/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#include <stdio.h>
#include <stdarg.h>
#include <Xm/Xm.h>
#include "xec.h"

/*-----------------------------------------------

	Change the title of a Label or Button

-------------------------------------------------*/

void xec_SetLabel(Widget w,const char *title)
{
	ARG_DEF(1);
	XmString	item = xec_NewString(title);

	SetArg(XmNlabelString,item);
	SetValues(w);
	XmStringFree(item);
}

void xec_VaSetLabel(Widget w,const char *fmt,...)
{
	va_list   args;
	char      str[1000];  /* DANGER: Fixed buffer size */
	va_start(args,fmt);
	vsprintf(str, fmt, args);
	xec_SetLabel(w,str);
	va_end(args);
}
