# Artist: Frank Zappa
# Album: Sheik Yerbouti
# Song: Bobby Brown

@head {
	$tempo 124
	$time_sig 4/4
	$title "Frank Zappa - Bobby Brown"
}

@body {

	# drums

	%define drum_main {
		/l8/c3 c /l4/r d c c c d r		
	}

	%define drum_verse {
		%repeat 8 {
			~drum_main
		}		
	}

	%define drum_chorus {
		%repeat 3 {
			~drum_main
		}
		/l1r2/r $volume 64 /l2r4/c+3 $volume 96
	}

	%define drum_end {
		%repeat 2 {
			%repeat 3 {
				~drum_main
			}
			/l1r2/r
		}
		%repeat 2 {
			~drum_main
			/l1r2/r
		}
	}

	@channel 10 "drums" {
		$reverb 32
		$volume 96
		$pan 96

		/l4r4/c+3

		$marker "Verse 1"      ~drum_verse
		$marker Chorus         ~drum_chorus
		$marker "Verse 2"      ~drum_verse
		$marker Chorus         ~drum_chorus
		$marker "Verse 3"      ~drum_verse
		$marker "Chorus & end" ~drum_end
	}

	# rhythm

	%define C {
		( c3 e3 g3 c4 )
	}

	%define Am {
		( e2 a2 e3 a3 c4 )
	}

	%define Dm {
		( d3 a3 d4 f4 )
	}

	%define Em {
		( e2 b2 e3 g3 b3 e4 )
	}

	%define F {
		( f2 c3 f3 a3 c4 f4 )
	}

	%define G {
		( g2 b2 d3 g3 d4 g4 )
	}

	@channel 1 "rhythm" {
		$patch 91
		$length 1
		$chorus 48

		/l1/r

		%repeat 2 {
			%repeat 2 {
				~C ~C ~Am ~Am ~Dm ~Dm ~G ~G
			}
			
			~F ~F ~Em ~Am ~Dm %repeat 5 { ~G }
		}
		%repeat 2 {
			~C ~C ~Am ~Am ~Dm ~Dm ~G ~G
		}
			
		~F ~F ~Em ~Am ~Dm %repeat 3 { ~G }

		~F ~F ~Em ~Am %repeat 3 { ~F %repeat 3 { ~G } }
	}

	# bass

	%define bass_verse {
		%repeat 2 {
			/l8/c2 c /l4r3/r /l1/c 
			/l8/a2 a /l4r3/r /l1/a 
			/l8/d2 d /l4r3/r /l1/d 
			/l8/g2 g /l4r3/r /l1/g 
		}		
	}

	%define bass_chorus {
		/l1r2/f2 e3 a2 d3 /r3/g2
		%repeat 4 { /l16/f+ /r2/g /r5/r }
	}

	%define bass_end {
		/l1r2/f2 e3 a2 d3 /r3/g2 
		/l1r2/f2 e3 a2 %repeat 3 { f2 %repeat 3 { g2 } }				
	}

	@channel 2 "bass" {
		$patch 34
		$volume 127

		/l1/r

		%repeat 2 {
			~bass_verse ~bass_chorus
		}
		~bass_verse ~bass_end
	}
}
