from typing import Any, Optional
from boto.compat import StandardError

class BotoClientError(StandardError):
    reason = ...  # type: Any
    def __init__(self, reason, *args) -> None: ...

class SDBPersistenceError(StandardError): ...
class StoragePermissionsError(BotoClientError): ...
class S3PermissionsError(StoragePermissionsError): ...
class GSPermissionsError(StoragePermissionsError): ...

class BotoServerError(StandardError):
    status = ...  # type: Any
    reason = ...  # type: Any
    body = ...  # type: Any
    request_id = ...  # type: Any
    error_code = ...  # type: Any
    message = ...  # type: str
    box_usage = ...  # type: Any
    def __init__(self, status, reason, body: Optional[Any] = ..., *args) -> None: ...
    def __getattr__(self, name): ...
    def __setattr__(self, name, value): ...
    def startElement(self, name, attrs, connection): ...
    def endElement(self, name, value, connection): ...

class ConsoleOutput:
    parent = ...  # type: Any
    instance_id = ...  # type: Any
    timestamp = ...  # type: Any
    comment = ...  # type: Any
    output = ...  # type: Any
    def __init__(self, parent: Optional[Any] = ...) -> None: ...
    def startElement(self, name, attrs, connection): ...
    def endElement(self, name, value, connection): ...

class StorageCreateError(BotoServerError):
    bucket = ...  # type: Any
    def __init__(self, status, reason, body: Optional[Any] = ...) -> None: ...
    def endElement(self, name, value, connection): ...

class S3CreateError(StorageCreateError): ...
class GSCreateError(StorageCreateError): ...
class StorageCopyError(BotoServerError): ...
class S3CopyError(StorageCopyError): ...
class GSCopyError(StorageCopyError): ...

class SQSError(BotoServerError):
    detail = ...  # type: Any
    type = ...  # type: Any
    def __init__(self, status, reason, body: Optional[Any] = ...) -> None: ...
    def startElement(self, name, attrs, connection): ...
    def endElement(self, name, value, connection): ...

class SQSDecodeError(BotoClientError):
    message = ...  # type: Any
    def __init__(self, reason, message) -> None: ...

class StorageResponseError(BotoServerError):
    resource = ...  # type: Any
    def __init__(self, status, reason, body: Optional[Any] = ...) -> None: ...
    def startElement(self, name, attrs, connection): ...
    def endElement(self, name, value, connection): ...

class S3ResponseError(StorageResponseError): ...
class GSResponseError(StorageResponseError): ...

class EC2ResponseError(BotoServerError):
    errors = ...  # type: Any
    def __init__(self, status, reason, body: Optional[Any] = ...) -> None: ...
    def startElement(self, name, attrs, connection): ...
    request_id = ...  # type: Any
    def endElement(self, name, value, connection): ...

class JSONResponseError(BotoServerError):
    status = ...  # type: Any
    reason = ...  # type: Any
    body = ...  # type: Any
    error_message = ...  # type: Any
    error_code = ...  # type: Any
    def __init__(self, status, reason, body: Optional[Any] = ..., *args) -> None: ...

class DynamoDBResponseError(JSONResponseError): ...
class SWFResponseError(JSONResponseError): ...
class EmrResponseError(BotoServerError): ...

class _EC2Error:
    connection = ...  # type: Any
    error_code = ...  # type: Any
    error_message = ...  # type: Any
    def __init__(self, connection: Optional[Any] = ...) -> None: ...
    def startElement(self, name, attrs, connection): ...
    def endElement(self, name, value, connection): ...

class SDBResponseError(BotoServerError): ...
class AWSConnectionError(BotoClientError): ...
class StorageDataError(BotoClientError): ...
class S3DataError(StorageDataError): ...
class GSDataError(StorageDataError): ...

class InvalidUriError(Exception):
    message = ...  # type: Any
    def __init__(self, message) -> None: ...

class InvalidAclError(Exception):
    message = ...  # type: Any
    def __init__(self, message) -> None: ...

class InvalidCorsError(Exception):
    message = ...  # type: Any
    def __init__(self, message) -> None: ...

class NoAuthHandlerFound(Exception): ...

class InvalidLifecycleConfigError(Exception):
    message = ...  # type: Any
    def __init__(self, message) -> None: ...

class ResumableTransferDisposition:
    START_OVER = ...  # type: str
    WAIT_BEFORE_RETRY = ...  # type: str
    ABORT_CUR_PROCESS = ...  # type: str
    ABORT = ...  # type: str

class ResumableUploadException(Exception):
    message = ...  # type: Any
    disposition = ...  # type: Any
    def __init__(self, message, disposition) -> None: ...

class ResumableDownloadException(Exception):
    message = ...  # type: Any
    disposition = ...  # type: Any
    def __init__(self, message, disposition) -> None: ...

class TooManyRecordsException(Exception):
    message = ...  # type: Any
    def __init__(self, message) -> None: ...

class PleaseRetryException(Exception):
    message = ...  # type: Any
    response = ...  # type: Any
    def __init__(self, message, response: Optional[Any] = ...) -> None: ...

class InvalidInstanceMetadataError(Exception):
    MSG = ...  # type: str
    def __init__(self, msg) -> None: ...
