/* ====================================================================
 * ===  Copyright (C) 1998-2007 Yutaka Sagiya. All rights reserved. ===
 * ====================================================================
 * 
 *    Project              : SagCAD
 *    Description          : CAD/CAM
 *    Source               : List_cam.h
 * 
 *    ----------------------------------
 * 
 *    License              : GNU General Public License (GPL)
 *    Copyright            : (C) 1998-2007 by Yutaka Sagiya
 *    email                : kappa@a6s.highway.ne.jp
 *                         : yutaka@sagiya.com
 *    Begin                : 2001/01/16
 *    Last                 : 2007/11/08
 * ====================================================================
 */
#ifndef __LIST_CAM_H__
#define __LIST_CAM_H__

//#include <>
#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include "types.h"

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */



/* -------------------------------------------------------
 * 1 : 前処理  (struct #define etc)
 * -------------------------------------------------------
 */



/* -------------------------------------------------------
 * 2 : 外部変数 (global)
 * -------------------------------------------------------
 */
#ifdef    _LIST_CAM_
#define   GLOBAL
// 初期値設定
#define   GLOBAL_VAL(v)  = (v)
#else
#define   GLOBAL	extern
// 初期値設定の代入部分を無くす
#define   GLOBAL_VAL(v)  /* */
#endif


	GLOBAL CAM_LIST *p_cam_list;
	GLOBAL CAM_LIST_INFO cam_list_info;


#undef  GLOBAL
#undef  GLOBAL_VAL
#undef  _LIST_CAM_



/* -------------------------------------------------------
 * 3 : 外部関数 (Function)
 * -------------------------------------------------------
 */
/* CAM Data をリストの最初に追加 */
CAM_LIST *cam_list_add_first(CAM *add_cam);
/* CAM Data をリストの最後に追加 */
CAM_LIST *cam_list_add_last(CAM *add_cam);

/* リストの総数を調べる */
long cam_list_num(void);
/* n 番目のデータの検索 */
CAM_LIST *cam_search_num(long search_number);
/* データの検索(CAM *p_cam から CAM_LIST を求める) */
CAM_LIST *cam_search_cam(CAM *p_cam);
/* データの検索(CAM *p_cam から Data No. の long 値を求める) */
long cam_search_cam_to_num(CAM *p_cam);

/* CAM Data をリストから削除 */
int cam_list_free(CAM_LIST *del_List);
/* 全リストを削除 */
void cam_list_all_free(void);

/* CAM_LIST のデータ log */
void cam_list_log(void);



#ifdef __cplusplus
}
#endif /* __cplusplus */
#endif /* __LIST_CAM_H__ */
/* ====================================================================
 * ===  Copyright (C) 1998-2007 Yutaka Sagiya. All rights reserved. ===
 * ====================================================================
 *    Project              : SagCAD
 *    Description          : CAD/CAM
 *    Source               : List_cam.h
 * ====================================================================
 */
