/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.lamp.fjbg;

import ch.epfl.lamp.fjbg.FJBGContext;
import ch.epfl.lamp.fjbg.JAttribute;
import ch.epfl.lamp.fjbg.JClass;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class JSourceFileAttribute
extends JAttribute {
    protected final String sourceFileName;
    protected final int sourceFileIndex;

    public JSourceFileAttribute(FJBGContext context, JClass clazz, String sourceFileName) {
        super(context, clazz);
        this.sourceFileName = sourceFileName;
        this.sourceFileIndex = clazz.getConstantPool().addUtf8(sourceFileName);
    }

    public JSourceFileAttribute(FJBGContext context, JClass clazz, Object owner, String name, int size, DataInputStream stream) throws IOException {
        super(context, clazz, name);
        this.sourceFileIndex = stream.readShort();
        this.sourceFileName = clazz.getConstantPool().lookupUtf8(this.sourceFileIndex);
        assert (name.equals(this.getName()));
    }

    public String getName() {
        return "SourceFile";
    }

    public String getFileName() {
        return this.sourceFileName;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer("  SourceFile: \"");
        buf.append(this.sourceFileName);
        buf.append("\"\n");
        return buf.toString();
    }

    protected int getSize() {
        return 2;
    }

    protected void writeContentsTo(DataOutputStream stream) throws IOException {
        stream.writeShort(this.sourceFileIndex);
    }
}

