#
# SchoolTool - common information systems platform for school administration
# Copyright (c) 2005 Shuttleworth Foundation
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.
#
"""
PDF Views
"""

from zope.browserpage.viewpagetemplatefile import ViewPageTemplateFile

from schooltool.app.browser.report import ReportPDFView
from schooltool.person.interfaces import IPerson

from schooltool.intervention import intervention
from schooltool.intervention import InterventionGettext as _


class InterventionStudentPDFView(ReportPDFView):
    """The intervention student (PDF) view class"""

    template=ViewPageTemplateFile('rml/intervention_student_rml.pt')

    def title(self):
        person = IPerson(self.context)
        return _('Student Interventions Report: ${student}',
                 mapping={'student': '%s %s' % (person.first_name,
                                                person.last_name)})

    @property
    def goals(self):
        goals = []
        for k, v in sorted(self.context['goals'].items()):
            goals.append({
                'goal': v.goal,
                'added': v.created.strftime('%x'),
                'due': v.timeline.strftime('%x'),
                'status': v.goal_met and _('CLOSED') or _('OPEN'),
                })
        return goals

    @property
    def messages(self):
        messages = []
        for k, v in sorted(self.context['messages'].items()):
            message = v.body
            if len(message) > 40:
                message = message[:100] + '...'
            messages.append({
                'creation_date': v.created,
                'from': ', '.join(intervention.contactsName(v.sender)),
                'sent': v.created.strftime('%x'),
                'message': message,
                })
        return sorted(messages, key=lambda m: m['creation_date'], reverse=True)

