/* Public domain. */

#include "bytestr.h"

#ifdef USE_BASE_LIBC

#include <string.h>

int byte_diff (register char const *s, register unsigned int n, register char const *t)
{
  return memcmp(s, t, n) ;
}

#else

int byte_diff (register char const *s, register unsigned int n, register char const *t)
{
  for (;;)
  {
    if (!n) return 0; if (*s != *t) break; ++s; ++t; --n;
    if (!n) return 0; if (*s != *t) break; ++s; ++t; --n;
    if (!n) return 0; if (*s != *t) break; ++s; ++t; --n;
    if (!n) return 0; if (*s != *t) break; ++s; ++t; --n;
  }
  return ((int)(unsigned int)(unsigned char) *s)
       - ((int)(unsigned int)(unsigned char) *t) ;
}

#endif
