/*
 * Copyright(c) 1997 by Jun-ichiro Itoh. All rights reserved.
 * Freely redistributable.  Absolutely no warranty.
 *
 * author contact: Jun-ichiro itojun Itoh <itojun@mt.cs.keio.ac.jp>
 * $Id: binlog.c,v 1.1.1.1 1998/02/23 14:18:30 itojun Exp $
 */
#include "common.h"

#if HAVE_SYS_IOCTL_H
# include <sys/ioctl.h>
#endif
#include <assert.h>

static int binlog_fd[2] = {-1, -1};
#define BINLOGBUFSIZ	16*1024
static char binlog_buf[2][BINLOGBUFSIZ];
static int binlog_idx[2];

static void binlog_put __P((int, char *, int));

/*
 * PUBLIC_ void binlog_flush __P((int));
 */
void
binlog_flush(line)
	int line;
{
	if (binlog_fd[line] < 0)
		return;
	write(binlog_fd[line], binlog_buf[line], binlog_idx[line]);
	binlog_idx[line] = 0;
}

static void
binlog_put(line, buf, len)
	int line;
	char *buf;
	int len;
{
	assert(len < sizeof(binlog_buf[line]));
	if (sizeof(binlog_buf[line]) < binlog_idx[line] + len)
		binlog_flush(line);

	memcpy(&binlog_buf[line][binlog_idx[line]], buf, len);
	binlog_idx[line] += len;
}

/*
 * PUBLIC: void binlog_end __P((int));
 */
void
binlog_end(line)
	int line;
{
	if (binlog_fd[line] < 0)
		return;

	binlog_flush(line);
	close(binlog_fd[line]);
	binlog_fd[line] = -1;
}

/*
 * PUBLIC: int binlog_init __P((int, char *));
 */
int
binlog_init(line, name)
	int line;
	char *name;
{
	if (0 <= binlog_fd[line])
		binlog_end(line);

	binlog_fd[line] = open(name, O_WRONLY|O_CREAT|O_APPEND, 0644);
	binlog_idx[line] = 0;
	return binlog_fd[line];
}

/*
 * PUBLIC: void binlog_write __P((int, char *, int));
 */
void
binlog_write(line, buf, len)
	int line;
	char *buf;
	int len;
{
	size_t i;
	size_t adv;
	char tbuf[10];

	if (binlog_fd[line] < 0)
		return;

	binlog_put(line, buf, len);
}
