# Standard Skriver Tool

A tool for managing users' default printer based on group membership and/or host address on the network.

## Introduction

The Standard Skriver Tool ('standardskriver' is Norwegian, i.e. Bokmål, for "default printer") helps you define
which printer is to be used for which device / IP / IP-range, user group, etc.

## Configuration

In `/etc/standardskriver.cfg` you are able to change the defined devices and their asigned default printers.

The syntax for doing this is simple and easy to manage via the configuration file `/etc/standardskriver.cfg`:

    [settings]
    
    # Define if standardskriver shall be active (it gets loaded via XDG autostart during
    # session startup:
    
    enable = {yes,no}
    
    # Define if groups section overrides machine section (= groups machine) or machine section
    # overrides groups section.
    
    order = {machine groups | groups machine}
    
    # Define if standardskriver shall remove the previous default printer, if no entry in the groups or
    # machine section matches at login time.
    
    delete lpoptions = {yes,no}
    
    [machine]
    
    # Example 01: single client (example-printer has to be defined as a known device/printer in CUPS):
    
    <xxx.xx.x.x> = example-printer
    
    # example: IP subnet (e.g. matching a pool of machines in one of the computer labs), again
    # other-example-printer needs to be a well-defined CUPS print queue.
    
    <xxx.xx.x.x/x> = other-example-printer
    
    # Example: Single client defined via MAC-address:
    
    aa:bb:cc:dd:ee:ff = example-printer
    
    [groups]
    
    # Here you can define a default printer for users based on POSIX group membership (teacher-printer
    # needs to be a well-defined CUPS print queue again):
    
    teachers = teacher-printer

## Using a Single Configuration for Multiple Sites

You can manage multiple sites (e.g. schools, customers, networks) in one
`standardskriver.cfg` file and deploy that configuration file across the
managed sites (very useful when deploying diskless workstation images to multiple
sites).

Each site needs to be given a unique name (e.g. `SCHOOL-01`, `SCHOOL-02`,
etc.). This site ID goes into an extra file:
`/etc/standardskriver.site`. This file is optional. The first line is
read from this file, gets sanitized and the outcome is the site ID.

In `/etc/standardskriver.cfg` you can then put sections like:

    [machine.SCHOOL-01]
    # special rules for SCHOOL-01
    10.1.2.3 = school-01-admin-printer

    [machine.SCHOOL-02]
    10.3.6.3 = school-02-admin-printer

    10.0.0.0/8 = main-printer

The same configuration scheme is possible for POSIX groups:

    [groups.SCHOOL-01]
    teachers = school-01-teacher-printer

    [groups.SCHOOL-02]
    teachers = school-02-teacher-printer

    [groups]
    students = students-printer

## Installation

### From Sources

This project contains a `Makefile` that sets up the Standard Skriver Tool on your system.

    $ make && sudo make install

### Python3 Dependencies

Make sure to have the Python3 module `netaddr` installed on your system.

### Install as a Package

The preferred installation method should rather be installation via your
distributions package manager, e.g. on Debian and derivatives:

    $ sudo apt-get install standardskriver

## License and Copyright

The Standard Skriver Tool is licensed under the GPL-2+ license.

Copyright holdership:

  * Copyright (C) 2013, Linnea Skogtvedt <linnea@linuxavdelingen.no>
  * Copyright (C) 2015-2017, Mike Gabriel <mike.gabriel@das-netzwerkteam.de>
