/* ------------------------------------------------------------------------- */
/*                                                                           */
/* [xml_base.h]             XML Base Library                                 */
/*                  - parsing, interpretation and transformation -           */
/*                                                                           */
/* Copyright (c) 2003 by D\olle, Manns.                                      */
/* ------------------------------------------------------------------------- */

/* File generated by 'ctoh'. Don't change manually. */

#ifndef xml_base_INCL
#define xml_base_INCL


#include "standard.h"
#include "symbols.h"
#include "hmap.h"
#include "hset.h"
#include "ptm.h"
#include "xml_dfn.h"


#ifdef __cplusplus
extern "C" {
#endif


/*  
   The module [xml_base] provides an reentrant interface for the parsing,
   interpretation and transformation of XML documents.
*/

/* -------------------------- Types and macros ------------------------------ */

AbstractType( XmlApp_T ) /* Abstract XML application type */
;

AbstractType( XmlCtx_T ) /* Abstract XML parser type */
;

/* ----------------------------- Init & Quit -------------------------------- */

XmlApp_T XML_app_init
         (
           XMLHDL_io_init           io_init,
           XMLHDL_io_cleanup        io_quit,
           XMLHDL_io_create_handle  io_create,
           XMLHDL_io_drop_handle    io_drop,
           XMLHDL_io_download       io_download
         )
/* init XML application;
   optional I/O handler:
   'io_init'     = init download module
   'io_quit'     = cleanup download module
   'io_create'   = create download handle
   'io_drop'     = drop download handle
   'io_download' = download URL to (string) stream
*/
;

void XML_app_quit(XmlApp_T xmlapp)
/* quit XML application; release resources */
;

XmlCtx_T XML_init
      (
        XmlApp_T xmlapp,
        void (*prMsg)(c_string msg), c_bool verbose, c_bool diagnose
      )
/* init XML parsing;
   'prMsg'    --> print function or NULL
   'verbose'  --> (de)activate progress information
   'diagnose' --> (de)activate diagnose information
*/
;

void XML_quit(XmlCtx_T xmlctx);  /* quit XML compilation; release resources */

/* ---------------------------- Set & Get ----------------------------------- */

void XML_set_verbose(XmlCtx_T xmlctx, c_bool verbose)
/* (de)activate progress information */
;

void XML_set_diagnose(XmlCtx_T xmlctx, c_bool diagnose)
/* (de)activate diagnose information */
;

void XML_set_context(XmlCtx_T xmlctx, Any_T extctx)
/* set external context information */
;

Any_T XML_get_context(XmlCtx_T xmlctx); /* get external context information */

void XML_get_trees(XmlCtx_T xmlctx, symbol* root, MAP(symbol,PT_Term)* trees)
/* get document trees */
;


/* ---------------------------- Parsing & Tree construction ----------------- */

int XML_load_file
    (
      XmlCtx_T xmlctx, c_string xmldoc, c_string cset, c_bool dtd, c_bool all
    )
/* parses XML/DTD definition in file 'xmldoc' and
   constructs the corresponding tree;
   'cset' = character set name ( UCS4, UTF-8, MS:CodePage / GNU:iconv-based )
   'dtd'  = True --> 'xmldoc' contains DTD definitions
   'all'  = True --> loads all referenced documents
   RC >  0: number of (syntax and semantic) errors
   RC = -1: tree construction failed
   RC =  0: successful load
*/
;

int XML_load_string
    (
      XmlCtx_T xmlctx, c_string xmldoc, unsigned int len,
      c_string cset, c_bool dtd, c_bool all
    )
/* parses XML definition in string 'xmldoc' and
   constructs the corresponding tree;
   'len'  = string size in bytes, inclusive terminating bytes
   'cset' = character set name ( UCS4, UTF-8, MS:CodePage / GNU:iconv-based )
   'dtd'  = True --> 'xmldoc' contains DTD definitions
   'all'  = True --> loads all referenced documents
   RC >  0: number of syntax and semantic errors
   RC = -1: tree construction failed
   RC =  0: successful load
*/
;

int XML_load_url
    (
      XmlCtx_T xmlctx, c_string xmldoc,
      c_string cset, c_string auth, c_bool dtd, c_bool all
    )
/* parses XML definition identified by URL 'xmldoc' and
   constructs the corresponding tree;
   'cset' = character set name ( UCS4, UTF-8, MS:CodePage / GNU:iconv-based )
   'auth' = optional user authentification ( format: user:passwd )
   'dtd'  = True --> 'xmldoc' contains DTD definitions
   'all'  = True --> loads all referenced documents
   RC >  0: number of syntax and semantic errors
   RC = -1: tree construction failed
   RC =  0: successful load
   assertion: valid I/O handler
*/
;



#ifdef __cplusplus
}
#endif

#endif
