/* ====================================================================
 * Copyright (c) 2007,      Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _SC_SETTNGS_H
#define _SC_SETTNGS_H

// sc
class ConfigManager;
class LayoutSettings;

/**
 * This class provides access to the different configuration types. Typical use
 * is to construct a @c Settings object in a widget constructor to read settings
 * and in the destructor to store the settings.
 */
class Settings
{
public:
  Settings();

  /** return access object to layout settings */
  LayoutSettings& layout();

  /** initialize the class, set up the @c ConfigManager. */
  static void setup( ConfigManager& cm );

private:
  static ConfigManager* _config;
};

#endif // _SC_SETTNGS_H
