#include <SyFi.h>
#include <fstream>

using namespace GiNaC; 
using namespace SyFi; 
using namespace std; 

int main() {

    initSyFi(3); 

    ex p0 = lst(0.0,0.0,1.0);
    ex p1 = lst(1.0,0.0,1.0);
    ex p2 = lst(0.0,1.0,1.0);

    Triangle triangle(p0,p1,p2);

    ex repr = triangle.repr();
    cout <<"t.repr "<<repr<<endl; 

    ex f = x*y*z;
    ex intf = triangle.integrate(f); 
    cout <<"intf "<<intf<<endl; 


    // regression test

    archive ar; 
    ar.archive_ex(intf, "intf"); 
    ar.archive_ex(repr, "repr"); 

    ofstream vfile("triangle_ex1.gar.v"); 
    vfile << ar; vfile.close(); 
    if(!compare_archives("triangle_ex1.gar.v", "triangle_ex1.gar.r")) { 
	    cerr << "Failure!" << endl;
	    return -1;
    }

    return 0; 
}

