#!/usr/bin/env python

# This file is part of Window-Switch.
# Copyright (c) 2009-2013 Antoine Martin <antoine@nagafix.co.uk>
# Window-Switch is released under the terms of the GNU GPL v3

from winswitch.util.simple_logger import Logger
from winswitch.util.crypt_util import make_key_fingerprint, generate_key, recreate_key, encrypt, encrypt_hex, encrypt_salted_hex, sign, sign_long, verify, verify_long, decrypt, decrypt_hex, decrypt_salted_hex, hex_str, unhex_str

N=22390734664856734253034198166817170227886325020821509599531082121154967161416804894317982595830336136258466074511639085603850426045655616504468759363447238760949118644343347978641820120757005385295079633352313964267858064685490468738307301955743770785408508150004444279672286870442423047789056071789270676221086301285256583559309701338314112339463520388540789804505951113695812494595751539080675928456957432818395557598948229302771534914958786714813081884157987919776235447852894196816185984446104251613747162107239956556937136376795026540434484630591599019792141210655971861366813668614618934486215845446273941770043
E=65537
D=8118294049259589534470583286386462592963285703415791249279911704272156639601845032558461669623578242363453787365084882617737977382194314042131721927983174198356240859772138405305200569288004668589982486957255968673159334926173375622314999299210880592686222601895198208242258275713762553390657954710417776345550400617990024159848415155604584287426250989709042791070557223055047016740280342153580446340780967193761306311886065942129645433497364403962545360006203298798431644838834253741776886767901757119888547800783009589758767543519527784722888146740638046716762584809572080828280643650818219688861669349533522202881
MESSAGE = "test"
SALT = "salt"
FINGERPRINT="0617662be7246ca27fb60e8bb77b08c3176b48d8"
ENCRYPT_SALTED_HEX="29ccd2d42419e4dd58eef58023afae077cc47df9e118e7ff0efc9238589eba0ece0a59d0efb162c93da69c476ea22ec6e5ccf8094d8327b7c474dfd3d8d8644ba843d6f5e30bd3b6a56131e8370acebbddd9297170fd6186adae9c552089ba0982911d810acb54885ab14b66094952472c4929c6c07cb0c40227351b236d6289850aae8748cc33c0806c810012ce2db1a0ce62ca66259ae0c68c2d636cc9fcd4867723c7de9f3761fce5879ecc49c84571a570c39ff82c30f2443583e598d42700c39155f6bcf9e155188c25703a0336d6dcfaf23f0b1c2efe9a1140abd7a64524ea36cd0aba0f26ccff6395dcf9538d3931215c69e74563fb299f7c3a8225c3"
SIGN_LONG=3616843447740126252102191696866228616680791021016350186594538379669307340955394173694242525168109778152520628097940853769083738421859841412116531366794120411779742712458674943632932491943412832036426803974839683764133868465265918803121188779312299647896500803361722970252509319061407712718865611965563938638224479139947483371472282755611534991703625735933861733375737131384999635491029465360119129136706011891864474752902678377987862820880898669808486061019137287839411841542075925541924828922695806985548434492848417542506027954921358644345187366408862861438603211258654403978474064140141615559068903744886882743418


class CryptUtilTest:
	def __init__(self):
		Logger(self, log_colour=Logger.RED, _debug=True)
		self.n=N
		self.e=E
		self.d=D
		self.test_key = recreate_key(self.n, self.e, self.d)
		#recreate_key(test_key.n, test_key.e, test_key.d)
		self.test_message = MESSAGE
		self.test_salt = SALT
		self.fingerprint = FINGERPRINT
		self.encrypt_salted_hex = ENCRYPT_SALTED_HEX
		self.sign_long = SIGN_LONG

	def test_generate_key(self):
		key = generate_key()
		self.sdebug("n=%s" % key.n)
		self.sdebug("e=%s" % key.e)
		self.sdebug("d=%s" % key.d)
		
	
	def test_make_key_fingerprint(self):
		modulus = N
		exp = E
		key_fingerprint = make_key_fingerprint(modulus, exp)
		self.sdebug("=%s" % key_fingerprint)
		assert key_fingerprint==self.fingerprint
		return	key_fingerprint
	
	def test_recreate_key(self):
		#crypto_modulus, crypto_public_exponent, crypto_private_exponent=0):
		re = recreate_key(self.test_key.n, self.test_key.e, self.test_key.d)
		self.sdebug("=%s" % re)
		assert re
		assert re.n == self.test_key.n
		assert re.e == self.test_key.e
		assert re.d == self.test_key.d
		return	re
	
	def test_encrypt(self):
		enc = encrypt(self.test_key, self.test_message)
		assert enc
		self.sdebug("=%s" % enc)
		return	enc
	
	def	test_encrypt_hex(self):
		enc = encrypt_hex(self.test_key, self.test_message)
		assert enc
		self.sdebug("encrypt_hex(%s,%s)=%s" % (self.test_key, self.test_message, enc))
		return	enc
	
	def test_encrypt_salted_hex(self):
		enc = encrypt_salted_hex(self.test_key, self.test_salt, self.test_message)
		assert enc
		self.sdebug("=%s" % enc)
		assert enc==self.encrypt_salted_hex
		return	enc
	
	def test_sign(self):
		sig = sign(self.test_key, self.test_message)
		assert sig
		self.sdebug("=%s" % sig)
		return	sig
	
	def	test_sign_long(self):
		sig = sign_long(self.test_key, self.test_message)
		assert sig
		assert str(sig)==str(self.sign_long)
		return	sig
	
	def test_verify(self):
		sig = self.test_sign()
		v = verify(self.test_key, self.test_message, sig)
		self.sdebug("=%s" % v)
		assert v
	
	def	test_verify_long(self):
		sig = self.test_sign_long()
		v = verify_long(self.test_key, self.test_message, sig)
		self.sdebug("=%s" % v)
		assert v
	
	def test_decrypt(self):
		enc = self.test_encrypt()
		dec = decrypt(self.test_key, enc)
		self.sdebug("=%s" % dec)
		assert dec
		assert dec==self.test_message
	
	def test_decrypt_hex(self):
		enc = self.test_encrypt_hex()
		dec = decrypt_hex(self.test_key, enc)
		self.sdebug("=%s" % dec)
		assert dec
		assert dec==self.test_message
	
	def test_decrypt_salted_hex(self):
		enc = self.test_encrypt_salted_hex()
		dec = decrypt_salted_hex(self.test_key, self.test_salt, enc)
		self.sdebug("=%s" % dec)
		assert dec
		assert dec==self.test_message
	
	def test_hex_str(self):
		hex = hex_str((self.test_message,))
		self.sdebug("=%s" % hex)
		assert hex == "74657374"
		return	hex
	
	def test_unhex_str(self):
		hex =  self.test_hex_str()
		msg = unhex_str(hex)
		self.sdebug("=%s" % str(msg))
		assert msg == (self.test_message,)
		#assert msg == self.test_message
	
	
	def all(self):
		self.test_generate_key()
		self.log()
		self.test_make_key_fingerprint();
		self.log()
		self.test_recreate_key()
		self.log()
		self.test_encrypt()
		self.log()
		self.test_encrypt_hex()
		self.log()
		self.test_encrypt_salted_hex()
		self.log()
		self.test_sign()
		self.log()
		self.test_sign_long()
		self.log()
		self.test_verify()
		self.log()
		self.test_verify_long()
		self.log()
		self.test_decrypt()
		self.log()
		self.test_decrypt_hex()
		self.log()
		self.test_decrypt_salted_hex()
		self.log()
		self.test_hex_str()
		self.log()
		self.test_unhex_str()

if __name__ == "__main__":
	c = CryptUtilTest()
	c.all()
