/*
 *========================================================================
 * $Id: time.c 88 2004-09-28 22:49:38Z rgb $
 *
 * See copyright in copyright.h and the accompanying file COPYING
 *========================================================================
 */

#include <wulfware/libwulf.h>

/*
 * <time> tag init and update (same thing)
 */
void init_time(Host *hostptr)
{

 /* 
  * scratch: current timestamp and delta (to microsecond resolution) 
  */
 unsigned long seconds,useconds;

 if((verbose == D_ALL) || (verbose == D_VALUES)){
   fprintf(OUTFP,"D_VALUES: Starting init_times().  Use -v %d to focus.\n",D_VALUES);
 }

 /* 
  * time - tv_sec and tv_usec timestamps.
  */
 /* <time tv_sec=?> */
 if(xtract_attribute(UNSIGNED_LONG,&seconds,value_xpath[TIME],
                      "tv_sec",hostptr->xp_doc) > 1){
   fprintf(OUTFP,"fill_values() Warning: %s not unique content tag.\n",
         value_xpath[TIME]);
 }
 if((verbose == D_ALL) || (verbose == D_VALUES)){
   fprintf(OUTFP,"D_VALUES: seconds = %d\n",seconds);
 }
 hostptr->val.time_tv_sec = seconds;

 /* <time tv_usec=?> */
 if(xtract_attribute(UNSIGNED_LONG,&useconds,value_xpath[TIME],
                      "tv_usec",hostptr->xp_doc) > 1){
   fprintf(OUTFP,"fill_values() Warning: %s not unique content tag.\n",
         value_xpath[TIME]);
 }
 if((verbose == D_ALL) || (verbose == D_VALUES)){
   fprintf(OUTFP,"D_VALUES: useconds = %d\n",useconds);
 }
 hostptr->val.time_tv_usec = useconds;
 if((verbose == D_ALL) || (verbose == D_VALUES)){
   fprintf(OUTFP,"D_VALUES: time_tv_sec = %ul time_tv_usec = %ul\n",hostptr->val.time_tv_sec,hostptr->val.time_tv_usec);
 }

 /*
  * node local time as a string
  */
 if(xtract(STRING,hostptr->val.time,value_xpath[TIME],hostptr->xp_doc) > 1){
   fprintf(OUTFP,"fill_values() Warning: %s not unique content tag.\n",value_xpath[TIME]);
 }
 if((verbose == D_ALL) || (verbose == D_VALUES)){
   fprintf(OUTFP,"D_VALUES: Time = %s\n",hostptr->val.time);
 }

}

void update_time(Host *hostptr)
{

 /* 
  * scratch: current timestamp and delta (to microsecond resolution) 
  */
 unsigned long seconds,useconds;

 if((verbose == D_ALL) || (verbose == D_VALUES)){
   fprintf(OUTFP,"D_VALUES: Starting init_times().  Use -v %d to focus.\n",D_VALUES);
 }

 /* 
  * time - tv_sec and tv_usec timestamps.
  */
 /* <time tv_sec=?> */
 if(xtract_attribute(UNSIGNED_LONG,&seconds,value_xpath[TIME],
                      "tv_sec",hostptr->xp_doc) > 1){
   fprintf(OUTFP,"fill_values() Warning: %s not unique content tag.\n",
         value_xpath[TIME]);
 }
 if((verbose == D_ALL) || (verbose == D_VALUES)){
   fprintf(OUTFP,"D_VALUES: seconds = %d\n",seconds);
 }
 hostptr->val.time_tv_sec = seconds;

 /* <time tv_usec=?> */
 if(xtract_attribute(UNSIGNED_LONG,&useconds,value_xpath[TIME],
                      "tv_usec",hostptr->xp_doc) > 1){
   fprintf(OUTFP,"fill_values() Warning: %s not unique content tag.\n",
         value_xpath[TIME]);
 }
 if((verbose == D_ALL) || (verbose == D_VALUES)){
   fprintf(OUTFP,"D_VALUES: useconds = %d\n",useconds);
 }
 hostptr->val.time_tv_usec = useconds;
 if((verbose == D_ALL) || (verbose == D_VALUES)){
   fprintf(OUTFP,"D_VALUES: time_tv_sec = %ul time_tv_usec = %ul\n",hostptr->val.time_tv_sec,hostptr->val.time_tv_usec);
 }

 /*
  * node local time as a string
  */
 if(xtract(STRING,hostptr->val.time,value_xpath[TIME],hostptr->xp_doc) > 1){
   fprintf(OUTFP,"fill_values() Warning: %s not unique content tag.\n",value_xpath[TIME]);
 }
 if((verbose == D_ALL) || (verbose == D_VALUES)){
   fprintf(OUTFP,"D_VALUES: Time = %s\n",hostptr->val.time);
 }

}


