# redir.y.tst: yash-specific test of redirections
# vim: set ft=sh ts=8 sts=4 sw=4 noet:

temp="${TESTTMP}/redir.y.tmp"

echo ===== unclosed here-documents =====

$INVOKE $TESTEE -c 'echo 1; cat <<END'
$INVOKE $TESTEE -c 'echo 2; cat <<END
'
$INVOKE $TESTEE -c 'echo 3; cat <<END
a'
$INVOKE $TESTEE -c 'echo 4; cat <<END
b
'
$INVOKE $TESTEE -c 'echo 5; cat <<END
c
END'
$INVOKE $TESTEE -c 'echo 6; cat <<END
c
END
echo ok'


echo ===== pipe redirection =====

exec 3>&- 4>&- 5>&- 6>&-
exec 4>>|3; echo 4-3 >&4; exec 4>&-; cat <&3; exec 3<&-
exec 4>>|6; echo 4-6 >&4; exec 4>&-; cat <&6; exec 6<&-
exec 5>>|3; echo 5-3 >&5; exec 5>&-; cat <&3; exec 3<&-
exec 5>>|6; echo 5-6 >&5; exec 5>&-; cat <&6; exec 6<&-
exec 5>>|4; echo 5-4 >&5; exec 5>&-; cat <&4; exec 4<&-
exec 3>>|6; echo 3-6 >&3; exec 3>&-; cat <&6; exec 6<&-
exec 3>>|4; echo 3-4 >&3; exec 3>&-; cat <&4; exec 4<&-

(while read i; do if [ $i -lt 5 ]; then echo $((i+1)); else exit; fi done |
{ echo 0; tee "$temp"; }) >>|0
cat "$temp"

rm -f "$temp"


echo ===== command redirection =====

cat <(echo 1)
cat <(echo 2)-
echo >(cat) 3 | cat

seq () {
    i=1
    while [ "$i" -le "$1" ]; do
	echo "$i"
	i=$((i+1))
    done
    unset i
}

seq 4 >(cat) | grep 4
grep 5 <(seq 5)
! $INVOKE $TESTEE -c '< (:)' 2>(cat>/dev/null)
echo $?


echo ===== here-string =====

var=foo
cat <<<""
cat <<<123
cat <<< "$var"
cat <<< "-
-"
