/*  
	Copyright (C) 2006 Salvatore Scarciglia <laas.mono@gmail.com>
	http://laas.altervista.org

    This code is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License version 2 as published by the Free Software Foundation.

    This code is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.

*/



using System;
using Gtk;
using Gdk;
using Glade;

public class yTToolWin {

	// Language selection Widgets
	[Widget] Gtk.Window		toolWindow;
	[Widget] Gtk.Window		parentWindow;
	[Widget] Gtk.Button		cmdOk;
	[Widget] Gtk.Button		cmdCancel;
	[Widget] Gtk.Image		imgLogo;
	[Widget] Gtk.RadioButton		radioProvider1;
	[Widget] Gtk.RadioButton		radioProvider2;
	[Widget] Gtk.RadioButton		radioProvider3;
	[Widget] Gtk.RadioButton		radioProvider4;	
	[Widget] Gtk.RadioButton		radioProvider5;	
	[Widget] Gtk.CheckButton		chkStartIco;
	[Widget] Gtk.CheckButton		chkAllDesk;
	//private yTService		currentService;
	private yTUserProfile	currentProfile;
	private yTProvider		currentProvider;
	private int				selectedProvider;
	public	bool			startInSystray;
	public	bool			showInAllWorkspace;

	
	public yTToolWin(Gtk.Window owner,yTUserProfile usp, yTService cs,yTProvider cp){
		Glade.XML gxml = new Glade.XML (null, "yt.glade", "toolWindow", null);
		gxml.Autoconnect (this);
		parentWindow = owner;
		currentProfile = usp;
		//currentService = cs;
		currentProvider = cp;
		startInSystray = currentProfile.startMode;
		showInAllWorkspace = currentProfile.allWorkspace;
		setupGui();
		setupRadioProvider(currentProvider.ID);
		setupStartupMode();
		setupVisibility();
	}	
	
	private void setupStartupMode(){
		if(startInSystray==true) 
			chkStartIco.Active = true;
		else
			chkStartIco.Active = false;
	}
	
	private void setupVisibility(){
		if(showInAllWorkspace==true) 
			chkAllDesk.Active = true;
		else
			chkAllDesk.Active = false;
	}
	

	private void setupRadioProvider(int prov){
		switch(prov){
			case 1:
				radioProvider1.Active = true;
				break;
			case 2:
				radioProvider2.Active = true;
				break;
			case 3:
				radioProvider3.Active = true;
				break;
			case 4:
				radioProvider4.Active = true;
				break;			
			case 5:
				radioProvider5.Active = true;
				break;	
		}
	}

	private void setupGui(){
		toolWindow.Icon = new Gdk.Pixbuf(null,"yTicon.png");
		toolWindow.TransientFor = parentWindow;
		toolWindow.SetPosition(Gtk.WindowPosition.CenterOnParent);
		toolWindow.Modal = true;
		toolWindow.ShowAll();
		cmdOk.Clicked+=buttonHandler;
		cmdCancel.Clicked+=buttonHandler;
		radioProvider1.Clicked+=radioHandler;
		radioProvider2.Clicked+=radioHandler;
		radioProvider3.Clicked+=radioHandler;
		radioProvider4.Clicked+=radioHandler;
		radioProvider5.Clicked+=radioHandler;
		chkStartIco.Toggled+=checkHandler;
		chkAllDesk.Toggled+=checkHandler;
		imgLogo.FromPixbuf = new Gdk.Pixbuf(null,"yTLogo.png");
	}	

	
	private void  checkHandler(object o, EventArgs args){
		CheckButton b = (CheckButton) o;
		if(b==chkStartIco){
			startInSystray = chkStartIco.Active;
		}
		else if(b==chkAllDesk){
			showInAllWorkspace = chkAllDesk.Active;
		}
	}
	
	private void  radioHandler(object o, EventArgs args){
		RadioButton b = (RadioButton) o;
		if(b==radioProvider1) selectedProvider=1;
		else if(b==radioProvider2) selectedProvider=2;
		else if(b==radioProvider3)selectedProvider=3;
		else if(b==radioProvider4)selectedProvider=4;
		else if(b==radioProvider5)selectedProvider=5;
	}	

	
	private void  buttonHandler(object o, EventArgs args){
		Button b = (Button) o;
		if(b==cmdOk) {
			currentProvider.changeProvider(selectedProvider);
			currentProfile.ProviderID = selectedProvider;
			currentProfile.startMode = startInSystray;
			currentProfile.allWorkspace = showInAllWorkspace;
		}
		toolWindow.Destroy();
	}	
	
	
}