# F:=Rationals();
local result, l;
result:= rec();
result.comment:=
"2\"A5 as 8 x 8 matrices over Z.\n\
Irreducible over Q, becomes 4 + 4 over C.\n\
Schur Index 2 (for the irreducible constituents).\n\
\n\
SEED:\n\
Undefined.\n\
v [= e1] has 2 x 20 = 40 images under G; <v> has 20 images under G.\n\
BASIS:\n\
v, v.x, v.y, v.x*y, v.y^2, v.x*y^2, v.x^3*y*x*y^2*x, v.y*x*y^2*x.\n\
\n\
Possible matrix entries for any element of the group:\n\
The 3 elements of {-1,0,1} only.\n\
\n\
Average number of nonzero entries for any element of the group:\n\
32 (50% exactly).\n\
\n\
Entry    Av/Mat  %Av/Mat\n\
 0        32      50\n\
 1        16      25\n\
-1        16      25\n\
nonzero   32      50\n\
";
result.symmetricforms:= [];
result.antisymmetricforms:= [];
result.hermitianforms:= [];
result.centralizeralgebra:= [];
result.generators:= List( [ [
0,1,0,0,0,0,0,0,
-1,0,0,0,0,0,0,0,
-1,0,0,1,-1,1,-1,-1,
0,-1,-1,0,-1,-1,1,-1,
1,0,-1,1,-1,-1,0,-1,
0,1,-1,-1,1,-1,1,0,
-1,0,-1,-1,0,-1,1,-1,
0,-1,1,-1,1,0,1,1]
,[
0,0,1,0,0,0,0,0,
0,0,0,1,0,0,0,0,
0,0,0,0,1,0,0,0,
0,0,0,0,0,1,0,0,
1,0,0,0,0,0,0,0,
0,1,0,0,0,0,0,0,
0,0,0,0,0,0,1,0,
0,0,0,0,0,0,0,1]
], l -> List( [ 0 .. 7 ],
i -> l{ [ i*8+1 .. (i+1)*8 ] } ) );




l:= [
2,0,0,-1,0,1,0,-1,
0,2,1,0,-1,0,1,0,
0,1,2,0,0,-1,0,-1,
-1,0,0,2,1,0,1,0,
0,-1,0,1,2,0,0,-1,
1,0,-1,0,0,2,1,0,
0,1,0,1,0,1,2,0,
-1,0,-1,0,-1,0,0,2];
Add( result.symmetricforms, List( [ 0 .. 7 ],
i -> l{ [ i*8+1 .. (i+1)*8 ] } ) );

l:= [
0,1,0,0,0,0,0,0,
-1,0,0,1,0,-1,0,1,
0,0,0,1,0,0,0,0,
0,-1,-1,0,0,1,0,1,
0,0,0,0,0,1,0,0,
0,1,0,-1,-1,0,0,1,
0,0,0,0,0,0,0,1,
0,-1,0,-1,0,-1,-1,0];
Add( result.antisymmetricforms, List( [ 0 .. 7 ],
i -> l{ [ i*8+1 .. (i+1)*8 ] } ) );

l:= [
0,0,1,0,-1,0,1,0,
0,0,0,-1,0,1,0,-1,
-1,0,0,0,1,0,1,0,
0,1,0,0,0,-1,0,-1,
1,0,-1,0,0,0,1,0,
0,-1,0,1,0,0,0,-1,
-1,0,-1,0,-1,0,0,0,
0,1,0,1,0,1,0,0];
Add( result.antisymmetricforms, List( [ 0 .. 7 ],
i -> l{ [ i*8+1 .. (i+1)*8 ] } ) );

l:= [
0,0,0,1,0,-1,0,1,
0,0,1,0,-1,0,1,0,
0,-1,0,0,0,1,0,1,
-1,0,0,0,1,0,1,0,
0,1,0,-1,0,0,0,1,
1,0,-1,0,0,0,1,0,
0,-1,0,-1,0,-1,0,0,
-1,0,-1,0,-1,0,0,0];
Add( result.antisymmetricforms, List( [ 0 .. 7 ],
i -> l{ [ i*8+1 .. (i+1)*8 ] } ) );

l:= [
1,0,0,0,0,0,0,0,
0,1,0,0,0,0,0,0,
0,0,1,0,0,0,0,0,
0,0,0,1,0,0,0,0,
0,0,0,0,1,0,0,0,
0,0,0,0,0,1,0,0,
0,0,0,0,0,0,1,0,
0,0,0,0,0,0,0,1];
Add( result.centralizeralgebra, List( [ 0 .. 7 ],
i -> l{ [ i*8+1 .. (i+1)*8 ] } ) );

l:= [
0,1,0,0,0,0,0,0,
-1,0,0,0,0,0,0,0,
0,0,0,1,0,0,0,0,
0,0,-1,0,0,0,0,0,
0,0,0,0,0,1,0,0,
0,0,0,0,-1,0,0,0,
0,0,0,0,0,0,0,1,
0,0,0,0,0,0,-1,0];
Add( result.centralizeralgebra, List( [ 0 .. 7 ],
i -> l{ [ i*8+1 .. (i+1)*8 ] } ) );

l:= [
0,3,-2,0,2,0,-2,0,
3,0,0,2,0,-2,0,2,
2,0,0,3,-2,0,-2,0,
0,-2,3,0,0,2,0,2,
-2,0,2,0,0,3,-2,0,
0,2,0,-2,3,0,0,2,
2,0,2,0,2,0,0,3,
0,-2,0,-2,0,-2,3,0];
Add( result.centralizeralgebra, List( [ 0 .. 7 ],
i -> l{ [ i*8+1 .. (i+1)*8 ] } ) );

l:= [
3,0,0,2,0,-2,0,2,
0,-3,2,0,-2,0,2,0,
0,-2,3,0,0,2,0,2,
-2,0,0,-3,2,0,2,0,
0,2,0,-2,3,0,0,2,
2,0,-2,0,0,-3,2,0,
0,-2,0,-2,0,-2,3,0,
-2,0,-2,0,-2,0,0,-3];
Add( result.centralizeralgebra, List( [ 0 .. 7 ],
i -> l{ [ i*8+1 .. (i+1)*8 ] } ) );

return result;
