
#ifndef LIBKDCRAW_EXPORT_H
#define LIBKDCRAW_EXPORT_H

#ifdef LIBKDCRAW_STATIC_DEFINE
#  define LIBKDCRAW_EXPORT
#  define LIBKDCRAW_NO_EXPORT
#else
#  ifndef LIBKDCRAW_EXPORT
#    ifdef KDcraw_EXPORTS
        /* We are building this library */
#      define LIBKDCRAW_EXPORT __attribute__((visibility("default")))
#    else
        /* We are using this library */
#      define LIBKDCRAW_EXPORT __attribute__((visibility("default")))
#    endif
#  endif

#  ifndef LIBKDCRAW_NO_EXPORT
#    define LIBKDCRAW_NO_EXPORT __attribute__((visibility("hidden")))
#  endif
#endif

#ifndef LIBKDCRAW_DECL_DEPRECATED
#  define LIBKDCRAW_DECL_DEPRECATED __attribute__ ((__deprecated__))
#endif

#ifndef LIBKDCRAW_DECL_DEPRECATED_EXPORT
#  define LIBKDCRAW_DECL_DEPRECATED_EXPORT LIBKDCRAW_EXPORT LIBKDCRAW_DECL_DEPRECATED
#endif

#ifndef LIBKDCRAW_DECL_DEPRECATED_NO_EXPORT
#  define LIBKDCRAW_DECL_DEPRECATED_NO_EXPORT LIBKDCRAW_NO_EXPORT LIBKDCRAW_DECL_DEPRECATED
#endif

#if 0 /* DEFINE_NO_DEPRECATED */
#  ifndef LIBKDCRAW_NO_DEPRECATED
#    define LIBKDCRAW_NO_DEPRECATED
#  endif
#endif

#define LIBKDCRAW_DECL_DEPRECATED_TEXT(text) __attribute__ ((__deprecated__(text)))

#if defined(LIBKDCRAW_NO_DEPRECATED)
#  undef LIBKDCRAW_DEPRECATED
#  define LIBKDCRAW_DEPRECATED_EXPORT LIBKDCRAW_EXPORT
#  define LIBKDCRAW_DEPRECATED_NO_EXPORT LIBKDCRAW_NO_EXPORT
#elif defined(LIBKDCRAW_NO_DEPRECATED_WARNINGS)
#  define LIBKDCRAW_DEPRECATED
#  define LIBKDCRAW_DEPRECATED_EXPORT LIBKDCRAW_EXPORT
#  define LIBKDCRAW_DEPRECATED_NO_EXPORT LIBKDCRAW_NO_EXPORT
#else
#  define LIBKDCRAW_DEPRECATED LIBKDCRAW_DECL_DEPRECATED
#  define LIBKDCRAW_DEPRECATED_EXPORT LIBKDCRAW_DECL_DEPRECATED_EXPORT
#  define LIBKDCRAW_DEPRECATED_NO_EXPORT LIBKDCRAW_DECL_DEPRECATED_NO_EXPORT
#endif

/* No deprecated API had been removed from build */
#define LIBKDCRAW_EXCLUDE_DEPRECATED_BEFORE_AND_AT 0

#define LIBKDCRAW_BUILD_DEPRECATED_SINCE(major, minor) 1

#ifdef LIBKDCRAW_NO_DEPRECATED
#  define LIBKDCRAW_DISABLE_DEPRECATED_BEFORE_AND_AT 0x50000
#endif
#ifdef LIBKDCRAW_NO_DEPRECATED_WARNINGS
#  define LIBKDCRAW_DEPRECATED_WARNINGS_SINCE 0
#endif

#ifndef LIBKDCRAW_DEPRECATED_WARNINGS_SINCE
#  ifdef LIBKDCRAW_DISABLE_DEPRECATED_BEFORE_AND_AT
#    define LIBKDCRAW_DEPRECATED_WARNINGS_SINCE LIBKDCRAW_DISABLE_DEPRECATED_BEFORE_AND_AT
#  else
#    define LIBKDCRAW_DEPRECATED_WARNINGS_SINCE 0x50000
#  endif
#endif

#ifndef LIBKDCRAW_DISABLE_DEPRECATED_BEFORE_AND_AT
#  define LIBKDCRAW_DISABLE_DEPRECATED_BEFORE_AND_AT 0
#endif

#ifdef LIBKDCRAW_DEPRECATED
#  define LIBKDCRAW_ENABLE_DEPRECATED_SINCE(major, minor) (((major<<16)|(minor<<8)) > LIBKDCRAW_DISABLE_DEPRECATED_BEFORE_AND_AT)
#else
#  define LIBKDCRAW_ENABLE_DEPRECATED_SINCE(major, minor) 0
#endif

#endif /* LIBKDCRAW_EXPORT_H */
