!{\src2tex{textfont=tt}}
!!****f* ABINIT/ctrap
!! NAME 
!! ctrap
!!
!! FUNCTION
!! Do corrected trapezoidal integral on uniform grid of spacing hh
!!
!! COPYRIGHT
!! Copyright (C) 1998-2005 ABINIT group (DCA, XG, FrD)
!! This file is distributed under the terms of the 
!! GNU General Public License, see ~ABINIT/Infos/copyright
!! or http://www.gnu.org/copyleft/gpl.txt .
!! For the initials of contributors, see ~ABINIT/Infos/contributors .
!!
!! INPUTS
!!  imax=highest index of grid=grid point number of upper limit
!!  ff(imax)=integrand values
!!  hh=spacing between x points
!!
!! OUTPUT
!!  ans=resulting integral by corrected trapezoid
!!
!! NOTES
!!  Note: must have imax>9 for end point corrections to work.
!!
!! PARENTS

!!!
!!      calc_dij0,calc_kij,calc_qijl,calc_shapef,calc_vhnzc,calc_vhtnzc,exchcor_atom
!!
!! CHILDREN
!!
!! SOURCE

 subroutine ctrap(imax,ff,hh,ans)
    
 use defs_basis

 implicit none

!Arguments ------------------------------------
 integer :: imax
 real(dp) :: hh,ans
 real(dp) :: ff(imax)

!Local variables-------------------------------
 integer :: ir,ir2
 real(dp) :: endpt,sum

! *************************************************************************

! endpt=end point correction terms (low and high ends)
 if (imax.lt.10) then
  endpt=zero
  if (imax>=2) then
   do ir=2,imax
    endpt=endpt+(ff(ir)+ff(ir-1))/2.d0
   enddo
  endif
 else
  endpt  = (23.75d0*(ff(1)+ff(imax  )) &
&         + 95.10d0*(ff(2)+ff(imax-1)) &
&         + 55.20d0*(ff(3)+ff(imax-2)) &
&         + 79.30d0*(ff(4)+ff(imax-3)) &
&         + 70.65d0*(ff(5)+ff(imax-4)))/ 72.d0
 endif

 ir2 = imax - 5
 sum=zero
 if (ir2 > 5) then
  do ir=6,ir2
   sum = sum + ff(ir)
  enddo 
 end if
 ans = (sum + endpt ) * hh

 end subroutine
!!***
