!{\src2tex{textfont=tt}}
!!****f* ABINIT/pawprt
!! NAME
!! pawprt
!!
!! FUNCTION
!! Print out data concerning PAW formalism
!! (pseudopotential strenght, augmentation occupancies...)
!! To be called at the end of the SCF cycle
!!
!! COPYRIGHT
!! Copyright (C) 1998-2007 ABINIT group (FJ, MT)
!! This file is distributed under the terms of the
!! GNU General Public License, see ~abinit/COPYING
!! or http://www.gnu.org/copyleft/gpl.txt .
!! For the initials of contributors, see ~abinit/doc/developers/contributors.txt.
!!
!! INPUTS
!!  indlmn(6,i,ntypat)=array giving l,m,n,lm,ln,spin for i=lmn
!!  enunit=parameter determining units of output energies
!!  lmnmax=if useylm=1, max number of (l,m,n) comp. over all types of psps
!!  natom=number of atoms in cell
!!  ntypat = number of atom types
!!  paw_ij(natom) <type(paw_ij_type)>=paw arrays given on (i,j) channels
!!  pawrhoij(natom) <type(pawrhoij_type)>= paw rhoij occupancies and related data
!!  pawtab(ntypat*usepaw) <type(pawtab_type)>=paw tabulated starting data
!!  typat(natom)=type of each atom
!!
!! OUTPUT
!!  (only printing)
!!
!! PARENTS
!!      outscfcv
!!
!! CHILDREN
!!      print_ij,wrtout
!!
!! SOURCE

#if defined HAVE_CONFIG_H
#include "config.h"
#endif

subroutine pawprt(indlmn,enunit,lmnmax,natom,ntypat,paw_ij,pawrhoij,pawtab,typat)

 use defs_basis
 use defs_datatypes

!This section has been created automatically by the script Abilint (TD). Do not modify these by hand.
#ifdef HAVE_FORTRAN_INTERFACES
 use interfaces_01manage_mpi
 use interfaces_11util
#endif
!End of the abilint section

 implicit none

!Arguments ------------------------------------
!scalars
 integer,intent(in) :: enunit,lmnmax,natom,ntypat
!arrays
 integer,intent(in) :: indlmn(6,lmnmax,ntypat),typat(natom)
 type(pawrhoij_type),intent(in) :: pawrhoij(natom)
 type(pawtab_type),intent(in) :: pawtab(ntypat)
 type(paw_ij_type),intent(in) :: paw_ij(natom)

!Local variables-------------------------------
!scalars
 integer :: iatom,im1,im2,ispden,itypat,lmn2size1,lmn2sizen,lmnsize1,lmnsizen
 integer :: unt
 logical :: antiferro,usepawu
 character(len=500) :: message
!arrays
 integer :: idum(1)

! *********************************************************************

 lmnsize1 =paw_ij(1)%lmn_size
 lmnsizen =paw_ij(natom)%lmn_size
 lmn2size1=paw_ij(1)%lmn2_size
 lmn2sizen=paw_ij(natom)%lmn2_size
 antiferro=(paw_ij(1)%nspden==2.and.paw_ij(1)%nsppol==1)
 usepawu=(count(pawtab(:)%usepawu>0)>0)

 write(message, '(2a)' ) ch10,&
&   ' ==== Results concerning PAW augmentation regions ===='
 call wrtout(ab_out,message,'COLL');call wrtout(6,message,'COLL')

!Print out pseudopotential strength
!----------------------------------
 message=' ';call wrtout(ab_out,message,'COLL');call wrtout(6,message,'COLL')
 do unt=1,2
  if ((unt==1).and.(enunit==0.or.enunit==2)) then
   write(message, '(a)' ) &
&   ' Total pseudopotential strength Dij (hartree):'
   call wrtout(ab_out,message,'COLL');call wrtout(6,message,'COLL')
  else if ((unt==2).and.(enunit==1.or.enunit==2)) then
   write(message, '(a)' ) &
&   ' Total pseudopotential strength Dij (eV):'
   call wrtout(ab_out,message,'COLL');call wrtout(6,message,'COLL')
  end if
  if (((unt==1).and.(enunit==0.or.enunit==2)).or.&
&     ((unt==2).and.(enunit==1.or.enunit==2))) then
   message=''
   if (natom>1) write(message, '(a)' ) ' Atom #  1'
   if (paw_ij(1)%nspden>1) &
&    write(message, '(2a)' ) trim(message),' - Spin component 1'
   if (natom>1.or.paw_ij(1)%nspden>1) then
    call wrtout(ab_out,message,'COLL');call wrtout(6,message,'COLL')
   end if
   call print_ij(paw_ij(1)%dij(:,1),lmn2size1,lmnsize1,2,-1,idum,0,idum,100.d0,unt)
   if (paw_ij(1)%nspden>1) then
    message=''
    if (natom>1) write(message, '(a)' ) ' Atom #  1'
    write(message, '(2a)' ) trim(message),' - Spin component 2'
    call wrtout(ab_out,message,'COLL');call wrtout(6,message,'COLL')
    call print_ij(paw_ij(1)%dij(:,2),lmn2size1,lmnsize1,2,-1,idum,0,idum,-1.d0,unt)
   end if
   if (natom>1) then
    write(message, '(a,i3)' ) ' Atom #',natom
    if (paw_ij(natom)%nspden>1) &
&      write(message, '(a,a)' ) trim(message),' - Spin component 1'
    call wrtout(ab_out,message,'COLL');call wrtout(6,message,'COLL')
    call print_ij(paw_ij(natom)%dij(:,1),lmn2sizen,lmnsizen,2,-1,idum,0,idum,100.d0,unt)
    if (paw_ij(natom)%nspden>1) then
     write(message, '(a,i3,a)' ) ' Atom #',natom,' - Spin component 2'
     call wrtout(ab_out,message,'COLL');call wrtout(6,message,'COLL')
     call print_ij(paw_ij(natom)%dij(:,2),lmn2sizen,lmnsizen,2,-1,idum,0,idum,-1.d0,unt)
    end if
   end if
  end if
  message=' ';call wrtout(ab_out,message,'COLL');call wrtout(6,message,'COLL')
 end do

!Print out SYMMETRIZED occupancies of the partial waves
!------------------------------------------------------

 write(message, '(a)' ) &
&   ' Augmentation waves occupancies Rhoij:'
 call wrtout(ab_out,message,'COLL');call wrtout(6,message,'COLL')
 message=''
 if (natom>1) write(message, '(a)' ) ' Atom #  1'
 if (pawrhoij(1)%nspden>1) &
&  write(message, '(2a)' ) trim(message),' - Spin component 1'
 if (natom>1.or.pawrhoij(1)%nspden>1) then
  call wrtout(ab_out,message,'COLL');call wrtout(6,message,'COLL')
 end if
 call print_ij(pawrhoij(1)%rhoijp(:,1),pawrhoij(1)%nrhoijsel(1),&
&     lmnsize1,2,-1,idum,1,pawrhoij(1)%rhoijselect(:,1),25.d0,1)
 if (pawrhoij(1)%nspden>1) then
  message=''
  if (natom>1) write(message, '(a)' ) ' Atom #  1'
  write(message, '(2a)' ) trim(message),' - Spin component 2'
  call wrtout(ab_out,message,'COLL');call wrtout(6,message,'COLL')
  call print_ij(pawrhoij(1)%rhoijp(:,2),pawrhoij(1)%nrhoijsel(2),&
&      lmnsize1,2,-1,idum,1,pawrhoij(1)%rhoijselect(:,2),-1.d0,1)
 end if
 if (natom>1) then
  write(message, '(a,i3)' ) ' Atom #',natom
  if (pawrhoij(natom)%nspden>1) &
&   write(message, '(a,a)' ) trim(message),' - Spin component 1'
  call wrtout(ab_out,message,'COLL');call wrtout(6,message,'COLL')
  call print_ij(pawrhoij(natom)%rhoijp(:,1),pawrhoij(natom)%nrhoijsel(1),&
&      lmnsizen,2,-1,idum,1,pawrhoij(natom)%rhoijselect(:,1),25.d0,1)
  if (pawrhoij(natom)%nspden>1) then
   write(message, '(a,i3,a)' ) ' Atom #',natom,' - Spin component 2'
   call wrtout(ab_out,message,'COLL');call wrtout(6,message,'COLL')
   call print_ij(pawrhoij(natom)%rhoijp(:,2),pawrhoij(natom)%nrhoijsel(2),&
&       lmnsizen,2,-1,idum,1,pawrhoij(natom)%rhoijselect(:,2),-1.d0,1)
  end if
 end if
 message=' ';call wrtout(ab_out,message,'COLL');call wrtout(6,message,'COLL')

!PAW+U: print out +U components of occupancies
!------------------------------------------------------
 if (usepawu) then
  write(message, '(a)' ) &
&    ' "PAW+U" part of augmentation waves occupancies Rhoij:'
  call wrtout(ab_out,message,'COLL');call wrtout(6,message,'COLL')
  message=''
  do iatom=1,natom
   itypat=typat(iatom)
   if (pawtab(itypat)%lpawu>=0) then
    write(message, '(a,i3,a,i1,a)') ' Atom #',iatom,' - L=',pawtab(itypat)%lpawu,' ONLY'
    if (pawrhoij(1)%nspden>1) write(message, '(2a)' ) trim(message),' - Spin component 1'
    call wrtout(ab_out,message,'COLL');call wrtout(6,message,'COLL')
    call print_ij(pawrhoij(iatom)%rhoijp(:,1),pawrhoij(iatom)%nrhoijsel(1),&
&        pawrhoij(iatom)%lmn_size,2,pawtab(itypat)%lpawu,indlmn(1,1:pawtab(itypat)%lmn_size,itypat),&
&        1,pawrhoij(iatom)%rhoijselect(:,1),-1.d0,1)
    if (pawrhoij(1)%nspden>1) then
     write(message, '(a,i3,a,i1,a)') ' Atom #',iatom,' - L=',pawtab(itypat)%lpawu,&
&                                    ' ONLY - Spin component 2'
     call wrtout(ab_out,message,'COLL');call wrtout(6,message,'COLL')
     call print_ij(pawrhoij(iatom)%rhoijp(:,2),pawrhoij(iatom)%nrhoijsel(2),&
&         pawrhoij(iatom)%lmn_size,2,pawtab(itypat)%lpawu,indlmn(1,1:pawtab(itypat)%lmn_size,itypat),&
&         1,pawrhoij(iatom)%rhoijselect(:,2),-1.d0,1)
    end if
   end if
  end do

  write(message, '(a)' )' '
  call wrtout(06,  message,'COLL')
  call wrtout(ab_out,  message,'COLL')
  write(message, '(a)' )'---------- LDA+U DATA --------------------------------------------------- '
  call wrtout(06,  message,'COLL')
  call wrtout(ab_out,  message,'COLL')
  write(message, '(a)' )' '
  call wrtout(06,  message,'COLL')
  call wrtout(ab_out,  message,'COLL')

  do iatom=1,natom
   itypat=typat(iatom)
   if (pawtab(itypat)%lpawu>=0) then
    write(message,fmt=9) "====== For Atom", iatom,", occupations for correlated orbitals. lpawu ="&
&    ,pawtab(itypat)%lpawu
    call wrtout(06,message,'COLL')
    call wrtout(ab_out,  message,'COLL')
    write(message, '(a)' )' '
    call wrtout(06,  message,'COLL')
    call wrtout(ab_out,  message,'COLL')
9   format(a,i5,a,i4)
    do ispden=1,paw_ij(iatom)%nspden
     write(message,fmt=10) "Atom", iatom,". Occ. for lpawu and for spin",&
&     ispden," =",paw_ij(iatom)%nocctot(ispden)
     call wrtout(06,message,'COLL')
     call wrtout(ab_out,  message,'COLL')
10  format(a,i4,a,i3,a,f10.5)
    end do
    if(paw_ij(iatom)%nspden==2) then
     write(message,fmt=11) "=> On atom",iatom,",  local Mag. for lpawu is  ",&
&    paw_ij(iatom)%nocctot(2)-paw_ij(iatom)%nocctot(1)
     call wrtout(6,message,'COLL')
     call wrtout(ab_out,  message,'COLL')
    end if
11  format(a,i4,a,2x,e15.8)
    write(message, '(a)' )' '
    call wrtout(06,  message,'COLL')
    call wrtout(ab_out,  message,'COLL')
    write(message,'(a)') "== Occupation matrix for correlated orbitals:"
    call wrtout(6,message,'COLL')
    call wrtout(ab_out,  message,'COLL')
    write(message, '(a)' )' '
    call wrtout(06,  message,'COLL')
    call wrtout(ab_out,  message,'COLL')
    do ispden=1,paw_ij(iatom)%nspden
     write(message,fmt=12) "Occupation matrix for spin",ispden
12   format(a,i3)
     call wrtout(6,message,'COLL')
     call wrtout(ab_out,  message,'COLL')
     do im1=1,pawtab(itypat)%lpawu*2+1
       write(message,fmt=13) (paw_ij(iatom)%noccmmp(im1,im2,ispden)&
&       ,im2=1,pawtab(itypat)%lpawu*2+1)
       call wrtout(6,message,'COLL')
       call wrtout(ab_out,  message,'COLL')
     end do
     write(message, '(a)' )' '
     call wrtout(06,  message,'COLL')
     call wrtout(ab_out,  message,'COLL')
     write(message, '(a)' )' '
     call wrtout(06,  message,'COLL')
     call wrtout(ab_out,  message,'COLL')
13   format(12(1x,9(1x,f10.5)))
    end do
   endif
  enddo
 end if
 message=' ';call wrtout(ab_out,message,'COLL');call wrtout(6,message,'COLL')

end subroutine pawprt

!!***
