#!/usr/bin/python
# -*- coding: utf-8 -*-
# Copyright 2020 Dell Inc. or its subsidiaries. All Rights Reserved
# GNU General Public License v3.0+
# (see COPYING or https://www.gnu.org/licenses/gpl-3.0.txt)

#############################################
#                WARNING                    #
#############################################
#
# This file is auto generated by the resource
#   module builder playbook.
#
# Do not edit this file manually.
#
# Changes to this file will be over written
#   by the resource module builder.
#
# Changes should be made in the model used to
#   generate this file or in the resource module
#   builder template.
#
#############################################

"""
The module file for sonic_mclag
"""

from __future__ import absolute_import, division, print_function
__metaclass__ = type

DOCUMENTATION = """
---
module: sonic_mclag
version_added: 1.0.0
notes:
  - Tested against Enterprise SONiC Distribution by Dell Technologies.
  - Supports C(check_mode).
short_description: Manage multi chassis link aggregation groups domain (MCLAG) and its parameters
description:
  - Manage multi chassis link aggregation groups domain (MCLAG) and its parameters.
author: Abirami N (@abirami-n)

options:
  config:
    description: Dict of mclag domain configurations.
    type: dict
    suboptions:
      domain_id:
        description:
          - ID of the mclag domain (MCLAG domain).
        type: int
        required: True
      peer_address:
        description:
          - The IPV4 peer-ip for corresponding MCLAG.
        type: str
      source_address:
        description:
          - The IPV4 source-ip for corresponding MCLAG.
        type: str
      peer_link:
        description:
          - Peer-link for corresponding MCLAG.
        type: str
      system_mac:
        description:
          - MAC address of MCLAG.
        type: str
      keepalive:
        description:
          - MCLAG session keepalive-interval in secs.
        type: int
      session_timeout:
        description:
          - MCLAG session timeout value in secs.
        type: int
      delay_restore:
        description:
          - MCLAG delay restore time in secs.
        type: int
      gateway_mac:
        description:
          - Gateway MAC address for router ports over MCLAG.
          - Configured gateway MAC address can be modified only when I(state=replaced) or I(state=overridden).
        type: str
      unique_ip:
        description: Holds Vlan dictionary for MCLAG unique IP.
        suboptions:
          vlans:
            description:
              - Holds a list of VLANs and VLAN ranges for which a separate IP address is enabled for Layer 3 protocol support over MCLAG.
            type: list
            elements: dict
            suboptions:
              vlan:
                description:
                  - Holds a VLAN name or VLAN range.
                  - Specify a single VLAN eg. Vlan10.
                  - Specify a range of VLANs eg. Vlan10-20.
                type: str
        type: dict
      peer_gateway:
        description: Holds Vlan dictionary for MCLAG peer gateway.
        suboptions:
          vlans:
            description:
              - Holds a list of VLANs and VLAN ranges for which MCLAG peer gateway functionality is enabled.
            type: list
            elements: dict
            suboptions:
              vlan:
                description:
                  - Holds a VLAN name or VLAN range.
                  - Specify a single VLAN eg. Vlan10.
                  - Specify a range of VLANs eg. Vlan10-20.
                type: str
        type: dict
      members:
        description: Holds portchannels dictionary for an MCLAG domain.
        suboptions:
          portchannels:
            description:
              - Holds a list of portchannels for configuring as an MCLAG interface.
            type: list
            elements: dict
            suboptions:
              lag:
                description: Holds a PortChannel ID.
                type: str
        type: dict
  state:
    description:
      - The state that the configuration should be left in.
    type: str
    choices:
      - merged
      - deleted
      - replaced
      - overridden
    default: merged
"""
EXAMPLES = """
# Using merged
#
# Before state:
# -------------
#
# sonic# show mclag brief
# MCLAG Not Configured

- name: Merge provided configuration with device configuration
  dellemc.enterprise_sonic.sonic_mclag:
    config:
      domain_id: 1
      peer_address: 1.1.1.1
      source_address: 2.2.2.2
      peer_link: 'Portchannel1'
      keepalive: 1
      session_timeout: 3
      delay_restore: 240
      system_mac: '00:00:00:11:11:11'
      gateway_mac: '00:00:00:12:12:12'
      unique_ip:
        vlans:
          - vlan: Vlan4
          - vlan: Vlan21-25
      peer_gateway:
        vlans:
          - vlan: Vlan4
          - vlan: Vlan21-25
      members:
        portchannels:
          - lag: PortChannel10
    state: merged

# After state:
# ------------
#
# sonic# show mclag brief
#
# Domain ID            : 1
# Role                 : standby
# Session Status       : down
# Peer Link Status     : down
# Source Address       : 2.2.2.2
# Peer Address         : 1.1.1.1
# Peer Link            : PortChannel1
# Keepalive Interval   : 1 secs
# Session Timeout      : 3 secs
# Delay Restore        : 240 secs
# System Mac           : 20:04:0f:37:bd:c9
# Mclag System Mac     : 00:00:00:11:11:11
# Gateway Mac          : 00:00:00:12:12:12
#
#
# Number of MLAG Interfaces:1
#-----------------------------------------------------------
# MLAG Interface       Local/Remote Status
#-----------------------------------------------------------
# PortChannel10            down/down
#
# sonic# show mclag separate-ip-interfaces
# Interface Name
# ==============
# Vlan4
# Vlan21
# Vlan22
# Vlan23
# Vlan24
# Vlan25
# ==============
# Total count :    6
# ==============
# sonic#
# sonic# show mclag peer-gateway-interfaces
# Interface Name
# ==============
# Vlan4
# Vlan21
# Vlan22
# Vlan23
# Vlan24
# Vlan25
# ==============
# Total count :    6
# ==============
# sonic#


# Using merged
#
# Before state:
# ------------
#
# sonic# show mclag brief
#
# Domain ID            : 1
# Role                 : standby
# Session Status       : down
# Peer Link Status     : down
# Source Address       : 2.2.2.2
# Peer Address         : 1.1.1.1
# Peer Link            : PortChannel1
# Keepalive Interval   : 1 secs
# Session Timeout      : 3 secs
# Delay Restore        : 240 secs
# System Mac           : 20:04:0f:37:bd:c9
# Mclag System Mac     : 00:00:00:11:11:11
# Gateway Mac          : 00:00:00:12:12:12
#
#
# Number of MLAG Interfaces:1
#-----------------------------------------------------------
# MLAG Interface       Local/Remote Status
#-----------------------------------------------------------
# PortChannel10            down/down
#
# sonic# show mclag separate-ip-interfaces
# Interface Name
# ==============
# Vlan4
# Vlan21
# Vlan22
# Vlan23
# Vlan24
# Vlan25
# ==============
# Total count :    6
# ==============
# sonic#
# sonic# show mclag peer-gateway-interfaces
# Interface Name
# ==============
# Vlan4
# Vlan21
# Vlan22
# Vlan23
# Vlan24
# Vlan25
# ==============
# Total count :    6
# ==============
# sonic#

- name: Merge device configuration with the provided configuration
  dellemc.enterprise_sonic.sonic_mclag:
    config:
      domain_id: 1
      source_address: 3.3.3.3
      keepalive: 10
      session_timeout: 30
      delay_restore: 360
      unique_ip:
        vlans:
          - vlan: Vlan5
          - vlan: Vlan26-28
      peer_gateway:
        vlans:
          - vlan: Vlan5
          - vlan: Vlan26-28
      members:
        portchannels:
          - lag: PortChannel12
    state: merged

# After state:
# ------------
#
# sonic# show mclag brief
#
# Domain ID            : 1
# Role                 : standby
# Session Status       : down
# Peer Link Status     : down
# Source Address       : 3.3.3.3
# Peer Address         : 1.1.1.1
# Peer Link            : PortChannel1
# Keepalive Interval   : 10 secs
# Session Timeout      : 30 secs
# Delay Restore        : 360 secs
# System Mac           : 20:04:0f:37:bd:c9
# Mclag System Mac     : 00:00:00:11:11:11
# Gateway Mac          : 00:00:00:12:12:12
#
#
# Number of MLAG Interfaces:2
#-----------------------------------------------------------
# MLAG Interface       Local/Remote Status
#-----------------------------------------------------------
# PortChannel10            down/down
# PortChannel12            down/down
#
# sonic# show mclag separate-ip-interfaces
# Interface Name
# ==============
# Vlan4
# Vlan5
# Vlan21
# Vlan22
# Vlan23
# Vlan24
# Vlan25
# Vlan26
# Vlan27
# Vlan28
# ==============
# Total count :   10
# ==============
# sonic# show mclag peer-gateway-interfaces
# Interface Name
# ==============
# Vlan4
# Vlan5
# Vlan21
# Vlan22
# Vlan23
# Vlan24
# Vlan25
# Vlan26
# Vlan27
# Vlan28
# ==============
# Total count :   10
# ==============
# sonic#


# Using deleted
#
# Before state:
# ------------
#
# sonic# show mclag brief
#
# Domain ID            : 1
# Role                 : standby
# Session Status       : down
# Peer Link Status     : down
# Source Address       : 3.3.3.3
# Peer Address         : 1.1.1.1
# Peer Link            : PortChannel1
# Keepalive Interval   : 10 secs
# Session Timeout      : 30 secs
# Delay Restore        : 360 secs
# System Mac           : 20:04:0f:37:bd:c9
# Mclag System Mac     : 00:00:00:11:11:11
# Gateway Mac          : 00:00:00:12:12:12
#
#
# Number of MLAG Interfaces:1
#-----------------------------------------------------------
# MLAG Interface       Local/Remote Status
#-----------------------------------------------------------
# PortChannel10            down/down
#
# sonic# show mclag separate-ip-interfaces
# Interface Name
# ==============
# Vlan4
# Vlan21
# Vlan22
# Vlan23
# Vlan24
# Vlan25
# ==============
# Total count :    6
# ==============
# sonic#
# sonic# show mclag peer-gateway-interfaces
# Interface Name
# ==============
# Vlan4
# Vlan21
# Vlan22
# Vlan23
# Vlan24
# Vlan25
# ==============
# Total count :    6
# ==============
# sonic#

- name: Delete device configuration based on the provided configuration
  dellemc.enterprise_sonic.sonic_mclag:
    config:
      domain_id: 1
      source_address: 3.3.3.3
      keepalive: 10
      unique_ip:
        vlans:
          - vlan: Vlan22
          - vlan: Vlan24-25
      peer_gateway:
        vlans:
          - vlan: Vlan22
          - vlan: Vlan24-25
      members:
        portchannels:
          - lag: PortChannel10
    state: deleted

# After state:
# ------------
#
# sonic# show mclag brief
#
# Domain ID            : 1
# Role                 : standby
# Session Status       : down
# Peer Link Status     : down
# Source Address       :
# Peer Address         : 1.1.1.1
# Peer Link            : PortChannel1
# Keepalive Interval   : 1 secs
# Session Timeout      : 30 secs
# Delay Restore        : 360 secs
# System Mac           : 20:04:0f:37:bd:c9
# Mclag System Mac     : 00:00:00:11:11:11
# Gateway Mac          : 00:00:00:12:12:12
#
#
# Number of MLAG Interfaces:0
#
# sonic# show mclag separate-ip-interfaces
# Interface Name
# ==============
# Vlan4
# Vlan21
# Vlan23
# ==============
# Total count :    3
# ==============
# sonic#
# sonic# show mclag peer-gateway-interfaces
# Interface Name
# ==============
# Vlan4
# Vlan21
# Vlan23
# ==============
# Total count :    3
# ==============
# sonic#


# Using deleted
#
# Before state:
# ------------
#
# sonic# show mclag brief
#
# Domain ID            : 1
# Role                 : standby
# Session Status       : down
# Peer Link Status     : down
# Source Address       : 3.3.3.3
# Peer Address         : 1.1.1.1
# Peer Link            : PortChannel1
# Keepalive Interval   : 10 secs
# Session Timeout      : 30 secs
# Delay Restore        : 360 secs
# System Mac           : 20:04:0f:37:bd:c9
# Mclag System Mac     : 00:00:00:11:11:11
# Gateway Mac          : 00:00:00:12:12:12
#
#
# Number of MLAG Interfaces:1
#-----------------------------------------------------------
# MLAG Interface       Local/Remote Status
#-----------------------------------------------------------
# PortChannel10            down/down
#
# sonic# show mclag separate-ip-interfaces
# Interface Name
# ==============
# Vlan4
# ==============
# Total count :    1
# ==============
# sonic#
# sonic# show mclag peer-gateway-interfaces
# Interface Name
# ==============
# Vlan4
# ==============
# Total count :    1
# ==============
# sonic#

- name: Delete all device configuration
  dellemc.enterprise_sonic.sonic_mclag:
    config:
    state: deleted

# After state:
# ------------
#
# sonic# show mclag brief
# MCLAG Not Configured
# sonic# show mclag separate-ip-interfaces
# MCLAG separate IP interface not configured
# sonic# show mclag peer-gateway-interfaces
# MCLAG Peer Gateway interface not configured
# sonic#


# Using deleted
#
# Before state:
# ------------
#
# sonic# show mclag brief
#
# Domain ID            : 1
# Role                 : standby
# Session Status       : down
# Peer Link Status     : down
# Source Address       : 3.3.3.3
# Peer Address         : 1.1.1.1
# Peer Link            : PortChannel1
# Keepalive Interval   : 10 secs
# Session Timeout      : 30 secs
# Delay Restore        : 360 secs
# System Mac           : 20:04:0f:37:bd:c9
# Mclag System Mac     : 00:00:00:11:11:11
# Gateway Mac          : 00:00:00:12:12:12
#
#
# Number of MLAG Interfaces:2
#-----------------------------------------------------------
# MLAG Interface       Local/Remote Status
#-----------------------------------------------------------
# PortChannel10            down/down
# PortChannel12            down/down
#
# sonic# show mclag separate-ip-interfaces
# Interface Name
# ==============
# Vlan4
# ==============
# Total count :    1
# ==============
# sonic#
# sonic# show mclag peer-gateway-interfaces
# Interface Name
# ==============
# Vlan4
# ==============
# Total count :    1
# ==============
# sonic#

- name: Delete device configuration based on the provided configuration
  dellemc.enterprise_sonic.sonic_mclag:
    config:
      domain_id: 1
      source_address: 3.3.3.3
      keepalive: 10
      peer_gateway:
        vlans:
      members:
        portchannels:
    state: deleted

# After state:
# ------------
#
# sonic# show mclag brief
#
# Domain ID            : 1
# Role                 : standby
# Session Status       : down
# Peer Link Status     : down
# Source Address       :
# Peer Address         : 1.1.1.1
# Peer Link            : PortChannel1
# Keepalive Interval   : 1 secs
# Session Timeout      : 30 secs
# Delay Restore        : 360 secs
# System Mac           : 20:04:0f:37:bd:c9
# Mclag System Mac     : 00:00:00:11:11:11
# Gateway Mac          : 00:00:00:12:12:12
#
#
# Number of MLAG Interfaces:0
#
# sonic# show mclag separate-ip-interfaces
# Interface Name
# ==============
# Vlan4
# ==============
# Total count :    1
# ==============
# sonic#
# sonic# show mclag peer-gateway-interfaces
# MCLAG Peer Gateway interface not configured
# sonic#


# Using replaced
#
# Before state:
# ------------
#
# sonic# show mclag brief
#
# Domain ID            : 1
# Role                 : standby
# Session Status       : down
# Peer Link Status     : down
# Source Address       : 2.2.2.2
# Peer Address         : 1.1.1.1
# Peer Link            : PortChannel1
# Keepalive Interval   : 1 secs
# Session Timeout      : 3 secs
# Delay Restore        : 240 secs
# System Mac           : 20:04:0f:37:bd:c9
# Mclag System Mac     : 00:00:00:11:11:11
# Gateway Mac          : 00:00:00:12:12:12
#
#
# Number of MLAG Interfaces:2
#-----------------------------------------------------------
# MLAG Interface       Local/Remote Status
#-----------------------------------------------------------
# PortChannel10            down/down
# PortChannel11            down/down
#
# sonic# show mclag separate-ip-interfaces
# Interface Name
# ==============
# Vlan4
# Vlan21
# Vlan22
# Vlan23
# Vlan24
# Vlan25
# ==============
# Total count :    6
# ==============
# sonic#
# sonic# show mclag peer-gateway-interfaces
# Interface Name
# ==============
# Vlan4
# Vlan21
# Vlan22
# Vlan23
# Vlan24
# Vlan25
# ==============
# Total count :    6
# ==============
# sonic#

- name: Replace device configuration with the provided configuration
  dellemc.enterprise_sonic.sonic_mclag:
    config:
      domain_id: 1
      unique_ip:
        vlans:
          - vlan: Vlan5
          - vlan: Vlan24-28
      peer_gateway:
        vlans:
          - vlan: Vlan5
          - vlan: Vlan24-28
      members:
        portchannels:
          - lag: PortChannel10
          - lag: PortChannel12
    state: replaced

# After state:
# ------------
#
# sonic# show mclag brief
#
# Domain ID            : 1
# Role                 : standby
# Session Status       : down
# Peer Link Status     : down
# Source Address       : 2.2.2.2
# Peer Address         : 1.1.1.1
# Peer Link            : PortChannel1
# Keepalive Interval   : 1 secs
# Session Timeout      : 3 secs
# Delay Restore        : 240 secs
# System Mac           : 20:04:0f:37:bd:c9
# Mclag System Mac     : 00:00:00:11:11:11
# Gateway Mac          : 00:00:00:12:12:12
#
#
# Number of MLAG Interfaces:2
#-----------------------------------------------------------
# MLAG Interface       Local/Remote Status
#-----------------------------------------------------------
# PortChannel10            down/down
# PortChannel12            down/down
#
# sonic# show mclag separate-ip-interfaces
# Interface Name
# ==============
# Vlan5
# Vlan24
# Vlan25
# Vlan26
# Vlan27
# Vlan28
# ==============
# Total count :   6
# ==============
# sonic# show mclag peer-gateway-interfaces
# Interface Name
# ==============
# Vlan5
# Vlan24
# Vlan25
# Vlan26
# Vlan27
# Vlan28
# ==============
# Total count :   6
# ==============
# sonic#


# Using overridden
#
# Before state:
# ------------
#
# sonic# show mclag brief
#
# Domain ID            : 1
# Role                 : standby
# Session Status       : down
# Peer Link Status     : down
# Source Address       : 2.2.2.2
# Peer Address         : 1.1.1.1
# Peer Link            : PortChannel1
# Keepalive Interval   : 1 secs
# Session Timeout      : 3 secs
# Delay Restore        : 240 secs
# System Mac           : 20:04:0f:37:bd:c9
# Mclag System Mac     : 00:00:00:11:11:11
# Gateway Mac          : 00:00:00:12:12:12
#
#
# Number of MLAG Interfaces:2
#-----------------------------------------------------------
# MLAG Interface       Local/Remote Status
#-----------------------------------------------------------
# PortChannel10            down/down
# PortChannel11            down/down
#
# sonic# show mclag separate-ip-interfaces
# Interface Name
# ==============
# Vlan4
# Vlan21
# Vlan22
# Vlan23
# Vlan24
# Vlan25
# ==============
# Total count :    6
# ==============
# sonic#
# sonic# show mclag peer-gateway-interfaces
# Interface Name
# ==============
# Vlan4
# Vlan21
# Vlan22
# Vlan23
# Vlan24
# Vlan25
# ==============
# Total count :    6
# ==============
# sonic#

- name: Override device configuration with the provided configuration
  dellemc.enterprise_sonic.sonic_mclag:
    config:
      domain_id: 1
      peer_address: 1.1.1.1
      source_address: 3.3.3.3
      peer_link: 'Portchannel1'
      system_mac: '00:00:00:11:11:11'
      gateway_mac: '00:00:00:12:12:12'
      unique_ip:
        vlans:
          - vlan: Vlan24-28
      peer_gateway:
        vlans:
          - vlan: Vlan24-28
      members:
        portchannels:
          - lag: PortChannel10
          - lag: PortChannel12
    state: overridden

# After state:
# ------------
#
# sonic# show mclag brief
#
# Domain ID            : 1
# Role                 : standby
# Session Status       : down
# Peer Link Status     : down
# Source Address       : 3.3.3.3
# Peer Address         : 1.1.1.1
# Peer Link            : PortChannel1
# Keepalive Interval   : 1 secs
# Session Timeout      : 30 secs
# Delay Restore        : 300 secs
# System Mac           : 20:04:0f:37:bd:c9
# Mclag System Mac     : 00:00:00:11:11:11
# Gateway Mac          : 00:00:00:12:12:12
#
#
# Number of MLAG Interfaces:2
#-----------------------------------------------------------
# MLAG Interface       Local/Remote Status
#-----------------------------------------------------------
# PortChannel10            down/down
# PortChannel12            down/down
#
# sonic# show mclag separate-ip-interfaces
# Interface Name
# ==============
# Vlan24
# Vlan25
# Vlan26
# Vlan27
# Vlan28
# ==============
# Total count :   5
# ==============
# sonic# show mclag peer-gateway-interfaces
# Interface Name
# ==============
# Vlan24
# Vlan25
# Vlan26
# Vlan27
# Vlan28
# ==============
# Total count :   5
# ==============
# sonic#
"""
RETURN = """
before:
  description: The configuration prior to the model invocation.
  returned: always
  type: list
  sample: >
    The configuration returned always in the same format
     of the parameters above.
after:
  description: The resulting configuration model invocation.
  returned: when changed
  type: list
  sample: >
    The configuration returned always in the same format
     of the parameters above.
commands:
  description: The set of commands pushed to the remote device.
  returned: always
  type: list
  sample: ['command 1', 'command 2', 'command 3']
"""


from ansible.module_utils.basic import AnsibleModule
from ansible_collections.dellemc.enterprise_sonic.plugins.module_utils.network.sonic.argspec.mclag.mclag import MclagArgs
from ansible_collections.dellemc.enterprise_sonic.plugins.module_utils.network.sonic.config.mclag.mclag import Mclag


def main():
    """
    Main entry point for module execution

    :returns: the result form module invocation
    """
    module = AnsibleModule(argument_spec=MclagArgs.argument_spec,
                           supports_check_mode=True)

    result = Mclag(module).execute_module()
    module.exit_json(**result)


if __name__ == '__main__':
    main()
