module type BASE = sig val name : string end
module type OPT =
  sig
    val config_file : string ref
    val user_specified_config_file : bool ref
  end
module Make :
  functor (B : BASE) ->
    functor (Opt : OPT) ->
      sig
        val home : string
        val directory : string
        val primary_file : unit -> string
        val current : Configurator.configurator
        module Convert : sig val convert : Oldconfig.t -> Configfile.t end
        val load : unit -> (string * exn) list
      end
