/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.type;

import java.io.Serializable;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.pattern.AnyNodeTest;
import net.sf.saxon.pattern.NoNodeTest;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.style.StandardNames;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInSchemaFactory;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.value.AtomicValue;

public abstract class Type
implements Serializable {
    public static final short ELEMENT = 1;
    public static final short ATTRIBUTE = 2;
    public static final short TEXT = 3;
    public static final short PROCESSING_INSTRUCTION = 7;
    public static final short COMMENT = 8;
    public static final short DOCUMENT = 9;
    public static final short NAMESPACE = 13;
    public static final short NODE = 0;
    public static final ItemType NODE_TYPE = AnyNodeTest.getInstance();
    public static final short ITEM = 88;
    public static final ItemType ITEM_TYPE = AnyItemType.getInstance();
    public static final short MAX_NODE_TYPE = 13;
    public static final short EMPTY = 15;
    public static final int ATOMIC = 643;
    public static final int NUMBER = 646;
    public static final int STRING = 513;
    public static final int BOOLEAN = 514;
    public static final int DECIMAL = 515;
    public static final int FLOAT = 516;
    public static final int DOUBLE = 517;
    public static final int DURATION = 518;
    public static final int DATE_TIME = 519;
    public static final int TIME = 520;
    public static final int DATE = 521;
    public static final int G_YEAR_MONTH = 522;
    public static final int G_YEAR = 523;
    public static final int G_MONTH_DAY = 524;
    public static final int G_DAY = 525;
    public static final int G_MONTH = 526;
    public static final int HEX_BINARY = 527;
    public static final int BASE64_BINARY = 528;
    public static final int ANY_URI = 529;
    public static final int QNAME = 530;
    public static final int NOTATION = 531;
    public static final int UNTYPED_ATOMIC = 642;
    public static final int ANY_SIMPLE_TYPE = 593;
    public static final int OBJECT = 285;
    public static final int INTEGER = 532;
    public static final int NON_POSITIVE_INTEGER = 533;
    public static final int NEGATIVE_INTEGER = 534;
    public static final int LONG = 535;
    public static final int INT = 536;
    public static final int SHORT = 537;
    public static final int BYTE = 538;
    public static final int NON_NEGATIVE_INTEGER = 539;
    public static final int POSITIVE_INTEGER = 540;
    public static final int UNSIGNED_LONG = 541;
    public static final int UNSIGNED_INT = 542;
    public static final int UNSIGNED_SHORT = 543;
    public static final int UNSIGNED_BYTE = 544;
    public static final int NORMALIZED_STRING = 553;
    public static final int TOKEN = 554;
    public static final int LANGUAGE = 555;
    public static final int NMTOKEN = 556;
    public static final int NMTOKENS = 557;
    public static final int NAME = 558;
    public static final int NCNAME = 559;
    public static final int ID = 560;
    public static final int IDREF = 561;
    public static final int IDREFS = 562;
    public static final int ENTITY = 563;
    public static final int YEAR_MONTH_DURATION = 644;
    public static final int DAY_TIME_DURATION = 645;
    public static final AtomicType UNTYPED_ATOMIC_TYPE = (AtomicType)BuiltInSchemaFactory.getSchemaType(642);
    public static final AtomicType ATOMIC_TYPE = (AtomicType)BuiltInSchemaFactory.getSchemaType(643);
    public static final AtomicType YEAR_MONTH_DURATION_TYPE = (AtomicType)BuiltInSchemaFactory.getSchemaType(644);
    public static final AtomicType DAY_TIME_DURATION_TYPE = (AtomicType)BuiltInSchemaFactory.getSchemaType(645);
    public static final AtomicType STRING_TYPE = (AtomicType)BuiltInSchemaFactory.getSchemaType(513);
    public static final AtomicType BOOLEAN_TYPE = (AtomicType)BuiltInSchemaFactory.getSchemaType(514);
    public static final AtomicType DECIMAL_TYPE = (AtomicType)BuiltInSchemaFactory.getSchemaType(515);
    public static final AtomicType FLOAT_TYPE = (AtomicType)BuiltInSchemaFactory.getSchemaType(516);
    public static final AtomicType DOUBLE_TYPE = (AtomicType)BuiltInSchemaFactory.getSchemaType(517);
    public static final AtomicType DURATION_TYPE = (AtomicType)BuiltInSchemaFactory.getSchemaType(518);
    public static final AtomicType DATE_TIME_TYPE = (AtomicType)BuiltInSchemaFactory.getSchemaType(519);
    public static final AtomicType TIME_TYPE = (AtomicType)BuiltInSchemaFactory.getSchemaType(520);
    public static final AtomicType DATE_TYPE = (AtomicType)BuiltInSchemaFactory.getSchemaType(521);
    public static final AtomicType G_YEAR_MONTH_TYPE = (AtomicType)BuiltInSchemaFactory.getSchemaType(522);
    public static final AtomicType G_YEAR_TYPE = (AtomicType)BuiltInSchemaFactory.getSchemaType(523);
    public static final AtomicType G_MONTH_DAY_TYPE = (AtomicType)BuiltInSchemaFactory.getSchemaType(524);
    public static final AtomicType G_DAY_TYPE = (AtomicType)BuiltInSchemaFactory.getSchemaType(525);
    public static final AtomicType G_MONTH_TYPE = (AtomicType)BuiltInSchemaFactory.getSchemaType(526);
    public static final AtomicType HEX_BINARY_TYPE = (AtomicType)BuiltInSchemaFactory.getSchemaType(527);
    public static final AtomicType BASE64_BINARY_TYPE = (AtomicType)BuiltInSchemaFactory.getSchemaType(528);
    public static final AtomicType ANY_URI_TYPE = (AtomicType)BuiltInSchemaFactory.getSchemaType(529);
    public static final AtomicType QNAME_TYPE = (AtomicType)BuiltInSchemaFactory.getSchemaType(530);
    public static final AtomicType NOTATION_TYPE = (AtomicType)BuiltInSchemaFactory.getSchemaType(531);
    public static final AtomicType INTEGER_TYPE = (AtomicType)BuiltInSchemaFactory.getSchemaType(532);
    public static final AtomicType ID_TYPE = (AtomicType)BuiltInSchemaFactory.getSchemaType(560);
    public static final AtomicType NUMBER_TYPE = (AtomicType)BuiltInSchemaFactory.getSchemaType(646);

    public static boolean isNodeType(ItemType type) {
        return type instanceof NodeTest;
    }

    public static final String displayTypeName(Item item) {
        if (item instanceof NodeInfo) {
            NodeInfo node = (NodeInfo)item;
            switch (node.getNodeKind()) {
                case 9: {
                    return "document-node()";
                }
                case 1: {
                    NamePool pool = node.getNamePool();
                    int annotation = node.getTypeAnnotation();
                    return "element(" + ((NodeInfo)item).getDisplayName() + ", " + (annotation == -1 ? "xdt:untyped)" : pool.getDisplayName(annotation) + ")");
                }
                case 2: {
                    NamePool pool2 = node.getNamePool();
                    int annotation2 = node.getTypeAnnotation();
                    return "attribute(" + ((NodeInfo)item).getDisplayName() + (annotation2 == -1 ? ")" : "," + pool2.getDisplayName(annotation2) + ")");
                }
                case 3: {
                    return "text()";
                }
                case 8: {
                    return "commen()";
                }
                case 7: {
                    return "processing-instruction()";
                }
                case 13: {
                    return "namespace()";
                }
            }
            return "";
        }
        return ((AtomicValue)item).getItemType().toString();
    }

    public static ItemType getBuiltInItemType(String namespace, String localName) {
        return (ItemType)((Object)BuiltInSchemaFactory.getSchemaType(StandardNames.getFingerprint(namespace, localName)));
    }

    public static boolean isSubType(ItemType subtype, ItemType supertype) {
        if (subtype == null) {
            return false;
        }
        if (subtype.isSameType(supertype)) {
            return true;
        }
        if (supertype instanceof AnyItemType) {
            return true;
        }
        if (subtype instanceof AnyItemType) {
            return false;
        }
        if (subtype instanceof NoNodeTest) {
            return true;
        }
        return Type.isSubType(subtype.getSuperType(), supertype);
    }

    public static boolean isPromotable(ItemType sourceType, ItemType targetType) {
        if (Type.isSubType(sourceType, DECIMAL_TYPE)) {
            return targetType == FLOAT_TYPE || targetType == DOUBLE_TYPE;
        }
        if (Type.isSubType(sourceType, FLOAT_TYPE)) {
            return targetType == DOUBLE_TYPE;
        }
        return false;
    }

    public static final ItemType getCommonSuperType(ItemType t1, ItemType t2) {
        if (t1 instanceof NoNodeTest) {
            return t2;
        }
        if (t2 instanceof NoNodeTest) {
            return t1;
        }
        if (t1 == t2) {
            return t1;
        }
        if (Type.isSubType(t1, t2)) {
            return t2;
        }
        if (Type.isSubType(t2, t1)) {
            return t1;
        }
        return Type.getCommonSuperType(t2.getSuperType(), t1);
    }

    public static boolean isPrimitiveType(int code) {
        return code >= 0 && (code <= 532 || code == 646 || code == 642 || code == 643 || code == 593);
    }
}

