/*
 * Decompiled with CFR 0.152.
 */
package yuku.alkitabconverter.yet;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import yuku.alkitab.model.FootnoteEntry;
import yuku.alkitab.model.XrefEntry;
import yuku.alkitab.util.Ari;
import yuku.alkitab.yes2.model.PericopeData;
import yuku.alkitabconverter.util.FootnoteDb;
import yuku.alkitabconverter.util.Rec;
import yuku.alkitabconverter.util.TextDb;
import yuku.alkitabconverter.util.XrefDb;
import yuku.alkitabconverter.yes_common.Yes2Common;

public class YetFileOutput {
    private final OutputStream output;
    private TextDb textDb;
    private PericopeData pericopeData;
    private XrefDb xrefDb;
    private FootnoteDb footnoteDb;
    private Yes2Common.VersionInfo versionInfo;

    public YetFileOutput(File output) throws IOException {
        this.output = new FileOutputStream(output);
    }

    public YetFileOutput(OutputStream output) {
        this.output = output;
    }

    public void setTextDb(TextDb textDb) {
        this.textDb = textDb;
    }

    public void setPericopeData(PericopeData pericopeData) {
        this.pericopeData = pericopeData;
    }

    public void setXrefDb(XrefDb xrefDb) {
        this.xrefDb = xrefDb;
    }

    public void setFootnoteDb(FootnoteDb footnoteDb) {
        this.footnoteDb = footnoteDb;
    }

    public void setVersionInfo(Yes2Common.VersionInfo versionInfo) {
        this.versionInfo = versionInfo;
    }

    public void write() throws IOException {
        final PrintWriter pw = new PrintWriter(new OutputStreamWriter(this.output, "utf-8"));
        LinkedHashMap<String, String> info = new LinkedHashMap<String, String>();
        if (this.versionInfo.locale != null) {
            info.put("locale", this.versionInfo.locale);
        }
        if (this.versionInfo.shortName != null) {
            info.put("shortName", this.versionInfo.shortName);
        }
        if (this.versionInfo.longName != null) {
            info.put("longName", this.versionInfo.longName);
        }
        if (this.versionInfo.description != null) {
            info.put("description", this.versionInfo.description);
        }
        for (Map.Entry e : info.entrySet()) {
            pw.printf(Locale.US, "%s\t%s\t%s\n", "info", e.getKey(), ((String)e.getValue()).replaceAll("[\\r\\n]", " "));
        }
        int[] bookIds = this.textDb.getBookIds();
        for (int bookId : bookIds) {
            String bookShortName = this.versionInfo.getBookShortName(bookId);
            String bookAbbreviation = this.versionInfo.getBookAbbreviation(bookId);
            if (bookAbbreviation == null) {
                pw.printf(Locale.US, "%s\t%s\t%s\n", "book_name", bookId + 1, bookShortName);
                continue;
            }
            pw.printf(Locale.US, "%s\t%s\t%s\t%s\n", "book_name", bookId + 1, bookShortName, bookAbbreviation);
        }
        Object object = this.textDb.toRecList().iterator();
        while (object.hasNext()) {
            Rec rec = (Rec)object.next();
            pw.printf(Locale.US, "%s\t%s\t%s\t%s\t%s\n", "verse", rec.book_1, rec.chapter_1, rec.verse_1, rec.text);
        }
        if (this.pericopeData != null && this.pericopeData.entries != null) {
            for (PericopeData.Entry entry : this.pericopeData.entries) {
                pw.printf(Locale.US, "%s\t%s\t%s\t%s\t%s\n", "pericope", Ari.toBook(entry.ari) + 1, Ari.toChapter(entry.ari), Ari.toVerse(entry.ari), entry.block.title);
                if (entry.block.parallels == null) continue;
                for (String parallel : entry.block.parallels) {
                    pw.printf(Locale.US, "%s\t%s\n", "parallel", parallel);
                }
            }
        }
        if (this.xrefDb != null) {
            this.xrefDb.processEach(new XrefDb.XrefProcessor(){

                @Override
                public void process(XrefEntry xe, int ari, int entryIndex) {
                    pw.printf(Locale.US, "%s\t%s\t%s\t%s\t%s\t%s\n", "xref", Ari.toBook(ari) + 1, Ari.toChapter(ari), Ari.toVerse(ari), entryIndex + 1, xe.content);
                }
            });
        }
        if (this.footnoteDb != null) {
            this.footnoteDb.processEach(new FootnoteDb.FootnoteProcessor(){

                @Override
                public void process(FootnoteEntry fe, int ari, int entryIndex) {
                    pw.printf(Locale.US, "%s\t%s\t%s\t%s\t%s\t%s\n", "footnote", Ari.toBook(ari) + 1, Ari.toChapter(ari), Ari.toVerse(ari), entryIndex + 1, fe.content);
                }
            });
        }
        pw.close();
    }
}

