#include "Bdef.h"

void dgupk_sum(MatInf, buff)
MATINFO  *MatInf;
char  *buff;
{
   int m, n, lda, i, j;
   double *A, *v;

   m = MatInf->M;
   n = MatInf->N;
   lda = MatInf->lda;
   A = (double *) MatInf->A;
   v = (double *) buff;

   if (m != 1)
   {
      for(j=0; j < n; j++)
      {
	 i = pvm_upkdouble(v, m, 1);
	 Mpvmerror(i, "pvm_upkdouble", __LINE__, __FILE__);
	 for (i=0; i < m; i++) A[i] += v[i];
	 A += lda;
      }
   }
   else
   {
      i = pvm_upkdouble((double *) v, n, 1);
      Mpvmerror(i, "pvm_upkdouble", __LINE__, __FILE__);
      for (i=j=0; j < n; j++, i += lda) A[i] += v[j];
   }
}
