----------------------------------------------------------------------------
-- |
-- Module      :  Main
-- Copyright   :  (c) Jan Vornberger 2009
-- License     :  BSD3-style (see LICENSE)
--
-- Maintainer  :  jan.vornberger@informatik.uni-oldenburg.de
-- Stability   :  unstable
-- Portability :  not portable
--
-----------------------------------------------------------------------------

module Main where

import Graphics.UI.Gtk
import Graphics.UI.Gtk.Glade
import Paths_bluetile
import Utils
import Control.Monad(when)
import System.Environment(getEnv)
import System.FilePath(pathSeparator)
import System.Directory(doesFileExist)

main :: IO ()
main = do
    home <- getEnv "HOME"
    let configFile = home ++ [pathSeparator] ++ ".bluetilegreet"
    exists <- doesFileExist configFile
    when (not exists) $ greetingScreen configFile

greetingScreen :: String -> IO ()
greetingScreen configFile = do
    initGUI
    dataDir <- getDataDir
    Just xml <- xmlNew $ dataDir ++ [pathSeparator] ++ "bluetilegreet" ++ [pathSeparator] ++ "bluetilegreet.glade"

    window <- xmlGetWidget xml castToWindow "bluetilegreetwindow"
    onDestroy window mainQuit
    windowSetPosition window WinPosCenter

    openWindowsBtn <- xmlGetWidget xml castToButton "openwindowsbutton"
    onClicked openWindowsBtn $ do
        libexecDir <- getLibexecDir
        spawnPipe $ libexecDir ++ [pathSeparator] ++ "bluetilemockwin 0 0 65535"
        spawnPipe $ libexecDir ++ [pathSeparator] ++ "bluetilemockwin 65535 0 0"
        return ()

    startBtn <- xmlGetWidget xml castToButton "startbutton"
    startupAgainChkBtn <- xmlGetWidget xml castToCheckButton "startupagaincheckbutton"
    onClicked startBtn $ do
        noFutureStartups <- toggleButtonGetActive startupAgainChkBtn
        when noFutureStartups $ do
            writeFile configFile "Delete this file to show the Bluetile greeting screen again.\n"
        mainQuit

    widgetShowAll window
    mainGUI
