//  ************************************************************************************************
//
//  BornAgain: simulate and fit reflection and scattering
//
//! @file      GUI/Support/Data/SimulationOptionsItem.h
//! @brief     Defines class SimulationOptionsItem
//!
//! @homepage  http://www.bornagainproject.org
//! @license   GNU General Public License v3 or higher (see COPYING)
//! @copyright Forschungszentrum Jülich GmbH 2018
//! @authors   Scientific Computing Group at MLZ (see CITATION, AUTHORS)
//
//  ************************************************************************************************

#ifndef BORNAGAIN_GUI_SUPPORT_DATA_SIMULATIONOPTIONSITEM_H
#define BORNAGAIN_GUI_SUPPORT_DATA_SIMULATIONOPTIONSITEM_H

#include <QXmlStreamWriter>

//! The SimulationOptionsItem class holds simulation status (run policy, number of threads,
//! integration flag). Used in SimulationView to define job settings. When job is started,
//! item is copied to the job.

class SimulationOptionsItem {
public:
    explicit SimulationOptionsItem();

    void setNumberOfThreads(unsigned n) { m_numberOfThreads = n; }
    unsigned numberOfThreads() const { return m_numberOfThreads; }

    void setRunImmediately(bool b) { m_runImmediately = b; }
    bool runImmediately() const { return m_runImmediately; }

    bool useMonteCarloIntegration() const;
    void setUseMonteCarloIntegration(unsigned numberOfPoints);

    void setUseAnalytical() { m_computationMethodAnalytical = true; }
    bool useAnalytical() const { return m_computationMethodAnalytical; }

    unsigned numberOfMonteCarloPoints() const { return m_numberOfMonteCarloPoints; }

    void setUseAverageMaterials(bool b) { m_useAverageMaterials = b; }
    bool useAverageMaterials() const { return m_useAverageMaterials; }

    void setIncludeSpecularPeak(bool b) { m_includeSpecularPeak = b; }
    bool includeSpecularPeak() const { return m_includeSpecularPeak; }

    int selectedInstrumentIndex() const { return m_selectedInstrumentIndex; }
    void setSelectedInstrumentIndex(int i) { m_selectedInstrumentIndex = i; }

    int selectedSampleIndex() const { return m_selectedSampleIndex; }
    void setSelectedSampleIndex(int i) { m_selectedSampleIndex = i; }

    int selectedDataIndex() const { return m_selectedDataIndex; }
    void setSelectedDataIndex(int i) { m_selectedDataIndex = i; }

    void writeTo(QXmlStreamWriter* w) const;
    void readFrom(QXmlStreamReader* r);

private:
    bool m_runImmediately;
    unsigned m_numberOfThreads;
    bool m_computationMethodAnalytical;
    unsigned m_numberOfMonteCarloPoints;
    bool m_useAverageMaterials;
    bool m_includeSpecularPeak;
    int m_selectedInstrumentIndex;
    int m_selectedSampleIndex;
    int m_selectedDataIndex;
};

#endif // BORNAGAIN_GUI_SUPPORT_DATA_SIMULATIONOPTIONSITEM_H
