//  ************************************************************************************************
//
//  BornAgain: simulate and fit reflection and scattering
//
//! @file      GUI/View/PlotUtil/RangeUtil.h
//! @brief     Defines RangeUtil namespace
//!
//! @homepage  http://www.bornagainproject.org
//! @license   GNU General Public License v3 or higher (see COPYING)
//! @copyright Forschungszentrum Jülich GmbH 2018
//! @authors   Scientific Computing Group at MLZ (see CITATION, AUTHORS)
//
//  ************************************************************************************************

#ifndef BORNAGAIN_GUI_VIEW_PLOTUTIL_RANGEUTIL_H
#define BORNAGAIN_GUI_VIEW_PLOTUTIL_RANGEUTIL_H

#include <QList>

class AmplitudeAxisItem;
class IntensityDataItem;
class SpecularDataItem;
class QCPRange;

//! Provides few helper functions for ColorMapPlot.

namespace GUI::View::RangeUtil {

//! Returns x-axis vizible range (zoom).
QCPRange itemZoomX(const IntensityDataItem* item);

//! Returns y-axis vizible range (zoom).
QCPRange itemZoomY(const IntensityDataItem* item);

//! Returns z-axis data range.
QCPRange itemDataRange(const IntensityDataItem* item);

//! Returns z-axis visible range (zoom).
QCPRange itemDataZoom(const IntensityDataItem* item);

//! Returns common min for a list of axes (zoom).
double commonMin(const QList<AmplitudeAxisItem*>& axes);

//! Returns common max for a list of axes (zoom).
double commonMax(const QList<AmplitudeAxisItem*>& axes);

//! Returns common range for a list of axes (zoom).
QCPRange commonRange(const QList<AmplitudeAxisItem*>& axes);

//! Sets common Y range for a list of items (zoom).
void setCommonRangeY(QList<SpecularDataItem*> items);

//! Sets common Z range for a list of items (zoom).
void setCommonRangeZ(QList<IntensityDataItem*> items);

//! Gets Y axes from a list of specular items.
QList<AmplitudeAxisItem*> valueAxesFromSpecularItems(const QList<SpecularDataItem*>& items);

//! Gets Z axes from a list of intensity items.
QList<AmplitudeAxisItem*> valueAxesFromIntensityItems(const QList<IntensityDataItem*>& items);


} // namespace GUI::View::RangeUtil

#endif // BORNAGAIN_GUI_VIEW_PLOTUTIL_RANGEUTIL_H
