{ -*- buffer-read-only: t -*-

  Copyright 2015-2022 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated node properties.

  Do not edit this file manually!
  To add new properties:
  - add them to the text files in tools/internal/x3d-nodes-to-pascal/nodes-specification/ ,
  - and regenerate include files by running x3d-nodes-to-pascal }

{$ifdef read_interface}

  strict private
    function GetCenter: TVector3Double;
    procedure SetCenter(const Value: TVector3Double);
    function GetGeoOrigin: TGeoOriginNode;
    procedure SetGeoOrigin(const Value: TGeoOriginNode);
    function GetRange: Single;
    procedure SetRange(const Value: Single);
    function GetBBox: TBox3D;
    procedure SetBBox(const Value: TBox3D);
  public
    procedure CreateNode; override;
    class function ClassX3DType: string; override;

    strict private FEventChildren: TMFNodeEvent;
    {  }
    public property EventChildren: TMFNodeEvent read FEventChildren;

    strict private FEventLevel_changed: TSFInt32Event;
    {  }
    public property EventLevel_changed: TSFInt32Event read FEventLevel_changed;

    strict private FFdCenter: TSFVec3d;
    { Internal wrapper for property @link(Center). This wrapper API may change, we advise to access simpler @link(Center) instead. }
    public property FdCenter: TSFVec3d read FFdCenter;
    {  }
    property Center: TVector3Double read GetCenter write SetCenter;

    strict private FFdChild1Url: TMFString;
    { Internal wrapper for property @link(Child1Url). This wrapper API may change, we advise to access simpler @link(Child1Url) instead. }
    public property FdChild1Url: TMFString read FFdChild1Url;
    {  }
    procedure SetChild1Url(const Value: array of string); overload;
    {  }
    procedure SetChild1Url(const Value: TCastleStringList); overload;

    strict private FFdChild2Url: TMFString;
    { Internal wrapper for property @link(Child2Url). This wrapper API may change, we advise to access simpler @link(Child2Url) instead. }
    public property FdChild2Url: TMFString read FFdChild2Url;
    {  }
    procedure SetChild2Url(const Value: array of string); overload;
    {  }
    procedure SetChild2Url(const Value: TCastleStringList); overload;

    strict private FFdChild3Url: TMFString;
    { Internal wrapper for property @link(Child3Url). This wrapper API may change, we advise to access simpler @link(Child3Url) instead. }
    public property FdChild3Url: TMFString read FFdChild3Url;
    {  }
    procedure SetChild3Url(const Value: array of string); overload;
    {  }
    procedure SetChild3Url(const Value: TCastleStringList); overload;

    strict private FFdChild4Url: TMFString;
    { Internal wrapper for property @link(Child4Url). This wrapper API may change, we advise to access simpler @link(Child4Url) instead. }
    public property FdChild4Url: TMFString read FFdChild4Url;
    {  }
    procedure SetChild4Url(const Value: array of string); overload;
    {  }
    procedure SetChild4Url(const Value: TCastleStringList); overload;

    strict private FFdGeoOrigin: TSFNode;
    { Internal wrapper for property @link(GeoOrigin). This wrapper API may change, we advise to access simpler @link(GeoOrigin) instead. }
    public property FdGeoOrigin: TSFNode read FFdGeoOrigin;
    {  }
    property GeoOrigin: TGeoOriginNode read GetGeoOrigin write SetGeoOrigin;

    strict private FFdGeoSystem: TMFString;
    { Internal wrapper for property @link(GeoSystem). This wrapper API may change, we advise to access simpler @link(GeoSystem) instead. }
    public property FdGeoSystem: TMFString read FFdGeoSystem;
    {  }
    procedure SetGeoSystem(const Value: array of string); overload;
    {  }
    procedure SetGeoSystem(const Value: TCastleStringList); overload;

    strict private FFdRange: TSFFloat;
    { Internal wrapper for property @link(Range). This wrapper API may change, we advise to access simpler @link(Range) instead. }
    public property FdRange: TSFFloat read FFdRange;
    {  }
    property Range: Single read GetRange write SetRange;

    strict private FFdRootUrl: TMFString;
    { Internal wrapper for property @link(RootUrl). This wrapper API may change, we advise to access simpler @link(RootUrl) instead. }
    public property FdRootUrl: TMFString read FFdRootUrl;
    {  }
    procedure SetRootUrl(const Value: array of string); overload;
    {  }
    procedure SetRootUrl(const Value: TCastleStringList); overload;

    strict private FFdRootNode: TMFNode;
    { Internal wrapper for property @link(RootNode). This wrapper API may change, we advise to access simpler @link(RootNode) instead. }
    public property FdRootNode: TMFNode read FFdRootNode;
    {  }
    procedure SetRootNode(const Value: array of TAbstractChildNode);

    strict private FFdBboxCenter: TSFVec3f;
    { Internal wrapper for property @link(BboxCenter). This wrapper API may change, we advise to access simpler @link(BboxCenter) instead. }
    public property FdBboxCenter: TSFVec3f read FFdBboxCenter;
    {  }
    property BBox: TBox3D read GetBBox write SetBBox;

    strict private FFdBboxSize: TSFVec3f;
    { Internal wrapper for property @link(BboxSize). This wrapper API may change, we advise to access simpler @link(BboxSize) instead. }
    public property FdBboxSize: TSFVec3f read FFdBboxSize;

{$endif read_interface}

{$ifdef read_implementation}

{ TGeoLODNode ----------------------------------------------- }

function TGeoLODNode.GetCenter: TVector3Double;
begin
  Result := FdCenter.Value;
end;

procedure TGeoLODNode.SetCenter(const Value: TVector3Double);
begin
  FdCenter.Send(Value);
end;

procedure TGeoLODNode.SetChild1Url(const Value: array of string);
begin
  FdChild1Url.Send(Value);
end;

procedure TGeoLODNode.SetChild1Url(const Value: TCastleStringList);
begin
  FdChild1Url.Send(Value);
end;

procedure TGeoLODNode.SetChild2Url(const Value: array of string);
begin
  FdChild2Url.Send(Value);
end;

procedure TGeoLODNode.SetChild2Url(const Value: TCastleStringList);
begin
  FdChild2Url.Send(Value);
end;

procedure TGeoLODNode.SetChild3Url(const Value: array of string);
begin
  FdChild3Url.Send(Value);
end;

procedure TGeoLODNode.SetChild3Url(const Value: TCastleStringList);
begin
  FdChild3Url.Send(Value);
end;

procedure TGeoLODNode.SetChild4Url(const Value: array of string);
begin
  FdChild4Url.Send(Value);
end;

procedure TGeoLODNode.SetChild4Url(const Value: TCastleStringList);
begin
  FdChild4Url.Send(Value);
end;

function TGeoLODNode.GetGeoOrigin: TGeoOriginNode;
begin
  if FdGeoOrigin.Value is TGeoOriginNode then
    Result := TGeoOriginNode(FdGeoOrigin.Value)
  else
    Result := nil;
end;

procedure TGeoLODNode.SetGeoOrigin(const Value: TGeoOriginNode);
begin
  FdGeoOrigin.Send(Value);
end;

procedure TGeoLODNode.SetGeoSystem(const Value: array of string);
begin
  FdGeoSystem.Send(Value);
end;

procedure TGeoLODNode.SetGeoSystem(const Value: TCastleStringList);
begin
  FdGeoSystem.Send(Value);
end;

function TGeoLODNode.GetRange: Single;
begin
  Result := FdRange.Value;
end;

procedure TGeoLODNode.SetRange(const Value: Single);
begin
  FdRange.Send(Value);
end;

procedure TGeoLODNode.SetRootUrl(const Value: array of string);
begin
  FdRootUrl.Send(Value);
end;

procedure TGeoLODNode.SetRootUrl(const Value: TCastleStringList);
begin
  FdRootUrl.Send(Value);
end;

procedure TGeoLODNode.SetRootNode(const Value: array of TAbstractChildNode);
var
  L: Integer;
  A: array of TX3DNode;
begin
  L := High(Value) + 1;
  SetLength(A, L);
  if L > 0 then
    Move(Value[0], A[0], L * SizeOf(TAbstractChildNode));
  FdRootNode.Send(A);
end;

function TGeoLODNode.GetBBox: TBox3D;
begin
  Result := TBox3D.FromCenterSize(FdBBoxCenter.Value, FdBBoxSize.Value);
end;

procedure TGeoLODNode.SetBBox(const Value: TBox3D);
var
  ValueCenter, ValueSize: TVector3;
begin
  Value.ToCenterSize(ValueCenter, ValueSize);
  FdBBoxCenter.Send(ValueCenter);
  FdBBoxSize.Send(ValueSize);
end;

class function TGeoLODNode.ClassX3DType: String;
begin
  Result := 'GeoLOD';
end;

procedure TGeoLODNode.CreateNode;
begin
  inherited;

  FEventChildren := TMFNodeEvent.Create(Self, 'children', false);
  AddEvent(FEventChildren);

  FEventLevel_changed := TSFInt32Event.Create(Self, 'level_changed', false);
  AddEvent(FEventLevel_changed);

  FFdCenter := TSFVec3d.Create(Self, False, 'center', Vector3Double(0, 0, 0));
   FdCenter.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdCenter);

  FFdChild1Url := TMFString.Create(Self, False, 'child1Url', []);
   FdChild1Url.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdChild1Url);

  FFdChild2Url := TMFString.Create(Self, False, 'child2Url', []);
   FdChild2Url.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdChild2Url);

  FFdChild3Url := TMFString.Create(Self, False, 'child3Url', []);
   FdChild3Url.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdChild3Url);

  FFdChild4Url := TMFString.Create(Self, False, 'child4Url', []);
   FdChild4Url.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdChild4Url);

  FFdGeoOrigin := TSFNode.Create(Self, False, 'geoOrigin', [TGeoOriginNode]);
   FdGeoOrigin.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdGeoOrigin);

  FFdGeoSystem := TMFString.Create(Self, False, 'geoSystem', ['GD','WE']);
   FdGeoSystem.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdGeoSystem);

  FFdRange := TSFFloat.Create(Self, False, 'range', 10);
   FdRange.ChangeAlways := chVisibleNonGeometry;
   FdRange.MustBeNonnegative := true;
  AddField(FFdRange);

  FFdRootUrl := TMFString.Create(Self, False, 'rootUrl', []);
   FdRootUrl.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdRootUrl);

  FFdRootNode := TMFNode.Create(Self, False, 'rootNode', [TAbstractChildNode]);
   FdRootNode.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdRootNode);

  FFdBboxCenter := TSFVec3f.Create(Self, False, 'bboxCenter', Vector3(0, 0, 0));
   FdBboxCenter.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdBboxCenter);

  FFdBboxSize := TSFVec3f.Create(Self, False, 'bboxSize', Vector3(-1, -1, -1));
   FdBboxSize.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdBboxSize);
end;

{$endif read_implementation}
