{ -*- buffer-read-only: t -*-

  Copyright 2015-2022 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated node properties.

  Do not edit this file manually!
  To add new properties:
  - add them to the text files in tools/internal/x3d-nodes-to-pascal/nodes-specification/ ,
  - and regenerate include files by running x3d-nodes-to-pascal }

{$ifdef read_interface}

  strict private
    function GetGeoOrigin: TGeoOriginNode;
    procedure SetGeoOrigin(const Value: TGeoOriginNode);
  public
    procedure CreateNode; override;
    class function ClassX3DType: string; override;

    strict private FFdKeyValue: TMFVec3d;
    { Internal wrapper for property @link(KeyValue). This wrapper API may change, we advise to access simpler @link(KeyValue) instead. }
    public property FdKeyValue: TMFVec3d read FFdKeyValue;
    {  }
    procedure SetKeyValue(const Value: array of TVector3Double); overload;
    {  }
    procedure SetKeyValue(const Value: TVector3DoubleList); overload;

    strict private FEventGeovalue_changed: TSFVec3dEvent;
    {  }
    public property EventGeovalue_changed: TSFVec3dEvent read FEventGeovalue_changed;

    strict private FEventValue_changed: TSFVec3fEvent;
    {  }
    public property EventValue_changed: TSFVec3fEvent read FEventValue_changed;

    strict private FFdGeoOrigin: TSFNode;
    { Internal wrapper for property @link(GeoOrigin). This wrapper API may change, we advise to access simpler @link(GeoOrigin) instead. }
    public property FdGeoOrigin: TSFNode read FFdGeoOrigin;
    {  }
    property GeoOrigin: TGeoOriginNode read GetGeoOrigin write SetGeoOrigin;

    strict private FFdGeoSystem: TMFString;
    { Internal wrapper for property @link(GeoSystem). This wrapper API may change, we advise to access simpler @link(GeoSystem) instead. }
    public property FdGeoSystem: TMFString read FFdGeoSystem;
    {  }
    procedure SetGeoSystem(const Value: array of string); overload;
    {  }
    procedure SetGeoSystem(const Value: TCastleStringList); overload;

{$endif read_interface}

{$ifdef read_implementation}

{ TGeoPositionInterpolatorNode ----------------------------------------------- }

procedure TGeoPositionInterpolatorNode.SetKeyValue(const Value: array of TVector3Double);
begin
  FdKeyValue.Send(Value);
end;

procedure TGeoPositionInterpolatorNode.SetKeyValue(const Value: TVector3DoubleList);
begin
  FdKeyValue.Send(Value);
end;

function TGeoPositionInterpolatorNode.GetGeoOrigin: TGeoOriginNode;
begin
  if FdGeoOrigin.Value is TGeoOriginNode then
    Result := TGeoOriginNode(FdGeoOrigin.Value)
  else
    Result := nil;
end;

procedure TGeoPositionInterpolatorNode.SetGeoOrigin(const Value: TGeoOriginNode);
begin
  FdGeoOrigin.Send(Value);
end;

procedure TGeoPositionInterpolatorNode.SetGeoSystem(const Value: array of string);
begin
  FdGeoSystem.Send(Value);
end;

procedure TGeoPositionInterpolatorNode.SetGeoSystem(const Value: TCastleStringList);
begin
  FdGeoSystem.Send(Value);
end;

class function TGeoPositionInterpolatorNode.ClassX3DType: String;
begin
  Result := 'GeoPositionInterpolator';
end;

procedure TGeoPositionInterpolatorNode.CreateNode;
begin
  inherited;

  FFdKeyValue := TMFVec3d.Create(Self, True, 'keyValue', []);
   FdKeyValue.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdKeyValue);

  FEventGeovalue_changed := TSFVec3dEvent.Create(Self, 'geovalue_changed', false);
  AddEvent(FEventGeovalue_changed);

  FEventValue_changed := TSFVec3fEvent.Create(Self, 'value_changed', false);
  AddEvent(FEventValue_changed);

  FFdGeoOrigin := TSFNode.Create(Self, False, 'geoOrigin', [TGeoOriginNode]);
   FdGeoOrigin.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdGeoOrigin);

  FFdGeoSystem := TMFString.Create(Self, False, 'geoSystem', ['GD','WE']);
   FdGeoSystem.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdGeoSystem);
end;

{$endif read_implementation}
