{ -*- buffer-read-only: t -*-

  Copyright 2015-2022 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated node properties.

  Do not edit this file manually!
  To add new properties:
  - add them to the text files in tools/internal/x3d-nodes-to-pascal/nodes-specification/ ,
  - and regenerate include files by running x3d-nodes-to-pascal }

{$ifdef read_interface}

  strict private
    function GetTimeOut: TFloatTime;
    procedure SetTimeOut(const Value: TFloatTime);
  public
    procedure CreateNode; override;
    class function ClassX3DType: string; override;

    strict private FFdTimeOut: TSFTime;
    { Internal wrapper for property @link(TimeOut). This wrapper API may change, we advise to access simpler @link(TimeOut) instead. }
    public property FdTimeOut: TSFTime read FFdTimeOut;
    {  }
    property TimeOut: TFloatTime read GetTimeOut write SetTimeOut;

    strict private FFdWatchList: TMFNode;
    { Internal wrapper for property @link(WatchList). This wrapper API may change, we advise to access simpler @link(WatchList) instead. }
    public property FdWatchList: TMFNode read FFdWatchList;

    strict private FEventIsLoaded: TSFBoolEvent;
    {  }
    public property EventIsLoaded: TSFBoolEvent read FEventIsLoaded;

    strict private FEventLoadTime: TSFTimeEvent;
    {  }
    public property EventLoadTime: TSFTimeEvent read FEventLoadTime;

    strict private FEventProgress: TSFFloatEvent;
    {  }
    public property EventProgress: TSFFloatEvent read FEventProgress;

{$endif read_interface}

{$ifdef read_implementation}

{ TLoadSensorNode ----------------------------------------------- }

function TLoadSensorNode.GetTimeOut: TFloatTime;
begin
  Result := FdTimeOut.Value;
end;

procedure TLoadSensorNode.SetTimeOut(const Value: TFloatTime);
begin
  FdTimeOut.Send(Value);
end;

class function TLoadSensorNode.ClassX3DType: String;
begin
  Result := 'LoadSensor';
end;

procedure TLoadSensorNode.CreateNode;
begin
  inherited;

  FFdTimeOut := TSFTime.Create(Self, True, 'timeOut', 0);
   FdTimeOut.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdTimeOut);

  FFdWatchList := TMFNode.Create(Self, True, 'watchList', TUrlFunctionality);
   FdWatchList.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdWatchList);

  FEventIsLoaded := TSFBoolEvent.Create(Self, 'isLoaded', false);
  AddEvent(FEventIsLoaded);

  FEventLoadTime := TSFTimeEvent.Create(Self, 'loadTime', false);
  AddEvent(FEventLoadTime);

  FEventProgress := TSFFloatEvent.Create(Self, 'progress', false);
  AddEvent(FEventProgress);
end;

{$endif read_implementation}
