{ -*- buffer-read-only: t -*-

  Copyright 2015-2022 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated node properties.

  Do not edit this file manually!
  To add new properties:
  - add them to the text files in tools/internal/x3d-nodes-to-pascal/nodes-specification/ ,
  - and regenerate include files by running x3d-nodes-to-pascal }

{$ifdef read_interface}

  strict private
    function GetHeightAngle: Single;
    procedure SetHeightAngle(const Value: Single);
  public
    procedure CreateNode; override;
    class function ClassX3DType: string; override;
    class function ForVRMLVersion(const Version: TX3DVersion): Boolean; override;

    strict private FFdHeightAngle: TSFFloat;
    { Internal wrapper for property @link(HeightAngle). This wrapper API may change, we advise to access simpler @link(HeightAngle) instead. }
    public property FdHeightAngle: TSFFloat read FFdHeightAngle;
    {  }
    property HeightAngle: Single read GetHeightAngle write SetHeightAngle;

{$endif read_interface}

{$ifdef read_implementation}

{ TPerspectiveCameraNode_1 ----------------------------------------------- }

function TPerspectiveCameraNode_1.GetHeightAngle: Single;
begin
  Result := FdHeightAngle.Value;
end;

procedure TPerspectiveCameraNode_1.SetHeightAngle(const Value: Single);
begin
  FdHeightAngle.Send(Value);
end;

class function TPerspectiveCameraNode_1.ForVRMLVersion(const Version: TX3DVersion): Boolean;
begin
  Result := Version.Major <= 1; // parse this node only in VRML 1.0 and Inventor files
end;

class function TPerspectiveCameraNode_1.ClassX3DType: String;
begin
  Result := 'PerspectiveCamera';
end;

procedure TPerspectiveCameraNode_1.CreateNode;
begin
  inherited;

  FFdHeightAngle := TSFFloat.Create(Self, True, 'heightAngle', Pi/4);
   FdHeightAngle.ChangeAlways := chVisibleNonGeometry;
   FdHeightAngle.MustBeNonnegative := true;
  AddField(FFdHeightAngle);
end;

{$endif read_implementation}
