{ -*- buffer-read-only: t -*-

  Copyright 2015-2022 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated node properties.

  Do not edit this file manually!
  To add new properties:
  - add them to the text files in tools/internal/x3d-nodes-to-pascal/nodes-specification/ ,
  - and regenerate include files by running x3d-nodes-to-pascal }

{$ifdef read_interface}

  strict private
    function GetAnchorPoint: TVector3;
    procedure SetAnchorPoint(const Value: TVector3);
    function GetAxis: TVector3;
    procedure SetAxis(const Value: TVector3);
    function GetMaxAngle: Single;
    procedure SetMaxAngle(const Value: Single);
    function GetMinAngle: Single;
    procedure SetMinAngle(const Value: Single);
    function GetStopBounce: Single;
    procedure SetStopBounce(const Value: Single);
    function GetStopErrorCorrection: Single;
    procedure SetStopErrorCorrection(const Value: Single);
  public
    procedure CreateNode; override;
    class function ClassX3DType: string; override;

    strict private FFdAnchorPoint: TSFVec3f;
    { Internal wrapper for property @link(AnchorPoint). This wrapper API may change, we advise to access simpler @link(AnchorPoint) instead. }
    public property FdAnchorPoint: TSFVec3f read FFdAnchorPoint;
    {  }
    property AnchorPoint: TVector3 read GetAnchorPoint write SetAnchorPoint;

    strict private FFdAxis: TSFVec3f;
    { Internal wrapper for property @link(Axis). This wrapper API may change, we advise to access simpler @link(Axis) instead. }
    public property FdAxis: TSFVec3f read FFdAxis;
    {  }
    property Axis: TVector3 read GetAxis write SetAxis;

    strict private FFdMaxAngle: TSFFloat;
    { Internal wrapper for property @link(MaxAngle). This wrapper API may change, we advise to access simpler @link(MaxAngle) instead. }
    public property FdMaxAngle: TSFFloat read FFdMaxAngle;
    {  }
    property MaxAngle: Single read GetMaxAngle write SetMaxAngle;

    strict private FFdMinAngle: TSFFloat;
    { Internal wrapper for property @link(MinAngle). This wrapper API may change, we advise to access simpler @link(MinAngle) instead. }
    public property FdMinAngle: TSFFloat read FFdMinAngle;
    {  }
    property MinAngle: Single read GetMinAngle write SetMinAngle;

    strict private FFdStopBounce: TSFFloat;
    { Internal wrapper for property @link(StopBounce). This wrapper API may change, we advise to access simpler @link(StopBounce) instead. }
    public property FdStopBounce: TSFFloat read FFdStopBounce;
    {  }
    property StopBounce: Single read GetStopBounce write SetStopBounce;

    strict private FFdStopErrorCorrection: TSFFloat;
    { Internal wrapper for property @link(StopErrorCorrection). This wrapper API may change, we advise to access simpler @link(StopErrorCorrection) instead. }
    public property FdStopErrorCorrection: TSFFloat read FFdStopErrorCorrection;
    {  }
    property StopErrorCorrection: Single read GetStopErrorCorrection write SetStopErrorCorrection;

    strict private FEventAngle: TSFFloatEvent;
    {  }
    public property EventAngle: TSFFloatEvent read FEventAngle;

    strict private FEventAngleRate: TSFFloatEvent;
    {  }
    public property EventAngleRate: TSFFloatEvent read FEventAngleRate;

    strict private FEventBody1AnchorPoint: TSFVec3fEvent;
    {  }
    public property EventBody1AnchorPoint: TSFVec3fEvent read FEventBody1AnchorPoint;

    strict private FEventBody2AnchorPoint: TSFVec3fEvent;
    {  }
    public property EventBody2AnchorPoint: TSFVec3fEvent read FEventBody2AnchorPoint;

{$endif read_interface}

{$ifdef read_implementation}

{ TSingleAxisHingeJointNode ----------------------------------------------- }

function TSingleAxisHingeJointNode.GetAnchorPoint: TVector3;
begin
  Result := FdAnchorPoint.Value;
end;

procedure TSingleAxisHingeJointNode.SetAnchorPoint(const Value: TVector3);
begin
  FdAnchorPoint.Send(Value);
end;

function TSingleAxisHingeJointNode.GetAxis: TVector3;
begin
  Result := FdAxis.Value;
end;

procedure TSingleAxisHingeJointNode.SetAxis(const Value: TVector3);
begin
  FdAxis.Send(Value);
end;

function TSingleAxisHingeJointNode.GetMaxAngle: Single;
begin
  Result := FdMaxAngle.Value;
end;

procedure TSingleAxisHingeJointNode.SetMaxAngle(const Value: Single);
begin
  FdMaxAngle.Send(Value);
end;

function TSingleAxisHingeJointNode.GetMinAngle: Single;
begin
  Result := FdMinAngle.Value;
end;

procedure TSingleAxisHingeJointNode.SetMinAngle(const Value: Single);
begin
  FdMinAngle.Send(Value);
end;

function TSingleAxisHingeJointNode.GetStopBounce: Single;
begin
  Result := FdStopBounce.Value;
end;

procedure TSingleAxisHingeJointNode.SetStopBounce(const Value: Single);
begin
  FdStopBounce.Send(Value);
end;

function TSingleAxisHingeJointNode.GetStopErrorCorrection: Single;
begin
  Result := FdStopErrorCorrection.Value;
end;

procedure TSingleAxisHingeJointNode.SetStopErrorCorrection(const Value: Single);
begin
  FdStopErrorCorrection.Send(Value);
end;

class function TSingleAxisHingeJointNode.ClassX3DType: String;
begin
  Result := 'SingleAxisHingeJoint';
end;

procedure TSingleAxisHingeJointNode.CreateNode;
begin
  inherited;

  FFdAnchorPoint := TSFVec3f.Create(Self, True, 'anchorPoint', Vector3(0, 0, 0));
   FdAnchorPoint.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdAnchorPoint);

  FFdAxis := TSFVec3f.Create(Self, True, 'axis', Vector3(0, 0, 0));
   FdAxis.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdAxis);

  FFdMaxAngle := TSFFloat.Create(Self, True, 'maxAngle', Pi);
   FdMaxAngle.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdMaxAngle);

  FFdMinAngle := TSFFloat.Create(Self, True, 'minAngle', -Pi);
   FdMinAngle.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdMinAngle);

  FFdStopBounce := TSFFloat.Create(Self, True, 'stopBounce', 0);
   FdStopBounce.ChangeAlways := chVisibleNonGeometry;
   FdStopBounce.MustBeNonnegative := true;
  AddField(FFdStopBounce);

  FFdStopErrorCorrection := TSFFloat.Create(Self, True, 'stopErrorCorrection', 0.8);
   FdStopErrorCorrection.ChangeAlways := chVisibleNonGeometry;
   FdStopErrorCorrection.MustBeNonnegative := true;
  AddField(FFdStopErrorCorrection);

  FEventAngle := TSFFloatEvent.Create(Self, 'angle', false);
  AddEvent(FEventAngle);

  FEventAngleRate := TSFFloatEvent.Create(Self, 'angleRate', false);
  AddEvent(FEventAngleRate);

  FEventBody1AnchorPoint := TSFVec3fEvent.Create(Self, 'body1AnchorPoint', false);
  AddEvent(FEventBody1AnchorPoint);

  FEventBody2AnchorPoint := TSFVec3fEvent.Create(Self, 'body2AnchorPoint', false);
  AddEvent(FEventBody2AnchorPoint);
end;

{$endif read_implementation}
