{ -*- buffer-read-only: t -*-

  Copyright 2015-2022 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated node properties.

  Do not edit this file manually!
  To add new properties:
  - add them to the text files in tools/internal/x3d-nodes-to-pascal/nodes-specification/ ,
  - and regenerate include files by running x3d-nodes-to-pascal }

{$ifdef read_interface}

  strict private
    function GetDeletionAllowed: Boolean;
    procedure SetDeletionAllowed(const Value: Boolean);
  public
    procedure CreateNode; override;
    class function ClassX3DType: string; override;

    strict private FFdDeletionAllowed: TSFBool;
    { Internal wrapper for property @link(DeletionAllowed). This wrapper API may change, we advise to access simpler @link(DeletionAllowed) instead. }
    public property FdDeletionAllowed: TSFBool read FFdDeletionAllowed;
    {  }
    property DeletionAllowed: Boolean read GetDeletionAllowed write SetDeletionAllowed;

    strict private FEventEnteredText: TSFStringEvent;
    {  }
    public property EventEnteredText: TSFStringEvent read FEventEnteredText;

    strict private FEventFinalText: TSFStringEvent;
    {  }
    public property EventFinalText: TSFStringEvent read FEventFinalText;

{$endif read_interface}

{$ifdef read_implementation}

{ TStringSensorNode ----------------------------------------------- }

function TStringSensorNode.GetDeletionAllowed: Boolean;
begin
  Result := FdDeletionAllowed.Value;
end;

procedure TStringSensorNode.SetDeletionAllowed(const Value: Boolean);
begin
  FdDeletionAllowed.Send(Value);
end;

class function TStringSensorNode.ClassX3DType: String;
begin
  Result := 'StringSensor';
end;

procedure TStringSensorNode.CreateNode;
begin
  inherited;

  FFdDeletionAllowed := TSFBool.Create(Self, True, 'deletionAllowed', true);
   FdDeletionAllowed.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdDeletionAllowed);

  FEventEnteredText := TSFStringEvent.Create(Self, 'enteredText', false);
  AddEvent(FEventEnteredText);

  FEventFinalText := TSFStringEvent.Create(Self, 'finalText', false);
  AddEvent(FEventFinalText);
end;

{$endif read_implementation}
