{ -*- buffer-read-only: t -*-

  Copyright 2015-2024 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated node properties.

  Do not edit this file manually!
  To add new properties:
  - add them to the text files in tools/internal/x3d-nodes-to-pascal/nodes-specification/ ,
  - and regenerate include files by running x3d-nodes-to-pascal }

{$ifdef read_interface}

  strict private
    function GetScaleFactor: TVector3;
    procedure SetScaleFactor(const Value: TVector3);
  public
    { Create node fields and events. }
    procedure CreateNode; override;
    class function ClassX3DType: String; override;
    class function ForVRMLVersion(const Version: TX3DVersion): Boolean; override;

    strict private FFdScaleFactor: TSFVec3f;
    { Internal wrapper for property @code(ScaleFactor). This wrapper API may change, we advise to access simpler @code(ScaleFactor) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdScaleFactor: TSFVec3f read FFdScaleFactor;
    {  }
    property ScaleFactor: TVector3 read GetScaleFactor write SetScaleFactor;

{$endif read_interface}

{$ifdef read_implementation}

{ TScaleNode_1 ----------------------------------------------- }

function TScaleNode_1.GetScaleFactor: TVector3;
begin
  Result := FdScaleFactor.Value;
end;

procedure TScaleNode_1.SetScaleFactor(const Value: TVector3);
begin
  FdScaleFactor.Send(Value);
end;

class function TScaleNode_1.ForVRMLVersion(const Version: TX3DVersion): Boolean;
begin
  Result := Version.Major <= 1; // parse this node only in VRML 1.0 and Inventor files
end;

class function TScaleNode_1.ClassX3DType: String;
begin
  Result := 'Scale';
end;

procedure TScaleNode_1.CreateNode;
begin
  inherited;

  FFdScaleFactor := TSFVec3f.Create(Self, True, 'scaleFactor', Vector3(1, 1, 1));
   FdScaleFactor.ChangeAlways := chEverything;
  AddField(FFdScaleFactor);
end;

{$endif read_implementation}
