/*
** (c) 1996-2000 The Regents of the University of California (through
** E.O. Lawrence Berkeley National Laboratory), subject to approval by
** the U.S. Department of Energy.  Your use of this software is under
** license -- the license agreement is attached and included in the
** directory as license.txt or you may contact Berkeley Lab's Technology
** Transfer Department at TTD@lbl.gov.  NOTICE OF U.S. GOVERNMENT RIGHTS.
** The Software was developed under funding from the U.S. Government
** which consequently retains certain rights as follows: the
** U.S. Government has been granted for itself and others acting on its
** behalf a paid-up, nonexclusive, irrevocable, worldwide license in the
** Software to reproduce, prepare derivative works, and perform publicly
** and display publicly.  Beginning five (5) years after the date
** permission to assert copyright is obtained from the U.S. Department of
** Energy, and subject to any subsequent five (5) year renewals, the
** U.S. Government is granted for itself and others acting on its behalf
** a paid-up, nonexclusive, irrevocable, worldwide license in the
** Software to reproduce, prepare derivative works, distribute copies to
** the public, perform publicly and display publicly, and to permit
** others to do so.
*/

#include "REAL.H"
#include "CONSTANTS.H"
#include "BCTypes.H"

#define DIMS lo_1,lo_2,lo_3,hi_1,hi_2,hi_3

#if BL_USE_FLOAT
#define threehalves    1.5e0
#else
#define threehalves    1.5d0
#endif

c *************************************************************************
c ** SETSCALBC **
c ** Impose the physical boundary conditions on scalars s
c *************************************************************************

      subroutine setscalbc(s,DIMS,bcx_lo,bcx_hi,bcy_lo,bcy_hi,bcz_lo,bcz_hi,
     $                     which_scal,dx,time)

      implicit none

      integer DIMS
      integer which_scal
      integer bcx_lo,bcx_hi
      integer bcy_lo,bcy_hi
      integer bcz_lo,bcz_hi
      REAL_T  dx(3)
      REAL_T  time
      REAL_T  s(lo_1-1:hi_1+1,lo_2-1:hi_2+1,lo_3-1:hi_3+1)

c     Local variables
      integer is,ie,js,je,ks,ke,i,j,k

      is = lo_1
      ie = hi_1
      js = lo_2
      je = hi_2
      ks = lo_3
      ke = hi_3

      if (bcz_lo .eq. PERIODIC) then
        do j = js,je 
        do i = is,ie 
          s(i,j,ks-1) = s(i,j,ke)
        enddo
        enddo

      elseif (bcz_lo .eq. WALL) then

c     NOTE: THESE VALUES ARE DEFINED ON THE EDGE OF THE PHYSICAL BOUNDARY,
c           NOT IN THE GHOST CELL

        do j = js,je 
        do i = is,ie 
c         s(i,j,ks-1) = threehalves*s(i,j,ks) - half*s(i,j,ks+1)
          s(i,j,ks-1) = s(i,j,ks)
        enddo
        enddo

      elseif (bcz_lo .eq. INLET) then

        call scalinflow(s,DIMS,time,2,0,which_scal)

      elseif (bcz_lo .eq. OUTLET) then

        do j = js,je 
        do i = is,ie 
c         s(i,j,ks-1) = threehalves*s(i,j,ks) - half*s(i,j,ks+1)
          s(i,j,ks-1) = s(i,j,ks)
        enddo
        enddo

      else
        print *,'bogus bcz_lo in setscalbc ',bcz_lo
        stop
      endif

      if (bcz_hi .eq. PERIODIC) then
        do j = js,je 
        do i = is,ie 
          s(i,j,ke+1) = s(i,j,ks)
        enddo
        enddo

      elseif (bcz_hi .eq. WALL) then

c     NOTE: THESE VALUES ARE DEFINED ON THE EDGE OF THE PHYSICAL BOUNDARY,
c           NOT IN THE GHOST CELL

        do j = js,je 
        do i = is,ie 
c         s(i,j,ke+1) = threehalves*s(i,j,ke) - half*s(i,j,ke-1)
          s(i,j,ke+1) = s(i,j,ke)
        enddo
        enddo

      elseif (bcz_hi .eq. INLET) then

        call scalinflow(s,DIMS,time,2,1,which_scal)

      elseif (bcz_hi .eq. OUTLET) then

        do j = js,je 
        do i = is,ie 
c         s(i,j,ke+1) = threehalves*s(i,j,ke) - half*s(i,j,ke-1)
          s(i,j,ke+1) = s(i,j,ke)
        enddo
        enddo

      else
        print *,'bogus bcz_hi in setscalbc ',bcz_hi
        stop
      endif

      if (bcy_lo .eq. PERIODIC) then
        do k = ks-1,ke+1
        do i = is,ie 
          s(i,js-1,k)=s(i,je,k)
        enddo
        enddo

      elseif (bcy_lo .eq. WALL) then

c     NOTE: THESE VALUES ARE DEFINED ON THE EDGE OF THE PHYSICAL BOUNDARY,
c           NOT IN THE GHOST CELL
        do k = ks-1,ke+1
        do i = is,ie 
c         s(i,js-1,k) = threehalves*s(i,js,k) - half*s(i,js+1,k)
          s(i,js-1,k) = s(i,js,k)
        enddo
        enddo

      elseif (bcy_lo .eq. INLET) then

        call scalinflow(s,DIMS,time,1,0,which_scal)

      elseif (bcy_lo .eq. OUTLET) then

        do k = ks-1,ke+1
        do i = is,ie 
c         s(i,js-1,k) = threehalves*s(i,js,k) - half*s(i,js+1,k)
          s(i,js-1,k) = s(i,js,k)
        enddo
        enddo

      else

        print *,'bogus bcy_lo in setscalbc ',bcy_lo
        stop

      endif

      if (bcy_hi .eq. PERIODIC) then
        do k = ks-1,ke+1
        do i = is,ie 
          s(i,je+1,k)=s(i,js,k)
        enddo
        enddo

      elseif (bcy_hi .eq. WALL) then

c     NOTE: THESE VALUES ARE DEFINED ON THE EDGE OF THE PHYSICAL BOUNDARY,
c           NOT IN THE GHOST CELL
        do k = ks-1,ke+1
        do i = is,ie 
c         s(i,je+1,k) = threehalves*s(i,je,k) - half*s(i,je-1,k)
          s(i,je+1,k) = s(i,je,k)
        enddo
        enddo

      elseif (bcy_hi .eq. INLET) then

        call scalinflow(s,DIMS,time,1,1,which_scal)

      elseif (bcy_hi .eq. OUTLET) then

        do k = ks-1,ke+1
        do i = is,ie 
c         s(i,je+1,k) = threehalves*s(i,je,k) - half*s(i,je-1,k)
          s(i,je+1,k) = s(i,je,k)
        enddo
        enddo

      else

        print *,'bogus bcy_hi in setscalbc ',bcy_hi
        stop

      endif

      if (bcx_lo .eq. PERIODIC) then
        do k = ks-1,ke+1 
        do j = js-1,je+1 
          s(is-1,j,k) = s(ie,j,k)
        enddo
        enddo

      elseif (bcx_lo .eq. WALL) then

c     NOTE: THESE VALUES ARE DEFINED ON THE EDGE OF THE PHYSICAL BOUNDARY,
c           NOT IN THE GHOST CELL

        do k = ks-1,ke+1 
        do j = js-1,je+1 
c         s(is-1,j,k) = threehalves*s(is,j,k) - half*s(is+1,j,k)
          s(is-1,j,k) = s(is,j,k)
        enddo
        enddo

      elseif (bcx_lo .eq. INLET) then

        call scalinflow(s,DIMS,time,0,0,which_scal)

      elseif (bcx_lo .eq. OUTLET) then

        do k = ks-1,ke+1 
        do j = js-1,je+1 
c         s(is-1,j,k) = threehalves*s(is,j,k) - half*s(is+1,j,k)
          s(is-1,j,k) = s(is,j,k)
        enddo
        enddo

      else
        print *,'bogus bcx_lo in setscalbc ',bcx_lo
        stop
      endif

      if (bcx_hi .eq. PERIODIC) then
        do k = ks-1,ke+1 
        do j = js-1,je+1 
          s(ie+1,j,k) = s(is,j,k)
        enddo
        enddo

      elseif (bcx_hi .eq. WALL) then

c     NOTE: THESE VALUES ARE DEFINED ON THE EDGE OF THE PHYSICAL BOUNDARY,
c           NOT IN THE GHOST CELL

        do k = ks-1,ke+1 
        do j = js-1,je+1 
c         s(ie+1,j,k) = threehalves*s(ie,j,k) - half*s(ie-1,j,k)
          s(ie+1,j,k) = s(ie,j,k)
        enddo
        enddo

      elseif (bcx_hi .eq. INLET) then

        call scalinflow(s,DIMS,time,0,1,which_scal)

      elseif (bcx_hi .eq. OUTLET) then

        do k = ks-1,ke+1 
        do j = js-1,je+1 
c         s(ie+1,j,k) = threehalves*s(ie,j,k) - half*s(ie-1,j,k)
          s(ie+1,j,k) = s(ie,j,k)
        enddo
        enddo

      else
        print *,'bogus bcx_hi in setscalbc ',bcx_hi
        stop
      endif

      return
      end
