#ifndef H_CDW_UDF
#define H_CDW_UDF

#include <inttypes.h>

#include "main.h"


/* These values don't include ending NUL character. */
#define CDW_UDF_LVID_LEN_MAX  126  /* "Logical Volume Identifier" */
#define CDW_UDF_VID_LEN_MAX    30  /* "Volume Identifier" */
#define CDW_UDF_VSID_LEN_MAX  126  /* "Volume Set Identifier" */
#define CDW_UDF_FSID_LEN_MAX   30  /* "File Set Identifier" */




/* Options related to creating UDF file system. */
typedef struct {
	uint64_t volume_size_bytes;  /* This field won't be saved to config file. */

	cdw_id_t mkudffs_blocksize;
	cdw_id_t mkudffs_udfrev;
	cdw_id_t mkudffs_strategy;
	cdw_id_t mkudffs_spartable;
	cdw_id_t mkudffs_media_type;
	cdw_id_t mkudffs_space;
	cdw_id_t mkudffs_ad;
	bool     mkudffs_noefe;
	cdw_id_t mkudffs_encoding;

	char mkudffs_other_options[CDW_MKUDFFS_OTHER_OPTIONS_LEN_MAX + 1]; /* Other mkudffs options, not specified by other fields. */

	char mkudffs_lvid[CDW_UDF_LVID_LEN_MAX + 1];  /* Logical Volume Identifier. */
	char mkudffs_vid[CDW_UDF_VID_LEN_MAX + 1];    /* Volume Identifier. */
	char mkudffs_vsid[CDW_UDF_VSID_LEN_MAX + 1];  /* Volume Set Identifier. */
	char mkudffs_fsid[CDW_UDF_FSID_LEN_MAX + 1];  /* File Set Identifier. */

	char rsync_options[CDW_RSYNC_OPTIONS_LEN_MAX + 1];
	char *mount_point;
} cdw_udf_t;


cdw_rv_t cdw_udf_copy(cdw_udf_t *target, cdw_udf_t *source);
cdw_rv_t cdw_udf_init(cdw_udf_t *udf);
cdw_rv_t cdw_udf_set_defaults(cdw_udf_t *udf);
cdw_rv_t cdw_udf_clean(cdw_udf_t *udf);
void     cdw_udf_debug_print_options(cdw_udf_t *udf);


#endif /* #ifndef H_CDW_UDF */
