/* Generated from posixunix.scm by the CHICKEN compiler
   http://www.call-cc.org
   2017-02-19 13:16
   Version 4.12.0 (rev 6ea24b6)
   linux-unix-gnu-x86-64 [ 64bit manyargs ptables ]
   compiled 2017-02-19 on yves.more-magic.net (Linux)
   command line: posixunix.scm -optimize-level 2 -include-path . -include-path ./ -inline -ignore-repository -feature chicken-bootstrap -no-warnings -specialize -types ./types.db -explicit-use -no-trace -output-file posixunix.c
   unit: posix
*/

#include "chicken.h"


#include <signal.h>
#include <errno.h>

#include <sys/stat.h>

static int C_not_implemented(void);
int C_not_implemented() { return -1; }

#define C_curdir(buf)       (getcwd(C_c_string(buf), 1024) ? C_fix(strlen(C_c_string(buf))) : C_SCHEME_FALSE)

static C_TLS struct stat C_statbuf;

#define C_stat_type         (C_statbuf.st_mode & S_IFMT)
#define C_stat(fn)          C_fix(stat((char *)C_data_pointer(fn), &C_statbuf))
#define C_fstat(f)          C_fix(fstat(C_unfix(f), &C_statbuf))

#ifndef S_IFSOCK
# define S_IFSOCK           0140000
#endif

#define cpy_tmvec_to_tmstc08(ptm, v) \
    ((ptm)->tm_sec = C_unfix(C_block_item((v), 0)), \
    (ptm)->tm_min = C_unfix(C_block_item((v), 1)), \
    (ptm)->tm_hour = C_unfix(C_block_item((v), 2)), \
    (ptm)->tm_mday = C_unfix(C_block_item((v), 3)), \
    (ptm)->tm_mon = C_unfix(C_block_item((v), 4)), \
    (ptm)->tm_year = C_unfix(C_block_item((v), 5)), \
    (ptm)->tm_wday = C_unfix(C_block_item((v), 6)), \
    (ptm)->tm_yday = C_unfix(C_block_item((v), 7)), \
    (ptm)->tm_isdst = (C_block_item((v), 8) != C_SCHEME_FALSE))

#define cpy_tmvec_to_tmstc9(ptm, v) \
    (((struct tm *)ptm)->tm_gmtoff = -C_unfix(C_block_item((v), 9)))

#define C_tm_set_08(v, tm)  cpy_tmvec_to_tmstc08( (tm), (v) )
#define C_tm_set_9(v, tm)   cpy_tmvec_to_tmstc9( (tm), (v) )

static struct tm *
C_tm_set( C_word v, void *tm )
{
  C_tm_set_08( v, (struct tm *)tm );
#if defined(C_GNU_ENV) && !defined(__CYGWIN__) && !defined(__uClinux__)
  C_tm_set_9( v, (struct tm *)tm );
#endif
  return tm;
}

#define TIME_STRING_MAXLENGTH 255
static char C_time_string [TIME_STRING_MAXLENGTH + 1];
#undef TIME_STRING_MAXLENGTH

#define C_strftime(v, f, tm) \
        (strftime(C_time_string, sizeof(C_time_string), C_c_string(f), C_tm_set((v), (tm))) ? C_time_string : NULL)
#define C_a_mktime(ptr, c, v, tm)  C_flonum(ptr, mktime(C_tm_set((v), C_data_pointer(tm))))
#define C_asctime(v, tm)    (asctime(C_tm_set((v), (tm))))

#define C_fdopen(a, n, fd, m) C_mpointer(a, fdopen(C_unfix(fd), C_c_string(m)))
#define C_C_fileno(p)       C_fix(fileno(C_port_file(p)))
#define C_dup(x)            C_fix(dup(C_unfix(x)))
#define C_dup2(x, y)        C_fix(dup2(C_unfix(x), C_unfix(y)))

#define C_set_file_ptr(port, ptr)  (C_set_block_item(port, 0, (C_block_item(ptr, 0))), C_SCHEME_UNDEFINED)

#define C_opendir(x,h)      C_set_block_item(h, 0, (C_word) opendir(C_c_string(x)))
#define C_closedir(h)       (closedir((DIR *)C_block_item(h, 0)), C_SCHEME_UNDEFINED)
#define C_readdir(h,e)      C_set_block_item(e, 0, (C_word) readdir((DIR *)C_block_item(h, 0)))
#define C_foundfile(e,b,l)    (C_strlcpy(C_c_string(b), ((struct dirent *) C_block_item(e, 0))->d_name, l), C_fix(strlen(((struct dirent *) C_block_item(e, 0))->d_name)))

/* It is assumed that 'int' is-a 'long' */
#define C_ftell(p)          C_fix(ftell(C_port_file(p)))
#define C_fseek(p, n, w)    C_mk_nbool(fseek(C_port_file(p), C_num_to_int(n), C_unfix(w)))
#define C_lseek(fd, o, w)     C_fix(lseek(C_unfix(fd), C_unfix(o), C_unfix(w)))

#ifdef HAVE_SETENV
# define C_unsetenv(s)      (unsetenv((char *)C_data_pointer(s)), C_SCHEME_TRUE)
# define C_setenv(x, y)     C_fix(setenv((char *)C_data_pointer(x), (char *)C_data_pointer(y), 1))
#else
# if defined(_WIN32) && !defined(__CYGWIN__)
#  define C_unsetenv(s)      C_setenv(s, C_SCHEME_FALSE)
# else
#  define C_unsetenv(s)      C_fix(putenv((char *)C_data_pointer(s)))
# endif
static C_word C_fcall C_setenv(C_word x, C_word y) {
  char *sx = C_c_string(x),
       *sy = (y == C_SCHEME_FALSE ? "" : C_c_string(y));
  int n1 = C_strlen(sx), n2 = C_strlen(sy);
  int buf_len = n1 + n2 + 2;
  char *buf = (char *)C_malloc(buf_len);
  if(buf == NULL) return(C_fix(0));
  else {
    C_strlcpy(buf, sx, buf_len);
    C_strlcat(buf, "=", buf_len);
    C_strlcat(buf, sy, buf_len);
    return(C_fix(putenv(buf)));
  }
}
#endif

#ifndef S_IFLNK
#define S_IFLNK S_IFREG
#endif

#ifndef S_IFREG
#define S_IFREG S_IFREG
#endif

#ifndef S_IFDIR
#define S_IFDIR S_IFREG
#endif

#ifndef S_IFCHR
#define S_IFCHR S_IFREG
#endif

#ifndef S_IFBLK
#define S_IFBLK S_IFREG
#endif

#ifndef S_IFSOCK
#define S_IFSOCK S_IFREG
#endif

#ifndef S_IFIFO
#define S_IFIFO S_IFREG
#endif

static C_TLS int C_wait_status;

#include <sys/time.h>
#include <sys/wait.h>
#include <sys/utsname.h>
#include <sys/ioctl.h>
#include <fcntl.h>
#include <dirent.h>
#include <pwd.h>
#include <utime.h>

#if defined(__sun) && defined(__SVR4)
# include <sys/tty.h>
# include <termios.h>
#endif

#ifdef HAVE_GRP_H
#include <grp.h>
#endif

#include <sys/mman.h>
#include <sys/poll.h>

#ifndef O_FSYNC
# define O_FSYNC O_SYNC
#endif

#ifndef PIPE_BUF
# ifdef __CYGWIN__
#  define PIPE_BUF       _POSIX_PIPE_BUF
# else
#  define PIPE_BUF 1024
# endif
#endif

#ifndef O_BINARY
# define O_BINARY        0
#endif
#ifndef O_TEXT
# define O_TEXT          0
#endif

#ifndef MAP_FILE
# define MAP_FILE    0
#endif

#ifndef MAP_ANON
# define MAP_ANON    0
#endif

#if defined(HAVE_CRT_EXTERNS_H)
# include <crt_externs.h>
# define C_getenventry(i)       ((*_NSGetEnviron())[ i ])
#elif defined(C_MACOSX)
# define C_getenventry(i)       NULL
#else
extern char **environ;
# define C_getenventry(i)       (environ[ i ])
#endif

#ifndef FILENAME_MAX
# define FILENAME_MAX          1024
#endif

static C_TLS struct utsname C_utsname;
static C_TLS struct flock C_flock;
static C_TLS DIR *temphandle;
static C_TLS struct passwd *C_user;
#ifdef HAVE_GRP_H
static C_TLS struct group *C_group;
#else
static C_TLS struct {
  char *gr_name, gr_passwd;
  int gr_gid;
  char *gr_mem[ 1 ];
} C_group = { "", "", 0, { "" } };
#endif

/* Android doesn't provide pw_gecos in the passwd struct */
#ifdef __ANDROID__
# define C_PW_GECOS ("")
#else
# define C_PW_GECOS (C_user->pw_gecos)
#endif

static C_TLS int C_pipefds[ 2 ];
static C_TLS time_t C_secs;
static C_TLS struct timeval C_timeval;
static C_TLS char C_hostbuf[ 256 ];
static C_TLS struct stat C_statbuf;

#define C_mkdir(str)        C_fix(mkdir(C_c_string(str), S_IRWXU | S_IRWXG | S_IRWXO))
#define C_fchdir(fd)        C_fix(fchdir(C_unfix(fd)))
#define C_chdir(str)        C_fix(chdir(C_c_string(str)))
#define C_rmdir(str)        C_fix(rmdir(C_c_string(str)))

#define open_binary_input_pipe(a, n, name)   C_mpointer(a, popen(C_c_string(name), "r"))
#define open_text_input_pipe(a, n, name)     open_binary_input_pipe(a, n, name)
#define open_binary_output_pipe(a, n, name)  C_mpointer(a, popen(C_c_string(name), "w"))
#define open_text_output_pipe(a, n, name)    open_binary_output_pipe(a, n, name)
#define close_pipe(p)                        C_fix(pclose(C_port_file(p)))

#define C_fork              fork
#define C_waitpid(id, o)    C_fix(waitpid(C_unfix(id), &C_wait_status, C_unfix(o)))
#define C_getppid           getppid
#define C_kill(id, s)       C_fix(kill(C_unfix(id), C_unfix(s)))
#define C_getuid            getuid
#define C_getgid            getgid
#define C_geteuid           geteuid
#define C_getegid           getegid
#define C_chown(fn, u, g)   C_fix(chown(C_data_pointer(fn), C_unfix(u), C_unfix(g)))
#define C_chmod(fn, m)      C_fix(chmod(C_data_pointer(fn), C_unfix(m)))
#define C_setuid(id)        C_fix(setuid(C_unfix(id)))
#define C_setgid(id)        C_fix(setgid(C_unfix(id)))
#define C_seteuid(id)       C_fix(seteuid(C_unfix(id)))
#define C_setegid(id)       C_fix(setegid(C_unfix(id)))
#define C_setsid(dummy)     C_fix(setsid())
#define C_setpgid(x, y)     C_fix(setpgid(C_unfix(x), C_unfix(y)))
#define C_getpgid(x)        C_fix(getpgid(C_unfix(x)))
#define C_symlink(o, n)     C_fix(symlink(C_data_pointer(o), C_data_pointer(n)))
#define C_do_readlink(f, b)    C_fix(readlink(C_data_pointer(f), C_data_pointer(b), FILENAME_MAX))
#define C_getpwnam(n)       C_mk_bool((C_user = getpwnam((char *)C_data_pointer(n))) != NULL)
#define C_getpwuid(u)       C_mk_bool((C_user = getpwuid(C_unfix(u))) != NULL)
#if !defined(__ANDROID__) && defined(HAVE_GRP_H)
#define C_getgrnam(n)       C_mk_bool((C_group = getgrnam((char *)C_data_pointer(n))) != NULL)
#define C_getgrgid(u)       C_mk_bool((C_group = getgrgid(C_unfix(u))) != NULL)
#else
#define C_getgrnam(n)       C_SCHEME_FALSE
#define C_getgrgid(n)       C_SCHEME_FALSE
#endif
#define C_pipe(d)           C_fix(pipe(C_pipefds))
#define C_truncate(f, n)    C_fix(truncate((char *)C_data_pointer(f), C_num_to_int(n)))
#define C_ftruncate(f, n)   C_fix(ftruncate(C_unfix(f), C_num_to_int(n)))
#define C_uname             C_fix(uname(&C_utsname))
#define C_alarm             alarm
#define C_setvbuf(p, m, s)  C_fix(setvbuf(C_port_file(p), NULL, C_unfix(m), C_unfix(s)))
#define C_test_access(fn, m)     C_fix(access((char *)C_data_pointer(fn), C_unfix(m)))
#define C_close(fd)         C_fix(close(C_unfix(fd)))
#define C_sleep             sleep
#define C_umask(m)          C_fix(umask(C_unfix(m)))

#define C_lstat(fn)         C_fix(lstat((char *)C_data_pointer(fn), &C_statbuf))

#define C_u_i_execvp(f,a)   C_fix(execvp(C_data_pointer(f), (char *const *)C_c_pointer_vector_or_null(a)))
#define C_u_i_execve(f,a,e) C_fix(execve(C_data_pointer(f), (char *const *)C_c_pointer_vector_or_null(a), (char *const *)C_c_pointer_vector_or_null(e)))

#if defined(__FreeBSD__) || defined(C_MACOSX) || defined(__NetBSD__) || defined(__OpenBSD__) || defined(__sgi__) || defined(sgi) || defined(__DragonFly__) || defined(__SUNPRO_C)
static C_TLS int C_uw;
# define C_WIFEXITED(n)      (C_uw = C_unfix(n), C_mk_bool(WIFEXITED(C_uw)))
# define C_WIFSIGNALED(n)    (C_uw = C_unfix(n), C_mk_bool(WIFSIGNALED(C_uw)))
# define C_WIFSTOPPED(n)     (C_uw = C_unfix(n), C_mk_bool(WIFSTOPPED(C_uw)))
# define C_WEXITSTATUS(n)    (C_uw = C_unfix(n), C_fix(WEXITSTATUS(C_uw)))
# define C_WTERMSIG(n)       (C_uw = C_unfix(n), C_fix(WTERMSIG(C_uw)))
# define C_WSTOPSIG(n)       (C_uw = C_unfix(n), C_fix(WSTOPSIG(C_uw)))
#else
# define C_WIFEXITED(n)      C_mk_bool(WIFEXITED(C_unfix(n)))
# define C_WIFSIGNALED(n)    C_mk_bool(WIFSIGNALED(C_unfix(n)))
# define C_WIFSTOPPED(n)     C_mk_bool(WIFSTOPPED(C_unfix(n)))
# define C_WEXITSTATUS(n)    C_fix(WEXITSTATUS(C_unfix(n)))
# define C_WTERMSIG(n)       C_fix(WTERMSIG(C_unfix(n)))
# define C_WSTOPSIG(n)       C_fix(WSTOPSIG(C_unfix(n)))
#endif

#ifdef __CYGWIN__
# define C_mkfifo(fn, m)    C_fix(-1);
#else
# define C_mkfifo(fn, m)    C_fix(mkfifo((char *)C_data_pointer(fn), C_unfix(m)))
#endif

#define C_flock_setup(t, s, n) (C_flock.l_type = C_unfix(t), C_flock.l_start = C_num_to_int(s), C_flock.l_whence = SEEK_SET, C_flock.l_len = C_num_to_int(n), C_SCHEME_UNDEFINED)
#define C_flock_test(p)     (fcntl(fileno(C_port_file(p)), F_GETLK, &C_flock) >= 0 ? (C_flock.l_type == F_UNLCK ? C_fix(0) : C_fix(C_flock.l_pid)) : C_SCHEME_FALSE)
#define C_flock_lock(p)     C_fix(fcntl(fileno(C_port_file(p)), F_SETLK, &C_flock))
#define C_flock_lockw(p)    C_fix(fcntl(fileno(C_port_file(p)), F_SETLKW, &C_flock))

static C_TLS sigset_t C_sigset;
#define C_sigemptyset(d)    (sigemptyset(&C_sigset), C_SCHEME_UNDEFINED)
#define C_sigaddset(s)      (sigaddset(&C_sigset, C_unfix(s)), C_SCHEME_UNDEFINED)
#define C_sigdelset(s)      (sigdelset(&C_sigset, C_unfix(s)), C_SCHEME_UNDEFINED)
#define C_sigismember(s)    C_mk_bool(sigismember(&C_sigset, C_unfix(s)))
#define C_sigprocmask_set(d)        C_fix(sigprocmask(SIG_SETMASK, &C_sigset, NULL))
#define C_sigprocmask_block(d)      C_fix(sigprocmask(SIG_BLOCK, &C_sigset, NULL))
#define C_sigprocmask_unblock(d)    C_fix(sigprocmask(SIG_UNBLOCK, &C_sigset, NULL))
#define C_sigprocmask_get(d)        C_fix(sigprocmask(SIG_SETMASK, NULL, &C_sigset))

#define C_open(fn, fl, m)   C_fix(open(C_c_string(fn), C_unfix(fl), C_unfix(m)))
#define C_read(fd, b, n)    C_fix(read(C_unfix(fd), C_data_pointer(b), C_unfix(n)))
#define C_write(fd, b, n)   C_fix(write(C_unfix(fd), C_data_pointer(b), C_unfix(n)))
#define C_mkstemp(t)        C_fix(mkstemp(C_c_string(t)))

#define C_ctime(n)          (C_secs = (n), ctime(&C_secs))

#if defined(__SVR4) || defined(C_MACOSX) || defined(__ANDROID__) || defined(_AIX)
/* Seen here: http://lists.samba.org/archive/samba-technical/2002-November/025571.html */

static time_t C_timegm(struct tm *t)
{
  time_t tl, tb;
  struct tm *tg;

  tl = mktime (t);
  if (tl == -1)
    {
      t->tm_hour--;
      tl = mktime (t);
      if (tl == -1)
        return -1; /* can't deal with output from strptime */
      tl += 3600;
    }
  tg = gmtime (&tl);
  tg->tm_isdst = 0;
  tb = mktime (tg);
  if (tb == -1)
    {
      tg->tm_hour--;
      tb = mktime (tg);
      if (tb == -1)
        return -1; /* can't deal with output from gmtime */
      tb += 3600;
    }
  return (tl - (tb - tl));
}
#else
#define C_timegm timegm
#endif

#define C_a_timegm(ptr, c, v, tm)  C_flonum(ptr, C_timegm(C_tm_set((v), C_data_pointer(tm))))

#ifdef __linux__
extern char *strptime(const char *s, const char *format, struct tm *tm);
extern pid_t getpgid(pid_t pid);
#endif

/* tm_get could be in posix-common, but it's only used in here */
#define cpy_tmstc08_to_tmvec(v, ptm) \
    (C_set_block_item((v), 0, C_fix(((struct tm *)ptm)->tm_sec)), \
    C_set_block_item((v), 1, C_fix((ptm)->tm_min)), \
    C_set_block_item((v), 2, C_fix((ptm)->tm_hour)), \
    C_set_block_item((v), 3, C_fix((ptm)->tm_mday)), \
    C_set_block_item((v), 4, C_fix((ptm)->tm_mon)), \
    C_set_block_item((v), 5, C_fix((ptm)->tm_year)), \
    C_set_block_item((v), 6, C_fix((ptm)->tm_wday)), \
    C_set_block_item((v), 7, C_fix((ptm)->tm_yday)), \
    C_set_block_item((v), 8, ((ptm)->tm_isdst ? C_SCHEME_TRUE : C_SCHEME_FALSE)))

#define cpy_tmstc9_to_tmvec(v, ptm) \
    (C_set_block_item((v), 9, C_fix(-(ptm)->tm_gmtoff)))

#define C_tm_get_08(v, tm)  cpy_tmstc08_to_tmvec( (v), (tm) )
#define C_tm_get_9(v, tm)   cpy_tmstc9_to_tmvec( (v), (tm) )

static C_word
C_tm_get( C_word v, void *tm )
{
  C_tm_get_08( v, (struct tm *)tm );
#if defined(C_GNU_ENV) && !defined(__CYGWIN__) && !defined(__uClinux__)
  C_tm_get_9( v, (struct tm *)tm );
#endif
  return v;
}

#define C_strptime(s, f, v, stm) \
        (strptime(C_c_string(s), C_c_string(f), ((struct tm *)(stm))) ? C_tm_get((v), (stm)) : C_SCHEME_FALSE)

static gid_t *C_groups = NULL;

#define C_get_gid(n)      C_fix(C_groups[ C_unfix(n) ])
#define C_set_gid(n, id)  (C_groups[ C_unfix(n) ] = C_unfix(id), C_SCHEME_UNDEFINED)
#define C_set_groups(n)   C_fix(setgroups(C_unfix(n), C_groups))

#if !defined(__ANDROID__) && defined(TIOCGWINSZ)
static int get_tty_size(int p, int *rows, int *cols)
{
 struct winsize tty_size;
 int r;

 memset(&tty_size, 0, sizeof tty_size);

 r = ioctl(p, TIOCGWINSZ, &tty_size);
 if (r == 0) {
    *rows = tty_size.ws_row;
    *cols = tty_size.ws_col;
 }
 return r;
}
#else
static int get_tty_size(int p, int *rows, int *cols)
{
 *rows = *cols = 0;
 return -1;
}
#endif

static int set_file_mtime(char *filename, C_word tm)
{
  struct utimbuf tb;

  tb.actime = tb.modtime = C_num_to_int(tm);
  return utime(filename, &tb);
}

static C_word C_i_fifo_p(C_word name) 
{
  struct stat buf;
  int res;

  res = stat(C_c_string(name), &buf);

  if(res != 0) {
#ifdef __CYGWIN__
    return C_SCHEME_FALSE;
#else
    if(errno == ENOENT) return C_fix(0);
    else return C_fix(res);
#endif
  }

  if((buf.st_mode & S_IFMT) == S_IFIFO) return C_SCHEME_TRUE;
  else return C_SCHEME_FALSE;
}


static C_PTABLE_ENTRY *create_ptable(void);
C_noret_decl(C_scheduler_toplevel)
C_externimport void C_ccall C_scheduler_toplevel(C_word c,C_word *av) C_noret;
C_noret_decl(C_irregex_toplevel)
C_externimport void C_ccall C_irregex_toplevel(C_word c,C_word *av) C_noret;
C_noret_decl(C_extras_toplevel)
C_externimport void C_ccall C_extras_toplevel(C_word c,C_word *av) C_noret;
C_noret_decl(C_files_toplevel)
C_externimport void C_ccall C_files_toplevel(C_word c,C_word *av) C_noret;
C_noret_decl(C_ports_toplevel)
C_externimport void C_ccall C_ports_toplevel(C_word c,C_word *av) C_noret;
C_noret_decl(C_lolevel_toplevel)
C_externimport void C_ccall C_lolevel_toplevel(C_word c,C_word *av) C_noret;

static C_TLS C_word lf[470];
static double C_possibly_force_alignment;
static C_char C_TLS li0[] C_aligned={C_lihdr(0,0,41),40,112,111,115,105,120,45,101,114,114,111,114,32,116,121,112,101,55,49,32,108,111,99,55,50,32,109,115,103,55,51,32,46,32,97,114,103,115,55,52,41,0,0,0,0,0,0,0};
static C_char C_TLS li1[] C_aligned={C_lihdr(0,0,38),40,35,35,115,121,115,35,115,116,97,116,32,102,105,108,101,56,54,32,108,105,110,107,56,55,32,101,114,114,56,56,32,108,111,99,56,57,41,0,0};
static C_char C_TLS li2[] C_aligned={C_lihdr(0,0,28),40,102,105,108,101,45,115,116,97,116,32,102,49,48,49,32,46,32,116,109,112,49,48,48,49,48,50,41,0,0,0,0};
static C_char C_TLS li3[] C_aligned={C_lihdr(0,0,23),40,102,105,108,101,45,97,99,99,101,115,115,45,116,105,109,101,32,102,49,50,55,41,0};
static C_char C_TLS li4[] C_aligned={C_lihdr(0,0,23),40,102,105,108,101,45,99,104,97,110,103,101,45,116,105,109,101,32,102,49,51,48,41,0};
static C_char C_TLS li5[] C_aligned={C_lihdr(0,0,17),40,102,105,108,101,45,111,119,110,101,114,32,102,49,51,51,41,0,0,0,0,0,0,0};
static C_char C_TLS li6[] C_aligned={C_lihdr(0,0,23),40,102,105,108,101,45,112,101,114,109,105,115,115,105,111,110,115,32,102,49,51,54,41,0};
static C_char C_TLS li7[] C_aligned={C_lihdr(0,0,16),40,102,105,108,101,45,115,105,122,101,32,102,49,51,57,41};
static C_char C_TLS li8[] C_aligned={C_lihdr(0,0,31),40,102,105,108,101,45,116,121,112,101,32,102,105,108,101,49,52,54,32,46,32,116,109,112,49,52,53,49,52,55,41,0};
static C_char C_TLS li9[] C_aligned={C_lihdr(0,0,23),40,114,101,103,117,108,97,114,45,102,105,108,101,63,32,102,105,108,101,49,54,53,41,0};
static C_char C_TLS li10[] C_aligned={C_lihdr(0,0,24),40,115,121,109,98,111,108,105,99,45,108,105,110,107,63,32,102,105,108,101,49,54,55,41};
static C_char C_TLS li11[] C_aligned={C_lihdr(0,0,23),40,98,108,111,99,107,45,100,101,118,105,99,101,63,32,102,105,108,101,49,54,57,41,0};
static C_char C_TLS li12[] C_aligned={C_lihdr(0,0,27),40,99,104,97,114,97,99,116,101,114,45,100,101,118,105,99,101,63,32,102,105,108,101,49,55,49,41,0,0,0,0,0};
static C_char C_TLS li13[] C_aligned={C_lihdr(0,0,16),40,102,95,50,57,53,49,32,102,105,108,101,49,55,51,41};
static C_char C_TLS li14[] C_aligned={C_lihdr(0,0,17),40,115,111,99,107,101,116,63,32,102,105,108,101,49,55,53,41,0,0,0,0,0,0,0};
static C_char C_TLS li15[] C_aligned={C_lihdr(0,0,20),40,100,105,114,101,99,116,111,114,121,63,32,102,105,108,101,49,55,55,41,0,0,0,0};
static C_char C_TLS li16[] C_aligned={C_lihdr(0,0,47),40,115,101,116,45,102,105,108,101,45,112,111,115,105,116,105,111,110,33,32,112,111,114,116,49,56,50,32,112,111,115,49,56,51,32,46,32,119,104,101,110,99,101,49,56,52,41,0};
static C_char C_TLS li17[] C_aligned={C_lihdr(0,0,25),40,109,111,100,101,32,105,110,112,50,48,54,32,109,50,48,55,32,108,111,99,50,48,56,41,0,0,0,0,0,0,0};
static C_char C_TLS li18[] C_aligned={C_lihdr(0,0,32),40,99,104,101,99,107,32,108,111,99,50,50,48,32,102,100,50,50,49,32,105,110,112,50,50,50,32,114,50,50,51,41};
static C_char C_TLS li19[] C_aligned={C_lihdr(0,0,31),40,111,112,101,110,45,105,110,112,117,116,45,102,105,108,101,42,32,102,100,50,50,54,32,46,32,109,50,50,55,41,0};
static C_char C_TLS li20[] C_aligned={C_lihdr(0,0,32),40,111,112,101,110,45,111,117,116,112,117,116,45,102,105,108,101,42,32,102,100,50,50,57,32,46,32,109,50,51,48,41};
static C_char C_TLS li21[] C_aligned={C_lihdr(0,0,22),40,112,111,114,116,45,62,102,105,108,101,110,111,32,112,111,114,116,50,51,54,41,0,0};
static C_char C_TLS li22[] C_aligned={C_lihdr(0,0,34),40,100,117,112,108,105,99,97,116,101,45,102,105,108,101,110,111,32,111,108,100,50,52,53,32,46,32,110,101,119,50,52,54,41,0,0,0,0,0,0};
static C_char C_TLS li23[] C_aligned={C_lihdr(0,0,31),40,99,117,114,114,101,110,116,45,100,105,114,101,99,116,111,114,121,32,46,32,116,109,112,50,53,54,50,53,55,41,0};
static C_char C_TLS li24[] C_aligned={C_lihdr(0,0,14),40,114,109,100,105,114,32,100,105,114,50,56,51,41,0,0};
static C_char C_TLS li25[] C_aligned={C_lihdr(0,0,11),40,103,50,56,57,32,102,50,57,56,41,0,0,0,0,0};
static C_char C_TLS li26[] C_aligned={C_lihdr(0,0,26),40,102,111,114,45,101,97,99,104,45,108,111,111,112,50,56,56,32,103,50,57,53,51,48,54,41,0,0,0,0,0,0};
static C_char C_TLS li27[] C_aligned={C_lihdr(0,0,38),40,100,101,108,101,116,101,45,100,105,114,101,99,116,111,114,121,32,110,97,109,101,50,55,53,32,46,32,116,109,112,50,55,52,50,55,54,41,0,0};
static C_char C_TLS li28[] C_aligned={C_lihdr(0,0,13),40,108,111,111,112,32,100,105,114,51,50,57,41,0,0,0};
static C_char C_TLS li29[] C_aligned={C_lihdr(0,0,7),40,97,51,51,56,50,41,0};
static C_char C_TLS li30[] C_aligned={C_lihdr(0,0,47),40,97,51,51,56,56,32,100,105,114,51,51,55,51,51,56,51,52,51,32,102,105,108,101,51,51,57,51,52,48,51,52,52,32,101,120,116,51,52,49,51,52,50,51,52,53,41,0};
static C_char C_TLS li31[] C_aligned={C_lihdr(0,0,38),40,99,114,101,97,116,101,45,100,105,114,101,99,116,111,114,121,32,110,97,109,101,51,49,56,32,46,32,116,109,112,51,49,55,51,49,57,41,0,0};
static C_char C_TLS li32[] C_aligned={C_lihdr(0,0,6),40,108,111,111,112,41,0,0};
static C_char C_TLS li33[] C_aligned={C_lihdr(0,0,23),40,100,105,114,101,99,116,111,114,121,32,46,32,116,109,112,51,53,57,51,54,48,41,0};
static C_char C_TLS li34[] C_aligned={C_lihdr(0,0,7),40,97,51,53,56,57,41,0};
static C_char C_TLS li35[] C_aligned={C_lihdr(0,0,11),40,103,52,50,50,32,109,52,50,52,41,0,0,0,0,0};
static C_char C_TLS li36[] C_aligned={C_lihdr(0,0,13),40,108,111,111,112,32,102,110,115,52,49,53,41,0,0,0};
static C_char C_TLS li37[] C_aligned={C_lihdr(0,0,46),40,97,51,53,57,53,32,100,105,114,51,57,56,51,57,57,52,48,52,32,102,105,108,52,48,48,52,48,49,52,48,53,32,101,120,116,52,48,50,52,48,51,52,48,54,41,0,0};
static C_char C_TLS li38[] C_aligned={C_lihdr(0,0,20),40,99,111,110,99,45,108,111,111,112,32,112,97,116,104,115,51,57,54,41,0,0,0,0};
static C_char C_TLS li39[] C_aligned={C_lihdr(0,0,17),40,103,108,111,98,32,46,32,112,97,116,104,115,51,57,52,41,0,0,0,0,0,0,0};
static C_char C_TLS li40[] C_aligned={C_lihdr(0,0,7),40,97,51,55,54,50,41,0};
static C_char C_TLS li41[] C_aligned={C_lihdr(0,0,7),40,97,51,55,54,55,41,0};
static C_char C_TLS li42[] C_aligned={C_lihdr(0,0,7),40,97,51,55,56,55,41,0};
static C_char C_TLS li43[] C_aligned={C_lihdr(0,0,24),40,108,111,111,112,32,100,105,114,52,53,49,32,102,115,52,53,50,32,114,52,53,51,41};
static C_char C_TLS li44[] C_aligned={C_lihdr(0,0,13),40,102,95,51,56,51,51,32,120,52,52,57,41,0,0,0};
static C_char C_TLS li45[] C_aligned={C_lihdr(0,0,15),40,102,95,51,56,52,57,32,46,32,95,52,52,54,41,0};
static C_char C_TLS li46[] C_aligned={C_lihdr(0,0,15),40,102,95,51,56,52,49,32,46,32,95,52,52,53,41,0};
static C_char C_TLS li47[] C_aligned={C_lihdr(0,0,7),40,97,51,56,55,56,41,0};
static C_char C_TLS li48[] C_aligned={C_lihdr(0,0,7),40,97,51,56,56,49,41,0};
static C_char C_TLS li49[] C_aligned={C_lihdr(0,0,7),40,97,51,56,56,52,41,0};
static C_char C_TLS li50[] C_aligned={C_lihdr(0,0,7),40,97,51,56,56,55,41,0};
static C_char C_TLS li51[] C_aligned={C_lihdr(0,0,18),40,102,95,51,56,57,51,32,120,52,56,56,32,121,52,56,57,41,0,0,0,0,0,0};
static C_char C_TLS li52[] C_aligned={C_lihdr(0,0,7),40,97,51,56,57,48,41,0};
static C_char C_TLS li53[] C_aligned={C_lihdr(0,0,15),40,102,95,51,57,48,49,32,46,32,95,52,56,54,41,0};
static C_char C_TLS li54[] C_aligned={C_lihdr(0,0,7),40,97,51,56,57,56,41,0};
static C_char C_TLS li55[] C_aligned={C_lihdr(0,0,31),40,102,105,110,100,45,102,105,108,101,115,32,100,105,114,52,56,51,32,46,32,116,109,112,52,56,50,52,56,52,41,0};
static C_char C_TLS li56[] C_aligned={C_lihdr(0,0,32),40,99,104,101,99,107,45,116,105,109,101,45,118,101,99,116,111,114,32,108,111,99,53,49,52,32,116,109,53,49,53,41};
static C_char C_TLS li57[] C_aligned={C_lihdr(0,0,33),40,115,101,99,111,110,100,115,45,62,108,111,99,97,108,45,116,105,109,101,32,46,32,116,109,112,53,50,49,53,50,50,41,0,0,0,0,0,0,0};
static C_char C_TLS li58[] C_aligned={C_lihdr(0,0,31),40,115,101,99,111,110,100,115,45,62,117,116,99,45,116,105,109,101,32,46,32,116,109,112,53,51,51,53,51,52,41,0};
static C_char C_TLS li59[] C_aligned={C_lihdr(0,0,29),40,115,101,99,111,110,100,115,45,62,115,116,114,105,110,103,32,46,32,116,109,112,53,53,49,53,53,50,41,0,0,0};
static C_char C_TLS li60[] C_aligned={C_lihdr(0,0,27),40,108,111,99,97,108,45,116,105,109,101,45,62,115,101,99,111,110,100,115,32,116,109,53,54,51,41,0,0,0,0,0};
static C_char C_TLS li61[] C_aligned={C_lihdr(0,0,32),40,116,105,109,101,45,62,115,116,114,105,110,103,32,116,109,53,57,53,32,46,32,116,109,112,53,57,52,53,57,54,41};
static C_char C_TLS li62[] C_aligned={C_lihdr(0,0,22),40,115,101,116,101,110,118,32,118,97,114,54,48,57,32,118,97,108,54,49,48,41,0,0};
static C_char C_TLS li63[] C_aligned={C_lihdr(0,0,17),40,117,110,115,101,116,101,110,118,32,118,97,114,54,49,53,41,0,0,0,0,0,0,0};
static C_char C_TLS li64[] C_aligned={C_lihdr(0,0,11),40,115,99,97,110,32,106,54,50,57,41,0,0,0,0,0};
static C_char C_TLS li65[] C_aligned={C_lihdr(0,0,11),40,108,111,111,112,32,105,54,50,54,41,0,0,0,0,0};
static C_char C_TLS li66[] C_aligned={C_lihdr(0,0,27),40,103,101,116,45,101,110,118,105,114,111,110,109,101,110,116,45,118,97,114,105,97,98,108,101,115,41,0,0,0,0,0};
static C_char C_TLS li67[] C_aligned={C_lihdr(0,0,36),40,115,101,116,45,115,105,103,110,97,108,45,104,97,110,100,108,101,114,33,32,115,105,103,54,51,51,32,112,114,111,99,54,51,52,41,0,0,0,0};
static C_char C_TLS li68[] C_aligned={C_lihdr(0,0,20),40,99,117,114,114,101,110,116,45,112,114,111,99,101,115,115,45,105,100,41,0,0,0,0};
static C_char C_TLS li69[] C_aligned={C_lihdr(0,0,7),40,97,52,50,55,51,41,0};
static C_char C_TLS li70[] C_aligned={C_lihdr(0,0,33),40,97,52,50,55,57,32,101,112,105,100,54,53,56,32,101,110,111,114,109,54,53,57,32,101,99,111,100,101,54,54,48,41,0,0,0,0,0,0,0};
static C_char C_TLS li71[] C_aligned={C_lihdr(0,0,24),40,112,114,111,99,101,115,115,45,119,97,105,116,32,46,32,97,114,103,115,54,52,51,41};
static C_char C_TLS li72[] C_aligned={C_lihdr(0,0,7),40,97,52,51,52,56,41,0};
static C_char C_TLS li73[] C_aligned={C_lihdr(0,0,14),40,97,52,51,52,50,32,101,120,110,54,56,49,41,0,0};
static C_char C_TLS li74[] C_aligned={C_lihdr(0,0,22),40,100,111,108,111,111,112,54,56,51,32,115,108,54,56,53,32,105,54,56,54,41,0,0};
static C_char C_TLS li75[] C_aligned={C_lihdr(0,0,10),40,116,109,112,49,50,53,57,52,41,0,0,0,0,0,0};
static C_char C_TLS li76[] C_aligned={C_lihdr(0,0,7),40,97,52,52,50,50,41,0};
static C_char C_TLS li77[] C_aligned={C_lihdr(0,0,21),40,116,109,112,50,50,53,57,53,32,97,114,103,115,54,55,53,54,57,55,41,0,0,0};
static C_char C_TLS li78[] C_aligned={C_lihdr(0,0,7),40,97,52,51,53,55,41,0};
static C_char C_TLS li79[] C_aligned={C_lihdr(0,0,15),40,97,52,51,51,54,32,107,54,55,52,54,56,48,41,0};
static C_char C_TLS li80[] C_aligned={C_lihdr(0,0,56),40,108,105,115,116,45,62,99,45,115,116,114,105,110,103,45,98,117,102,102,101,114,32,115,116,114,105,110,103,45,108,105,115,116,54,54,57,32,99,111,110,118,101,114,116,54,55,48,32,108,111,99,54,55,49,41};
static C_char C_TLS li81[] C_aligned={C_lihdr(0,0,16),40,100,111,108,111,111,112,55,48,50,32,105,55,48,52,41};
static C_char C_TLS li82[] C_aligned={C_lihdr(0,0,38),40,102,114,101,101,45,99,45,115,116,114,105,110,103,45,98,117,102,102,101,114,32,98,117,102,102,101,114,45,97,114,114,97,121,55,48,48,41,0,0};
static C_char C_TLS li83[] C_aligned={C_lihdr(0,0,10),40,110,111,112,32,120,55,49,49,41,0,0,0,0,0,0};
static C_char C_TLS li84[] C_aligned={C_lihdr(0,0,7),40,97,52,53,48,53,41,0};
static C_char C_TLS li85[] C_aligned={C_lihdr(0,0,14),40,97,52,52,57,57,32,101,120,110,55,50,57,41,0,0};
static C_char C_TLS li86[] C_aligned={C_lihdr(0,0,7),40,97,52,53,50,54,41,0};
static C_char C_TLS li87[] C_aligned={C_lihdr(0,0,7),40,97,52,53,52,57,41,0};
static C_char C_TLS li88[] C_aligned={C_lihdr(0,0,20),40,97,52,53,52,51,32,46,32,97,114,103,115,55,50,51,55,51,51,41,0,0,0,0};
static C_char C_TLS li89[] C_aligned={C_lihdr(0,0,7),40,97,52,53,50,48,41,0};
static C_char C_TLS li90[] C_aligned={C_lihdr(0,0,15),40,97,52,52,57,51,32,107,55,50,50,55,50,56,41,0};
static C_char C_TLS li91[] C_aligned={C_lihdr(0,0,81),40,99,97,108,108,45,119,105,116,104,45,101,120,101,99,45,97,114,103,115,32,108,111,99,55,49,50,32,102,105,108,101,110,97,109,101,55,49,51,32,97,114,103,99,111,110,118,55,49,52,32,97,114,103,108,105,115,116,55,49,53,32,101,110,118,108,105,115,116,55,49,54,32,112,114,111,99,55,49,55,41,0,0,0,0,0,0,0};
static C_char C_TLS li92[] C_aligned={C_lihdr(0,0,34),40,35,35,115,121,115,35,102,105,108,101,45,110,111,110,98,108,111,99,107,105,110,103,33,32,102,100,55,56,55,55,57,48,41,0,0,0,0,0,0};
static C_char C_TLS li93[] C_aligned={C_lihdr(0,0,33),40,35,35,115,121,115,35,102,105,108,101,45,115,101,108,101,99,116,45,111,110,101,32,105,110,116,55,57,50,55,57,53,41,0,0,0,0,0,0,0};
static C_char C_TLS li94[] C_aligned={C_lihdr(0,0,39),40,102,105,108,101,45,99,111,110,116,114,111,108,32,102,100,56,52,54,32,99,109,100,56,52,55,32,46,32,116,109,112,56,52,53,56,52,56,41,0};
static C_char C_TLS li95[] C_aligned={C_lihdr(0,0,42),40,102,105,108,101,45,111,112,101,110,32,102,105,108,101,110,97,109,101,56,53,57,32,102,108,97,103,115,56,54,48,32,46,32,109,111,100,101,56,54,49,41,0,0,0,0,0,0};
static C_char C_TLS li96[] C_aligned={C_lihdr(0,0,6),40,108,111,111,112,41,0,0};
static C_char C_TLS li97[] C_aligned={C_lihdr(0,0,18),40,102,105,108,101,45,99,108,111,115,101,32,102,100,56,54,57,41,0,0,0,0,0,0};
static C_char C_TLS li98[] C_aligned={C_lihdr(0,0,37),40,102,105,108,101,45,114,101,97,100,32,102,100,56,55,56,32,115,105,122,101,56,55,57,32,46,32,98,117,102,102,101,114,56,56,48,41,0,0,0};
static C_char C_TLS li99[] C_aligned={C_lihdr(0,0,38),40,102,105,108,101,45,119,114,105,116,101,32,102,100,56,56,57,32,98,117,102,102,101,114,56,57,48,32,46,32,115,105,122,101,56,57,49,41,0,0};
static C_char C_TLS li100[] C_aligned={C_lihdr(0,0,26),40,102,105,108,101,45,109,107,115,116,101,109,112,32,116,101,109,112,108,97,116,101,57,48,48,41,0,0,0,0,0,0};
static C_char C_TLS li101[] C_aligned={C_lihdr(0,0,20),40,100,111,108,111,111,112,57,50,56,32,102,100,115,114,108,57,51,49,41,0,0,0,0};
static C_char C_TLS li102[] C_aligned={C_lihdr(0,0,20),40,100,111,108,111,111,112,57,52,54,32,102,100,115,119,108,57,52,57,41,0,0,0,0};
static C_char C_TLS li103[] C_aligned={C_lihdr(0,0,26),40,108,112,32,105,49,48,48,51,32,114,101,115,49,48,48,52,32,102,100,115,49,48,48,53,41,0,0,0,0,0,0};
static C_char C_TLS li104[] C_aligned={C_lihdr(0,0,23),40,108,112,32,105,57,56,52,32,114,101,115,57,56,53,32,102,100,115,57,56,54,41,0};
static C_char C_TLS li105[] C_aligned={C_lihdr(0,0,42),40,102,105,108,101,45,115,101,108,101,99,116,32,102,100,115,114,57,48,55,32,102,100,115,119,57,48,56,32,46,32,116,105,109,101,111,117,116,57,48,57,41,0,0,0,0,0,0};
static C_char C_TLS li106[] C_aligned={C_lihdr(0,0,27),40,99,104,97,110,103,101,45,100,105,114,101,99,116,111,114,121,32,110,97,109,101,49,48,50,57,41,0,0,0,0,0};
static C_char C_TLS li107[] C_aligned={C_lihdr(0,0,26),40,99,104,97,110,103,101,45,100,105,114,101,99,116,111,114,121,42,32,102,100,49,48,51,52,41,0,0,0,0,0,0};
static C_char C_TLS li108[] C_aligned={C_lihdr(0,0,37),40,99,104,101,99,107,32,108,111,99,49,48,52,50,32,99,109,100,49,48,52,51,32,105,110,112,49,48,52,52,32,114,49,48,52,53,41,0,0,0};
static C_char C_TLS li109[] C_aligned={C_lihdr(0,0,33),40,111,112,101,110,45,105,110,112,117,116,45,112,105,112,101,32,99,109,100,49,48,52,56,32,46,32,109,49,48,52,57,41,0,0,0,0,0,0,0};
static C_char C_TLS li110[] C_aligned={C_lihdr(0,0,34),40,111,112,101,110,45,111,117,116,112,117,116,45,112,105,112,101,32,99,109,100,49,48,53,56,32,46,32,109,49,48,53,57,41,0,0,0,0,0,0};
static C_char C_TLS li111[] C_aligned={C_lihdr(0,0,27),40,99,108,111,115,101,45,105,110,112,117,116,45,112,105,112,101,32,112,111,114,116,49,48,54,56,41,0,0,0,0,0};
static C_char C_TLS li112[] C_aligned={C_lihdr(0,0,28),40,99,108,111,115,101,45,111,117,116,112,117,116,45,112,105,112,101,32,112,111,114,116,49,48,55,50,41,0,0,0,0};
static C_char C_TLS li113[] C_aligned={C_lihdr(0,0,7),40,97,53,51,57,51,41,0};
static C_char C_TLS li114[] C_aligned={C_lihdr(0,0,21),40,97,53,51,57,57,32,46,32,114,101,115,117,108,116,115,49,48,56,55,41,0,0,0};
static C_char C_TLS li115[] C_aligned={C_lihdr(0,0,50),40,99,97,108,108,45,119,105,116,104,45,105,110,112,117,116,45,112,105,112,101,32,99,109,100,49,48,56,51,32,112,114,111,99,49,48,56,52,32,46,32,109,111,100,101,49,48,56,53,41,0,0,0,0,0,0};
static C_char C_TLS li116[] C_aligned={C_lihdr(0,0,7),40,97,53,52,49,55,41,0};
static C_char C_TLS li117[] C_aligned={C_lihdr(0,0,21),40,97,53,52,50,51,32,46,32,114,101,115,117,108,116,115,49,48,57,52,41,0,0,0};
static C_char C_TLS li118[] C_aligned={C_lihdr(0,0,51),40,99,97,108,108,45,119,105,116,104,45,111,117,116,112,117,116,45,112,105,112,101,32,99,109,100,49,48,57,48,32,112,114,111,99,49,48,57,49,32,46,32,109,111,100,101,49,48,57,50,41,0,0,0,0,0};
static C_char C_TLS li119[] C_aligned={C_lihdr(0,0,7),40,97,53,52,52,49,41,0};
static C_char C_TLS li120[] C_aligned={C_lihdr(0,0,21),40,97,53,52,53,50,32,46,32,114,101,115,117,108,116,115,49,49,48,57,41,0,0,0};
static C_char C_TLS li121[] C_aligned={C_lihdr(0,0,7),40,97,53,52,52,54,41,0};
static C_char C_TLS li122[] C_aligned={C_lihdr(0,0,7),40,97,53,52,54,49,41,0};
static C_char C_TLS li123[] C_aligned={C_lihdr(0,0,51),40,119,105,116,104,45,105,110,112,117,116,45,102,114,111,109,45,112,105,112,101,32,99,109,100,49,48,57,55,32,116,104,117,110,107,49,48,57,56,32,46,32,109,111,100,101,49,48,57,57,41,0,0,0,0,0};
static C_char C_TLS li124[] C_aligned={C_lihdr(0,0,7),40,97,53,52,55,53,41,0};
static C_char C_TLS li125[] C_aligned={C_lihdr(0,0,21),40,97,53,52,56,54,32,46,32,114,101,115,117,108,116,115,49,49,50,54,41,0,0,0};
static C_char C_TLS li126[] C_aligned={C_lihdr(0,0,7),40,97,53,52,56,48,41,0};
static C_char C_TLS li127[] C_aligned={C_lihdr(0,0,7),40,97,53,52,57,53,41,0};
static C_char C_TLS li128[] C_aligned={C_lihdr(0,0,50),40,119,105,116,104,45,111,117,116,112,117,116,45,116,111,45,112,105,112,101,32,99,109,100,49,49,49,52,32,116,104,117,110,107,49,49,49,53,32,46,32,109,111,100,101,49,49,49,54,41,0,0,0,0,0,0};
static C_char C_TLS li129[] C_aligned={C_lihdr(0,0,13),40,99,114,101,97,116,101,45,112,105,112,101,41,0,0,0};
static C_char C_TLS li130[] C_aligned={C_lihdr(0,0,19),40,102,111,114,45,101,97,99,104,45,108,111,111,112,49,49,54,52,41,0,0,0,0,0};
static C_char C_TLS li131[] C_aligned={C_lihdr(0,0,27),40,115,101,116,45,115,105,103,110,97,108,45,109,97,115,107,33,32,115,105,103,115,49,49,54,49,41,0,0,0,0,0};
static C_char C_TLS li132[] C_aligned={C_lihdr(0,0,24),40,115,105,103,110,97,108,45,109,97,115,107,101,100,63,32,115,105,103,49,49,57,50,41};
static C_char C_TLS li133[] C_aligned={C_lihdr(0,0,22),40,115,105,103,110,97,108,45,109,97,115,107,33,32,115,105,103,49,49,57,54,41,0,0};
static C_char C_TLS li134[] C_aligned={C_lihdr(0,0,24),40,115,105,103,110,97,108,45,117,110,109,97,115,107,33,32,115,105,103,49,50,48,49,41};
static C_char C_TLS li135[] C_aligned={C_lihdr(0,0,20),40,115,121,115,116,101,109,45,105,110,102,111,114,109,97,116,105,111,110,41,0,0,0,0};
static C_char C_TLS li136[] C_aligned={C_lihdr(0,0,41),40,117,115,101,114,45,105,110,102,111,114,109,97,116,105,111,110,32,117,115,101,114,49,50,51,51,32,46,32,116,109,112,49,50,51,50,49,50,51,52,41,0,0,0,0,0,0,0};
static C_char C_TLS li137[] C_aligned={C_lihdr(0,0,19),40,99,117,114,114,101,110,116,45,117,115,101,114,45,110,97,109,101,41,0,0,0,0,0};
static C_char C_TLS li138[] C_aligned={C_lihdr(0,0,29),40,99,117,114,114,101,110,116,45,101,102,102,101,99,116,105,118,101,45,117,115,101,114,45,110,97,109,101,41,0,0,0};
static C_char C_TLS li139[] C_aligned={C_lihdr(0,0,12),40,108,111,111,112,32,105,49,50,55,49,41,0,0,0,0};
static C_char C_TLS li140[] C_aligned={C_lihdr(0,0,43),40,103,114,111,117,112,45,105,110,102,111,114,109,97,116,105,111,110,32,103,114,111,117,112,49,50,53,56,32,46,32,116,109,112,49,50,53,55,49,50,53,57,41,0,0,0,0,0};
static C_char C_TLS li141[] C_aligned={C_lihdr(0,0,12),40,108,111,111,112,32,105,49,50,57,48,41,0,0,0,0};
static C_char C_TLS li142[] C_aligned={C_lihdr(0,0,12),40,103,101,116,45,103,114,111,117,112,115,41,0,0,0,0};
static C_char C_TLS li143[] C_aligned={C_lihdr(0,0,26),40,100,111,108,111,111,112,49,50,57,55,32,108,115,116,49,50,57,57,32,105,49,51,48,48,41,0,0,0,0,0,0};
static C_char C_TLS li144[] C_aligned={C_lihdr(0,0,22),40,115,101,116,45,103,114,111,117,112,115,33,32,108,115,116,48,49,50,57,54,41,0,0};
static C_char C_TLS li145[] C_aligned={C_lihdr(0,0,35),40,105,110,105,116,105,97,108,105,122,101,45,103,114,111,117,112,115,32,117,115,101,114,49,51,49,55,32,105,100,49,51,49,56,41,0,0,0,0,0};
static C_char C_TLS li146[] C_aligned={C_lihdr(0,0,34),40,99,104,97,110,103,101,45,102,105,108,101,45,109,111,100,101,32,102,110,97,109,101,49,51,54,50,32,109,49,51,54,51,41,0,0,0,0,0,0};
static C_char C_TLS li147[] C_aligned={C_lihdr(0,0,42),40,99,104,97,110,103,101,45,102,105,108,101,45,111,119,110,101,114,32,102,110,49,51,54,55,32,117,105,100,49,51,54,56,32,103,105,100,49,51,54,57,41,0,0,0,0,0,0};
static C_char C_TLS li148[] C_aligned={C_lihdr(0,0,36),40,99,104,101,99,107,32,102,105,108,101,110,97,109,101,49,51,55,52,32,97,99,99,49,51,55,53,32,108,111,99,49,51,55,54,41,0,0,0,0};
static C_char C_TLS li149[] C_aligned={C_lihdr(0,0,32),40,102,105,108,101,45,114,101,97,100,45,97,99,99,101,115,115,63,32,102,105,108,101,110,97,109,101,49,51,56,48,41};
static C_char C_TLS li150[] C_aligned={C_lihdr(0,0,33),40,102,105,108,101,45,119,114,105,116,101,45,97,99,99,101,115,115,63,32,102,105,108,101,110,97,109,101,49,51,56,49,41,0,0,0,0,0,0,0};
static C_char C_TLS li151[] C_aligned={C_lihdr(0,0,35),40,102,105,108,101,45,101,120,101,99,117,116,101,45,97,99,99,101,115,115,63,32,102,105,108,101,110,97,109,101,49,51,56,50,41,0,0,0,0,0};
static C_char C_TLS li152[] C_aligned={C_lihdr(0,0,16),40,99,114,101,97,116,101,45,115,101,115,115,105,111,110,41};
static C_char C_TLS li153[] C_aligned={C_lihdr(0,0,38),40,99,114,101,97,116,101,45,115,121,109,98,111,108,105,99,45,108,105,110,107,32,111,108,100,49,52,48,50,32,110,101,119,49,52,48,51,41,0,0};
static C_char C_TLS li154[] C_aligned={C_lihdr(0,0,49),40,35,35,115,121,115,35,114,101,97,100,45,115,121,109,98,111,108,105,99,45,108,105,110,107,32,102,110,97,109,101,49,52,48,56,32,108,111,99,97,116,105,111,110,49,52,48,57,41,0,0,0,0,0,0,0};
static C_char C_TLS li155[] C_aligned={C_lihdr(0,0,7),40,97,54,50,51,54,41,0};
static C_char C_TLS li156[] C_aligned={C_lihdr(0,0,32),40,108,111,111,112,32,99,111,109,112,111,110,101,110,116,115,49,52,50,55,32,114,101,115,117,108,116,49,52,50,56,41};
static C_char C_TLS li157[] C_aligned={C_lihdr(0,0,67),40,97,54,50,52,50,32,98,97,115,101,45,111,114,105,103,105,110,49,52,50,51,32,98,97,115,101,45,100,105,114,101,99,116,111,114,121,49,52,50,52,32,100,105,114,101,99,116,111,114,121,45,99,111,109,112,111,110,101,110,116,115,49,52,50,53,41,0,0,0,0,0};
static C_char C_TLS li158[] C_aligned={C_lihdr(0,0,44),40,114,101,97,100,45,115,121,109,98,111,108,105,99,45,108,105,110,107,32,102,110,97,109,101,49,52,49,54,32,46,32,116,109,112,49,52,49,53,49,52,49,55,41,0,0,0,0};
static C_char C_TLS li159[] C_aligned={C_lihdr(0,0,27),40,102,105,108,101,45,108,105,110,107,32,111,108,100,49,52,53,49,32,110,101,119,49,52,53,50,41,0,0,0,0,0};
static C_char C_TLS li160[] C_aligned={C_lihdr(0,0,8),40,114,101,97,100,121,63,41};
static C_char C_TLS li161[] C_aligned={C_lihdr(0,0,6),40,108,111,111,112,41,0,0};
static C_char C_TLS li162[] C_aligned={C_lihdr(0,0,7),40,102,101,116,99,104,41,0};
static C_char C_TLS li163[] C_aligned={C_lihdr(0,0,7),40,97,54,53,51,56,41,0};
static C_char C_TLS li164[] C_aligned={C_lihdr(0,0,7),40,97,54,53,54,51,41,0};
static C_char C_TLS li165[] C_aligned={C_lihdr(0,0,7),40,97,54,53,55,53,41,0};
static C_char C_TLS li166[] C_aligned={C_lihdr(0,0,7),40,97,54,53,57,55,41,0};
static C_char C_TLS li167[] C_aligned={C_lihdr(0,0,28),40,108,111,111,112,32,110,49,53,51,48,32,109,49,53,51,49,32,115,116,97,114,116,49,53,51,50,41,0,0,0,0};
static C_char C_TLS li168[] C_aligned={C_lihdr(0,0,41),40,97,54,54,49,50,32,112,111,114,116,49,53,50,53,32,110,49,53,50,54,32,100,101,115,116,49,53,50,55,32,115,116,97,114,116,49,53,50,56,41,0,0,0,0,0,0,0};
static C_char C_TLS li169[] C_aligned={C_lihdr(0,0,15),40,97,54,55,49,54,32,112,111,115,49,53,53,50,41,0};
static C_char C_TLS li170[] C_aligned={C_lihdr(0,0,7),40,97,54,55,48,54,41,0};
static C_char C_TLS li171[] C_aligned={C_lihdr(0,0,40),40,97,54,55,54,50,32,110,101,120,116,49,53,54,48,32,108,105,110,101,49,53,54,49,32,102,117,108,108,45,108,105,110,101,63,49,53,54,50,41};
static C_char C_TLS li172[] C_aligned={C_lihdr(0,0,23),40,97,54,54,56,56,32,112,49,53,52,54,32,108,105,109,105,116,49,53,52,55,41,0};
static C_char C_TLS li173[] C_aligned={C_lihdr(0,0,16),40,97,54,56,49,49,32,112,111,114,116,49,53,54,55,41};
static C_char C_TLS li174[] C_aligned={C_lihdr(0,0,62),40,35,35,115,121,115,35,99,117,115,116,111,109,45,105,110,112,117,116,45,112,111,114,116,32,108,111,99,49,52,54,48,32,110,97,109,49,52,54,49,32,102,100,49,52,54,50,32,46,32,116,109,112,49,52,53,57,49,52,54,51,41,0,0};
static C_char C_TLS li175[] C_aligned={C_lihdr(0,0,6),40,108,111,111,112,41,0,0};
static C_char C_TLS li176[] C_aligned={C_lihdr(0,0,26),40,112,111,107,101,49,53,57,52,32,115,116,114,49,54,48,48,32,108,101,110,49,54,48,49,41,0,0,0,0,0,0};
static C_char C_TLS li177[] C_aligned={C_lihdr(0,0,15),40,97,54,57,56,55,32,115,116,114,49,54,51,56,41,0};
static C_char C_TLS li178[] C_aligned={C_lihdr(0,0,7),40,97,54,57,57,51,41,0};
static C_char C_TLS li179[] C_aligned={C_lihdr(0,0,7),40,97,55,48,49,53,41,0};
static C_char C_TLS li180[] C_aligned={C_lihdr(0,0,16),40,102,95,55,48,50,52,32,115,116,114,49,54,49,56,41};
static C_char C_TLS li181[] C_aligned={C_lihdr(0,0,32),40,108,111,111,112,32,114,101,109,49,54,50,51,32,115,116,97,114,116,49,54,50,52,32,108,101,110,49,54,50,53,41};
static C_char C_TLS li182[] C_aligned={C_lihdr(0,0,16),40,102,95,55,48,51,57,32,115,116,114,49,54,50,49,41};
static C_char C_TLS li183[] C_aligned={C_lihdr(0,0,63),40,35,35,115,121,115,35,99,117,115,116,111,109,45,111,117,116,112,117,116,45,112,111,114,116,32,108,111,99,49,53,55,56,32,110,97,109,49,53,55,57,32,102,100,49,53,56,48,32,46,32,116,109,112,49,53,55,55,49,53,56,49,41,0};
static C_char C_TLS li184[] C_aligned={C_lihdr(0,0,33),40,102,105,108,101,45,116,114,117,110,99,97,116,101,32,102,110,97,109,101,49,54,52,54,32,111,102,102,49,54,52,55,41,0,0,0,0,0,0,0};
static C_char C_TLS li185[] C_aligned={C_lihdr(0,0,33),40,115,101,116,117,112,32,112,111,114,116,49,54,53,53,32,97,114,103,115,49,54,53,54,32,108,111,99,49,54,53,55,41,0,0,0,0,0,0,0};
static C_char C_TLS li186[] C_aligned={C_lihdr(0,0,30),40,101,114,114,32,109,115,103,49,54,55,50,32,108,111,99,107,49,54,55,51,32,108,111,99,49,54,55,52,41,0,0};
static C_char C_TLS li187[] C_aligned={C_lihdr(0,0,31),40,102,105,108,101,45,108,111,99,107,32,112,111,114,116,49,54,55,53,32,46,32,97,114,103,115,49,54,55,54,41,0};
static C_char C_TLS li188[] C_aligned={C_lihdr(0,0,40),40,102,105,108,101,45,108,111,99,107,47,98,108,111,99,107,105,110,103,32,112,111,114,116,49,54,55,56,32,46,32,97,114,103,115,49,54,55,57,41};
static C_char C_TLS li189[] C_aligned={C_lihdr(0,0,36),40,102,105,108,101,45,116,101,115,116,45,108,111,99,107,32,112,111,114,116,49,54,56,49,32,46,32,97,114,103,115,49,54,56,50,41,0,0,0,0};
static C_char C_TLS li190[] C_aligned={C_lihdr(0,0,22),40,102,105,108,101,45,117,110,108,111,99,107,32,108,111,99,107,49,54,57,57,41,0,0};
static C_char C_TLS li191[] C_aligned={C_lihdr(0,0,34),40,99,114,101,97,116,101,45,102,105,102,111,32,102,110,97,109,101,49,55,48,51,32,46,32,109,111,100,101,49,55,48,52,41,0,0,0,0,0,0};
static C_char C_TLS li192[] C_aligned={C_lihdr(0,0,20),40,102,105,102,111,63,32,102,105,108,101,110,97,109,101,49,55,48,57,41,0,0,0,0};
static C_char C_TLS li193[] C_aligned={C_lihdr(0,0,72),40,109,97,112,45,102,105,108,101,45,116,111,45,109,101,109,111,114,121,32,97,100,100,114,49,55,52,53,32,108,101,110,49,55,52,54,32,112,114,111,116,49,55,52,55,32,102,108,97,103,49,55,52,56,32,102,100,49,55,52,57,32,46,32,111,102,102,49,55,53,48,41};
static C_char C_TLS li194[] C_aligned={C_lihdr(0,0,43),40,117,110,109,97,112,45,102,105,108,101,45,102,114,111,109,45,109,101,109,111,114,121,32,109,109,97,112,49,55,54,55,32,46,32,108,101,110,49,55,54,56,41,0,0,0,0,0};
static C_char C_TLS li195[] C_aligned={C_lihdr(0,0,37),40,109,101,109,111,114,121,45,109,97,112,112,101,100,45,102,105,108,101,45,112,111,105,110,116,101,114,32,109,109,97,112,49,55,55,50,41,0,0,0};
static C_char C_TLS li196[] C_aligned={C_lihdr(0,0,27),40,109,101,109,111,114,121,45,109,97,112,112,101,100,45,102,105,108,101,63,32,120,49,55,55,53,41,0,0,0,0,0};
static C_char C_TLS li197[] C_aligned={C_lihdr(0,0,36),40,115,116,114,105,110,103,45,62,116,105,109,101,32,116,105,109,49,55,57,54,32,46,32,116,109,112,49,55,57,53,49,55,57,55,41,0,0,0,0};
static C_char C_TLS li198[] C_aligned={C_lihdr(0,0,26),40,117,116,99,45,116,105,109,101,45,62,115,101,99,111,110,100,115,32,116,109,49,56,48,56,41,0,0,0,0,0,0};
static C_char C_TLS li199[] C_aligned={C_lihdr(0,0,29),40,108,111,99,97,108,45,116,105,109,101,122,111,110,101,45,97,98,98,114,101,118,105,97,116,105,111,110,41,0,0,0};
static C_char C_TLS li200[] C_aligned={C_lihdr(0,0,18),40,95,101,120,105,116,32,46,32,99,111,100,101,49,56,50,49,41,0,0,0,0,0,0};
static C_char C_TLS li201[] C_aligned={C_lihdr(0,0,24),40,115,101,116,45,97,108,97,114,109,33,32,105,110,116,49,56,50,51,49,56,50,54,41};
static C_char C_TLS li202[] C_aligned={C_lihdr(0,0,50),40,115,101,116,45,98,117,102,102,101,114,105,110,103,45,109,111,100,101,33,32,112,111,114,116,49,56,50,56,32,109,111,100,101,49,56,50,57,32,46,32,115,105,122,101,49,56,51,48,41,0,0,0,0,0,0};
static C_char C_TLS li203[] C_aligned={C_lihdr(0,0,25),40,116,101,114,109,105,110,97,108,45,112,111,114,116,63,32,112,111,114,116,49,56,52,50,41,0,0,0,0,0,0,0};
static C_char C_TLS li204[] C_aligned={C_lihdr(0,0,42),40,35,35,115,121,115,35,116,101,114,109,105,110,97,108,45,99,104,101,99,107,32,99,97,108,108,101,114,49,56,52,55,32,112,111,114,116,49,56,52,56,41,0,0,0,0,0,0};
static C_char C_TLS li205[] C_aligned={C_lihdr(0,0,24),40,116,101,114,109,105,110,97,108,45,110,97,109,101,32,112,111,114,116,49,56,53,56,41};
static C_char C_TLS li206[] C_aligned={C_lihdr(0,0,24),40,116,101,114,109,105,110,97,108,45,115,105,122,101,32,112,111,114,116,49,56,55,48,41};
static C_char C_TLS li207[] C_aligned={C_lihdr(0,0,15),40,103,101,116,45,104,111,115,116,45,110,97,109,101,41,0};
static C_char C_TLS li208[] C_aligned={C_lihdr(0,0,18),40,102,95,55,57,49,53,32,116,104,117,110,107,49,57,50,48,41,0,0,0,0,0,0};
static C_char C_TLS li209[] C_aligned={C_lihdr(0,0,7),40,97,55,57,48,54,41,0};
static C_char C_TLS li210[] C_aligned={C_lihdr(0,0,28),40,112,114,111,99,101,115,115,45,102,111,114,107,32,46,32,116,109,112,49,56,57,54,49,56,57,55,41,0,0,0,0};
static C_char C_TLS li211[] C_aligned={C_lihdr(0,0,13),40,97,55,57,55,50,32,120,49,57,52,49,41,0,0,0};
static C_char C_TLS li212[] C_aligned={C_lihdr(0,0,37),40,97,55,57,55,53,32,112,114,103,49,57,52,50,32,97,114,103,98,117,102,49,57,52,51,32,101,110,118,98,117,102,49,57,52,52,41,0,0,0};
static C_char C_TLS li213[] C_aligned={C_lihdr(0,0,44),40,112,114,111,99,101,115,115,45,101,120,101,99,117,116,101,32,102,105,108,101,110,97,109,101,49,57,50,57,32,46,32,116,109,112,49,57,50,56,49,57,51,48,41,0,0,0,0};
static C_char C_TLS li214[] C_aligned={C_lihdr(0,0,7),40,97,56,48,51,48,41,0};
static C_char C_TLS li215[] C_aligned={C_lihdr(0,0,39),40,35,35,115,121,115,35,112,114,111,99,101,115,115,45,119,97,105,116,32,112,105,100,49,57,52,55,32,110,111,104,97,110,103,49,57,52,56,41,0};
static C_char C_TLS li216[] C_aligned={C_lihdr(0,0,19),40,112,97,114,101,110,116,45,112,114,111,99,101,115,115,45,105,100,41,0,0,0,0,0};
static C_char C_TLS li217[] C_aligned={C_lihdr(0,0,19),40,115,108,101,101,112,32,105,110,116,49,57,54,48,49,57,54,51,41,0,0,0,0,0};
static C_char C_TLS li218[] C_aligned={C_lihdr(0,0,33),40,112,114,111,99,101,115,115,45,115,105,103,110,97,108,32,105,100,49,57,54,53,32,46,32,115,105,103,49,57,54,54,41,0,0,0,0,0,0,0};
static C_char C_TLS li219[] C_aligned={C_lihdr(0,0,21),40,35,35,115,121,115,35,115,104,101,108,108,45,99,111,109,109,97,110,100,41,0,0,0};
static C_char C_TLS li220[] C_aligned={C_lihdr(0,0,42),40,35,35,115,121,115,35,115,104,101,108,108,45,99,111,109,109,97,110,100,45,97,114,103,117,109,101,110,116,115,32,99,109,100,108,105,110,49,57,55,54,41,0,0,0,0,0,0};
static C_char C_TLS li221[] C_aligned={C_lihdr(0,0,30),40,112,114,111,99,101,115,115,45,114,117,110,32,102,49,57,55,56,32,46,32,97,114,103,115,49,57,55,57,41,0,0};
static C_char C_TLS li222[] C_aligned={C_lihdr(0,0,7),40,97,56,49,55,51,41,0};
static C_char C_TLS li223[] C_aligned={C_lihdr(0,0,29),40,97,56,49,55,57,32,95,50,48,48,51,32,102,108,103,50,48,48,52,32,99,111,100,50,48,48,53,41,0,0,0};
static C_char C_TLS li224[] C_aligned={C_lihdr(0,0,8),40,102,95,56,49,53,57,41};
static C_char C_TLS li225[] C_aligned={C_lihdr(0,0,68),40,109,97,107,101,45,111,110,45,99,108,111,115,101,32,108,111,99,49,57,57,54,32,112,105,100,49,57,57,55,32,99,108,115,118,101,99,49,57,57,56,32,105,100,120,49,57,57,57,32,105,100,120,97,50,48,48,48,32,105,100,120,98,50,48,48,49,41,0,0,0,0};
static C_char C_TLS li226[] C_aligned={C_lihdr(0,0,7),40,97,56,50,48,50,41,0};
static C_char C_TLS li227[] C_aligned={C_lihdr(0,0,19),40,97,56,50,48,56,32,105,50,48,49,48,32,111,50,48,49,49,41,0,0,0,0,0};
static C_char C_TLS li228[] C_aligned={C_lihdr(0,0,22),40,110,101,101,100,101,100,45,112,105,112,101,32,112,111,114,116,50,48,48,56,41,0,0};
static C_char C_TLS li229[] C_aligned={C_lihdr(0,0,34),40,99,111,110,110,101,99,116,45,112,97,114,101,110,116,32,112,105,112,101,50,48,49,51,32,112,111,114,116,50,48,49,52,41,0,0,0,0,0,0};
static C_char C_TLS li230[] C_aligned={C_lihdr(0,0,43),40,99,111,110,110,101,99,116,45,99,104,105,108,100,32,112,105,112,101,50,48,50,49,32,112,111,114,116,50,48,50,50,32,115,116,100,102,100,50,48,50,51,41,0,0,0,0,0};
static C_char C_TLS li231[] C_aligned={C_lihdr(0,0,14),40,115,119,97,112,112,101,100,45,101,110,100,115,41,0,0};
static C_char C_TLS li232[] C_aligned={C_lihdr(0,0,7),40,97,56,50,55,55,41,0};
static C_char C_TLS li233[] C_aligned={C_lihdr(0,0,67),40,115,112,97,119,110,32,99,109,100,50,48,51,52,32,97,114,103,115,50,48,51,53,32,101,110,118,50,48,51,54,32,115,116,100,111,117,116,102,50,48,51,55,32,115,116,100,105,110,102,50,48,51,56,32,115,116,100,101,114,114,102,50,48,51,57,41,0,0,0,0,0};
static C_char C_TLS li234[] C_aligned={C_lihdr(0,0,59),40,105,110,112,117,116,45,112,111,114,116,32,108,111,99,50,48,52,54,32,99,109,100,50,48,52,56,32,112,105,112,101,50,48,52,57,32,115,116,100,102,50,48,53,48,32,111,110,45,99,108,111,115,101,50,48,53,50,41,0,0,0,0,0};
static C_char C_TLS li235[] C_aligned={C_lihdr(0,0,60),40,111,117,116,112,117,116,45,112,111,114,116,32,108,111,99,50,48,53,52,32,99,109,100,50,48,53,54,32,112,105,112,101,50,48,53,55,32,115,116,100,102,50,48,53,56,32,111,110,45,99,108,111,115,101,50,48,54,48,41,0,0,0,0};
static C_char C_TLS li236[] C_aligned={C_lihdr(0,0,7),40,97,56,51,50,55,41,0};
static C_char C_TLS li237[] C_aligned={C_lihdr(0,0,50),40,97,56,51,51,51,32,105,110,112,105,112,101,50,48,54,57,32,111,117,116,112,105,112,101,50,48,55,48,32,101,114,114,112,105,112,101,50,48,55,49,32,112,105,100,50,48,55,50,41,0,0,0,0,0,0};
static C_char C_TLS li238[] C_aligned={C_lihdr(0,0,83),40,35,35,115,121,115,35,112,114,111,99,101,115,115,32,108,111,99,50,48,54,50,32,99,109,100,50,48,54,51,32,97,114,103,115,50,48,54,52,32,101,110,118,50,48,54,53,32,115,116,100,111,117,116,102,50,48,54,54,32,115,116,100,105,110,102,50,48,54,55,32,115,116,100,101,114,114,102,50,48,54,56,41,0,0,0,0,0};
static C_char C_TLS li239[] C_aligned={C_lihdr(0,0,7),40,103,50,48,56,56,41,0};
static C_char C_TLS li240[] C_aligned={C_lihdr(0,0,19),40,102,111,114,45,101,97,99,104,45,108,111,111,112,50,48,56,55,41,0,0,0,0,0};
static C_char C_TLS li241[] C_aligned={C_lihdr(0,0,19),40,99,104,107,115,116,114,108,115,116,32,108,115,116,50,48,56,52,41,0,0,0,0,0};
static C_char C_TLS li242[] C_aligned={C_lihdr(0,0,7),40,97,56,52,50,56,41,0};
static C_char C_TLS li243[] C_aligned={C_lihdr(0,0,58),40,37,112,114,111,99,101,115,115,32,108,111,99,50,48,55,55,32,101,114,114,63,50,48,55,56,32,99,109,100,50,48,55,57,32,97,114,103,115,50,48,56,48,32,101,110,118,50,48,56,49,32,107,50,48,56,50,41,0,0,0,0,0,0};
static C_char C_TLS li244[] C_aligned={C_lihdr(0,0,31),40,97,56,52,54,54,32,105,50,49,51,49,32,111,50,49,51,50,32,112,50,49,51,51,32,101,50,49,51,52,41,0};
static C_char C_TLS li245[] C_aligned={C_lihdr(0,0,31),40,112,114,111,99,101,115,115,32,99,109,100,50,49,49,57,32,46,32,116,109,112,50,49,49,56,50,49,50,48,41,0};
static C_char C_TLS li246[] C_aligned={C_lihdr(0,0,32),40,112,114,111,99,101,115,115,42,32,99,109,100,50,49,51,57,32,46,32,116,109,112,50,49,51,56,50,49,52,48,41};
static C_char C_TLS li247[] C_aligned={C_lihdr(0,0,29),40,115,101,116,45,114,111,111,116,45,100,105,114,101,99,116,111,114,121,33,32,100,105,114,50,49,54,48,41,0,0,0};
static C_char C_TLS li248[] C_aligned={C_lihdr(0,0,15),40,97,56,53,55,52,32,112,105,100,49,51,57,49,41,0};
static C_char C_TLS li249[] C_aligned={C_lihdr(0,0,24),40,97,56,53,57,50,32,112,105,100,49,51,57,54,32,112,103,105,100,49,51,57,55,41};
static C_char C_TLS li250[] C_aligned={C_lihdr(0,0,7),40,97,56,54,49,52,41,0};
static C_char C_TLS li251[] C_aligned={C_lihdr(0,0,14),40,97,56,54,49,55,32,105,100,49,50,50,54,41,0,0};
static C_char C_TLS li252[] C_aligned={C_lihdr(0,0,7),40,97,56,54,51,51,41,0};
static C_char C_TLS li253[] C_aligned={C_lihdr(0,0,14),40,97,56,54,51,54,32,105,100,49,50,50,49,41,0,0};
static C_char C_TLS li254[] C_aligned={C_lihdr(0,0,7),40,97,56,54,53,50,41,0};
static C_char C_TLS li255[] C_aligned={C_lihdr(0,0,14),40,97,56,54,53,53,32,105,100,49,50,49,54,41,0,0};
static C_char C_TLS li256[] C_aligned={C_lihdr(0,0,7),40,97,56,54,55,49,41,0};
static C_char C_TLS li257[] C_aligned={C_lihdr(0,0,14),40,97,56,54,55,52,32,105,100,49,50,49,49,41,0,0};
static C_char C_TLS li258[] C_aligned={C_lihdr(0,0,24),40,108,111,111,112,32,115,105,103,115,49,49,56,54,32,109,97,115,107,49,49,56,55,41};
static C_char C_TLS li259[] C_aligned={C_lihdr(0,0,7),40,97,56,54,57,48,41,0};
static C_char C_TLS li260[] C_aligned={C_lihdr(0,0,14),40,97,56,55,50,52,32,115,105,103,54,51,57,41,0,0};
static C_char C_TLS li261[] C_aligned={C_lihdr(0,0,19),40,97,56,55,51,51,32,46,32,116,109,112,52,57,56,52,57,57,41,0,0,0,0,0};
static C_char C_TLS li262[] C_aligned={C_lihdr(0,0,13),40,97,56,55,53,56,32,117,109,53,49,49,41,0,0,0};
static C_char C_TLS li263[] C_aligned={C_lihdr(0,0,15),40,97,56,55,54,52,32,112,111,114,116,49,57,52,41,0};
static C_char C_TLS li264[] C_aligned={C_lihdr(0,0,12),40,97,56,56,48,49,32,102,49,49,48,41,0,0,0,0};
static C_char C_TLS li265[] C_aligned={C_lihdr(0,0,17),40,97,56,56,48,55,32,102,49,49,50,32,116,49,49,51,41,0,0,0,0,0,0,0};
static C_char C_TLS li266[] C_aligned={C_lihdr(0,0,10),40,116,111,112,108,101,118,101,108,41,0,0,0,0,0,0};


/* from k8542 in set-root-directory! in k6200 in k6169 in k5687 in k5683 in k5679 in k5675 in k5595 in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
C_regparm static C_word C_fcall stub2155(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
char * t0=(char * )C_string_or_null(C_a0);
C_r=C_fix((C_word)chroot(t0));
return C_r;}

/* from k8059 */
C_regparm static C_word C_fcall stub1961(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_unfix(C_a0);
C_r=C_fix((C_word)C_sleep(t0));
return C_r;}

/* from parent-process-id in k6200 in k6169 in k5687 in k5683 in k5679 in k5675 in k5595 in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
C_regparm static C_word C_fcall stub1957(C_word C_buf){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
C_r=C_fix((C_word)C_getppid());
return C_r;}

/* from k7879 */
C_regparm static C_word C_fcall stub1911(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
void * t0=(void * )C_c_pointer_or_null(C_a0);
C_r=C_fix((C_word)C_fflush(t0));
return C_r;}

/* from fork */
C_regparm static C_word C_fcall stub1891(C_word C_buf){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
C_r=C_fix((C_word)C_fork());
return C_r;}

#define return(x) C_cblock C_r = (C_mpointer(&C_a,(void*)(x))); goto C_ret; C_cblockend
C_regparm static C_word C_fcall stub1884(C_word C_buf){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
if(gethostname(C_hostbuf, 256) == -1) C_return(NULL);else C_return(C_hostbuf);
C_ret:
#undef return

return C_r;}

/* from k7808 */
C_regparm static C_word C_fcall stub1865(C_word C_buf,C_word C_a0,C_word C_a1,C_word C_a2){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_unfix(C_a0);
int *t1=(int *)C_c_pointer_nn(C_a1);
int *t2=(int *)C_c_pointer_nn(C_a2);
C_r=C_fix((C_word)get_tty_size(t0,t1,t2));
return C_r;}

/* from k7784 */
C_regparm static C_word C_fcall stub1854(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_unfix(C_a0);
C_r=C_mpointer(&C_a,(void*)ttyname(t0));
return C_r;}

/* from k7671 */
C_regparm static C_word C_fcall stub1824(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_unfix(C_a0);
C_r=C_fix((C_word)C_alarm(t0));
return C_r;}

/* from k7651 */
C_regparm static C_word C_fcall stub1818(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_unfix(C_a0);
_exit(t0);
return C_r;}

#define return(x) C_cblock C_r = (C_mpointer(&C_a,(void*)(x))); goto C_ret; C_cblockend
C_regparm static C_word C_fcall stub1812(C_word C_buf){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;

#if !defined(__CYGWIN__) && !defined(__SVR4) && !defined(__uClinux__) && !defined(__hpux__) && !defined(_AIX)
time_t clock = time(NULL);struct tm *ltm = C_localtime(&clock);char *z = ltm ? (char *)ltm->tm_zone : 0;
#else
char *z = (daylight ? tzname[1] : tzname[0]);
#endif
C_return(z);
C_ret:
#undef return

return C_r;}

/* from k7579 */
C_regparm static C_word C_fcall stub1783(C_word C_buf,C_word C_a0,C_word C_a1,C_word C_a2,C_word C_a3){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
C_word t0=(C_word )(C_a0);
C_word t1=(C_word )(C_a1);
C_word t2=(C_word )(C_a2);
void * t3=(void * )C_data_pointer_or_null(C_a3);
C_r=((C_word)C_strptime(t0,t1,t2,t3));
return C_r;}

/* from k7522 */
C_regparm static C_word C_fcall stub1761(C_word C_buf,C_word C_a0,C_word C_a1){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
void * t0=(void * )C_c_pointer_or_null(C_a0);
int t1=(int )C_num_to_int(C_a1);
C_r=C_fix((C_word)munmap(t0,t1));
return C_r;}

/* from k7462 */
C_regparm static C_word C_fcall stub1734(C_word C_buf,C_word C_a0,C_word C_a1,C_word C_a2,C_word C_a3,C_word C_a4,C_word C_a5){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
void * t0=(void * )C_c_pointer_or_null(C_a0);
int t1=(int )C_num_to_int(C_a1);
int t2=(int )C_unfix(C_a2);
int t3=(int )C_unfix(C_a3);
int t4=(int )C_unfix(C_a4);
int t5=(int )C_num_to_int(C_a5);
C_r=C_mpointer_or_false(&C_a,(void*)mmap(t0,t1,t2,t3,t4,t5));
return C_r;}

/* from k6326 in k6322 in file-link in k6200 in k6169 in k5687 in k5683 in k5679 in k5675 in k5595 in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
C_regparm static C_word C_fcall stub1443(C_word C_buf,C_word C_a0,C_word C_a1){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
char * t0=(char * )C_string_or_null(C_a0);
char * t1=(char * )C_string_or_null(C_a1);
C_r=C_fix((C_word)link(t0,t1));
return C_r;}

/* from k5993 */
C_regparm static C_word C_fcall stub1311(C_word C_buf,C_word C_a0,C_word C_a1){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
char * t0=(char * )C_string_or_null(C_a0);
int t1=(int )C_unfix(C_a1);
C_r=C_fix((C_word)initgroups(t0,t1));
return C_r;}

#define return(x) C_cblock C_r = (C_mk_bool((x))); goto C_ret; C_cblockend
C_regparm static C_word C_fcall stub1281(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int n=(int )C_unfix(C_a0);
if(C_groups != NULL) C_free(C_groups);C_groups = (gid_t *)C_malloc(sizeof(gid_t) * n);if(C_groups == NULL) C_return(0);else C_return(1);
C_ret:
#undef return

return C_r;}

#define return(x) C_cblock C_r = (C_fix((C_word)(x))); goto C_ret; C_cblockend
C_regparm static C_word C_fcall stub1276(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int n=(int )C_unfix(C_a0);
C_return(getgroups(n, C_groups));
C_ret:
#undef return

return C_r;}

#define return(x) C_cblock C_r = (C_mpointer(&C_a,(void*)(x))); goto C_ret; C_cblockend
C_regparm static C_word C_fcall stub1249(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int i=(int )C_unfix(C_a0);
C_return(C_group->gr_mem[ i ]);
C_ret:
#undef return

return C_r;}

/* from a8614 in k5683 in k5679 in k5675 in k5595 in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
C_regparm static C_word C_fcall stub1224(C_word C_buf){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
C_r=C_fix((C_word)C_getegid());
return C_r;}

/* from a8633 in k5679 in k5675 in k5595 in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
C_regparm static C_word C_fcall stub1219(C_word C_buf){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
C_r=C_fix((C_word)C_getgid());
return C_r;}

/* from a8652 in k5675 in k5595 in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
C_regparm static C_word C_fcall stub1214(C_word C_buf){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
C_r=C_fix((C_word)C_geteuid());
return C_r;}

/* from a8671 in k5595 in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
C_regparm static C_word C_fcall stub1209(C_word C_buf){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
C_r=C_fix((C_word)C_getuid());
return C_r;}

#define return(x) C_cblock C_r = (C_mk_bool((x))); goto C_ret; C_cblockend
C_regparm static C_word C_fcall stub1014(C_word C_buf,C_word C_a0,C_word C_a1){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int i=(int )C_unfix(C_a0);
void * p=(void * )C_data_pointer_or_null(C_a1);
struct pollfd *fds = p;C_return(fds[i].revents & (POLLOUT|POLLERR|POLLHUP|POLLNVAL));
C_ret:
#undef return

return C_r;}

#define return(x) C_cblock C_r = (C_mk_bool((x))); goto C_ret; C_cblockend
C_regparm static C_word C_fcall stub995(C_word C_buf,C_word C_a0,C_word C_a1){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int i=(int )C_unfix(C_a0);
void * p=(void * )C_data_pointer_or_null(C_a1);
struct pollfd *fds = p;C_return(fds[i].revents & (POLLIN|POLLERR|POLLHUP|POLLNVAL));
C_ret:
#undef return

return C_r;}

/* from k4865 */
C_regparm static C_word C_fcall stub970(C_word C_buf,C_word C_a0,C_word C_a1,C_word C_a2){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
void * t0=(void * )C_data_pointer_or_null(C_a0);
int t1=(int )C_unfix(C_a1);
int t2=(int )C_unfix(C_a2);
C_r=C_fix((C_word)poll(t0,t1,t2));
return C_r;}

#define return(x) C_cblock C_r = (((C_word)(x))); goto C_ret; C_cblockend
C_regparm static C_word C_fcall stub955(C_word C_buf,C_word C_a0,C_word C_a1,C_word C_a2){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int i=(int )C_unfix(C_a0);
int fd=(int )C_unfix(C_a1);
void * p=(void * )C_data_pointer_or_null(C_a2);
struct pollfd *fds = p;fds[i].fd = fd; fds[i].events = POLLOUT;
C_ret:
#undef return

return C_r;}

#define return(x) C_cblock C_r = (((C_word)(x))); goto C_ret; C_cblockend
C_regparm static C_word C_fcall stub937(C_word C_buf,C_word C_a0,C_word C_a1,C_word C_a2){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int i=(int )C_unfix(C_a0);
int fd=(int )C_unfix(C_a1);
void * p=(void * )C_data_pointer_or_null(C_a2);
struct pollfd *fds = p;fds[i].fd = fd; fds[i].events = POLLIN;
C_ret:
#undef return

return C_r;}

/* from k4617 */
C_regparm static C_word C_fcall stub837(C_word C_buf,C_word C_a0,C_word C_a1,C_word C_a2){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_unfix(C_a0);
int t1=(int )C_unfix(C_a1);
long t2=(long )C_num_to_long(C_a2);
C_r=C_fix((C_word)fcntl(t0,t1,t2));
return C_r;}

/* from k4566 */
C_regparm static C_word C_fcall stub793(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_unfix(C_a0);
C_r=C_fix((C_word)C_check_fd_ready(t0));
return C_r;}

#define return(x) C_cblock C_r = (C_mk_bool((x))); goto C_ret; C_cblockend
C_regparm static C_word C_fcall stub788(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int fd=(int )C_unfix(C_a0);
int val = fcntl(fd, F_GETFL, 0);if(val == -1) C_return(0);C_return(fcntl(fd, F_SETFL, val | O_NONBLOCK) != -1);
C_ret:
#undef return

return C_r;}

#define return(x) C_cblock C_r = (C_mpointer_or_false(&C_a,(void*)(x))); goto C_ret; C_cblockend
C_regparm static C_word C_fcall stub665(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
C_word o=(C_word )(C_a0);
char *ptr = C_malloc(C_header_size(o)); 
if (ptr != NULL) {
  C_memcpy(ptr, C_data_pointer(o), C_header_size(o)); 
}
C_return(ptr);
C_ret:
#undef return

return C_r;}

/* from k4158 */
C_regparm static C_word C_fcall stub621(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_unfix(C_a0);
C_r=C_mpointer(&C_a,(void*)C_getenventry(t0));
return C_r;}

/* from k4056 */
C_regparm static C_word C_fcall stub582(C_word C_buf,C_word C_a0,C_word C_a1,C_word C_a2){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
C_word t0=(C_word )(C_a0);
C_word t1=(C_word )(C_a1);
void * t2=(void * )C_data_pointer_or_null(C_a2);
C_r=C_mpointer(&C_a,(void*)C_strftime(t0,t1,t2));
return C_r;}

/* from k4043 */
C_regparm static C_word C_fcall stub572(C_word C_buf,C_word C_a0,C_word C_a1){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
C_word t0=(C_word )(C_a0);
void * t1=(void * )C_data_pointer_or_null(C_a1);
C_r=C_mpointer(&C_a,(void*)C_asctime(t0,t1));
return C_r;}

/* from k3976 */
C_regparm static C_word C_fcall stub544(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_num_to_int(C_a0);
C_r=C_mpointer(&C_a,(void*)C_ctime(t0));
return C_r;}

/* from k8816 in a8807 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
C_regparm static C_word C_fcall stub119(C_word C_buf,C_word C_a0,C_word C_a1){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
char * t0=(char * )C_string_or_null(C_a0);
C_word t1=(C_word )(C_a1);
C_r=C_fix((C_word)set_file_mtime(t0,t1));
return C_r;}

/* from k2701 */
C_regparm static C_word C_fcall stub67(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_unfix(C_a0);
C_r=C_mpointer(&C_a,(void*)strerror(t0));
return C_r;}

C_noret_decl(f_4494)
static void C_ccall f_4494(C_word c,C_word *av) C_noret;
C_noret_decl(f_3841)
static void C_ccall f_3841(C_word c,C_word *av) C_noret;
C_noret_decl(f_4489)
static void C_ccall f_4489(C_word c,C_word *av) C_noret;
C_noret_decl(f_4486)
static void C_ccall f_4486(C_word c,C_word *av) C_noret;
C_noret_decl(f_8725)
static void C_ccall f_8725(C_word c,C_word *av) C_noret;
C_noret_decl(f_6498)
static void C_ccall f_6498(C_word c,C_word *av) C_noret;
C_noret_decl(f_5418)
static void C_ccall f_5418(C_word c,C_word *av) C_noret;
C_noret_decl(f_5413)
static void C_ccall f_5413(C_word c,C_word *av) C_noret;
C_noret_decl(f_3832)
static void C_ccall f_3832(C_word c,C_word *av) C_noret;
C_noret_decl(f_3833)
static void C_ccall f_3833(C_word c,C_word *av) C_noret;
C_noret_decl(f_6495)
static void C_ccall f_6495(C_word c,C_word *av) C_noret;
C_noret_decl(f_4274)
static void C_ccall f_4274(C_word c,C_word *av) C_noret;
C_noret_decl(f_3868)
static void C_ccall f_3868(C_word c,C_word *av) C_noret;
C_noret_decl(f_3313)
static void C_ccall f_3313(C_word c,C_word *av) C_noret;
C_noret_decl(f_6621)
static void C_fcall f_6621(C_word t0,C_word t1) C_noret;
C_noret_decl(f_5771)
static void C_ccall f_5771(C_word c,C_word *av) C_noret;
C_noret_decl(f_6623)
static void C_fcall f_6623(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_3865)
static void C_ccall f_3865(C_word c,C_word *av) C_noret;
C_noret_decl(f_3862)
static void C_ccall f_3862(C_word c,C_word *av) C_noret;
C_noret_decl(f_7744)
static void C_ccall f_7744(C_word c,C_word *av) C_noret;
C_noret_decl(f_7024)
static void C_ccall f_7024(C_word c,C_word *av) C_noret;
C_noret_decl(f_6671)
static void C_ccall f_6671(C_word c,C_word *av) C_noret;
C_noret_decl(f_5767)
static void C_ccall f_5767(C_word c,C_word *av) C_noret;
C_noret_decl(f_3888)
static void C_ccall f_3888(C_word c,C_word *av) C_noret;
C_noret_decl(f_7756)
static void C_fcall f_7756(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_5791)
static void C_fcall f_5791(C_word t0,C_word t1) C_noret;
C_noret_decl(f_8734)
static void C_ccall f_8734(C_word c,C_word *av) C_noret;
C_noret_decl(f_5428)
static void C_ccall f_5428(C_word c,C_word *av) C_noret;
C_noret_decl(f_5424)
static void C_ccall f_5424(C_word c,C_word *av) C_noret;
C_noret_decl(f_3885)
static void C_ccall f_3885(C_word c,C_word *av) C_noret;
C_noret_decl(f_3882)
static void C_ccall f_3882(C_word c,C_word *av) C_noret;
C_noret_decl(f_3879)
static void C_ccall f_3879(C_word c,C_word *av) C_noret;
C_noret_decl(f_3367)
static void C_ccall f_3367(C_word c,C_word *av) C_noret;
C_noret_decl(f_8618)
static void C_ccall f_8618(C_word c,C_word *av) C_noret;
C_noret_decl(f_7004)
static void C_ccall f_7004(C_word c,C_word *av) C_noret;
C_noret_decl(f_8615)
static void C_ccall f_8615(C_word c,C_word *av) C_noret;
C_noret_decl(f_5784)
static void C_ccall f_5784(C_word c,C_word *av) C_noret;
C_noret_decl(f_6613)
static void C_ccall f_6613(C_word c,C_word *av) C_noret;
C_noret_decl(f_3874)
static void C_ccall f_3874(C_word c,C_word *av) C_noret;
C_noret_decl(f_3871)
static void C_ccall f_3871(C_word c,C_word *av) C_noret;
C_noret_decl(f_7738)
static void C_ccall f_7738(C_word c,C_word *av) C_noret;
C_noret_decl(f_5737)
static void C_ccall f_5737(C_word c,C_word *av) C_noret;
C_noret_decl(f_4209)
static void C_ccall f_4209(C_word c,C_word *av) C_noret;
C_noret_decl(f_8609)
static void C_ccall f_8609(C_word c,C_word *av) C_noret;
C_noret_decl(f_4908)
static void C_ccall f_4908(C_word c,C_word *av) C_noret;
C_noret_decl(f_5487)
static void C_ccall f_5487(C_word c,C_word *av) C_noret;
C_noret_decl(f_5481)
static void C_ccall f_5481(C_word c,C_word *av) C_noret;
C_noret_decl(f_5081)
static C_word C_fcall f_5081(C_word t0,C_word t1,C_word t2);
C_noret_decl(f_4205)
static void C_ccall f_4205(C_word c,C_word *av) C_noret;
C_noret_decl(f_8637)
static void C_ccall f_8637(C_word c,C_word *av) C_noret;
C_noret_decl(f_8634)
static void C_ccall f_8634(C_word c,C_word *av) C_noret;
C_noret_decl(f_5723)
static void C_ccall f_5723(C_word c,C_word *av) C_noret;
C_noret_decl(f_5727)
static void C_ccall f_5727(C_word c,C_word *av) C_noret;
C_noret_decl(f_4918)
static void C_fcall f_4918(C_word t0,C_word t1) C_noret;
C_noret_decl(f_4911)
static void C_ccall f_4911(C_word c,C_word *av) C_noret;
C_noret_decl(f_5079)
static void C_ccall f_5079(C_word c,C_word *av) C_noret;
C_noret_decl(f_8628)
static void C_ccall f_8628(C_word c,C_word *av) C_noret;
C_noret_decl(f_5753)
static void C_ccall f_5753(C_word c,C_word *av) C_noret;
C_noret_decl(f_6602)
static void C_ccall f_6602(C_word c,C_word *av) C_noret;
C_noret_decl(f_5757)
static void C_ccall f_5757(C_word c,C_word *av) C_noret;
C_noret_decl(f_4227)
static void C_ccall f_4227(C_word c,C_word *av) C_noret;
C_noret_decl(f_5759)
static void C_ccall f_5759(C_word c,C_word *av) C_noret;
C_noret_decl(f_5068)
static void C_fcall f_5068(C_word t0,C_word t1) C_noret;
C_noret_decl(f_3329)
static void C_ccall f_3329(C_word c,C_word *av) C_noret;
C_noret_decl(f_3323)
static void C_ccall f_3323(C_word c,C_word *av) C_noret;
C_noret_decl(f_5745)
static void C_ccall f_5745(C_word c,C_word *av) C_noret;
C_noret_decl(f_7205)
static void C_fcall f_7205(C_word t0,C_word t1) C_noret;
C_noret_decl(f_6067)
static void C_ccall f_6067(C_word c,C_word *av) C_noret;
C_noret_decl(f_6429)
static C_word C_fcall f_6429(C_word t0);
C_noret_decl(f_4434)
static void C_ccall f_4434(C_word c,C_word *av) C_noret;
C_noret_decl(f_3859)
static void C_ccall f_3859(C_word c,C_word *av) C_noret;
C_noret_decl(f_6437)
static void C_fcall f_6437(C_word t0,C_word t1) C_noret;
C_noret_decl(f_4440)
static void C_fcall f_4440(C_word t0,C_word t1) C_noret;
C_noret_decl(f_7266)
static void C_ccall f_7266(C_word c,C_word *av) C_noret;
C_noret_decl(f_4444)
static void C_ccall f_4444(C_word c,C_word *av) C_noret;
C_noret_decl(f_3855)
static void C_ccall f_3855(C_word c,C_word *av) C_noret;
C_noret_decl(f_5036)
static void C_fcall f_5036(C_word t0,C_word t1) C_noret;
C_noret_decl(f_3901)
static void C_ccall f_3901(C_word c,C_word *av) C_noret;
C_noret_decl(f_3906)
static void C_ccall f_3906(C_word c,C_word *av) C_noret;
C_noret_decl(f_4449)
static void C_fcall f_4449(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_3908)
static void C_fcall f_3908(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_7248)
static void C_fcall f_7248(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_6026)
static void C_ccall f_6026(C_word c,C_word *av) C_noret;
C_noret_decl(f_3281)
static void C_fcall f_3281(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_7298)
static void C_ccall f_7298(C_word c,C_word *av) C_noret;
C_noret_decl(f_3276)
static void C_ccall f_3276(C_word c,C_word *av) C_noret;
C_noret_decl(f_3273)
static void C_ccall f_3273(C_word c,C_word *av) C_noret;
C_noret_decl(f_7270)
static void C_ccall f_7270(C_word c,C_word *av) C_noret;
C_noret_decl(f_4977)
static void C_fcall f_4977(C_word t0,C_word t1) C_noret;
C_noret_decl(f_3291)
static void C_ccall f_3291(C_word c,C_word *av) C_noret;
C_noret_decl(f_4423)
static void C_ccall f_4423(C_word c,C_word *av) C_noret;
C_noret_decl(f_7282)
static void C_ccall f_7282(C_word c,C_word *av) C_noret;
C_noret_decl(f_7286)
static void C_ccall f_7286(C_word c,C_word *av) C_noret;
C_noret_decl(f_4417)
static void C_fcall f_4417(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_4948)
static void C_fcall f_4948(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_3927)
static void C_ccall f_3927(C_word c,C_word *av) C_noret;
C_noret_decl(f_3952)
static void C_ccall f_3952(C_word c,C_word *av) C_noret;
C_noret_decl(f_3983)
static void C_ccall f_3983(C_word c,C_word *av) C_noret;
C_noret_decl(f_6443)
static void C_ccall f_6443(C_word c,C_word *av) C_noret;
C_noret_decl(f_3989)
static void C_ccall f_3989(C_word c,C_word *av) C_noret;
C_noret_decl(f_3931)
static void C_ccall f_3931(C_word c,C_word *av) C_noret;
C_noret_decl(f_4462)
static void C_ccall f_4462(C_word c,C_word *av) C_noret;
C_noret_decl(f_4459)
static void C_ccall f_4459(C_word c,C_word *av) C_noret;
C_noret_decl(f_6917)
static void C_ccall f_6917(C_word c,C_word *av) C_noret;
C_noret_decl(f_6911)
static void C_ccall f_6911(C_word c,C_word *av) C_noret;
C_noret_decl(f_6910)
static void C_ccall f_6910(C_word c,C_word *av) C_noret;
C_noret_decl(f_3209)
static void C_ccall f_3209(C_word c,C_word *av) C_noret;
C_noret_decl(f_3206)
static void C_ccall f_3206(C_word c,C_word *av) C_noret;
C_noret_decl(f_6465)
static void C_ccall f_6465(C_word c,C_word *av) C_noret;
C_noret_decl(f_7836)
static void C_ccall f_7836(C_word c,C_word *av) C_noret;
C_noret_decl(f_6462)
static void C_ccall f_6462(C_word c,C_word *av) C_noret;
C_noret_decl(f_7840)
static void C_ccall f_7840(C_word c,C_word *av) C_noret;
C_noret_decl(f_3227)
static void C_ccall f_3227(C_word c,C_word *av) C_noret;
C_noret_decl(f_7815)
static void C_ccall f_7815(C_word c,C_word *av) C_noret;
C_noret_decl(f_6400)
static void C_fcall f_6400(C_word t0,C_word t1) C_noret;
C_noret_decl(f_7811)
static void C_ccall f_7811(C_word c,C_word *av) C_noret;
C_noret_decl(f_6404)
static void C_ccall f_6404(C_word c,C_word *av) C_noret;
C_noret_decl(f_7848)
static void C_ccall f_7848(C_word c,C_word *av) C_noret;
C_noret_decl(f_4407)
static void C_ccall f_4407(C_word c,C_word *av) C_noret;
C_noret_decl(f_3979)
static void C_ccall f_3979(C_word c,C_word *av) C_noret;
C_noret_decl(f_8153)
static void C_ccall f_8153(C_word c,C_word *av) C_noret;
C_noret_decl(f_8159)
static void C_ccall f_8159(C_word c,C_word *av) C_noret;
C_noret_decl(f_8157)
static void C_fcall f_8157(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6) C_noret;
C_noret_decl(f_6967)
static void C_ccall f_6967(C_word c,C_word *av) C_noret;
C_noret_decl(f_6936)
static void C_ccall f_6936(C_word c,C_word *av) C_noret;
C_noret_decl(f_7893)
static void C_ccall f_7893(C_word c,C_word *av) C_noret;
C_noret_decl(f_8174)
static void C_ccall f_8174(C_word c,C_word *av) C_noret;
C_noret_decl(f_6693)
static void C_ccall f_6693(C_word c,C_word *av) C_noret;
C_noret_decl(f_6994)
static void C_ccall f_6994(C_word c,C_word *av) C_noret;
C_noret_decl(f_4116)
static void C_ccall f_4116(C_word c,C_word *av) C_noret;
C_noret_decl(f_8110)
static void C_ccall f_8110(C_word c,C_word *av) C_noret;
C_noret_decl(f_7787)
static void C_ccall f_7787(C_word c,C_word *av) C_noret;
C_noret_decl(C_posix_toplevel)
C_externexport void C_ccall C_posix_toplevel(C_word c,C_word *av) C_noret;
C_noret_decl(f_7484)
static void C_ccall f_7484(C_word c,C_word *av) C_noret;
C_noret_decl(f_8103)
static void C_ccall f_8103(C_word c,C_word *av) C_noret;
C_noret_decl(f_8107)
static void C_fcall f_8107(C_word t0,C_word t1) C_noret;
C_noret_decl(f_6977)
static void C_fcall f_6977(C_word t0,C_word t1) C_noret;
C_noret_decl(f_6689)
static void C_ccall f_6689(C_word c,C_word *av) C_noret;
C_noret_decl(f_7497)
static void C_ccall f_7497(C_word c,C_word *av) C_noret;
C_noret_decl(f_3948)
static void C_ccall f_3948(C_word c,C_word *av) C_noret;
C_noret_decl(f_6982)
static void C_ccall f_6982(C_word c,C_word *av) C_noret;
C_noret_decl(f_6988)
static void C_ccall f_6988(C_word c,C_word *av) C_noret;
C_noret_decl(f_6986)
static void C_ccall f_6986(C_word c,C_word *av) C_noret;
C_noret_decl(f_6114)
static void C_ccall f_6114(C_word c,C_word *av) C_noret;
C_noret_decl(f_6116)
static void C_fcall f_6116(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_4197)
static void C_ccall f_4197(C_word c,C_word *av) C_noret;
C_noret_decl(f_8194)
static void C_fcall f_8194(C_word t0,C_word t1) C_noret;
C_noret_decl(f_5289)
static void C_ccall f_5289(C_word c,C_word *av) C_noret;
C_noret_decl(f_5275)
static void C_ccall f_5275(C_word c,C_word *av) C_noret;
C_noret_decl(f_5273)
static void C_ccall f_5273(C_word c,C_word *av) C_noret;
C_noret_decl(f_6126)
static void C_ccall f_6126(C_word c,C_word *av) C_noret;
C_noret_decl(f_4161)
static void C_ccall f_4161(C_word c,C_word *av) C_noret;
C_noret_decl(f_8180)
static void C_ccall f_8180(C_word c,C_word *av) C_noret;
C_noret_decl(f_4167)
static void C_fcall f_4167(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_4171)
static void C_ccall f_4171(C_word c,C_word *av) C_noret;
C_noret_decl(f_4179)
static void C_fcall f_4179(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_4141)
static void C_ccall f_4141(C_word c,C_word *av) C_noret;
C_noret_decl(f_4149)
static void C_ccall f_4149(C_word c,C_word *av) C_noret;
C_noret_decl(f_6154)
static void C_ccall f_6154(C_word c,C_word *av) C_noret;
C_noret_decl(f_6158)
static void C_ccall f_6158(C_word c,C_word *av) C_noret;
C_noret_decl(f_5442)
static void C_ccall f_5442(C_word c,C_word *av) C_noret;
C_noret_decl(f_5447)
static void C_ccall f_5447(C_word c,C_word *av) C_noret;
C_noret_decl(f_6164)
static void C_ccall f_6164(C_word c,C_word *av) C_noret;
C_noret_decl(f_4124)
static void C_ccall f_4124(C_word c,C_word *av) C_noret;
C_noret_decl(f_7907)
static void C_ccall f_7907(C_word c,C_word *av) C_noret;
C_noret_decl(f_8365)
static void C_ccall f_8365(C_word c,C_word *av) C_noret;
C_noret_decl(f_7911)
static void C_ccall f_7911(C_word c,C_word *av) C_noret;
C_noret_decl(f_6136)
static void C_ccall f_6136(C_word c,C_word *av) C_noret;
C_noret_decl(f_8361)
static void C_ccall f_8361(C_word c,C_word *av) C_noret;
C_noret_decl(f_6134)
static void C_ccall f_6134(C_word c,C_word *av) C_noret;
C_noret_decl(f_3088)
static void C_ccall f_3088(C_word c,C_word *av) C_noret;
C_noret_decl(f_4135)
static void C_ccall f_4135(C_word c,C_word *av) C_noret;
C_noret_decl(f_4139)
static void C_ccall f_4139(C_word c,C_word *av) C_noret;
C_noret_decl(f_7915)
static void C_ccall f_7915(C_word c,C_word *av) C_noret;
C_noret_decl(f_8353)
static void C_ccall f_8353(C_word c,C_word *av) C_noret;
C_noret_decl(f_6142)
static void C_ccall f_6142(C_word c,C_word *av) C_noret;
C_noret_decl(f_6148)
static void C_ccall f_6148(C_word c,C_word *av) C_noret;
C_noret_decl(f_5453)
static void C_ccall f_5453(C_word c,C_word *av) C_noret;
C_noret_decl(f_8357)
static void C_ccall f_8357(C_word c,C_word *av) C_noret;
C_noret_decl(f_5457)
static void C_ccall f_5457(C_word c,C_word *av) C_noret;
C_noret_decl(f_7056)
static void C_fcall f_7056(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_5207)
static void C_ccall f_5207(C_word c,C_word *av) C_noret;
C_noret_decl(f_8380)
static void C_fcall f_8380(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_8385)
static C_word C_fcall f_8385(C_word t0,C_word t1);
C_noret_decl(f_6198)
static void C_ccall f_6198(C_word c,C_word *av) C_noret;
C_noret_decl(f_7973)
static void C_ccall f_7973(C_word c,C_word *av) C_noret;
C_noret_decl(f_5400)
static void C_ccall f_5400(C_word c,C_word *av) C_noret;
C_noret_decl(f_7976)
static void C_ccall f_7976(C_word c,C_word *av) C_noret;
C_noret_decl(f_6194)
static void C_ccall f_6194(C_word c,C_word *av) C_noret;
C_noret_decl(f_5409)
static void C_ccall f_5409(C_word c,C_word *av) C_noret;
C_noret_decl(f_5404)
static void C_ccall f_5404(C_word c,C_word *av) C_noret;
C_noret_decl(f_7066)
static void C_ccall f_7066(C_word c,C_word *av) C_noret;
C_noret_decl(f_5433)
static void C_ccall f_5433(C_word c,C_word *av) C_noret;
C_noret_decl(f_8378)
static void C_fcall f_8378(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6) C_noret;
C_noret_decl(f_5437)
static void C_ccall f_5437(C_word c,C_word *av) C_noret;
C_noret_decl(f_4250)
static void C_ccall f_4250(C_word c,C_word *av) C_noret;
C_noret_decl(f_7038)
static void C_ccall f_7038(C_word c,C_word *av) C_noret;
C_noret_decl(f_7039)
static void C_ccall f_7039(C_word c,C_word *av) C_noret;
C_noret_decl(f_6173)
static void C_ccall f_6173(C_word c,C_word *av) C_noret;
C_noret_decl(f_6171)
static void C_ccall f_6171(C_word c,C_word *av) C_noret;
C_noret_decl(f_5462)
static void C_ccall f_5462(C_word c,C_word *av) C_noret;
C_noret_decl(f_7955)
static void C_ccall f_7955(C_word c,C_word *av) C_noret;
C_noret_decl(f_5467)
static void C_ccall f_5467(C_word c,C_word *av) C_noret;
C_noret_decl(f_8133)
static void C_ccall f_8133(C_word c,C_word *av) C_noret;
C_noret_decl(f_8015)
static void C_ccall f_8015(C_word c,C_word *av) C_noret;
C_noret_decl(f_8394)
static C_word C_fcall f_8394(C_word t0,C_word t1);
C_noret_decl(f_8129)
static void C_ccall f_8129(C_word c,C_word *av) C_noret;
C_noret_decl(f_7016)
static void C_ccall f_7016(C_word c,C_word *av) C_noret;
C_noret_decl(f_3487)
static void C_ccall f_3487(C_word c,C_word *av) C_noret;
C_noret_decl(f_4242)
static void C_ccall f_4242(C_word c,C_word *av) C_noret;
C_noret_decl(f_4244)
static void C_ccall f_4244(C_word c,C_word *av) C_noret;
C_noret_decl(f_3473)
static void C_fcall f_3473(C_word t0,C_word t1) C_noret;
C_noret_decl(f_7852)
static void C_ccall f_7852(C_word c,C_word *av) C_noret;
C_noret_decl(f_7855)
static void C_ccall f_7855(C_word c,C_word *av) C_noret;
C_noret_decl(f_5296)
static void C_ccall f_5296(C_word c,C_word *av) C_noret;
C_noret_decl(f_8053)
static void C_ccall f_8053(C_word c,C_word *av) C_noret;
C_noret_decl(f_8056)
static void C_ccall f_8056(C_word c,C_word *av) C_noret;
C_noret_decl(f_3499)
static void C_fcall f_3499(C_word t0,C_word t1) C_noret;
C_noret_decl(f_7862)
static void C_ccall f_7862(C_word c,C_word *av) C_noret;
C_noret_decl(f_8300)
static void C_fcall f_8300(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6) C_noret;
C_noret_decl(f_8304)
static void C_ccall f_8304(C_word c,C_word *av) C_noret;
C_noret_decl(f_8322)
static void C_ccall f_8322(C_word c,C_word *av) C_noret;
C_noret_decl(f_8328)
static void C_ccall f_8328(C_word c,C_word *av) C_noret;
C_noret_decl(f_7472)
static void C_ccall f_7472(C_word c,C_word *av) C_noret;
C_noret_decl(f_8092)
static void C_ccall f_8092(C_word c,C_word *av) C_noret;
C_noret_decl(f_7468)
static void C_ccall f_7468(C_word c,C_word *av) C_noret;
C_noret_decl(f_8311)
static void C_fcall f_8311(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6) C_noret;
C_noret_decl(f_8315)
static void C_ccall f_8315(C_word c,C_word *av) C_noret;
C_noret_decl(f_3233)
static void C_fcall f_3233(C_word t0,C_word t1) C_noret;
C_noret_decl(f_7478)
static void C_ccall f_7478(C_word c,C_word *av) C_noret;
C_noret_decl(f_7475)
static void C_fcall f_7475(C_word t0,C_word t1) C_noret;
C_noret_decl(f_8097)
static void C_ccall f_8097(C_word c,C_word *av) C_noret;
C_noret_decl(f_8345)
static void C_ccall f_8345(C_word c,C_word *av) C_noret;
C_noret_decl(f_8349)
static void C_ccall f_8349(C_word c,C_word *av) C_noret;
C_noret_decl(f_5389)
static void C_ccall f_5389(C_word c,C_word *av) C_noret;
C_noret_decl(f_5385)
static void C_ccall f_5385(C_word c,C_word *av) C_noret;
C_noret_decl(f_8334)
static void C_ccall f_8334(C_word c,C_word *av) C_noret;
C_noret_decl(f_3237)
static void C_ccall f_3237(C_word c,C_word *av) C_noret;
C_noret_decl(f_5377)
static void C_ccall f_5377(C_word c,C_word *av) C_noret;
C_noret_decl(f_5370)
static void C_ccall f_5370(C_word c,C_word *av) C_noret;
C_noret_decl(f_3267)
static void C_ccall f_3267(C_word c,C_word *av) C_noret;
C_noret_decl(f_3412)
static void C_ccall f_3412(C_word c,C_word *av) C_noret;
C_noret_decl(f_3257)
static void C_fcall f_3257(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_3256)
static void C_ccall f_3256(C_word c,C_word *av) C_noret;
C_noret_decl(f_4382)
static void C_ccall f_4382(C_word c,C_word *av) C_noret;
C_noret_decl(f_6399)
static void C_ccall f_6399(C_word c,C_word *av) C_noret;
C_noret_decl(f_6393)
static void C_ccall f_6393(C_word c,C_word *av) C_noret;
C_noret_decl(f_4388)
static void C_ccall f_4388(C_word c,C_word *av) C_noret;
C_noret_decl(f_8088)
static void C_ccall f_8088(C_word c,C_word *av) C_noret;
C_noret_decl(f_8802)
static void C_ccall f_8802(C_word c,C_word *av) C_noret;
C_noret_decl(f_8808)
static void C_ccall f_8808(C_word c,C_word *av) C_noret;
C_noret_decl(f_8806)
static void C_ccall f_8806(C_word c,C_word *av) C_noret;
C_noret_decl(f_4391)
static void C_ccall f_4391(C_word c,C_word *av) C_noret;
C_noret_decl(f_3038)
static void C_fcall f_3038(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_8828)
static void C_ccall f_8828(C_word c,C_word *av) C_noret;
C_noret_decl(f_3033)
static void C_ccall f_3033(C_word c,C_word *av) C_noret;
C_noret_decl(f_8818)
static void C_ccall f_8818(C_word c,C_word *av) C_noret;
C_noret_decl(f_6737)
static void C_ccall f_6737(C_word c,C_word *av) C_noret;
C_noret_decl(f_5306)
static void C_ccall f_5306(C_word c,C_word *av) C_noret;
C_noret_decl(f_3006)
static void C_ccall f_3006(C_word c,C_word *av) C_noret;
C_noret_decl(f_6717)
static void C_ccall f_6717(C_word c,C_word *av) C_noret;
C_noret_decl(f_3000)
static void C_ccall f_3000(C_word c,C_word *av) C_noret;
C_noret_decl(f_3075)
static void C_fcall f_3075(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_5329)
static void C_ccall f_5329(C_word c,C_word *av) C_noret;
C_noret_decl(f_5394)
static void C_ccall f_5394(C_word c,C_word *av) C_noret;
C_noret_decl(f_6702)
static void C_fcall f_6702(C_word t0,C_word t1) C_noret;
C_noret_decl(f_6707)
static void C_ccall f_6707(C_word c,C_word *av) C_noret;
C_noret_decl(f_3090)
static void C_ccall f_3090(C_word c,C_word *av) C_noret;
C_noret_decl(f_5123)
static C_word C_fcall f_5123(C_word t0,C_word t1,C_word t2);
C_noret_decl(f_3046)
static void C_ccall f_3046(C_word c,C_word *av) C_noret;
C_noret_decl(f_8031)
static void C_ccall f_8031(C_word c,C_word *av) C_noret;
C_noret_decl(f_6324)
static void C_ccall f_6324(C_word c,C_word *av) C_noret;
C_noret_decl(f_6328)
static void C_ccall f_6328(C_word c,C_word *av) C_noret;
C_noret_decl(f_8063)
static void C_ccall f_8063(C_word c,C_word *av) C_noret;
C_noret_decl(f_8067)
static void C_fcall f_8067(C_word t0,C_word t1) C_noret;
C_noret_decl(f_3596)
static void C_ccall f_3596(C_word c,C_word *av) C_noret;
C_noret_decl(f_3590)
static void C_ccall f_3590(C_word c,C_word *av) C_noret;
C_noret_decl(f_4673)
static void C_ccall f_4673(C_word c,C_word *av) C_noret;
C_noret_decl(f_4670)
static void C_ccall f_4670(C_word c,C_word *av) C_noret;
C_noret_decl(f_4685)
static void C_ccall f_4685(C_word c,C_word *av) C_noret;
C_noret_decl(f_3575)
static void C_fcall f_3575(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_4694)
static void C_ccall f_4694(C_word c,C_word *av) C_noret;
C_noret_decl(f_4620)
static void C_ccall f_4620(C_word c,C_word *av) C_noret;
C_noret_decl(f_2911)
static void C_ccall f_2911(C_word c,C_word *av) C_noret;
C_noret_decl(f_2919)
static void C_ccall f_2919(C_word c,C_word *av) C_noret;
C_noret_decl(f_4657)
static void C_fcall f_4657(C_word t0,C_word t1) C_noret;
C_noret_decl(f_4653)
static void C_ccall f_4653(C_word c,C_word *av) C_noret;
C_noret_decl(f_6363)
static void C_ccall f_6363(C_word c,C_word *av) C_noret;
C_noret_decl(f_6365)
static void C_ccall f_6365(C_word c,C_word *av) C_noret;
C_noret_decl(f_5260)
static void C_fcall f_5260(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_3509)
static void C_ccall f_3509(C_word c,C_word *av) C_noret;
C_noret_decl(f_6343)
static void C_ccall f_6343(C_word c,C_word *av) C_noret;
C_noret_decl(f_5233)
static void C_ccall f_5233(C_word c,C_word *av) C_noret;
C_noret_decl(f_2921)
static void C_ccall f_2921(C_word c,C_word *av) C_noret;
C_noret_decl(f_2929)
static void C_ccall f_2929(C_word c,C_word *av) C_noret;
C_noret_decl(f_5226)
static void C_ccall f_5226(C_word c,C_word *av) C_noret;
C_noret_decl(f_5217)
static void C_ccall f_5217(C_word c,C_word *av) C_noret;
C_noret_decl(f_5214)
static void C_ccall f_5214(C_word c,C_word *av) C_noret;
C_noret_decl(f_2941)
static void C_ccall f_2941(C_word c,C_word *av) C_noret;
C_noret_decl(f_2949)
static void C_ccall f_2949(C_word c,C_word *av) C_noret;
C_noret_decl(f_3449)
static void C_ccall f_3449(C_word c,C_word *av) C_noret;
C_noret_decl(f_2931)
static void C_ccall f_2931(C_word c,C_word *av) C_noret;
C_noret_decl(f_2939)
static void C_ccall f_2939(C_word c,C_word *av) C_noret;
C_noret_decl(f_8259)
static void C_ccall f_8259(C_word c,C_word *av) C_noret;
C_noret_decl(f_3434)
static void C_ccall f_3434(C_word c,C_word *av) C_noret;
C_noret_decl(f_2961)
static void C_ccall f_2961(C_word c,C_word *av) C_noret;
C_noret_decl(f_8255)
static void C_fcall f_8255(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6,C_word t7) C_noret;
C_noret_decl(f_3430)
static void C_ccall f_3430(C_word c,C_word *av) C_noret;
C_noret_decl(f_2969)
static void C_ccall f_2969(C_word c,C_word *av) C_noret;
C_noret_decl(f_7791)
static void C_ccall f_7791(C_word c,C_word *av) C_noret;
C_noret_decl(f_8241)
static C_word C_fcall f_8241(C_word *a,C_word t0);
C_noret_decl(f_8278)
static void C_ccall f_8278(C_word c,C_word *av) C_noret;
C_noret_decl(f_3455)
static void C_ccall f_3455(C_word c,C_word *av) C_noret;
C_noret_decl(f_3459)
static void C_ccall f_3459(C_word c,C_word *av) C_noret;
C_noret_decl(f_6763)
static void C_ccall f_6763(C_word c,C_word *av) C_noret;
C_noret_decl(f_3452)
static void C_ccall f_3452(C_word c,C_word *av) C_noret;
C_noret_decl(f_2988)
static void C_fcall f_2988(C_word t0,C_word t1) C_noret;
C_noret_decl(f_8276)
static void C_ccall f_8276(C_word c,C_word *av) C_noret;
C_noret_decl(f_2984)
static void C_ccall f_2984(C_word c,C_word *av) C_noret;
C_noret_decl(f_2971)
static void C_ccall f_2971(C_word c,C_word *av) C_noret;
C_noret_decl(f_2979)
static void C_ccall f_2979(C_word c,C_word *av) C_noret;
C_noret_decl(f_8265)
static void C_ccall f_8265(C_word c,C_word *av) C_noret;
C_noret_decl(f_8262)
static void C_ccall f_8262(C_word c,C_word *av) C_noret;
C_noret_decl(f_8214)
static void C_fcall f_8214(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_8209)
static void C_ccall f_8209(C_word c,C_word *av) C_noret;
C_noret_decl(f_8203)
static void C_ccall f_8203(C_word c,C_word *av) C_noret;
C_noret_decl(f_8575)
static void C_ccall f_8575(C_word c,C_word *av) C_noret;
C_noret_decl(f_5818)
static void C_ccall f_5818(C_word c,C_word *av) C_noret;
C_noret_decl(f_5814)
static void C_fcall f_5814(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_5812)
static void C_ccall f_5812(C_word c,C_word *av) C_noret;
C_noret_decl(f_8593)
static void C_ccall f_8593(C_word c,C_word *av) C_noret;
C_noret_decl(f_4017)
static void C_ccall f_4017(C_word c,C_word *av) C_noret;
C_noret_decl(f_5808)
static void C_ccall f_5808(C_word c,C_word *av) C_noret;
C_noret_decl(f_5804)
static void C_ccall f_5804(C_word c,C_word *av) C_noret;
C_noret_decl(f_4021)
static void C_ccall f_4021(C_word c,C_word *av) C_noret;
C_noret_decl(f_4025)
static void C_ccall f_4025(C_word c,C_word *av) C_noret;
C_noret_decl(f_2951)
static void C_ccall f_2951(C_word c,C_word *av) C_noret;
C_noret_decl(f_2959)
static void C_ccall f_2959(C_word c,C_word *av) C_noret;
C_noret_decl(f_4031)
static void C_ccall f_4031(C_word c,C_word *av) C_noret;
C_noret_decl(f_8569)
static void C_ccall f_8569(C_word c,C_word *av) C_noret;
C_noret_decl(f_5355)
static void C_ccall f_5355(C_word c,C_word *av) C_noret;
C_noret_decl(f_6504)
static void C_ccall f_6504(C_word c,C_word *av) C_noret;
C_noret_decl(f_8552)
static void C_ccall f_8552(C_word c,C_word *av) C_noret;
C_noret_decl(f_3193)
static void C_ccall f_3193(C_word c,C_word *av) C_noret;
C_noret_decl(f_8588)
static void C_ccall f_8588(C_word c,C_word *av) C_noret;
C_noret_decl(f_4062)
static void C_ccall f_4062(C_word c,C_word *av) C_noret;
C_noret_decl(f_8288)
static void C_ccall f_8288(C_word c,C_word *av) C_noret;
C_noret_decl(f_8582)
static void C_ccall f_8582(C_word c,C_word *av) C_noret;
C_noret_decl(f_2806)
static void C_ccall f_2806(C_word c,C_word *av) C_noret;
C_noret_decl(f_2804)
static void C_ccall f_2804(C_word c,C_word *av) C_noret;
C_noret_decl(f_2800)
static void C_ccall f_2800(C_word c,C_word *av) C_noret;
C_noret_decl(f_8285)
static void C_ccall f_8285(C_word c,C_word *av) C_noret;
C_noret_decl(f_8282)
static void C_ccall f_8282(C_word c,C_word *av) C_noret;
C_noret_decl(f_4069)
static void C_ccall f_4069(C_word c,C_word *av) C_noret;
C_noret_decl(f_5894)
static void C_ccall f_5894(C_word c,C_word *av) C_noret;
C_noret_decl(f_4078)
static void C_ccall f_4078(C_word c,C_word *av) C_noret;
C_noret_decl(f_6539)
static void C_ccall f_6539(C_word c,C_word *av) C_noret;
C_noret_decl(f_6537)
static void C_ccall f_6537(C_word c,C_word *av) C_noret;
C_noret_decl(f_6533)
static void C_ccall f_6533(C_word c,C_word *av) C_noret;
C_noret_decl(f_5315)
static void C_ccall f_5315(C_word c,C_word *av) C_noret;
C_noret_decl(f_4092)
static void C_ccall f_4092(C_word c,C_word *av) C_noret;
C_noret_decl(f_4095)
static void C_ccall f_4095(C_word c,C_word *av) C_noret;
C_noret_decl(f_4088)
static void C_ccall f_4088(C_word c,C_word *av) C_noret;
C_noret_decl(f_6543)
static void C_ccall f_6543(C_word c,C_word *av) C_noret;
C_noret_decl(f_5346)
static void C_ccall f_5346(C_word c,C_word *av) C_noret;
C_noret_decl(f_5874)
static void C_ccall f_5874(C_word c,C_word *av) C_noret;
C_noret_decl(f_5871)
static void C_ccall f_5871(C_word c,C_word *av) C_noret;
C_noret_decl(f_5879)
static void C_fcall f_5879(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_5336)
static void C_ccall f_5336(C_word c,C_word *av) C_noret;
C_noret_decl(f_4360)
static void C_fcall f_4360(C_word t0,C_word t1) C_noret;
C_noret_decl(f_4364)
static void C_ccall f_4364(C_word c,C_word *av) C_noret;
C_noret_decl(f_5864)
static void C_ccall f_5864(C_word c,C_word *av) C_noret;
C_noret_decl(f_4366)
static void C_fcall f_4366(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_5868)
static void C_ccall f_5868(C_word c,C_word *av) C_noret;
C_noret_decl(f_5362)
static void C_ccall f_5362(C_word c,C_word *av) C_noret;
C_noret_decl(f_6576)
static void C_ccall f_6576(C_word c,C_word *av) C_noret;
C_noret_decl(f_7173)
static void C_ccall f_7173(C_word c,C_word *av) C_noret;
C_noret_decl(f_4343)
static void C_ccall f_4343(C_word c,C_word *av) C_noret;
C_noret_decl(f_5842)
static void C_ccall f_5842(C_word c,C_word *av) C_noret;
C_noret_decl(f_4349)
static void C_ccall f_4349(C_word c,C_word *av) C_noret;
C_noret_decl(f_6586)
static void C_ccall f_6586(C_word c,C_word *av) C_noret;
C_noret_decl(f_2816)
static void C_ccall f_2816(C_word c,C_word *av) C_noret;
C_noret_decl(f_2818)
static void C_ccall f_2818(C_word c,C_word *av) C_noret;
C_noret_decl(f_2812)
static void C_ccall f_2812(C_word c,C_word *av) C_noret;
C_noret_decl(f_4513)
static void C_ccall f_4513(C_word c,C_word *av) C_noret;
C_noret_decl(f_2810)
static void C_ccall f_2810(C_word c,C_word *av) C_noret;
C_noret_decl(f_4510)
static void C_ccall f_4510(C_word c,C_word *av) C_noret;
C_noret_decl(f_7149)
static void C_ccall f_7149(C_word c,C_word *av) C_noret;
C_noret_decl(f_4353)
static void C_ccall f_4353(C_word c,C_word *av) C_noret;
C_noret_decl(f_4358)
static void C_ccall f_4358(C_word c,C_word *av) C_noret;
C_noret_decl(f_4521)
static void C_ccall f_4521(C_word c,C_word *av) C_noret;
C_noret_decl(f_4527)
static void C_ccall f_4527(C_word c,C_word *av) C_noret;
C_noret_decl(f_7159)
static void C_fcall f_7159(C_word t0,C_word t1) C_noret;
C_noret_decl(f_4321)
static void C_fcall f_4321(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_5828)
static void C_ccall f_5828(C_word c,C_word *av) C_noret;
C_noret_decl(f_4329)
static void C_ccall f_4329(C_word c,C_word *av) C_noret;
C_noret_decl(f_6564)
static void C_ccall f_6564(C_word c,C_word *av) C_noret;
C_noret_decl(f_8237)
static void C_ccall f_8237(C_word c,C_word *av) C_noret;
C_noret_decl(f_4332)
static void C_ccall f_4332(C_word c,C_word *av) C_noret;
C_noret_decl(f_4337)
static void C_ccall f_4337(C_word c,C_word *av) C_noret;
C_noret_decl(f_2822)
static void C_ccall f_2822(C_word c,C_word *av) C_noret;
C_noret_decl(f_2824)
static void C_ccall f_2824(C_word c,C_word *av) C_noret;
C_noret_decl(f_8225)
static void C_ccall f_8225(C_word c,C_word *av) C_noret;
C_noret_decl(f_8226)
static void C_fcall f_8226(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_7184)
static void C_fcall f_7184(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_6598)
static void C_ccall f_6598(C_word c,C_word *av) C_noret;
C_noret_decl(f_7166)
static void C_ccall f_7166(C_word c,C_word *av) C_noret;
C_noret_decl(f_3569)
static void C_ccall f_3569(C_word c,C_word *av) C_noret;
C_noret_decl(f_3600)
static void C_ccall f_3600(C_word c,C_word *av) C_noret;
C_noret_decl(f_4807)
static void C_ccall f_4807(C_word c,C_word *av) C_noret;
C_noret_decl(f_4801)
static void C_ccall f_4801(C_word c,C_word *av) C_noret;
C_noret_decl(f_3609)
static void C_fcall f_3609(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_3607)
static void C_ccall f_3607(C_word c,C_word *av) C_noret;
C_noret_decl(f_4814)
static void C_ccall f_4814(C_word c,C_word *av) C_noret;
C_noret_decl(f_3650)
static void C_ccall f_3650(C_word c,C_word *av) C_noret;
C_noret_decl(f_4836)
static void C_fcall f_4836(C_word t0,C_word t1) C_noret;
C_noret_decl(f_3642)
static void C_ccall f_3642(C_word c,C_word *av) C_noret;
C_noret_decl(f_8544)
static void C_ccall f_8544(C_word c,C_word *av) C_noret;
C_noret_decl(f_4844)
static void C_ccall f_4844(C_word c,C_word *av) C_noret;
C_noret_decl(f_2843)
static void C_ccall f_2843(C_word c,C_word *av) C_noret;
C_noret_decl(f_3670)
static void C_ccall f_3670(C_word c,C_word *av) C_noret;
C_noret_decl(f_3104)
static void C_ccall f_3104(C_word c,C_word *av) C_noret;
C_noret_decl(f_3102)
static void C_ccall f_3102(C_word c,C_word *av) C_noret;
C_noret_decl(f_3134)
static void C_ccall f_3134(C_word c,C_word *av) C_noret;
C_noret_decl(f_5904)
static void C_ccall f_5904(C_word c,C_word *av) C_noret;
C_noret_decl(f_3695)
static void C_fcall f_3695(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_3693)
static void C_ccall f_3693(C_word c,C_word *av) C_noret;
C_noret_decl(f_7535)
static void C_fcall f_7535(C_word t0,C_word t1) C_noret;
C_noret_decl(f_3166)
static void C_ccall f_3166(C_word c,C_word *av) C_noret;
C_noret_decl(f_6822)
static void C_ccall f_6822(C_word c,C_word *av) C_noret;
C_noret_decl(f_3160)
static void C_ccall f_3160(C_word c,C_word *av) C_noret;
C_noret_decl(f_3686)
static void C_fcall f_3686(C_word t0,C_word t1) C_noret;
C_noret_decl(f_3683)
static void C_fcall f_3683(C_word t0,C_word t1) C_noret;
C_noret_decl(f_3116)
static void C_ccall f_3116(C_word c,C_word *av) C_noret;
C_noret_decl(f_3118)
static void C_ccall f_3118(C_word c,C_word *av) C_noret;
C_noret_decl(f_2715)
static void C_ccall f_2715(C_word c,C_word *av) C_noret;
C_noret_decl(f_3143)
static void C_ccall f_3143(C_word c,C_word *av) C_noret;
C_noret_decl(f_2719)
static void C_ccall f_2719(C_word c,C_word *av) C_noret;
C_noret_decl(f_2708)
static void C_ccall f_2708(C_word c,C_word *av) C_noret;
C_noret_decl(f_2704)
static void C_ccall f_2704(C_word c,C_word *av) C_noret;
C_noret_decl(f_3173)
static void C_fcall f_3173(C_word t0,C_word t1) C_noret;
C_noret_decl(f_3176)
static void C_ccall f_3176(C_word c,C_word *av) C_noret;
C_noret_decl(f_7528)
static void C_ccall f_7528(C_word c,C_word *av) C_noret;
C_noret_decl(f_3717)
static void C_ccall f_3717(C_word c,C_word *av) C_noret;
C_noret_decl(f_7570)
static void C_ccall f_7570(C_word c,C_word *av) C_noret;
C_noret_decl(f_5932)
static void C_ccall f_5932(C_word c,C_word *av) C_noret;
C_noret_decl(f_5937)
static void C_fcall f_5937(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_5599)
static void C_ccall f_5599(C_word c,C_word *av) C_noret;
C_noret_decl(f_5597)
static void C_ccall f_5597(C_word c,C_word *av) C_noret;
C_noret_decl(f_3708)
static void C_ccall f_3708(C_word c,C_word *av) C_noret;
C_noret_decl(f_7585)
static void C_ccall f_7585(C_word c,C_word *av) C_noret;
C_noret_decl(f_2751)
static void C_ccall f_2751(C_word c,C_word *av) C_noret;
C_noret_decl(f_6088)
static void C_ccall f_6088(C_word c,C_word *av) C_noret;
C_noret_decl(f_5953)
static void C_ccall f_5953(C_word c,C_word *av) C_noret;
C_noret_decl(f_2747)
static void C_ccall f_2747(C_word c,C_word *av) C_noret;
C_noret_decl(f_7561)
static void C_ccall f_7561(C_word c,C_word *av) C_noret;
C_noret_decl(f_6090)
static void C_ccall f_6090(C_word c,C_word *av) C_noret;
C_noret_decl(f_6812)
static void C_ccall f_6812(C_word c,C_word *av) C_noret;
C_noret_decl(f_2772)
static void C_ccall f_2772(C_word c,C_word *av) C_noret;
C_noret_decl(f_2779)
static void C_ccall f_2779(C_word c,C_word *av) C_noret;
C_noret_decl(f_2760)
static void C_ccall f_2760(C_word c,C_word *av) C_noret;
C_noret_decl(f_2767)
static void C_ccall f_2767(C_word c,C_word *av) C_noret;
C_noret_decl(f_2792)
static void C_ccall f_2792(C_word c,C_word *av) C_noret;
C_noret_decl(f_2798)
static void C_ccall f_2798(C_word c,C_word *av) C_noret;
C_noret_decl(f_6203)
static void C_ccall f_6203(C_word c,C_word *av) C_noret;
C_noret_decl(f_6202)
static void C_ccall f_6202(C_word c,C_word *av) C_noret;
C_noret_decl(f_7398)
static void C_ccall f_7398(C_word c,C_word *av) C_noret;
C_noret_decl(f_2794)
static void C_ccall f_2794(C_word c,C_word *av) C_noret;
C_noret_decl(f_3630)
static void C_fcall f_3630(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_6208)
static void C_ccall f_6208(C_word c,C_word *av) C_noret;
C_noret_decl(f_7390)
static void C_ccall f_7390(C_word c,C_word *av) C_noret;
C_noret_decl(f_5991)
static void C_ccall f_5991(C_word c,C_word *av) C_noret;
C_noret_decl(f_5572)
static C_word C_fcall f_5572(C_word t0);
C_noret_decl(f_3626)
static void C_ccall f_3626(C_word c,C_word *av) C_noret;
C_noret_decl(f_3638)
static void C_ccall f_3638(C_word c,C_word *av) C_noret;
C_noret_decl(f_4830)
static void C_fcall f_4830(C_word t0,C_word t1) C_noret;
C_noret_decl(f_4833)
static void C_fcall f_4833(C_word t0,C_word t1) C_noret;
C_noret_decl(f_4826)
static void C_ccall f_4826(C_word c,C_word *av) C_noret;
C_noret_decl(f_7694)
static void C_fcall f_7694(C_word t0,C_word t1) C_noret;
C_noret_decl(f_3798)
static void C_ccall f_3798(C_word c,C_word *av) C_noret;
C_noret_decl(f_3783)
static void C_ccall f_3783(C_word c,C_word *av) C_noret;
C_noret_decl(f_3780)
static void C_ccall f_3780(C_word c,C_word *av) C_noret;
C_noret_decl(f_3788)
static void C_ccall f_3788(C_word c,C_word *av) C_noret;
C_noret_decl(f_4716)
static void C_ccall f_4716(C_word c,C_word *av) C_noret;
C_noret_decl(f_3776)
static void C_ccall f_3776(C_word c,C_word *av) C_noret;
C_noret_decl(f_6003)
static void C_ccall f_6003(C_word c,C_word *av) C_noret;
C_noret_decl(f_3763)
static void C_ccall f_3763(C_word c,C_word *av) C_noret;
C_noret_decl(f_8765)
static void C_ccall f_8765(C_word c,C_word *av) C_noret;
C_noret_decl(f_3761)
static void C_ccall f_3761(C_word c,C_word *av) C_noret;
C_noret_decl(f_8769)
static void C_ccall f_8769(C_word c,C_word *av) C_noret;
C_noret_decl(f_3768)
static void C_ccall f_3768(C_word c,C_word *av) C_noret;
C_noret_decl(f_6019)
static void C_ccall f_6019(C_word c,C_word *av) C_noret;
C_noret_decl(f_3751)
static void C_ccall f_3751(C_word c,C_word *av) C_noret;
C_noret_decl(f_6263)
static void C_ccall f_6263(C_word c,C_word *av) C_noret;
C_noret_decl(f_8759)
static void C_ccall f_8759(C_word c,C_word *av) C_noret;
C_noret_decl(f_6269)
static void C_ccall f_6269(C_word c,C_word *av) C_noret;
C_noret_decl(f_5605)
static void C_ccall f_5605(C_word c,C_word *av) C_noret;
C_noret_decl(f_3742)
static void C_ccall f_3742(C_word c,C_word *av) C_noret;
C_noret_decl(f_6278)
static void C_ccall f_6278(C_word c,C_word *av) C_noret;
C_noret_decl(f_8781)
static void C_ccall f_8781(C_word c,C_word *av) C_noret;
C_noret_decl(f_5923)
static void C_ccall f_5923(C_word c,C_word *av) C_noret;
C_noret_decl(f_5928)
static void C_ccall f_5928(C_word c,C_word *av) C_noret;
C_noret_decl(f_3739)
static void C_ccall f_3739(C_word c,C_word *av) C_noret;
C_noret_decl(f_6281)
static void C_ccall f_6281(C_word c,C_word *av) C_noret;
C_noret_decl(f_6284)
static void C_ccall f_6284(C_word c,C_word *av) C_noret;
C_noret_decl(f_8447)
static void C_ccall f_8447(C_word c,C_word *av) C_noret;
C_noret_decl(f_8449)
static void C_ccall f_8449(C_word c,C_word *av) C_noret;
C_noret_decl(f_8772)
static void C_ccall f_8772(C_word c,C_word *av) C_noret;
C_noret_decl(f_6290)
static void C_ccall f_6290(C_word c,C_word *av) C_noret;
C_noret_decl(f_6222)
static void C_ccall f_6222(C_word c,C_word *av) C_noret;
C_noret_decl(f_8467)
static void C_ccall f_8467(C_word c,C_word *av) C_noret;
C_noret_decl(f_2722)
static void C_fcall f_2722(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_3389)
static void C_ccall f_3389(C_word c,C_word *av) C_noret;
C_noret_decl(f_2726)
static void C_ccall f_2726(C_word c,C_word *av) C_noret;
C_noret_decl(f_6237)
static void C_ccall f_6237(C_word c,C_word *av) C_noret;
C_noret_decl(f_3381)
static void C_ccall f_3381(C_word c,C_word *av) C_noret;
C_noret_decl(f_3383)
static void C_ccall f_3383(C_word c,C_word *av) C_noret;
C_noret_decl(f_8497)
static void C_ccall f_8497(C_word c,C_word *av) C_noret;
C_noret_decl(f_7606)
static void C_ccall f_7606(C_word c,C_word *av) C_noret;
C_noret_decl(f_4794)
static void C_ccall f_4794(C_word c,C_word *av) C_noret;
C_noret_decl(f_6243)
static void C_ccall f_6243(C_word c,C_word *av) C_noret;
C_noret_decl(f_5548)
static void C_ccall f_5548(C_word c,C_word *av) C_noret;
C_noret_decl(f_7602)
static void C_ccall f_7602(C_word c,C_word *av) C_noret;
C_noret_decl(f_3374)
static void C_ccall f_3374(C_word c,C_word *av) C_noret;
C_noret_decl(f_4767)
static void C_fcall f_4767(C_word t0,C_word t1) C_noret;
C_noret_decl(f_4764)
static void C_ccall f_4764(C_word c,C_word *av) C_noret;
C_noret_decl(f_7325)
static void C_ccall f_7325(C_word c,C_word *av) C_noret;
C_noret_decl(f_8697)
static void C_fcall f_8697(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_6253)
static void C_fcall f_6253(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_6251)
static void C_ccall f_6251(C_word c,C_word *av) C_noret;
C_noret_decl(f_8691)
static void C_ccall f_8691(C_word c,C_word *av) C_noret;
C_noret_decl(f_4773)
static void C_ccall f_4773(C_word c,C_word *av) C_noret;
C_noret_decl(f_8685)
static void C_ccall f_8685(C_word c,C_word *av) C_noret;
C_noret_decl(f_4542)
static void C_ccall f_4542(C_word c,C_word *av) C_noret;
C_noret_decl(f_4544)
static void C_ccall f_4544(C_word c,C_word *av) C_noret;
C_noret_decl(f_5685)
static void C_ccall f_5685(C_word c,C_word *av) C_noret;
C_noret_decl(f_5681)
static void C_ccall f_5681(C_word c,C_word *av) C_noret;
C_noret_decl(f_5689)
static void C_ccall f_5689(C_word c,C_word *av) C_noret;
C_noret_decl(f_7636)
static void C_ccall f_7636(C_word c,C_word *av) C_noret;
C_noret_decl(f_7630)
static void C_ccall f_7630(C_word c,C_word *av) C_noret;
C_noret_decl(f_5670)
static void C_ccall f_5670(C_word c,C_word *av) C_noret;
C_noret_decl(f_5677)
static void C_ccall f_5677(C_word c,C_word *av) C_noret;
C_noret_decl(f_4757)
static void C_ccall f_4757(C_word c,C_word *av) C_noret;
C_noret_decl(f_7641)
static void C_ccall f_7641(C_word c,C_word *av) C_noret;
C_noret_decl(f_5664)
static void C_ccall f_5664(C_word c,C_word *av) C_noret;
C_noret_decl(f_5660)
static void C_ccall f_5660(C_word c,C_word *av) C_noret;
C_noret_decl(f_4726)
static void C_ccall f_4726(C_word c,C_word *av) C_noret;
C_noret_decl(f_4729)
static void C_ccall f_4729(C_word c,C_word *av) C_noret;
C_noret_decl(f_8656)
static void C_ccall f_8656(C_word c,C_word *av) C_noret;
C_noret_decl(f_7614)
static void C_ccall f_7614(C_word c,C_word *av) C_noret;
C_noret_decl(f_8653)
static void C_ccall f_8653(C_word c,C_word *av) C_noret;
C_noret_decl(f_8647)
static void C_ccall f_8647(C_word c,C_word *av) C_noret;
C_noret_decl(f_4732)
static void C_ccall f_4732(C_word c,C_word *av) C_noret;
C_noret_decl(f_7626)
static void C_ccall f_7626(C_word c,C_word *av) C_noret;
C_noret_decl(f_7622)
static void C_ccall f_7622(C_word c,C_word *av) C_noret;
C_noret_decl(f_4506)
static void C_ccall f_4506(C_word c,C_word *av) C_noret;
C_noret_decl(f_5641)
static void C_ccall f_5641(C_word c,C_word *av) C_noret;
C_noret_decl(f_4500)
static void C_ccall f_4500(C_word c,C_word *av) C_noret;
C_noret_decl(f_7679)
static void C_ccall f_7679(C_word c,C_word *av) C_noret;
C_noret_decl(f_5648)
static void C_ccall f_5648(C_word c,C_word *av) C_noret;
C_noret_decl(f_8675)
static void C_ccall f_8675(C_word c,C_word *av) C_noret;
C_noret_decl(f_4550)
static void C_ccall f_4550(C_word c,C_word *av) C_noret;
C_noret_decl(f_7675)
static void C_ccall f_7675(C_word c,C_word *av) C_noret;
C_noret_decl(f_4556)
static void C_ccall f_4556(C_word c,C_word *av) C_noret;
C_noret_decl(f_5637)
static void C_ccall f_5637(C_word c,C_word *av) C_noret;
C_noret_decl(f_8672)
static void C_ccall f_8672(C_word c,C_word *av) C_noret;
C_noret_decl(f_2680)
static void C_ccall f_2680(C_word c,C_word *av) C_noret;
C_noret_decl(f_2689)
static void C_ccall f_2689(C_word c,C_word *av) C_noret;
C_noret_decl(f_2686)
static void C_ccall f_2686(C_word c,C_word *av) C_noret;
C_noret_decl(f_2683)
static void C_ccall f_2683(C_word c,C_word *av) C_noret;
C_noret_decl(f_8666)
static void C_ccall f_8666(C_word c,C_word *av) C_noret;
C_noret_decl(f_7353)
static void C_ccall f_7353(C_word c,C_word *av) C_noret;
C_noret_decl(f_7682)
static void C_fcall f_7682(C_word t0,C_word t1) C_noret;
C_noret_decl(f_4563)
static void C_ccall f_4563(C_word c,C_word *av) C_noret;
C_noret_decl(f_7685)
static void C_ccall f_7685(C_word c,C_word *av) C_noret;
C_noret_decl(f_5621)
static void C_ccall f_5621(C_word c,C_word *av) C_noret;
C_noret_decl(f_6888)
static void C_ccall f_6888(C_word c,C_word *av) C_noret;
C_noret_decl(f_2677)
static void C_ccall f_2677(C_word c,C_word *av) C_noret;
C_noret_decl(f_8421)
static void C_ccall f_8421(C_word c,C_word *av) C_noret;
C_noret_decl(f_4531)
static void C_fcall f_4531(C_word t0,C_word t1) C_noret;
C_noret_decl(f_8424)
static void C_ccall f_8424(C_word c,C_word *av) C_noret;
C_noret_decl(f_7654)
static void C_ccall f_7654(C_word c,C_word *av) C_noret;
C_noret_decl(f_7668)
static void C_ccall f_7668(C_word c,C_word *av) C_noret;
C_noret_decl(f_4538)
static void C_ccall f_4538(C_word c,C_word *av) C_noret;
C_noret_decl(f_5691)
static void C_ccall f_5691(C_word c,C_word *av) C_noret;
C_noret_decl(f_5698)
static void C_fcall f_5698(C_word t0,C_word t1) C_noret;
C_noret_decl(f_8429)
static void C_ccall f_8429(C_word c,C_word *av) C_noret;
C_noret_decl(f_2692)
static void C_ccall f_2692(C_word c,C_word *av) C_noret;
C_noret_decl(f_3816)
static void C_ccall f_3816(C_word c,C_word *av) C_noret;
C_noret_decl(f_8443)
static void C_ccall f_8443(C_word c,C_word *av) C_noret;
C_noret_decl(f_7302)
static void C_ccall f_7302(C_word c,C_word *av) C_noret;
C_noret_decl(f_5501)
static void C_ccall f_5501(C_word c,C_word *av) C_noret;
C_noret_decl(f_5505)
static void C_ccall f_5505(C_word c,C_word *av) C_noret;
C_noret_decl(f_7360)
static void C_fcall f_7360(C_word t0,C_word t1) C_noret;
C_noret_decl(f_5652)
static void C_ccall f_5652(C_word c,C_word *av) C_noret;
C_noret_decl(f_5656)
static void C_ccall f_5656(C_word c,C_word *av) C_noret;
C_noret_decl(f_5496)
static void C_ccall f_5496(C_word c,C_word *av) C_noret;
C_noret_decl(f_5491)
static void C_ccall f_5491(C_word c,C_word *av) C_noret;
C_noret_decl(f_7377)
static void C_ccall f_7377(C_word c,C_word *av) C_noret;
C_noret_decl(f_5476)
static void C_ccall f_5476(C_word c,C_word *av) C_noret;
C_noret_decl(f_5471)
static void C_ccall f_5471(C_word c,C_word *av) C_noret;
C_noret_decl(f_3807)
static void C_ccall f_3807(C_word c,C_word *av) C_noret;
C_noret_decl(f_5719)
static void C_ccall f_5719(C_word c,C_word *av) C_noret;
C_noret_decl(f_5715)
static void C_ccall f_5715(C_word c,C_word *av) C_noret;
C_noret_decl(f_5711)
static void C_ccall f_5711(C_word c,C_word *av) C_noret;
C_noret_decl(f_3801)
static void C_ccall f_3801(C_word c,C_word *av) C_noret;
C_noret_decl(f_3351)
static void C_ccall f_3351(C_word c,C_word *av) C_noret;
C_noret_decl(f_4474)
static void C_ccall f_4474(C_word c,C_word *av) C_noret;
C_noret_decl(f_3823)
static void C_ccall f_3823(C_word c,C_word *av) C_noret;
C_noret_decl(f_5007)
static void C_fcall f_5007(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_4280)
static void C_ccall f_4280(C_word c,C_word *av) C_noret;
C_noret_decl(f_3899)
static void C_ccall f_3899(C_word c,C_word *av) C_noret;
C_noret_decl(f_3348)
static void C_fcall f_3348(C_word t0,C_word t1) C_noret;
C_noret_decl(f_3341)
static void C_fcall f_3341(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_4480)
static void C_ccall f_4480(C_word c,C_word *av) C_noret;
C_noret_decl(f_3893)
static void C_ccall f_3893(C_word c,C_word *av) C_noret;
C_noret_decl(f_3891)
static void C_ccall f_3891(C_word c,C_word *av) C_noret;
C_noret_decl(f_3849)
static void C_ccall f_3849(C_word c,C_word *av) C_noret;
C_noret_decl(f_4476)
static void C_fcall f_4476(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6,C_word t7) C_noret;
C_noret_decl(f_3339)
static void C_ccall f_3339(C_word c,C_word *av) C_noret;

C_noret_decl(trf_6621)
static void C_ccall trf_6621(C_word c,C_word *av) C_noret;
static void C_ccall trf_6621(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_6621(t0,t1);}

C_noret_decl(trf_6623)
static void C_ccall trf_6623(C_word c,C_word *av) C_noret;
static void C_ccall trf_6623(C_word c,C_word *av){
C_word t0=av[4];
C_word t1=av[3];
C_word t2=av[2];
C_word t3=av[1];
C_word t4=av[0];
f_6623(t0,t1,t2,t3,t4);}

C_noret_decl(trf_7756)
static void C_ccall trf_7756(C_word c,C_word *av) C_noret;
static void C_ccall trf_7756(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_7756(t0,t1,t2);}

C_noret_decl(trf_5791)
static void C_ccall trf_5791(C_word c,C_word *av) C_noret;
static void C_ccall trf_5791(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_5791(t0,t1);}

C_noret_decl(trf_4918)
static void C_ccall trf_4918(C_word c,C_word *av) C_noret;
static void C_ccall trf_4918(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_4918(t0,t1);}

C_noret_decl(trf_5068)
static void C_ccall trf_5068(C_word c,C_word *av) C_noret;
static void C_ccall trf_5068(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_5068(t0,t1);}

C_noret_decl(trf_7205)
static void C_ccall trf_7205(C_word c,C_word *av) C_noret;
static void C_ccall trf_7205(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_7205(t0,t1);}

C_noret_decl(trf_6437)
static void C_ccall trf_6437(C_word c,C_word *av) C_noret;
static void C_ccall trf_6437(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_6437(t0,t1);}

C_noret_decl(trf_4440)
static void C_ccall trf_4440(C_word c,C_word *av) C_noret;
static void C_ccall trf_4440(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_4440(t0,t1);}

C_noret_decl(trf_5036)
static void C_ccall trf_5036(C_word c,C_word *av) C_noret;
static void C_ccall trf_5036(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_5036(t0,t1);}

C_noret_decl(trf_4449)
static void C_ccall trf_4449(C_word c,C_word *av) C_noret;
static void C_ccall trf_4449(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_4449(t0,t1,t2);}

C_noret_decl(trf_3908)
static void C_ccall trf_3908(C_word c,C_word *av) C_noret;
static void C_ccall trf_3908(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_3908(t0,t1,t2);}

C_noret_decl(trf_7248)
static void C_ccall trf_7248(C_word c,C_word *av) C_noret;
static void C_ccall trf_7248(C_word c,C_word *av){
C_word t0=av[3];
C_word t1=av[2];
C_word t2=av[1];
C_word t3=av[0];
f_7248(t0,t1,t2,t3);}

C_noret_decl(trf_3281)
static void C_ccall trf_3281(C_word c,C_word *av) C_noret;
static void C_ccall trf_3281(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_3281(t0,t1,t2);}

C_noret_decl(trf_4977)
static void C_ccall trf_4977(C_word c,C_word *av) C_noret;
static void C_ccall trf_4977(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_4977(t0,t1);}

C_noret_decl(trf_4417)
static void C_ccall trf_4417(C_word c,C_word *av) C_noret;
static void C_ccall trf_4417(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_4417(t0,t1,t2);}

C_noret_decl(trf_4948)
static void C_ccall trf_4948(C_word c,C_word *av) C_noret;
static void C_ccall trf_4948(C_word c,C_word *av){
C_word t0=av[4];
C_word t1=av[3];
C_word t2=av[2];
C_word t3=av[1];
C_word t4=av[0];
f_4948(t0,t1,t2,t3,t4);}

C_noret_decl(trf_6400)
static void C_ccall trf_6400(C_word c,C_word *av) C_noret;
static void C_ccall trf_6400(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_6400(t0,t1);}

C_noret_decl(trf_8157)
static void C_ccall trf_8157(C_word c,C_word *av) C_noret;
static void C_ccall trf_8157(C_word c,C_word *av){
C_word t0=av[6];
C_word t1=av[5];
C_word t2=av[4];
C_word t3=av[3];
C_word t4=av[2];
C_word t5=av[1];
C_word t6=av[0];
f_8157(t0,t1,t2,t3,t4,t5,t6);}

C_noret_decl(trf_8107)
static void C_ccall trf_8107(C_word c,C_word *av) C_noret;
static void C_ccall trf_8107(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_8107(t0,t1);}

C_noret_decl(trf_6977)
static void C_ccall trf_6977(C_word c,C_word *av) C_noret;
static void C_ccall trf_6977(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_6977(t0,t1);}

C_noret_decl(trf_6116)
static void C_ccall trf_6116(C_word c,C_word *av) C_noret;
static void C_ccall trf_6116(C_word c,C_word *av){
C_word t0=av[3];
C_word t1=av[2];
C_word t2=av[1];
C_word t3=av[0];
f_6116(t0,t1,t2,t3);}

C_noret_decl(trf_8194)
static void C_ccall trf_8194(C_word c,C_word *av) C_noret;
static void C_ccall trf_8194(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_8194(t0,t1);}

C_noret_decl(trf_4167)
static void C_ccall trf_4167(C_word c,C_word *av) C_noret;
static void C_ccall trf_4167(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_4167(t0,t1,t2);}

C_noret_decl(trf_4179)
static void C_ccall trf_4179(C_word c,C_word *av) C_noret;
static void C_ccall trf_4179(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_4179(t0,t1,t2);}

C_noret_decl(trf_7056)
static void C_ccall trf_7056(C_word c,C_word *av) C_noret;
static void C_ccall trf_7056(C_word c,C_word *av){
C_word t0=av[4];
C_word t1=av[3];
C_word t2=av[2];
C_word t3=av[1];
C_word t4=av[0];
f_7056(t0,t1,t2,t3,t4);}

C_noret_decl(trf_8380)
static void C_ccall trf_8380(C_word c,C_word *av) C_noret;
static void C_ccall trf_8380(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_8380(t0,t1,t2);}

C_noret_decl(trf_8378)
static void C_ccall trf_8378(C_word c,C_word *av) C_noret;
static void C_ccall trf_8378(C_word c,C_word *av){
C_word t0=av[6];
C_word t1=av[5];
C_word t2=av[4];
C_word t3=av[3];
C_word t4=av[2];
C_word t5=av[1];
C_word t6=av[0];
f_8378(t0,t1,t2,t3,t4,t5,t6);}

C_noret_decl(trf_3473)
static void C_ccall trf_3473(C_word c,C_word *av) C_noret;
static void C_ccall trf_3473(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_3473(t0,t1);}

C_noret_decl(trf_3499)
static void C_ccall trf_3499(C_word c,C_word *av) C_noret;
static void C_ccall trf_3499(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_3499(t0,t1);}

C_noret_decl(trf_8300)
static void C_ccall trf_8300(C_word c,C_word *av) C_noret;
static void C_ccall trf_8300(C_word c,C_word *av){
C_word t0=av[6];
C_word t1=av[5];
C_word t2=av[4];
C_word t3=av[3];
C_word t4=av[2];
C_word t5=av[1];
C_word t6=av[0];
f_8300(t0,t1,t2,t3,t4,t5,t6);}

C_noret_decl(trf_8311)
static void C_ccall trf_8311(C_word c,C_word *av) C_noret;
static void C_ccall trf_8311(C_word c,C_word *av){
C_word t0=av[6];
C_word t1=av[5];
C_word t2=av[4];
C_word t3=av[3];
C_word t4=av[2];
C_word t5=av[1];
C_word t6=av[0];
f_8311(t0,t1,t2,t3,t4,t5,t6);}

C_noret_decl(trf_3233)
static void C_ccall trf_3233(C_word c,C_word *av) C_noret;
static void C_ccall trf_3233(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_3233(t0,t1);}

C_noret_decl(trf_7475)
static void C_ccall trf_7475(C_word c,C_word *av) C_noret;
static void C_ccall trf_7475(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_7475(t0,t1);}

C_noret_decl(trf_3257)
static void C_ccall trf_3257(C_word c,C_word *av) C_noret;
static void C_ccall trf_3257(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_3257(t0,t1,t2);}

C_noret_decl(trf_3038)
static void C_ccall trf_3038(C_word c,C_word *av) C_noret;
static void C_ccall trf_3038(C_word c,C_word *av){
C_word t0=av[3];
C_word t1=av[2];
C_word t2=av[1];
C_word t3=av[0];
f_3038(t0,t1,t2,t3);}

C_noret_decl(trf_3075)
static void C_ccall trf_3075(C_word c,C_word *av) C_noret;
static void C_ccall trf_3075(C_word c,C_word *av){
C_word t0=av[4];
C_word t1=av[3];
C_word t2=av[2];
C_word t3=av[1];
C_word t4=av[0];
f_3075(t0,t1,t2,t3,t4);}

C_noret_decl(trf_6702)
static void C_ccall trf_6702(C_word c,C_word *av) C_noret;
static void C_ccall trf_6702(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_6702(t0,t1);}

C_noret_decl(trf_8067)
static void C_ccall trf_8067(C_word c,C_word *av) C_noret;
static void C_ccall trf_8067(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_8067(t0,t1);}

C_noret_decl(trf_3575)
static void C_ccall trf_3575(C_word c,C_word *av) C_noret;
static void C_ccall trf_3575(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_3575(t0,t1,t2);}

C_noret_decl(trf_4657)
static void C_ccall trf_4657(C_word c,C_word *av) C_noret;
static void C_ccall trf_4657(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_4657(t0,t1);}

C_noret_decl(trf_5260)
static void C_ccall trf_5260(C_word c,C_word *av) C_noret;
static void C_ccall trf_5260(C_word c,C_word *av){
C_word t0=av[4];
C_word t1=av[3];
C_word t2=av[2];
C_word t3=av[1];
C_word t4=av[0];
f_5260(t0,t1,t2,t3,t4);}

C_noret_decl(trf_8255)
static void C_ccall trf_8255(C_word c,C_word *av) C_noret;
static void C_ccall trf_8255(C_word c,C_word *av){
C_word t0=av[7];
C_word t1=av[6];
C_word t2=av[5];
C_word t3=av[4];
C_word t4=av[3];
C_word t5=av[2];
C_word t6=av[1];
C_word t7=av[0];
f_8255(t0,t1,t2,t3,t4,t5,t6,t7);}

C_noret_decl(trf_2988)
static void C_ccall trf_2988(C_word c,C_word *av) C_noret;
static void C_ccall trf_2988(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_2988(t0,t1);}

C_noret_decl(trf_8214)
static void C_ccall trf_8214(C_word c,C_word *av) C_noret;
static void C_ccall trf_8214(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_8214(t0,t1,t2);}

C_noret_decl(trf_5814)
static void C_ccall trf_5814(C_word c,C_word *av) C_noret;
static void C_ccall trf_5814(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_5814(t0,t1,t2);}

C_noret_decl(trf_5879)
static void C_ccall trf_5879(C_word c,C_word *av) C_noret;
static void C_ccall trf_5879(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_5879(t0,t1,t2);}

C_noret_decl(trf_4360)
static void C_ccall trf_4360(C_word c,C_word *av) C_noret;
static void C_ccall trf_4360(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_4360(t0,t1);}

C_noret_decl(trf_4366)
static void C_ccall trf_4366(C_word c,C_word *av) C_noret;
static void C_ccall trf_4366(C_word c,C_word *av){
C_word t0=av[3];
C_word t1=av[2];
C_word t2=av[1];
C_word t3=av[0];
f_4366(t0,t1,t2,t3);}

C_noret_decl(trf_7159)
static void C_ccall trf_7159(C_word c,C_word *av) C_noret;
static void C_ccall trf_7159(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_7159(t0,t1);}

C_noret_decl(trf_4321)
static void C_ccall trf_4321(C_word c,C_word *av) C_noret;
static void C_ccall trf_4321(C_word c,C_word *av){
C_word t0=av[3];
C_word t1=av[2];
C_word t2=av[1];
C_word t3=av[0];
f_4321(t0,t1,t2,t3);}

C_noret_decl(trf_8226)
static void C_ccall trf_8226(C_word c,C_word *av) C_noret;
static void C_ccall trf_8226(C_word c,C_word *av){
C_word t0=av[3];
C_word t1=av[2];
C_word t2=av[1];
C_word t3=av[0];
f_8226(t0,t1,t2,t3);}

C_noret_decl(trf_7184)
static void C_ccall trf_7184(C_word c,C_word *av) C_noret;
static void C_ccall trf_7184(C_word c,C_word *av){
C_word t0=av[3];
C_word t1=av[2];
C_word t2=av[1];
C_word t3=av[0];
f_7184(t0,t1,t2,t3);}

C_noret_decl(trf_3609)
static void C_ccall trf_3609(C_word c,C_word *av) C_noret;
static void C_ccall trf_3609(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_3609(t0,t1,t2);}

C_noret_decl(trf_4836)
static void C_ccall trf_4836(C_word c,C_word *av) C_noret;
static void C_ccall trf_4836(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_4836(t0,t1);}

C_noret_decl(trf_3695)
static void C_ccall trf_3695(C_word c,C_word *av) C_noret;
static void C_ccall trf_3695(C_word c,C_word *av){
C_word t0=av[4];
C_word t1=av[3];
C_word t2=av[2];
C_word t3=av[1];
C_word t4=av[0];
f_3695(t0,t1,t2,t3,t4);}

C_noret_decl(trf_7535)
static void C_ccall trf_7535(C_word c,C_word *av) C_noret;
static void C_ccall trf_7535(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_7535(t0,t1);}

C_noret_decl(trf_3686)
static void C_ccall trf_3686(C_word c,C_word *av) C_noret;
static void C_ccall trf_3686(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_3686(t0,t1);}

C_noret_decl(trf_3683)
static void C_ccall trf_3683(C_word c,C_word *av) C_noret;
static void C_ccall trf_3683(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_3683(t0,t1);}

C_noret_decl(trf_3173)
static void C_ccall trf_3173(C_word c,C_word *av) C_noret;
static void C_ccall trf_3173(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_3173(t0,t1);}

C_noret_decl(trf_5937)
static void C_ccall trf_5937(C_word c,C_word *av) C_noret;
static void C_ccall trf_5937(C_word c,C_word *av){
C_word t0=av[3];
C_word t1=av[2];
C_word t2=av[1];
C_word t3=av[0];
f_5937(t0,t1,t2,t3);}

C_noret_decl(trf_3630)
static void C_ccall trf_3630(C_word c,C_word *av) C_noret;
static void C_ccall trf_3630(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_3630(t0,t1,t2);}

C_noret_decl(trf_4830)
static void C_ccall trf_4830(C_word c,C_word *av) C_noret;
static void C_ccall trf_4830(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_4830(t0,t1);}

C_noret_decl(trf_4833)
static void C_ccall trf_4833(C_word c,C_word *av) C_noret;
static void C_ccall trf_4833(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_4833(t0,t1);}

C_noret_decl(trf_7694)
static void C_ccall trf_7694(C_word c,C_word *av) C_noret;
static void C_ccall trf_7694(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_7694(t0,t1);}

C_noret_decl(trf_2722)
static void C_ccall trf_2722(C_word c,C_word *av) C_noret;
static void C_ccall trf_2722(C_word c,C_word *av){
C_word t0=av[4];
C_word t1=av[3];
C_word t2=av[2];
C_word t3=av[1];
C_word t4=av[0];
f_2722(t0,t1,t2,t3,t4);}

C_noret_decl(trf_4767)
static void C_ccall trf_4767(C_word c,C_word *av) C_noret;
static void C_ccall trf_4767(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_4767(t0,t1);}

C_noret_decl(trf_8697)
static void C_ccall trf_8697(C_word c,C_word *av) C_noret;
static void C_ccall trf_8697(C_word c,C_word *av){
C_word t0=av[3];
C_word t1=av[2];
C_word t2=av[1];
C_word t3=av[0];
f_8697(t0,t1,t2,t3);}

C_noret_decl(trf_6253)
static void C_ccall trf_6253(C_word c,C_word *av) C_noret;
static void C_ccall trf_6253(C_word c,C_word *av){
C_word t0=av[3];
C_word t1=av[2];
C_word t2=av[1];
C_word t3=av[0];
f_6253(t0,t1,t2,t3);}

C_noret_decl(trf_7682)
static void C_ccall trf_7682(C_word c,C_word *av) C_noret;
static void C_ccall trf_7682(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_7682(t0,t1);}

C_noret_decl(trf_4531)
static void C_ccall trf_4531(C_word c,C_word *av) C_noret;
static void C_ccall trf_4531(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_4531(t0,t1);}

C_noret_decl(trf_5698)
static void C_ccall trf_5698(C_word c,C_word *av) C_noret;
static void C_ccall trf_5698(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_5698(t0,t1);}

C_noret_decl(trf_7360)
static void C_ccall trf_7360(C_word c,C_word *av) C_noret;
static void C_ccall trf_7360(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_7360(t0,t1);}

C_noret_decl(trf_5007)
static void C_ccall trf_5007(C_word c,C_word *av) C_noret;
static void C_ccall trf_5007(C_word c,C_word *av){
C_word t0=av[4];
C_word t1=av[3];
C_word t2=av[2];
C_word t3=av[1];
C_word t4=av[0];
f_5007(t0,t1,t2,t3,t4);}

C_noret_decl(trf_3348)
static void C_ccall trf_3348(C_word c,C_word *av) C_noret;
static void C_ccall trf_3348(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_3348(t0,t1);}

C_noret_decl(trf_3341)
static void C_ccall trf_3341(C_word c,C_word *av) C_noret;
static void C_ccall trf_3341(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_3341(t0,t1,t2);}

C_noret_decl(trf_4476)
static void C_ccall trf_4476(C_word c,C_word *av) C_noret;
static void C_ccall trf_4476(C_word c,C_word *av){
C_word t0=av[7];
C_word t1=av[6];
C_word t2=av[5];
C_word t3=av[4];
C_word t4=av[3];
C_word t5=av[2];
C_word t6=av[1];
C_word t7=av[0];
f_4476(t0,t1,t2,t3,t4,t5,t6,t7);}

/* a4493 in k4484 in k4478 in call-with-exec-args in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_4494(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(17,c,3)))){
C_save_and_reclaim((void *)f_4494,3,av);}
a=C_alloc(17);
t3=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_4500,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t2,a[5]=((C_word)li85),tmp=(C_word)a,a+=6,tmp);
t4=(*a=C_CLOSURE_TYPE|10,a[1]=(C_word)f_4521,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[2],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[6],a[7]=((C_word*)t0)[7],a[8]=((C_word*)t0)[8],a[9]=t2,a[10]=((C_word)li89),tmp=(C_word)a,a+=11,tmp);
/* posix-common.scm:726: with-exception-handler */
t5=*((C_word*)lf[135]+1);{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=t5;
av2[1]=t1;
av2[2]=t3;
av2[3]=t4;
((C_proc)(void*)(*((C_word*)t5+1)))(4,av2);}}

/* f_3841 in k3872 in k3869 in k3866 in k3863 in k3860 in k3857 in find-files in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_3841(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_3841,2,av);}
t2=t1;{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=t2;
av2[1]=C_SCHEME_TRUE;
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* k4487 in k4484 in k4478 in call-with-exec-args in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_4489(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_4489,2,av);}
/* posix-common.scm:726: g726 */
t2=t1;{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=t2;
av2[1]=((C_word*)t0)[2];
((C_proc)C_fast_retrieve_proc(t2))(2,av2);}}

/* k4484 in k4478 in call-with-exec-args in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_4486(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(15,c,3)))){
C_save_and_reclaim((void *)f_4486,2,av);}
a=C_alloc(15);
t2=t1;
t3=C_SCHEME_FALSE;
t4=(*a=C_VECTOR_TYPE|1,a[1]=t3,tmp=(C_word)a,a+=2,tmp);
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4489,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
t6=(*a=C_CLOSURE_TYPE|9,a[1]=(C_word)f_4494,a[2]=t4,a[3]=t2,a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],a[6]=((C_word*)t0)[5],a[7]=((C_word*)t0)[6],a[8]=((C_word*)t0)[7],a[9]=((C_word)li90),tmp=(C_word)a,a+=10,tmp);
/* posix-common.scm:726: call-with-current-continuation */
t7=*((C_word*)lf[136]+1);{
C_word *av2;
if(c >= 3) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(3);
}
av2[0]=t7;
av2[1]=t5;
av2[2]=t6;
((C_proc)(void*)(*((C_word*)t7+1)))(3,av2);}}

/* a8724 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_8725(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_8725,3,av);}
t3=C_i_check_exact_2(t2,lf[123]);
t4=t1;{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=t4;
av2[1]=C_slot(*((C_word*)lf[122]+1),t2);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* k6496 in k6493 in loop in fetch in k6397 in k6391 in custom-input-port in k6200 in k6169 in k5687 in k5683 in k5679 in k5675 in k5595 in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in ... */
static void C_ccall f_6498(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_6498,2,av);}
/* posixunix.scm:1160: loop */
t2=((C_word*)((C_word*)t0)[2])[1];{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=t2;
av2[1]=((C_word*)t0)[3];
f_6443(2,av2);}}

/* a5417 in k5411 in call-with-output-pipe in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_5418(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,2)))){
C_save_and_reclaim((void *)f_5418,2,av);}
/* posixunix.scm:663: proc */
t2=((C_word*)t0)[2];{
C_word *av2;
if(c >= 3) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(3);
}
av2[0]=t2;
av2[1]=t1;
av2[2]=((C_word*)t0)[3];
((C_proc)C_fast_retrieve_proc(t2))(3,av2);}}

/* k5411 in call-with-output-pipe in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_5413(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(9,c,3)))){
C_save_and_reclaim((void *)f_5413,2,av);}
a=C_alloc(9);
t2=t1;
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_5418,a[2]=((C_word*)t0)[2],a[3]=t2,a[4]=((C_word)li116),tmp=(C_word)a,a+=5,tmp);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5424,a[2]=t2,a[3]=((C_word)li117),tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm:662: ##sys#call-with-values */{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=0;
av2[1]=((C_word*)t0)[3];
av2[2]=t3;
av2[3]=t4;
C_call_with_values(4,av2);}}

/* k3830 in k3681 in k3872 in k3869 in k3866 in k3863 in k3860 in k3857 in find-files in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_3832(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,3)))){
C_save_and_reclaim((void *)f_3832,2,av);}
a=C_alloc(4);
t2=t1;
t3=((C_word*)t0)[2];
f_3686(t3,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3833,a[2]=t2,a[3]=((C_word)li44),tmp=(C_word)a,a+=4,tmp));}

/* f_3833 in k3830 in k3681 in k3872 in k3869 in k3866 in k3863 in k3860 in k3857 in find-files in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_3833(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,3)))){
C_save_and_reclaim((void *)f_3833,3,av);}
/* posix-common.scm:528: irregex-match */
t3=*((C_word*)lf[89]+1);{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=t3;
av2[1]=t1;
av2[2]=((C_word*)t0)[2];
av2[3]=t2;
((C_proc)(void*)(*((C_word*)t3+1)))(4,av2);}}

/* k6493 in loop in fetch in k6397 in k6391 in custom-input-port in k6200 in k6169 in k5687 in k5683 in k5679 in k5675 in k5595 in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in ... */
static void C_ccall f_6495(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(8,c,6)))){
C_save_and_reclaim((void *)f_6495,2,av);}
a=C_alloc(8);
if(C_truep(t1)){
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_6498,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm:1159: ##sys#thread-yield! */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[348]+1));
C_word *av2=av; /* Re-use our own argvector */
av2[0]=*((C_word*)lf[348]+1);
av2[1]=t2;
tp(2,av2);}}
else{
t2=C_read(((C_word*)t0)[4],((C_word*)t0)[5],((C_word*)t0)[6]);
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_6504,a[2]=((C_word*)t0)[7],a[3]=t3,a[4]=((C_word*)t0)[8],a[5]=((C_word*)t0)[3],tmp=(C_word)a,a+=6,tmp);
t5=C_eqp(((C_word*)t3)[1],C_fix(-1));
if(C_truep(t5)){
t6=C_eqp(C_fix((C_word)errno),C_fix((C_word)EWOULDBLOCK));
t7=(C_truep(t6)?t6:C_eqp(C_fix((C_word)errno),C_fix((C_word)EAGAIN)));
if(C_truep(t7)){
t8=C_set_block_item(t3,0,C_fix(0));
t9=C_mutate2(((C_word *)((C_word*)t0)[7])+1,((C_word*)t3)[1]);
t10=C_set_block_item(((C_word*)t0)[8],0,C_fix(0));
t11=((C_word*)t0)[3];{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=t11;
av2[1]=t10;
((C_proc)(void*)(*((C_word*)t11+1)))(2,av2);}}
else{
/* posixunix.scm:1166: posix-error */
t8=lf[0];{
C_word *av2;
if(c >= 7) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(7);
}
av2[0]=t8;
av2[1]=t4;
av2[2]=lf[8];
av2[3]=((C_word*)t0)[9];
av2[4]=lf[353];
av2[5]=((C_word*)t0)[4];
av2[6]=((C_word*)t0)[10];
f_2704(7,av2);}}}
else{
t6=C_mutate2(((C_word *)((C_word*)t0)[7])+1,((C_word*)t3)[1]);
t7=C_set_block_item(((C_word*)t0)[8],0,C_fix(0));
t8=((C_word*)t0)[3];{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=t8;
av2[1]=t7;
((C_proc)(void*)(*((C_word*)t8+1)))(2,av2);}}}}

/* a4273 in process-wait in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_4274(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,3)))){
C_save_and_reclaim((void *)f_4274,2,av);}
/* posix-common.scm:679: ##sys#process-wait */
t2=*((C_word*)lf[126]+1);{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=t2;
av2[1]=t1;
av2[2]=((C_word*)t0)[2];
av2[3]=((C_word*)t0)[3];
((C_proc)(void*)(*((C_word*)t2+1)))(4,av2);}}

/* k3866 in k3863 in k3860 in k3857 in find-files in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_3868(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(12,c,4)))){
C_save_and_reclaim((void *)f_3868,2,av);}
a=C_alloc(12);
t2=t1;
t3=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_3871,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[6],a[7]=t2,a[8]=((C_word*)t0)[7],tmp=(C_word)a,a+=9,tmp);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3882,a[2]=((C_word)li48),tmp=(C_word)a,a+=3,tmp);
/* posix-common.scm:552: ##sys#get-keyword */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[97]+1));
C_word *av2;
if(c >= 5) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(5);
}
av2[0]=*((C_word*)lf[97]+1);
av2[1]=t3;
av2[2]=lf[77];
av2[3]=((C_word*)t0)[7];
av2[4]=t4;
tp(5,av2);}}

/* create-directory in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_3313(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand((c-3)*C_SIZEOF_PAIR +10,c,2)))){
C_save_and_reclaim((void*)f_3313,c,av);}
a=C_alloc((c-3)*C_SIZEOF_PAIR+10);
t3=C_build_rest(&a,c,3,av);
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
t4=C_i_nullp(t3);
t5=(C_truep(t4)?C_SCHEME_FALSE:C_i_car(t3));
t6=t5;
t7=C_i_check_string_2(t2,lf[79]);
t8=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3323,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
t9=C_block_size(t2);
t10=C_eqp(C_fix(0),t9);
t11=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_3329,a[2]=t1,a[3]=t2,a[4]=t6,a[5]=t8,tmp=(C_word)a,a+=6,tmp);
if(C_truep(t10)){
t12=t11;{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=t12;
av2[1]=t10;
f_3329(2,av2);}}
else{
/* posix-common.scm:457: file-exists? */
t12=*((C_word*)lf[84]+1);{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=t12;
av2[1]=t11;
av2[2]=t2;
((C_proc)(void*)(*((C_word*)t12+1)))(3,av2);}}}

/* k6619 in a6612 in k6397 in k6391 in custom-input-port in k6200 in k6169 in k5687 in k5683 in k5679 in k5675 in k5595 in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 in ... */
static void C_fcall f_6621(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(11,0,5)))){
C_save_and_reclaim_args((void *)trf_6621,2,t0,t1);}
a=C_alloc(11);
t2=C_SCHEME_UNDEFINED;
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=C_set_block_item(t3,0,(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_6623,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=t3,a[7]=((C_word*)t0)[6],a[8]=((C_word)li167),tmp=(C_word)a,a+=9,tmp));
t5=((C_word*)t3)[1];
f_6623(t5,((C_word*)t0)[7],t1,C_fix(0),((C_word*)t0)[8]);}

/* k5769 in current-effective-user-name in k5687 in k5683 in k5679 in k5675 in k5595 in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_5771(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,2)))){
C_save_and_reclaim((void *)f_5771,2,av);}
/* posixunix.scm:891: user-information */
t2=*((C_word*)lf[266]+1);{
C_word *av2;
if(c >= 3) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(3);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[2];
av2[2]=t1;
((C_proc)(void*)(*((C_word*)t2+1)))(3,av2);}}

/* loop in k6619 in a6612 in k6397 in k6391 in custom-input-port in k6200 in k6169 in k5687 in k5683 in k5679 in k5675 in k5595 in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in ... */
static void C_fcall f_6623(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word t17;
C_word t18;
C_word t19;
C_word t20;
C_word *a;
loop:
if(C_unlikely(!C_demand(C_calculate_demand(8,0,4)))){
C_save_and_reclaim_args((void *)trf_6623,5,t0,t1,t2,t3,t4);}
a=C_alloc(8);
t5=C_eqp(C_fix(0),t2);
if(C_truep(t5)){
t6=t3;
t7=t1;{
C_word av2[2];
av2[0]=t7;
av2[1]=t6;
((C_proc)(void*)(*((C_word*)t7+1)))(2,av2);}}
else{
if(C_truep(C_fixnum_lessp(((C_word*)((C_word*)t0)[2])[1],((C_word*)((C_word*)t0)[3])[1]))){
t6=C_fixnum_difference(((C_word*)((C_word*)t0)[3])[1],((C_word*)((C_word*)t0)[2])[1]);
t7=C_fixnum_lessp(t2,t6);
t8=(C_truep(t7)?t2:t6);
t9=C_fixnum_plus(((C_word*)((C_word*)t0)[2])[1],t8);
t10=C_substring_copy(((C_word*)t0)[4],((C_word*)t0)[5],((C_word*)((C_word*)t0)[2])[1],t9,t4);
t11=C_fixnum_plus(((C_word*)((C_word*)t0)[2])[1],t8);
t12=C_set_block_item(((C_word*)t0)[2],0,t11);
t13=C_fixnum_difference(t2,t8);
t14=C_fixnum_plus(t3,t8);
t15=C_fixnum_plus(t4,t8);
/* posixunix.scm:1201: loop */
t17=t1;
t18=t13;
t19=t14;
t20=t15;
t1=t17;
t2=t18;
t3=t19;
t4=t20;
goto loop;}
else{
t6=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_6671,a[2]=((C_word*)t0)[3],a[3]=t3,a[4]=t1,a[5]=((C_word*)t0)[6],a[6]=t2,a[7]=t4,tmp=(C_word)a,a+=8,tmp);
/* posixunix.scm:1203: fetch */
t7=((C_word*)t0)[7];
f_6437(t7,t6);}}}

/* k3863 in k3860 in k3857 in find-files in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_3865(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(11,c,4)))){
C_save_and_reclaim((void *)f_3865,2,av);}
a=C_alloc(11);
t2=t1;
t3=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_3868,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=t2,a[7]=((C_word*)t0)[6],tmp=(C_word)a,a+=8,tmp);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3885,a[2]=((C_word)li49),tmp=(C_word)a,a+=3,tmp);
/* posix-common.scm:552: ##sys#get-keyword */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[97]+1));
C_word *av2;
if(c >= 5) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(5);
}
av2[0]=*((C_word*)lf[97]+1);
av2[1]=t3;
av2[2]=lf[98];
av2[3]=((C_word*)t0)[6];
av2[4]=t4;
tp(5,av2);}}

/* k3860 in k3857 in find-files in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_3862(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(10,c,4)))){
C_save_and_reclaim((void *)f_3862,2,av);}
a=C_alloc(10);
t2=t1;
t3=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_3865,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=t2,a[6]=((C_word*)t0)[5],tmp=(C_word)a,a+=7,tmp);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3888,a[2]=((C_word)li50),tmp=(C_word)a,a+=3,tmp);
/* posix-common.scm:552: ##sys#get-keyword */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[97]+1));
C_word *av2;
if(c >= 5) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(5);
}
av2[0]=*((C_word*)lf[97]+1);
av2[1]=t3;
av2[2]=lf[99];
av2[3]=((C_word*)t0)[5];
av2[4]=t4;
tp(5,av2);}}

/* k7742 in terminal-port? in k6200 in k6169 in k5687 in k5683 in k5679 in k5675 in k5595 in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_7744(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_7744,2,av);}
t2=C_eqp(C_fix(0),t1);
if(C_truep(t2)){
t3=((C_word*)t0)[2];{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=t3;
av2[1]=C_SCHEME_FALSE;
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}
else{
t3=C_tty_portp(((C_word*)t0)[3]);
t4=((C_word*)t0)[2];{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=t4;
av2[1]=t3;
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}}

/* f_7024 in k6908 in custom-output-port in k6200 in k6169 in k5687 in k5683 in k5679 in k5675 in k5595 in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_7024(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,3)))){
C_save_and_reclaim((void *)f_7024,3,av);}
if(C_truep(t2)){
t3=C_block_size(t2);
/* posixunix.scm:1272: poke */
t4=((C_word*)((C_word*)t0)[2])[1];{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=t4;
av2[1]=t1;
av2[2]=t2;
av2[3]=t3;
((C_proc)C_fast_retrieve_proc(t4))(4,av2);}}
else{
t3=C_SCHEME_UNDEFINED;
t4=t1;{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=t4;
av2[1]=t3;
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}}

/* k6669 in loop in k6619 in a6612 in k6397 in k6391 in custom-input-port in k6200 in k6169 in k5687 in k5683 in k5679 in k5675 in k5595 in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in ... */
static void C_ccall f_6671(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,4)))){
C_save_and_reclaim((void *)f_6671,2,av);}
t2=C_eqp(C_fix(0),((C_word*)((C_word*)t0)[2])[1]);
if(C_truep(t2)){
t3=((C_word*)t0)[3];
t4=((C_word*)t0)[4];{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=t4;
av2[1]=t3;
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}
else{
/* posixunix.scm:1206: loop */
t3=((C_word*)((C_word*)t0)[5])[1];
f_6623(t3,((C_word*)t0)[4],((C_word*)t0)[6],((C_word*)t0)[3],((C_word*)t0)[7]);}}

/* k5765 in current-effective-user-name in k5687 in k5683 in k5679 in k5675 in k5595 in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_5767(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_5767,2,av);}
t2=((C_word*)t0)[2];{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=t2;
av2[1]=C_i_car(t1);
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* a3887 in k3860 in k3857 in find-files in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_3888(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_3888,2,av);}
t2=t1;{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=t2;
av2[1]=C_SCHEME_END_OF_LIST;
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* ##sys#terminal-check in k6200 in k6169 in k5687 in k5683 in k5679 in k5675 in k5595 in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_fcall f_7756(C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,0,4)))){
C_save_and_reclaim_args((void *)trf_7756,3,t1,t2,t3);}
t4=t3;
t5=t2;
t6=C_i_check_port_2(t4,C_fix(0),C_SCHEME_TRUE,t5);
t7=C_slot(t3,C_fix(7));
t8=C_eqp(lf[43],t7);
t9=(C_truep(t8)?C_tty_portp(t3):C_SCHEME_FALSE);
if(C_truep(t9)){
t10=C_SCHEME_UNDEFINED;
t11=t1;{
C_word av2[2];
av2[0]=t11;
av2[1]=t10;
((C_proc)(void*)(*((C_word*)t11+1)))(2,av2);}}
else{
/* posixunix.scm:1508: ##sys#error */
t10=*((C_word*)lf[50]+1);{
C_word av2[5];
av2[0]=t10;
av2[1]=t1;
av2[2]=t2;
av2[3]=lf[414];
av2[4]=t3;
((C_proc)(void*)(*((C_word*)t10+1)))(5,av2);}}}

/* k5789 in group-information in k5687 in k5683 in k5679 in k5675 in k5595 in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_fcall f_5791(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(7,0,3)))){
C_save_and_reclaim_args((void *)trf_5791,2,t0,t1);}
a=C_alloc(7);
if(C_truep(t1)){
t2=(C_truep(((C_word*)t0)[2])?*((C_word*)lf[267]+1):*((C_word*)lf[268]+1));
t3=t2;
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5804,a[2]=t3,a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* ##sys#peek-nonnull-c-string */
t5=*((C_word*)lf[260]+1);{
C_word av2[4];
av2[0]=t5;
av2[1]=t4;
av2[2]=C_mpointer(&a,(void*)C_group->gr_name);
av2[3]=C_fix(0);
((C_proc)(void*)(*((C_word*)t5+1)))(4,av2);}}
else{
t2=((C_word*)t0)[3];{
C_word av2[2];
av2[0]=t2;
av2[1]=C_SCHEME_FALSE;
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}}

/* a8733 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_8734(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand((c-2)*C_SIZEOF_PAIR +0,c,1)))){
C_save_and_reclaim((void*)f_8734,c,av);}
a=C_alloc((c-2)*C_SIZEOF_PAIR+0);
t2=C_build_rest(&a,c,2,av);
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
t3=C_i_nullp(t2);
t4=(C_truep(t3)?C_SCHEME_FALSE:C_i_car(t2));
t5=(C_truep(t4)?C_i_check_exact_2(t4,lf[102]):C_SCHEME_UNDEFINED);
if(C_truep(t4)){
t6=C_umask(t4);
if(C_truep(t4)){
t7=t1;{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=t7;
av2[1]=t6;
((C_proc)(void*)(*((C_word*)t7+1)))(2,av2);}}
else{
t7=C_umask(t6);
t8=t1;{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=t8;
av2[1]=t6;
((C_proc)(void*)(*((C_word*)t8+1)))(2,av2);}}}
else{
t6=C_umask(C_fix(0));
if(C_truep(t4)){
t7=t1;{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=t7;
av2[1]=t6;
((C_proc)(void*)(*((C_word*)t7+1)))(2,av2);}}
else{
t7=C_umask(t6);
t8=t1;{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=t8;
av2[1]=t6;
((C_proc)(void*)(*((C_word*)t8+1)))(2,av2);}}}}

/* k5426 in a5423 in k5411 in call-with-output-pipe in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_5428(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,2)))){
C_save_and_reclaim((void *)f_5428,2,av);}{
C_word *av2;
if(c >= 3) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(3);
}
av2[0]=0;
av2[1]=((C_word*)t0)[2];
av2[2]=((C_word*)t0)[3];
C_apply_values(3,av2);}}

/* a5423 in k5411 in call-with-output-pipe in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_5424(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand((c-2)*C_SIZEOF_PAIR +4,c,2)))){
C_save_and_reclaim((void*)f_5424,c,av);}
a=C_alloc((c-2)*C_SIZEOF_PAIR+4);
t2=C_build_rest(&a,c,2,av);
C_word t3;
C_word t4;
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5428,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm:665: close-output-pipe */
t4=*((C_word*)lf[213]+1);{
C_word *av2;
if(c >= 3) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(3);
}
av2[0]=t4;
av2[1]=t3;
av2[2]=((C_word*)t0)[2];
((C_proc)(void*)(*((C_word*)t4+1)))(3,av2);}}

/* a3884 in k3863 in k3860 in k3857 in find-files in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_3885(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_3885,2,av);}
t2=t1;{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=t2;
av2[1]=C_SCHEME_FALSE;
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* a3881 in k3866 in k3863 in k3860 in k3857 in find-files in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_3882(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_3882,2,av);}
t2=t1;{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=t2;
av2[1]=C_SCHEME_FALSE;
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* a3878 in k3869 in k3866 in k3863 in k3860 in k3857 in find-files in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_3879(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_3879,2,av);}
t2=t1;{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=t2;
av2[1]=C_SCHEME_FALSE;
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* k3365 in k3349 in k3346 in loop in k3337 in k3327 in create-directory in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_3367(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,5)))){
C_save_and_reclaim((void *)f_3367,2,av);}
t2=C_mkdir(t1);
t3=C_eqp(C_fix(0),t2);
if(C_truep(t3)){
t4=C_SCHEME_UNDEFINED;
t5=((C_word*)t0)[2];{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=t5;
av2[1]=t4;
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}
else{
/* posix-common.scm:451: posix-error */
t4=lf[0];{
C_word *av2;
if(c >= 6) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(6);
}
av2[0]=t4;
av2[1]=((C_word*)t0)[2];
av2[2]=lf[8];
av2[3]=lf[79];
av2[4]=lf[80];
av2[5]=((C_word*)t0)[3];
f_2704(6,av2);}}}

/* a8617 in k5683 in k5679 in k5675 in k5595 in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_8618(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(4,c,2)))){
C_save_and_reclaim((void *)f_8618,3,av);}
a=C_alloc(4);
t3=C_setegid(t2);
if(C_truep(C_fixnum_lessp(t3,C_fix(0)))){
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_8628,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm:858: ##sys#update-errno */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[5]+1));
C_word *av2=av; /* Re-use our own argvector */
av2[0]=*((C_word*)lf[5]+1);
av2[1]=t4;
tp(2,av2);}}
else{
t4=C_SCHEME_UNDEFINED;
t5=t1;{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=t5;
av2[1]=t4;
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}}

/* k7002 in a6993 in k6975 in k6908 in custom-output-port in k6200 in k6169 in k5687 in k5683 in k5679 in k5675 in k5595 in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 in ... */
static void C_ccall f_7004(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_7004,2,av);}
/* posixunix.scm:1298: on-close */
t2=((C_word*)t0)[2];{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=t2;
av2[1]=((C_word*)t0)[3];
((C_proc)C_fast_retrieve_proc(t2))(2,av2);}}

/* a8614 in k5683 in k5679 in k5675 in k5595 in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_8615(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_8615,2,av);}
t2=t1;{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=t2;
av2[1]=stub1224(C_SCHEME_UNDEFINED);
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* group-information in k5687 in k5683 in k5679 in k5675 in k5595 in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_5784(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand((c-3)*C_SIZEOF_PAIR +7,c,3)))){
C_save_and_reclaim((void*)f_5784,c,av);}
a=C_alloc((c-3)*C_SIZEOF_PAIR+7);
t3=C_build_rest(&a,c,3,av);
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
t4=C_i_nullp(t3);
t5=(C_truep(t4)?C_SCHEME_FALSE:C_i_car(t3));
t6=t5;
t7=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5791,a[2]=t6,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
if(C_truep(C_fixnump(t2))){
t8=t7;
f_5791(t8,C_getgrgid(t2));}
else{
t8=C_i_check_string_2(t2,lf[271]);
t9=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5842,a[2]=t7,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm:906: ##sys#make-c-string */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[11]+1));
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[11]+1);
av2[1]=t9;
av2[2]=t2;
av2[3]=lf[271];
tp(4,av2);}}}

/* a6612 in k6397 in k6391 in custom-input-port in k6200 in k6169 in k5687 in k5683 in k5679 in k5675 in k5595 in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_6613(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4=av[4];
C_word t5=av[5];
C_word t6;
C_word t7;
C_word t8;
C_word *a;
if(c!=6) C_bad_argc_2(c,6,t0);
if(C_unlikely(!C_demand(C_calculate_demand(9,c,2)))){
C_save_and_reclaim((void *)f_6613,6,av);}
a=C_alloc(9);
t6=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_6621,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=t4,a[6]=((C_word*)t0)[5],a[7]=t1,a[8]=t5,tmp=(C_word)a,a+=9,tmp);
if(C_truep(t3)){
t7=t6;
f_6621(t7,t3);}
else{
t7=C_block_size(t4);
t8=t6;
f_6621(t8,C_fixnum_difference(t7,t5));}}

/* k3872 in k3869 in k3866 in k3863 in k3860 in k3857 in find-files in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_3874(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(17,c,2)))){
C_save_and_reclaim((void *)f_3874,2,av);}
a=C_alloc(17);
t2=((C_word*)t0)[2];
t3=((C_word*)t0)[3];
t4=((C_word*)t0)[4];
t5=((C_word*)t0)[5];
t6=((C_word*)t0)[6];
t7=((C_word*)t0)[7];
t8=t1;
t9=((C_word*)t0)[8];
t10=C_i_check_string_2(t3,lf[76]);
t11=C_fix(0);
t12=(*a=C_VECTOR_TYPE|1,a[1]=t11,tmp=(C_word)a,a+=2,tmp);
t13=(*a=C_CLOSURE_TYPE|9,a[1]=(C_word)f_3683,a[2]=t8,a[3]=t5,a[4]=t12,a[5]=t9,a[6]=t2,a[7]=t3,a[8]=t6,a[9]=t4,tmp=(C_word)a,a+=10,tmp);
if(C_truep(t7)){
if(C_truep(C_fixnump(t7))){
t14=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3849,a[2]=t12,a[3]=t7,a[4]=((C_word)li45),tmp=(C_word)a,a+=5,tmp);
t15=t13;
f_3683(t15,t14);}
else{
t14=t13;
f_3683(t14,t7);}}
else{
t14=t13;
f_3683(t14,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3841,a[2]=((C_word)li46),tmp=(C_word)a,a+=3,tmp));}}

/* k3869 in k3866 in k3863 in k3860 in k3857 in find-files in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_3871(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(12,c,4)))){
C_save_and_reclaim((void *)f_3871,2,av);}
a=C_alloc(12);
t2=t1;
t3=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_3874,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[6],a[7]=((C_word*)t0)[7],a[8]=t2,tmp=(C_word)a,a+=9,tmp);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3879,a[2]=((C_word)li47),tmp=(C_word)a,a+=3,tmp);
/* posix-common.scm:552: ##sys#get-keyword */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[97]+1));
C_word *av2;
if(c >= 5) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(5);
}
av2[0]=*((C_word*)lf[97]+1);
av2[1]=t3;
av2[2]=lf[78];
av2[3]=((C_word*)t0)[8];
av2[4]=t4;
tp(5,av2);}}

/* terminal-port? in k6200 in k6169 in k5687 in k5683 in k5679 in k5675 in k5595 in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_7738(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(4,c,3)))){
C_save_and_reclaim((void *)f_7738,3,av);}
a=C_alloc(4);
t3=t2;
t4=C_i_check_port_2(t3,C_fix(0),C_SCHEME_TRUE,lf[412]);
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_7744,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm:1501: ##sys#peek-unsigned-integer */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[65]+1));
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[65]+1);
av2[1]=t5;
av2[2]=t2;
av2[3]=C_fix(0);
tp(4,av2);}}

/* k5735 in user-information in k5687 in k5683 in k5679 in k5675 in k5595 in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_5737(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_5737,2,av);}
t2=((C_word*)t0)[2];
f_5698(t2,C_getpwnam(t1));}

/* k4207 in k4203 in scan in k4169 in loop in get-environment-variables in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_4209(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(7,c,2)))){
C_save_and_reclaim((void *)f_4209,2,av);}
a=C_alloc(7);
t2=C_a_i_cons(&a,2,((C_word*)t0)[2],t1);
t3=t2;
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4197,a[2]=((C_word*)t0)[3],a[3]=t3,tmp=(C_word)a,a+=4,tmp);
t5=C_fixnum_plus(((C_word*)t0)[4],C_fix(1));
/* posix-common.scm:650: loop */
t6=((C_word*)((C_word*)t0)[5])[1];
f_4167(t6,t4,t5);}

/* k8607 in a8592 in k5687 in k5683 in k5679 in k5675 in k5595 in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_8609(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,5)))){
C_save_and_reclaim((void *)f_8609,2,av);}
/* posixunix.scm:1062: ##sys#error */
t2=*((C_word*)lf[50]+1);{
C_word *av2;
if(c >= 6) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(6);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[2];
av2[2]=lf[448];
av2[3]=lf[449];
av2[4]=((C_word*)t0)[3];
av2[5]=((C_word*)t0)[4];
((C_proc)(void*)(*((C_word*)t2+1)))(6,av2);}}

/* k4906 in k5066 in k4842 in k4834 in k4831 in k4828 in file-select in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_4908(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(13,c,5)))){
C_save_and_reclaim((void *)f_4908,2,av);}
a=C_alloc(13);
t2=t1;
t3=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_4911,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=t2,tmp=(C_word)a,a+=6,tmp);
t4=C_SCHEME_UNDEFINED;
t5=(*a=C_VECTOR_TYPE|1,a[1]=t4,tmp=(C_word)a,a+=2,tmp);
t6=C_set_block_item(t5,0,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4948,a[2]=t5,a[3]=((C_word*)t0)[5],a[4]=((C_word)li103),tmp=(C_word)a,a+=5,tmp));
t7=((C_word*)t5)[1];
f_4948(t7,t3,((C_word*)t0)[6],C_SCHEME_END_OF_LIST,((C_word*)t0)[7]);}

/* a5486 in a5480 in k5469 in with-output-to-pipe in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_5487(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand((c-2)*C_SIZEOF_PAIR +4,c,2)))){
C_save_and_reclaim((void*)f_5487,c,av);}
a=C_alloc((c-2)*C_SIZEOF_PAIR+4);
t2=C_build_rest(&a,c,2,av);
C_word t3;
C_word t4;
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5491,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm:682: close-output-pipe */
t4=*((C_word*)lf[213]+1);{
C_word *av2;
if(c >= 3) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(3);
}
av2[0]=t4;
av2[1]=t3;
av2[2]=((C_word*)t0)[2];
((C_proc)(void*)(*((C_word*)t4+1)))(3,av2);}}

/* a5480 in k5469 in with-output-to-pipe in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_5481(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(C_unlikely(!C_demand(C_calculate_demand(4,c,3)))){
C_save_and_reclaim((void *)f_5481,2,av);}
a=C_alloc(4);
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5487,a[2]=((C_word*)t0)[2],a[3]=((C_word)li125),tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm:680: ##sys#call-with-values */{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=0;
av2[1]=t1;
av2[2]=((C_word*)t0)[3];
av2[3]=t2;
C_call_with_values(4,av2);}}

/* doloop946 in k4842 in k4834 in k4831 in k4828 in file-select in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static C_word C_fcall f_5081(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_stack_overflow_check;
loop:{}
if(C_truep(C_i_nullp(t2))){
t3=C_SCHEME_UNDEFINED;
return(t3);}
else{
t3=C_i_car(t2);
t4=t1;
t5=C_i_foreign_fixnum_argumentp(t4);
t6=C_i_foreign_fixnum_argumentp(t3);
if(C_truep(((C_word*)t0)[2])){
t7=C_i_foreign_block_argumentp(((C_word*)t0)[2]);
t8=stub955(C_SCHEME_UNDEFINED,t5,t6,t7);
t9=C_fixnum_plus(t1,C_fix(1));
t10=t2;
t11=C_u_i_cdr(t10);
t13=t9;
t14=t11;
t1=t13;
t2=t14;
goto loop;}
else{
t7=stub955(C_SCHEME_UNDEFINED,t5,t6,C_SCHEME_FALSE);
t8=C_fixnum_plus(t1,C_fix(1));
t9=t2;
t10=C_u_i_cdr(t9);
t13=t8;
t14=t10;
t1=t13;
t2=t14;
goto loop;}}}

/* k4203 in scan in k4169 in loop in get-environment-variables in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_4205(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(6,c,4)))){
C_save_and_reclaim((void *)f_4205,2,av);}
a=C_alloc(6);
t2=t1;
t3=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_4209,a[2]=t2,a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],tmp=(C_word)a,a+=6,tmp);
t4=C_fixnum_plus(((C_word*)t0)[5],C_fix(1));
t5=C_block_size(((C_word*)t0)[6]);
/* posix-common.scm:649: ##sys#substring */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[70]+1));
C_word *av2;
if(c >= 5) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(5);
}
av2[0]=*((C_word*)lf[70]+1);
av2[1]=t3;
av2[2]=((C_word*)t0)[6];
av2[3]=t4;
av2[4]=t5;
tp(5,av2);}}

/* a8636 in k5679 in k5675 in k5595 in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_8637(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(4,c,2)))){
C_save_and_reclaim((void *)f_8637,3,av);}
a=C_alloc(4);
t3=C_setgid(t2);
if(C_truep(C_fixnum_lessp(t3,C_fix(0)))){
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_8647,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm:849: ##sys#update-errno */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[5]+1));
C_word *av2=av; /* Re-use our own argvector */
av2[0]=*((C_word*)lf[5]+1);
av2[1]=t4;
tp(2,av2);}}
else{
t4=C_SCHEME_UNDEFINED;
t5=t1;{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=t5;
av2[1]=t4;
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}}

/* a8633 in k5679 in k5675 in k5595 in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_8634(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_8634,2,av);}
t2=t1;{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=t2;
av2[1]=stub1219(C_SCHEME_UNDEFINED);
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* k5721 in k5717 in k5713 in k5709 in k5696 in user-information in k5687 in k5683 in k5679 in k5675 in k5595 in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_5723(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(11,c,3)))){
C_save_and_reclaim((void *)f_5723,2,av);}
a=C_alloc(11);
t2=t1;
t3=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_5727,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[6],a[7]=t2,tmp=(C_word)a,a+=8,tmp);
/* ##sys#peek-c-string */
t4=*((C_word*)lf[4]+1);{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=t4;
av2[1]=t3;
av2[2]=C_mpointer(&a,(void*)C_user->pw_shell);
av2[3]=C_fix(0);
((C_proc)(void*)(*((C_word*)t4+1)))(4,av2);}}

/* k5725 in k5721 in k5717 in k5713 in k5709 in k5696 in user-information in k5687 in k5683 in k5679 in k5675 in k5595 in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 in ... */
static void C_ccall f_5727(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,8)))){
C_save_and_reclaim((void *)f_5727,2,av);}
/* posixunix.scm:871: g1243 */
t2=((C_word*)t0)[2];{
C_word *av2;
if(c >= 9) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(9);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[3];
av2[2]=((C_word*)t0)[4];
av2[3]=((C_word*)t0)[5];
av2[4]=C_fix((C_word)C_user->pw_uid);
av2[5]=C_fix((C_word)C_user->pw_gid);
av2[6]=((C_word*)t0)[6];
av2[7]=((C_word*)t0)[7];
av2[8]=t1;
((C_proc)(void*)(*((C_word*)t2+1)))(9,av2);}}

/* k4916 in k4909 in k4906 in k5066 in k4842 in k4834 in k4831 in k4828 in file-select in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_fcall f_4918(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,0,3)))){
C_save_and_reclaim_args((void *)trf_4918,2,t0,t1);}
if(C_truep(((C_word*)t0)[2])){
if(C_truep(C_fixnump(((C_word*)t0)[2]))){
if(C_truep(C_i_memq(((C_word*)t0)[2],((C_word*)t0)[3]))){
t2=((C_word*)t0)[2];
/* posixunix.scm:580: values */{
C_word av2[4];
av2[0]=0;
av2[1]=((C_word*)t0)[4];
av2[2]=t1;
av2[3]=t2;
C_values(4,av2);}}
else{
/* posixunix.scm:580: values */{
C_word av2[4];
av2[0]=0;
av2[1]=((C_word*)t0)[4];
av2[2]=t1;
av2[3]=C_SCHEME_FALSE;
C_values(4,av2);}}}
else{
/* posixunix.scm:580: values */{
C_word av2[4];
av2[0]=0;
av2[1]=((C_word*)t0)[4];
av2[2]=t1;
av2[3]=((C_word*)t0)[3];
C_values(4,av2);}}}
else{
/* posixunix.scm:580: values */{
C_word av2[4];
av2[0]=0;
av2[1]=((C_word*)t0)[4];
av2[2]=t1;
av2[3]=C_SCHEME_FALSE;
C_values(4,av2);}}}

/* k4909 in k4906 in k5066 in k4842 in k4834 in k4831 in k4828 in file-select in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_4911(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(5,c,2)))){
C_save_and_reclaim((void *)f_4911,2,av);}
a=C_alloc(5);
t2=t1;
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4918,a[2]=((C_word*)t0)[2],a[3]=t2,a[4]=((C_word*)t0)[3],tmp=(C_word)a,a+=5,tmp);
if(C_truep(((C_word*)t0)[4])){
if(C_truep(C_fixnump(((C_word*)t0)[4]))){
t4=C_i_memq(((C_word*)t0)[4],((C_word*)t0)[5]);
t5=t3;
f_4918(t5,(C_truep(t4)?((C_word*)t0)[4]:C_SCHEME_FALSE));}
else{
t4=t3;
f_4918(t4,((C_word*)t0)[5]);}}
else{
t4=t3;
f_4918(t4,C_SCHEME_FALSE);}}

/* k5077 in k4842 in k4834 in k4831 in k4828 in file-select in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_5079(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,1)))){
C_save_and_reclaim((void *)f_5079,2,av);}
a=C_alloc(4);
t2=C_a_i_times(&a,2,t1,C_fix(1000));
t3=((C_word*)t0)[2];
f_5068(t3,C_i_inexact_to_exact(t2));}

/* k8626 in a8617 in k5683 in k5679 in k5675 in k5595 in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_8628(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,4)))){
C_save_and_reclaim((void *)f_8628,2,av);}
/* posixunix.scm:859: ##sys#error */
t2=*((C_word*)lf[50]+1);{
C_word *av2;
if(c >= 5) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(5);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[2];
av2[2]=lf[452];
av2[3]=lf[453];
av2[4]=((C_word*)t0)[3];
((C_proc)(void*)(*((C_word*)t2+1)))(5,av2);}}

/* k5751 in current-user-name in k5687 in k5683 in k5679 in k5675 in k5595 in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_5753(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_5753,2,av);}
t2=((C_word*)t0)[2];{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=t2;
av2[1]=C_i_car(t1);
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* k6600 in a6597 in k6397 in k6391 in custom-input-port in k6200 in k6169 in k5687 in k5683 in k5679 in k5675 in k5595 in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 in ... */
static void C_ccall f_6602(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_6602,2,av);}
/* posixunix.scm:1192: peek */
t2=((C_word*)t0)[2];{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=t2;
av2[1]=(
  /* posixunix.scm:1192: peek */
  f_6429(((C_word*)t0)[3])
);
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* k5755 in current-user-name in k5687 in k5683 in k5679 in k5675 in k5595 in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_5757(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,2)))){
C_save_and_reclaim((void *)f_5757,2,av);}
/* posixunix.scm:888: user-information */
t2=*((C_word*)lf[266]+1);{
C_word *av2;
if(c >= 3) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(3);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[2];
av2[2]=t1;
((C_proc)(void*)(*((C_word*)t2+1)))(3,av2);}}

/* set-signal-handler! in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_4227(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_4227,4,av);}
t4=C_i_check_exact_2(t2,lf[121]);
if(C_truep(t3)){
t5=t2;
t6=C_establish_signal_handler(t2,t5);
t7=t1;{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=t7;
av2[1]=C_i_vector_set(*((C_word*)lf[122]+1),t2,t3);
((C_proc)(void*)(*((C_word*)t7+1)))(2,av2);}}
else{
t5=C_establish_signal_handler(t2,C_SCHEME_FALSE);
t6=t1;{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=t6;
av2[1]=C_i_vector_set(*((C_word*)lf[122]+1),t2,t3);
((C_proc)(void*)(*((C_word*)t6+1)))(2,av2);}}}

/* current-effective-user-name in k5687 in k5683 in k5679 in k5675 in k5595 in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_5759(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(C_unlikely(!C_demand(C_calculate_demand(6,c,2)))){
C_save_and_reclaim((void *)f_5759,2,av);}
a=C_alloc(6);
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5767,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5771,a[2]=t2,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm:891: current-effective-user-id */
t4=*((C_word*)lf[263]+1);{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=t4;
av2[1]=t3;
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* k5066 in k4842 in k4834 in k4831 in k4828 in file-select in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_fcall f_5068(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(15,0,6)))){
C_save_and_reclaim_args((void *)trf_5068,2,t0,t1);}
a=C_alloc(15);
t2=(C_truep(((C_word*)t0)[2])?C_i_foreign_block_argumentp(((C_word*)t0)[2]):C_SCHEME_FALSE);
t3=C_i_foreign_fixnum_argumentp(((C_word*)t0)[3]);
t4=C_i_foreign_fixnum_argumentp(t1);
t5=stub970(C_SCHEME_UNDEFINED,t2,t3,t4);
if(C_truep(C_fixnum_lessp(t5,C_fix(0)))){
/* posixunix.scm:561: posix-error */
t6=lf[0];{
C_word av2[7];
av2[0]=t6;
av2[1]=((C_word*)t0)[4];
av2[2]=lf[8];
av2[3]=lf[196];
av2[4]=lf[197];
av2[5]=((C_word*)t0)[5];
av2[6]=((C_word*)t0)[6];
f_2704(7,av2);}}
else{
t6=C_eqp(t5,C_fix(0));
if(C_truep(t6)){
t7=C_i_pairp(((C_word*)t0)[5]);
t8=(C_truep(t7)?C_SCHEME_END_OF_LIST:C_SCHEME_FALSE);
if(C_truep(C_i_pairp(((C_word*)t0)[6]))){
/* posixunix.scm:562: values */{
C_word av2[4];
av2[0]=0;
av2[1]=((C_word*)t0)[4];
av2[2]=t8;
av2[3]=C_SCHEME_END_OF_LIST;
C_values(4,av2);}}
else{
/* posixunix.scm:562: values */{
C_word av2[4];
av2[0]=0;
av2[1]=((C_word*)t0)[4];
av2[2]=t8;
av2[3]=C_SCHEME_FALSE;
C_values(4,av2);}}}
else{
t7=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_4908,a[2]=((C_word*)t0)[6],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[2],a[6]=((C_word*)t0)[7],a[7]=((C_word*)t0)[8],tmp=(C_word)a,a+=8,tmp);
t8=C_SCHEME_UNDEFINED;
t9=(*a=C_VECTOR_TYPE|1,a[1]=t8,tmp=(C_word)a,a+=2,tmp);
t10=C_set_block_item(t9,0,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_5007,a[2]=t9,a[3]=((C_word*)t0)[2],a[4]=((C_word)li104),tmp=(C_word)a,a+=5,tmp));
t11=((C_word*)t9)[1];
f_5007(t11,t7,C_fix(0),C_SCHEME_END_OF_LIST,((C_word*)t0)[9]);}}}

/* k3327 in create-directory in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_3329(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(10,c,5)))){
C_save_and_reclaim((void *)f_3329,2,av);}
a=C_alloc(10);
if(C_truep(t1)){
t2=((C_word*)t0)[2];{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=t2;
av2[1]=((C_word*)t0)[3];
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}
else{
if(C_truep(((C_word*)t0)[4])){
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3339,a[2]=((C_word*)t0)[5],tmp=(C_word)a,a+=3,tmp);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3383,a[2]=((C_word*)t0)[3],a[3]=((C_word)li29),tmp=(C_word)a,a+=4,tmp);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3389,a[2]=((C_word)li30),tmp=(C_word)a,a+=3,tmp);
/* posix-common.scm:459: ##sys#call-with-values */{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=0;
av2[1]=t2;
av2[2]=t3;
av2[3]=t4;
C_call_with_values(4,av2);}}
else{
t2=((C_word*)t0)[5];
t3=((C_word*)t0)[3];
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3412,a[2]=t2,a[3]=t3,tmp=(C_word)a,a+=4,tmp);
/* posix-common.scm:450: ##sys#make-c-string */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[11]+1));
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[11]+1);
av2[1]=t4;
av2[2]=t3;
av2[3]=lf[79];
tp(4,av2);}}}}

/* k3321 in create-directory in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_3323(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_3323,2,av);}
t2=((C_word*)t0)[2];{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=t2;
av2[1]=((C_word*)t0)[3];
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* current-user-name in k5687 in k5683 in k5679 in k5675 in k5595 in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_5745(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(C_unlikely(!C_demand(C_calculate_demand(6,c,2)))){
C_save_and_reclaim((void *)f_5745,2,av);}
a=C_alloc(6);
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5753,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5757,a[2]=t2,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm:888: current-user-id */
t4=*((C_word*)lf[262]+1);{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=t4;
av2[1]=t3;
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* k7203 in setup in k6200 in k6169 in k5687 in k5683 in k5679 in k5675 in k5595 in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_fcall f_7205(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(5,0,1)))){
C_save_and_reclaim_args((void *)trf_7205,2,t0,t1);}
a=C_alloc(5);
t2=C_slot(((C_word*)t0)[2],C_fix(1));
t3=(C_truep(t2)?C_fix((C_word)F_RDLCK):C_fix((C_word)F_WRLCK));
t4=C_flock_setup(t3,((C_word*)t0)[3],((C_word*)((C_word*)t0)[4])[1]);
t5=((C_word*)t0)[5];{
C_word av2[2];
av2[0]=t5;
av2[1]=C_a_i_record4(&a,4,lf[366],((C_word*)t0)[2],((C_word*)t0)[3],((C_word*)((C_word*)t0)[4])[1]);
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}

/* change-file-mode in k5687 in k5683 in k5679 in k5675 in k5595 in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_6067(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(5,c,3)))){
C_save_and_reclaim((void *)f_6067,4,av);}
a=C_alloc(5);
t4=C_i_check_string_2(t2,lf[320]);
t5=C_i_check_exact_2(t3,lf[320]);
t6=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_6088,a[2]=t3,a[3]=t1,a[4]=t2,tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm:1016: ##sys#make-c-string */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[11]+1));
C_word *av2=av; /* Re-use our own argvector */
av2[0]=*((C_word*)lf[11]+1);
av2[1]=t6;
av2[2]=t2;
av2[3]=lf[320];
tp(4,av2);}}

/* peek in k6397 in k6391 in custom-input-port in k6200 in k6169 in k5687 in k5683 in k5679 in k5675 in k5595 in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static C_word C_fcall f_6429(C_word t0){
C_word tmp;
C_word t1;
C_word t2;
C_stack_overflow_check;{}
if(C_truep(C_fixnum_greater_or_equal_p(((C_word*)((C_word*)t0)[2])[1],((C_word*)((C_word*)t0)[3])[1]))){
return(C_SCHEME_END_OF_FILE);}
else{
t1=C_subchar(((C_word*)t0)[4],((C_word*)((C_word*)t0)[2])[1]);
return(t1);}}

/* k4432 in a4357 in a4336 in k4327 in list->c-string-buffer in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_4434(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(3,c,2)))){
C_save_and_reclaim((void *)f_4434,2,av);}
a=C_alloc(3);
/* tmp22595 */
t2=((C_word*)t0)[2];
f_4417(t2,((C_word*)t0)[3],C_a_i_list(&a,1,t1));}

/* k3857 in find-files in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_3859(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(9,c,4)))){
C_save_and_reclaim((void *)f_3859,2,av);}
a=C_alloc(9);
t2=t1;
t3=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_3862,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t2,a[5]=((C_word*)t0)[4],tmp=(C_word)a,a+=6,tmp);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3891,a[2]=((C_word)li52),tmp=(C_word)a,a+=3,tmp);
/* posix-common.scm:552: ##sys#get-keyword */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[97]+1));
C_word *av2;
if(c >= 5) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(5);
}
av2[0]=*((C_word*)lf[97]+1);
av2[1]=t3;
av2[2]=lf[100];
av2[3]=((C_word*)t0)[4];
av2[4]=t4;
tp(5,av2);}}

/* fetch in k6397 in k6391 in custom-input-port in k6200 in k6169 in k5687 in k5683 in k5679 in k5675 in k5595 in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_fcall f_6437(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(14,0,2)))){
C_save_and_reclaim_args((void *)trf_6437,2,t0,t1);}
a=C_alloc(14);
t2=C_SCHEME_UNDEFINED;
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=C_set_block_item(t3,0,(*a=C_CLOSURE_TYPE|11,a[1]=(C_word)f_6443,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=t3,a[6]=((C_word*)t0)[5],a[7]=((C_word*)t0)[6],a[8]=((C_word*)t0)[7],a[9]=((C_word*)t0)[8],a[10]=((C_word*)t0)[9],a[11]=((C_word)li161),tmp=(C_word)a,a+=12,tmp));
t5=((C_word*)t3)[1];{
C_word av2[2];
av2[0]=t5;
av2[1]=t1;
f_6443(2,av2);}}

/* free-c-string-buffer in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_fcall f_4440(C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,0,2)))){
C_save_and_reclaim_args((void *)trf_4440,2,t1,t2);}
a=C_alloc(4);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4444,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* posix-common.scm:719: pointer-vector-length */
t4=*((C_word*)lf[140]+1);{
C_word av2[3];
av2[0]=t4;
av2[1]=t3;
av2[2]=t2;
((C_proc)(void*)(*((C_word*)t4+1)))(3,av2);}}

/* file-lock in k6200 in k6169 in k5687 in k5683 in k5679 in k5675 in k5595 in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_7266(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand((c-3)*C_SIZEOF_PAIR +5,c,4)))){
C_save_and_reclaim((void*)f_7266,c,av);}
a=C_alloc((c-3)*C_SIZEOF_PAIR+5);
t3=C_build_rest(&a,c,3,av);
C_word t4;
C_word t5;
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_7270,a[2]=t2,a[3]=((C_word*)t0)[2],a[4]=t1,tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm:1338: setup */
f_7184(t4,t2,t3,lf[367]);}

/* k4442 in free-c-string-buffer in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_4444(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(8,c,3)))){
C_save_and_reclaim((void *)f_4444,2,av);}
a=C_alloc(8);
t2=t1;
t3=C_SCHEME_UNDEFINED;
t4=(*a=C_VECTOR_TYPE|1,a[1]=t3,tmp=(C_word)a,a+=2,tmp);
t5=C_set_block_item(t4,0,(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_4449,a[2]=t2,a[3]=t4,a[4]=((C_word*)t0)[2],a[5]=((C_word)li81),tmp=(C_word)a,a+=6,tmp));
t6=((C_word*)t4)[1];
f_4449(t6,((C_word*)t0)[3],C_fix(0));}

/* find-files in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_3855(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand((c-3)*C_SIZEOF_PAIR +8,c,4)))){
C_save_and_reclaim((void*)f_3855,c,av);}
a=C_alloc((c-3)*C_SIZEOF_PAIR+8);
t3=C_build_rest(&a,c,3,av);
C_word t4;
C_word t5;
C_word t6;
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3859,a[2]=t1,a[3]=t2,a[4]=t3,tmp=(C_word)a,a+=5,tmp);
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3899,a[2]=((C_word)li54),tmp=(C_word)a,a+=3,tmp);
/* posix-common.scm:552: ##sys#get-keyword */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[97]+1));
C_word *av2;
if(c >= 5) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(5);
}
av2[0]=*((C_word*)lf[97]+1);
av2[1]=t4;
av2[2]=lf[101];
av2[3]=t3;
av2[4]=t5;
tp(5,av2);}}

/* k5034 in lp in k5066 in k4842 in k4834 in k4831 in k4828 in file-select in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_fcall f_5036(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(3,0,4)))){
C_save_and_reclaim_args((void *)trf_5036,2,t0,t1);}
a=C_alloc(3);
if(C_truep(t1)){
t2=C_fixnum_plus(((C_word*)t0)[2],C_fix(1));
t3=C_i_car(((C_word*)t0)[3]);
t4=C_a_i_cons(&a,2,t3,((C_word*)t0)[4]);
t5=((C_word*)t0)[3];
t6=C_u_i_cdr(t5);
/* posixunix.scm:570: lp */
t7=((C_word*)((C_word*)t0)[5])[1];
f_5007(t7,((C_word*)t0)[6],t2,t4,t6);}
else{
t2=C_fixnum_plus(((C_word*)t0)[2],C_fix(1));
t3=C_i_cdr(((C_word*)t0)[3]);
/* posixunix.scm:571: lp */
t4=((C_word*)((C_word*)t0)[5])[1];
f_5007(t4,((C_word*)t0)[6],t2,((C_word*)t0)[4],t3);}}

/* f_3901 in a3898 in find-files in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_3901(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_3901,2,av);}
t2=t1;{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=t2;
av2[1]=C_SCHEME_TRUE;
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_3906(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word t17;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(38,c,4)))){
C_save_and_reclaim((void *)f_3906,2,av);}
a=C_alloc(38);
t2=C_mutate2((C_word*)lf[102]+1 /* (set! file-creation-mode ...) */,t1);
t3=C_mutate2(&lf[103] /* (set! check-time-vector ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3908,a[2]=((C_word)li56),tmp=(C_word)a,a+=3,tmp));
t4=C_mutate2((C_word*)lf[105]+1 /* (set! seconds->local-time ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3927,a[2]=((C_word)li57),tmp=(C_word)a,a+=3,tmp));
t5=C_mutate2((C_word*)lf[108]+1 /* (set! seconds->utc-time ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3948,a[2]=((C_word)li58),tmp=(C_word)a,a+=3,tmp));
t6=C_mutate2((C_word*)lf[109]+1 /* (set! seconds->string ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3979,a[2]=((C_word)li59),tmp=(C_word)a,a+=3,tmp));
t7=C_fix((C_word)sizeof(struct tm));
t8=C_mutate2((C_word*)lf[111]+1 /* (set! local-time->seconds ...) */,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4017,a[2]=t7,a[3]=((C_word)li60),tmp=(C_word)a,a+=4,tmp));
t9=C_fix((C_word)sizeof(struct tm));
t10=C_mutate2((C_word*)lf[115]+1 /* (set! time->string ...) */,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4062,a[2]=t9,a[3]=((C_word)li61),tmp=(C_word)a,a+=4,tmp));
t11=C_mutate2((C_word*)lf[118]+1 /* (set! setenv ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4124,a[2]=((C_word)li62),tmp=(C_word)a,a+=3,tmp));
t12=C_mutate2((C_word*)lf[119]+1 /* (set! unsetenv ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4141,a[2]=((C_word)li63),tmp=(C_word)a,a+=3,tmp));
t13=C_mutate2((C_word*)lf[120]+1 /* (set! get-environment-variables ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4161,a[2]=((C_word)li66),tmp=(C_word)a,a+=3,tmp));
t14=C_mutate2((C_word*)lf[121]+1 /* (set! set-signal-handler! ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4227,a[2]=((C_word)li67),tmp=(C_word)a,a+=3,tmp));
t15=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4242,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
t16=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_8725,a[2]=((C_word)li260),tmp=(C_word)a,a+=3,tmp);
/* posix-common.scm:663: getter-with-setter */
t17=*((C_word*)lf[450]+1);{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=t17;
av2[1]=t15;
av2[2]=t16;
av2[3]=*((C_word*)lf[121]+1);
((C_proc)(void*)(*((C_word*)t17+1)))(4,av2);}}

/* doloop702 in k4442 in free-c-string-buffer in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_fcall f_4449(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(5,0,3)))){
C_save_and_reclaim_args((void *)trf_4449,3,t0,t1,t2);}
a=C_alloc(5);
t3=C_eqp(t2,((C_word*)t0)[2]);
if(C_truep(t3)){
t4=C_SCHEME_UNDEFINED;
t5=t1;{
C_word av2[2];
av2[0]=t5;
av2[1]=t4;
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}
else{
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4459,a[2]=t2,a[3]=((C_word*)t0)[3],a[4]=t1,tmp=(C_word)a,a+=5,tmp);
/* posix-common.scm:722: pointer-vector-ref */
t5=*((C_word*)lf[139]+1);{
C_word av2[4];
av2[0]=t5;
av2[1]=t4;
av2[2]=((C_word*)t0)[4];
av2[3]=t2;
((C_proc)(void*)(*((C_word*)t5+1)))(4,av2);}}}

/* check-time-vector in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_fcall f_3908(C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,0,4)))){
C_save_and_reclaim_args((void *)trf_3908,3,t1,t2,t3);}
t4=C_i_check_vector_2(t3,t2);
t5=C_block_size(t3);
if(C_truep(C_fixnum_lessp(t5,C_fix(10)))){
/* posix-common.scm:581: ##sys#error */
t6=*((C_word*)lf[50]+1);{
C_word av2[5];
av2[0]=t6;
av2[1]=t1;
av2[2]=t2;
av2[3]=lf[104];
av2[4]=t3;
((C_proc)(void*)(*((C_word*)t6+1)))(5,av2);}}
else{
t6=C_SCHEME_UNDEFINED;
t7=t1;{
C_word av2[2];
av2[0]=t7;
av2[1]=t6;
((C_proc)(void*)(*((C_word*)t7+1)))(2,av2);}}}

/* err in k6200 in k6169 in k5687 in k5683 in k5679 in k5675 in k5595 in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_fcall f_7248(C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,0,7)))){
C_save_and_reclaim_args((void *)trf_7248,4,t1,t2,t3,t4);}
t5=C_slot(t3,C_fix(1));
t6=C_slot(t3,C_fix(2));
t7=C_slot(t3,C_fix(3));
/* posixunix.scm:1335: posix-error */
t8=lf[0];{
C_word av2[8];
av2[0]=t8;
av2[1]=t1;
av2[2]=lf[8];
av2[3]=t4;
av2[4]=t2;
av2[5]=t5;
av2[6]=t6;
av2[7]=t7;
f_2704(8,av2);}}

/* k6024 in initialize-groups in k5687 in k5683 in k5679 in k5675 in k5595 in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_6026(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(5,c,2)))){
C_save_and_reclaim((void *)f_6026,2,av);}
a=C_alloc(5);
if(C_truep(C_fixnum_lessp(t1,C_fix(0)))){
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_6019,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm:963: ##sys#update-errno */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[5]+1));
C_word *av2=av; /* Re-use our own argvector */
av2[0]=*((C_word*)lf[5]+1);
av2[1]=t2;
tp(2,av2);}}
else{
t2=C_SCHEME_UNDEFINED;
t3=((C_word*)t0)[2];{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=t3;
av2[1]=t2;
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}}

/* for-each-loop288 in k3254 in delete-directory in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_fcall f_3281(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(5,0,2)))){
C_save_and_reclaim_args((void *)trf_3281,3,t0,t1,t2);}
a=C_alloc(5);
if(C_truep(C_i_pairp(t2))){
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3291,a[2]=t2,a[3]=((C_word*)t0)[2],a[4]=t1,tmp=(C_word)a,a+=5,tmp);
t4=C_slot(t2,C_fix(0));
/* posix-common.scm:435: g289 */
t5=((C_word*)t0)[3];
f_3257(t5,t3,t4);}
else{
t3=C_SCHEME_UNDEFINED;
t4=t1;{
C_word av2[2];
av2[0]=t4;
av2[1]=t3;
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}}

/* file-test-lock in k6200 in k6169 in k5687 in k5683 in k5679 in k5675 in k5595 in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_7298(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand((c-3)*C_SIZEOF_PAIR +5,c,4)))){
C_save_and_reclaim((void*)f_7298,c,av);}
a=C_alloc((c-3)*C_SIZEOF_PAIR+5);
t3=C_build_rest(&a,c,3,av);
C_word t4;
C_word t5;
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_7302,a[2]=t2,a[3]=t1,a[4]=((C_word*)t0)[2],tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm:1350: setup */
f_7184(t4,t2,t3,lf[371]);}

/* k3274 in k3254 in delete-directory in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_3276(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,2)))){
C_save_and_reclaim((void *)f_3276,2,av);}
/* posix-common.scm:446: rmdir */
f_3233(((C_word*)t0)[3],((C_word*)t0)[4]);}

/* k3271 in k3265 in g289 in k3254 in delete-directory in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_3273(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,2)))){
C_save_and_reclaim((void *)f_3273,2,av);}
if(C_truep(t1)){
/* posix-common.scm:440: g299 */
f_3233(((C_word*)t0)[3],((C_word*)t0)[4]);}
else{
t2=*((C_word*)lf[75]+1);
t3=*((C_word*)lf[75]+1);
/* posix-common.scm:440: g299 */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[75]+1));
C_word *av2;
if(c >= 3) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(3);
}
av2[0]=*((C_word*)lf[75]+1);
av2[1]=((C_word*)t0)[3];
av2[2]=((C_word*)t0)[4];
tp(3,av2);}}}

/* k7268 in file-lock in k6200 in k6169 in k5687 in k5683 in k5679 in k5675 in k5595 in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_7270(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,4)))){
C_save_and_reclaim((void *)f_7270,2,av);}
t2=C_flock_lock(((C_word*)t0)[2]);
if(C_truep(C_fixnum_lessp(t2,C_fix(0)))){
/* posixunix.scm:1340: err */
f_7248(((C_word*)t0)[4],lf[368],t1,lf[367]);}
else{
t3=((C_word*)t0)[4];{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=t3;
av2[1]=t1;
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}}

/* k4975 in lp in k4906 in k5066 in k4842 in k4834 in k4831 in k4828 in file-select in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_fcall f_4977(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(3,0,4)))){
C_save_and_reclaim_args((void *)trf_4977,2,t0,t1);}
a=C_alloc(3);
if(C_truep(t1)){
t2=C_fixnum_plus(((C_word*)t0)[2],C_fix(1));
t3=C_i_car(((C_word*)t0)[3]);
t4=C_a_i_cons(&a,2,t3,((C_word*)t0)[4]);
t5=((C_word*)t0)[3];
t6=C_u_i_cdr(t5);
/* posixunix.scm:578: lp */
t7=((C_word*)((C_word*)t0)[5])[1];
f_4948(t7,((C_word*)t0)[6],t2,t4,t6);}
else{
t2=C_fixnum_plus(((C_word*)t0)[2],C_fix(1));
t3=C_i_cdr(((C_word*)t0)[3]);
/* posixunix.scm:579: lp */
t4=((C_word*)((C_word*)t0)[5])[1];
f_4948(t4,((C_word*)t0)[6],t2,((C_word*)t0)[4],t3);}}

/* k3289 in for-each-loop288 in k3254 in delete-directory in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_3291(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,2)))){
C_save_and_reclaim((void *)f_3291,2,av);}
t2=C_slot(((C_word*)t0)[2],C_fix(1));
t3=((C_word*)((C_word*)t0)[3])[1];
f_3281(t3,((C_word*)t0)[4],t2);}

/* a4422 in tmp22595 in a4357 in a4336 in k4327 in list->c-string-buffer in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_4423(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,2)))){
C_save_and_reclaim((void *)f_4423,2,av);}{
C_word *av2;
if(c >= 3) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(3);
}
av2[0]=0;
av2[1]=t1;
av2[2]=((C_word*)t0)[2];
C_apply_values(3,av2);}}

/* file-lock/blocking in k6200 in k6169 in k5687 in k5683 in k5679 in k5675 in k5595 in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_7282(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand((c-3)*C_SIZEOF_PAIR +5,c,4)))){
C_save_and_reclaim((void*)f_7282,c,av);}
a=C_alloc((c-3)*C_SIZEOF_PAIR+5);
t3=C_build_rest(&a,c,3,av);
C_word t4;
C_word t5;
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_7286,a[2]=t2,a[3]=((C_word*)t0)[2],a[4]=t1,tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm:1344: setup */
f_7184(t4,t2,t3,lf[369]);}

/* k7284 in file-lock/blocking in k6200 in k6169 in k5687 in k5683 in k5679 in k5675 in k5595 in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_7286(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,4)))){
C_save_and_reclaim((void *)f_7286,2,av);}
t2=C_flock_lockw(((C_word*)t0)[2]);
if(C_truep(C_fixnum_lessp(t2,C_fix(0)))){
/* posixunix.scm:1346: err */
f_7248(((C_word*)t0)[4],lf[370],t1,lf[369]);}
else{
t3=((C_word*)t0)[4];{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=t3;
av2[1]=t1;
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}}

/* tmp22595 in a4357 in a4336 in k4327 in list->c-string-buffer in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_fcall f_4417(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,0,2)))){
C_save_and_reclaim_args((void *)trf_4417,3,t0,t1,t2);}
a=C_alloc(4);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4423,a[2]=t2,a[3]=((C_word)li76),tmp=(C_word)a,a+=4,tmp);
/* posix-common.scm:696: k674 */
t4=((C_word*)t0)[2];{
C_word av2[3];
av2[0]=t4;
av2[1]=t1;
av2[2]=t3;
((C_proc)C_fast_retrieve_proc(t4))(3,av2);}}

/* lp in k4906 in k5066 in k4842 in k4834 in k4831 in k4828 in file-select in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_fcall f_4948(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(7,0,2)))){
C_save_and_reclaim_args((void *)trf_4948,5,t0,t1,t2,t3,t4);}
a=C_alloc(7);
if(C_truep(C_i_nullp(t4))){
/* posixunix.scm:573: ##sys#fast-reverse */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[198]+1));
C_word av2[3];
av2[0]=*((C_word*)lf[198]+1);
av2[1]=t1;
av2[2]=t3;
tp(3,av2);}}
else{
t5=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_4977,a[2]=t2,a[3]=t4,a[4]=t3,a[5]=((C_word*)t0)[2],a[6]=t1,tmp=(C_word)a,a+=7,tmp);
t6=t2;
t7=C_i_foreign_fixnum_argumentp(t6);
if(C_truep(((C_word*)t0)[3])){
t8=C_i_foreign_block_argumentp(((C_word*)t0)[3]);
t9=t5;
f_4977(t9,stub1014(C_SCHEME_UNDEFINED,t7,t8));}
else{
t8=t5;
f_4977(t8,stub1014(C_SCHEME_UNDEFINED,t7,C_SCHEME_FALSE));}}}

/* seconds->local-time in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_3927(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand((c-2)*C_SIZEOF_PAIR +3,c,3)))){
C_save_and_reclaim((void*)f_3927,c,av);}
a=C_alloc((c-2)*C_SIZEOF_PAIR+3);
t2=C_build_rest(&a,c,2,av);
C_word t3;
C_word t4;
C_word t5;
C_word t6;
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3931,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
if(C_truep(C_i_nullp(t2))){
/* posix-common.scm:583: current-seconds */
t4=*((C_word*)lf[107]+1);{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=t4;
av2[1]=t3;
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}
else{
t4=C_i_car(t2);
t5=C_i_check_number_2(t4,lf[105]);
/* posix-common.scm:585: ##sys#decode-seconds */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[106]+1));
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[106]+1);
av2[1]=t1;
av2[2]=t4;
av2[3]=C_SCHEME_FALSE;
tp(4,av2);}}}

/* k3950 in seconds->utc-time in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_3952(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,3)))){
C_save_and_reclaim((void *)f_3952,2,av);}
t2=C_i_check_number_2(t1,lf[108]);
/* posix-common.scm:589: ##sys#decode-seconds */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[106]+1));
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[106]+1);
av2[1]=((C_word*)t0)[2];
av2[2]=t1;
av2[3]=C_SCHEME_TRUE;
tp(4,av2);}}

/* k3981 in seconds->string in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_3983(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(9,c,3)))){
C_save_and_reclaim((void *)f_3983,2,av);}
a=C_alloc(9);
t2=t1;
t3=C_i_check_number_2(t2,lf[109]);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3989,a[2]=((C_word*)t0)[2],a[3]=t2,tmp=(C_word)a,a+=4,tmp);
t5=C_a_i_bytevector(&a,1,C_fix(3));
t6=C_i_foreign_integer_argumentp(t2);
t7=stub544(t5,t6);
/* posix-common.scm:592: ##sys#peek-c-string */
t8=*((C_word*)lf[4]+1);{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=t8;
av2[1]=t4;
av2[2]=t7;
av2[3]=C_fix(0);
((C_proc)(void*)(*((C_word*)t8+1)))(4,av2);}}

/* loop in fetch in k6397 in k6391 in custom-input-port in k6200 in k6169 in k5687 in k5683 in k5679 in k5675 in k5595 in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 in ... */
static void C_ccall f_6443(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(C_unlikely(!C_demand(C_calculate_demand(11,c,6)))){
C_save_and_reclaim((void *)f_6443,2,av);}
a=C_alloc(11);
t2=C_read(((C_word*)t0)[2],((C_word*)t0)[3],((C_word*)t0)[4]);
t3=C_eqp(t2,C_fix(-1));
if(C_truep(t3)){
t4=C_fix((C_word)errno);
t5=C_i_eqvp(t4,C_fix((C_word)EWOULDBLOCK));
t6=(C_truep(t5)?t5:C_i_eqvp(t4,C_fix((C_word)EAGAIN)));
if(C_truep(t6)){
t7=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_6462,a[2]=((C_word*)t0)[5],a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm:1148: ##sys#thread-block-for-i/o! */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[349]+1));
C_word *av2;
if(c >= 5) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(5);
}
av2[0]=*((C_word*)lf[349]+1);
av2[1]=t7;
av2[2]=*((C_word*)lf[350]+1);
av2[3]=((C_word*)t0)[2];
av2[4]=lf[351];
tp(5,av2);}}
else{
if(C_truep(C_i_eqvp(t4,C_fix((C_word)EINTR)))){
/* posixunix.scm:1152: ##sys#dispatch-interrupt */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[186]+1));
C_word *av2;
if(c >= 3) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(3);
}
av2[0]=*((C_word*)lf[186]+1);
av2[1]=t1;
av2[2]=((C_word*)((C_word*)t0)[5])[1];
tp(3,av2);}}
else{
/* posixunix.scm:1153: posix-error */
t7=lf[0];{
C_word *av2;
if(c >= 7) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(7);
}
av2[0]=t7;
av2[1]=t1;
av2[2]=lf[8];
av2[3]=((C_word*)t0)[6];
av2[4]=lf[352];
av2[5]=((C_word*)t0)[2];
av2[6]=((C_word*)t0)[7];
f_2704(7,av2);}}}}
else{
t4=(C_truep(((C_word*)t0)[8])?C_eqp(t2,C_fix(0)):C_SCHEME_FALSE);
if(C_truep(t4)){
t5=(*a=C_CLOSURE_TYPE|10,a[1]=(C_word)f_6495,a[2]=((C_word*)t0)[5],a[3]=t1,a[4]=((C_word*)t0)[2],a[5]=((C_word*)t0)[3],a[6]=((C_word*)t0)[4],a[7]=((C_word*)t0)[9],a[8]=((C_word*)t0)[10],a[9]=((C_word*)t0)[6],a[10]=((C_word*)t0)[7],tmp=(C_word)a,a+=11,tmp);
/* posixunix.scm:1157: more? */
t6=((C_word*)t0)[8];{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=t6;
av2[1]=t5;
((C_proc)C_fast_retrieve_proc(t6))(2,av2);}}
else{
t5=C_mutate2(((C_word *)((C_word*)t0)[9])+1,t2);
t6=C_set_block_item(((C_word*)t0)[10],0,C_fix(0));
t7=t1;{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=t7;
av2[1]=t6;
((C_proc)(void*)(*((C_word*)t7+1)))(2,av2);}}}}

/* k3987 in k3981 in seconds->string in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_3989(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,4)))){
C_save_and_reclaim((void *)f_3989,2,av);}
if(C_truep(t1)){
t2=C_block_size(t1);
t3=C_fixnum_difference(t2,C_fix(1));
/* posix-common.scm:597: ##sys#substring */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[70]+1));
C_word *av2;
if(c >= 5) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(5);
}
av2[0]=*((C_word*)lf[70]+1);
av2[1]=((C_word*)t0)[2];
av2[2]=t1;
av2[3]=C_fix(0);
av2[4]=t3;
tp(5,av2);}}
else{
/* posix-common.scm:598: ##sys#error */
t2=*((C_word*)lf[50]+1);{
C_word *av2;
if(c >= 5) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(5);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[2];
av2[2]=lf[109];
av2[3]=lf[110];
av2[4]=((C_word*)t0)[3];
((C_proc)(void*)(*((C_word*)t2+1)))(5,av2);}}}

/* k3929 in seconds->local-time in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_3931(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,3)))){
C_save_and_reclaim((void *)f_3931,2,av);}
t2=C_i_check_number_2(t1,lf[105]);
/* posix-common.scm:585: ##sys#decode-seconds */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[106]+1));
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[106]+1);
av2[1]=((C_word*)t0)[2];
av2[2]=t1;
av2[3]=C_SCHEME_FALSE;
tp(4,av2);}}

/* k4460 in k4457 in doloop702 in k4442 in free-c-string-buffer in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_4462(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,2)))){
C_save_and_reclaim((void *)f_4462,2,av);}
t2=C_fixnum_plus(((C_word*)t0)[2],C_fix(1));
t3=((C_word*)((C_word*)t0)[3])[1];
f_4449(t3,((C_word*)t0)[4],t2);}

/* k4457 in doloop702 in k4442 in free-c-string-buffer in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_4459(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(5,c,2)))){
C_save_and_reclaim((void *)f_4459,2,av);}
a=C_alloc(5);
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4462,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],tmp=(C_word)a,a+=5,tmp);
if(C_truep(t1)){
/* posix-common.scm:723: free */
t3=*((C_word*)lf[138]+1);{
C_word *av2;
if(c >= 3) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(3);
}
av2[0]=t3;
av2[1]=t2;
av2[2]=t1;
((C_proc)(void*)(*((C_word*)t3+1)))(3,av2);}}
else{
t3=C_fixnum_plus(((C_word*)t0)[2],C_fix(1));
t4=((C_word*)((C_word*)t0)[3])[1];
f_4449(t4,((C_word*)t0)[4],t3);}}

/* loop in poke1594 in k6908 in custom-output-port in k6200 in k6169 in k5687 in k5683 in k5679 in k5675 in k5595 in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_6917(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(C_unlikely(!C_demand(C_calculate_demand(6,c,6)))){
C_save_and_reclaim((void *)f_6917,2,av);}
a=C_alloc(6);
t2=C_write(((C_word*)t0)[2],((C_word*)t0)[3],((C_word*)t0)[4]);
t3=C_eqp(C_fix(-1),t2);
if(C_truep(t3)){
t4=C_fix((C_word)errno);
t5=C_i_eqvp(t4,C_fix((C_word)EWOULDBLOCK));
t6=(C_truep(t5)?t5:C_i_eqvp(t4,C_fix((C_word)EAGAIN)));
if(C_truep(t6)){
t7=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_6936,a[2]=((C_word*)t0)[5],a[3]=t1,a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],tmp=(C_word)a,a+=6,tmp);
/* posixunix.scm:1259: ##sys#thread-yield! */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[348]+1));
C_word *av2=av; /* Re-use our own argvector */
av2[0]=*((C_word*)lf[348]+1);
av2[1]=t7;
tp(2,av2);}}
else{
if(C_truep(C_i_eqvp(t4,C_fix((C_word)EINTR)))){
/* posixunix.scm:1262: ##sys#dispatch-interrupt */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[186]+1));
C_word *av2;
if(c >= 3) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(3);
}
av2[0]=*((C_word*)lf[186]+1);
av2[1]=t1;
av2[2]=((C_word*)((C_word*)t0)[6])[1];
tp(3,av2);}}
else{
/* posixunix.scm:1264: posix-error */
t7=lf[0];{
C_word *av2;
if(c >= 7) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(7);
}
av2[0]=t7;
av2[1]=t1;
av2[2]=((C_word*)t0)[7];
av2[3]=lf[8];
av2[4]=lf[360];
av2[5]=((C_word*)t0)[2];
av2[6]=((C_word*)t0)[8];
f_2704(7,av2);}}}}
else{
if(C_truep(C_fixnum_lessp(t2,((C_word*)t0)[4]))){
t4=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_6967,a[2]=((C_word*)t0)[4],a[3]=t2,a[4]=((C_word*)t0)[5],a[5]=t1,tmp=(C_word)a,a+=6,tmp);
/* posixunix.scm:1266: ##sys#substring */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[70]+1));
C_word *av2;
if(c >= 5) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(5);
}
av2[0]=*((C_word*)lf[70]+1);
av2[1]=t4;
av2[2]=((C_word*)t0)[3];
av2[3]=t2;
av2[4]=((C_word*)t0)[4];
tp(5,av2);}}
else{
t4=t1;{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=t4;
av2[1]=C_SCHEME_UNDEFINED;
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}}}

/* poke1594 in k6908 in custom-output-port in k6200 in k6169 in k5687 in k5683 in k5679 in k5675 in k5595 in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_6911(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(12,c,2)))){
C_save_and_reclaim((void *)f_6911,4,av);}
a=C_alloc(12);
t4=C_SCHEME_UNDEFINED;
t5=(*a=C_VECTOR_TYPE|1,a[1]=t4,tmp=(C_word)a,a+=2,tmp);
t6=C_set_block_item(t5,0,(*a=C_CLOSURE_TYPE|9,a[1]=(C_word)f_6917,a[2]=((C_word*)t0)[2],a[3]=t2,a[4]=t3,a[5]=((C_word*)t0)[3],a[6]=t5,a[7]=((C_word*)t0)[4],a[8]=((C_word*)t0)[5],a[9]=((C_word)li175),tmp=(C_word)a,a+=10,tmp));
t7=((C_word*)t5)[1];{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=t7;
av2[1]=t1;
f_6917(2,av2);}}

/* k6908 in custom-output-port in k6200 in k6169 in k5687 in k5683 in k5679 in k5675 in k5595 in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_6910(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(26,c,4)))){
C_save_and_reclaim((void *)f_6910,2,av);}
a=C_alloc(26);
t2=C_SCHEME_UNDEFINED;
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=C_SCHEME_UNDEFINED;
t5=(*a=C_VECTOR_TYPE|1,a[1]=t4,tmp=(C_word)a,a+=2,tmp);
t6=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_6911,a[2]=((C_word*)t0)[2],a[3]=t3,a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],a[6]=((C_word)li176),tmp=(C_word)a,a+=7,tmp);
t7=C_fixnump(((C_word*)t0)[5]);
t8=(C_truep(t7)?((C_word*)t0)[5]:C_block_size(((C_word*)t0)[5]));
t9=t8;
t10=(*a=C_CLOSURE_TYPE|9,a[1]=(C_word)f_6977,a[2]=t3,a[3]=t6,a[4]=t5,a[5]=((C_word*)t0)[6],a[6]=((C_word*)t0)[4],a[7]=((C_word*)t0)[7],a[8]=((C_word*)t0)[2],a[9]=((C_word*)t0)[3],tmp=(C_word)a,a+=10,tmp);
t11=C_eqp(C_fix(0),t9);
if(C_truep(t11)){
t12=t10;
f_6977(t12,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_7024,a[2]=t3,a[3]=((C_word)li180),tmp=(C_word)a,a+=4,tmp));}
else{
t12=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_7038,a[2]=t10,a[3]=t9,a[4]=t3,tmp=(C_word)a,a+=5,tmp);
if(C_truep(C_fixnump(((C_word*)t0)[5]))){
/* posixunix.scm:1273: ##sys#make-string */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[72]+1));
C_word *av2;
if(c >= 3) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(3);
}
av2[0]=*((C_word*)lf[72]+1);
av2[1]=t12;
av2[2]=((C_word*)t0)[5];
tp(3,av2);}}
else{
t13=t12;{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=t13;
av2[1]=((C_word*)t0)[5];
f_7038(2,av2);}}}}

/* k3207 in k3204 in current-directory in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_3209(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,4)))){
C_save_and_reclaim((void *)f_3209,2,av);}
if(C_truep(((C_word*)t0)[2])){
/* posix-common.scm:422: ##sys#substring */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[70]+1));
C_word *av2;
if(c >= 5) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(5);
}
av2[0]=*((C_word*)lf[70]+1);
av2[1]=((C_word*)t0)[3];
av2[2]=((C_word*)t0)[4];
av2[3]=C_fix(0);
av2[4]=((C_word*)t0)[2];
tp(5,av2);}}
else{
/* posix-common.scm:423: ##sys#signal-hook */
t2=*((C_word*)lf[1]+1);{
C_word *av2;
if(c >= 5) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(5);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[3];
av2[2]=lf[8];
av2[3]=lf[68];
av2[4]=lf[71];
((C_proc)(void*)(*((C_word*)t2+1)))(5,av2);}}}

/* k3204 in current-directory in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_3206(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(5,c,2)))){
C_save_and_reclaim((void *)f_3206,2,av);}
a=C_alloc(5);
t2=t1;
t3=C_curdir(t2);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3209,a[2]=t3,a[3]=((C_word*)t0)[2],a[4]=t2,tmp=(C_word)a,a+=5,tmp);
/* posix-common.scm:420: ##sys#update-errno */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[5]+1));
C_word *av2=av; /* Re-use our own argvector */
av2[0]=*((C_word*)lf[5]+1);
av2[1]=t4;
tp(2,av2);}}

/* k6463 in k6460 in loop in fetch in k6397 in k6391 in custom-input-port in k6200 in k6169 in k5687 in k5683 in k5679 in k5675 in k5595 in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in ... */
static void C_ccall f_6465(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_6465,2,av);}
/* posixunix.scm:1150: loop */
t2=((C_word*)((C_word*)t0)[2])[1];{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=t2;
av2[1]=((C_word*)t0)[3];
f_6443(2,av2);}}

/* k7834 in k7813 in terminal-size in k6200 in k6169 in k5687 in k5683 in k5679 in k5675 in k5595 in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_7836(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(8,c,5)))){
C_save_and_reclaim((void *)f_7836,2,av);}
a=C_alloc(8);
t2=t1;
t3=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_7840,a[2]=((C_word*)t0)[2],a[3]=t2,a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],a[6]=((C_word*)t0)[5],a[7]=((C_word*)t0)[6],tmp=(C_word)a,a+=8,tmp);
/* posixunix.scm:1527: ##sys#make-locative */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[419]+1));
C_word *av2;
if(c >= 6) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(6);
}
av2[0]=*((C_word*)lf[419]+1);
av2[1]=t3;
av2[2]=((C_word*)t0)[5];
av2[3]=C_fix(0);
av2[4]=C_SCHEME_FALSE;
av2[5]=lf[420];
tp(6,av2);}}

/* k6460 in loop in fetch in k6397 in k6391 in custom-input-port in k6200 in k6169 in k5687 in k5683 in k5679 in k5675 in k5595 in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in ... */
static void C_ccall f_6462(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,2)))){
C_save_and_reclaim((void *)f_6462,2,av);}
a=C_alloc(4);
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_6465,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm:1149: ##sys#thread-yield! */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[348]+1));
C_word *av2=av; /* Re-use our own argvector */
av2[0]=*((C_word*)lf[348]+1);
av2[1]=t2;
tp(2,av2);}}

/* k7838 in k7834 in k7813 in terminal-size in k6200 in k6169 in k5687 in k5683 in k5679 in k5675 in k5595 in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_7840(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,5)))){
C_save_and_reclaim((void *)f_7840,2,av);}
t2=C_i_foreign_fixnum_argumentp(((C_word*)t0)[2]);
t3=C_i_foreign_pointer_argumentp(((C_word*)t0)[3]);
t4=C_i_foreign_pointer_argumentp(t1);
t5=stub1865(C_SCHEME_UNDEFINED,t2,t3,t4);
t6=C_eqp(C_fix(0),t5);
if(C_truep(t6)){
/* posixunix.scm:1528: values */{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=0;
av2[1]=((C_word*)t0)[4];
av2[2]=C_fix((C_word)*((int *)C_data_pointer(((C_word*)t0)[5])));
av2[3]=C_fix((C_word)*((int *)C_data_pointer(((C_word*)t0)[6])));
C_values(4,av2);}}
else{
/* posixunix.scm:1529: posix-error */
t7=lf[0];{
C_word *av2;
if(c >= 6) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(6);
}
av2[0]=t7;
av2[1]=((C_word*)t0)[4];
av2[2]=lf[417];
av2[3]=lf[416];
av2[4]=lf[418];
av2[5]=((C_word*)t0)[7];
f_2704(6,av2);}}}

/* delete-directory in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_3227(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand((c-3)*C_SIZEOF_PAIR +8,c,6)))){
C_save_and_reclaim((void*)f_3227,c,av);}
a=C_alloc((c-3)*C_SIZEOF_PAIR+8);
t3=C_build_rest(&a,c,3,av);
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
t4=C_i_nullp(t3);
t5=(C_truep(t4)?C_SCHEME_FALSE:C_i_car(t3));
t6=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3233,a[2]=((C_word)li24),tmp=(C_word)a,a+=3,tmp);
t7=C_i_check_string_2(t2,lf[73]);
if(C_truep(t5)){
t8=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3256,a[2]=t6,a[3]=t1,a[4]=t2,tmp=(C_word)a,a+=5,tmp);
/* posix-common.scm:435: find-files */
t9=*((C_word*)lf[76]+1);{
C_word *av2;
if(c >= 7) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(7);
}
av2[0]=t9;
av2[1]=t8;
av2[2]=t2;
av2[3]=lf[77];
av2[4]=C_SCHEME_TRUE;
av2[5]=lf[78];
av2[6]=C_SCHEME_FALSE;
((C_proc)(void*)(*((C_word*)t9+1)))(7,av2);}}
else{
/* posix-common.scm:447: rmdir */
f_3233(t1,t2);}}

/* k7813 in terminal-size in k6200 in k6169 in k5687 in k5683 in k5679 in k5675 in k5595 in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_7815(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(13,c,5)))){
C_save_and_reclaim((void *)f_7815,2,av);}
a=C_alloc(13);
t2=C_a_i_bytevector(&a,1,C_fix(1));
t3=C_a_i_bytevector(&a,1,C_fix(1));
t4=C_C_fileno(((C_word*)t0)[2]);
t5=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_7836,a[2]=t4,a[3]=((C_word*)t0)[3],a[4]=t2,a[5]=t3,a[6]=((C_word*)t0)[2],tmp=(C_word)a,a+=7,tmp);
/* posixunix.scm:1526: ##sys#make-locative */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[419]+1));
C_word *av2;
if(c >= 6) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(6);
}
av2[0]=*((C_word*)lf[419]+1);
av2[1]=t5;
av2[2]=t2;
av2[3]=C_fix(0);
av2[4]=C_SCHEME_FALSE;
av2[5]=lf[420];
tp(6,av2);}}

/* ready? in k6397 in k6391 in custom-input-port in k6200 in k6169 in k5687 in k5683 in k5679 in k5675 in k5595 in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_fcall f_6400(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(6,0,2)))){
C_save_and_reclaim_args((void *)trf_6400,2,t0,t1);}
a=C_alloc(6);
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_6404,a[2]=t1,a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],tmp=(C_word)a,a+=6,tmp);
/* posixunix.scm:1129: ##sys#file-select-one */
t3=*((C_word*)lf[144]+1);{
C_word av2[3];
av2[0]=t3;
av2[1]=t2;
av2[2]=((C_word*)t0)[3];
((C_proc)(void*)(*((C_word*)t3+1)))(3,av2);}}

/* terminal-size in k6200 in k6169 in k5687 in k5683 in k5679 in k5675 in k5595 in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_7811(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(4,c,3)))){
C_save_and_reclaim((void *)f_7811,3,av);}
a=C_alloc(4);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_7815,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm:1521: ##sys#terminal-check */
f_7756(t3,lf[416],t2);}

/* k6402 in ready? in k6397 in k6391 in custom-input-port in k6200 in k6169 in k5687 in k5683 in k5679 in k5675 in k5595 in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 in ... */
static void C_ccall f_6404(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,6)))){
C_save_and_reclaim((void *)f_6404,2,av);}
t2=C_eqp(C_fix(-1),t1);
if(C_truep(t2)){
t3=C_eqp(C_fix((C_word)errno),C_fix((C_word)EWOULDBLOCK));
t4=(C_truep(t3)?t3:C_eqp(C_fix((C_word)errno),C_fix((C_word)EAGAIN)));
if(C_truep(t4)){
t5=((C_word*)t0)[2];{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=t5;
av2[1]=C_SCHEME_FALSE;
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}
else{
/* posixunix.scm:1134: posix-error */
t5=lf[0];{
C_word *av2;
if(c >= 7) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(7);
}
av2[0]=t5;
av2[1]=((C_word*)t0)[2];
av2[2]=lf[8];
av2[3]=((C_word*)t0)[3];
av2[4]=lf[347];
av2[5]=((C_word*)t0)[4];
av2[6]=((C_word*)t0)[5];
f_2704(7,av2);}}}
else{
t3=((C_word*)t0)[2];{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=t3;
av2[1]=C_eqp(C_fix(1),t1);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}}

/* get-host-name in k6200 in k6169 in k5687 in k5683 in k5679 in k5675 in k5595 in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_7848(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(C_unlikely(!C_demand(C_calculate_demand(8,c,3)))){
C_save_and_reclaim((void *)f_7848,2,av);}
a=C_alloc(8);
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_7852,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
t3=C_a_i_bytevector(&a,1,C_fix(3));
t4=stub1884(t3);
/* posixunix.scm:1534: ##sys#peek-c-string */
t5=*((C_word*)lf[4]+1);{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=t5;
av2[1]=t2;
av2[2]=t4;
av2[3]=C_fix(0);
((C_proc)(void*)(*((C_word*)t5+1)))(4,av2);}}

/* k4405 in doloop683 in tmp12594 in a4357 in a4336 in k4327 in list->c-string-buffer in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_4407(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,3)))){
C_save_and_reclaim((void *)f_4407,2,av);}
/* posix-common.scm:711: ##sys#make-c-string */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[11]+1));
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[11]+1);
av2[1]=((C_word*)t0)[2];
av2[2]=t1;
av2[3]=((C_word*)t0)[3];
tp(4,av2);}}

/* seconds->string in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_3979(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand((c-2)*C_SIZEOF_PAIR +3,c,2)))){
C_save_and_reclaim((void*)f_3979,c,av);}
a=C_alloc((c-2)*C_SIZEOF_PAIR+3);
t2=C_build_rest(&a,c,2,av);
C_word t3;
C_word t4;
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3983,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
if(C_truep(C_i_nullp(t2))){
/* posix-common.scm:593: current-seconds */
t4=*((C_word*)lf[107]+1);{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=t4;
av2[1]=t3;
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}
else{
t4=t3;{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=t4;
av2[1]=C_i_car(t2);
f_3983(2,av2);}}}

/* k8151 in k8235 in connect-child in k6200 in k6169 in k5687 in k5683 in k5679 in k5675 in k5595 in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_8153(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,2)))){
C_save_and_reclaim((void *)f_8153,2,av);}
/* posixunix.scm:1642: file-close */
t2=*((C_word*)lf[185]+1);{
C_word *av2;
if(c >= 3) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(3);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[2];
av2[2]=((C_word*)t0)[3];
((C_proc)(void*)(*((C_word*)t2+1)))(3,av2);}}

/* f_8159 in make-on-close in k6200 in k6169 in k5687 in k5683 in k5679 in k5675 in k5595 in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_8159(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(C_unlikely(!C_demand(C_calculate_demand(9,c,5)))){
C_save_and_reclaim((void *)f_8159,2,av);}
a=C_alloc(9);
t2=C_i_vector_set(((C_word*)t0)[2],((C_word*)t0)[3],C_SCHEME_TRUE);
t3=C_i_vector_ref(((C_word*)t0)[2],((C_word*)t0)[4]);
t4=(C_truep(t3)?C_i_vector_ref(((C_word*)t0)[2],((C_word*)t0)[5]):C_SCHEME_FALSE);
if(C_truep(t4)){
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_8174,a[2]=((C_word*)t0)[6],a[3]=((C_word)li222),tmp=(C_word)a,a+=4,tmp);
t6=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_8180,a[2]=((C_word*)t0)[7],a[3]=((C_word*)t0)[6],a[4]=((C_word)li223),tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm:1649: ##sys#call-with-values */{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=0;
av2[1]=t1;
av2[2]=t5;
av2[3]=t6;
C_call_with_values(4,av2);}}
else{
t5=C_SCHEME_UNDEFINED;
t6=t1;{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=t6;
av2[1]=t5;
((C_proc)(void*)(*((C_word*)t6+1)))(2,av2);}}}

/* make-on-close in k6200 in k6169 in k5687 in k5683 in k5679 in k5675 in k5595 in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_fcall f_8157(C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6,C_word t7){
C_word tmp;
C_word t8;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(9,0,2)))){
C_save_and_reclaim_args((void *)trf_8157,7,t1,t2,t3,t4,t5,t6,t7);}
a=C_alloc(9);
t8=t1;{
C_word av2[2];
av2[0]=t8;
av2[1]=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_8159,a[2]=t4,a[3]=t5,a[4]=t6,a[5]=t7,a[6]=t3,a[7]=t2,a[8]=((C_word)li224),tmp=(C_word)a,a+=9,tmp);
((C_proc)(void*)(*((C_word*)t8+1)))(2,av2);}}

/* k6965 in loop in poke1594 in k6908 in custom-output-port in k6200 in k6169 in k5687 in k5683 in k5679 in k5675 in k5595 in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 in ... */
static void C_ccall f_6967(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,3)))){
C_save_and_reclaim((void *)f_6967,2,av);}
t2=C_fixnum_difference(((C_word*)t0)[2],((C_word*)t0)[3]);
/* posixunix.scm:1266: poke */
t3=((C_word*)((C_word*)t0)[4])[1];{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=t3;
av2[1]=((C_word*)t0)[5];
av2[2]=t1;
av2[3]=t2;
((C_proc)C_fast_retrieve_proc(t3))(4,av2);}}

/* k6934 in loop in poke1594 in k6908 in custom-output-port in k6200 in k6169 in k5687 in k5683 in k5679 in k5675 in k5595 in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 in ... */
static void C_ccall f_6936(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,3)))){
C_save_and_reclaim((void *)f_6936,2,av);}
/* posixunix.scm:1260: poke */
t2=((C_word*)((C_word*)t0)[2])[1];{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[3];
av2[2]=((C_word*)t0)[4];
av2[3]=((C_word*)t0)[5];
((C_proc)C_fast_retrieve_proc(t2))(4,av2);}}

/* k7891 in process-fork in k6200 in k6169 in k5687 in k5683 in k5679 in k5675 in k5595 in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_7893(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(7,c,3)))){
C_save_and_reclaim((void *)f_7893,2,av);}
a=C_alloc(7);
t2=(C_truep(((C_word*)t0)[2])?C_eqp(((C_word*)t0)[3],C_fix(0)):C_SCHEME_FALSE);
if(C_truep(t2)){
t3=(C_truep(((C_word*)t0)[4])?*((C_word*)lf[424]+1):(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_7915,a[2]=((C_word)li208),tmp=(C_word)a,a+=3,tmp));
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_7907,a[2]=((C_word*)t0)[2],a[3]=((C_word)li209),tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm:1554: g1918 */
t5=t3;{
C_word *av2;
if(c >= 3) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(3);
}
av2[0]=t5;
av2[1]=((C_word*)t0)[5];
av2[2]=t4;
((C_proc)C_fast_retrieve_proc(t5))(3,av2);}}
else{
t3=((C_word*)t0)[5];{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=t3;
av2[1]=((C_word*)t0)[3];
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}}

/* a8173 */
static void C_ccall f_8174(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,3)))){
C_save_and_reclaim((void *)f_8174,2,av);}
/* posixunix.scm:1649: ##sys#process-wait */
t2=*((C_word*)lf[126]+1);{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=t2;
av2[1]=t1;
av2[2]=((C_word*)t0)[2];
av2[3]=C_SCHEME_FALSE;
((C_proc)(void*)(*((C_word*)t2+1)))(4,av2);}}

/* k6691 in a6688 in k6397 in k6391 in custom-input-port in k6200 in k6169 in k5687 in k5683 in k5679 in k5675 in k5595 in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 in ... */
static void C_ccall f_6693(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(8,c,2)))){
C_save_and_reclaim((void *)f_6693,2,av);}
a=C_alloc(8);
if(C_truep(C_fixnum_greater_or_equal_p(((C_word*)((C_word*)t0)[2])[1],((C_word*)((C_word*)t0)[3])[1]))){
t2=((C_word*)t0)[4];{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=t2;
av2[1]=C_SCHEME_END_OF_FILE;
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}
else{
t2=((C_word*)t0)[5];
t3=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_6702,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[6],a[5]=((C_word*)t0)[7],a[6]=((C_word*)t0)[8],a[7]=((C_word*)t0)[4],tmp=(C_word)a,a+=8,tmp);
if(C_truep(t2)){
t4=t3;
f_6702(t4,t2);}
else{
t4=C_fudge(C_fix(21));
t5=t3;
f_6702(t5,C_fixnum_difference(t4,((C_word*)((C_word*)t0)[2])[1]));}}}

/* a6993 in k6975 in k6908 in custom-output-port in k6200 in k6169 in k5687 in k5683 in k5679 in k5675 in k5595 in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_6994(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(C_unlikely(!C_demand(C_calculate_demand(4,c,6)))){
C_save_and_reclaim((void *)f_6994,2,av);}
a=C_alloc(4);
if(C_truep(C_slot(((C_word*)((C_word*)t0)[2])[1],C_fix(8)))){
t2=C_SCHEME_UNDEFINED;
t3=t1;{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=t3;
av2[1]=t2;
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}
else{
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_7004,a[2]=((C_word*)t0)[3],a[3]=t1,tmp=(C_word)a,a+=4,tmp);
t3=C_close(((C_word*)t0)[4]);
if(C_truep(C_fixnum_lessp(t3,C_fix(0)))){
/* posixunix.scm:1297: posix-error */
t4=lf[0];{
C_word *av2;
if(c >= 7) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(7);
}
av2[0]=t4;
av2[1]=t2;
av2[2]=lf[8];
av2[3]=((C_word*)t0)[5];
av2[4]=lf[361];
av2[5]=((C_word*)t0)[4];
av2[6]=((C_word*)t0)[6];
f_2704(7,av2);}}
else{
/* posixunix.scm:1298: on-close */
t4=((C_word*)t0)[3];{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=t4;
av2[1]=t1;
((C_proc)C_fast_retrieve_proc(t4))(2,av2);}}}}

/* k4114 in k4067 in time->string in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_4116(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(5,c,3)))){
C_save_and_reclaim((void *)f_4116,2,av);}
a=C_alloc(5);
t2=((C_word*)t0)[2];
t3=C_a_i_bytevector(&a,1,C_fix(3));
if(C_truep(t1)){
t4=C_i_foreign_block_argumentp(t1);
t5=stub572(t3,t2,t4);
/* posix-common.scm:610: ##sys#peek-c-string */
t6=*((C_word*)lf[4]+1);{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=t6;
av2[1]=((C_word*)t0)[3];
av2[2]=t5;
av2[3]=C_fix(0);
((C_proc)(void*)(*((C_word*)t6+1)))(4,av2);}}
else{
t4=stub572(t3,t2,C_SCHEME_FALSE);
/* posix-common.scm:610: ##sys#peek-c-string */
t5=*((C_word*)lf[4]+1);{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=t5;
av2[1]=((C_word*)t0)[3];
av2[2]=t4;
av2[3]=C_fix(0);
((C_proc)(void*)(*((C_word*)t5+1)))(4,av2);}}}

/* k8108 in k8105 in process-run in k6200 in k6169 in k5687 in k5683 in k5679 in k5675 in k5595 in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_8110(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,3)))){
C_save_and_reclaim((void *)f_8110,2,av);}
a=C_alloc(4);
t2=C_eqp(C_fix(0),t1);
if(C_truep(t2)){
if(C_truep(((C_word*)t0)[2])){
/* posixunix.scm:1613: process-execute */
t3=*((C_word*)lf[427]+1);{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=t3;
av2[1]=((C_word*)t0)[3];
av2[2]=((C_word*)t0)[4];
av2[3]=((C_word*)t0)[2];
((C_proc)(void*)(*((C_word*)t3+1)))(4,av2);}}
else{
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_8129,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm:1615: ##sys#shell-command */
t4=*((C_word*)lf[433]+1);{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=t4;
av2[1]=t3;
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}}
else{
t3=((C_word*)t0)[3];{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=t3;
av2[1]=t1;
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}}

/* terminal-name in k6200 in k6169 in k5687 in k5683 in k5679 in k5675 in k5595 in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_7787(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(4,c,3)))){
C_save_and_reclaim((void *)f_7787,3,av);}
a=C_alloc(4);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_7791,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm:1513: ##sys#terminal-check */
f_7756(t3,lf[415],t2);}

/* toplevel */
static C_TLS int toplevel_initialized=0;

void C_ccall C_posix_toplevel(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(toplevel_initialized) {C_kontinue(t1,C_SCHEME_UNDEFINED);}
else C_toplevel_entry(C_text("posix_toplevel"));
C_check_nursery_minimum(C_calculate_demand(3,c,2));
if(C_unlikely(!C_demand(C_calculate_demand(3,c,2)))){
C_save_and_reclaim((void*)C_posix_toplevel,c,av);}
toplevel_initialized=1;
if(C_unlikely(!C_demand_2(2419))){
C_save(t1);
C_rereclaim2(2419*sizeof(C_word),1);
t1=C_restore;}
a=C_alloc(3);
C_initialize_lf(lf,470);
lf[1]=C_h_intern(&lf[1],15,"\003syssignal-hook");
lf[2]=C_h_intern(&lf[2],13,"string-append");
lf[3]=C_decode_literal(C_heaptop,"\376B\000\000\003 - ");
lf[4]=C_h_intern(&lf[4],17,"\003syspeek-c-string");
lf[5]=C_h_intern(&lf[5],16,"\003sysupdate-errno");
lf[6]=C_h_intern(&lf[6],15,"\003sysposix-error");
lf[8]=C_h_intern(&lf[8],11,"\000file-error");
lf[9]=C_decode_literal(C_heaptop,"\376B\000\000\022cannot access file");
lf[10]=C_h_intern(&lf[10],12,"port->fileno");
lf[11]=C_h_intern(&lf[11],17,"\003sysmake-c-string");
lf[12]=C_h_intern(&lf[12],27,"\003sysplatform-fixup-pathname");
lf[13]=C_h_intern(&lf[13],11,"\000type-error");
lf[14]=C_decode_literal(C_heaptop,"\376B\000\000\052bad argument type - not a fixnum or string");
lf[15]=C_h_intern(&lf[15],5,"port\077");
lf[16]=C_h_intern(&lf[16],9,"file-stat");
lf[17]=C_h_intern(&lf[17],22,"file-modification-time");
lf[18]=C_h_intern(&lf[18],16,"file-access-time");
lf[19]=C_h_intern(&lf[19],16,"file-change-time");
lf[20]=C_h_intern(&lf[20],10,"file-owner");
lf[21]=C_h_intern(&lf[21],16,"file-permissions");
lf[22]=C_h_intern(&lf[22],9,"file-size");
lf[23]=C_h_intern(&lf[23],9,"file-type");
lf[24]=C_h_intern(&lf[24],12,"regular-file");
lf[25]=C_h_intern(&lf[25],13,"symbolic-link");
lf[26]=C_h_intern(&lf[26],9,"directory");
lf[27]=C_h_intern(&lf[27],16,"character-device");
lf[28]=C_h_intern(&lf[28],12,"block-device");
lf[29]=C_h_intern(&lf[29],4,"fifo");
lf[30]=C_h_intern(&lf[30],6,"socket");
lf[31]=C_h_intern(&lf[31],13,"regular-file\077");
lf[32]=C_h_intern(&lf[32],14,"symbolic-link\077");
lf[33]=C_h_intern(&lf[33],13,"block-device\077");
lf[34]=C_h_intern(&lf[34],17,"character-device\077");
lf[35]=C_h_intern(&lf[35],5,"fifo\077");
lf[36]=C_h_intern(&lf[36],7,"socket\077");
lf[37]=C_h_intern(&lf[37],10,"directory\077");
lf[38]=C_h_intern(&lf[38],8,"seek/set");
lf[39]=C_h_intern(&lf[39],8,"seek/end");
lf[40]=C_h_intern(&lf[40],8,"seek/cur");
lf[41]=C_h_intern(&lf[41],18,"set-file-position!");
lf[42]=C_decode_literal(C_heaptop,"\376B\000\000\030cannot set file position");
lf[43]=C_h_intern(&lf[43],6,"stream");
lf[44]=C_decode_literal(C_heaptop,"\376B\000\000\014invalid file");
lf[45]=C_h_intern(&lf[45],13,"file-position");
lf[46]=C_h_intern(&lf[46],12,"fileno/stdin");
lf[47]=C_h_intern(&lf[47],13,"fileno/stdout");
lf[48]=C_h_intern(&lf[48],13,"fileno/stderr");
lf[49]=C_h_intern(&lf[49],7,"\000append");
lf[50]=C_h_intern(&lf[50],9,"\003syserror");
lf[51]=C_decode_literal(C_heaptop,"\376B\000\000\033invalid mode for input file");
lf[52]=C_decode_literal(C_heaptop,"\376B\000\000\001a");
lf[53]=C_decode_literal(C_heaptop,"\376B\000\000\025invalid mode argument");
lf[54]=C_decode_literal(C_heaptop,"\376B\000\000\001r");
lf[55]=C_decode_literal(C_heaptop,"\376B\000\000\001w");
lf[56]=C_decode_literal(C_heaptop,"\376B\000\000\020cannot open file");
lf[57]=C_h_intern(&lf[57],13,"\003sysmake-port");
lf[58]=C_h_intern(&lf[58],21,"\003sysstream-port-class");
lf[59]=C_decode_literal(C_heaptop,"\376B\000\000\010(fdport)");
lf[60]=C_h_intern(&lf[60],16,"open-input-file\052");
lf[61]=C_h_intern(&lf[61],17,"open-output-file\052");
lf[62]=C_h_intern(&lf[62],13,"\003sysport-data");
lf[63]=C_decode_literal(C_heaptop,"\376B\000\000\031port has no attached file");
lf[64]=C_decode_literal(C_heaptop,"\376B\000\000%cannot access file-descriptor of port");
lf[65]=C_h_intern(&lf[65],25,"\003syspeek-unsigned-integer");
lf[66]=C_h_intern(&lf[66],16,"duplicate-fileno");
lf[67]=C_decode_literal(C_heaptop,"\376B\000\000 cannot duplicate file-descriptor");
lf[68]=C_h_intern(&lf[68],17,"current-directory");
lf[69]=C_h_intern(&lf[69],16,"change-directory");
lf[70]=C_h_intern(&lf[70],13,"\003syssubstring");
lf[71]=C_decode_literal(C_heaptop,"\376B\000\000!cannot retrieve current directory");
lf[72]=C_h_intern(&lf[72],15,"\003sysmake-string");
lf[73]=C_h_intern(&lf[73],16,"delete-directory");
lf[74]=C_decode_literal(C_heaptop,"\376B\000\000\027cannot delete directory");
lf[75]=C_h_intern(&lf[75],11,"delete-file");
lf[76]=C_h_intern(&lf[76],10,"find-files");
lf[77]=C_h_intern(&lf[77],9,"\000dotfiles");
lf[78]=C_h_intern(&lf[78],16,"\000follow-symlinks");
lf[79]=C_h_intern(&lf[79],16,"create-directory");
lf[80]=C_decode_literal(C_heaptop,"\376B\000\000\027cannot create directory");
lf[81]=C_h_intern(&lf[81],18,"pathname-directory");
lf[82]=C_h_intern(&lf[82],18,"decompose-pathname");
lf[83]=C_h_intern(&lf[83],13,"make-pathname");
lf[84]=C_h_intern(&lf[84],12,"file-exists\077");
lf[85]=C_decode_literal(C_heaptop,"\376B\000\000\025cannot open directory");
lf[86]=C_h_intern(&lf[86],16,"\003sysmake-pointer");
lf[87]=C_h_intern(&lf[87],4,"glob");
lf[88]=C_h_intern(&lf[88],23,"irregex-match-substring");
lf[89]=C_h_intern(&lf[89],13,"irregex-match");
lf[90]=C_decode_literal(C_heaptop,"\376B\000\000\001.");
lf[91]=C_h_intern(&lf[91],16,"\003sysglob->regexp");
lf[92]=C_decode_literal(C_heaptop,"\376B\000\000\001\052");
lf[93]=C_decode_literal(C_heaptop,"\376B\000\000\001.");
lf[94]=C_decode_literal(C_heaptop,"\376B\000\000\002..");
lf[95]=C_h_intern(&lf[95],16,"\003sysdynamic-wind");
lf[96]=C_h_intern(&lf[96],7,"irregex");
lf[97]=C_h_intern(&lf[97],15,"\003sysget-keyword");
lf[98]=C_h_intern(&lf[98],6,"\000limit");
lf[99]=C_h_intern(&lf[99],5,"\000seed");
lf[100]=C_h_intern(&lf[100],7,"\000action");
lf[101]=C_h_intern(&lf[101],5,"\000test");
lf[102]=C_h_intern(&lf[102],18,"file-creation-mode");
lf[104]=C_decode_literal(C_heaptop,"\376B\000\000\025time vector too short");
lf[105]=C_h_intern(&lf[105],19,"seconds->local-time");
lf[106]=C_h_intern(&lf[106],18,"\003sysdecode-seconds");
lf[107]=C_h_intern(&lf[107],15,"current-seconds");
lf[108]=C_h_intern(&lf[108],17,"seconds->utc-time");
lf[109]=C_h_intern(&lf[109],15,"seconds->string");
lf[110]=C_decode_literal(C_heaptop,"\376B\000\000 cannot convert seconds to string");
lf[111]=C_h_intern(&lf[111],19,"local-time->seconds");
lf[112]=C_decode_literal(C_heaptop,"\376B\000\000%cannot convert time vector to seconds");
lf[113]=C_h_intern(&lf[113],3,"fp=");
lf[114]=C_decode_literal(C_heaptop,"\376U-1.0\000");
lf[115]=C_h_intern(&lf[115],12,"time->string");
lf[116]=C_decode_literal(C_heaptop,"\376B\000\000 time formatting overflows buffer");
lf[117]=C_decode_literal(C_heaptop,"\376B\000\000$cannot convert time vector to string");
lf[118]=C_h_intern(&lf[118],6,"setenv");
lf[119]=C_h_intern(&lf[119],8,"unsetenv");
lf[120]=C_h_intern(&lf[120],25,"get-environment-variables");
lf[121]=C_h_intern(&lf[121],19,"set-signal-handler!");
lf[122]=C_h_intern(&lf[122],17,"\003syssignal-vector");
lf[123]=C_h_intern(&lf[123],14,"signal-handler");
lf[124]=C_h_intern(&lf[124],18,"current-process-id");
lf[125]=C_h_intern(&lf[125],12,"process-wait");
lf[126]=C_h_intern(&lf[126],16,"\003sysprocess-wait");
lf[127]=C_h_intern(&lf[127],14,"\000process-error");
lf[128]=C_decode_literal(C_heaptop,"\376B\000\000 waiting for child process failed");
lf[130]=C_h_intern(&lf[130],6,"signal");
lf[132]=C_h_intern(&lf[132],19,"pointer-vector-set!");
lf[133]=C_h_intern(&lf[133],5,"error");
lf[134]=C_decode_literal(C_heaptop,"\376B\000\000\015Out of memory");
lf[135]=C_h_intern(&lf[135],22,"with-exception-handler");
lf[136]=C_h_intern(&lf[136],30,"call-with-current-continuation");
lf[137]=C_h_intern(&lf[137],19,"make-pointer-vector");
lf[138]=C_h_intern(&lf[138],4,"free");
lf[139]=C_h_intern(&lf[139],18,"pointer-vector-ref");
lf[140]=C_h_intern(&lf[140],21,"pointer-vector-length");
lf[141]=C_h_intern(&lf[141],24,"pathname-strip-directory");
lf[143]=C_h_intern(&lf[143],21,"\003sysfile-nonblocking!");
lf[144]=C_h_intern(&lf[144],19,"\003sysfile-select-one");
lf[145]=C_h_intern(&lf[145],8,"pipe/buf");
lf[146]=C_h_intern(&lf[146],11,"fcntl/dupfd");
lf[147]=C_h_intern(&lf[147],11,"fcntl/getfd");
lf[148]=C_h_intern(&lf[148],11,"fcntl/setfd");
lf[149]=C_h_intern(&lf[149],11,"fcntl/getfl");
lf[150]=C_h_intern(&lf[150],11,"fcntl/setfl");
lf[151]=C_h_intern(&lf[151],11,"open/rdonly");
lf[152]=C_h_intern(&lf[152],11,"open/wronly");
lf[153]=C_h_intern(&lf[153],9,"open/rdwr");
lf[154]=C_h_intern(&lf[154],9,"open/read");
lf[155]=C_h_intern(&lf[155],10,"open/write");
lf[156]=C_h_intern(&lf[156],10,"open/creat");
lf[157]=C_h_intern(&lf[157],11,"open/append");
lf[158]=C_h_intern(&lf[158],9,"open/excl");
lf[159]=C_h_intern(&lf[159],11,"open/noctty");
lf[160]=C_h_intern(&lf[160],13,"open/nonblock");
lf[161]=C_h_intern(&lf[161],10,"open/trunc");
lf[162]=C_h_intern(&lf[162],9,"open/sync");
lf[163]=C_h_intern(&lf[163],10,"open/fsync");
lf[164]=C_h_intern(&lf[164],11,"open/binary");
lf[165]=C_h_intern(&lf[165],9,"open/text");
lf[166]=C_h_intern(&lf[166],10,"perm/irusr");
lf[167]=C_h_intern(&lf[167],10,"perm/iwusr");
lf[168]=C_h_intern(&lf[168],10,"perm/ixusr");
lf[169]=C_h_intern(&lf[169],10,"perm/irgrp");
lf[170]=C_h_intern(&lf[170],10,"perm/iwgrp");
lf[171]=C_h_intern(&lf[171],10,"perm/ixgrp");
lf[172]=C_h_intern(&lf[172],10,"perm/iroth");
lf[173]=C_h_intern(&lf[173],10,"perm/iwoth");
lf[174]=C_h_intern(&lf[174],10,"perm/ixoth");
lf[175]=C_h_intern(&lf[175],10,"perm/irwxu");
lf[176]=C_h_intern(&lf[176],10,"perm/irwxg");
lf[177]=C_h_intern(&lf[177],10,"perm/irwxo");
lf[178]=C_h_intern(&lf[178],10,"perm/isvtx");
lf[179]=C_h_intern(&lf[179],10,"perm/isuid");
lf[180]=C_h_intern(&lf[180],10,"perm/isgid");
lf[181]=C_h_intern(&lf[181],12,"file-control");
lf[182]=C_decode_literal(C_heaptop,"\376B\000\000\023cannot control file");
lf[183]=C_h_intern(&lf[183],9,"file-open");
lf[184]=C_decode_literal(C_heaptop,"\376B\000\000\020cannot open file");
lf[185]=C_h_intern(&lf[185],10,"file-close");
lf[186]=C_h_intern(&lf[186],22,"\003sysdispatch-interrupt");
lf[187]=C_decode_literal(C_heaptop,"\376B\000\000\021cannot close file");
lf[188]=C_h_intern(&lf[188],9,"file-read");
lf[189]=C_decode_literal(C_heaptop,"\376B\000\000\025cannot read from file");
lf[190]=C_decode_literal(C_heaptop,"\376B\000\000(bad argument type - not a string or blob");
lf[191]=C_h_intern(&lf[191],10,"file-write");
lf[192]=C_decode_literal(C_heaptop,"\376B\000\000\024cannot write to file");
lf[193]=C_decode_literal(C_heaptop,"\376B\000\000(bad argument type - not a string or blob");
lf[194]=C_h_intern(&lf[194],12,"file-mkstemp");
lf[195]=C_decode_literal(C_heaptop,"\376B\000\000\034cannot create temporary file");
lf[196]=C_h_intern(&lf[196],11,"file-select");
lf[197]=C_decode_literal(C_heaptop,"\376B\000\000\006failed");
lf[198]=C_h_intern(&lf[198],16,"\003sysfast-reverse");
lf[199]=C_h_intern(&lf[199],3,"max");
lf[200]=C_h_intern(&lf[200],13,"\003sysmake-blob");
lf[201]=C_decode_literal(C_heaptop,"\376B\000\000\037cannot change current directory");
lf[202]=C_h_intern(&lf[202],17,"change-directory\052");
lf[203]=C_decode_literal(C_heaptop,"\376B\000\000\037cannot change current directory");
lf[204]=C_decode_literal(C_heaptop,"\376B\000\000\020cannot open pipe");
lf[205]=C_decode_literal(C_heaptop,"\376B\000\000\006(pipe)");
lf[206]=C_h_intern(&lf[206],15,"open-input-pipe");
lf[207]=C_h_intern(&lf[207],5,"\000text");
lf[208]=C_h_intern(&lf[208],7,"\000binary");
lf[209]=C_decode_literal(C_heaptop,"\376B\000\000#illegal input/output mode specifier");
lf[210]=C_h_intern(&lf[210],16,"open-output-pipe");
lf[211]=C_h_intern(&lf[211],16,"close-input-pipe");
lf[212]=C_decode_literal(C_heaptop,"\376B\000\000\030error while closing pipe");
lf[213]=C_h_intern(&lf[213],17,"close-output-pipe");
lf[214]=C_decode_literal(C_heaptop,"\376B\000\000\030error while closing pipe");
lf[215]=C_h_intern(&lf[215],20,"call-with-input-pipe");
lf[216]=C_h_intern(&lf[216],21,"call-with-output-pipe");
lf[217]=C_h_intern(&lf[217],20,"with-input-from-pipe");
lf[218]=C_h_intern(&lf[218],18,"\003sysstandard-input");
lf[219]=C_h_intern(&lf[219],19,"with-output-to-pipe");
lf[220]=C_h_intern(&lf[220],19,"\003sysstandard-output");
lf[221]=C_h_intern(&lf[221],11,"create-pipe");
lf[222]=C_decode_literal(C_heaptop,"\376B\000\000\022cannot create pipe");
lf[223]=C_h_intern(&lf[223],11,"signal/term");
lf[224]=C_h_intern(&lf[224],11,"signal/kill");
lf[225]=C_h_intern(&lf[225],10,"signal/int");
lf[226]=C_h_intern(&lf[226],10,"signal/hup");
lf[227]=C_h_intern(&lf[227],10,"signal/fpe");
lf[228]=C_h_intern(&lf[228],10,"signal/ill");
lf[229]=C_h_intern(&lf[229],11,"signal/segv");
lf[230]=C_h_intern(&lf[230],11,"signal/abrt");
lf[231]=C_h_intern(&lf[231],11,"signal/trap");
lf[232]=C_h_intern(&lf[232],11,"signal/quit");
lf[233]=C_h_intern(&lf[233],11,"signal/alrm");
lf[234]=C_h_intern(&lf[234],13,"signal/vtalrm");
lf[235]=C_h_intern(&lf[235],11,"signal/prof");
lf[236]=C_h_intern(&lf[236],9,"signal/io");
lf[237]=C_h_intern(&lf[237],10,"signal/urg");
lf[238]=C_h_intern(&lf[238],11,"signal/chld");
lf[239]=C_h_intern(&lf[239],11,"signal/cont");
lf[240]=C_h_intern(&lf[240],11,"signal/stop");
lf[241]=C_h_intern(&lf[241],11,"signal/tstp");
lf[242]=C_h_intern(&lf[242],11,"signal/pipe");
lf[243]=C_h_intern(&lf[243],11,"signal/xcpu");
lf[244]=C_h_intern(&lf[244],11,"signal/xfsz");
lf[245]=C_h_intern(&lf[245],11,"signal/usr1");
lf[246]=C_h_intern(&lf[246],11,"signal/usr2");
lf[247]=C_h_intern(&lf[247],12,"signal/winch");
lf[248]=C_h_intern(&lf[248],10,"signal/bus");
lf[249]=C_h_intern(&lf[249],12,"signal/break");
lf[250]=C_h_intern(&lf[250],12,"signals-list");
lf[251]=C_h_intern(&lf[251],16,"set-signal-mask!");
lf[252]=C_decode_literal(C_heaptop,"\376B\000\000\026cannot set signal mask");
lf[253]=C_h_intern(&lf[253],11,"signal-mask");
lf[254]=C_h_intern(&lf[254],14,"signal-masked\077");
lf[255]=C_h_intern(&lf[255],12,"signal-mask!");
lf[256]=C_decode_literal(C_heaptop,"\376B\000\000\023cannot block signal");
lf[257]=C_h_intern(&lf[257],14,"signal-unmask!");
lf[258]=C_decode_literal(C_heaptop,"\376B\000\000\025cannot unblock signal");
lf[259]=C_h_intern(&lf[259],18,"system-information");
lf[260]=C_h_intern(&lf[260],25,"\003syspeek-nonnull-c-string");
lf[261]=C_decode_literal(C_heaptop,"\376B\000\000\042cannot retrieve system information");
lf[262]=C_h_intern(&lf[262],15,"current-user-id");
lf[263]=C_h_intern(&lf[263],25,"current-effective-user-id");
lf[264]=C_h_intern(&lf[264],16,"current-group-id");
lf[265]=C_h_intern(&lf[265],26,"current-effective-group-id");
lf[266]=C_h_intern(&lf[266],16,"user-information");
lf[267]=C_h_intern(&lf[267],6,"vector");
lf[268]=C_h_intern(&lf[268],4,"list");
lf[269]=C_h_intern(&lf[269],17,"current-user-name");
lf[270]=C_h_intern(&lf[270],27,"current-effective-user-name");
lf[271]=C_h_intern(&lf[271],17,"group-information");
lf[272]=C_h_intern(&lf[272],10,"get-groups");
lf[273]=C_decode_literal(C_heaptop,"\376B\000\000\047cannot retrieve supplementary group ids");
lf[274]=C_decode_literal(C_heaptop,"\376B\000\000\015out of memory");
lf[275]=C_decode_literal(C_heaptop,"\376B\000\000\047cannot retrieve supplementary group ids");
lf[276]=C_h_intern(&lf[276],11,"set-groups!");
lf[277]=C_decode_literal(C_heaptop,"\376B\000\000\042cannot set supplementary group ids");
lf[278]=C_decode_literal(C_heaptop,"\376B\000\000\015out of memory");
lf[279]=C_h_intern(&lf[279],17,"initialize-groups");
lf[280]=C_decode_literal(C_heaptop,"\376B\000\000)cannot initialize supplementary group ids");
lf[281]=C_h_intern(&lf[281],10,"errno/perm");
lf[282]=C_h_intern(&lf[282],11,"errno/noent");
lf[283]=C_h_intern(&lf[283],10,"errno/srch");
lf[284]=C_h_intern(&lf[284],10,"errno/intr");
lf[285]=C_h_intern(&lf[285],8,"errno/io");
lf[286]=C_h_intern(&lf[286],12,"errno/noexec");
lf[287]=C_h_intern(&lf[287],10,"errno/badf");
lf[288]=C_h_intern(&lf[288],11,"errno/child");
lf[289]=C_h_intern(&lf[289],11,"errno/nomem");
lf[290]=C_h_intern(&lf[290],11,"errno/acces");
lf[291]=C_h_intern(&lf[291],11,"errno/fault");
lf[292]=C_h_intern(&lf[292],10,"errno/busy");
lf[293]=C_h_intern(&lf[293],12,"errno/notdir");
lf[294]=C_h_intern(&lf[294],11,"errno/isdir");
lf[295]=C_h_intern(&lf[295],11,"errno/inval");
lf[296]=C_h_intern(&lf[296],11,"errno/mfile");
lf[297]=C_h_intern(&lf[297],11,"errno/nospc");
lf[298]=C_h_intern(&lf[298],11,"errno/spipe");
lf[299]=C_h_intern(&lf[299],10,"errno/pipe");
lf[300]=C_h_intern(&lf[300],11,"errno/again");
lf[301]=C_h_intern(&lf[301],10,"errno/rofs");
lf[302]=C_h_intern(&lf[302],11,"errno/exist");
lf[303]=C_h_intern(&lf[303],16,"errno/wouldblock");
lf[304]=C_h_intern(&lf[304],10,"errno/2big");
lf[305]=C_h_intern(&lf[305],12,"errno/deadlk");
lf[306]=C_h_intern(&lf[306],9,"errno/dom");
lf[307]=C_h_intern(&lf[307],10,"errno/fbig");
lf[308]=C_h_intern(&lf[308],11,"errno/ilseq");
lf[309]=C_h_intern(&lf[309],11,"errno/mlink");
lf[310]=C_h_intern(&lf[310],17,"errno/nametoolong");
lf[311]=C_h_intern(&lf[311],11,"errno/nfile");
lf[312]=C_h_intern(&lf[312],11,"errno/nodev");
lf[313]=C_h_intern(&lf[313],11,"errno/nolck");
lf[314]=C_h_intern(&lf[314],11,"errno/nosys");
lf[315]=C_h_intern(&lf[315],14,"errno/notempty");
lf[316]=C_h_intern(&lf[316],11,"errno/notty");
lf[317]=C_h_intern(&lf[317],10,"errno/nxio");
lf[318]=C_h_intern(&lf[318],11,"errno/range");
lf[319]=C_h_intern(&lf[319],10,"errno/xdev");
lf[320]=C_h_intern(&lf[320],16,"change-file-mode");
lf[321]=C_decode_literal(C_heaptop,"\376B\000\000\027cannot change file mode");
lf[322]=C_h_intern(&lf[322],17,"change-file-owner");
lf[323]=C_decode_literal(C_heaptop,"\376B\000\000\030cannot change file owner");
lf[324]=C_h_intern(&lf[324],17,"file-read-access\077");
lf[325]=C_h_intern(&lf[325],18,"file-write-access\077");
lf[326]=C_h_intern(&lf[326],20,"file-execute-access\077");
lf[327]=C_h_intern(&lf[327],14,"create-session");
lf[328]=C_decode_literal(C_heaptop,"\376B\000\000\025cannot create session");
lf[329]=C_h_intern(&lf[329],16,"process-group-id");
lf[330]=C_h_intern(&lf[330],20,"create-symbolic-link");
lf[331]=C_h_intern(&lf[331],18,"create-symbol-link");
lf[332]=C_decode_literal(C_heaptop,"\376B\000\000\033cannot create symbolic link");
lf[333]=C_h_intern(&lf[333],22,"\003sysread-symbolic-link");
lf[334]=C_decode_literal(C_heaptop,"\376B\000\000\031cannot read symbolic link");
lf[335]=C_h_intern(&lf[335],9,"substring");
lf[336]=C_h_intern(&lf[336],18,"read-symbolic-link");
lf[337]=C_h_intern(&lf[337],19,"decompose-directory");
lf[338]=C_h_intern(&lf[338],18,"absolute-pathname\077");
lf[339]=C_decode_literal(C_heaptop,"\376B\000\000Icould not canonicalize path with symbolic links, component does not exist");
lf[340]=C_decode_literal(C_heaptop,"\376B\000\000\000");
lf[341]=C_decode_literal(C_heaptop,"\376B\000\000\000");
lf[342]=C_h_intern(&lf[342],9,"file-link");
lf[343]=C_h_intern(&lf[343],9,"hard-link");
lf[344]=C_decode_literal(C_heaptop,"\376B\000\000\032could not create hard link");
lf[345]=C_h_intern(&lf[345],21,"\003syscustom-input-port");
lf[346]=C_h_intern(&lf[346],4,"void");
lf[347]=C_decode_literal(C_heaptop,"\376B\000\000\015cannot select");
lf[348]=C_h_intern(&lf[348],17,"\003systhread-yield!");
lf[349]=C_h_intern(&lf[349],25,"\003systhread-block-for-i/o!");
lf[350]=C_h_intern(&lf[350],18,"\003syscurrent-thread");
lf[351]=C_h_intern(&lf[351],6,"\000input");
lf[352]=C_decode_literal(C_heaptop,"\376B\000\000\013cannot read");
lf[353]=C_decode_literal(C_heaptop,"\376B\000\000\013cannot read");
lf[354]=C_h_intern(&lf[354],14,"set-port-name!");
lf[355]=C_decode_literal(C_heaptop,"\376B\000\000\014cannot close");
lf[356]=C_h_intern(&lf[356],20,"\003sysscan-buffer-line");
lf[357]=C_decode_literal(C_heaptop,"\376B\000\000\000");
lf[358]=C_h_intern(&lf[358],15,"make-input-port");
lf[359]=C_h_intern(&lf[359],22,"\003syscustom-output-port");
lf[360]=C_decode_literal(C_heaptop,"\376B\000\000\014cannot write");
lf[361]=C_decode_literal(C_heaptop,"\376B\000\000\014cannot close");
lf[362]=C_h_intern(&lf[362],16,"make-output-port");
lf[363]=C_h_intern(&lf[363],13,"file-truncate");
lf[364]=C_decode_literal(C_heaptop,"\376B\000\000\024cannot truncate file");
lf[365]=C_decode_literal(C_heaptop,"\376B\000\000\014invalid file");
lf[366]=C_h_intern(&lf[366],4,"lock");
lf[367]=C_h_intern(&lf[367],9,"file-lock");
lf[368]=C_decode_literal(C_heaptop,"\376B\000\000\020cannot lock file");
lf[369]=C_h_intern(&lf[369],18,"file-lock/blocking");
lf[370]=C_decode_literal(C_heaptop,"\376B\000\000\020cannot lock file");
lf[371]=C_h_intern(&lf[371],14,"file-test-lock");
lf[372]=C_decode_literal(C_heaptop,"\376B\000\000\022cannot unlock file");
lf[373]=C_h_intern(&lf[373],11,"file-unlock");
lf[374]=C_decode_literal(C_heaptop,"\376B\000\000\022cannot unlock file");
lf[375]=C_h_intern(&lf[375],11,"create-fifo");
lf[376]=C_decode_literal(C_heaptop,"\376B\000\000\022cannot create FIFO");
lf[377]=C_decode_literal(C_heaptop,"\376B\000\000\023file does not exist");
lf[378]=C_decode_literal(C_heaptop,"\376B\000\000(system error while trying to access file");
lf[379]=C_h_intern(&lf[379],9,"prot/read");
lf[380]=C_h_intern(&lf[380],10,"prot/write");
lf[381]=C_h_intern(&lf[381],9,"prot/exec");
lf[382]=C_h_intern(&lf[382],9,"prot/none");
lf[383]=C_h_intern(&lf[383],9,"map/fixed");
lf[384]=C_h_intern(&lf[384],10,"map/shared");
lf[385]=C_h_intern(&lf[385],11,"map/private");
lf[386]=C_h_intern(&lf[386],13,"map/anonymous");
lf[387]=C_h_intern(&lf[387],8,"map/file");
lf[388]=C_h_intern(&lf[388],18,"map-file-to-memory");
lf[389]=C_h_intern(&lf[389],4,"mmap");
lf[390]=C_decode_literal(C_heaptop,"\376B\000\000\031cannot map file to memory");
lf[391]=C_h_intern(&lf[391],20,"\003syspointer->address");
lf[392]=C_decode_literal(C_heaptop,"\376B\000\000)bad argument type - not a foreign pointer");
lf[393]=C_h_intern(&lf[393],16,"\003sysnull-pointer");
lf[394]=C_h_intern(&lf[394],22,"unmap-file-from-memory");
lf[395]=C_decode_literal(C_heaptop,"\376B\000\000\035cannot unmap file from memory");
lf[396]=C_h_intern(&lf[396],26,"memory-mapped-file-pointer");
lf[397]=C_h_intern(&lf[397],19,"memory-mapped-file\077");
lf[398]=C_h_intern(&lf[398],12,"string->time");
lf[399]=C_decode_literal(C_heaptop,"\376B\000\000\027%a %b %e %H:%M:%S %Z %Y");
lf[400]=C_h_intern(&lf[400],17,"utc-time->seconds");
lf[401]=C_decode_literal(C_heaptop,"\376B\000\000%cannot convert time vector to seconds");
lf[402]=C_h_intern(&lf[402],27,"local-timezone-abbreviation");
lf[403]=C_h_intern(&lf[403],5,"_exit");
lf[404]=C_h_intern(&lf[404],10,"set-alarm!");
lf[405]=C_h_intern(&lf[405],19,"set-buffering-mode!");
lf[406]=C_decode_literal(C_heaptop,"\376B\000\000\031cannot set buffering mode");
lf[407]=C_h_intern(&lf[407],5,"\000full");
lf[408]=C_h_intern(&lf[408],5,"\000line");
lf[409]=C_h_intern(&lf[409],5,"\000none");
lf[410]=C_decode_literal(C_heaptop,"\376B\000\000\026invalid buffering-mode");
lf[411]=C_h_intern(&lf[411],14,"\003syscheck-port");
lf[412]=C_h_intern(&lf[412],14,"terminal-port\077");
lf[414]=C_decode_literal(C_heaptop,"\376B\000\000#port is not connected to a terminal");
lf[415]=C_h_intern(&lf[415],13,"terminal-name");
lf[416]=C_h_intern(&lf[416],13,"terminal-size");
lf[417]=C_h_intern(&lf[417],6,"\000error");
lf[418]=C_decode_literal(C_heaptop,"\376B\000\000\036Unable to get size of terminal");
lf[419]=C_h_intern(&lf[419],17,"\003sysmake-locative");
lf[420]=C_h_intern(&lf[420],8,"location");
lf[421]=C_h_intern(&lf[421],13,"get-host-name");
lf[422]=C_decode_literal(C_heaptop,"\376B\000\000\031cannot retrieve host-name");
lf[423]=C_h_intern(&lf[423],12,"process-fork");
lf[424]=C_h_intern(&lf[424],22,"\003syskill-other-threads");
lf[425]=C_h_intern(&lf[425],4,"exit");
lf[426]=C_decode_literal(C_heaptop,"\376B\000\000\033cannot create child process");
lf[427]=C_h_intern(&lf[427],15,"process-execute");
lf[428]=C_decode_literal(C_heaptop,"\376B\000\000\026cannot execute process");
lf[429]=C_h_intern(&lf[429],17,"parent-process-id");
lf[430]=C_h_intern(&lf[430],5,"sleep");
lf[431]=C_h_intern(&lf[431],14,"process-signal");
lf[432]=C_decode_literal(C_heaptop,"\376B\000\000 could not send signal to process");
lf[433]=C_h_intern(&lf[433],17,"\003sysshell-command");
lf[434]=C_decode_literal(C_heaptop,"\376B\000\000\007/bin/sh");
lf[435]=C_h_intern(&lf[435],24,"get-environment-variable");
lf[436]=C_decode_literal(C_heaptop,"\376B\000\000\005SHELL");
lf[437]=C_h_intern(&lf[437],27,"\003sysshell-command-arguments");
lf[438]=C_decode_literal(C_heaptop,"\376B\000\000\002-c");
lf[439]=C_h_intern(&lf[439],11,"process-run");
lf[440]=C_decode_literal(C_heaptop,"\376B\000\000\025abnormal process exit");
lf[441]=C_h_intern(&lf[441],11,"\003sysprocess");
lf[442]=C_h_intern(&lf[442],7,"process");
lf[443]=C_h_intern(&lf[443],8,"process\052");
lf[444]=C_h_intern(&lf[444],6,"values");
lf[445]=C_h_intern(&lf[445],19,"set-root-directory!");
lf[446]=C_decode_literal(C_heaptop,"\376B\000\000\037unable to change root directory");
lf[447]=C_decode_literal(C_heaptop,"\376B\000\000 cannot retrieve process group ID");
lf[448]=C_h_intern(&lf[448],21,"set-process-group-id!");
lf[449]=C_decode_literal(C_heaptop,"\376B\000\000\033cannot set process group ID");
lf[450]=C_h_intern(&lf[450],18,"getter-with-setter");
lf[451]=C_decode_literal(C_heaptop,"\376B\000\000\026(process-group-id pid)");
lf[452]=C_h_intern(&lf[452],26,"effective-group-id!-setter");
lf[453]=C_decode_literal(C_heaptop,"\376B\000\000\035cannot set effective group ID");
lf[454]=C_decode_literal(C_heaptop,"\376B\000\000\034(current-effective-group-id)");
lf[455]=C_h_intern(&lf[455],12,"set-user-id!");
lf[456]=C_decode_literal(C_heaptop,"\376B\000\000\023cannot set group ID");
lf[457]=C_decode_literal(C_heaptop,"\376B\000\000\022(current-group-id)");
lf[458]=C_h_intern(&lf[458],25,"effective-user-id!-setter");
lf[459]=C_decode_literal(C_heaptop,"\376B\000\000\034cannot set effective user ID");
lf[460]=C_decode_literal(C_heaptop,"\376B\000\000\033(current-effective-used-id)");
lf[461]=C_decode_literal(C_heaptop,"\376B\000\000\022cannot set user ID");
lf[462]=C_decode_literal(C_heaptop,"\376B\000\000\021(current-user-id)");
lf[463]=C_decode_literal(C_heaptop,"\376B\000\000\031(file-creation-mode mode)");
lf[464]=C_decode_literal(C_heaptop,"\376B\000\000%cannot retrieve file position of port");
lf[465]=C_decode_literal(C_heaptop,"\376B\000\000\014invalid file");
lf[466]=C_decode_literal(C_heaptop,"\376B\000\000\024(file-position port)");
lf[467]=C_h_intern(&lf[467],26,"set-file-modification-time");
lf[468]=C_decode_literal(C_heaptop,"\376B\000\000!cannot set file modification-time");
lf[469]=C_decode_literal(C_heaptop,"\376B\000\000\032(file-modification-time f)");
C_register_lf2(lf,470,create_ptable());{}
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2677,a[2]=t1,tmp=(C_word)a,a+=3,tmp);{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=C_SCHEME_UNDEFINED;
av2[1]=t2;
C_scheduler_toplevel(2,av2);}}

/* k7482 in k7476 in k7473 in k7470 in map-file-to-memory in k6200 in k6169 in k5687 in k5683 in k5679 in k5675 in k5595 in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 in ... */
static void C_ccall f_7484(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,1)))){
C_save_and_reclaim((void *)f_7484,2,av);}
a=C_alloc(4);
t2=((C_word*)t0)[2];{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=t2;
av2[1]=C_a_i_record3(&a,3,lf[389],((C_word*)t0)[3],((C_word*)t0)[4]);
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* process-run in k6200 in k6169 in k5687 in k5683 in k5679 in k5675 in k5595 in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_8103(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand((c-3)*C_SIZEOF_PAIR +4,c,2)))){
C_save_and_reclaim((void*)f_8103,c,av);}
a=C_alloc((c-3)*C_SIZEOF_PAIR+4);
t3=C_build_rest(&a,c,3,av);
C_word t4;
C_word t5;
C_word t6;
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_8107,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
if(C_truep(C_i_pairp(t3))){
t5=t3;
t6=t4;
f_8107(t6,C_u_i_car(t5));}
else{
t5=t4;
f_8107(t5,C_SCHEME_FALSE);}}

/* k8105 in process-run in k6200 in k6169 in k5687 in k5683 in k5679 in k5675 in k5595 in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_fcall f_8107(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(5,0,2)))){
C_save_and_reclaim_args((void *)trf_8107,2,t0,t1);}
a=C_alloc(5);
t2=t1;
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_8110,a[2]=t2,a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm:1611: process-fork */
t4=*((C_word*)lf[423]+1);{
C_word av2[2];
av2[0]=t4;
av2[1]=t3;
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* k6975 in k6908 in custom-output-port in k6200 in k6169 in k5687 in k5683 in k5679 in k5675 in k5595 in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_fcall f_6977(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(23,0,4)))){
C_save_and_reclaim_args((void *)trf_6977,2,t0,t1);}
a=C_alloc(23);
t2=C_mutate2(((C_word *)((C_word*)t0)[2])+1,((C_word*)t0)[3]);
t3=C_mutate2(((C_word *)((C_word*)t0)[4])+1,t1);
t4=C_SCHEME_UNDEFINED;
t5=(*a=C_VECTOR_TYPE|1,a[1]=t4,tmp=(C_word)a,a+=2,tmp);
t6=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_6982,a[2]=t5,a[3]=((C_word*)t0)[5],a[4]=((C_word*)t0)[6],tmp=(C_word)a,a+=5,tmp);
t7=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_6988,a[2]=((C_word*)t0)[4],a[3]=((C_word)li177),tmp=(C_word)a,a+=4,tmp);
t8=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_6994,a[2]=t5,a[3]=((C_word*)t0)[7],a[4]=((C_word*)t0)[8],a[5]=((C_word*)t0)[9],a[6]=((C_word*)t0)[6],a[7]=((C_word)li178),tmp=(C_word)a,a+=8,tmp);
t9=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_7016,a[2]=((C_word*)t0)[4],a[3]=((C_word)li179),tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm:1291: make-output-port */
t10=*((C_word*)lf[362]+1);{
C_word av2[5];
av2[0]=t10;
av2[1]=t6;
av2[2]=t7;
av2[3]=t8;
av2[4]=t9;
((C_proc)(void*)(*((C_word*)t10+1)))(5,av2);}}

/* a6688 in k6397 in k6391 in custom-input-port in k6200 in k6169 in k5687 in k5683 in k5679 in k5675 in k5595 in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_6689(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word t5;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(9,c,2)))){
C_save_and_reclaim((void *)f_6689,4,av);}
a=C_alloc(9);
t4=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_6693,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t1,a[5]=t3,a[6]=((C_word*)t0)[4],a[7]=((C_word*)t0)[5],a[8]=t2,tmp=(C_word)a,a+=9,tmp);
if(C_truep(C_fixnum_greater_or_equal_p(((C_word*)((C_word*)t0)[2])[1],((C_word*)((C_word*)t0)[3])[1]))){
/* posixunix.scm:1209: fetch */
t5=((C_word*)t0)[5];
f_6437(t5,t4);}
else{
t5=t4;{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=t5;
av2[1]=C_SCHEME_UNDEFINED;
f_6693(2,av2);}}}

/* k7495 in k7476 in k7473 in k7470 in map-file-to-memory in k6200 in k6169 in k5687 in k5683 in k5679 in k5675 in k5595 in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 in ... */
static void C_ccall f_7497(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,10)))){
C_save_and_reclaim((void *)f_7497,2,av);}
a=C_alloc(4);
t2=C_eqp(C_fix(-1),t1);
if(C_truep(t2)){
/* posixunix.scm:1420: posix-error */
t3=lf[0];{
C_word *av2;
if(c >= 11) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(11);
}
av2[0]=t3;
av2[1]=((C_word*)t0)[2];
av2[2]=lf[8];
av2[3]=lf[388];
av2[4]=lf[390];
av2[5]=((C_word*)t0)[3];
av2[6]=((C_word*)t0)[4];
av2[7]=((C_word*)t0)[5];
av2[8]=((C_word*)t0)[6];
av2[9]=((C_word*)t0)[7];
av2[10]=((C_word*)t0)[8];
f_2704(11,av2);}}
else{
t3=((C_word*)t0)[9];{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=t3;
av2[1]=C_a_i_record3(&a,3,lf[389],((C_word*)t0)[10],((C_word*)t0)[4]);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}}

/* seconds->utc-time in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_3948(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand((c-2)*C_SIZEOF_PAIR +3,c,3)))){
C_save_and_reclaim((void*)f_3948,c,av);}
a=C_alloc((c-2)*C_SIZEOF_PAIR+3);
t2=C_build_rest(&a,c,2,av);
C_word t3;
C_word t4;
C_word t5;
C_word t6;
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3952,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
if(C_truep(C_i_nullp(t2))){
/* posix-common.scm:587: current-seconds */
t4=*((C_word*)lf[107]+1);{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=t4;
av2[1]=t3;
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}
else{
t4=C_i_car(t2);
t5=C_i_check_number_2(t4,lf[108]);
/* posix-common.scm:589: ##sys#decode-seconds */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[106]+1));
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[106]+1);
av2[1]=t1;
av2[2]=t4;
av2[3]=C_SCHEME_TRUE;
tp(4,av2);}}}

/* k6980 in k6975 in k6908 in custom-output-port in k6200 in k6169 in k5687 in k5683 in k5679 in k5675 in k5595 in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_6982(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,3)))){
C_save_and_reclaim((void *)f_6982,2,av);}
a=C_alloc(4);
t2=C_mutate2(((C_word *)((C_word*)t0)[2])+1,t1);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_6986,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm:1301: set-port-name! */
t4=*((C_word*)lf[354]+1);{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=t4;
av2[1]=t3;
av2[2]=((C_word*)((C_word*)t0)[2])[1];
av2[3]=((C_word*)t0)[4];
((C_proc)(void*)(*((C_word*)t4+1)))(4,av2);}}

/* a6987 in k6975 in k6908 in custom-output-port in k6200 in k6169 in k5687 in k5683 in k5679 in k5675 in k5595 in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_6988(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,2)))){
C_save_and_reclaim((void *)f_6988,3,av);}
/* posixunix.scm:1293: store */
t3=((C_word*)((C_word*)t0)[2])[1];{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=t3;
av2[1]=t1;
av2[2]=t2;
((C_proc)C_fast_retrieve_proc(t3))(3,av2);}}

/* k6984 in k6980 in k6975 in k6908 in custom-output-port in k6200 in k6169 in k5687 in k5683 in k5679 in k5675 in k5595 in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 in ... */
static void C_ccall f_6986(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_6986,2,av);}
t2=((C_word*)t0)[2];{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=t2;
av2[1]=((C_word*)((C_word*)t0)[3])[1];
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* k6112 in change-file-owner in k5687 in k5683 in k5679 in k5675 in k5595 in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_6114(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,7)))){
C_save_and_reclaim((void *)f_6114,2,av);}
t2=C_chown(t1,((C_word*)t0)[2],((C_word*)t0)[3]);
if(C_truep(C_fixnum_lessp(t2,C_fix(0)))){
/* posixunix.scm:1025: posix-error */
t3=lf[0];{
C_word *av2;
if(c >= 8) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(8);
}
av2[0]=t3;
av2[1]=((C_word*)t0)[4];
av2[2]=lf[8];
av2[3]=lf[322];
av2[4]=lf[323];
av2[5]=((C_word*)t0)[5];
av2[6]=((C_word*)t0)[2];
av2[7]=((C_word*)t0)[3];
f_2704(8,av2);}}
else{
t3=C_SCHEME_UNDEFINED;
t4=((C_word*)t0)[4];{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=t4;
av2[1]=t3;
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}}

/* check in k5687 in k5683 in k5679 in k5675 in k5595 in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_fcall f_6116(C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,0,3)))){
C_save_and_reclaim_args((void *)trf_6116,4,t1,t2,t3,t4);}
a=C_alloc(4);
t5=C_i_check_string_2(t2,t4);
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_6134,a[2]=t3,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm:1034: ##sys#make-c-string */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[11]+1));
C_word av2[4];
av2[0]=*((C_word*)lf[11]+1);
av2[1]=t6;
av2[2]=t2;
av2[3]=t4;
tp(4,av2);}}

/* k4195 in k4207 in k4203 in scan in k4169 in loop in get-environment-variables in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_4197(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(3,c,1)))){
C_save_and_reclaim((void *)f_4197,2,av);}
a=C_alloc(3);
t2=((C_word*)t0)[2];{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=t2;
av2[1]=C_a_i_cons(&a,2,((C_word*)t0)[3],t1);
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* needed-pipe in k6200 in k6169 in k5687 in k5683 in k5679 in k5675 in k5595 in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_fcall f_8194(C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(6,0,4)))){
C_save_and_reclaim_args((void *)trf_8194,2,t1,t2);}
a=C_alloc(6);
if(C_truep(t2)){
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_8203,a[2]=((C_word)li226),tmp=(C_word)a,a+=3,tmp);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_8209,a[2]=((C_word)li227),tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm:1654: ##sys#call-with-values */{
C_word av2[4];
av2[0]=0;
av2[1]=t1;
av2[2]=t3;
av2[3]=t4;
C_call_with_values(4,av2);}}
else{
t3=t1;{
C_word av2[2];
av2[0]=t3;
av2[1]=C_SCHEME_FALSE;
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}}

/* k5287 in open-input-pipe in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_5289(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,5)))){
C_save_and_reclaim((void *)f_5289,2,av);}
/* posixunix.scm:617: check */
f_5260(((C_word*)t0)[3],lf[206],((C_word*)t0)[4],C_SCHEME_TRUE,t1);}

/* open-input-pipe in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_5275(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand((c-3)*C_SIZEOF_PAIR +10,c,3)))){
C_save_and_reclaim((void*)f_5275,c,av);}
a=C_alloc((c-3)*C_SIZEOF_PAIR+10);
t3=C_build_rest(&a,c,3,av);
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
t4=C_i_check_string_2(t2,lf[206]);
t5=C_i_pairp(t3);
t6=(C_truep(t5)?C_slot(t3,C_fix(0)):lf[207]);
t7=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_5289,a[2]=((C_word*)t0)[2],a[3]=t1,a[4]=t2,tmp=(C_word)a,a+=5,tmp);
t8=C_eqp(t6,lf[207]);
if(C_truep(t8)){
t9=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_5296,a[2]=((C_word*)t0)[2],a[3]=t1,a[4]=t2,tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm:621: ##sys#make-c-string */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[11]+1));
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[11]+1);
av2[1]=t9;
av2[2]=t2;
av2[3]=lf[206];
tp(4,av2);}}
else{
t9=C_eqp(t6,lf[208]);
if(C_truep(t9)){
t10=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_5306,a[2]=((C_word*)t0)[2],a[3]=t1,a[4]=t2,tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm:622: ##sys#make-c-string */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[11]+1));
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[11]+1);
av2[1]=t10;
av2[2]=t2;
av2[3]=lf[206];
tp(4,av2);}}
else{
/* posixunix.scm:606: ##sys#error */
t10=*((C_word*)lf[50]+1);{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=t10;
av2[1]=t7;
av2[2]=lf[209];
av2[3]=t6;
((C_proc)(void*)(*((C_word*)t10+1)))(4,av2);}}}}

/* k5271 in check in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_5273(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_5273,2,av);}
t2=C_set_file_ptr(t1,((C_word*)t0)[2]);
t3=t1;
t4=((C_word*)t0)[3];{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=t4;
av2[1]=t3;
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* k6124 in k6132 in check in k5687 in k5683 in k5679 in k5675 in k5595 in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_6126(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_6126,2,av);}
t2=((C_word*)t0)[2];{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=t2;
av2[1]=((C_word*)t0)[3];
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* get-environment-variables in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_4161(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(C_unlikely(!C_demand(C_calculate_demand(6,c,3)))){
C_save_and_reclaim((void *)f_4161,2,av);}
a=C_alloc(6);
t2=C_SCHEME_UNDEFINED;
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=C_set_block_item(t3,0,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4167,a[2]=t3,a[3]=((C_word)li65),tmp=(C_word)a,a+=4,tmp));
t5=((C_word*)t3)[1];
f_4167(t5,t1,C_fix(0));}

/* a8179 */
static void C_ccall f_8180(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4=av[4];
C_word t5;
C_word t6;
C_word *a;
if(c!=5) C_bad_argc_2(c,5,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,6)))){
C_save_and_reclaim((void *)f_8180,5,av);}
if(C_truep(t3)){
t5=C_SCHEME_UNDEFINED;
t6=t1;{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=t6;
av2[1]=t5;
((C_proc)(void*)(*((C_word*)t6+1)))(2,av2);}}
else{
/* posixunix.scm:1651: ##sys#signal-hook */
t5=*((C_word*)lf[1]+1);{
C_word *av2;
if(c >= 7) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(7);
}
av2[0]=t5;
av2[1]=t1;
av2[2]=lf[127];
av2[3]=((C_word*)t0)[2];
av2[4]=lf[440];
av2[5]=((C_word*)t0)[3];
av2[6]=t4;
((C_proc)(void*)(*((C_word*)t5+1)))(7,av2);}}}

/* loop in get-environment-variables in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_fcall f_4167(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(10,0,3)))){
C_save_and_reclaim_args((void *)trf_4167,3,t0,t1,t2);}
a=C_alloc(10);
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4171,a[2]=t2,a[3]=((C_word*)t0)[2],a[4]=t1,tmp=(C_word)a,a+=5,tmp);
t4=t2;
t5=C_a_i_bytevector(&a,1,C_fix(3));
t6=C_i_foreign_fixnum_argumentp(t4);
t7=stub621(t5,t6);
/* posix-common.scm:641: ##sys#peek-c-string */
t8=*((C_word*)lf[4]+1);{
C_word av2[4];
av2[0]=t8;
av2[1]=t3;
av2[2]=t7;
av2[3]=C_fix(0);
((C_proc)(void*)(*((C_word*)t8+1)))(4,av2);}}

/* k4169 in loop in get-environment-variables in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_4171(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(9,c,3)))){
C_save_and_reclaim((void *)f_4171,2,av);}
a=C_alloc(9);
t2=t1;
if(C_truep(t2)){
t3=C_SCHEME_UNDEFINED;
t4=(*a=C_VECTOR_TYPE|1,a[1]=t3,tmp=(C_word)a,a+=2,tmp);
t5=C_set_block_item(t4,0,(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_4179,a[2]=t2,a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],a[5]=t4,a[6]=((C_word)li64),tmp=(C_word)a,a+=7,tmp));
t6=((C_word*)t4)[1];
f_4179(t6,((C_word*)t0)[4],C_fix(0));}
else{
t3=((C_word*)t0)[4];{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=t3;
av2[1]=C_SCHEME_END_OF_LIST;
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}}

/* scan in k4169 in loop in get-environment-variables in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_fcall f_4179(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
loop:
if(C_unlikely(!C_demand(C_calculate_demand(7,0,4)))){
C_save_and_reclaim_args((void *)trf_4179,3,t0,t1,t2);}
a=C_alloc(7);
t3=C_subchar(((C_word*)t0)[2],t2);
if(C_truep(C_i_char_equalp(C_make_character(61),t3))){
t4=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_4205,a[2]=t1,a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=t2,a[6]=((C_word*)t0)[2],tmp=(C_word)a,a+=7,tmp);
/* posix-common.scm:648: ##sys#substring */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[70]+1));
C_word av2[5];
av2[0]=*((C_word*)lf[70]+1);
av2[1]=t4;
av2[2]=((C_word*)t0)[2];
av2[3]=C_fix(0);
av2[4]=t2;
tp(5,av2);}}
else{
t4=C_fixnum_plus(t2,C_fix(1));
/* posix-common.scm:651: scan */
t6=t1;
t7=t4;
t1=t6;
t2=t7;
goto loop;}}

/* unsetenv in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_4141(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(3,c,3)))){
C_save_and_reclaim((void *)f_4141,3,av);}
a=C_alloc(3);
t3=C_i_check_string_2(t2,lf[119]);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4149,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posix-common.scm:637: ##sys#make-c-string */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[11]+1));
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[11]+1);
av2[1]=t4;
av2[2]=t2;
av2[3]=lf[119];
tp(4,av2);}}

/* k4147 in unsetenv in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_4149(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_4149,2,av);}
t2=C_unsetenv(t1);
t3=((C_word*)t0)[2];{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=t3;
av2[1]=C_SCHEME_UNDEFINED;
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* create-session in k5687 in k5683 in k5679 in k5675 in k5595 in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_6154(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(C_unlikely(!C_demand(C_calculate_demand(7,c,2)))){
C_save_and_reclaim((void *)f_6154,2,av);}
a=C_alloc(7);
t2=C_setsid(C_SCHEME_FALSE);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_6158,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
if(C_truep(C_fixnum_lessp(t2,C_fix(0)))){
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6164,a[2]=t3,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm:1044: ##sys#update-errno */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[5]+1));
C_word *av2=av; /* Re-use our own argvector */
av2[0]=*((C_word*)lf[5]+1);
av2[1]=t4;
tp(2,av2);}}
else{
t4=t1;{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=t4;
av2[1]=t2;
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}}

/* k6156 in create-session in k5687 in k5683 in k5679 in k5675 in k5595 in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_6158(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_6158,2,av);}
t2=((C_word*)t0)[2];{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=t2;
av2[1]=((C_word*)t0)[3];
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* a5441 in k5435 in with-input-from-pipe in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_5442(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_5442,2,av);}
t2=C_mutate2(((C_word *)((C_word*)t0)[2])+1,*((C_word*)lf[218]+1));
t3=C_mutate2((C_word*)lf[218]+1 /* (set! ##sys#standard-input ...) */,((C_word*)((C_word*)t0)[3])[1]);
t4=t1;{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=t4;
av2[1]=C_SCHEME_UNDEFINED;
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* a5446 in k5435 in with-input-from-pipe in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_5447(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(C_unlikely(!C_demand(C_calculate_demand(4,c,3)))){
C_save_and_reclaim((void *)f_5447,2,av);}
a=C_alloc(4);
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5453,a[2]=((C_word*)t0)[2],a[3]=((C_word)li120),tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm:672: ##sys#call-with-values */{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=0;
av2[1]=t1;
av2[2]=((C_word*)t0)[3];
av2[3]=t2;
C_call_with_values(4,av2);}}

/* k6162 in create-session in k5687 in k5683 in k5679 in k5675 in k5595 in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_6164(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,3)))){
C_save_and_reclaim((void *)f_6164,2,av);}
/* posixunix.scm:1045: ##sys#error */
t2=*((C_word*)lf[50]+1);{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[2];
av2[2]=lf[327];
av2[3]=lf[328];
((C_proc)(void*)(*((C_word*)t2+1)))(4,av2);}}

/* setenv in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_4124(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(4,c,3)))){
C_save_and_reclaim((void *)f_4124,4,av);}
a=C_alloc(4);
t4=C_i_check_string_2(t2,lf[118]);
t5=C_i_check_string_2(t3,lf[118]);
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4135,a[2]=t1,a[3]=t3,tmp=(C_word)a,a+=4,tmp);
/* posix-common.scm:632: ##sys#make-c-string */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[11]+1));
C_word *av2=av; /* Re-use our own argvector */
av2[0]=*((C_word*)lf[11]+1);
av2[1]=t6;
av2[2]=t2;
av2[3]=lf[118];
tp(4,av2);}}

/* a7906 in k7891 in process-fork in k6200 in k6169 in k5687 in k5683 in k5679 in k5675 in k5595 in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_7907(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(C_unlikely(!C_demand(C_calculate_demand(3,c,2)))){
C_save_and_reclaim((void *)f_7907,2,av);}
a=C_alloc(3);
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_7911,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm:1559: thunk */
t3=((C_word*)t0)[2];{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=t3;
av2[1]=t2;
((C_proc)C_fast_retrieve_proc(t3))(2,av2);}}

/* k8363 in a8333 in process in k6200 in k6169 in k5687 in k5683 in k5679 in k5675 in k5595 in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_8365(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,6)))){
C_save_and_reclaim((void *)f_8365,2,av);}
/* posixunix.scm:1703: input-port */
t2=((C_word*)t0)[2];
f_8300(t2,((C_word*)t0)[3],((C_word*)t0)[4],((C_word*)t0)[5],((C_word*)t0)[6],((C_word*)t0)[7],t1);}

/* k7909 in a7906 in k7891 in process-fork in k6200 in k6169 in k5687 in k5683 in k5679 in k5675 in k5595 in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_7911(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,2)))){
C_save_and_reclaim((void *)f_7911,2,av);}
/* posixunix.scm:1560: exit */
t2=*((C_word*)lf[425]+1);{
C_word *av2;
if(c >= 3) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(3);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[2];
av2[2]=C_fix(0);
((C_proc)(void*)(*((C_word*)t2+1)))(3,av2);}}

/* file-read-access? in k5687 in k5683 in k5679 in k5675 in k5595 in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_6136(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,4)))){
C_save_and_reclaim((void *)f_6136,3,av);}
/* posixunix.scm:1037: check */
f_6116(t1,t2,C_fix((C_word)R_OK),lf[324]);}

/* k8359 in k8343 in a8333 in process in k6200 in k6169 in k5687 in k5683 in k5679 in k5675 in k5595 in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_8361(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,6)))){
C_save_and_reclaim((void *)f_8361,2,av);}
/* posixunix.scm:1705: output-port */
t2=((C_word*)t0)[2];
f_8311(t2,((C_word*)t0)[3],((C_word*)t0)[4],((C_word*)t0)[5],((C_word*)t0)[6],((C_word*)t0)[7],t1);}

/* k6132 in check in k5687 in k5683 in k5679 in k5675 in k5595 in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_6134(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,2)))){
C_save_and_reclaim((void *)f_6134,2,av);}
a=C_alloc(4);
t2=C_test_access(t1,((C_word*)t0)[2]);
t3=C_eqp(C_fix(0),t2);
t4=t3;
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_6126,a[2]=((C_word*)t0)[3],a[3]=t4,tmp=(C_word)a,a+=4,tmp);
if(C_truep(t4)){
t6=((C_word*)t0)[3];{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=t6;
av2[1]=t4;
((C_proc)(void*)(*((C_word*)t6+1)))(2,av2);}}
else{
/* posixunix.scm:1035: ##sys#update-errno */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[5]+1));
C_word *av2=av; /* Re-use our own argvector */
av2[0]=*((C_word*)lf[5]+1);
av2[1]=t5;
tp(2,av2);}}}

/* k3086 in check in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_3088(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_3088,2,av);}
t2=C_set_file_ptr(t1,((C_word*)t0)[2]);
t3=t1;
t4=((C_word*)t0)[3];{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=t4;
av2[1]=t3;
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* k4133 in setenv in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_4135(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,3)))){
C_save_and_reclaim((void *)f_4135,2,av);}
a=C_alloc(4);
t2=t1;
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4139,a[2]=t2,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
/* posix-common.scm:632: ##sys#make-c-string */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[11]+1));
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[11]+1);
av2[1]=t3;
av2[2]=((C_word*)t0)[3];
av2[3]=lf[118];
tp(4,av2);}}

/* k4137 in k4133 in setenv in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_4139(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_4139,2,av);}
t2=C_setenv(((C_word*)t0)[2],t1);
t3=((C_word*)t0)[3];{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=t3;
av2[1]=C_SCHEME_UNDEFINED;
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* f_7915 in k7891 in process-fork in k6200 in k6169 in k5687 in k5683 in k5679 in k5675 in k5595 in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_7915(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_7915,3,av);}
/* posixunix.scm:1557: thunk */
t3=t2;{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=t3;
av2[1]=t1;
((C_proc)C_fast_retrieve_proc(t3))(2,av2);}}

/* k8351 in k8347 in k8343 in a8333 in process in k6200 in k6169 in k5687 in k5683 in k5679 in k5675 in k5595 in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 in ... */
static void C_ccall f_8353(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,5)))){
C_save_and_reclaim((void *)f_8353,2,av);}
/* posixunix.scm:1702: values */{
C_word *av2;
if(c >= 6) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(6);
}
av2[0]=0;
av2[1]=((C_word*)t0)[2];
av2[2]=((C_word*)t0)[3];
av2[3]=((C_word*)t0)[4];
av2[4]=((C_word*)t0)[5];
av2[5]=t1;
C_values(6,av2);}}

/* file-write-access? in k5687 in k5683 in k5679 in k5675 in k5595 in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_6142(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,4)))){
C_save_and_reclaim((void *)f_6142,3,av);}
/* posixunix.scm:1038: check */
f_6116(t1,t2,C_fix((C_word)W_OK),lf[325]);}

/* file-execute-access? in k5687 in k5683 in k5679 in k5675 in k5595 in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_6148(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,4)))){
C_save_and_reclaim((void *)f_6148,3,av);}
/* posixunix.scm:1039: check */
f_6116(t1,t2,C_fix((C_word)X_OK),lf[326]);}

/* a5452 in a5446 in k5435 in with-input-from-pipe in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_5453(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand((c-2)*C_SIZEOF_PAIR +4,c,2)))){
C_save_and_reclaim((void*)f_5453,c,av);}
a=C_alloc((c-2)*C_SIZEOF_PAIR+4);
t2=C_build_rest(&a,c,2,av);
C_word t3;
C_word t4;
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5457,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm:674: close-input-pipe */
t4=*((C_word*)lf[211]+1);{
C_word *av2;
if(c >= 3) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(3);
}
av2[0]=t4;
av2[1]=t3;
av2[2]=((C_word*)t0)[2];
((C_proc)(void*)(*((C_word*)t4+1)))(3,av2);}}

/* k8355 in k8347 in k8343 in a8333 in process in k6200 in k6169 in k5687 in k5683 in k5679 in k5675 in k5595 in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 in ... */
static void C_ccall f_8357(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,6)))){
C_save_and_reclaim((void *)f_8357,2,av);}
/* posixunix.scm:1708: input-port */
t2=((C_word*)t0)[2];
f_8300(t2,((C_word*)t0)[3],((C_word*)t0)[4],((C_word*)t0)[5],((C_word*)t0)[6],((C_word*)t0)[7],t1);}

/* k5455 in a5452 in a5446 in k5435 in with-input-from-pipe in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_5457(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,2)))){
C_save_and_reclaim((void *)f_5457,2,av);}{
C_word *av2;
if(c >= 3) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(3);
}
av2[0]=0;
av2[1]=((C_word*)t0)[2];
av2[2]=((C_word*)t0)[3];
C_apply_values(3,av2);}}

/* loop */
static void C_fcall f_7056(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word *a;
loop:
if(C_unlikely(!C_demand(C_calculate_demand(7,0,4)))){
C_save_and_reclaim_args((void *)trf_7056,5,t0,t1,t2,t3,t4);}
a=C_alloc(7);
t5=C_eqp(C_fix(0),t2);
if(C_truep(t5)){
t6=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_7066,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t1,a[5]=((C_word*)t0)[4],a[6]=t4,tmp=(C_word)a,a+=7,tmp);
/* posixunix.scm:1279: poke */
t7=((C_word*)((C_word*)t0)[5])[1];{
C_word av2[4];
av2[0]=t7;
av2[1]=t6;
av2[2]=((C_word*)t0)[6];
av2[3]=((C_word*)t0)[4];
((C_proc)C_fast_retrieve_proc(t7))(4,av2);}}
else{
if(C_truep(C_fixnum_lessp(t2,t4))){
t6=C_substring_copy(((C_word*)t0)[7],((C_word*)t0)[6],t3,t2,((C_word*)((C_word*)t0)[2])[1]);
t7=C_fixnum_difference(t4,t2);
/* posixunix.scm:1284: loop */
t10=t1;
t11=C_fix(0);
t12=t2;
t13=t7;
t1=t10;
t2=t11;
t3=t12;
t4=t13;
goto loop;}
else{
t6=C_substring_copy(((C_word*)t0)[7],((C_word*)t0)[6],t3,t4,((C_word*)((C_word*)t0)[2])[1]);
t7=C_fixnum_plus(((C_word*)((C_word*)t0)[2])[1],t4);
t8=C_set_block_item(((C_word*)t0)[2],0,t7);
t9=t1;{
C_word av2[2];
av2[0]=t9;
av2[1]=t8;
((C_proc)(void*)(*((C_word*)t9+1)))(2,av2);}}}}

/* change-directory in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_5207(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(4,c,3)))){
C_save_and_reclaim((void *)f_5207,3,av);}
a=C_alloc(4);
t3=C_i_check_string_2(t2,lf[69]);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5214,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm:590: ##sys#make-c-string */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[11]+1));
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[11]+1);
av2[1]=t4;
av2[2]=t2;
av2[3]=lf[69];
tp(4,av2);}}

/* chkstrlst in %process in k6200 in k6169 in k5687 in k5683 in k5679 in k5675 in k5595 in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_fcall f_8380(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(8,0,2)))){
C_save_and_reclaim_args((void *)trf_8380,3,t0,t1,t2);}
a=C_alloc(8);
t3=C_i_check_list_2(t2,((C_word*)t0)[2]);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_8385,a[2]=((C_word*)t0)[2],a[3]=((C_word)li239),tmp=(C_word)a,a+=4,tmp);
t5=t2;
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_8394,a[2]=t4,a[3]=((C_word)li240),tmp=(C_word)a,a+=4,tmp);
t7=t1;{
C_word av2[2];
av2[0]=t7;
av2[1]=(
  f_8394(t6,t5)
);
((C_proc)(void*)(*((C_word*)t7+1)))(2,av2);}}

/* g2088 in chkstrlst in %process in k6200 in k6169 in k5687 in k5683 in k5679 in k5675 in k5595 in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static C_word C_fcall f_8385(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_stack_overflow_check;{}
return(C_i_check_string_2(t1,((C_word*)t0)[2]));}

/* k6196 in k6192 in create-symbolic-link in k6169 in k5687 in k5683 in k5679 in k5675 in k5595 in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_6198(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,6)))){
C_save_and_reclaim((void *)f_6198,2,av);}
t2=C_symlink(((C_word*)t0)[2],t1);
if(C_truep(C_fixnum_lessp(t2,C_fix(0)))){
/* posixunix.scm:1077: posix-error */
t3=lf[0];{
C_word *av2;
if(c >= 7) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(7);
}
av2[0]=t3;
av2[1]=((C_word*)t0)[3];
av2[2]=lf[8];
av2[3]=lf[331];
av2[4]=lf[332];
av2[5]=((C_word*)t0)[4];
av2[6]=((C_word*)t0)[5];
f_2704(7,av2);}}
else{
t3=C_SCHEME_UNDEFINED;
t4=((C_word*)t0)[3];{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=t4;
av2[1]=t3;
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}}

/* a7972 in process-execute in k6200 in k6169 in k5687 in k5683 in k5679 in k5675 in k5595 in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_7973(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_7973,3,av);}
t3=t1;{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=t3;
av2[1]=t2;
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* a5399 in k5387 in call-with-input-pipe in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_5400(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand((c-2)*C_SIZEOF_PAIR +4,c,2)))){
C_save_and_reclaim((void*)f_5400,c,av);}
a=C_alloc((c-2)*C_SIZEOF_PAIR+4);
t2=C_build_rest(&a,c,2,av);
C_word t3;
C_word t4;
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5404,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm:656: close-input-pipe */
t4=*((C_word*)lf[211]+1);{
C_word *av2;
if(c >= 3) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(3);
}
av2[0]=t4;
av2[1]=t3;
av2[2]=((C_word*)t0)[2];
((C_proc)(void*)(*((C_word*)t4+1)))(3,av2);}}

/* a7975 in process-execute in k6200 in k6169 in k5687 in k5683 in k5679 in k5675 in k5595 in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_7976(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4=av[4];
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
if(c!=5) C_bad_argc_2(c,5,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,5)))){
C_save_and_reclaim((void *)f_7976,5,av);}
t5=(C_truep(t4)?C_u_i_execve(t2,t3,t4):C_u_i_execvp(t2,t3));
t6=C_eqp(t5,C_fix(-1));
if(C_truep(t6)){
/* posixunix.scm:1571: posix-error */
t7=lf[0];{
C_word *av2;
if(c >= 6) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(6);
}
av2[0]=t7;
av2[1]=t1;
av2[2]=lf[127];
av2[3]=lf[427];
av2[4]=lf[428];
av2[5]=((C_word*)t0)[2];
f_2704(6,av2);}}
else{
t7=C_SCHEME_UNDEFINED;
t8=t1;{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=t8;
av2[1]=t7;
((C_proc)(void*)(*((C_word*)t8+1)))(2,av2);}}}

/* k6192 in create-symbolic-link in k6169 in k5687 in k5683 in k5679 in k5675 in k5595 in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_6194(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(6,c,3)))){
C_save_and_reclaim((void *)f_6194,2,av);}
a=C_alloc(6);
t2=t1;
t3=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_6198,a[2]=t2,a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],tmp=(C_word)a,a+=6,tmp);
/* posixunix.scm:1075: ##sys#make-c-string */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[11]+1));
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[11]+1);
av2[1]=t3;
av2[2]=((C_word*)t0)[4];
av2[3]=lf[330];
tp(4,av2);}}

/* call-with-output-pipe in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_5409(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c<4) C_bad_min_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand((c-4)*C_SIZEOF_PAIR +4,c,4)))){
C_save_and_reclaim((void*)f_5409,c,av);}
a=C_alloc((c-4)*C_SIZEOF_PAIR+4);
t4=C_build_rest(&a,c,4,av);
C_word t5;
C_word t6;
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5413,a[2]=t3,a[3]=t1,tmp=(C_word)a,a+=4,tmp);{
C_word *av2;
if(c >= 5) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(5);
}
av2[0]=0;
av2[1]=t5;
av2[2]=*((C_word*)lf[210]+1);
av2[3]=t2;
av2[4]=t4;
C_apply(5,av2);}}

/* k5402 in a5399 in k5387 in call-with-input-pipe in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_5404(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,2)))){
C_save_and_reclaim((void *)f_5404,2,av);}{
C_word *av2;
if(c >= 3) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(3);
}
av2[0]=0;
av2[1]=((C_word*)t0)[2];
av2[2]=((C_word*)t0)[3];
C_apply_values(3,av2);}}

/* k7064 in loop */
static void C_ccall f_7066(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,4)))){
C_save_and_reclaim((void *)f_7066,2,av);}
t2=C_set_block_item(((C_word*)t0)[2],0,C_fix(0));
/* posixunix.scm:1281: loop */
t3=((C_word*)((C_word*)t0)[3])[1];
f_7056(t3,((C_word*)t0)[4],((C_word*)t0)[5],C_fix(0),((C_word*)t0)[6]);}

/* with-input-from-pipe in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_5433(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c<4) C_bad_min_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand((c-4)*C_SIZEOF_PAIR +4,c,4)))){
C_save_and_reclaim((void*)f_5433,c,av);}
a=C_alloc((c-4)*C_SIZEOF_PAIR+4);
t4=C_build_rest(&a,c,4,av);
C_word t5;
C_word t6;
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5437,a[2]=t3,a[3]=t1,tmp=(C_word)a,a+=4,tmp);{
C_word *av2;
if(c >= 5) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(5);
}
av2[0]=0;
av2[1]=t5;
av2[2]=*((C_word*)lf[206]+1);
av2[3]=t2;
av2[4]=t4;
C_apply(5,av2);}}

/* %process in k6200 in k6169 in k5687 in k5683 in k5679 in k5675 in k5595 in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_fcall f_8378(C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6,C_word t7){
C_word tmp;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(23,0,3)))){
C_save_and_reclaim_args((void *)trf_8378,7,t1,t2,t3,t4,t5,t6,t7);}
a=C_alloc(23);
t8=(*a=C_VECTOR_TYPE|1,a[1]=t4,tmp=(C_word)a,a+=2,tmp);
t9=(*a=C_VECTOR_TYPE|1,a[1]=t5,tmp=(C_word)a,a+=2,tmp);
t10=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_8380,a[2]=t2,a[3]=((C_word)li241),tmp=(C_word)a,a+=4,tmp);
t11=C_i_check_string_2(((C_word*)t8)[1],t2);
t12=(*a=C_CLOSURE_TYPE|9,a[1]=(C_word)f_8421,a[2]=t2,a[3]=t8,a[4]=t9,a[5]=t6,a[6]=t3,a[7]=t1,a[8]=t7,a[9]=t10,tmp=(C_word)a,a+=10,tmp);
if(C_truep(((C_word*)t9)[1])){
/* posixunix.scm:1724: chkstrlst */
t13=t10;
f_8380(t13,t12,((C_word*)t9)[1]);}
else{
t13=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_8443,a[2]=t9,a[3]=t8,a[4]=t12,tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm:1726: ##sys#shell-command-arguments */
t14=*((C_word*)lf[437]+1);{
C_word av2[3];
av2[0]=t14;
av2[1]=t13;
av2[2]=((C_word*)t8)[1];
((C_proc)(void*)(*((C_word*)t14+1)))(3,av2);}}}

/* k5435 in with-input-from-pipe in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_5437(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(19,c,4)))){
C_save_and_reclaim((void *)f_5437,2,av);}
a=C_alloc(19);
t2=t1;
t3=t2;
t4=(*a=C_VECTOR_TYPE|1,a[1]=t3,tmp=(C_word)a,a+=2,tmp);
t5=C_SCHEME_FALSE;
t6=(*a=C_VECTOR_TYPE|1,a[1]=t5,tmp=(C_word)a,a+=2,tmp);
t7=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_5442,a[2]=t6,a[3]=t4,a[4]=((C_word)li119),tmp=(C_word)a,a+=5,tmp);
t8=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_5447,a[2]=t2,a[3]=((C_word*)t0)[2],a[4]=((C_word)li121),tmp=(C_word)a,a+=5,tmp);
t9=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_5462,a[2]=t4,a[3]=t6,a[4]=((C_word)li122),tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm:669: ##sys#dynamic-wind */
t10=*((C_word*)lf[95]+1);{
C_word *av2;
if(c >= 5) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(5);
}
av2[0]=t10;
av2[1]=((C_word*)t0)[3];
av2[2]=t7;
av2[3]=t8;
av2[4]=t9;
((C_proc)(void*)(*((C_word*)t10+1)))(5,av2);}}

/* process-wait in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_4250(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand((c-2)*C_SIZEOF_PAIR +9,c,5)))){
C_save_and_reclaim((void*)f_4250,c,av);}
a=C_alloc((c-2)*C_SIZEOF_PAIR+9);
t2=C_build_rest(&a,c,2,av);
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word t17;
t3=C_i_nullp(t2);
t4=(C_truep(t3)?C_SCHEME_FALSE:C_i_car(t2));
t5=C_i_nullp(t2);
t6=(C_truep(t5)?C_SCHEME_END_OF_LIST:C_i_cdr(t2));
t7=C_i_nullp(t6);
t8=(C_truep(t7)?C_SCHEME_FALSE:C_i_car(t6));
t9=t8;
t10=C_i_nullp(t6);
t11=(C_truep(t10)?C_SCHEME_END_OF_LIST:C_i_cdr(t6));
t12=(C_truep(t4)?t4:C_fix(-1));
t13=t12;
t14=C_i_check_exact_2(t13,lf[125]);
t15=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4274,a[2]=t13,a[3]=t9,a[4]=((C_word)li69),tmp=(C_word)a,a+=5,tmp);
t16=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4280,a[2]=t13,a[3]=((C_word)li70),tmp=(C_word)a,a+=4,tmp);
/* posix-common.scm:679: ##sys#call-with-values */{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=0;
av2[1]=t1;
av2[2]=t15;
av2[3]=t16;
C_call_with_values(4,av2);}}

/* k7036 in k6908 in custom-output-port in k6200 in k6169 in k5687 in k5683 in k5679 in k5675 in k5595 in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_7038(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(9,c,3)))){
C_save_and_reclaim((void *)f_7038,2,av);}
a=C_alloc(9);
t2=t1;
t3=C_fix(0);
t4=(*a=C_VECTOR_TYPE|1,a[1]=t3,tmp=(C_word)a,a+=2,tmp);
t5=((C_word*)t0)[2];
f_6977(t5,(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_7039,a[2]=((C_word*)t0)[3],a[3]=t4,a[4]=((C_word*)t0)[4],a[5]=t2,a[6]=((C_word)li182),tmp=(C_word)a,a+=7,tmp));}

/* f_7039 in k7036 in k6908 in custom-output-port in k6200 in k6169 in k5687 in k5683 in k5679 in k5675 in k5595 in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_7039(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(11,c,5)))){
C_save_and_reclaim((void *)f_7039,3,av);}
a=C_alloc(11);
if(C_truep(t2)){
t3=C_fixnum_difference(((C_word*)t0)[2],((C_word*)((C_word*)t0)[3])[1]);
t4=C_block_size(t2);
t5=C_SCHEME_UNDEFINED;
t6=(*a=C_VECTOR_TYPE|1,a[1]=t5,tmp=(C_word)a,a+=2,tmp);
t7=C_set_block_item(t6,0,(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_7056,a[2]=((C_word*)t0)[3],a[3]=t6,a[4]=((C_word*)t0)[2],a[5]=((C_word*)t0)[4],a[6]=((C_word*)t0)[5],a[7]=t2,a[8]=((C_word)li181),tmp=(C_word)a,a+=9,tmp));
t8=((C_word*)t6)[1];
f_7056(t8,t1,t3,C_fix(0),t4);}
else{
if(C_truep(C_fixnum_lessp(C_fix(0),((C_word*)((C_word*)t0)[3])[1]))){
/* posixunix.scm:1289: poke */
t3=((C_word*)((C_word*)t0)[4])[1];{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=t3;
av2[1]=t1;
av2[2]=((C_word*)t0)[5];
av2[3]=((C_word*)((C_word*)t0)[3])[1];
((C_proc)C_fast_retrieve_proc(t3))(4,av2);}}
else{
t3=t1;{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=t3;
av2[1]=C_SCHEME_UNDEFINED;
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}}}

/* create-symbolic-link in k6169 in k5687 in k5683 in k5679 in k5675 in k5595 in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_6173(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(5,c,3)))){
C_save_and_reclaim((void *)f_6173,4,av);}
a=C_alloc(5);
t4=C_i_check_string_2(t2,lf[330]);
t5=C_i_check_string_2(t3,lf[330]);
t6=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_6194,a[2]=t1,a[3]=t2,a[4]=t3,tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm:1074: ##sys#make-c-string */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[11]+1));
C_word *av2=av; /* Re-use our own argvector */
av2[0]=*((C_word*)lf[11]+1);
av2[1]=t6;
av2[2]=t2;
av2[3]=lf[330];
tp(4,av2);}}

/* k6169 in k5687 in k5683 in k5679 in k5675 in k5595 in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_6171(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(6,c,4)))){
C_save_and_reclaim((void *)f_6171,2,av);}
a=C_alloc(6);
t2=C_mutate2((C_word*)lf[329]+1 /* (set! process-group-id ...) */,t1);
t3=C_mutate2((C_word*)lf[330]+1 /* (set! create-symbolic-link ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6173,a[2]=((C_word)li153),tmp=(C_word)a,a+=3,tmp));
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6202,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
t5=C_fixnum_plus(C_fix((C_word)FILENAME_MAX),C_fix(1));
/* ##sys#make-string */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[72]+1));
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[72]+1);
av2[1]=t4;
av2[2]=t5;
av2[3]=C_make_character(32);
tp(4,av2);}}

/* a5461 in k5435 in with-input-from-pipe in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_5462(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_5462,2,av);}
t2=C_mutate2(((C_word *)((C_word*)t0)[2])+1,*((C_word*)lf[218]+1));
t3=C_mutate2((C_word*)lf[218]+1 /* (set! ##sys#standard-input ...) */,((C_word*)((C_word*)t0)[3])[1]);
t4=t1;{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=t4;
av2[1]=C_SCHEME_UNDEFINED;
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* process-execute in k6200 in k6169 in k5687 in k5683 in k5679 in k5675 in k5595 in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_7955(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand((c-3)*C_SIZEOF_PAIR +7,c,7)))){
C_save_and_reclaim((void*)f_7955,c,av);}
a=C_alloc((c-3)*C_SIZEOF_PAIR+7);
t3=C_build_rest(&a,c,3,av);
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
t4=C_i_nullp(t3);
t5=(C_truep(t4)?C_SCHEME_END_OF_LIST:C_i_car(t3));
t6=C_i_nullp(t3);
t7=(C_truep(t6)?C_SCHEME_END_OF_LIST:C_i_cdr(t3));
t8=C_i_nullp(t7);
t9=(C_truep(t8)?C_SCHEME_FALSE:C_i_car(t7));
t10=C_i_nullp(t7);
t11=(C_truep(t10)?C_SCHEME_END_OF_LIST:C_i_cdr(t7));
t12=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_7973,a[2]=((C_word)li211),tmp=(C_word)a,a+=3,tmp);
t13=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_7976,a[2]=t2,a[3]=((C_word)li212),tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm:1564: call-with-exec-args */
t14=lf[142];
f_4476(t14,t1,lf[427],t2,t12,t5,t9,t13);}

/* with-output-to-pipe in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_5467(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c<4) C_bad_min_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand((c-4)*C_SIZEOF_PAIR +4,c,4)))){
C_save_and_reclaim((void*)f_5467,c,av);}
a=C_alloc((c-4)*C_SIZEOF_PAIR+4);
t4=C_build_rest(&a,c,4,av);
C_word t5;
C_word t6;
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5471,a[2]=t3,a[3]=t1,tmp=(C_word)a,a+=4,tmp);{
C_word *av2;
if(c >= 5) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(5);
}
av2[0]=0;
av2[1]=t5;
av2[2]=*((C_word*)lf[210]+1);
av2[3]=t2;
av2[4]=t4;
C_apply(5,av2);}}

/* k8131 in k8127 in k8108 in k8105 in process-run in k6200 in k6169 in k5687 in k5683 in k5679 in k5675 in k5595 in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 in ... */
static void C_ccall f_8133(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,3)))){
C_save_and_reclaim((void *)f_8133,2,av);}
/* posixunix.scm:1615: process-execute */
t2=*((C_word*)lf[427]+1);{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[2];
av2[2]=((C_word*)t0)[3];
av2[3]=t1;
((C_proc)(void*)(*((C_word*)t2+1)))(4,av2);}}

/* ##sys#process-wait in k6200 in k6169 in k5687 in k5683 in k5679 in k5675 in k5595 in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_8015(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(5,c,4)))){
C_save_and_reclaim((void *)f_8015,4,av);}
a=C_alloc(5);
t4=(C_truep(t3)?C_fix((C_word)WNOHANG):C_fix(0));
t5=C_waitpid(t2,t4);
t6=C_WIFEXITED(C_fix((C_word)C_wait_status));
t7=C_eqp(t5,C_fix(-1));
t8=(C_truep(t7)?C_eqp(C_fix((C_word)errno),C_fix((C_word)EINTR)):C_SCHEME_FALSE);
if(C_truep(t8)){
t9=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_8031,a[2]=t2,a[3]=t3,a[4]=((C_word)li214),tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm:1580: ##sys#dispatch-interrupt */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[186]+1));
C_word *av2=av; /* Re-use our own argvector */
av2[0]=*((C_word*)lf[186]+1);
av2[1]=t1;
av2[2]=t9;
tp(3,av2);}}
else{
if(C_truep(t6)){
t9=C_WEXITSTATUS(C_fix((C_word)C_wait_status));
/* posixunix.scm:1582: values */{
C_word *av2;
if(c >= 5) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(5);
}
av2[0]=0;
av2[1]=t1;
av2[2]=t5;
av2[3]=t6;
av2[4]=t9;
C_values(5,av2);}}
else{
if(C_truep(C_WIFSIGNALED(C_fix((C_word)C_wait_status)))){
t9=C_WTERMSIG(C_fix((C_word)C_wait_status));
/* posixunix.scm:1582: values */{
C_word *av2;
if(c >= 5) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(5);
}
av2[0]=0;
av2[1]=t1;
av2[2]=t5;
av2[3]=t6;
av2[4]=t9;
C_values(5,av2);}}
else{
t9=C_WSTOPSIG(C_fix((C_word)C_wait_status));
/* posixunix.scm:1582: values */{
C_word *av2;
if(c >= 5) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(5);
}
av2[0]=0;
av2[1]=t1;
av2[2]=t5;
av2[3]=t6;
av2[4]=t9;
C_values(5,av2);}}}}}

/* for-each-loop2087 in chkstrlst in %process in k6200 in k6169 in k5687 in k5683 in k5679 in k5675 in k5595 in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static C_word C_fcall f_8394(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_stack_overflow_check;
loop:{}
if(C_truep(C_i_pairp(t1))){
t2=C_slot(t1,C_fix(0));
t3=(
  /* posixunix.scm:1721: g2088 */
  f_8385(((C_word*)t0)[2],t2)
);
t4=C_slot(t1,C_fix(1));
t6=t4;
t1=t6;
goto loop;}
else{
t2=C_SCHEME_UNDEFINED;
return(t2);}}

/* k8127 in k8108 in k8105 in process-run in k6200 in k6169 in k5687 in k5683 in k5679 in k5675 in k5595 in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_8129(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,2)))){
C_save_and_reclaim((void *)f_8129,2,av);}
a=C_alloc(4);
t2=t1;
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_8133,a[2]=((C_word*)t0)[2],a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm:1615: ##sys#shell-command-arguments */
t4=*((C_word*)lf[437]+1);{
C_word *av2;
if(c >= 3) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(3);
}
av2[0]=t4;
av2[1]=t3;
av2[2]=((C_word*)t0)[3];
((C_proc)(void*)(*((C_word*)t4+1)))(3,av2);}}

/* a7015 in k6975 in k6908 in custom-output-port in k6200 in k6169 in k5687 in k5683 in k5679 in k5675 in k5595 in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_7016(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,2)))){
C_save_and_reclaim((void *)f_7016,2,av);}
/* posixunix.scm:1300: store */
t2=((C_word*)((C_word*)t0)[2])[1];{
C_word *av2;
if(c >= 3) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(3);
}
av2[0]=t2;
av2[1]=t1;
av2[2]=C_SCHEME_FALSE;
((C_proc)C_fast_retrieve_proc(t2))(3,av2);}}

/* k3485 in loop in k3457 in k3453 in k3450 in k3447 in k3432 in directory in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_3487(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(5,c,2)))){
C_save_and_reclaim((void *)f_3487,2,av);}
a=C_alloc(5);
t2=t1;
t3=C_i_string_ref(t2,C_fix(0));
t4=C_fixnum_greaterp(((C_word*)t0)[2],C_fix(1));
t5=(C_truep(t4)?C_i_string_ref(t2,C_fix(1)):C_SCHEME_FALSE);
t6=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3499,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=t2,tmp=(C_word)a,a+=5,tmp);
t7=C_eqp(C_make_character(46),t3);
if(C_truep(t7)){
t8=C_i_not(t5);
if(C_truep(t8)){
t9=t6;
f_3499(t9,t8);}
else{
t9=C_eqp(C_make_character(46),t5);
if(C_truep(t9)){
t10=C_eqp(C_fix(2),((C_word*)t0)[2]);
t11=t6;
f_3499(t11,(C_truep(t10)?t10:C_i_not(((C_word*)t0)[5])));}
else{
t10=t6;
f_3499(t10,C_i_not(((C_word*)t0)[5]));}}}
else{
t8=t6;
f_3499(t8,C_SCHEME_FALSE);}}

/* k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_4242(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word t17;
C_word t18;
C_word t19;
C_word t20;
C_word t21;
C_word t22;
C_word t23;
C_word t24;
C_word t25;
C_word t26;
C_word t27;
C_word t28;
C_word t29;
C_word t30;
C_word t31;
C_word t32;
C_word t33;
C_word t34;
C_word t35;
C_word t36;
C_word t37;
C_word t38;
C_word t39;
C_word t40;
C_word t41;
C_word t42;
C_word t43;
C_word t44;
C_word t45;
C_word t46;
C_word t47;
C_word t48;
C_word t49;
C_word t50;
C_word t51;
C_word t52;
C_word t53;
C_word t54;
C_word t55;
C_word t56;
C_word t57;
C_word t58;
C_word t59;
C_word t60;
C_word t61;
C_word t62;
C_word t63;
C_word t64;
C_word t65;
C_word t66;
C_word t67;
C_word t68;
C_word t69;
C_word t70;
C_word t71;
C_word t72;
C_word t73;
C_word t74;
C_word t75;
C_word t76;
C_word t77;
C_word t78;
C_word t79;
C_word t80;
C_word t81;
C_word t82;
C_word t83;
C_word t84;
C_word t85;
C_word t86;
C_word t87;
C_word t88;
C_word t89;
C_word t90;
C_word t91;
C_word t92;
C_word t93;
C_word t94;
C_word t95;
C_word t96;
C_word t97;
C_word t98;
C_word t99;
C_word t100;
C_word t101;
C_word t102;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(181,c,8)))){
C_save_and_reclaim((void *)f_4242,2,av);}
a=C_alloc(181);
t2=C_mutate2((C_word*)lf[123]+1 /* (set! signal-handler ...) */,t1);
t3=C_mutate2((C_word*)lf[124]+1 /* (set! current-process-id ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4244,a[2]=((C_word)li68),tmp=(C_word)a,a+=3,tmp));
t4=C_mutate2((C_word*)lf[125]+1 /* (set! process-wait ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4250,a[2]=((C_word)li71),tmp=(C_word)a,a+=3,tmp));
t5=C_mutate2(&lf[129] /* (set! list->c-string-buffer ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4321,a[2]=((C_word)li80),tmp=(C_word)a,a+=3,tmp));
t6=C_mutate2(&lf[131] /* (set! free-c-string-buffer ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4440,a[2]=((C_word)li82),tmp=(C_word)a,a+=3,tmp));
t7=*((C_word*)lf[141]+1);
t8=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4474,a[2]=((C_word)li83),tmp=(C_word)a,a+=3,tmp);
t9=C_mutate2(&lf[142] /* (set! call-with-exec-args ...) */,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4476,a[2]=t8,a[3]=t7,a[4]=((C_word)li91),tmp=(C_word)a,a+=5,tmp));
t10=C_mutate2((C_word*)lf[143]+1 /* (set! ##sys#file-nonblocking! ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4556,a[2]=((C_word)li92),tmp=(C_word)a,a+=3,tmp));
t11=C_mutate2((C_word*)lf[144]+1 /* (set! ##sys#file-select-one ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4563,a[2]=((C_word)li93),tmp=(C_word)a,a+=3,tmp));
t12=C_mutate2((C_word*)lf[145]+1 /* (set! pipe/buf ...) */,C_fix((C_word)PIPE_BUF));
t13=C_mutate2((C_word*)lf[146]+1 /* (set! fcntl/dupfd ...) */,C_fix((C_word)F_DUPFD));
t14=C_mutate2((C_word*)lf[147]+1 /* (set! fcntl/getfd ...) */,C_fix((C_word)F_GETFD));
t15=C_mutate2((C_word*)lf[148]+1 /* (set! fcntl/setfd ...) */,C_fix((C_word)F_SETFD));
t16=C_mutate2((C_word*)lf[149]+1 /* (set! fcntl/getfl ...) */,C_fix((C_word)F_GETFL));
t17=C_mutate2((C_word*)lf[150]+1 /* (set! fcntl/setfl ...) */,C_fix((C_word)F_SETFL));
t18=C_mutate2((C_word*)lf[151]+1 /* (set! open/rdonly ...) */,C_fix((C_word)O_RDONLY));
t19=C_mutate2((C_word*)lf[152]+1 /* (set! open/wronly ...) */,C_fix((C_word)O_WRONLY));
t20=C_mutate2((C_word*)lf[153]+1 /* (set! open/rdwr ...) */,C_fix((C_word)O_RDWR));
t21=C_mutate2((C_word*)lf[154]+1 /* (set! open/read ...) */,C_fix((C_word)O_RDONLY));
t22=C_mutate2((C_word*)lf[155]+1 /* (set! open/write ...) */,C_fix((C_word)O_WRONLY));
t23=C_mutate2((C_word*)lf[156]+1 /* (set! open/creat ...) */,C_fix((C_word)O_CREAT));
t24=C_mutate2((C_word*)lf[157]+1 /* (set! open/append ...) */,C_fix((C_word)O_APPEND));
t25=C_mutate2((C_word*)lf[158]+1 /* (set! open/excl ...) */,C_fix((C_word)O_EXCL));
t26=C_mutate2((C_word*)lf[159]+1 /* (set! open/noctty ...) */,C_fix((C_word)O_NOCTTY));
t27=C_mutate2((C_word*)lf[160]+1 /* (set! open/nonblock ...) */,C_fix((C_word)O_NONBLOCK));
t28=C_mutate2((C_word*)lf[161]+1 /* (set! open/trunc ...) */,C_fix((C_word)O_TRUNC));
t29=C_mutate2((C_word*)lf[162]+1 /* (set! open/sync ...) */,C_fix((C_word)O_FSYNC));
t30=C_mutate2((C_word*)lf[163]+1 /* (set! open/fsync ...) */,C_fix((C_word)O_FSYNC));
t31=C_mutate2((C_word*)lf[164]+1 /* (set! open/binary ...) */,C_fix((C_word)O_BINARY));
t32=C_mutate2((C_word*)lf[165]+1 /* (set! open/text ...) */,C_fix((C_word)O_TEXT));
t33=C_mutate2((C_word*)lf[166]+1 /* (set! perm/irusr ...) */,C_fix((C_word)S_IRUSR));
t34=C_mutate2((C_word*)lf[167]+1 /* (set! perm/iwusr ...) */,C_fix((C_word)S_IWUSR));
t35=C_mutate2((C_word*)lf[168]+1 /* (set! perm/ixusr ...) */,C_fix((C_word)S_IXUSR));
t36=C_mutate2((C_word*)lf[169]+1 /* (set! perm/irgrp ...) */,C_fix((C_word)S_IRGRP));
t37=C_mutate2((C_word*)lf[170]+1 /* (set! perm/iwgrp ...) */,C_fix((C_word)S_IWGRP));
t38=C_mutate2((C_word*)lf[171]+1 /* (set! perm/ixgrp ...) */,C_fix((C_word)S_IXGRP));
t39=C_mutate2((C_word*)lf[172]+1 /* (set! perm/iroth ...) */,C_fix((C_word)S_IROTH));
t40=C_mutate2((C_word*)lf[173]+1 /* (set! perm/iwoth ...) */,C_fix((C_word)S_IWOTH));
t41=C_mutate2((C_word*)lf[174]+1 /* (set! perm/ixoth ...) */,C_fix((C_word)S_IXOTH));
t42=C_mutate2((C_word*)lf[175]+1 /* (set! perm/irwxu ...) */,C_fix((C_word)S_IRWXU));
t43=C_mutate2((C_word*)lf[176]+1 /* (set! perm/irwxg ...) */,C_fix((C_word)S_IRWXG));
t44=C_mutate2((C_word*)lf[177]+1 /* (set! perm/irwxo ...) */,C_fix((C_word)S_IRWXO));
t45=C_mutate2((C_word*)lf[178]+1 /* (set! perm/isvtx ...) */,C_fix((C_word)S_ISVTX));
t46=C_mutate2((C_word*)lf[179]+1 /* (set! perm/isuid ...) */,C_fix((C_word)S_ISUID));
t47=C_mutate2((C_word*)lf[180]+1 /* (set! perm/isgid ...) */,C_fix((C_word)S_ISGID));
t48=C_mutate2((C_word*)lf[181]+1 /* (set! file-control ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4620,a[2]=((C_word)li94),tmp=(C_word)a,a+=3,tmp));
t49=C_a_i_bitwise_ior(&a,2,C_fix((C_word)S_IRGRP),C_fix((C_word)S_IROTH));
t50=C_a_i_bitwise_ior(&a,2,C_fix((C_word)S_IRWXU),t49);
t51=t50;
t52=C_mutate2((C_word*)lf[183]+1 /* (set! file-open ...) */,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4653,a[2]=t51,a[3]=((C_word)li95),tmp=(C_word)a,a+=4,tmp));
t53=C_mutate2((C_word*)lf[185]+1 /* (set! file-close ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4685,a[2]=((C_word)li97),tmp=(C_word)a,a+=3,tmp));
t54=C_mutate2((C_word*)lf[188]+1 /* (set! file-read ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4716,a[2]=((C_word)li98),tmp=(C_word)a,a+=3,tmp));
t55=C_mutate2((C_word*)lf[191]+1 /* (set! file-write ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4757,a[2]=((C_word)li99),tmp=(C_word)a,a+=3,tmp));
t56=C_mutate2((C_word*)lf[194]+1 /* (set! file-mkstemp ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4794,a[2]=((C_word)li100),tmp=(C_word)a,a+=3,tmp));
t57=C_mutate2((C_word*)lf[196]+1 /* (set! file-select ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4826,a[2]=((C_word)li105),tmp=(C_word)a,a+=3,tmp));
t58=C_mutate2((C_word*)lf[69]+1 /* (set! change-directory ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5207,a[2]=((C_word)li106),tmp=(C_word)a,a+=3,tmp));
t59=C_mutate2((C_word*)lf[202]+1 /* (set! change-directory* ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5226,a[2]=((C_word)li107),tmp=(C_word)a,a+=3,tmp));
t60=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5260,a[2]=((C_word)li108),tmp=(C_word)a,a+=3,tmp);
t61=C_mutate2((C_word*)lf[206]+1 /* (set! open-input-pipe ...) */,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5275,a[2]=t60,a[3]=((C_word)li109),tmp=(C_word)a,a+=4,tmp));
t62=C_mutate2((C_word*)lf[210]+1 /* (set! open-output-pipe ...) */,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5315,a[2]=t60,a[3]=((C_word)li110),tmp=(C_word)a,a+=4,tmp));
t63=C_mutate2((C_word*)lf[211]+1 /* (set! close-input-pipe ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5355,a[2]=((C_word)li111),tmp=(C_word)a,a+=3,tmp));
t64=C_mutate2((C_word*)lf[213]+1 /* (set! close-output-pipe ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5370,a[2]=((C_word)li112),tmp=(C_word)a,a+=3,tmp));
t65=C_mutate2((C_word*)lf[215]+1 /* (set! call-with-input-pipe ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5385,a[2]=((C_word)li115),tmp=(C_word)a,a+=3,tmp));
t66=C_mutate2((C_word*)lf[216]+1 /* (set! call-with-output-pipe ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5409,a[2]=((C_word)li118),tmp=(C_word)a,a+=3,tmp));
t67=C_mutate2((C_word*)lf[217]+1 /* (set! with-input-from-pipe ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5433,a[2]=((C_word)li123),tmp=(C_word)a,a+=3,tmp));
t68=C_mutate2((C_word*)lf[219]+1 /* (set! with-output-to-pipe ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5467,a[2]=((C_word)li128),tmp=(C_word)a,a+=3,tmp));
t69=C_mutate2((C_word*)lf[221]+1 /* (set! create-pipe ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5501,a[2]=((C_word)li129),tmp=(C_word)a,a+=3,tmp));
t70=C_mutate2((C_word*)lf[223]+1 /* (set! signal/term ...) */,C_fix((C_word)SIGTERM));
t71=C_mutate2((C_word*)lf[224]+1 /* (set! signal/kill ...) */,C_fix((C_word)SIGKILL));
t72=C_mutate2((C_word*)lf[225]+1 /* (set! signal/int ...) */,C_fix((C_word)SIGINT));
t73=C_mutate2((C_word*)lf[226]+1 /* (set! signal/hup ...) */,C_fix((C_word)SIGHUP));
t74=C_mutate2((C_word*)lf[227]+1 /* (set! signal/fpe ...) */,C_fix((C_word)SIGFPE));
t75=C_mutate2((C_word*)lf[228]+1 /* (set! signal/ill ...) */,C_fix((C_word)SIGILL));
t76=C_mutate2((C_word*)lf[229]+1 /* (set! signal/segv ...) */,C_fix((C_word)SIGSEGV));
t77=C_mutate2((C_word*)lf[230]+1 /* (set! signal/abrt ...) */,C_fix((C_word)SIGABRT));
t78=C_mutate2((C_word*)lf[231]+1 /* (set! signal/trap ...) */,C_fix((C_word)SIGTRAP));
t79=C_mutate2((C_word*)lf[232]+1 /* (set! signal/quit ...) */,C_fix((C_word)SIGQUIT));
t80=C_mutate2((C_word*)lf[233]+1 /* (set! signal/alrm ...) */,C_fix((C_word)SIGALRM));
t81=C_mutate2((C_word*)lf[234]+1 /* (set! signal/vtalrm ...) */,C_fix((C_word)SIGVTALRM));
t82=C_mutate2((C_word*)lf[235]+1 /* (set! signal/prof ...) */,C_fix((C_word)SIGPROF));
t83=C_mutate2((C_word*)lf[236]+1 /* (set! signal/io ...) */,C_fix((C_word)SIGIO));
t84=C_mutate2((C_word*)lf[237]+1 /* (set! signal/urg ...) */,C_fix((C_word)SIGURG));
t85=C_mutate2((C_word*)lf[238]+1 /* (set! signal/chld ...) */,C_fix((C_word)SIGCHLD));
t86=C_mutate2((C_word*)lf[239]+1 /* (set! signal/cont ...) */,C_fix((C_word)SIGCONT));
t87=C_mutate2((C_word*)lf[240]+1 /* (set! signal/stop ...) */,C_fix((C_word)SIGSTOP));
t88=C_mutate2((C_word*)lf[241]+1 /* (set! signal/tstp ...) */,C_fix((C_word)SIGTSTP));
t89=C_mutate2((C_word*)lf[242]+1 /* (set! signal/pipe ...) */,C_fix((C_word)SIGPIPE));
t90=C_mutate2((C_word*)lf[243]+1 /* (set! signal/xcpu ...) */,C_fix((C_word)SIGXCPU));
t91=C_mutate2((C_word*)lf[244]+1 /* (set! signal/xfsz ...) */,C_fix((C_word)SIGXFSZ));
t92=C_mutate2((C_word*)lf[245]+1 /* (set! signal/usr1 ...) */,C_fix((C_word)SIGUSR1));
t93=C_mutate2((C_word*)lf[246]+1 /* (set! signal/usr2 ...) */,C_fix((C_word)SIGUSR2));
t94=C_mutate2((C_word*)lf[247]+1 /* (set! signal/winch ...) */,C_fix((C_word)SIGWINCH));
t95=C_mutate2((C_word*)lf[248]+1 /* (set! signal/bus ...) */,C_fix((C_word)SIGBUS));
t96=C_set_block_item(lf[249] /* signal/break */,0,C_fix(0));
t97=C_a_i_list(&a,26,*((C_word*)lf[223]+1),*((C_word*)lf[224]+1),*((C_word*)lf[225]+1),*((C_word*)lf[226]+1),*((C_word*)lf[227]+1),*((C_word*)lf[228]+1),*((C_word*)lf[229]+1),*((C_word*)lf[230]+1),*((C_word*)lf[231]+1),*((C_word*)lf[232]+1),*((C_word*)lf[233]+1),*((C_word*)lf[234]+1),*((C_word*)lf[235]+1),*((C_word*)lf[236]+1),*((C_word*)lf[237]+1),*((C_word*)lf[238]+1),*((C_word*)lf[239]+1),*((C_word*)lf[240]+1),*((C_word*)lf[241]+1),*((C_word*)lf[242]+1),*((C_word*)lf[243]+1),*((C_word*)lf[244]+1),*((C_word*)lf[245]+1),*((C_word*)lf[246]+1),*((C_word*)lf[247]+1),*((C_word*)lf[248]+1));
t98=C_mutate2((C_word*)lf[250]+1 /* (set! signals-list ...) */,t97);
t99=C_mutate2((C_word*)lf[251]+1 /* (set! set-signal-mask! ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5548,a[2]=((C_word)li131),tmp=(C_word)a,a+=3,tmp));
t100=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5597,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
t101=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_8691,a[2]=((C_word)li259),tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm:774: getter-with-setter */
t102=*((C_word*)lf[450]+1);{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=t102;
av2[1]=t100;
av2[2]=t101;
av2[3]=*((C_word*)lf[251]+1);
((C_proc)(void*)(*((C_word*)t102+1)))(4,av2);}}

/* current-process-id in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_4244(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_4244,2,av);}
t2=t1;{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=t2;
av2[1]=C_fudge(C_fix(33));
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* loop in k3457 in k3453 in k3450 in k3447 in k3432 in directory in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_fcall f_3473(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(6,0,4)))){
C_save_and_reclaim_args((void *)trf_3473,2,t0,t1);}
a=C_alloc(6);
t2=C_readdir(((C_word*)t0)[2],((C_word*)t0)[3]);
if(C_truep(C_null_pointerp(((C_word*)t0)[3]))){
t3=C_closedir(((C_word*)t0)[2]);
t4=t1;{
C_word av2[2];
av2[0]=t4;
av2[1]=C_SCHEME_END_OF_LIST;
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}
else{
t3=C_block_size(((C_word*)t0)[4]);
t4=C_foundfile(((C_word*)t0)[3],((C_word*)t0)[4],t3);
t5=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_3487,a[2]=t4,a[3]=((C_word*)t0)[5],a[4]=t1,a[5]=((C_word*)t0)[6],tmp=(C_word)a,a+=6,tmp);
/* posix-common.scm:485: ##sys#substring */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[70]+1));
C_word av2[5];
av2[0]=*((C_word*)lf[70]+1);
av2[1]=t5;
av2[2]=((C_word*)t0)[4];
av2[3]=C_fix(0);
av2[4]=t4;
tp(5,av2);}}}

/* k7850 in get-host-name in k6200 in k6169 in k5687 in k5683 in k5679 in k5675 in k5595 in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_7852(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,4)))){
C_save_and_reclaim((void *)f_7852,2,av);}
a=C_alloc(4);
t2=t1;
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_7855,a[2]=((C_word*)t0)[2],a[3]=t2,tmp=(C_word)a,a+=4,tmp);
if(C_truep(t2)){
t4=((C_word*)t0)[2];{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=t4;
av2[1]=t2;
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}
else{
/* posixunix.scm:1540: posix-error */
t4=lf[0];{
C_word *av2;
if(c >= 5) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(5);
}
av2[0]=t4;
av2[1]=t3;
av2[2]=lf[417];
av2[3]=lf[421];
av2[4]=lf[422];
f_2704(5,av2);}}}

/* k7853 in k7850 in get-host-name in k6200 in k6169 in k5687 in k5683 in k5679 in k5675 in k5595 in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_7855(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_7855,2,av);}
t2=((C_word*)t0)[2];{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=t2;
av2[1]=((C_word*)t0)[3];
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* k5294 in open-input-pipe in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_5296(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(2,c,5)))){
C_save_and_reclaim((void *)f_5296,2,av);}
a=C_alloc(2);
t2=open_text_input_pipe(&a,1,t1);
/* posixunix.scm:617: check */
f_5260(((C_word*)t0)[3],lf[206],((C_word*)t0)[4],C_SCHEME_TRUE,t2);}

/* parent-process-id in k6200 in k6169 in k5687 in k5683 in k5679 in k5675 in k5595 in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_8053(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_8053,2,av);}
t2=t1;{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=t2;
av2[1]=stub1957(C_SCHEME_UNDEFINED);
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* sleep in k6200 in k6169 in k5687 in k5683 in k5679 in k5675 in k5595 in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_8056(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_8056,3,av);}
t3=C_i_foreign_fixnum_argumentp(t2);
t4=t1;{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=t4;
av2[1]=stub1961(C_SCHEME_UNDEFINED,t3);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* k3497 in k3485 in loop in k3457 in k3453 in k3450 in k3447 in k3432 in directory in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_fcall f_3499(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,0,2)))){
C_save_and_reclaim_args((void *)trf_3499,2,t0,t1);}
a=C_alloc(4);
if(C_truep(t1)){
/* posix-common.scm:492: loop */
t2=((C_word*)((C_word*)t0)[2])[1];
f_3473(t2,((C_word*)t0)[3]);}
else{
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3509,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],tmp=(C_word)a,a+=4,tmp);
/* posix-common.scm:493: loop */
t3=((C_word*)((C_word*)t0)[2])[1];
f_3473(t3,t2);}}

/* process-fork in k6200 in k6169 in k5687 in k5683 in k5679 in k5675 in k5595 in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_7862(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand((c-2)*C_SIZEOF_PAIR +6,c,4)))){
C_save_and_reclaim((void*)f_7862,c,av);}
a=C_alloc((c-2)*C_SIZEOF_PAIR+6);
t2=C_build_rest(&a,c,2,av);
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word t17;
C_word t18;
t3=C_i_nullp(t2);
t4=(C_truep(t3)?C_SCHEME_FALSE:C_i_car(t2));
t5=t4;
t6=C_i_nullp(t2);
t7=(C_truep(t6)?C_SCHEME_END_OF_LIST:C_i_cdr(t2));
t8=C_i_nullp(t7);
t9=(C_truep(t8)?C_SCHEME_FALSE:C_i_car(t7));
t10=t9;
t11=C_i_nullp(t7);
t12=(C_truep(t11)?C_SCHEME_END_OF_LIST:C_i_cdr(t7));
t13=stub1911(C_SCHEME_UNDEFINED,C_SCHEME_FALSE);
t14=stub1891(C_SCHEME_UNDEFINED);
t15=t14;
t16=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_7893,a[2]=t5,a[3]=t15,a[4]=t10,a[5]=t1,tmp=(C_word)a,a+=6,tmp);
t17=C_eqp(C_fix(-1),t15);
if(C_truep(t17)){
/* posixunix.scm:1553: posix-error */
t18=lf[0];{
C_word *av2;
if(c >= 5) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(5);
}
av2[0]=t18;
av2[1]=t16;
av2[2]=lf[127];
av2[3]=lf[423];
av2[4]=lf[426];
f_2704(5,av2);}}
else{
t18=t16;{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=t18;
av2[1]=C_SCHEME_UNDEFINED;
f_7893(2,av2);}}}

/* input-port in k6200 in k6169 in k5687 in k5683 in k5679 in k5675 in k5595 in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_fcall f_8300(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6){
C_word tmp;
C_word t7;
C_word t8;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(6,0,3)))){
C_save_and_reclaim_args((void *)trf_8300,7,t0,t1,t2,t3,t4,t5,t6);}
a=C_alloc(6);
t7=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_8304,a[2]=t1,a[3]=t2,a[4]=t3,a[5]=t6,tmp=(C_word)a,a+=6,tmp);
/* posixunix.scm:1689: connect-parent */
f_8214(t7,t4,t5);}

/* k8302 in input-port in k6200 in k6169 in k5687 in k5683 in k5679 in k5675 in k5595 in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_8304(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,7)))){
C_save_and_reclaim((void *)f_8304,2,av);}
if(C_truep(t1)){
/* posixunix.scm:1690: ##sys#custom-input-port */
t2=*((C_word*)lf[345]+1);{
C_word *av2;
if(c >= 8) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(8);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[2];
av2[2]=((C_word*)t0)[3];
av2[3]=((C_word*)t0)[4];
av2[4]=t1;
av2[5]=C_SCHEME_TRUE;
av2[6]=C_fix(256);
av2[7]=((C_word*)t0)[5];
((C_proc)(void*)(*((C_word*)t2+1)))(8,av2);}}
else{
t2=((C_word*)t0)[2];{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=t2;
av2[1]=C_SCHEME_FALSE;
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}}

/* ##sys#process in k6200 in k6169 in k5687 in k5683 in k5679 in k5675 in k5595 in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_8322(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4=av[4];
C_word t5=av[5];
C_word t6=av[6];
C_word t7=av[7];
C_word t8=av[8];
C_word t9;
C_word t10;
C_word t11;
C_word *a;
if(c!=9) C_bad_argc_2(c,9,t0);
if(C_unlikely(!C_demand(C_calculate_demand(21,c,6)))){
C_save_and_reclaim((void *)f_8322,9,av);}
a=C_alloc(21);
t9=(*a=C_CLOSURE_TYPE|9,a[1]=(C_word)f_8328,a[2]=((C_word*)t0)[2],a[3]=t3,a[4]=t4,a[5]=t5,a[6]=t6,a[7]=t7,a[8]=t8,a[9]=((C_word)li236),tmp=(C_word)a,a+=10,tmp);
t10=(*a=C_CLOSURE_TYPE|10,a[1]=(C_word)f_8334,a[2]=t7,a[3]=t6,a[4]=t8,a[5]=((C_word*)t0)[3],a[6]=t2,a[7]=t3,a[8]=((C_word*)t0)[4],a[9]=((C_word*)t0)[5],a[10]=((C_word)li237),tmp=(C_word)a,a+=11,tmp);
/* posixunix.scm:1637: ##sys#call-with-values */{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=0;
av2[1]=t1;
av2[2]=t9;
av2[3]=t10;
C_call_with_values(4,av2);}}

/* a8327 in process in k6200 in k6169 in k5687 in k5683 in k5679 in k5675 in k5595 in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_8328(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,7)))){
C_save_and_reclaim((void *)f_8328,2,av);}
/* posixunix.scm:1697: spawn */
t2=((C_word*)t0)[2];
f_8255(t2,t1,((C_word*)t0)[3],((C_word*)t0)[4],((C_word*)t0)[5],((C_word*)t0)[6],((C_word*)t0)[7],((C_word*)t0)[8]);}

/* k7470 in map-file-to-memory in k6200 in k6169 in k5687 in k5683 in k5679 in k5675 in k5595 in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_7472(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(8,c,2)))){
C_save_and_reclaim((void *)f_7472,2,av);}
a=C_alloc(8);
t2=t1;
t3=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_7475,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=t2,a[7]=((C_word*)t0)[6],tmp=(C_word)a,a+=8,tmp);
if(C_truep(C_i_pairp(((C_word*)t0)[7]))){
t4=((C_word*)t0)[7];
t5=t3;
f_7475(t5,C_u_i_car(t4));}
else{
t4=t3;
f_7475(t4,C_fix(0));}}

/* k8090 in shell-command in k6200 in k6169 in k5687 in k5683 in k5679 in k5675 in k5595 in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_8092(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_8092,2,av);}
if(C_truep(t1)){
t2=t1;
t3=((C_word*)t0)[2];{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=t3;
av2[1]=t2;
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}
else{
t2=((C_word*)t0)[2];{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=t2;
av2[1]=lf[434];
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}}

/* map-file-to-memory in k6200 in k6169 in k5687 in k5683 in k5679 in k5675 in k5595 in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_7468(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4=av[4];
C_word t5=av[5];
C_word t6=av[6];
C_word t7;
C_word *a;
if(c<7) C_bad_min_argc_2(c,7,t0);
if(C_unlikely(!C_demand(C_calculate_demand((c-7)*C_SIZEOF_PAIR +8,c,2)))){
C_save_and_reclaim((void*)f_7468,c,av);}
a=C_alloc((c-7)*C_SIZEOF_PAIR+8);
t7=C_build_rest(&a,c,7,av);
C_word t8;
C_word t9;
C_word t10;
t8=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_7472,a[2]=t3,a[3]=t4,a[4]=t5,a[5]=t6,a[6]=t1,a[7]=t7,tmp=(C_word)a,a+=8,tmp);
t9=t2;
if(C_truep(t9)){
t10=t8;{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=t10;
av2[1]=t2;
f_7472(2,av2);}}
else{
/* posixunix.scm:1414: ##sys#null-pointer */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[393]+1));
C_word *av2=av; /* Re-use our own argvector */
av2[0]=*((C_word*)lf[393]+1);
av2[1]=t8;
tp(2,av2);}}}

/* output-port in k6200 in k6169 in k5687 in k5683 in k5679 in k5675 in k5595 in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_fcall f_8311(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6){
C_word tmp;
C_word t7;
C_word t8;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(6,0,3)))){
C_save_and_reclaim_args((void *)trf_8311,7,t0,t1,t2,t3,t4,t5,t6);}
a=C_alloc(6);
t7=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_8315,a[2]=t1,a[3]=t2,a[4]=t3,a[5]=t6,tmp=(C_word)a,a+=6,tmp);
/* posixunix.scm:1693: connect-parent */
f_8214(t7,t4,t5);}

/* k8313 in output-port in k6200 in k6169 in k5687 in k5683 in k5679 in k5675 in k5595 in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_8315(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,7)))){
C_save_and_reclaim((void *)f_8315,2,av);}
if(C_truep(t1)){
/* posixunix.scm:1694: ##sys#custom-output-port */
t2=*((C_word*)lf[359]+1);{
C_word *av2;
if(c >= 8) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(8);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[2];
av2[2]=((C_word*)t0)[3];
av2[3]=((C_word*)t0)[4];
av2[4]=t1;
av2[5]=C_SCHEME_TRUE;
av2[6]=C_fix(0);
av2[7]=((C_word*)t0)[5];
((C_proc)(void*)(*((C_word*)t2+1)))(8,av2);}}
else{
t2=((C_word*)t0)[2];{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=t2;
av2[1]=C_SCHEME_FALSE;
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}}

/* rmdir in delete-directory in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_fcall f_3233(C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,0,2)))){
C_save_and_reclaim_args((void *)trf_3233,2,t1,t2);}
a=C_alloc(4);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3237,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* posix-common.scm:430: ##sys#make-c-string */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[11]+1));
C_word av2[3];
av2[0]=*((C_word*)lf[11]+1);
av2[1]=t3;
av2[2]=t2;
tp(3,av2);}}

/* k7476 in k7473 in k7470 in map-file-to-memory in k6200 in k6169 in k5687 in k5683 in k5679 in k5675 in k5595 in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_7478(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word t17;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(21,c,2)))){
C_save_and_reclaim((void *)f_7478,2,av);}
a=C_alloc(21);
t2=((C_word*)t0)[2];
t3=((C_word*)t0)[3];
t4=((C_word*)t0)[4];
t5=((C_word*)t0)[5];
t6=C_a_i_bytevector(&a,1,C_fix(3));
t7=(C_truep(((C_word*)t0)[6])?C_i_foreign_pointer_argumentp(((C_word*)t0)[6]):C_SCHEME_FALSE);
t8=C_i_foreign_integer_argumentp(t2);
t9=C_i_foreign_fixnum_argumentp(t3);
t10=C_i_foreign_fixnum_argumentp(t4);
t11=C_i_foreign_fixnum_argumentp(t5);
t12=C_i_foreign_integer_argumentp(((C_word*)t0)[7]);
t13=stub1734(t6,t7,t8,t9,t10,t11,t12);
t14=t13;
t15=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_7484,a[2]=((C_word*)t0)[8],a[3]=t14,a[4]=((C_word*)t0)[2],tmp=(C_word)a,a+=5,tmp);
t16=(*a=C_CLOSURE_TYPE|10,a[1]=(C_word)f_7497,a[2]=t15,a[3]=((C_word*)t0)[6],a[4]=((C_word*)t0)[2],a[5]=((C_word*)t0)[3],a[6]=((C_word*)t0)[4],a[7]=((C_word*)t0)[5],a[8]=((C_word*)t0)[7],a[9]=((C_word*)t0)[8],a[10]=t14,tmp=(C_word)a,a+=11,tmp);
/* posixunix.scm:1419: ##sys#pointer->address */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[391]+1));
C_word *av2;
if(c >= 3) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(3);
}
av2[0]=*((C_word*)lf[391]+1);
av2[1]=t16;
av2[2]=t14;
tp(3,av2);}}

/* k7473 in k7470 in map-file-to-memory in k6200 in k6169 in k5687 in k5683 in k5679 in k5675 in k5595 in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_fcall f_7475(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(9,0,5)))){
C_save_and_reclaim_args((void *)trf_7475,2,t0,t1);}
a=C_alloc(9);
t2=t1;
t3=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_7478,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[6],a[7]=t2,a[8]=((C_word*)t0)[7],tmp=(C_word)a,a+=9,tmp);
if(C_truep(C_blockp(((C_word*)t0)[6]))){
if(C_truep(C_specialp(((C_word*)t0)[6]))){
t4=t3;{
C_word av2[2];
av2[0]=t4;
av2[1]=C_SCHEME_UNDEFINED;
f_7478(2,av2);}}
else{
/* posixunix.scm:1417: ##sys#signal-hook */
t4=*((C_word*)lf[1]+1);{
C_word av2[6];
av2[0]=t4;
av2[1]=t3;
av2[2]=lf[13];
av2[3]=lf[388];
av2[4]=lf[392];
av2[5]=((C_word*)t0)[6];
((C_proc)(void*)(*((C_word*)t4+1)))(6,av2);}}}
else{
/* posixunix.scm:1417: ##sys#signal-hook */
t4=*((C_word*)lf[1]+1);{
C_word av2[6];
av2[0]=t4;
av2[1]=t3;
av2[2]=lf[13];
av2[3]=lf[388];
av2[4]=lf[392];
av2[5]=((C_word*)t0)[6];
((C_proc)(void*)(*((C_word*)t4+1)))(6,av2);}}}

/* ##sys#shell-command-arguments in k6200 in k6169 in k5687 in k5683 in k5679 in k5675 in k5595 in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_8097(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(6,c,1)))){
C_save_and_reclaim((void *)f_8097,3,av);}
a=C_alloc(6);
t3=t1;{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=t3;
av2[1]=C_a_i_list2(&a,2,lf[438],t2);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* k8343 in a8333 in process in k6200 in k6169 in k5687 in k5683 in k5679 in k5675 in k5595 in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_8345(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(20,c,7)))){
C_save_and_reclaim((void *)f_8345,2,av);}
a=C_alloc(20);
t2=t1;
t3=(*a=C_CLOSURE_TYPE|11,a[1]=(C_word)f_8349,a[2]=((C_word*)t0)[2],a[3]=t2,a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],a[6]=((C_word*)t0)[5],a[7]=((C_word*)t0)[6],a[8]=((C_word*)t0)[7],a[9]=((C_word*)t0)[8],a[10]=((C_word*)t0)[9],a[11]=((C_word*)t0)[10],tmp=(C_word)a,a+=12,tmp);
t4=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_8361,a[2]=((C_word*)t0)[11],a[3]=t3,a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[6],a[6]=((C_word*)t0)[12],a[7]=((C_word*)t0)[13],tmp=(C_word)a,a+=8,tmp);
/* posixunix.scm:1706: make-on-close */
f_8157(t4,((C_word*)t0)[5],((C_word*)t0)[3],((C_word*)t0)[10],C_fix(1),C_fix(0),C_fix(2));}

/* k8347 in k8343 in a8333 in process in k6200 in k6169 in k5687 in k5683 in k5679 in k5675 in k5595 in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_8349(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(14,c,7)))){
C_save_and_reclaim((void *)f_8349,2,av);}
a=C_alloc(14);
t2=t1;
t3=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_8353,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t2,a[5]=((C_word*)t0)[4],tmp=(C_word)a,a+=6,tmp);
t4=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_8357,a[2]=((C_word*)t0)[5],a[3]=t3,a[4]=((C_word*)t0)[6],a[5]=((C_word*)t0)[7],a[6]=((C_word*)t0)[8],a[7]=((C_word*)t0)[9],tmp=(C_word)a,a+=8,tmp);
/* posixunix.scm:1709: make-on-close */
f_8157(t4,((C_word*)t0)[6],((C_word*)t0)[4],((C_word*)t0)[11],C_fix(2),C_fix(0),C_fix(1));}

/* k5387 in call-with-input-pipe in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_5389(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(9,c,3)))){
C_save_and_reclaim((void *)f_5389,2,av);}
a=C_alloc(9);
t2=t1;
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_5394,a[2]=((C_word*)t0)[2],a[3]=t2,a[4]=((C_word)li113),tmp=(C_word)a,a+=5,tmp);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5400,a[2]=t2,a[3]=((C_word)li114),tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm:653: ##sys#call-with-values */{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=0;
av2[1]=((C_word*)t0)[3];
av2[2]=t3;
av2[3]=t4;
C_call_with_values(4,av2);}}

/* call-with-input-pipe in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_5385(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c<4) C_bad_min_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand((c-4)*C_SIZEOF_PAIR +4,c,4)))){
C_save_and_reclaim((void*)f_5385,c,av);}
a=C_alloc((c-4)*C_SIZEOF_PAIR+4);
t4=C_build_rest(&a,c,4,av);
C_word t5;
C_word t6;
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5389,a[2]=t3,a[3]=t1,tmp=(C_word)a,a+=4,tmp);{
C_word *av2;
if(c >= 5) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(5);
}
av2[0]=0;
av2[1]=t5;
av2[2]=*((C_word*)lf[206]+1);
av2[3]=t2;
av2[4]=t4;
C_apply(5,av2);}}

/* a8333 in process in k6200 in k6169 in k5687 in k5683 in k5679 in k5675 in k5595 in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_8334(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4=av[4];
C_word t5=av[5];
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word *a;
if(c!=6) C_bad_argc_2(c,6,t0);
if(C_unlikely(!C_demand(C_calculate_demand(26,c,7)))){
C_save_and_reclaim((void *)f_8334,6,av);}
a=C_alloc(26);
t6=C_i_not(((C_word*)t0)[2]);
t7=C_i_not(((C_word*)t0)[3]);
t8=C_i_not(((C_word*)t0)[4]);
t9=C_a_i_vector3(&a,3,t6,t7,t8);
t10=t9;
t11=(*a=C_CLOSURE_TYPE|13,a[1]=(C_word)f_8345,a[2]=t1,a[3]=t5,a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[6],a[6]=((C_word*)t0)[7],a[7]=t4,a[8]=((C_word*)t0)[4],a[9]=((C_word*)t0)[8],a[10]=t10,a[11]=((C_word*)t0)[9],a[12]=t3,a[13]=((C_word*)t0)[3],tmp=(C_word)a,a+=14,tmp);
t12=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_8365,a[2]=((C_word*)t0)[5],a[3]=t11,a[4]=((C_word*)t0)[6],a[5]=((C_word*)t0)[7],a[6]=t2,a[7]=((C_word*)t0)[2],tmp=(C_word)a,a+=8,tmp);
/* posixunix.scm:1704: make-on-close */
f_8157(t12,((C_word*)t0)[6],t5,t10,C_fix(0),C_fix(1),C_fix(2));}

/* k3235 in rmdir in delete-directory in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_3237(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,5)))){
C_save_and_reclaim((void *)f_3237,2,av);}
t2=C_rmdir(t1);
t3=C_eqp(C_fix(0),t2);
if(C_truep(t3)){
t4=C_SCHEME_UNDEFINED;
t5=((C_word*)t0)[2];{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=t5;
av2[1]=t4;
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}
else{
/* posix-common.scm:432: posix-error */
t4=lf[0];{
C_word *av2;
if(c >= 6) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(6);
}
av2[0]=t4;
av2[1]=((C_word*)t0)[2];
av2[2]=lf[8];
av2[3]=lf[73];
av2[4]=lf[74];
av2[5]=((C_word*)t0)[3];
f_2704(6,av2);}}}

/* k5375 in close-output-pipe in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_5377(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_5377,2,av);}
t2=((C_word*)t0)[2];{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=t2;
av2[1]=((C_word*)t0)[3];
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* close-output-pipe in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_5370(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(4,c,5)))){
C_save_and_reclaim((void *)f_5370,3,av);}
a=C_alloc(4);
t3=t2;
t4=C_i_check_port_2(t3,C_SCHEME_FALSE,C_SCHEME_TRUE,lf[213]);
t5=close_pipe(t2);
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5377,a[2]=t1,a[3]=t5,tmp=(C_word)a,a+=4,tmp);
t7=C_eqp(C_fix(-1),t5);
if(C_truep(t7)){
/* posixunix.scm:647: posix-error */
t8=lf[0];{
C_word *av2;
if(c >= 6) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(6);
}
av2[0]=t8;
av2[1]=t6;
av2[2]=lf[8];
av2[3]=lf[213];
av2[4]=lf[214];
av2[5]=t2;
f_2704(6,av2);}}
else{
t8=t1;{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=t8;
av2[1]=t5;
((C_proc)(void*)(*((C_word*)t8+1)))(2,av2);}}}

/* k3265 in g289 in k3254 in delete-directory in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_3267(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(5,c,2)))){
C_save_and_reclaim((void *)f_3267,2,av);}
a=C_alloc(5);
if(C_truep(t1)){
t2=*((C_word*)lf[75]+1);
t3=*((C_word*)lf[75]+1);
/* posix-common.scm:440: g299 */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[75]+1));
C_word *av2;
if(c >= 3) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(3);
}
av2[0]=*((C_word*)lf[75]+1);
av2[1]=((C_word*)t0)[2];
av2[2]=((C_word*)t0)[3];
tp(3,av2);}}
else{
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3273,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],tmp=(C_word)a,a+=5,tmp);
/* posix-common.scm:442: directory? */
t3=*((C_word*)lf[37]+1);{
C_word *av2;
if(c >= 3) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(3);
}
av2[0]=t3;
av2[1]=t2;
av2[2]=((C_word*)t0)[3];
((C_proc)(void*)(*((C_word*)t3+1)))(3,av2);}}}

/* k3410 in k3327 in create-directory in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_3412(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,5)))){
C_save_and_reclaim((void *)f_3412,2,av);}
t2=C_mkdir(t1);
t3=C_eqp(C_fix(0),t2);
if(C_truep(t3)){
t4=C_SCHEME_UNDEFINED;
t5=((C_word*)t0)[2];{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=t5;
av2[1]=t4;
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}
else{
/* posix-common.scm:451: posix-error */
t4=lf[0];{
C_word *av2;
if(c >= 6) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(6);
}
av2[0]=t4;
av2[1]=((C_word*)t0)[2];
av2[2]=lf[8];
av2[3]=lf[79];
av2[4]=lf[80];
av2[5]=((C_word*)t0)[3];
f_2704(6,av2);}}}

/* g289 in k3254 in delete-directory in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_fcall f_3257(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(5,0,2)))){
C_save_and_reclaim_args((void *)trf_3257,3,t0,t1,t2);}
a=C_alloc(5);
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3267,a[2]=t1,a[3]=t2,a[4]=((C_word*)t0)[2],tmp=(C_word)a,a+=5,tmp);
/* posix-common.scm:441: symbolic-link? */
t4=*((C_word*)lf[32]+1);{
C_word av2[3];
av2[0]=t4;
av2[1]=t3;
av2[2]=t2;
((C_proc)(void*)(*((C_word*)t4+1)))(3,av2);}}

/* k3254 in delete-directory in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_3256(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(16,c,3)))){
C_save_and_reclaim((void *)f_3256,2,av);}
a=C_alloc(16);
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3257,a[2]=((C_word*)t0)[2],a[3]=((C_word)li25),tmp=(C_word)a,a+=4,tmp);
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3276,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],tmp=(C_word)a,a+=5,tmp);
t4=C_SCHEME_UNDEFINED;
t5=(*a=C_VECTOR_TYPE|1,a[1]=t4,tmp=(C_word)a,a+=2,tmp);
t6=C_set_block_item(t5,0,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3281,a[2]=t5,a[3]=t2,a[4]=((C_word)li26),tmp=(C_word)a,a+=5,tmp));
t7=((C_word*)t5)[1];
f_3281(t7,t3,t1);}

/* k4380 in doloop683 in tmp12594 in a4357 in a4336 in k4327 in list->c-string-buffer in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_4382(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(13,c,3)))){
C_save_and_reclaim((void *)f_4382,2,av);}
a=C_alloc(13);
t2=C_a_i_bytevector(&a,1,C_fix(3));
t3=stub665(t2,t1);
t4=t3;
t5=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_4388,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[6],a[7]=t4,tmp=(C_word)a,a+=8,tmp);
if(C_truep(t4)){
t6=t5;{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=t6;
av2[1]=C_SCHEME_UNDEFINED;
f_4388(2,av2);}}
else{
/* posix-common.scm:713: error */
t6=*((C_word*)lf[133]+1);{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=t6;
av2[1]=t5;
av2[2]=((C_word*)t0)[7];
av2[3]=lf[134];
((C_proc)(void*)(*((C_word*)t6+1)))(4,av2);}}}

/* k6397 in k6391 in custom-input-port in k6200 in k6169 in k5687 in k5683 in k5679 in k5675 in k5595 in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_6399(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word t17;
C_word t18;
C_word t19;
C_word t20;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(81,c,8)))){
C_save_and_reclaim((void *)f_6399,2,av);}
a=C_alloc(81);
t2=t1;
t3=C_fix(0);
t4=(*a=C_VECTOR_TYPE|1,a[1]=t3,tmp=(C_word)a,a+=2,tmp);
t5=C_fix(0);
t6=(*a=C_VECTOR_TYPE|1,a[1]=t5,tmp=(C_word)a,a+=2,tmp);
t7=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_6400,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word)li160),tmp=(C_word)a,a+=6,tmp);
t8=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_6429,a[2]=t6,a[3]=t4,a[4]=t2,tmp=(C_word)a,a+=5,tmp);
t9=(*a=C_CLOSURE_TYPE|10,a[1]=(C_word)f_6437,a[2]=((C_word*)t0)[3],a[3]=t2,a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[2],a[6]=((C_word*)t0)[4],a[7]=((C_word*)t0)[6],a[8]=t4,a[9]=t6,a[10]=((C_word)li162),tmp=(C_word)a,a+=11,tmp);
t10=C_SCHEME_UNDEFINED;
t11=(*a=C_VECTOR_TYPE|1,a[1]=t10,tmp=(C_word)a,a+=2,tmp);
t12=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_6533,a[2]=t11,a[3]=((C_word*)t0)[7],a[4]=((C_word*)t0)[4],tmp=(C_word)a,a+=5,tmp);
t13=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_6539,a[2]=t8,a[3]=t6,a[4]=t4,a[5]=t9,a[6]=((C_word)li163),tmp=(C_word)a,a+=7,tmp);
t14=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_6564,a[2]=t6,a[3]=t4,a[4]=t7,a[5]=((C_word)li164),tmp=(C_word)a,a+=6,tmp);
t15=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_6576,a[2]=t11,a[3]=((C_word*)t0)[8],a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[2],a[6]=((C_word*)t0)[4],a[7]=((C_word)li165),tmp=(C_word)a,a+=8,tmp);
t16=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_6598,a[2]=t8,a[3]=t6,a[4]=t4,a[5]=t9,a[6]=((C_word)li166),tmp=(C_word)a,a+=7,tmp);
t17=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_6613,a[2]=t6,a[3]=t4,a[4]=t2,a[5]=t9,a[6]=((C_word)li168),tmp=(C_word)a,a+=7,tmp);
t18=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_6689,a[2]=t6,a[3]=t4,a[4]=t2,a[5]=t9,a[6]=((C_word)li172),tmp=(C_word)a,a+=7,tmp);
t19=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_6812,a[2]=t6,a[3]=t4,a[4]=t2,a[5]=((C_word)li173),tmp=(C_word)a,a+=6,tmp);
/* posixunix.scm:1173: make-input-port */
t20=*((C_word*)lf[358]+1);{
C_word *av2;
if(c >= 9) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(9);
}
av2[0]=t20;
av2[1]=t12;
av2[2]=t13;
av2[3]=t14;
av2[4]=t15;
av2[5]=t16;
av2[6]=t17;
av2[7]=t18;
av2[8]=t19;
((C_proc)(void*)(*((C_word*)t20+1)))(9,av2);}}

/* k6391 in custom-input-port in k6200 in k6169 in k5687 in k5683 in k5679 in k5675 in k5595 in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_6393(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(9,c,2)))){
C_save_and_reclaim((void *)f_6393,2,av);}
a=C_alloc(9);
t2=C_fixnump(((C_word*)t0)[2]);
t3=(C_truep(t2)?((C_word*)t0)[2]:C_block_size(((C_word*)t0)[2]));
t4=t3;
t5=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_6399,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=t4,a[6]=((C_word*)t0)[6],a[7]=((C_word*)t0)[7],a[8]=((C_word*)t0)[8],tmp=(C_word)a,a+=9,tmp);
if(C_truep(C_fixnump(((C_word*)t0)[2]))){
/* posixunix.scm:1124: ##sys#make-string */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[72]+1));
C_word *av2;
if(c >= 3) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(3);
}
av2[0]=*((C_word*)lf[72]+1);
av2[1]=t5;
av2[2]=((C_word*)t0)[2];
tp(3,av2);}}
else{
t6=t5;{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=t6;
av2[1]=((C_word*)t0)[2];
f_6399(2,av2);}}}

/* k4386 in k4380 in doloop683 in tmp12594 in a4357 in a4336 in k4327 in list->c-string-buffer in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_4388(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(6,c,4)))){
C_save_and_reclaim((void *)f_4388,2,av);}
a=C_alloc(6);
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_4391,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],tmp=(C_word)a,a+=6,tmp);
/* posix-common.scm:714: pointer-vector-set! */
t3=*((C_word*)lf[132]+1);{
C_word *av2;
if(c >= 5) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(5);
}
av2[0]=t3;
av2[1]=t2;
av2[2]=((C_word*)t0)[6];
av2[3]=((C_word*)t0)[3];
av2[4]=((C_word*)t0)[7];
((C_proc)(void*)(*((C_word*)t3+1)))(5,av2);}}

/* ##sys#shell-command in k6200 in k6169 in k5687 in k5683 in k5679 in k5675 in k5595 in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_8088(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(C_unlikely(!C_demand(C_calculate_demand(3,c,2)))){
C_save_and_reclaim((void *)f_8088,2,av);}
a=C_alloc(3);
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_8092,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm:1603: get-environment-variable */
t3=*((C_word*)lf[435]+1);{
C_word *av2;
if(c >= 3) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(3);
}
av2[0]=t3;
av2[1]=t2;
av2[2]=lf[436];
((C_proc)(void*)(*((C_word*)t3+1)))(3,av2);}}

/* a8801 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_8802(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(3,c,5)))){
C_save_and_reclaim((void *)f_8802,3,av);}
a=C_alloc(3);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_8806,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posix-common.scm:254: ##sys#stat */
f_2722(t3,t2,C_SCHEME_FALSE,C_SCHEME_TRUE,lf[17]);}

/* a8807 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_8808(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(9,c,2)))){
C_save_and_reclaim((void *)f_8808,4,av);}
a=C_alloc(9);
t4=C_i_check_number_2(t3,lf[467]);
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_8828,a[2]=t1,a[3]=t2,a[4]=t3,tmp=(C_word)a,a+=5,tmp);
t6=t5;
t7=t2;
t8=t3;
t9=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_8818,a[2]=t6,a[3]=t8,tmp=(C_word)a,a+=4,tmp);
if(C_truep(t7)){
t10=C_i_foreign_string_argumentp(t7);
/* posix-common.scm:257: ##sys#make-c-string */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[11]+1));
C_word *av2=av; /* Re-use our own argvector */
av2[0]=*((C_word*)lf[11]+1);
av2[1]=t9;
av2[2]=t10;
tp(3,av2);}}
else{
t10=t6;{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=t10;
av2[1]=stub119(C_SCHEME_UNDEFINED,C_SCHEME_FALSE,t8);
((C_proc)(void*)(*((C_word*)t10+1)))(2,av2);}}}

/* k8804 in a8801 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_8806(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,1)))){
C_save_and_reclaim((void *)f_8806,2,av);}
a=C_alloc(4);
t2=((C_word*)t0)[2];{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=t2;
av2[1]=C_flonum(&a,C_statbuf.st_mtime);
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* k4389 in k4386 in k4380 in doloop683 in tmp12594 in a4357 in a4336 in k4327 in list->c-string-buffer in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_4391(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,3)))){
C_save_and_reclaim((void *)f_4391,2,av);}
t2=((C_word*)t0)[2];
t3=C_u_i_cdr(t2);
t4=C_fixnum_plus(((C_word*)t0)[3],C_fix(1));
t5=((C_word*)((C_word*)t0)[4])[1];
f_4366(t5,((C_word*)t0)[5],t3,t4);}

/* mode in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_fcall f_3038(C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,0,3)))){
C_save_and_reclaim_args((void *)trf_3038,4,t1,t2,t3,t4);}
a=C_alloc(4);
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3046,a[2]=t1,a[3]=t4,tmp=(C_word)a,a+=4,tmp);
if(C_truep(C_i_pairp(t3))){
t6=t3;
t7=C_u_i_car(t6);
t8=C_eqp(t7,lf[49]);
if(C_truep(t8)){
t9=t2;
if(C_truep(t9)){
/* posix-common.scm:363: ##sys#error */
t10=*((C_word*)lf[50]+1);{
C_word av2[4];
av2[0]=t10;
av2[1]=t5;
av2[2]=lf[51];
av2[3]=t7;
((C_proc)(void*)(*((C_word*)t10+1)))(4,av2);}}
else{
/* posix-common.scm:359: ##sys#make-c-string */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[11]+1));
C_word av2[4];
av2[0]=*((C_word*)lf[11]+1);
av2[1]=t1;
av2[2]=lf[52];
av2[3]=t4;
tp(4,av2);}}}
else{
/* posix-common.scm:364: ##sys#error */
t9=*((C_word*)lf[50]+1);{
C_word av2[4];
av2[0]=t9;
av2[1]=t5;
av2[2]=lf[53];
av2[3]=t7;
((C_proc)(void*)(*((C_word*)t9+1)))(4,av2);}}}
else{
if(C_truep(t2)){
/* posix-common.scm:359: ##sys#make-c-string */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[11]+1));
C_word av2[4];
av2[0]=*((C_word*)lf[11]+1);
av2[1]=t1;
av2[2]=lf[54];
av2[3]=t4;
tp(4,av2);}}
else{
/* posix-common.scm:359: ##sys#make-c-string */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[11]+1));
C_word av2[4];
av2[0]=*((C_word*)lf[11]+1);
av2[1]=t1;
av2[2]=lf[55];
av2[3]=t4;
tp(4,av2);}}}}

/* k8826 in a8807 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_8828(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,6)))){
C_save_and_reclaim((void *)f_8828,2,av);}
if(C_truep(C_fixnum_lessp(t1,C_fix(0)))){
/* posix-common.scm:260: posix-error */
t2=lf[0];{
C_word *av2;
if(c >= 7) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(7);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[2];
av2[2]=lf[8];
av2[3]=lf[467];
av2[4]=lf[468];
av2[5]=((C_word*)t0)[3];
av2[6]=((C_word*)t0)[4];
f_2704(7,av2);}}
else{
t2=C_SCHEME_UNDEFINED;
t3=((C_word*)t0)[2];{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=t3;
av2[1]=t2;
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}}

/* k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_3033(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word t17;
C_word t18;
C_word t19;
C_word t20;
C_word t21;
C_word t22;
C_word t23;
C_word t24;
C_word t25;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(53,c,6)))){
C_save_and_reclaim((void *)f_3033,2,av);}
a=C_alloc(53);
t2=C_mutate2((C_word*)lf[45]+1 /* (set! file-position ...) */,t1);
t3=C_mutate2((C_word*)lf[46]+1 /* (set! fileno/stdin ...) */,C_fix((C_word)STDIN_FILENO));
t4=C_mutate2((C_word*)lf[47]+1 /* (set! fileno/stdout ...) */,C_fix((C_word)STDOUT_FILENO));
t5=C_mutate2((C_word*)lf[48]+1 /* (set! fileno/stderr ...) */,C_fix((C_word)STDERR_FILENO));
t6=C_SCHEME_UNDEFINED;
t7=(*a=C_VECTOR_TYPE|1,a[1]=t6,tmp=(C_word)a,a+=2,tmp);
t8=C_SCHEME_UNDEFINED;
t9=(*a=C_VECTOR_TYPE|1,a[1]=t8,tmp=(C_word)a,a+=2,tmp);
t10=C_set_block_item(t7,0,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3038,a[2]=((C_word)li17),tmp=(C_word)a,a+=3,tmp));
t11=C_set_block_item(t9,0,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3075,a[2]=((C_word)li18),tmp=(C_word)a,a+=3,tmp));
t12=C_mutate2((C_word*)lf[60]+1 /* (set! open-input-file* ...) */,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3090,a[2]=t9,a[3]=t7,a[4]=((C_word)li19),tmp=(C_word)a,a+=5,tmp));
t13=C_mutate2((C_word*)lf[61]+1 /* (set! open-output-file* ...) */,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3104,a[2]=t9,a[3]=t7,a[4]=((C_word)li20),tmp=(C_word)a,a+=5,tmp));
t14=C_mutate2((C_word*)lf[10]+1 /* (set! port->fileno ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3118,a[2]=((C_word)li21),tmp=(C_word)a,a+=3,tmp));
t15=C_mutate2((C_word*)lf[66]+1 /* (set! duplicate-fileno ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3166,a[2]=((C_word)li22),tmp=(C_word)a,a+=3,tmp));
t16=C_mutate2((C_word*)lf[68]+1 /* (set! current-directory ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3193,a[2]=((C_word)li23),tmp=(C_word)a,a+=3,tmp));
t17=C_mutate2((C_word*)lf[73]+1 /* (set! delete-directory ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3227,a[2]=((C_word)li27),tmp=(C_word)a,a+=3,tmp));
t18=C_mutate2((C_word*)lf[79]+1 /* (set! create-directory ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3313,a[2]=((C_word)li31),tmp=(C_word)a,a+=3,tmp));
t19=C_mutate2((C_word*)lf[26]+1 /* (set! directory ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3430,a[2]=((C_word)li33),tmp=(C_word)a,a+=3,tmp));
t20=C_mutate2((C_word*)lf[87]+1 /* (set! glob ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3569,a[2]=((C_word)li39),tmp=(C_word)a,a+=3,tmp));
t21=C_mutate2((C_word*)lf[76]+1 /* (set! find-files ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3855,a[2]=((C_word)li55),tmp=(C_word)a,a+=3,tmp));
t22=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3906,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
t23=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_8734,a[2]=((C_word)li261),tmp=(C_word)a,a+=3,tmp);
t24=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_8759,a[2]=((C_word)li262),tmp=(C_word)a,a+=3,tmp);
/* posix-common.scm:564: getter-with-setter */
t25=*((C_word*)lf[450]+1);{
C_word *av2;
if(c >= 5) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(5);
}
av2[0]=t25;
av2[1]=t22;
av2[2]=t23;
av2[3]=t24;
av2[4]=lf[463];
((C_proc)(void*)(*((C_word*)t25+1)))(5,av2);}}

/* k8816 in a8807 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_8818(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_8818,2,av);}
t2=((C_word*)t0)[2];{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=t2;
av2[1]=stub119(C_SCHEME_UNDEFINED,t1,((C_word*)t0)[3]);
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* k6735 in a6716 in a6706 in k6700 in k6691 in a6688 in k6397 in k6391 in custom-input-port in k6200 in k6169 in k5687 in k5683 in k5679 in k5675 in k5595 in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in ... */
static void C_ccall f_6737(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,4)))){
C_save_and_reclaim((void *)f_6737,2,av);}
if(C_truep(C_fixnum_lessp(((C_word*)((C_word*)t0)[2])[1],((C_word*)((C_word*)t0)[3])[1]))){
t2=C_fixnum_plus(((C_word*)((C_word*)t0)[2])[1],((C_word*)((C_word*)t0)[4])[1]);
t3=C_i_fixnum_min(((C_word*)((C_word*)t0)[3])[1],t2);
/* posixunix.scm:1226: values */{
C_word *av2;
if(c >= 5) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(5);
}
av2[0]=0;
av2[1]=((C_word*)t0)[5];
av2[2]=((C_word*)t0)[6];
av2[3]=((C_word*)((C_word*)t0)[2])[1];
av2[4]=t3;
C_values(5,av2);}}
else{
/* posixunix.scm:1229: values */{
C_word *av2;
if(c >= 5) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(5);
}
av2[0]=0;
av2[1]=((C_word*)t0)[5];
av2[2]=C_SCHEME_FALSE;
av2[3]=((C_word*)((C_word*)t0)[2])[1];
av2[4]=C_SCHEME_FALSE;
C_values(5,av2);}}}

/* k5304 in open-input-pipe in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_5306(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(2,c,5)))){
C_save_and_reclaim((void *)f_5306,2,av);}
a=C_alloc(2);
t2=open_binary_input_pipe(&a,1,t1);
/* posixunix.scm:617: check */
f_5260(((C_word*)t0)[3],lf[206],((C_word*)t0)[4],C_SCHEME_TRUE,t2);}

/* k3004 in k2986 in set-file-position! in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_3006(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,5)))){
C_save_and_reclaim((void *)f_3006,2,av);}
if(C_truep(t1)){
t2=C_slot(((C_word*)t0)[2],C_fix(7));
t3=C_eqp(t2,lf[43]);
if(C_truep(t3)){
t4=C_fseek(((C_word*)t0)[2],((C_word*)t0)[3],((C_word*)t0)[4]);
t5=((C_word*)t0)[5];{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=t5;
av2[1]=t4;
f_3000(2,av2);}}
else{
t4=((C_word*)t0)[5];{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=t4;
av2[1]=C_SCHEME_FALSE;
f_3000(2,av2);}}}
else{
if(C_truep(C_fixnump(((C_word*)t0)[2]))){
t2=C_lseek(((C_word*)t0)[2],((C_word*)t0)[3],((C_word*)t0)[4]);
t3=((C_word*)t0)[5];{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=t3;
av2[1]=t2;
f_3000(2,av2);}}
else{
/* posix-common.scm:326: ##sys#signal-hook */
t2=*((C_word*)lf[1]+1);{
C_word *av2;
if(c >= 6) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(6);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[5];
av2[2]=lf[13];
av2[3]=lf[41];
av2[4]=lf[44];
av2[5]=((C_word*)t0)[2];
((C_proc)(void*)(*((C_word*)t2+1)))(6,av2);}}}}

/* a6716 in a6706 in k6700 in k6691 in a6688 in k6397 in k6391 in custom-input-port in k6200 in k6169 in k5687 in k5683 in k5679 in k5675 in k5595 in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in ... */
static void C_ccall f_6717(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(7,c,4)))){
C_save_and_reclaim((void *)f_6717,3,av);}
a=C_alloc(7);
t3=C_fixnum_difference(t2,((C_word*)((C_word*)t0)[2])[1]);
if(C_truep(C_fixnum_greater_or_equal_p(t3,((C_word*)((C_word*)t0)[3])[1]))){
/* posixunix.scm:1221: values */{
C_word *av2;
if(c >= 5) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(5);
}
av2[0]=0;
av2[1]=t1;
av2[2]=C_SCHEME_FALSE;
av2[3]=t2;
av2[4]=C_SCHEME_FALSE;
C_values(5,av2);}}
else{
t4=C_fixnum_difference(((C_word*)((C_word*)t0)[3])[1],t3);
t5=C_set_block_item(((C_word*)t0)[3],0,t4);
t6=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_6737,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[3],a[5]=t1,a[6]=((C_word*)t0)[5],tmp=(C_word)a,a+=7,tmp);
/* posixunix.scm:1224: fetch */
t7=((C_word*)t0)[6];
f_6437(t7,t6);}}

/* k2998 in k2986 in set-file-position! in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_3000(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,6)))){
C_save_and_reclaim((void *)f_3000,2,av);}
if(C_truep(t1)){
t2=C_SCHEME_UNDEFINED;
t3=((C_word*)t0)[2];{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=t3;
av2[1]=t2;
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}
else{
/* posix-common.scm:327: posix-error */
t2=lf[0];{
C_word *av2;
if(c >= 7) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(7);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[2];
av2[2]=lf[8];
av2[3]=lf[41];
av2[4]=lf[42];
av2[5]=((C_word*)t0)[3];
av2[6]=((C_word*)t0)[4];
f_2704(7,av2);}}}

/* check in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_fcall f_3075(C_word t1,C_word t2,C_word t3,C_word t4,C_word t5){
C_word tmp;
C_word t6;
C_word t7;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,0,5)))){
C_save_and_reclaim_args((void *)trf_3075,5,t1,t2,t3,t4,t5);}
a=C_alloc(4);
if(C_truep(C_null_pointerp(t5))){
/* posix-common.scm:370: posix-error */
t6=lf[0];{
C_word av2[6];
av2[0]=t6;
av2[1]=t1;
av2[2]=lf[8];
av2[3]=t2;
av2[4]=lf[56];
av2[5]=t3;
f_2704(6,av2);}}
else{
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3088,a[2]=t5,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* posix-common.scm:371: ##sys#make-port */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[57]+1));
C_word av2[6];
av2[0]=*((C_word*)lf[57]+1);
av2[1]=t6;
av2[2]=t4;
av2[3]=*((C_word*)lf[58]+1);
av2[4]=lf[59];
av2[5]=lf[43];
tp(6,av2);}}}

/* k5327 in open-output-pipe in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_5329(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,5)))){
C_save_and_reclaim((void *)f_5329,2,av);}
/* posixunix.scm:628: check */
f_5260(((C_word*)t0)[3],lf[210],((C_word*)t0)[4],C_SCHEME_FALSE,t1);}

/* a5393 in k5387 in call-with-input-pipe in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_5394(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,2)))){
C_save_and_reclaim((void *)f_5394,2,av);}
/* posixunix.scm:654: proc */
t2=((C_word*)t0)[2];{
C_word *av2;
if(c >= 3) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(3);
}
av2[0]=t2;
av2[1]=t1;
av2[2]=((C_word*)t0)[3];
((C_proc)C_fast_retrieve_proc(t2))(3,av2);}}

/* k6700 in k6691 in a6688 in k6397 in k6391 in custom-input-port in k6200 in k6169 in k5687 in k5683 in k5679 in k5675 in k5595 in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in ... */
static void C_fcall f_6702(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(15,0,5)))){
C_save_and_reclaim_args((void *)trf_6702,2,t0,t1);}
a=C_alloc(15);
t2=t1;
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_6707,a[2]=((C_word*)t0)[2],a[3]=t3,a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],a[6]=((C_word*)t0)[5],a[7]=((C_word)li170),tmp=(C_word)a,a+=8,tmp);
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_6763,a[2]=((C_word*)t0)[6],a[3]=((C_word*)t0)[2],a[4]=((C_word)li171),tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm:1212: ##sys#call-with-values */{
C_word av2[4];
av2[0]=0;
av2[1]=((C_word*)t0)[7];
av2[2]=t4;
av2[3]=t5;
C_call_with_values(4,av2);}}

/* a6706 in k6700 in k6691 in a6688 in k6397 in k6391 in custom-input-port in k6200 in k6169 in k5687 in k5683 in k5679 in k5675 in k5595 in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in ... */
static void C_ccall f_6707(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(C_unlikely(!C_demand(C_calculate_demand(8,c,5)))){
C_save_and_reclaim((void *)f_6707,2,av);}
a=C_alloc(8);
t2=C_fixnum_plus(((C_word*)((C_word*)t0)[2])[1],((C_word*)((C_word*)t0)[3])[1]);
t3=C_i_fixnum_min(((C_word*)((C_word*)t0)[4])[1],t2);
t4=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_6717,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[6],a[7]=((C_word)li169),tmp=(C_word)a,a+=8,tmp);
/* posixunix.scm:1214: ##sys#scan-buffer-line */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[356]+1));
C_word *av2;
if(c >= 6) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(6);
}
av2[0]=*((C_word*)lf[356]+1);
av2[1]=t1;
av2[2]=((C_word*)t0)[5];
av2[3]=t3;
av2[4]=((C_word*)((C_word*)t0)[2])[1];
av2[5]=t4;
tp(6,av2);}}

/* open-input-file* in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_3090(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand((c-3)*C_SIZEOF_PAIR +5,c,4)))){
C_save_and_reclaim((void*)f_3090,c,av);}
a=C_alloc((c-3)*C_SIZEOF_PAIR+5);
t3=C_build_rest(&a,c,3,av);
C_word t4;
C_word t5;
C_word t6;
t4=C_i_check_exact_2(t2,lf[60]);
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3102,a[2]=t2,a[3]=((C_word*)t0)[2],a[4]=t1,tmp=(C_word)a,a+=5,tmp);
/* posix-common.scm:377: mode */
f_3038(t5,C_SCHEME_TRUE,t3,lf[60]);}

/* doloop928 in k4842 in k4834 in k4831 in k4828 in file-select in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static C_word C_fcall f_5123(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_stack_overflow_check;
loop:{}
if(C_truep(C_i_nullp(t2))){
t3=C_SCHEME_UNDEFINED;
return(t3);}
else{
t3=C_i_car(t2);
t4=t1;
t5=C_i_foreign_fixnum_argumentp(t4);
t6=C_i_foreign_fixnum_argumentp(t3);
if(C_truep(((C_word*)t0)[2])){
t7=C_i_foreign_block_argumentp(((C_word*)t0)[2]);
t8=stub937(C_SCHEME_UNDEFINED,t5,t6,t7);
t9=C_fixnum_plus(t1,C_fix(1));
t10=t2;
t11=C_u_i_cdr(t10);
t13=t9;
t14=t11;
t1=t13;
t2=t14;
goto loop;}
else{
t7=stub937(C_SCHEME_UNDEFINED,t5,t6,C_SCHEME_FALSE);
t8=C_fixnum_plus(t1,C_fix(1));
t9=t2;
t10=C_u_i_cdr(t9);
t13=t8;
t14=t10;
t1=t13;
t2=t14;
goto loop;}}}

/* k3044 in mode in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_3046(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,3)))){
C_save_and_reclaim((void *)f_3046,2,av);}
/* posix-common.scm:359: ##sys#make-c-string */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[11]+1));
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[11]+1);
av2[1]=((C_word*)t0)[2];
av2[2]=t1;
av2[3]=((C_word*)t0)[3];
tp(4,av2);}}

/* a8030 in process-wait in k6200 in k6169 in k5687 in k5683 in k5679 in k5675 in k5595 in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_8031(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,3)))){
C_save_and_reclaim((void *)f_8031,2,av);}
/* posixunix.scm:1581: ##sys#process-wait */
t2=*((C_word*)lf[126]+1);{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=t2;
av2[1]=t1;
av2[2]=((C_word*)t0)[2];
av2[3]=((C_word*)t0)[3];
((C_proc)(void*)(*((C_word*)t2+1)))(4,av2);}}

/* k6322 in file-link in k6200 in k6169 in k5687 in k5683 in k5679 in k5675 in k5595 in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_6324(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,2)))){
C_save_and_reclaim((void *)f_6324,2,av);}
a=C_alloc(4);
t2=t1;
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_6328,a[2]=((C_word*)t0)[2],a[3]=t2,tmp=(C_word)a,a+=4,tmp);
if(C_truep(((C_word*)t0)[3])){
t4=C_i_foreign_string_argumentp(((C_word*)t0)[3]);
/* posixunix.scm:1112: ##sys#make-c-string */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[11]+1));
C_word *av2;
if(c >= 3) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(3);
}
av2[0]=*((C_word*)lf[11]+1);
av2[1]=t3;
av2[2]=t4;
tp(3,av2);}}
else{
t4=((C_word*)t0)[2];{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=t4;
av2[1]=stub1443(C_SCHEME_UNDEFINED,t2,C_SCHEME_FALSE);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}}

/* k6326 in k6322 in file-link in k6200 in k6169 in k5687 in k5683 in k5679 in k5675 in k5595 in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_6328(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_6328,2,av);}
t2=((C_word*)t0)[2];{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=t2;
av2[1]=stub1443(C_SCHEME_UNDEFINED,((C_word*)t0)[3],t1);
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* process-signal in k6200 in k6169 in k5687 in k5683 in k5679 in k5675 in k5595 in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_8063(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand((c-3)*C_SIZEOF_PAIR +4,c,2)))){
C_save_and_reclaim((void*)f_8063,c,av);}
a=C_alloc((c-3)*C_SIZEOF_PAIR+4);
t3=C_build_rest(&a,c,3,av);
C_word t4;
C_word t5;
C_word t6;
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_8067,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
if(C_truep(C_i_pairp(t3))){
t5=t3;
t6=t4;
f_8067(t6,C_u_i_car(t5));}
else{
t5=t4;
f_8067(t5,C_fix((C_word)SIGTERM));}}

/* k8065 in process-signal in k6200 in k6169 in k5687 in k5683 in k5679 in k5675 in k5595 in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_fcall f_8067(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,0,6)))){
C_save_and_reclaim_args((void *)trf_8067,2,t0,t1);}
t2=C_i_check_exact_2(((C_word*)t0)[2],lf[431]);
t3=C_i_check_exact_2(t1,lf[431]);
t4=C_kill(((C_word*)t0)[2],t1);
t5=C_eqp(t4,C_fix(-1));
if(C_truep(t5)){
/* posixunix.scm:1600: posix-error */
t6=lf[0];{
C_word av2[7];
av2[0]=t6;
av2[1]=((C_word*)t0)[3];
av2[2]=lf[127];
av2[3]=lf[431];
av2[4]=lf[432];
av2[5]=((C_word*)t0)[2];
av2[6]=t1;
f_2704(7,av2);}}
else{
t6=C_SCHEME_UNDEFINED;
t7=((C_word*)t0)[3];{
C_word av2[2];
av2[0]=t7;
av2[1]=t6;
((C_proc)(void*)(*((C_word*)t7+1)))(2,av2);}}}

/* a3595 in conc-loop in glob in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_3596(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4=av[4];
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word *a;
if(c!=5) C_bad_argc_2(c,5,t0);
if(C_unlikely(!C_demand(C_calculate_demand(9,c,4)))){
C_save_and_reclaim((void *)f_3596,5,av);}
a=C_alloc(9);
t5=t2;
t6=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_3600,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t5,a[5]=t1,tmp=(C_word)a,a+=6,tmp);
t7=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3670,a[2]=t6,tmp=(C_word)a,a+=3,tmp);
if(C_truep(t3)){
t8=t3;
/* posix-common.scm:504: make-pathname */
t9=*((C_word*)lf[83]+1);{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=t9;
av2[1]=t7;
av2[2]=C_SCHEME_FALSE;
av2[3]=t8;
av2[4]=t4;
((C_proc)(void*)(*((C_word*)t9+1)))(5,av2);}}
else{
/* posix-common.scm:504: make-pathname */
t8=*((C_word*)lf[83]+1);{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=t8;
av2[1]=t7;
av2[2]=C_SCHEME_FALSE;
av2[3]=lf[92];
av2[4]=t4;
((C_proc)(void*)(*((C_word*)t8+1)))(5,av2);}}}

/* a3589 in conc-loop in glob in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_3590(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,2)))){
C_save_and_reclaim((void *)f_3590,2,av);}
/* posix-common.scm:503: decompose-pathname */
t2=*((C_word*)lf[82]+1);{
C_word *av2;
if(c >= 3) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(3);
}
av2[0]=t2;
av2[1]=t1;
av2[2]=((C_word*)t0)[2];
((C_proc)(void*)(*((C_word*)t2+1)))(3,av2);}}

/* k4671 in k4668 in k4655 in file-open in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_4673(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_4673,2,av);}
t2=((C_word*)t0)[2];{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=t2;
av2[1]=((C_word*)t0)[3];
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* k4668 in k4655 in file-open in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_4670(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,7)))){
C_save_and_reclaim((void *)f_4670,2,av);}
a=C_alloc(4);
t2=C_open(t1,((C_word*)t0)[2],((C_word*)t0)[3]);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4673,a[2]=((C_word*)t0)[4],a[3]=t2,tmp=(C_word)a,a+=4,tmp);
t4=C_eqp(C_fix(-1),t2);
if(C_truep(t4)){
/* posixunix.scm:480: posix-error */
t5=lf[0];{
C_word *av2;
if(c >= 8) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(8);
}
av2[0]=t5;
av2[1]=t3;
av2[2]=lf[8];
av2[3]=lf[183];
av2[4]=lf[184];
av2[5]=((C_word*)t0)[5];
av2[6]=((C_word*)t0)[2];
av2[7]=((C_word*)t0)[3];
f_2704(8,av2);}}
else{
t5=((C_word*)t0)[4];{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=t5;
av2[1]=t2;
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}}

/* file-close in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_4685(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(7,c,2)))){
C_save_and_reclaim((void *)f_4685,3,av);}
a=C_alloc(7);
t3=C_i_check_exact_2(t2,lf[185]);
t4=C_SCHEME_UNDEFINED;
t5=(*a=C_VECTOR_TYPE|1,a[1]=t4,tmp=(C_word)a,a+=2,tmp);
t6=C_set_block_item(t5,0,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4694,a[2]=t2,a[3]=t5,a[4]=((C_word)li96),tmp=(C_word)a,a+=5,tmp));
t7=((C_word*)t5)[1];{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=t7;
av2[1]=t1;
f_4694(2,av2);}}

/* conc-loop in glob in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_fcall f_3575(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(9,0,5)))){
C_save_and_reclaim_args((void *)trf_3575,3,t0,t1,t2);}
a=C_alloc(9);
if(C_truep(C_i_nullp(t2))){
t3=t1;{
C_word av2[2];
av2[0]=t3;
av2[1]=C_SCHEME_END_OF_LIST;
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}
else{
t3=C_i_car(t2);
t4=t3;
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3590,a[2]=t4,a[3]=((C_word)li34),tmp=(C_word)a,a+=4,tmp);
t6=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3596,a[2]=t2,a[3]=((C_word*)t0)[2],a[4]=((C_word)li37),tmp=(C_word)a,a+=5,tmp);
/* posix-common.scm:502: ##sys#call-with-values */{
C_word av2[4];
av2[0]=0;
av2[1]=t1;
av2[2]=t5;
av2[3]=t6;
C_call_with_values(4,av2);}}}

/* loop in file-close in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_4694(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,5)))){
C_save_and_reclaim((void *)f_4694,2,av);}
t2=C_close(((C_word*)t0)[2]);
if(C_truep(C_fixnum_lessp(t2,C_fix(0)))){
t3=C_fix((C_word)errno);
if(C_truep(C_i_eqvp(t3,C_fix((C_word)EINTR)))){
/* posixunix.scm:489: ##sys#dispatch-interrupt */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[186]+1));
C_word *av2;
if(c >= 3) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(3);
}
av2[0]=*((C_word*)lf[186]+1);
av2[1]=t1;
av2[2]=((C_word*)((C_word*)t0)[3])[1];
tp(3,av2);}}
else{
/* posixunix.scm:491: posix-error */
t4=lf[0];{
C_word *av2;
if(c >= 6) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(6);
}
av2[0]=t4;
av2[1]=t1;
av2[2]=lf[8];
av2[3]=lf[185];
av2[4]=lf[187];
av2[5]=((C_word*)t0)[2];
f_2704(6,av2);}}}
else{
t3=C_SCHEME_UNDEFINED;
t4=t1;{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=t4;
av2[1]=t3;
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}}

/* file-control in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_4620(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c<4) C_bad_min_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand((c-4)*C_SIZEOF_PAIR +0,c,6)))){
C_save_and_reclaim((void*)f_4620,c,av);}
a=C_alloc((c-4)*C_SIZEOF_PAIR+0);
t4=C_build_rest(&a,c,4,av);
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
t5=C_i_nullp(t4);
t6=(C_truep(t5)?C_fix(0):C_i_car(t4));
t7=C_i_check_exact_2(t2,lf[181]);
t8=C_i_check_exact_2(t3,lf[181]);
t9=t2;
t10=t3;
t11=C_i_foreign_fixnum_argumentp(t9);
t12=C_i_foreign_fixnum_argumentp(t10);
t13=C_i_foreign_integer_argumentp(t6);
t14=stub837(C_SCHEME_UNDEFINED,t11,t12,t13);
t15=C_eqp(t14,C_fix(-1));
if(C_truep(t15)){
/* posixunix.scm:468: posix-error */
t16=lf[0];{
C_word *av2;
if(c >= 7) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(7);
}
av2[0]=t16;
av2[1]=t1;
av2[2]=lf[8];
av2[3]=lf[181];
av2[4]=lf[182];
av2[5]=t2;
av2[6]=t3;
f_2704(7,av2);}}
else{
t16=t1;{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=t16;
av2[1]=t14;
((C_proc)(void*)(*((C_word*)t16+1)))(2,av2);}}}

/* regular-file? in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_2911(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(3,c,4)))){
C_save_and_reclaim((void *)f_2911,3,av);}
a=C_alloc(3);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2919,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posix-common.scm:284: file-type */
t4=*((C_word*)lf[23]+1);{
C_word *av2;
if(c >= 5) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(5);
}
av2[0]=t4;
av2[1]=t3;
av2[2]=t2;
av2[3]=C_SCHEME_FALSE;
av2[4]=C_SCHEME_FALSE;
((C_proc)(void*)(*((C_word*)t4+1)))(5,av2);}}

/* k2917 in regular-file? in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_2919(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_2919,2,av);}
t2=((C_word*)t0)[2];{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=t2;
av2[1]=C_eqp(lf[24],t1);
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* k4655 in file-open in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_fcall f_4657(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(6,0,3)))){
C_save_and_reclaim_args((void *)trf_4657,2,t0,t1);}
a=C_alloc(6);
t2=t1;
t3=C_i_check_string_2(((C_word*)t0)[2],lf[183]);
t4=C_i_check_exact_2(((C_word*)t0)[3],lf[183]);
t5=C_i_check_exact_2(t2,lf[183]);
t6=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_4670,a[2]=((C_word*)t0)[3],a[3]=t2,a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[2],tmp=(C_word)a,a+=6,tmp);
/* posixunix.scm:478: ##sys#make-c-string */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[11]+1));
C_word av2[4];
av2[0]=*((C_word*)lf[11]+1);
av2[1]=t6;
av2[2]=((C_word*)t0)[2];
av2[3]=lf[183];
tp(4,av2);}}

/* file-open in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_4653(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c<4) C_bad_min_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand((c-4)*C_SIZEOF_PAIR +5,c,2)))){
C_save_and_reclaim((void*)f_4653,c,av);}
a=C_alloc((c-4)*C_SIZEOF_PAIR+5);
t4=C_build_rest(&a,c,4,av);
C_word t5;
C_word t6;
C_word t7;
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4657,a[2]=t2,a[3]=t3,a[4]=t1,tmp=(C_word)a,a+=5,tmp);
if(C_truep(C_i_pairp(t4))){
t6=t4;
t7=t5;
f_4657(t7,C_u_i_car(t6));}
else{
t6=t5;
f_4657(t6,((C_word*)t0)[2]);}}

/* k6361 in file-link in k6200 in k6169 in k5687 in k5683 in k5679 in k5675 in k5595 in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_6363(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,6)))){
C_save_and_reclaim((void *)f_6363,2,av);}
if(C_truep(C_fixnum_lessp(t1,C_fix(0)))){
/* posixunix.scm:1117: posix-error */
t2=lf[0];{
C_word *av2;
if(c >= 7) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(7);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[2];
av2[2]=lf[8];
av2[3]=lf[343];
av2[4]=lf[344];
av2[5]=((C_word*)t0)[3];
av2[6]=((C_word*)t0)[4];
f_2704(7,av2);}}
else{
t2=C_SCHEME_UNDEFINED;
t3=((C_word*)t0)[2];{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=t3;
av2[1]=t2;
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}}

/* ##sys#custom-input-port in k6200 in k6169 in k5687 in k5683 in k5679 in k5675 in k5595 in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_6365(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4=av[4];
C_word t5;
C_word *a;
if(c<5) C_bad_min_argc_2(c,5,t0);
if(C_unlikely(!C_demand(C_calculate_demand((c-5)*C_SIZEOF_PAIR +9,c,2)))){
C_save_and_reclaim((void*)f_6365,c,av);}
a=C_alloc((c-5)*C_SIZEOF_PAIR+9);
t5=C_build_rest(&a,c,5,av);
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word t17;
C_word t18;
C_word t19;
C_word t20;
C_word t21;
C_word t22;
C_word t23;
C_word t24;
C_word t25;
C_word t26;
t6=C_i_nullp(t5);
t7=(C_truep(t6)?C_SCHEME_FALSE:C_i_car(t5));
t8=C_i_nullp(t5);
t9=(C_truep(t8)?C_SCHEME_END_OF_LIST:C_i_cdr(t5));
t10=C_i_nullp(t9);
t11=(C_truep(t10)?C_fix(1):C_i_car(t9));
t12=t11;
t13=C_i_nullp(t9);
t14=(C_truep(t13)?C_SCHEME_END_OF_LIST:C_i_cdr(t9));
t15=C_i_nullp(t14);
t16=(C_truep(t15)?*((C_word*)lf[346]+1):C_i_car(t14));
t17=t16;
t18=C_i_nullp(t14);
t19=(C_truep(t18)?C_SCHEME_END_OF_LIST:C_i_cdr(t14));
t20=C_i_nullp(t19);
t21=(C_truep(t20)?C_SCHEME_FALSE:C_i_car(t19));
t22=t21;
t23=C_i_nullp(t19);
t24=(C_truep(t23)?C_SCHEME_END_OF_LIST:C_i_cdr(t19));
t25=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_6393,a[2]=t12,a[3]=t2,a[4]=t4,a[5]=t3,a[6]=t22,a[7]=t1,a[8]=t17,tmp=(C_word)a,a+=9,tmp);
if(C_truep(t7)){
/* posixunix.scm:1122: ##sys#file-nonblocking! */
t26=*((C_word*)lf[143]+1);{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=t26;
av2[1]=t25;
av2[2]=t4;
((C_proc)(void*)(*((C_word*)t26+1)))(3,av2);}}
else{
t26=t25;{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=t26;
av2[1]=C_SCHEME_UNDEFINED;
f_6393(2,av2);}}}

/* check in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_fcall f_5260(C_word t1,C_word t2,C_word t3,C_word t4,C_word t5){
C_word tmp;
C_word t6;
C_word t7;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,0,5)))){
C_save_and_reclaim_args((void *)trf_5260,5,t1,t2,t3,t4,t5);}
a=C_alloc(4);
if(C_truep(C_null_pointerp(t5))){
/* posixunix.scm:609: posix-error */
t6=lf[0];{
C_word av2[6];
av2[0]=t6;
av2[1]=t1;
av2[2]=lf[8];
av2[3]=t2;
av2[4]=lf[204];
av2[5]=t3;
f_2704(6,av2);}}
else{
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5273,a[2]=t5,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm:610: ##sys#make-port */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[57]+1));
C_word av2[6];
av2[0]=*((C_word*)lf[57]+1);
av2[1]=t6;
av2[2]=t4;
av2[3]=*((C_word*)lf[58]+1);
av2[4]=lf[205];
av2[5]=lf[43];
tp(6,av2);}}}

/* k3507 in k3497 in k3485 in loop in k3457 in k3453 in k3450 in k3447 in k3432 in directory in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_3509(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(3,c,1)))){
C_save_and_reclaim((void *)f_3509,2,av);}
a=C_alloc(3);
t2=((C_word*)t0)[2];{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=t2;
av2[1]=C_a_i_cons(&a,2,((C_word*)t0)[3],t1);
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* file-link in k6200 in k6169 in k5687 in k5683 in k5679 in k5675 in k5595 in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_6343(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(9,c,2)))){
C_save_and_reclaim((void *)f_6343,4,av);}
a=C_alloc(9);
t4=C_i_check_string_2(t2,lf[342]);
t5=C_i_check_string_2(t3,lf[342]);
t6=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_6363,a[2]=t1,a[3]=t2,a[4]=t3,tmp=(C_word)a,a+=5,tmp);
t7=t6;
t8=t2;
t9=t3;
t10=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_6324,a[2]=t7,a[3]=t9,tmp=(C_word)a,a+=4,tmp);
if(C_truep(t8)){
t11=C_i_foreign_string_argumentp(t8);
/* posixunix.scm:1112: ##sys#make-c-string */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[11]+1));
C_word *av2=av; /* Re-use our own argvector */
av2[0]=*((C_word*)lf[11]+1);
av2[1]=t10;
av2[2]=t11;
tp(3,av2);}}
else{
t11=t10;{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=t11;
av2[1]=C_SCHEME_FALSE;
f_6324(2,av2);}}}

/* k5231 in change-directory* in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_5233(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_5233,2,av);}
t2=((C_word*)t0)[2];{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=t2;
av2[1]=((C_word*)t0)[3];
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* symbolic-link? in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_2921(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(3,c,4)))){
C_save_and_reclaim((void *)f_2921,3,av);}
a=C_alloc(3);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2929,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posix-common.scm:287: file-type */
t4=*((C_word*)lf[23]+1);{
C_word *av2;
if(c >= 5) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(5);
}
av2[0]=t4;
av2[1]=t3;
av2[2]=t2;
av2[3]=C_SCHEME_TRUE;
av2[4]=C_SCHEME_FALSE;
((C_proc)(void*)(*((C_word*)t4+1)))(5,av2);}}

/* k2927 in symbolic-link? in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_2929(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_2929,2,av);}
t2=((C_word*)t0)[2];{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=t2;
av2[1]=C_eqp(lf[25],t1);
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* change-directory* in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_5226(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(4,c,5)))){
C_save_and_reclaim((void *)f_5226,3,av);}
a=C_alloc(4);
t3=C_i_check_exact_2(t2,lf[202]);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5233,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
t5=C_fchdir(t2);
t6=C_eqp(C_fix(0),t5);
if(C_truep(t6)){
t7=t1;{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=t7;
av2[1]=t2;
((C_proc)(void*)(*((C_word*)t7+1)))(2,av2);}}
else{
/* posixunix.scm:598: posix-error */
t7=lf[0];{
C_word *av2;
if(c >= 6) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(6);
}
av2[0]=t7;
av2[1]=t4;
av2[2]=lf[8];
av2[3]=lf[202];
av2[4]=lf[203];
av2[5]=t2;
f_2704(6,av2);}}}

/* k5215 in k5212 in change-directory in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_5217(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_5217,2,av);}
t2=((C_word*)t0)[2];{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=t2;
av2[1]=((C_word*)t0)[3];
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* k5212 in change-directory in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_5214(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,5)))){
C_save_and_reclaim((void *)f_5214,2,av);}
a=C_alloc(4);
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5217,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
t3=C_chdir(t1);
t4=C_eqp(C_fix(0),t3);
if(C_truep(t4)){
t5=((C_word*)t0)[2];{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=t5;
av2[1]=((C_word*)t0)[3];
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}
else{
/* posixunix.scm:592: posix-error */
t5=lf[0];{
C_word *av2;
if(c >= 6) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(6);
}
av2[0]=t5;
av2[1]=t2;
av2[2]=lf[8];
av2[3]=lf[69];
av2[4]=lf[201];
av2[5]=((C_word*)t0)[3];
f_2704(6,av2);}}}

/* character-device? in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_2941(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(3,c,4)))){
C_save_and_reclaim((void *)f_2941,3,av);}
a=C_alloc(3);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2949,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posix-common.scm:293: file-type */
t4=*((C_word*)lf[23]+1);{
C_word *av2;
if(c >= 5) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(5);
}
av2[0]=t4;
av2[1]=t3;
av2[2]=t2;
av2[3]=C_SCHEME_FALSE;
av2[4]=C_SCHEME_FALSE;
((C_proc)(void*)(*((C_word*)t4+1)))(5,av2);}}

/* k2947 in character-device? in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_2949(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_2949,2,av);}
t2=((C_word*)t0)[2];{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=t2;
av2[1]=C_eqp(lf[27],t1);
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* k3447 in k3432 in directory in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_3449(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(6,c,2)))){
C_save_and_reclaim((void *)f_3449,2,av);}
a=C_alloc(6);
t2=t1;
t3=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_3452,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t2,a[5]=((C_word*)t0)[4],tmp=(C_word)a,a+=6,tmp);
/* posix-common.scm:471: ##sys#make-pointer */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[86]+1));
C_word *av2=av; /* Re-use our own argvector */
av2[0]=*((C_word*)lf[86]+1);
av2[1]=t3;
tp(2,av2);}}

/* block-device? in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_2931(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(3,c,4)))){
C_save_and_reclaim((void *)f_2931,3,av);}
a=C_alloc(3);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2939,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posix-common.scm:290: file-type */
t4=*((C_word*)lf[23]+1);{
C_word *av2;
if(c >= 5) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(5);
}
av2[0]=t4;
av2[1]=t3;
av2[2]=t2;
av2[3]=C_SCHEME_FALSE;
av2[4]=C_SCHEME_FALSE;
((C_proc)(void*)(*((C_word*)t4+1)))(5,av2);}}

/* k2937 in block-device? in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_2939(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_2939,2,av);}
t2=((C_word*)t0)[2];{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=t2;
av2[1]=C_eqp(lf[28],t1);
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* k8257 in spawn in k6200 in k6169 in k5687 in k5683 in k5679 in k5675 in k5595 in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_8259(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(13,c,2)))){
C_save_and_reclaim((void *)f_8259,2,av);}
a=C_alloc(13);
t2=t1;
t3=(*a=C_CLOSURE_TYPE|12,a[1]=(C_word)f_8262,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t2,a[5]=((C_word*)t0)[4],a[6]=((C_word*)t0)[5],a[7]=((C_word*)t0)[6],a[8]=((C_word*)t0)[7],a[9]=((C_word*)t0)[8],a[10]=((C_word*)t0)[9],a[11]=((C_word*)t0)[10],a[12]=((C_word*)t0)[11],tmp=(C_word)a,a+=13,tmp);
/* posixunix.scm:1677: needed-pipe */
f_8194(t3,((C_word*)t0)[9]);}

/* k3432 in directory in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_3434(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(5,c,3)))){
C_save_and_reclaim((void *)f_3434,2,av);}
a=C_alloc(5);
t2=t1;
t3=C_i_nullp(((C_word*)t0)[2]);
t4=(C_truep(t3)?C_SCHEME_END_OF_LIST:C_i_cdr(((C_word*)t0)[2]));
t5=C_i_nullp(t4);
t6=(C_truep(t5)?C_SCHEME_FALSE:C_i_car(t4));
t7=t6;
t8=C_i_nullp(t4);
t9=(C_truep(t8)?C_SCHEME_END_OF_LIST:C_i_cdr(t4));
t10=C_i_check_string_2(t2,lf[26]);
t11=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3449,a[2]=((C_word*)t0)[3],a[3]=t2,a[4]=t7,tmp=(C_word)a,a+=5,tmp);
/* ##sys#make-string */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[72]+1));
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[72]+1);
av2[1]=t11;
av2[2]=C_fix(256);
av2[3]=C_make_character(32);
tp(4,av2);}}

/* socket? in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_2961(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(3,c,4)))){
C_save_and_reclaim((void *)f_2961,3,av);}
a=C_alloc(3);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2969,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posix-common.scm:299: file-type */
t4=*((C_word*)lf[23]+1);{
C_word *av2;
if(c >= 5) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(5);
}
av2[0]=t4;
av2[1]=t3;
av2[2]=t2;
av2[3]=C_SCHEME_FALSE;
av2[4]=C_SCHEME_FALSE;
((C_proc)(void*)(*((C_word*)t4+1)))(5,av2);}}

/* spawn in k6200 in k6169 in k5687 in k5683 in k5679 in k5675 in k5595 in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_fcall f_8255(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6,C_word t7){
C_word tmp;
C_word t8;
C_word t9;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(12,0,2)))){
C_save_and_reclaim_args((void *)trf_8255,8,t0,t1,t2,t3,t4,t5,t6,t7);}
a=C_alloc(12);
t8=(*a=C_CLOSURE_TYPE|11,a[1]=(C_word)f_8259,a[2]=((C_word*)t0)[2],a[3]=t1,a[4]=t2,a[5]=t3,a[6]=t4,a[7]=((C_word*)t0)[3],a[8]=t7,a[9]=t5,a[10]=t6,a[11]=((C_word*)t0)[4],tmp=(C_word)a,a+=12,tmp);
/* posixunix.scm:1676: needed-pipe */
f_8194(t8,t6);}

/* directory in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_3430(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand((c-2)*C_SIZEOF_PAIR +4,c,2)))){
C_save_and_reclaim((void*)f_3430,c,av);}
a=C_alloc((c-2)*C_SIZEOF_PAIR+4);
t2=C_build_rest(&a,c,2,av);
C_word t3;
C_word t4;
C_word t5;
t3=t2;
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3434,a[2]=t3,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
if(C_truep(C_i_nullp(t3))){
/* posix-common.scm:468: current-directory */
t5=*((C_word*)lf[68]+1);{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=t5;
av2[1]=t4;
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}
else{
t5=t4;{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=t5;
av2[1]=C_i_car(t3);
f_3434(2,av2);}}}

/* k2967 in socket? in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_2969(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_2969,2,av);}
t2=((C_word*)t0)[2];{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=t2;
av2[1]=C_eqp(lf[30],t1);
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* k7789 in terminal-name in k6200 in k6169 in k5687 in k5683 in k5679 in k5675 in k5595 in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_7791(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(5,c,3)))){
C_save_and_reclaim((void *)f_7791,2,av);}
a=C_alloc(5);
t2=C_C_fileno(((C_word*)t0)[2]);
t3=((C_word*)t0)[3];
t4=C_a_i_bytevector(&a,1,C_fix(3));
t5=C_i_foreign_fixnum_argumentp(t2);
t6=stub1854(t4,t5);
/* posixunix.scm:1511: ##sys#peek-nonnull-c-string */
t7=*((C_word*)lf[260]+1);{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=t7;
av2[1]=t3;
av2[2]=t6;
av2[3]=C_fix(0);
((C_proc)(void*)(*((C_word*)t7+1)))(4,av2);}}

/* swapped-ends in k6200 in k6169 in k5687 in k5683 in k5679 in k5675 in k5595 in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static C_word C_fcall f_8241(C_word *a,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_stack_overflow_check;{}
if(C_truep(t1)){
t2=C_i_cdr(t1);
t3=t1;
t4=C_u_i_car(t3);
return(C_a_i_cons(&a,2,t2,t4));}
else{
return(C_SCHEME_FALSE);}}

/* a8277 in k8263 in k8260 in k8257 in spawn in k6200 in k6169 in k5687 in k5683 in k5679 in k5675 in k5595 in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 in ... */
static void C_ccall f_8278(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(C_unlikely(!C_demand(C_calculate_demand(12,c,4)))){
C_save_and_reclaim((void *)f_8278,2,av);}
a=C_alloc(12);
t2=(*a=C_CLOSURE_TYPE|11,a[1]=(C_word)f_8282,a[2]=t1,a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],a[6]=((C_word*)t0)[5],a[7]=((C_word*)t0)[6],a[8]=((C_word*)t0)[7],a[9]=((C_word*)t0)[8],a[10]=((C_word*)t0)[9],a[11]=((C_word*)t0)[10],tmp=(C_word)a,a+=12,tmp);
/* posixunix.scm:1683: connect-child */
f_8226(t2,((C_word*)t0)[11],((C_word*)t0)[12],*((C_word*)lf[46]+1));}

/* k3453 in k3450 in k3447 in k3432 in directory in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_3455(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(8,c,3)))){
C_save_and_reclaim((void *)f_3455,2,av);}
a=C_alloc(8);
t2=t1;
t3=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_3459,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=t2,a[6]=((C_word*)t0)[5],a[7]=((C_word*)t0)[6],tmp=(C_word)a,a+=8,tmp);
/* posix-common.scm:475: ##sys#make-c-string */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[11]+1));
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[11]+1);
av2[1]=t3;
av2[2]=((C_word*)t0)[4];
av2[3]=lf[26];
tp(4,av2);}}

/* k3457 in k3453 in k3450 in k3447 in k3432 in directory in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_3459(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(10,c,5)))){
C_save_and_reclaim((void *)f_3459,2,av);}
a=C_alloc(10);
t2=C_opendir(t1,((C_word*)t0)[2]);
if(C_truep(C_null_pointerp(((C_word*)t0)[2]))){
/* posix-common.scm:477: posix-error */
t3=lf[0];{
C_word *av2;
if(c >= 6) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(6);
}
av2[0]=t3;
av2[1]=((C_word*)t0)[3];
av2[2]=lf[8];
av2[3]=lf[26];
av2[4]=lf[85];
av2[5]=((C_word*)t0)[4];
f_2704(6,av2);}}
else{
t3=C_SCHEME_UNDEFINED;
t4=(*a=C_VECTOR_TYPE|1,a[1]=t3,tmp=(C_word)a,a+=2,tmp);
t5=C_set_block_item(t4,0,(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_3473,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[5],a[4]=((C_word*)t0)[6],a[5]=t4,a[6]=((C_word*)t0)[7],a[7]=((C_word)li32),tmp=(C_word)a,a+=8,tmp));
t6=((C_word*)t4)[1];
f_3473(t6,((C_word*)t0)[3]);}}

/* a6762 in k6700 in k6691 in a6688 in k6397 in k6391 in custom-input-port in k6200 in k6169 in k5687 in k5683 in k5679 in k5675 in k5595 in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in ... */
static void C_ccall f_6763(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4=av[4];
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word *a;
if(c!=5) C_bad_argc_2(c,5,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_6763,5,av);}
if(C_truep(t4)){
t5=C_slot(((C_word*)t0)[2],C_fix(4));
t6=C_fixnum_plus(t5,C_fix(1));
t7=C_i_set_i_slot(((C_word*)t0)[2],C_fix(4),t6);
t8=C_i_set_i_slot(((C_word*)t0)[2],C_fix(5),C_fix(0));
t9=C_mutate2(((C_word *)((C_word*)t0)[3])+1,t2);
t10=t1;{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=t10;
av2[1]=t3;
((C_proc)(void*)(*((C_word*)t10+1)))(2,av2);}}
else{
t5=C_slot(((C_word*)t0)[2],C_fix(5));
t6=C_block_size(t3);
t7=C_fixnum_plus(t5,t6);
t8=C_i_set_i_slot(((C_word*)t0)[2],C_fix(5),t7);
t9=C_mutate2(((C_word *)((C_word*)t0)[3])+1,t2);
t10=t1;{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=t10;
av2[1]=t3;
((C_proc)(void*)(*((C_word*)t10+1)))(2,av2);}}}

/* k3450 in k3447 in k3432 in directory in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_3452(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(7,c,2)))){
C_save_and_reclaim((void *)f_3452,2,av);}
a=C_alloc(7);
t2=t1;
t3=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_3455,a[2]=t2,a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],a[6]=((C_word*)t0)[5],tmp=(C_word)a,a+=7,tmp);
/* posix-common.scm:472: ##sys#make-pointer */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[86]+1));
C_word *av2=av; /* Re-use our own argvector */
av2[0]=*((C_word*)lf[86]+1);
av2[1]=t3;
tp(2,av2);}}

/* k2986 in set-file-position! in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_fcall f_2988(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(11,0,2)))){
C_save_and_reclaim_args((void *)trf_2988,2,t0,t1);}
a=C_alloc(11);
t2=t1;
t3=C_i_check_exact_2(((C_word*)t0)[2],lf[41]);
t4=C_i_check_exact_2(t2,lf[41]);
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3000,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[2],tmp=(C_word)a,a+=5,tmp);
t6=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_3006,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[2],a[4]=t2,a[5]=t5,tmp=(C_word)a,a+=6,tmp);
/* posix-common.scm:320: port? */
t7=*((C_word*)lf[15]+1);{
C_word av2[3];
av2[0]=t7;
av2[1]=t6;
av2[2]=((C_word*)t0)[4];
((C_proc)(void*)(*((C_word*)t7+1)))(3,av2);}}

/* k8274 in k8263 in k8260 in k8257 in spawn in k6200 in k6169 in k5687 in k5683 in k5679 in k5675 in k5595 in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 in ... */
static void C_ccall f_8276(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,5)))){
C_save_and_reclaim((void *)f_8276,2,av);}
/* posixunix.scm:1679: values */{
C_word *av2;
if(c >= 6) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(6);
}
av2[0]=0;
av2[1]=((C_word*)t0)[2];
av2[2]=((C_word*)t0)[3];
av2[3]=((C_word*)t0)[4];
av2[4]=((C_word*)t0)[5];
av2[5]=t1;
C_values(6,av2);}}

/* set-file-position! in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_2984(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c<4) C_bad_min_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand((c-4)*C_SIZEOF_PAIR +5,c,2)))){
C_save_and_reclaim((void*)f_2984,c,av);}
a=C_alloc((c-4)*C_SIZEOF_PAIR+5);
t4=C_build_rest(&a,c,4,av);
C_word t5;
C_word t6;
C_word t7;
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2988,a[2]=t3,a[3]=t1,a[4]=t2,tmp=(C_word)a,a+=5,tmp);
if(C_truep(C_i_pairp(t4))){
t6=t4;
t7=t5;
f_2988(t7,C_u_i_car(t6));}
else{
t6=t5;
f_2988(t6,C_fix((C_word)SEEK_SET));}}

/* directory? in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_2971(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(3,c,4)))){
C_save_and_reclaim((void *)f_2971,3,av);}
a=C_alloc(3);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2979,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posix-common.scm:302: file-type */
t4=*((C_word*)lf[23]+1);{
C_word *av2;
if(c >= 5) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(5);
}
av2[0]=t4;
av2[1]=t3;
av2[2]=t2;
av2[3]=C_SCHEME_FALSE;
av2[4]=C_SCHEME_FALSE;
((C_proc)(void*)(*((C_word*)t4+1)))(5,av2);}}

/* k2977 in directory? in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_2979(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_2979,2,av);}
t2=((C_word*)t0)[2];{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=t2;
av2[1]=C_eqp(lf[26],t1);
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* k8263 in k8260 in k8257 in spawn in k6200 in k6169 in k5687 in k5683 in k5679 in k5675 in k5595 in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_8265(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(23,c,2)))){
C_save_and_reclaim((void *)f_8265,2,av);}
a=C_alloc(23);
t2=t1;
t3=(
  /* posixunix.scm:1680: swapped-ends */
  f_8241(C_a_i(&a,3),((C_word*)t0)[3])
);
t4=t3;
t5=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_8276,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[5],a[4]=t4,a[5]=t2,tmp=(C_word)a,a+=6,tmp);
t6=(*a=C_CLOSURE_TYPE|13,a[1]=(C_word)f_8278,a[2]=((C_word*)t0)[6],a[3]=((C_word*)t0)[7],a[4]=((C_word*)t0)[8],a[5]=((C_word*)t0)[2],a[6]=t2,a[7]=((C_word*)t0)[9],a[8]=((C_word*)t0)[10],a[9]=((C_word*)t0)[5],a[10]=((C_word*)t0)[11],a[11]=((C_word*)t0)[3],a[12]=((C_word*)t0)[12],a[13]=((C_word)li232),tmp=(C_word)a,a+=14,tmp);
/* posixunix.scm:1681: process-fork */
t7=*((C_word*)lf[423]+1);{
C_word *av2;
if(c >= 3) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(3);
}
av2[0]=t7;
av2[1]=t5;
av2[2]=t6;
((C_proc)(void*)(*((C_word*)t7+1)))(3,av2);}}

/* k8260 in k8257 in spawn in k6200 in k6169 in k5687 in k5683 in k5679 in k5675 in k5595 in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_8262(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(13,c,2)))){
C_save_and_reclaim((void *)f_8262,2,av);}
a=C_alloc(13);
t2=t1;
t3=(*a=C_CLOSURE_TYPE|12,a[1]=(C_word)f_8265,a[2]=((C_word*)t0)[2],a[3]=t2,a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],a[6]=((C_word*)t0)[5],a[7]=((C_word*)t0)[6],a[8]=((C_word*)t0)[7],a[9]=((C_word*)t0)[8],a[10]=((C_word*)t0)[9],a[11]=((C_word*)t0)[10],a[12]=((C_word*)t0)[11],tmp=(C_word)a,a+=13,tmp);
/* posixunix.scm:1678: needed-pipe */
f_8194(t3,((C_word*)t0)[9]);}

/* connect-parent in k6200 in k6169 in k5687 in k5683 in k5679 in k5675 in k5595 in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_fcall f_8214(C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,0,2)))){
C_save_and_reclaim_args((void *)trf_8214,3,t1,t2,t3);}
a=C_alloc(4);
if(C_truep(t3)){
t4=C_i_car(t2);
t5=t4;
t6=t2;
t7=C_u_i_cdr(t6);
t8=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_8225,a[2]=t1,a[3]=t5,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm:1661: file-close */
t9=*((C_word*)lf[185]+1);{
C_word av2[3];
av2[0]=t9;
av2[1]=t8;
av2[2]=t7;
((C_proc)(void*)(*((C_word*)t9+1)))(3,av2);}}
else{
t4=t1;{
C_word av2[2];
av2[0]=t4;
av2[1]=C_SCHEME_FALSE;
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}}

/* a8208 in needed-pipe in k6200 in k6169 in k5687 in k5683 in k5679 in k5675 in k5595 in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_8209(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(3,c,1)))){
C_save_and_reclaim((void *)f_8209,4,av);}
a=C_alloc(3);
t4=t1;{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=t4;
av2[1]=C_a_i_cons(&a,2,t2,t3);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* a8202 in needed-pipe in k6200 in k6169 in k5687 in k5683 in k5679 in k5675 in k5595 in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_8203(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_8203,2,av);}
/* posixunix.scm:1656: create-pipe */
t2=*((C_word*)lf[221]+1);{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=t2;
av2[1]=t1;
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* a8574 in k5687 in k5683 in k5679 in k5675 in k5595 in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_8575(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(8,c,2)))){
C_save_and_reclaim((void *)f_8575,3,av);}
a=C_alloc(8);
t3=C_i_check_exact_2(t2,lf[329]);
t4=C_getpgid(t2);
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_8582,a[2]=t1,a[3]=t4,tmp=(C_word)a,a+=4,tmp);
if(C_truep(C_fixnum_lessp(t4,C_fix(0)))){
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_8588,a[2]=t5,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm:1054: ##sys#update-errno */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[5]+1));
C_word *av2=av; /* Re-use our own argvector */
av2[0]=*((C_word*)lf[5]+1);
av2[1]=t6;
tp(2,av2);}}
else{
t6=t1;{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=t6;
av2[1]=t4;
((C_proc)(void*)(*((C_word*)t6+1)))(2,av2);}}}

/* k5816 in loop in k5806 in k5802 in k5789 in group-information in k5687 in k5683 in k5679 in k5675 in k5595 in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_5818(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,2)))){
C_save_and_reclaim((void *)f_5818,2,av);}
a=C_alloc(4);
t2=t1;
if(C_truep(t2)){
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5828,a[2]=((C_word*)t0)[2],a[3]=t2,tmp=(C_word)a,a+=4,tmp);
t4=C_fixnum_plus(((C_word*)t0)[3],C_fix(1));
/* posixunix.scm:915: loop */
t5=((C_word*)((C_word*)t0)[4])[1];
f_5814(t5,t3,t4);}
else{
t3=((C_word*)t0)[2];{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=t3;
av2[1]=C_SCHEME_END_OF_LIST;
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}}

/* loop in k5806 in k5802 in k5789 in group-information in k5687 in k5683 in k5679 in k5675 in k5595 in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_fcall f_5814(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(10,0,3)))){
C_save_and_reclaim_args((void *)trf_5814,3,t0,t1,t2);}
a=C_alloc(10);
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_5818,a[2]=t1,a[3]=t2,a[4]=((C_word*)t0)[2],tmp=(C_word)a,a+=5,tmp);
t4=t2;
t5=C_a_i_bytevector(&a,1,C_fix(3));
t6=C_i_foreign_fixnum_argumentp(t4);
t7=stub1249(t5,t6);
/* posixunix.scm:898: ##sys#peek-c-string */
t8=*((C_word*)lf[4]+1);{
C_word av2[4];
av2[0]=t8;
av2[1]=t3;
av2[2]=t7;
av2[3]=C_fix(0);
((C_proc)(void*)(*((C_word*)t8+1)))(4,av2);}}

/* k5810 in k5806 in k5802 in k5789 in group-information in k5687 in k5683 in k5679 in k5675 in k5595 in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_5812(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,5)))){
C_save_and_reclaim((void *)f_5812,2,av);}
/* posixunix.scm:901: g1268 */
t2=((C_word*)t0)[2];{
C_word *av2;
if(c >= 6) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(6);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[3];
av2[2]=((C_word*)t0)[4];
av2[3]=((C_word*)t0)[5];
av2[4]=C_fix((C_word)C_group->gr_gid);
av2[5]=t1;
((C_proc)(void*)(*((C_word*)t2+1)))(6,av2);}}

/* a8592 in k5687 in k5683 in k5679 in k5675 in k5595 in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_8593(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(5,c,2)))){
C_save_and_reclaim((void *)f_8593,4,av);}
a=C_alloc(5);
t4=C_i_check_exact_2(t2,lf[448]);
t5=C_i_check_exact_2(t3,lf[448]);
t6=C_setpgid(t2,t3);
if(C_truep(C_fixnum_lessp(t6,C_fix(0)))){
t7=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_8609,a[2]=t1,a[3]=t2,a[4]=t3,tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm:1061: ##sys#update-errno */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[5]+1));
C_word *av2=av; /* Re-use our own argvector */
av2[0]=*((C_word*)lf[5]+1);
av2[1]=t7;
tp(2,av2);}}
else{
t7=C_SCHEME_UNDEFINED;
t8=t1;{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=t8;
av2[1]=t7;
((C_proc)(void*)(*((C_word*)t8+1)))(2,av2);}}}

/* local-time->seconds in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_4017(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(5,c,3)))){
C_save_and_reclaim((void *)f_4017,3,av);}
a=C_alloc(5);
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4021,a[2]=t2,a[3]=t1,a[4]=((C_word*)t0)[2],tmp=(C_word)a,a+=5,tmp);
/* posix-common.scm:603: check-time-vector */
f_3908(t3,lf[111],t2);}

/* k5806 in k5802 in k5789 in group-information in k5687 in k5683 in k5679 in k5675 in k5595 in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_5808(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(12,c,3)))){
C_save_and_reclaim((void *)f_5808,2,av);}
a=C_alloc(12);
t2=t1;
t3=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_5812,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=t2,tmp=(C_word)a,a+=6,tmp);
t4=C_SCHEME_UNDEFINED;
t5=(*a=C_VECTOR_TYPE|1,a[1]=t4,tmp=(C_word)a,a+=2,tmp);
t6=C_set_block_item(t5,0,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5814,a[2]=t5,a[3]=((C_word)li139),tmp=(C_word)a,a+=4,tmp));
t7=((C_word*)t5)[1];
f_5814(t7,t3,C_fix(0));}

/* k5802 in k5789 in group-information in k5687 in k5683 in k5679 in k5675 in k5595 in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_5804(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(8,c,3)))){
C_save_and_reclaim((void *)f_5804,2,av);}
a=C_alloc(8);
t2=t1;
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_5808,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t2,tmp=(C_word)a,a+=5,tmp);
/* ##sys#peek-nonnull-c-string */
t4=*((C_word*)lf[260]+1);{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=t4;
av2[1]=t3;
av2[2]=C_mpointer(&a,(void*)C_group->gr_passwd);
av2[3]=C_fix(0);
((C_proc)(void*)(*((C_word*)t4+1)))(4,av2);}}

/* k4019 in local-time->seconds in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_4021(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,3)))){
C_save_and_reclaim((void *)f_4021,2,av);}
a=C_alloc(4);
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4025,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* posix-common.scm:604: ##sys#make-string */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[72]+1));
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[72]+1);
av2[1]=t2;
av2[2]=((C_word*)t0)[4];
av2[3]=C_make_character(0);
tp(4,av2);}}

/* k4023 in k4019 in local-time->seconds in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_4025(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(9,c,3)))){
C_save_and_reclaim((void *)f_4025,2,av);}
a=C_alloc(9);
t2=C_a_mktime(&a,2,((C_word*)t0)[2],t1);
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4031,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[2],a[4]=t2,tmp=(C_word)a,a+=5,tmp);
/* posix-common.scm:605: fp= */
t4=*((C_word*)lf[113]+1);{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=t4;
av2[1]=t3;
av2[2]=lf[114];
av2[3]=t2;
((C_proc)(void*)(*((C_word*)t4+1)))(4,av2);}}

/* f_2951 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_2951(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(3,c,4)))){
C_save_and_reclaim((void *)f_2951,3,av);}
a=C_alloc(3);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2959,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posix-common.scm:296: file-type */
t4=*((C_word*)lf[23]+1);{
C_word *av2;
if(c >= 5) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(5);
}
av2[0]=t4;
av2[1]=t3;
av2[2]=t2;
av2[3]=C_SCHEME_FALSE;
av2[4]=C_SCHEME_FALSE;
((C_proc)(void*)(*((C_word*)t4+1)))(5,av2);}}

/* k2957 */
static void C_ccall f_2959(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_2959,2,av);}
t2=((C_word*)t0)[2];{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=t2;
av2[1]=C_eqp(lf[29],t1);
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* k4029 in k4023 in k4019 in local-time->seconds in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_4031(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,4)))){
C_save_and_reclaim((void *)f_4031,2,av);}
if(C_truep(t1)){
/* posix-common.scm:606: ##sys#error */
t2=*((C_word*)lf[50]+1);{
C_word *av2;
if(c >= 5) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(5);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[2];
av2[2]=lf[111];
av2[3]=lf[112];
av2[4]=((C_word*)t0)[3];
((C_proc)(void*)(*((C_word*)t2+1)))(5,av2);}}
else{
t2=((C_word*)t0)[2];{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=t2;
av2[1]=((C_word*)t0)[4];
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}}

/* k8567 in set-root-directory! in k6200 in k6169 in k5687 in k5683 in k5679 in k5675 in k5595 in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_8569(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,5)))){
C_save_and_reclaim((void *)f_8569,2,av);}
if(C_truep(C_fixnum_lessp(t1,C_fix(0)))){
/* posixunix.scm:1751: posix-error */
t2=lf[0];{
C_word *av2;
if(c >= 6) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(6);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[2];
av2[2]=lf[8];
av2[3]=lf[445];
av2[4]=lf[446];
av2[5]=((C_word*)t0)[3];
f_2704(6,av2);}}
else{
t2=C_SCHEME_UNDEFINED;
t3=((C_word*)t0)[2];{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=t3;
av2[1]=t2;
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}}

/* close-input-pipe in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_5355(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(4,c,5)))){
C_save_and_reclaim((void *)f_5355,3,av);}
a=C_alloc(4);
t3=t2;
t4=C_i_check_port_2(t3,C_SCHEME_TRUE,C_SCHEME_TRUE,lf[211]);
t5=close_pipe(t2);
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5362,a[2]=t1,a[3]=t5,tmp=(C_word)a,a+=4,tmp);
t7=C_eqp(C_fix(-1),t5);
if(C_truep(t7)){
/* posixunix.scm:640: posix-error */
t8=lf[0];{
C_word *av2;
if(c >= 6) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(6);
}
av2[0]=t8;
av2[1]=t6;
av2[2]=lf[8];
av2[3]=lf[211];
av2[4]=lf[212];
av2[5]=t2;
f_2704(6,av2);}}
else{
t8=t1;{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=t8;
av2[1]=t5;
((C_proc)(void*)(*((C_word*)t8+1)))(2,av2);}}}

/* k6502 in k6493 in loop in fetch in k6397 in k6391 in custom-input-port in k6200 in k6169 in k5687 in k5683 in k5679 in k5675 in k5595 in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in ... */
static void C_ccall f_6504(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_6504,2,av);}
t2=C_mutate2(((C_word *)((C_word*)t0)[2])+1,((C_word*)((C_word*)t0)[3])[1]);
t3=C_set_block_item(((C_word*)t0)[4],0,C_fix(0));
t4=((C_word*)t0)[5];{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=t4;
av2[1]=t3;
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* set-root-directory! in k6200 in k6169 in k5687 in k5683 in k5679 in k5675 in k5595 in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_8552(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(7,c,2)))){
C_save_and_reclaim((void *)f_8552,3,av);}
a=C_alloc(7);
t3=C_i_check_string_2(t2,lf[445]);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_8569,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
t5=t4;
t6=t2;
t7=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_8544,a[2]=t5,tmp=(C_word)a,a+=3,tmp);
if(C_truep(t6)){
t8=C_i_foreign_string_argumentp(t6);
/* posixunix.scm:1747: ##sys#make-c-string */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[11]+1));
C_word *av2=av; /* Re-use our own argvector */
av2[0]=*((C_word*)lf[11]+1);
av2[1]=t7;
av2[2]=t8;
tp(3,av2);}}
else{
t8=t5;{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=t8;
av2[1]=stub2155(C_SCHEME_UNDEFINED,C_SCHEME_FALSE);
((C_proc)(void*)(*((C_word*)t8+1)))(2,av2);}}}

/* current-directory in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_3193(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand((c-2)*C_SIZEOF_PAIR +3,c,3)))){
C_save_and_reclaim((void*)f_3193,c,av);}
a=C_alloc((c-2)*C_SIZEOF_PAIR+3);
t2=C_build_rest(&a,c,2,av);
C_word t3;
C_word t4;
C_word t5;
C_word t6;
t3=C_i_nullp(t2);
t4=(C_truep(t3)?C_SCHEME_FALSE:C_i_car(t2));
if(C_truep(t4)){
/* posix-common.scm:416: change-directory */
t5=*((C_word*)lf[69]+1);{
C_word *av2;
if(c >= 3) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(3);
}
av2[0]=t5;
av2[1]=t1;
av2[2]=t4;
((C_proc)(void*)(*((C_word*)t5+1)))(3,av2);}}
else{
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3206,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* ##sys#make-string */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[72]+1));
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[72]+1);
av2[1]=t5;
av2[2]=C_fix(1024);
av2[3]=C_make_character(32);
tp(4,av2);}}}

/* k8586 in a8574 in k5687 in k5683 in k5679 in k5675 in k5595 in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_8588(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,4)))){
C_save_and_reclaim((void *)f_8588,2,av);}
/* posixunix.scm:1055: ##sys#error */
t2=*((C_word*)lf[50]+1);{
C_word *av2;
if(c >= 5) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(5);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[2];
av2[2]=lf[329];
av2[3]=lf[447];
av2[4]=((C_word*)t0)[3];
((C_proc)(void*)(*((C_word*)t2+1)))(5,av2);}}

/* time->string in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_4062(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand((c-3)*C_SIZEOF_PAIR +6,c,3)))){
C_save_and_reclaim((void*)f_4062,c,av);}
a=C_alloc((c-3)*C_SIZEOF_PAIR+6);
t3=C_build_rest(&a,c,3,av);
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
t4=C_i_nullp(t3);
t5=(C_truep(t4)?C_SCHEME_FALSE:C_i_car(t3));
t6=t5;
t7=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_4069,a[2]=t6,a[3]=t1,a[4]=t2,a[5]=((C_word*)t0)[2],tmp=(C_word)a,a+=6,tmp);
/* posix-common.scm:614: check-time-vector */
f_3908(t7,lf[115],t2);}

/* k8286 in k8283 in k8280 in a8277 in k8263 in k8260 in k8257 in spawn in k6200 in k6169 in k5687 in k5683 in k5679 in k5675 in k5595 in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in ... */
static void C_ccall f_8288(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,4)))){
C_save_and_reclaim((void *)f_8288,2,av);}
/* posixunix.scm:1686: process-execute */
t2=*((C_word*)lf[427]+1);{
C_word *av2;
if(c >= 5) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(5);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[2];
av2[2]=((C_word*)t0)[3];
av2[3]=((C_word*)t0)[4];
av2[4]=((C_word*)t0)[5];
((C_proc)(void*)(*((C_word*)t2+1)))(5,av2);}}

/* k8580 in a8574 in k5687 in k5683 in k5679 in k5675 in k5595 in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_8582(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_8582,2,av);}
t2=((C_word*)t0)[2];{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=t2;
av2[1]=((C_word*)t0)[3];
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* file-owner in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_2806(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(3,c,5)))){
C_save_and_reclaim((void *)f_2806,3,av);}
a=C_alloc(3);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2810,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posix-common.scm:267: ##sys#stat */
f_2722(t3,t2,C_SCHEME_FALSE,C_SCHEME_TRUE,lf[20]);}

/* k2802 in file-change-time in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_2804(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,1)))){
C_save_and_reclaim((void *)f_2804,2,av);}
a=C_alloc(4);
t2=((C_word*)t0)[2];{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=t2;
av2[1]=C_flonum(&a,C_statbuf.st_ctime);
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* file-change-time in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_2800(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(3,c,5)))){
C_save_and_reclaim((void *)f_2800,3,av);}
a=C_alloc(3);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2804,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posix-common.scm:266: ##sys#stat */
f_2722(t3,t2,C_SCHEME_FALSE,C_SCHEME_TRUE,lf[19]);}

/* k8283 in k8280 in a8277 in k8263 in k8260 in k8257 in spawn in k6200 in k6169 in k5687 in k5683 in k5679 in k5675 in k5595 in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in ... */
static void C_ccall f_8285(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(9,c,4)))){
C_save_and_reclaim((void *)f_8285,2,av);}
a=C_alloc(9);
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_8288,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],tmp=(C_word)a,a+=6,tmp);
t3=(
  /* posixunix.scm:1685: swapped-ends */
  f_8241(C_a_i(&a,3),((C_word*)t0)[7])
);
/* posixunix.scm:1685: connect-child */
f_8226(t2,t3,((C_word*)t0)[9],*((C_word*)lf[48]+1));}

/* k8280 in a8277 in k8263 in k8260 in k8257 in spawn in k6200 in k6169 in k5687 in k5683 in k5679 in k5675 in k5595 in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in ... */
static void C_ccall f_8282(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(13,c,4)))){
C_save_and_reclaim((void *)f_8282,2,av);}
a=C_alloc(13);
t2=(*a=C_CLOSURE_TYPE|9,a[1]=(C_word)f_8285,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[6],a[7]=((C_word*)t0)[7],a[8]=((C_word*)t0)[8],a[9]=((C_word*)t0)[9],tmp=(C_word)a,a+=10,tmp);
t3=(
  /* posixunix.scm:1684: swapped-ends */
  f_8241(C_a_i(&a,3),((C_word*)t0)[10])
);
/* posixunix.scm:1684: connect-child */
f_8226(t2,t3,((C_word*)t0)[11],*((C_word*)lf[47]+1));}

/* k4067 in time->string in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_4069(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(9,c,3)))){
C_save_and_reclaim((void *)f_4069,2,av);}
a=C_alloc(9);
if(C_truep(((C_word*)t0)[2])){
t2=C_i_check_string_2(((C_word*)t0)[2],lf[115]);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4078,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],tmp=(C_word)a,a+=4,tmp);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4088,a[2]=((C_word*)t0)[4],a[3]=t3,a[4]=((C_word*)t0)[5],tmp=(C_word)a,a+=5,tmp);
/* posix-common.scm:618: ##sys#make-c-string */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[11]+1));
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[11]+1);
av2[1]=t4;
av2[2]=((C_word*)t0)[2];
av2[3]=lf[115];
tp(4,av2);}}
else{
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4095,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],tmp=(C_word)a,a+=4,tmp);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4116,a[2]=((C_word*)t0)[4],a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* posix-common.scm:620: ##sys#make-string */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[72]+1));
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[72]+1);
av2[1]=t3;
av2[2]=((C_word*)t0)[5];
av2[3]=C_make_character(0);
tp(4,av2);}}}

/* k5892 in loop in k5872 in k5869 in k5866 in get-groups in k5687 in k5683 in k5679 in k5675 in k5595 in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_5894(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(3,c,1)))){
C_save_and_reclaim((void *)f_5894,2,av);}
a=C_alloc(3);
t2=((C_word*)t0)[2];{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=t2;
av2[1]=C_a_i_cons(&a,2,((C_word*)t0)[3],t1);
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* k4076 in k4067 in time->string in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_4078(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,4)))){
C_save_and_reclaim((void *)f_4078,2,av);}
if(C_truep(t1)){
t2=((C_word*)t0)[2];{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=t2;
av2[1]=t1;
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}
else{
/* posix-common.scm:619: ##sys#error */
t2=*((C_word*)lf[50]+1);{
C_word *av2;
if(c >= 5) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(5);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[2];
av2[2]=lf[115];
av2[3]=lf[116];
av2[4]=((C_word*)t0)[3];
((C_proc)(void*)(*((C_word*)t2+1)))(5,av2);}}}

/* a6538 in k6397 in k6391 in custom-input-port in k6200 in k6169 in k5687 in k5683 in k5679 in k5675 in k5595 in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_6539(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(C_unlikely(!C_demand(C_calculate_demand(5,c,2)))){
C_save_and_reclaim((void *)f_6539,2,av);}
a=C_alloc(5);
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_6543,a[2]=((C_word*)t0)[2],a[3]=t1,a[4]=((C_word*)t0)[3],tmp=(C_word)a,a+=5,tmp);
if(C_truep(C_fixnum_greater_or_equal_p(((C_word*)((C_word*)t0)[3])[1],((C_word*)((C_word*)t0)[4])[1]))){
/* posixunix.scm:1176: fetch */
t3=((C_word*)t0)[5];
f_6437(t3,t2);}
else{
t3=t2;{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=t3;
av2[1]=C_SCHEME_UNDEFINED;
f_6543(2,av2);}}}

/* k6535 in k6531 in k6397 in k6391 in custom-input-port in k6200 in k6169 in k5687 in k5683 in k5679 in k5675 in k5595 in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 in ... */
static void C_ccall f_6537(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_6537,2,av);}
t2=((C_word*)t0)[2];{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=t2;
av2[1]=((C_word*)((C_word*)t0)[3])[1];
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* k6531 in k6397 in k6391 in custom-input-port in k6200 in k6169 in k5687 in k5683 in k5679 in k5675 in k5595 in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_6533(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,3)))){
C_save_and_reclaim((void *)f_6533,2,av);}
a=C_alloc(4);
t2=C_mutate2(((C_word *)((C_word*)t0)[2])+1,t1);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_6537,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm:1246: set-port-name! */
t4=*((C_word*)lf[354]+1);{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=t4;
av2[1]=t3;
av2[2]=((C_word*)((C_word*)t0)[2])[1];
av2[3]=((C_word*)t0)[4];
((C_proc)(void*)(*((C_word*)t4+1)))(4,av2);}}

/* open-output-pipe in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_5315(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand((c-3)*C_SIZEOF_PAIR +10,c,3)))){
C_save_and_reclaim((void*)f_5315,c,av);}
a=C_alloc((c-3)*C_SIZEOF_PAIR+10);
t3=C_build_rest(&a,c,3,av);
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
t4=C_i_check_string_2(t2,lf[210]);
t5=C_i_pairp(t3);
t6=(C_truep(t5)?C_slot(t3,C_fix(0)):lf[207]);
t7=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_5329,a[2]=((C_word*)t0)[2],a[3]=t1,a[4]=t2,tmp=(C_word)a,a+=5,tmp);
t8=C_eqp(t6,lf[207]);
if(C_truep(t8)){
t9=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_5336,a[2]=((C_word*)t0)[2],a[3]=t1,a[4]=t2,tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm:632: ##sys#make-c-string */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[11]+1));
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[11]+1);
av2[1]=t9;
av2[2]=t2;
av2[3]=lf[210];
tp(4,av2);}}
else{
t9=C_eqp(t6,lf[208]);
if(C_truep(t9)){
t10=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_5346,a[2]=((C_word*)t0)[2],a[3]=t1,a[4]=t2,tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm:633: ##sys#make-c-string */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[11]+1));
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[11]+1);
av2[1]=t10;
av2[2]=t2;
av2[3]=lf[210];
tp(4,av2);}}
else{
/* posixunix.scm:606: ##sys#error */
t10=*((C_word*)lf[50]+1);{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=t10;
av2[1]=t7;
av2[2]=lf[209];
av2[3]=t6;
((C_proc)(void*)(*((C_word*)t10+1)))(4,av2);}}}}

/* k4090 in k4086 in k4067 in time->string in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_4092(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(5,c,3)))){
C_save_and_reclaim((void *)f_4092,2,av);}
a=C_alloc(5);
t2=((C_word*)t0)[2];
t3=C_a_i_bytevector(&a,1,C_fix(3));
if(C_truep(t1)){
t4=C_i_foreign_block_argumentp(t1);
t5=stub582(t3,t2,((C_word*)t0)[3],t4);
/* posix-common.scm:611: ##sys#peek-c-string */
t6=*((C_word*)lf[4]+1);{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=t6;
av2[1]=((C_word*)t0)[4];
av2[2]=t5;
av2[3]=C_fix(0);
((C_proc)(void*)(*((C_word*)t6+1)))(4,av2);}}
else{
t4=stub582(t3,t2,((C_word*)t0)[3],C_SCHEME_FALSE);
/* posix-common.scm:611: ##sys#peek-c-string */
t5=*((C_word*)lf[4]+1);{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=t5;
av2[1]=((C_word*)t0)[4];
av2[2]=t4;
av2[3]=C_fix(0);
((C_proc)(void*)(*((C_word*)t5+1)))(4,av2);}}}

/* k4093 in k4067 in time->string in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_4095(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,4)))){
C_save_and_reclaim((void *)f_4095,2,av);}
if(C_truep(t1)){
t2=C_block_size(t1);
t3=C_fixnum_difference(t2,C_fix(1));
/* posix-common.scm:622: ##sys#substring */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[70]+1));
C_word *av2;
if(c >= 5) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(5);
}
av2[0]=*((C_word*)lf[70]+1);
av2[1]=((C_word*)t0)[2];
av2[2]=t1;
av2[3]=C_fix(0);
av2[4]=t3;
tp(5,av2);}}
else{
/* posix-common.scm:623: ##sys#error */
t2=*((C_word*)lf[50]+1);{
C_word *av2;
if(c >= 5) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(5);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[2];
av2[2]=lf[115];
av2[3]=lf[117];
av2[4]=((C_word*)t0)[3];
((C_proc)(void*)(*((C_word*)t2+1)))(5,av2);}}}

/* k4086 in k4067 in time->string in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_4088(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(5,c,3)))){
C_save_and_reclaim((void *)f_4088,2,av);}
a=C_alloc(5);
t2=t1;
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4092,a[2]=((C_word*)t0)[2],a[3]=t2,a[4]=((C_word*)t0)[3],tmp=(C_word)a,a+=5,tmp);
/* posix-common.scm:618: ##sys#make-string */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[72]+1));
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[72]+1);
av2[1]=t3;
av2[2]=((C_word*)t0)[4];
av2[3]=C_make_character(0);
tp(4,av2);}}

/* k6541 in a6538 in k6397 in k6391 in custom-input-port in k6200 in k6169 in k5687 in k5683 in k5679 in k5675 in k5595 in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 in ... */
static void C_ccall f_6543(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_6543,2,av);}
t2=(
  /* posixunix.scm:1177: peek */
  f_6429(((C_word*)t0)[2])
);
if(C_truep(C_eofp(t2))){
t3=((C_word*)t0)[3];{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=t3;
av2[1]=t2;
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}
else{
t3=C_fixnum_plus(((C_word*)((C_word*)t0)[4])[1],C_fix(1));
t4=C_set_block_item(((C_word*)t0)[4],0,t3);
t5=((C_word*)t0)[3];{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=t5;
av2[1]=t2;
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}}

/* k5344 in open-output-pipe in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_5346(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(2,c,5)))){
C_save_and_reclaim((void *)f_5346,2,av);}
a=C_alloc(2);
t2=open_binary_output_pipe(&a,1,t1);
/* posixunix.scm:628: check */
f_5260(((C_word*)t0)[3],lf[210],((C_word*)t0)[4],C_SCHEME_FALSE,t2);}

/* k5872 in k5869 in k5866 in get-groups in k5687 in k5683 in k5679 in k5675 in k5595 in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_5874(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(7,c,3)))){
C_save_and_reclaim((void *)f_5874,2,av);}
a=C_alloc(7);
t2=C_SCHEME_UNDEFINED;
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=C_set_block_item(t3,0,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_5879,a[2]=((C_word*)t0)[2],a[3]=t3,a[4]=((C_word)li141),tmp=(C_word)a,a+=5,tmp));
t5=((C_word*)t3)[1];
f_5879(t5,((C_word*)t0)[3],C_fix(0));}

/* k5869 in k5866 in get-groups in k5687 in k5683 in k5679 in k5675 in k5595 in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_5871(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(7,c,2)))){
C_save_and_reclaim((void *)f_5871,2,av);}
a=C_alloc(7);
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5874,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
t3=C_i_foreign_fixnum_argumentp(((C_word*)t0)[2]);
t4=stub1276(C_SCHEME_UNDEFINED,t3);
if(C_truep(C_fixnum_lessp(t4,C_fix(0)))){
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5904,a[2]=t2,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm:937: ##sys#update-errno */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[5]+1));
C_word *av2=av; /* Re-use our own argvector */
av2[0]=*((C_word*)lf[5]+1);
av2[1]=t5;
tp(2,av2);}}
else{
t5=t2;{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=t5;
av2[1]=C_SCHEME_UNDEFINED;
f_5874(2,av2);}}}

/* loop in k5872 in k5869 in k5866 in get-groups in k5687 in k5683 in k5679 in k5675 in k5595 in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_fcall f_5879(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
loop:
if(C_unlikely(!C_demand(C_calculate_demand(4,0,2)))){
C_save_and_reclaim_args((void *)trf_5879,3,t0,t1,t2);}
a=C_alloc(4);
if(C_truep(C_fixnum_greater_or_equal_p(t2,((C_word*)t0)[2]))){
t3=t1;{
C_word av2[2];
av2[0]=t3;
av2[1]=C_SCHEME_END_OF_LIST;
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}
else{
t3=C_get_gid(t2);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5894,a[2]=t1,a[3]=t3,tmp=(C_word)a,a+=4,tmp);
t5=C_fixnum_plus(t2,C_fix(1));
/* posixunix.scm:942: loop */
t7=t4;
t8=t5;
t1=t7;
t2=t8;
goto loop;}}

/* k5334 in open-output-pipe in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_5336(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(2,c,5)))){
C_save_and_reclaim((void *)f_5336,2,av);}
a=C_alloc(2);
t2=open_text_output_pipe(&a,1,t1);
/* posixunix.scm:628: check */
f_5260(((C_word*)t0)[3],lf[210],((C_word*)t0)[4],C_SCHEME_FALSE,t2);}

/* tmp12594 in a4357 in a4336 in k4327 in list->c-string-buffer in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_fcall f_4360(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(14,0,4)))){
C_save_and_reclaim_args((void *)trf_4360,2,t0,t1);}
a=C_alloc(14);
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4364,a[2]=t1,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
t3=C_SCHEME_UNDEFINED;
t4=(*a=C_VECTOR_TYPE|1,a[1]=t3,tmp=(C_word)a,a+=2,tmp);
t5=C_set_block_item(t4,0,(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_4366,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=t4,a[5]=((C_word*)t0)[2],a[6]=((C_word*)t0)[5],a[7]=((C_word)li74),tmp=(C_word)a,a+=8,tmp));
t6=((C_word*)t4)[1];
f_4366(t6,t2,((C_word*)t0)[6],C_fix(0));}

/* k4362 in tmp12594 in a4357 in a4336 in k4327 in list->c-string-buffer in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_4364(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_4364,2,av);}
t2=((C_word*)t0)[2];{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=t2;
av2[1]=((C_word*)t0)[3];
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* get-groups in k5687 in k5683 in k5679 in k5675 in k5595 in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_5864(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(C_unlikely(!C_demand(C_calculate_demand(7,c,2)))){
C_save_and_reclaim((void *)f_5864,2,av);}
a=C_alloc(7);
t2=C_fix((C_word)getgroups(0, C_groups));
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5868,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
if(C_truep(C_fixnum_lessp(t2,C_fix(0)))){
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5923,a[2]=t3,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm:932: ##sys#update-errno */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[5]+1));
C_word *av2=av; /* Re-use our own argvector */
av2[0]=*((C_word*)lf[5]+1);
av2[1]=t4;
tp(2,av2);}}
else{
t4=t3;{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=t4;
av2[1]=C_SCHEME_UNDEFINED;
f_5868(2,av2);}}}

/* doloop683 in tmp12594 in a4357 in a4336 in k4327 in list->c-string-buffer in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_fcall f_4366(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(12,0,2)))){
C_save_and_reclaim_args((void *)trf_4366,4,t0,t1,t2,t3);}
a=C_alloc(12);
t4=C_i_nullp(t2);
t5=(C_truep(t4)?t4:C_eqp(t3,((C_word*)t0)[2]));
if(C_truep(t5)){
t6=C_SCHEME_UNDEFINED;
t7=t1;{
C_word av2[2];
av2[0]=t7;
av2[1]=t6;
((C_proc)(void*)(*((C_word*)t7+1)))(2,av2);}}
else{
t6=C_i_car(t2);
t7=C_i_check_string_2(t6,((C_word*)t0)[3]);
t8=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_4382,a[2]=t2,a[3]=t3,a[4]=((C_word*)t0)[4],a[5]=t1,a[6]=((C_word*)t0)[5],a[7]=((C_word*)t0)[3],tmp=(C_word)a,a+=8,tmp);
t9=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4407,a[2]=t8,a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
t10=t2;
t11=C_u_i_car(t10);
/* posix-common.scm:711: convert */
t12=((C_word*)t0)[6];{
C_word av2[3];
av2[0]=t12;
av2[1]=t9;
av2[2]=t11;
((C_proc)C_fast_retrieve_proc(t12))(3,av2);}}}

/* k5866 in get-groups in k5687 in k5683 in k5679 in k5675 in k5595 in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_5868(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,3)))){
C_save_and_reclaim((void *)f_5868,2,av);}
a=C_alloc(4);
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5871,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
t3=C_i_foreign_fixnum_argumentp(((C_word*)t0)[2]);
if(C_truep(stub1281(C_SCHEME_UNDEFINED,t3))){
t4=t2;{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=t4;
av2[1]=C_SCHEME_UNDEFINED;
f_5871(2,av2);}}
else{
/* posixunix.scm:935: ##sys#error */
t4=*((C_word*)lf[50]+1);{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=t4;
av2[1]=t2;
av2[2]=lf[272];
av2[3]=lf[274];
((C_proc)(void*)(*((C_word*)t4+1)))(4,av2);}}}

/* k5360 in close-input-pipe in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_5362(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_5362,2,av);}
t2=((C_word*)t0)[2];{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=t2;
av2[1]=((C_word*)t0)[3];
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* a6575 in k6397 in k6391 in custom-input-port in k6200 in k6169 in k5687 in k5683 in k5679 in k5675 in k5595 in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_6576(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(C_unlikely(!C_demand(C_calculate_demand(4,c,6)))){
C_save_and_reclaim((void *)f_6576,2,av);}
a=C_alloc(4);
if(C_truep(C_slot(((C_word*)((C_word*)t0)[2])[1],C_fix(8)))){
t2=C_SCHEME_UNDEFINED;
t3=t1;{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=t3;
av2[1]=t2;
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}
else{
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_6586,a[2]=((C_word*)t0)[3],a[3]=t1,tmp=(C_word)a,a+=4,tmp);
t3=C_close(((C_word*)t0)[4]);
if(C_truep(C_fixnum_lessp(t3,C_fix(0)))){
/* posixunix.scm:1187: posix-error */
t4=lf[0];{
C_word *av2;
if(c >= 7) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(7);
}
av2[0]=t4;
av2[1]=t2;
av2[2]=lf[8];
av2[3]=((C_word*)t0)[5];
av2[4]=lf[355];
av2[5]=((C_word*)t0)[4];
av2[6]=((C_word*)t0)[6];
f_2704(7,av2);}}
else{
/* posixunix.scm:1188: on-close */
t4=((C_word*)t0)[3];{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=t4;
av2[1]=t1;
((C_proc)C_fast_retrieve_proc(t4))(2,av2);}}}}

/* k7171 in file-truncate in k6200 in k6169 in k5687 in k5683 in k5679 in k5675 in k5595 in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_7173(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_7173,2,av);}
t2=C_truncate(t1,((C_word*)t0)[2]);
t3=((C_word*)t0)[3];
f_7159(t3,C_fixnum_lessp(t2,C_fix(0)));}

/* a4342 in a4336 in k4327 in list->c-string-buffer in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_4343(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(5,c,2)))){
C_save_and_reclaim((void *)f_4343,3,av);}
a=C_alloc(5);
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4349,a[2]=t2,a[3]=((C_word*)t0)[2],a[4]=((C_word)li72),tmp=(C_word)a,a+=5,tmp);
/* posix-common.scm:696: k674 */
t4=((C_word*)t0)[3];{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=t4;
av2[1]=t1;
av2[2]=t3;
((C_proc)C_fast_retrieve_proc(t4))(3,av2);}}

/* k5840 in group-information in k5687 in k5683 in k5679 in k5675 in k5595 in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_5842(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_5842,2,av);}
t2=((C_word*)t0)[2];
f_5791(t2,C_getgrnam(t1));}

/* a4348 in a4342 in a4336 in k4327 in list->c-string-buffer in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_4349(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(C_unlikely(!C_demand(C_calculate_demand(4,c,2)))){
C_save_and_reclaim((void *)f_4349,2,av);}
a=C_alloc(4);
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4353,a[2]=t1,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
/* posix-common.scm:702: free-c-string-buffer */
f_4440(t2,((C_word*)t0)[3]);}

/* k6584 in a6575 in k6397 in k6391 in custom-input-port in k6200 in k6169 in k5687 in k5683 in k5679 in k5675 in k5595 in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 in ... */
static void C_ccall f_6586(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_6586,2,av);}
/* posixunix.scm:1188: on-close */
t2=((C_word*)t0)[2];{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=t2;
av2[1]=((C_word*)t0)[3];
((C_proc)C_fast_retrieve_proc(t2))(2,av2);}}

/* k2814 in file-permissions in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_2816(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_2816,2,av);}
t2=((C_word*)t0)[2];{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=t2;
av2[1]=C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)C_statbuf.st_mode);
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* file-size in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_2818(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(3,c,5)))){
C_save_and_reclaim((void *)f_2818,3,av);}
a=C_alloc(3);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2822,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posix-common.scm:269: ##sys#stat */
f_2722(t3,t2,C_SCHEME_FALSE,C_SCHEME_TRUE,lf[22]);}

/* file-permissions in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_2812(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(3,c,5)))){
C_save_and_reclaim((void *)f_2812,3,av);}
a=C_alloc(3);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2816,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posix-common.scm:268: ##sys#stat */
f_2722(t3,t2,C_SCHEME_FALSE,C_SCHEME_TRUE,lf[21]);}

/* k4511 in k4508 in a4505 in a4499 in a4493 in k4484 in k4478 in call-with-exec-args in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_4513(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,2)))){
C_save_and_reclaim((void *)f_4513,2,av);}
/* posix-common.scm:738: signal */
t2=*((C_word*)lf[130]+1);{
C_word *av2;
if(c >= 3) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(3);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[2];
av2[2]=((C_word*)t0)[3];
((C_proc)(void*)(*((C_word*)t2+1)))(3,av2);}}

/* k2808 in file-owner in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_2810(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_2810,2,av);}
t2=((C_word*)t0)[2];{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=t2;
av2[1]=C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)C_statbuf.st_uid);
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* k4508 in a4505 in a4499 in a4493 in k4484 in k4478 in call-with-exec-args in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_4510(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,2)))){
C_save_and_reclaim((void *)f_4510,2,av);}
a=C_alloc(4);
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4513,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
if(C_truep(((C_word*)((C_word*)t0)[4])[1])){
/* posix-common.scm:737: free-c-string-buffer */
f_4440(t2,((C_word*)((C_word*)t0)[4])[1]);}
else{
/* posix-common.scm:738: signal */
t3=*((C_word*)lf[130]+1);{
C_word *av2;
if(c >= 3) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(3);
}
av2[0]=t3;
av2[1]=((C_word*)t0)[2];
av2[2]=((C_word*)t0)[3];
((C_proc)(void*)(*((C_word*)t3+1)))(3,av2);}}}

/* file-truncate in k6200 in k6169 in k5687 in k5683 in k5679 in k5675 in k5595 in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_7149(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(12,c,4)))){
C_save_and_reclaim((void *)f_7149,4,av);}
a=C_alloc(12);
t4=C_i_check_number_2(t3,lf[363]);
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_7159,a[2]=t1,a[3]=t2,a[4]=t3,tmp=(C_word)a,a+=5,tmp);
t6=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_7166,a[2]=t5,tmp=(C_word)a,a+=3,tmp);
if(C_truep(C_i_stringp(t2))){
t7=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_7173,a[2]=t3,a[3]=t5,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm:1310: ##sys#make-c-string */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[11]+1));
C_word *av2=av; /* Re-use our own argvector */
av2[0]=*((C_word*)lf[11]+1);
av2[1]=t7;
av2[2]=t2;
av2[3]=lf[363];
tp(4,av2);}}
else{
if(C_truep(C_fixnump(t2))){
t7=C_ftruncate(t2,t3);
t8=t5;
f_7159(t8,C_fixnum_lessp(t7,C_fix(0)));}
else{
/* posixunix.scm:1312: ##sys#error */
t7=*((C_word*)lf[50]+1);{
C_word *av2;
if(c >= 5) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(5);
}
av2[0]=t7;
av2[1]=t6;
av2[2]=lf[363];
av2[3]=lf[365];
av2[4]=t2;
((C_proc)(void*)(*((C_word*)t7+1)))(5,av2);}}}}

/* k4351 in a4348 in a4342 in a4336 in k4327 in list->c-string-buffer in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_4353(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,2)))){
C_save_and_reclaim((void *)f_4353,2,av);}
/* posix-common.scm:702: signal */
t2=*((C_word*)lf[130]+1);{
C_word *av2;
if(c >= 3) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(3);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[2];
av2[2]=((C_word*)t0)[3];
((C_proc)(void*)(*((C_word*)t2+1)))(3,av2);}}

/* a4357 in a4336 in k4327 in list->c-string-buffer in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_4358(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(C_unlikely(!C_demand(C_calculate_demand(16,c,3)))){
C_save_and_reclaim((void *)f_4358,2,av);}
a=C_alloc(16);
t2=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_4360,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[6],a[7]=((C_word)li75),tmp=(C_word)a,a+=8,tmp);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4417,a[2]=((C_word*)t0)[7],a[3]=((C_word)li77),tmp=(C_word)a,a+=4,tmp);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4434,a[2]=t3,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* tmp12594 */
t5=t2;
f_4360(t5,t4);}

/* a4520 in a4493 in k4484 in k4478 in call-with-exec-args in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_4521(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(C_unlikely(!C_demand(C_calculate_demand(14,c,3)))){
C_save_and_reclaim((void *)f_4521,2,av);}
a=C_alloc(14);
t2=(*a=C_CLOSURE_TYPE|9,a[1]=(C_word)f_4527,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[6],a[7]=((C_word*)t0)[7],a[8]=((C_word*)t0)[8],a[9]=((C_word)li86),tmp=(C_word)a,a+=10,tmp);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4544,a[2]=((C_word*)t0)[9],a[3]=((C_word)li88),tmp=(C_word)a,a+=4,tmp);
/* posix-common.scm:726: ##sys#call-with-values */{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=0;
av2[1]=t1;
av2[2]=t2;
av2[3]=t3;
C_call_with_values(4,av2);}}

/* a4526 in a4520 in a4493 in k4484 in k4478 in call-with-exec-args in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_4527(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(C_unlikely(!C_demand(C_calculate_demand(12,c,4)))){
C_save_and_reclaim((void *)f_4527,2,av);}
a=C_alloc(12);
t2=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_4531,a[2]=((C_word*)t0)[2],a[3]=t1,a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],a[6]=((C_word*)t0)[5],a[7]=((C_word*)t0)[6],tmp=(C_word)a,a+=8,tmp);
if(C_truep(((C_word*)t0)[7])){
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4542,a[2]=((C_word*)t0)[4],a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* posix-common.scm:742: list->c-string-buffer */
f_4321(t3,((C_word*)t0)[7],((C_word*)t0)[8],((C_word*)t0)[6]);}
else{
t3=t2;
f_4531(t3,C_SCHEME_UNDEFINED);}}

/* k7157 in file-truncate in k6200 in k6169 in k5687 in k5683 in k5679 in k5675 in k5595 in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_fcall f_7159(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,0,6)))){
C_save_and_reclaim_args((void *)trf_7159,2,t0,t1);}
if(C_truep(t1)){
/* posixunix.scm:1314: posix-error */
t2=lf[0];{
C_word av2[7];
av2[0]=t2;
av2[1]=((C_word*)t0)[2];
av2[2]=lf[8];
av2[3]=lf[363];
av2[4]=lf[364];
av2[5]=((C_word*)t0)[3];
av2[6]=((C_word*)t0)[4];
f_2704(7,av2);}}
else{
t2=C_SCHEME_UNDEFINED;
t3=((C_word*)t0)[2];{
C_word av2[2];
av2[0]=t3;
av2[1]=t2;
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}}

/* list->c-string-buffer in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_fcall f_4321(C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(11,0,3)))){
C_save_and_reclaim_args((void *)trf_4321,4,t1,t2,t3,t4);}
a=C_alloc(11);
t5=C_i_check_list_2(t2,t4);
t6=t2;
t7=C_u_i_length(t6);
t8=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_4329,a[2]=t1,a[3]=t7,a[4]=t4,a[5]=t3,a[6]=t2,tmp=(C_word)a,a+=7,tmp);
t9=C_a_i_plus(&a,2,t7,C_fix(1));
/* posix-common.scm:698: make-pointer-vector */
t10=*((C_word*)lf[137]+1);{
C_word av2[4];
av2[0]=t10;
av2[1]=t8;
av2[2]=t9;
av2[3]=C_SCHEME_FALSE;
((C_proc)(void*)(*((C_word*)t10+1)))(4,av2);}}

/* k5826 in k5816 in loop in k5806 in k5802 in k5789 in group-information in k5687 in k5683 in k5679 in k5675 in k5595 in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 in ... */
static void C_ccall f_5828(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(3,c,1)))){
C_save_and_reclaim((void *)f_5828,2,av);}
a=C_alloc(3);
t2=((C_word*)t0)[2];{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=t2;
av2[1]=C_a_i_cons(&a,2,((C_word*)t0)[3],t1);
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* k4327 in list->c-string-buffer in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_4329(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(11,c,3)))){
C_save_and_reclaim((void *)f_4329,2,av);}
a=C_alloc(11);
t2=t1;
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4332,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
t4=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_4337,a[2]=t2,a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[6],a[7]=((C_word)li79),tmp=(C_word)a,a+=8,tmp);
/* posix-common.scm:696: call-with-current-continuation */
t5=*((C_word*)lf[136]+1);{
C_word *av2;
if(c >= 3) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(3);
}
av2[0]=t5;
av2[1]=t3;
av2[2]=t4;
((C_proc)(void*)(*((C_word*)t5+1)))(3,av2);}}

/* a6563 in k6397 in k6391 in custom-input-port in k6200 in k6169 in k5687 in k5683 in k5679 in k5675 in k5595 in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_6564(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_6564,2,av);}
t2=C_fixnum_lessp(((C_word*)((C_word*)t0)[2])[1],((C_word*)((C_word*)t0)[3])[1]);
if(C_truep(t2)){
t3=t1;{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=t3;
av2[1]=t2;
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}
else{
/* posixunix.scm:1182: ready? */
t3=((C_word*)t0)[4];
f_6400(t3,t1);}}

/* k8235 in connect-child in k6200 in k6169 in k5687 in k5683 in k5679 in k5675 in k5595 in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_8237(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,3)))){
C_save_and_reclaim((void *)f_8237,2,av);}
a=C_alloc(4);
t2=((C_word*)t0)[2];
t3=((C_word*)t0)[3];
t4=((C_word*)t0)[4];
t5=C_eqp(t4,t3);
if(C_truep(t5)){
t6=C_SCHEME_UNDEFINED;
t7=t2;{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=t7;
av2[1]=t6;
((C_proc)(void*)(*((C_word*)t7+1)))(2,av2);}}
else{
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_8153,a[2]=t2,a[3]=t3,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm:1641: duplicate-fileno */
t7=*((C_word*)lf[66]+1);{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=t7;
av2[1]=t6;
av2[2]=t3;
av2[3]=t4;
((C_proc)(void*)(*((C_word*)t7+1)))(4,av2);}}}

/* k4330 in k4327 in list->c-string-buffer in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_4332(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_4332,2,av);}
/* posix-common.scm:696: g678 */
t2=t1;{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=t2;
av2[1]=((C_word*)t0)[2];
((C_proc)C_fast_retrieve_proc(t2))(2,av2);}}

/* a4336 in k4327 in list->c-string-buffer in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_4337(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(14,c,3)))){
C_save_and_reclaim((void *)f_4337,3,av);}
a=C_alloc(14);
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4343,a[2]=((C_word*)t0)[2],a[3]=t2,a[4]=((C_word)li73),tmp=(C_word)a,a+=5,tmp);
t4=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_4358,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[6],a[7]=t2,a[8]=((C_word)li78),tmp=(C_word)a,a+=9,tmp);
/* posix-common.scm:696: with-exception-handler */
t5=*((C_word*)lf[135]+1);{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=t5;
av2[1]=t1;
av2[2]=t3;
av2[3]=t4;
((C_proc)(void*)(*((C_word*)t5+1)))(4,av2);}}

/* k2820 in file-size in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_2822(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,1)))){
C_save_and_reclaim((void *)f_2822,2,av);}
a=C_alloc(4);
t2=((C_word*)t0)[2];{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=t2;
av2[1]=C_a_double_to_num(&a,C_statbuf.st_size);
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* file-type in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_2824(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand((c-3)*C_SIZEOF_PAIR +3,c,5)))){
C_save_and_reclaim((void*)f_2824,c,av);}
a=C_alloc((c-3)*C_SIZEOF_PAIR+3);
t3=C_build_rest(&a,c,3,av);
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
t4=C_i_nullp(t3);
t5=(C_truep(t4)?C_SCHEME_FALSE:C_i_car(t3));
t6=C_i_nullp(t3);
t7=(C_truep(t6)?C_SCHEME_END_OF_LIST:C_i_cdr(t3));
t8=C_i_nullp(t7);
t9=(C_truep(t8)?C_SCHEME_TRUE:C_i_car(t7));
t10=C_i_nullp(t7);
t11=(C_truep(t10)?C_SCHEME_END_OF_LIST:C_i_cdr(t7));
t12=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2843,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posix-common.scm:272: ##sys#stat */
f_2722(t12,t2,t5,t9,lf[23]);}

/* k8223 in connect-parent in k6200 in k6169 in k5687 in k5683 in k5679 in k5675 in k5595 in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_8225(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_8225,2,av);}
t2=((C_word*)t0)[2];{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=t2;
av2[1]=((C_word*)t0)[3];
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* connect-child in k6200 in k6169 in k5687 in k5683 in k5679 in k5675 in k5595 in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_fcall f_8226(C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(5,0,2)))){
C_save_and_reclaim_args((void *)trf_8226,4,t1,t2,t3,t4);}
a=C_alloc(5);
if(C_truep(t3)){
t5=C_i_car(t2);
t6=t5;
t7=t2;
t8=C_u_i_cdr(t7);
t9=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_8237,a[2]=t1,a[3]=t6,a[4]=t4,tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm:1667: file-close */
t10=*((C_word*)lf[185]+1);{
C_word av2[3];
av2[0]=t10;
av2[1]=t9;
av2[2]=t8;
((C_proc)(void*)(*((C_word*)t10+1)))(3,av2);}}
else{
t5=C_SCHEME_UNDEFINED;
t6=t1;{
C_word av2[2];
av2[0]=t6;
av2[1]=t5;
((C_proc)(void*)(*((C_word*)t6+1)))(2,av2);}}}

/* setup in k6200 in k6169 in k5687 in k5683 in k5679 in k5675 in k5595 in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_fcall f_7184(C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word t17;
C_word t18;
C_word t19;
C_word t20;
C_word t21;
C_word t22;
C_word t23;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(8,0,2)))){
C_save_and_reclaim_args((void *)trf_7184,4,t1,t2,t3,t4);}
a=C_alloc(8);
t5=C_i_nullp(t3);
t6=(C_truep(t5)?C_fix(0):C_i_car(t3));
t7=t6;
t8=C_i_nullp(t3);
t9=(C_truep(t8)?C_SCHEME_END_OF_LIST:C_i_cdr(t3));
t10=C_i_nullp(t9);
t11=(C_truep(t10)?C_SCHEME_TRUE:C_i_car(t9));
t12=t11;
t13=(*a=C_VECTOR_TYPE|1,a[1]=t12,tmp=(C_word)a,a+=2,tmp);
t14=C_i_nullp(t9);
t15=(C_truep(t14)?C_SCHEME_END_OF_LIST:C_i_cdr(t9));
t16=t2;
t17=t4;
t18=C_i_check_port_2(t16,C_fix(0),C_SCHEME_TRUE,t17);
t19=C_i_check_number_2(t7,t4);
t20=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_7205,a[2]=t2,a[3]=t7,a[4]=t13,a[5]=t1,tmp=(C_word)a,a+=6,tmp);
t21=C_eqp(C_SCHEME_TRUE,((C_word*)t13)[1]);
if(C_truep(t21)){
t22=C_set_block_item(t13,0,C_fix(0));
t23=t20;
f_7205(t23,t22);}
else{
t22=t20;
f_7205(t22,C_i_check_number_2(((C_word*)t13)[1],t4));}}

/* a6597 in k6397 in k6391 in custom-input-port in k6200 in k6169 in k5687 in k5683 in k5679 in k5675 in k5595 in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_6598(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(C_unlikely(!C_demand(C_calculate_demand(4,c,2)))){
C_save_and_reclaim((void *)f_6598,2,av);}
a=C_alloc(4);
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_6602,a[2]=t1,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
if(C_truep(C_fixnum_greater_or_equal_p(((C_word*)((C_word*)t0)[3])[1],((C_word*)((C_word*)t0)[4])[1]))){
/* posixunix.scm:1191: fetch */
t3=((C_word*)t0)[5];
f_6437(t3,t2);}
else{
/* posixunix.scm:1192: peek */
t3=t1;{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=t3;
av2[1]=(
  /* posixunix.scm:1192: peek */
  f_6429(((C_word*)t0)[2])
);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}}

/* k7164 in file-truncate in k6200 in k6169 in k5687 in k5683 in k5679 in k5675 in k5595 in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_7166(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_7166,2,av);}
t2=((C_word*)t0)[2];
f_7159(t2,C_fixnum_lessp(t1,C_fix(0)));}

/* glob in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_3569(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand((c-2)*C_SIZEOF_PAIR +6,c,3)))){
C_save_and_reclaim((void*)f_3569,c,av);}
a=C_alloc((c-2)*C_SIZEOF_PAIR+6);
t2=C_build_rest(&a,c,2,av);
C_word t3;
C_word t4;
C_word t5;
C_word t6;
t3=C_SCHEME_UNDEFINED;
t4=(*a=C_VECTOR_TYPE|1,a[1]=t3,tmp=(C_word)a,a+=2,tmp);
t5=C_set_block_item(t4,0,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3575,a[2]=t4,a[3]=((C_word)li38),tmp=(C_word)a,a+=4,tmp));
t6=((C_word*)t4)[1];
f_3575(t6,t1,t2);}

/* k3598 in a3595 in conc-loop in glob in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_3600(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(7,c,3)))){
C_save_and_reclaim((void *)f_3600,2,av);}
a=C_alloc(7);
t2=t1;
t3=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_3607,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=t2,a[6]=((C_word*)t0)[5],tmp=(C_word)a,a+=7,tmp);
if(C_truep(((C_word*)t0)[4])){
/* posix-common.scm:505: directory */
t4=*((C_word*)lf[26]+1);{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=t4;
av2[1]=t3;
av2[2]=((C_word*)t0)[4];
av2[3]=C_SCHEME_TRUE;
((C_proc)(void*)(*((C_word*)t4+1)))(4,av2);}}
else{
/* posix-common.scm:505: directory */
t4=*((C_word*)lf[26]+1);{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=t4;
av2[1]=t3;
av2[2]=lf[90];
av2[3]=C_SCHEME_TRUE;
((C_proc)(void*)(*((C_word*)t4+1)))(4,av2);}}}

/* k4805 in k4799 in file-mkstemp in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_4807(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,4)))){
C_save_and_reclaim((void *)f_4807,2,av);}
a=C_alloc(4);
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4814,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
t3=C_fixnum_difference(((C_word*)t0)[4],C_fix(1));
/* posixunix.scm:525: ##sys#substring */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[70]+1));
C_word *av2;
if(c >= 5) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(5);
}
av2[0]=*((C_word*)lf[70]+1);
av2[1]=t2;
av2[2]=((C_word*)t0)[5];
av2[3]=C_fix(0);
av2[4]=t3;
tp(5,av2);}}

/* k4799 in file-mkstemp in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_4801(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(6,c,5)))){
C_save_and_reclaim((void *)f_4801,2,av);}
a=C_alloc(6);
t2=t1;
t3=C_mkstemp(t2);
t4=C_block_size(t2);
t5=t4;
t6=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_4807,a[2]=((C_word*)t0)[2],a[3]=t3,a[4]=t5,a[5]=t2,tmp=(C_word)a,a+=6,tmp);
t7=C_eqp(C_fix(-1),t3);
if(C_truep(t7)){
/* posixunix.scm:524: posix-error */
t8=lf[0];{
C_word *av2;
if(c >= 6) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(6);
}
av2[0]=t8;
av2[1]=t6;
av2[2]=lf[8];
av2[3]=lf[194];
av2[4]=lf[195];
av2[5]=((C_word*)t0)[3];
f_2704(6,av2);}}
else{
t8=t6;{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=t8;
av2[1]=C_SCHEME_UNDEFINED;
f_4807(2,av2);}}}

/* loop in k3605 in k3598 in a3595 in conc-loop in glob in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_fcall f_3609(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(6,0,3)))){
C_save_and_reclaim_args((void *)trf_3609,3,t0,t1,t2);}
a=C_alloc(6);
if(C_truep(C_i_nullp(t2))){
t3=C_i_cdr(((C_word*)t0)[2]);
/* posix-common.scm:506: conc-loop */
t4=((C_word*)((C_word*)t0)[3])[1];
f_3575(t4,t1,t3);}
else{
t3=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_3626,a[2]=t2,a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=t1,tmp=(C_word)a,a+=6,tmp);
t4=C_i_car(t2);
/* posix-common.scm:507: irregex-match */
t5=*((C_word*)lf[89]+1);{
C_word av2[4];
av2[0]=t5;
av2[1]=t3;
av2[2]=((C_word*)t0)[6];
av2[3]=t4;
((C_proc)(void*)(*((C_word*)t5+1)))(4,av2);}}}

/* k3605 in k3598 in a3595 in conc-loop in glob in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_3607(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(10,c,3)))){
C_save_and_reclaim((void *)f_3607,2,av);}
a=C_alloc(10);
t2=C_SCHEME_UNDEFINED;
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=C_set_block_item(t3,0,(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_3609,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t3,a[5]=((C_word*)t0)[4],a[6]=((C_word*)t0)[5],a[7]=((C_word)li36),tmp=(C_word)a,a+=8,tmp));
t5=((C_word*)t3)[1];
f_3609(t5,((C_word*)t0)[6],t1);}

/* k4812 in k4805 in k4799 in file-mkstemp in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_4814(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,3)))){
C_save_and_reclaim((void *)f_4814,2,av);}
/* posixunix.scm:525: values */{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=0;
av2[1]=((C_word*)t0)[2];
av2[2]=((C_word*)t0)[3];
av2[3]=t1;
C_values(4,av2);}}

/* k3648 in g422 in k3624 in loop in k3605 in k3598 in a3595 in conc-loop in glob in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_3650(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,3)))){
C_save_and_reclaim((void *)f_3650,2,av);}
/* posix-common.scm:510: make-pathname */
t2=*((C_word*)lf[83]+1);{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[2];
av2[2]=((C_word*)t0)[3];
av2[3]=t1;
((C_proc)(void*)(*((C_word*)t2+1)))(4,av2);}}

/* k4834 in k4831 in k4828 in file-select in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_fcall f_4836(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(10,0,2)))){
C_save_and_reclaim_args((void *)trf_4836,2,t0,t1);}
a=C_alloc(10);
t2=t1;
t3=C_u_i_length(((C_word*)t0)[2]);
t4=C_u_i_length(t2);
t5=C_fixnum_plus(t3,t4);
t6=t5;
t7=(*a=C_CLOSURE_TYPE|9,a[1]=(C_word)f_4844,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[2],a[4]=t3,a[5]=t2,a[6]=t6,a[7]=((C_word*)t0)[4],a[8]=((C_word*)t0)[5],a[9]=((C_word*)t0)[6],tmp=(C_word)a,a+=10,tmp);
t8=C_fix((C_word)sizeof(struct pollfd));
t9=C_fixnum_times(t6,t8);
/* posixunix.scm:543: ##sys#make-blob */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[200]+1));
C_word av2[3];
av2[0]=*((C_word*)lf[200]+1);
av2[1]=t7;
av2[2]=t9;
tp(3,av2);}}

/* k3640 in k3636 in g422 in k3624 in loop in k3605 in k3598 in a3595 in conc-loop in glob in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_3642(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(3,c,1)))){
C_save_and_reclaim((void *)f_3642,2,av);}
a=C_alloc(3);
t2=((C_word*)t0)[2];{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=t2;
av2[1]=C_a_i_cons(&a,2,((C_word*)t0)[3],t1);
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* k8542 in set-root-directory! in k6200 in k6169 in k5687 in k5683 in k5679 in k5675 in k5595 in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_8544(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_8544,2,av);}
t2=((C_word*)t0)[2];{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=t2;
av2[1]=stub2155(C_SCHEME_UNDEFINED,t1);
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* k4842 in k4834 in k4831 in k4828 in file-select in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_4844(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(21,c,3)))){
C_save_and_reclaim((void *)f_4844,2,av);}
a=C_alloc(21);
t2=t1;
t3=(C_truep(((C_word*)t0)[2])?C_i_check_number(((C_word*)t0)[2]):C_SCHEME_UNDEFINED);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5123,a[2]=t2,a[3]=((C_word)li101),tmp=(C_word)a,a+=4,tmp);
t5=(
  f_5123(t4,C_fix(0),((C_word*)t0)[3])
);
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5081,a[2]=t2,a[3]=((C_word)li102),tmp=(C_word)a,a+=4,tmp);
t7=(
  f_5081(t6,((C_word*)t0)[4],((C_word*)t0)[5])
);
t8=(*a=C_CLOSURE_TYPE|9,a[1]=(C_word)f_5068,a[2]=t2,a[3]=((C_word*)t0)[6],a[4]=((C_word*)t0)[7],a[5]=((C_word*)t0)[8],a[6]=((C_word*)t0)[9],a[7]=((C_word*)t0)[4],a[8]=((C_word*)t0)[5],a[9]=((C_word*)t0)[3],tmp=(C_word)a,a+=10,tmp);
if(C_truep(((C_word*)t0)[2])){
t9=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5079,a[2]=t8,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm:559: max */
t10=*((C_word*)lf[199]+1);{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=t10;
av2[1]=t9;
av2[2]=C_fix(0);
av2[3]=((C_word*)t0)[2];
((C_proc)(void*)(*((C_word*)t10+1)))(4,av2);}}
else{
t9=t8;
f_5068(t9,C_fix(-1));}}

/* k2841 in file-type in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_2843(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_2843,2,av);}
if(C_truep(t1)){
t2=C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)C_stat_type);
if(C_truep(C_i_eqvp(t2,C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)S_IFREG)))){
t3=((C_word*)t0)[2];{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=t3;
av2[1]=lf[24];
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}
else{
if(C_truep(C_i_eqvp(t2,C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)S_IFLNK)))){
t3=((C_word*)t0)[2];{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=t3;
av2[1]=lf[25];
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}
else{
if(C_truep(C_i_eqvp(t2,C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)S_IFDIR)))){
t3=((C_word*)t0)[2];{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=t3;
av2[1]=lf[26];
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}
else{
if(C_truep(C_i_eqvp(t2,C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)S_IFCHR)))){
t3=((C_word*)t0)[2];{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=t3;
av2[1]=lf[27];
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}
else{
if(C_truep(C_i_eqvp(t2,C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)S_IFBLK)))){
t3=((C_word*)t0)[2];{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=t3;
av2[1]=lf[28];
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}
else{
if(C_truep(C_i_eqvp(t2,C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)S_IFIFO)))){
t3=((C_word*)t0)[2];{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=t3;
av2[1]=lf[29];
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}
else{
t3=C_i_eqvp(t2,C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)S_IFSOCK));
t4=((C_word*)t0)[2];{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=t4;
av2[1]=(C_truep(t3)?lf[30]:lf[24]);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}}}}}}}
else{
t2=((C_word*)t0)[2];{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=t2;
av2[1]=C_SCHEME_FALSE;
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}}

/* k3668 in a3595 in conc-loop in glob in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_3670(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,2)))){
C_save_and_reclaim((void *)f_3670,2,av);}
/* posix-common.scm:504: ##sys#glob->regexp */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[91]+1));
C_word *av2;
if(c >= 3) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(3);
}
av2[0]=*((C_word*)lf[91]+1);
av2[1]=((C_word*)t0)[2];
av2[2]=t1;
tp(3,av2);}}

/* open-output-file* in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_3104(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand((c-3)*C_SIZEOF_PAIR +5,c,4)))){
C_save_and_reclaim((void*)f_3104,c,av);}
a=C_alloc((c-3)*C_SIZEOF_PAIR+5);
t3=C_build_rest(&a,c,3,av);
C_word t4;
C_word t5;
C_word t6;
t4=C_i_check_exact_2(t2,lf[61]);
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3116,a[2]=t2,a[3]=((C_word*)t0)[2],a[4]=t1,tmp=(C_word)a,a+=5,tmp);
/* posix-common.scm:381: mode */
f_3038(t5,C_SCHEME_FALSE,t3,lf[61]);}

/* k3100 in open-input-file* in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_3102(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(2,c,5)))){
C_save_and_reclaim((void *)f_3102,2,av);}
a=C_alloc(2);
t2=C_fdopen(&a,2,((C_word*)t0)[2],t1);
/* posix-common.scm:377: check */
f_3075(((C_word*)t0)[4],lf[60],((C_word*)t0)[2],C_SCHEME_TRUE,t2);}

/* k3132 in port->fileno in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_3134(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_3134,2,av);}
t2=((C_word*)t0)[2];{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=t2;
av2[1]=C_slot(t1,C_fix(0));
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* k5902 in k5869 in k5866 in get-groups in k5687 in k5683 in k5679 in k5675 in k5595 in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_5904(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,3)))){
C_save_and_reclaim((void *)f_5904,2,av);}
/* posixunix.scm:938: ##sys#error */
t2=*((C_word*)lf[50]+1);{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[2];
av2[2]=lf[272];
av2[3]=lf[273];
((C_proc)(void*)(*((C_word*)t2+1)))(4,av2);}}

/* loop in k3691 in k3684 in k3681 in k3872 in k3869 in k3866 in k3863 in k3860 in k3857 in find-files in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_fcall f_3695(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(14,0,3)))){
C_save_and_reclaim_args((void *)trf_3695,5,t0,t1,t2,t3,t4);}
a=C_alloc(14);
if(C_truep(C_i_nullp(t3))){
t5=t4;
t6=t1;{
C_word av2[2];
av2[0]=t6;
av2[1]=t5;
((C_proc)(void*)(*((C_word*)t6+1)))(2,av2);}}
else{
t5=C_slot(t3,C_fix(0));
t6=t5;
t7=(*a=C_CLOSURE_TYPE|13,a[1]=(C_word)f_3708,a[2]=t3,a[3]=t6,a[4]=((C_word*)t0)[2],a[5]=t1,a[6]=t2,a[7]=t4,a[8]=((C_word*)t0)[3],a[9]=((C_word*)t0)[4],a[10]=((C_word*)t0)[5],a[11]=((C_word*)t0)[6],a[12]=((C_word*)t0)[7],a[13]=((C_word*)t0)[8],tmp=(C_word)a,a+=14,tmp);
/* posix-common.scm:535: make-pathname */
t8=*((C_word*)lf[83]+1);{
C_word av2[4];
av2[0]=t8;
av2[1]=t7;
av2[2]=t2;
av2[3]=t6;
((C_proc)(void*)(*((C_word*)t8+1)))(4,av2);}}}

/* k3691 in k3684 in k3681 in k3872 in k3869 in k3866 in k3863 in k3860 in k3857 in find-files in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_3693(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(12,c,5)))){
C_save_and_reclaim((void *)f_3693,2,av);}
a=C_alloc(12);
t2=C_SCHEME_UNDEFINED;
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=C_set_block_item(t3,0,(*a=C_CLOSURE_TYPE|9,a[1]=(C_word)f_3695,a[2]=t3,a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],a[6]=((C_word*)t0)[5],a[7]=((C_word*)t0)[6],a[8]=((C_word*)t0)[7],a[9]=((C_word)li43),tmp=(C_word)a,a+=10,tmp));
t5=((C_word*)t3)[1];
f_3695(t5,((C_word*)t0)[8],((C_word*)t0)[9],t1,((C_word*)t0)[10]);}

/* k7533 in unmap-file-from-memory in k6200 in k6169 in k5687 in k5683 in k5679 in k5675 in k5595 in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_fcall f_7535(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,0,6)))){
C_save_and_reclaim_args((void *)trf_7535,2,t0,t1);}
t2=C_slot(((C_word*)t0)[2],C_fix(1));
t3=(C_truep(t2)?C_i_foreign_pointer_argumentp(t2):C_SCHEME_FALSE);
t4=C_i_foreign_integer_argumentp(t1);
t5=stub1761(C_SCHEME_UNDEFINED,t3,t4);
t6=C_eqp(C_fix(0),t5);
if(C_truep(t6)){
t7=C_SCHEME_UNDEFINED;
t8=((C_word*)t0)[3];{
C_word av2[2];
av2[0]=t8;
av2[1]=t7;
((C_proc)(void*)(*((C_word*)t8+1)))(2,av2);}}
else{
/* posixunix.scm:1429: posix-error */
t7=lf[0];{
C_word av2[7];
av2[0]=t7;
av2[1]=((C_word*)t0)[3];
av2[2]=lf[8];
av2[3]=lf[394];
av2[4]=lf[395];
av2[5]=((C_word*)t0)[2];
av2[6]=t1;
f_2704(7,av2);}}}

/* duplicate-fileno in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_3166(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand((c-3)*C_SIZEOF_PAIR +4,c,2)))){
C_save_and_reclaim((void*)f_3166,c,av);}
a=C_alloc((c-3)*C_SIZEOF_PAIR+4);
t3=C_build_rest(&a,c,3,av);
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
t4=C_i_check_exact_2(t2,*((C_word*)lf[66]+1));
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3173,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
if(C_truep(C_i_nullp(t3))){
t6=t5;
f_3173(t6,C_dup(t2));}
else{
t6=C_i_car(t3);
t7=C_i_check_exact_2(t6,lf[66]);
t8=t5;
f_3173(t8,C_dup2(t2,t6));}}

/* k6820 in a6811 in k6397 in k6391 in custom-input-port in k6200 in k6169 in k5687 in k5683 in k5679 in k5675 in k5595 in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 in ... */
static void C_ccall f_6822(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_6822,2,av);}
t2=C_mutate2(((C_word *)((C_word*)t0)[2])+1,((C_word*)((C_word*)t0)[3])[1]);
t3=((C_word*)t0)[4];{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=t3;
av2[1]=t1;
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* k3158 in port->fileno in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_3160(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,5)))){
C_save_and_reclaim((void *)f_3160,2,av);}
a=C_alloc(4);
if(C_truep(C_i_zerop(t1))){
/* posix-common.scm:397: posix-error */
t2=lf[0];{
C_word *av2;
if(c >= 6) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(6);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[2];
av2[2]=lf[13];
av2[3]=lf[10];
av2[4]=lf[63];
av2[5]=((C_word*)t0)[3];
f_2704(6,av2);}}
else{
t2=C_C_fileno(((C_word*)t0)[3]);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3143,a[2]=((C_word*)t0)[2],a[3]=t2,tmp=(C_word)a,a+=4,tmp);
if(C_truep(C_fixnum_lessp(t2,C_fix(0)))){
/* posix-common.scm:395: posix-error */
t4=lf[0];{
C_word *av2;
if(c >= 6) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(6);
}
av2[0]=t4;
av2[1]=t3;
av2[2]=lf[8];
av2[3]=lf[10];
av2[4]=lf[64];
av2[5]=((C_word*)t0)[3];
f_2704(6,av2);}}
else{
t4=((C_word*)t0)[2];{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=t4;
av2[1]=t2;
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}}}

/* k3684 in k3681 in k3872 in k3869 in k3866 in k3863 in k3860 in k3857 in find-files in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_fcall f_3686(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(11,0,3)))){
C_save_and_reclaim_args((void *)trf_3686,2,t0,t1);}
a=C_alloc(11);
t2=t1;
t3=(*a=C_CLOSURE_TYPE|10,a[1]=(C_word)f_3693,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t2,a[5]=((C_word*)t0)[4],a[6]=((C_word*)t0)[5],a[7]=((C_word*)t0)[6],a[8]=((C_word*)t0)[7],a[9]=((C_word*)t0)[8],a[10]=((C_word*)t0)[9],tmp=(C_word)a,a+=11,tmp);
/* posix-common.scm:530: directory */
t4=*((C_word*)lf[26]+1);{
C_word av2[4];
av2[0]=t4;
av2[1]=t3;
av2[2]=((C_word*)t0)[8];
av2[3]=((C_word*)t0)[5];
((C_proc)(void*)(*((C_word*)t4+1)))(4,av2);}}

/* k3681 in k3872 in k3869 in k3866 in k3863 in k3860 in k3857 in find-files in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_fcall f_3683(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(13,0,2)))){
C_save_and_reclaim_args((void *)trf_3683,2,t0,t1);}
a=C_alloc(13);
t2=t1;
t3=(*a=C_CLOSURE_TYPE|9,a[1]=(C_word)f_3686,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=t2,a[7]=((C_word*)t0)[6],a[8]=((C_word*)t0)[7],a[9]=((C_word*)t0)[8],tmp=(C_word)a,a+=10,tmp);
if(C_truep(C_i_closurep(((C_word*)t0)[9]))){
t4=t3;
f_3686(t4,((C_word*)t0)[9]);}
else{
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3832,a[2]=t3,tmp=(C_word)a,a+=3,tmp);
/* posix-common.scm:527: irregex */
t5=*((C_word*)lf[96]+1);{
C_word av2[3];
av2[0]=t5;
av2[1]=t4;
av2[2]=((C_word*)t0)[9];
((C_proc)(void*)(*((C_word*)t5+1)))(3,av2);}}}

/* k3114 in open-output-file* in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_3116(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(2,c,5)))){
C_save_and_reclaim((void *)f_3116,2,av);}
a=C_alloc(2);
t2=C_fdopen(&a,2,((C_word*)t0)[2],t1);
/* posix-common.scm:381: check */
f_3075(((C_word*)t0)[4],lf[61],((C_word*)t0)[2],C_SCHEME_FALSE,t2);}

/* port->fileno in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_3118(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(4,c,3)))){
C_save_and_reclaim((void *)f_3118,3,av);}
a=C_alloc(4);
t3=t2;
t4=C_i_check_port_2(t3,C_fix(0),C_SCHEME_TRUE,lf[10]);
t5=C_slot(t2,C_fix(7));
t6=C_eqp(lf[30],t5);
if(C_truep(t6)){
t7=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3134,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posix-common.scm:391: ##sys#port-data */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[62]+1));
C_word *av2=av; /* Re-use our own argvector */
av2[0]=*((C_word*)lf[62]+1);
av2[1]=t7;
av2[2]=t2;
tp(3,av2);}}
else{
t7=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3160,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* posix-common.scm:392: ##sys#peek-unsigned-integer */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[65]+1));
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[65]+1);
av2[1]=t7;
av2[2]=t2;
av2[3]=C_fix(0);
tp(4,av2);}}}

/* k2713 in k2706 in posix-error in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_2715(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,6)))){
C_save_and_reclaim((void *)f_2715,2,av);}{
C_word *av2;
if(c >= 7) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(7);
}
av2[0]=0;
av2[1]=((C_word*)t0)[2];
av2[2]=*((C_word*)lf[1]+1);
av2[3]=((C_word*)t0)[3];
av2[4]=((C_word*)t0)[4];
av2[5]=t1;
av2[6]=((C_word*)t0)[5];
C_apply(7,av2);}}

/* k3141 in k3158 in port->fileno in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_3143(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_3143,2,av);}
t2=((C_word*)t0)[2];{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=t2;
av2[1]=((C_word*)t0)[3];
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* k2717 in k2706 in posix-error in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_2719(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,4)))){
C_save_and_reclaim((void *)f_2719,2,av);}
/* posix-common.scm:185: string-append */
t2=*((C_word*)lf[2]+1);{
C_word *av2;
if(c >= 5) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(5);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[2];
av2[2]=((C_word*)t0)[3];
av2[3]=lf[3];
av2[4]=t1;
((C_proc)(void*)(*((C_word*)t2+1)))(5,av2);}}

/* k2706 in posix-error in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_2708(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(15,c,3)))){
C_save_and_reclaim((void *)f_2708,2,av);}
a=C_alloc(15);
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_2715,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],tmp=(C_word)a,a+=6,tmp);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2719,a[2]=t2,a[3]=((C_word*)t0)[6],tmp=(C_word)a,a+=4,tmp);
t4=C_a_i_bytevector(&a,1,C_fix(3));
t5=C_i_foreign_fixnum_argumentp(t1);
t6=stub67(t4,t5);
/* posix-common.scm:181: ##sys#peek-c-string */
t7=*((C_word*)lf[4]+1);{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=t7;
av2[1]=t3;
av2[2]=t6;
av2[3]=C_fix(0);
((C_proc)(void*)(*((C_word*)t7+1)))(4,av2);}}

/* posix-error in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_2704(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4=av[4];
C_word t5;
C_word *a;
if(c<5) C_bad_min_argc_2(c,5,t0);
if(C_unlikely(!C_demand(C_calculate_demand((c-5)*C_SIZEOF_PAIR +7,c,2)))){
C_save_and_reclaim((void*)f_2704,c,av);}
a=C_alloc((c-5)*C_SIZEOF_PAIR+7);
t5=C_build_rest(&a,c,5,av);
C_word t6;
C_word t7;
t6=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_2708,a[2]=t1,a[3]=t2,a[4]=t3,a[5]=t5,a[6]=t4,tmp=(C_word)a,a+=7,tmp);
/* posix-common.scm:184: ##sys#update-errno */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[5]+1));
C_word *av2=av; /* Re-use our own argvector */
av2[0]=*((C_word*)lf[5]+1);
av2[1]=t6;
tp(2,av2);}}

/* k3171 in duplicate-fileno in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_fcall f_3173(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,0,5)))){
C_save_and_reclaim_args((void *)trf_3173,2,t0,t1);}
a=C_alloc(4);
t2=t1;
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3176,a[2]=((C_word*)t0)[2],a[3]=t2,tmp=(C_word)a,a+=4,tmp);
if(C_truep(C_fixnum_lessp(t2,C_fix(0)))){
/* posix-common.scm:408: posix-error */
t4=lf[0];{
C_word av2[6];
av2[0]=t4;
av2[1]=t3;
av2[2]=lf[8];
av2[3]=lf[66];
av2[4]=lf[67];
av2[5]=((C_word*)t0)[3];
f_2704(6,av2);}}
else{
t4=((C_word*)t0)[2];{
C_word av2[2];
av2[0]=t4;
av2[1]=t2;
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}}

/* k3174 in k3171 in duplicate-fileno in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_3176(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_3176,2,av);}
t2=((C_word*)t0)[2];{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=t2;
av2[1]=((C_word*)t0)[3];
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* unmap-file-from-memory in k6200 in k6169 in k5687 in k5683 in k5679 in k5675 in k5595 in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_7528(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand((c-3)*C_SIZEOF_PAIR +4,c,2)))){
C_save_and_reclaim((void*)f_7528,c,av);}
a=C_alloc((c-3)*C_SIZEOF_PAIR+4);
t3=C_build_rest(&a,c,3,av);
C_word t4;
C_word t5;
C_word t6;
C_word t7;
t4=C_i_check_structure_2(t2,lf[389],lf[394]);
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_7535,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
if(C_truep(C_i_pairp(t3))){
t6=t3;
t7=t5;
f_7535(t7,C_u_i_car(t6));}
else{
t6=t5;
f_7535(t6,C_slot(t2,C_fix(2)));}}

/* k3715 in k3706 in loop in k3691 in k3684 in k3681 in k3872 in k3869 in k3866 in k3863 in k3860 in k3857 in find-files in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_3717(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(14,c,4)))){
C_save_and_reclaim((void *)f_3717,2,av);}
a=C_alloc(14);
if(C_truep(t1)){
if(C_truep((C_truep(C_i_equalp(((C_word*)t0)[2],lf[93]))?C_SCHEME_TRUE:(C_truep(C_i_equalp(((C_word*)t0)[2],lf[94]))?C_SCHEME_TRUE:C_SCHEME_FALSE)))){
/* posix-common.scm:538: loop */
t2=((C_word*)((C_word*)t0)[3])[1];
f_3695(t2,((C_word*)t0)[4],((C_word*)t0)[5],((C_word*)t0)[6],((C_word*)t0)[7]);}
else{
t2=(*a=C_CLOSURE_TYPE|13,a[1]=(C_word)f_3807,a[2]=((C_word*)t0)[8],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[6],a[7]=((C_word*)t0)[9],a[8]=((C_word*)t0)[10],a[9]=((C_word*)t0)[7],a[10]=((C_word*)t0)[11],a[11]=((C_word*)t0)[12],a[12]=((C_word*)t0)[13],a[13]=((C_word*)t0)[14],tmp=(C_word)a,a+=14,tmp);
/* posix-common.scm:539: symbolic-link? */
t3=*((C_word*)lf[32]+1);{
C_word *av2;
if(c >= 3) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(3);
}
av2[0]=t3;
av2[1]=t2;
av2[2]=((C_word*)t0)[10];
((C_proc)(void*)(*((C_word*)t3+1)))(3,av2);}}}
else{
t2=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_3816,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[6],a[6]=((C_word*)t0)[9],a[7]=((C_word*)t0)[10],a[8]=((C_word*)t0)[7],tmp=(C_word)a,a+=9,tmp);
/* posix-common.scm:549: pproc */
t3=((C_word*)t0)[11];{
C_word *av2;
if(c >= 3) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(3);
}
av2[0]=t3;
av2[1]=t2;
av2[2]=((C_word*)t0)[10];
((C_proc)(void*)(*((C_word*)t3+1)))(3,av2);}}}

/* memory-mapped-file? in k6200 in k6169 in k5687 in k5683 in k5679 in k5675 in k5595 in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_7570(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_7570,3,av);}
t3=t1;{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=t3;
av2[1]=C_i_structurep(t2,lf[389]);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* k5930 in set-groups! in k5687 in k5683 in k5679 in k5675 in k5595 in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_5932(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(7,c,4)))){
C_save_and_reclaim((void *)f_5932,2,av);}
a=C_alloc(7);
t2=C_SCHEME_UNDEFINED;
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=C_set_block_item(t3,0,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_5937,a[2]=((C_word*)t0)[2],a[3]=t3,a[4]=((C_word)li143),tmp=(C_word)a,a+=5,tmp));
t5=((C_word*)t3)[1];
f_5937(t5,((C_word*)t0)[3],((C_word*)t0)[2],C_fix(0));}

/* doloop1297 in k5930 in set-groups! in k5687 in k5683 in k5679 in k5675 in k5595 in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_fcall f_5937(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word *a;
loop:
if(C_unlikely(!C_demand(C_calculate_demand(4,0,3)))){
C_save_and_reclaim_args((void *)trf_5937,4,t0,t1,t2,t3);}
a=C_alloc(4);
if(C_truep(C_i_nullp(t2))){
t4=C_set_groups(t3);
if(C_truep(C_fixnum_lessp(t4,C_fix(0)))){
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5953,a[2]=t1,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm:951: ##sys#update-errno */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[5]+1));
C_word av2[2];
av2[0]=*((C_word*)lf[5]+1);
av2[1]=t5;
tp(2,av2);}}
else{
t5=t1;{
C_word av2[2];
av2[0]=t5;
av2[1]=C_SCHEME_UNDEFINED;
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}}
else{
t4=C_slot(t2,C_fix(0));
t5=C_i_check_exact_2(t4,lf[276]);
t6=C_set_gid(t3,t4);
t7=C_slot(t2,C_fix(1));
t8=C_fixnum_plus(t3,C_fix(1));
t10=t1;
t11=t7;
t12=t8;
t1=t10;
t2=t11;
t3=t12;
goto loop;}}

/* signal-masked? in k5595 in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_5599(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_5599,3,av);}
t3=C_i_check_exact_2(t2,lf[254]);
t4=C_sigprocmask_get(C_fix(0));
t5=t1;{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=t5;
av2[1]=C_sigismember(t2);
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}

/* k5595 in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_5597(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(21,c,4)))){
C_save_and_reclaim((void *)f_5597,2,av);}
a=C_alloc(21);
t2=C_mutate2((C_word*)lf[253]+1 /* (set! signal-mask ...) */,t1);
t3=C_mutate2((C_word*)lf[254]+1 /* (set! signal-masked? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5599,a[2]=((C_word)li132),tmp=(C_word)a,a+=3,tmp));
t4=C_mutate2((C_word*)lf[255]+1 /* (set! signal-mask! ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5605,a[2]=((C_word)li133),tmp=(C_word)a,a+=3,tmp));
t5=C_mutate2((C_word*)lf[257]+1 /* (set! signal-unmask! ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5621,a[2]=((C_word)li134),tmp=(C_word)a,a+=3,tmp));
t6=C_mutate2((C_word*)lf[259]+1 /* (set! system-information ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5637,a[2]=((C_word)li135),tmp=(C_word)a,a+=3,tmp));
t7=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5677,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
t8=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_8672,a[2]=((C_word)li256),tmp=(C_word)a,a+=3,tmp);
t9=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_8675,a[2]=((C_word)li257),tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm:826: getter-with-setter */
t10=*((C_word*)lf[450]+1);{
C_word *av2;
if(c >= 5) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(5);
}
av2[0]=t10;
av2[1]=t7;
av2[2]=t8;
av2[3]=t9;
av2[4]=lf[462];
((C_proc)(void*)(*((C_word*)t10+1)))(5,av2);}}

/* k3706 in loop in k3691 in k3684 in k3681 in k3872 in k3869 in k3866 in k3863 in k3860 in k3857 in find-files in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_3708(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(15,c,2)))){
C_save_and_reclaim((void *)f_3708,2,av);}
a=C_alloc(15);
t2=t1;
t3=C_slot(((C_word*)t0)[2],C_fix(1));
t4=t3;
t5=(*a=C_CLOSURE_TYPE|14,a[1]=(C_word)f_3717,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[6],a[6]=t4,a[7]=((C_word*)t0)[7],a[8]=((C_word*)t0)[8],a[9]=((C_word*)t0)[9],a[10]=t2,a[11]=((C_word*)t0)[10],a[12]=((C_word*)t0)[11],a[13]=((C_word*)t0)[12],a[14]=((C_word*)t0)[13],tmp=(C_word)a,a+=15,tmp);
/* posix-common.scm:537: directory? */
t6=*((C_word*)lf[37]+1);{
C_word *av2;
if(c >= 3) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(3);
}
av2[0]=t6;
av2[1]=t5;
av2[2]=t2;
((C_proc)(void*)(*((C_word*)t6+1)))(3,av2);}}

/* string->time in k6200 in k6169 in k5687 in k5683 in k5679 in k5675 in k5595 in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_7585(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand((c-3)*C_SIZEOF_PAIR +5,c,3)))){
C_save_and_reclaim((void*)f_7585,c,av);}
a=C_alloc((c-3)*C_SIZEOF_PAIR+5);
t3=C_build_rest(&a,c,3,av);
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
t4=C_i_nullp(t3);
t5=(C_truep(t4)?lf[399]:C_i_car(t3));
t6=t5;
t7=C_i_check_string_2(t2,lf[398]);
t8=C_i_check_string_2(t6,lf[398]);
t9=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_7602,a[2]=t1,a[3]=((C_word*)t0)[2],a[4]=t6,tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm:1446: ##sys#make-c-string */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[11]+1));
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[11]+1);
av2[1]=t9;
av2[2]=t2;
av2[3]=lf[398];
tp(4,av2);}}

/* k2749 in k2745 in stat in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_2751(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_2751,2,av);}
t2=C_fstat(t1);
t3=((C_word*)t0)[2];{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=t3;
av2[1]=t2;
f_2726(2,av2);}}

/* k6086 in change-file-mode in k5687 in k5683 in k5679 in k5675 in k5595 in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_6088(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,6)))){
C_save_and_reclaim((void *)f_6088,2,av);}
t2=C_chmod(t1,((C_word*)t0)[2]);
if(C_truep(C_fixnum_lessp(t2,C_fix(0)))){
/* posixunix.scm:1017: posix-error */
t3=lf[0];{
C_word *av2;
if(c >= 7) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(7);
}
av2[0]=t3;
av2[1]=((C_word*)t0)[3];
av2[2]=lf[8];
av2[3]=lf[320];
av2[4]=lf[321];
av2[5]=((C_word*)t0)[4];
av2[6]=((C_word*)t0)[2];
f_2704(7,av2);}}
else{
t3=C_SCHEME_UNDEFINED;
t4=((C_word*)t0)[3];{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=t4;
av2[1]=t3;
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}}

/* k5951 in doloop1297 in k5930 in set-groups! in k5687 in k5683 in k5679 in k5675 in k5595 in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_5953(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,4)))){
C_save_and_reclaim((void *)f_5953,2,av);}
/* posixunix.scm:952: ##sys#error */
t2=*((C_word*)lf[50]+1);{
C_word *av2;
if(c >= 5) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(5);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[2];
av2[2]=lf[276];
av2[3]=lf[277];
av2[4]=((C_word*)t0)[3];
((C_proc)(void*)(*((C_word*)t2+1)))(5,av2);}}

/* k2745 in stat in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_2747(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(8,c,5)))){
C_save_and_reclaim((void *)f_2747,2,av);}
a=C_alloc(8);
if(C_truep(t1)){
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2751,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
/* posix-common.scm:225: port->fileno */
t3=*((C_word*)lf[10]+1);{
C_word *av2;
if(c >= 3) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(3);
}
av2[0]=t3;
av2[1]=t2;
av2[2]=((C_word*)t0)[3];
((C_proc)(void*)(*((C_word*)t3+1)))(3,av2);}}
else{
if(C_truep(C_i_stringp(((C_word*)t0)[3]))){
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2760,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2767,a[2]=t2,a[3]=((C_word*)t0)[5],tmp=(C_word)a,a+=4,tmp);
/* posix-common.scm:228: ##sys#platform-fixup-pathname */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[12]+1));
C_word *av2;
if(c >= 3) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(3);
}
av2[0]=*((C_word*)lf[12]+1);
av2[1]=t3;
av2[2]=((C_word*)t0)[3];
tp(3,av2);}}
else{
/* posix-common.scm:235: ##sys#signal-hook */
t2=*((C_word*)lf[1]+1);{
C_word *av2;
if(c >= 6) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(6);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[2];
av2[2]=lf[13];
av2[3]=((C_word*)t0)[5];
av2[4]=lf[14];
av2[5]=((C_word*)t0)[3];
((C_proc)(void*)(*((C_word*)t2+1)))(6,av2);}}}}

/* memory-mapped-file-pointer in k6200 in k6169 in k5687 in k5683 in k5679 in k5675 in k5595 in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_7561(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_7561,3,av);}
t3=C_i_check_structure_2(t2,lf[389],lf[396]);
t4=t1;{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=t4;
av2[1]=C_slot(t2,C_fix(1));
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* change-file-owner in k5687 in k5683 in k5679 in k5675 in k5595 in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_6090(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4=av[4];
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word *a;
if(c!=5) C_bad_argc_2(c,5,t0);
if(C_unlikely(!C_demand(C_calculate_demand(6,c,3)))){
C_save_and_reclaim((void *)f_6090,5,av);}
a=C_alloc(6);
t5=C_i_check_string_2(t2,lf[322]);
t6=C_i_check_exact_2(t3,lf[322]);
t7=C_i_check_exact_2(t4,lf[322]);
t8=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_6114,a[2]=t3,a[3]=t4,a[4]=t1,a[5]=t2,tmp=(C_word)a,a+=6,tmp);
/* posixunix.scm:1024: ##sys#make-c-string */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[11]+1));
C_word *av2=av; /* Re-use our own argvector */
av2[0]=*((C_word*)lf[11]+1);
av2[1]=t8;
av2[2]=t2;
av2[3]=lf[322];
tp(4,av2);}}

/* a6811 in k6397 in k6391 in custom-input-port in k6200 in k6169 in k5687 in k5683 in k5679 in k5675 in k5595 in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_6812(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(5,c,4)))){
C_save_and_reclaim((void *)f_6812,3,av);}
a=C_alloc(5);
if(C_truep(C_fixnum_greater_or_equal_p(((C_word*)((C_word*)t0)[2])[1],((C_word*)((C_word*)t0)[3])[1]))){
t3=t1;{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=t3;
av2[1]=lf[357];
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}
else{
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_6822,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t1,tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm:1242: ##sys#substring */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[70]+1));
C_word *av2;
if(c >= 5) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(5);
}
av2[0]=*((C_word*)lf[70]+1);
av2[1]=t3;
av2[2]=((C_word*)t0)[4];
av2[3]=((C_word*)((C_word*)t0)[2])[1];
av2[4]=((C_word*)((C_word*)t0)[3])[1];
tp(5,av2);}}}

/* file-stat in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_2772(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand((c-3)*C_SIZEOF_PAIR +3,c,5)))){
C_save_and_reclaim((void*)f_2772,c,av);}
a=C_alloc((c-3)*C_SIZEOF_PAIR+3);
t3=C_build_rest(&a,c,3,av);
C_word t4;
C_word t5;
C_word t6;
C_word t7;
t4=C_i_nullp(t3);
t5=(C_truep(t4)?C_SCHEME_FALSE:C_i_car(t3));
t6=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2779,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posix-common.scm:244: ##sys#stat */
f_2722(t6,t2,t5,C_SCHEME_TRUE,lf[16]);}

/* k2777 in file-stat in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_2779(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(30,c,1)))){
C_save_and_reclaim((void *)f_2779,2,av);}
a=C_alloc(30);
t2=((C_word*)t0)[2];{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=t2;
av2[1]=C_a_i_vector(&a,13,C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)C_statbuf.st_ino),C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)C_statbuf.st_mode),C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)C_statbuf.st_nlink),C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)C_statbuf.st_uid),C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)C_statbuf.st_gid),C_a_double_to_num(&a,C_statbuf.st_size),C_flonum(&a,C_statbuf.st_atime),C_flonum(&a,C_statbuf.st_ctime),C_flonum(&a,C_statbuf.st_mtime),C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)C_statbuf.st_dev),C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)C_statbuf.st_rdev),C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)C_statbuf.st_blksize),C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)C_statbuf.st_blocks));
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* k2758 in k2745 in stat in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_2760(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_2760,2,av);}
if(C_truep(((C_word*)t0)[2])){
t2=C_lstat(t1);
t3=((C_word*)t0)[3];{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=t3;
av2[1]=t2;
f_2726(2,av2);}}
else{
t2=C_stat(t1);
t3=((C_word*)t0)[3];{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=t3;
av2[1]=t2;
f_2726(2,av2);}}}

/* k2765 in k2745 in stat in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_2767(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,3)))){
C_save_and_reclaim((void *)f_2767,2,av);}
/* posix-common.scm:227: ##sys#make-c-string */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[11]+1));
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[11]+1);
av2[1]=((C_word*)t0)[2];
av2[2]=t1;
av2[3]=((C_word*)t0)[3];
tp(4,av2);}}

/* k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_2792(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word t17;
C_word t18;
C_word t19;
C_word t20;
C_word t21;
C_word t22;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(48,c,4)))){
C_save_and_reclaim((void *)f_2792,2,av);}
a=C_alloc(48);
t2=C_mutate2((C_word*)lf[17]+1 /* (set! file-modification-time ...) */,t1);
t3=C_mutate2((C_word*)lf[18]+1 /* (set! file-access-time ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2794,a[2]=((C_word)li3),tmp=(C_word)a,a+=3,tmp));
t4=C_mutate2((C_word*)lf[19]+1 /* (set! file-change-time ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2800,a[2]=((C_word)li4),tmp=(C_word)a,a+=3,tmp));
t5=C_mutate2((C_word*)lf[20]+1 /* (set! file-owner ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2806,a[2]=((C_word)li5),tmp=(C_word)a,a+=3,tmp));
t6=C_mutate2((C_word*)lf[21]+1 /* (set! file-permissions ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2812,a[2]=((C_word)li6),tmp=(C_word)a,a+=3,tmp));
t7=C_mutate2((C_word*)lf[22]+1 /* (set! file-size ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2818,a[2]=((C_word)li7),tmp=(C_word)a,a+=3,tmp));
t8=C_mutate2((C_word*)lf[23]+1 /* (set! file-type ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2824,a[2]=((C_word)li8),tmp=(C_word)a,a+=3,tmp));
t9=C_mutate2((C_word*)lf[31]+1 /* (set! regular-file? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2911,a[2]=((C_word)li9),tmp=(C_word)a,a+=3,tmp));
t10=C_mutate2((C_word*)lf[32]+1 /* (set! symbolic-link? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2921,a[2]=((C_word)li10),tmp=(C_word)a,a+=3,tmp));
t11=C_mutate2((C_word*)lf[33]+1 /* (set! block-device? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2931,a[2]=((C_word)li11),tmp=(C_word)a,a+=3,tmp));
t12=C_mutate2((C_word*)lf[34]+1 /* (set! character-device? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2941,a[2]=((C_word)li12),tmp=(C_word)a,a+=3,tmp));
t13=C_mutate2((C_word*)lf[35]+1 /* (set! fifo? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2951,a[2]=((C_word)li13),tmp=(C_word)a,a+=3,tmp));
t14=C_mutate2((C_word*)lf[36]+1 /* (set! socket? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2961,a[2]=((C_word)li14),tmp=(C_word)a,a+=3,tmp));
t15=C_mutate2((C_word*)lf[37]+1 /* (set! directory? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2971,a[2]=((C_word)li15),tmp=(C_word)a,a+=3,tmp));
t16=C_mutate2((C_word*)lf[38]+1 /* (set! seek/set ...) */,C_fix((C_word)SEEK_SET));
t17=C_mutate2((C_word*)lf[39]+1 /* (set! seek/end ...) */,C_fix((C_word)SEEK_END));
t18=C_mutate2((C_word*)lf[40]+1 /* (set! seek/cur ...) */,C_fix((C_word)SEEK_CUR));
t19=C_mutate2((C_word*)lf[41]+1 /* (set! set-file-position! ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2984,a[2]=((C_word)li16),tmp=(C_word)a,a+=3,tmp));
t20=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3033,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
t21=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_8765,a[2]=((C_word)li263),tmp=(C_word)a,a+=3,tmp);
/* posix-common.scm:330: getter-with-setter */
t22=*((C_word*)lf[450]+1);{
C_word *av2;
if(c >= 5) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(5);
}
av2[0]=t22;
av2[1]=t20;
av2[2]=t21;
av2[3]=*((C_word*)lf[41]+1);
av2[4]=lf[466];
((C_proc)(void*)(*((C_word*)t22+1)))(5,av2);}}

/* k2796 in file-access-time in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_2798(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,1)))){
C_save_and_reclaim((void *)f_2798,2,av);}
a=C_alloc(4);
t2=((C_word*)t0)[2];{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=t2;
av2[1]=C_flonum(&a,C_statbuf.st_atime);
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* ##sys#read-symbolic-link in k6200 in k6169 in k5687 in k5683 in k5679 in k5675 in k5595 in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_6203(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word t5;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(6,c,3)))){
C_save_and_reclaim((void *)f_6203,4,av);}
a=C_alloc(6);
t4=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_6208,a[2]=((C_word*)t0)[2],a[3]=t1,a[4]=t3,a[5]=t2,tmp=(C_word)a,a+=6,tmp);
/* posixunix.scm:1086: ##sys#make-c-string */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[11]+1));
C_word *av2=av; /* Re-use our own argvector */
av2[0]=*((C_word*)lf[11]+1);
av2[1]=t4;
av2[2]=t2;
av2[3]=t3;
tp(4,av2);}}

/* k6200 in k6169 in k5687 in k5683 in k5679 in k5675 in k5595 in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_6202(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word t17;
C_word t18;
C_word t19;
C_word t20;
C_word t21;
C_word t22;
C_word t23;
C_word t24;
C_word t25;
C_word t26;
C_word t27;
C_word t28;
C_word t29;
C_word t30;
C_word t31;
C_word t32;
C_word t33;
C_word t34;
C_word t35;
C_word t36;
C_word t37;
C_word t38;
C_word t39;
C_word t40;
C_word t41;
C_word t42;
C_word t43;
C_word t44;
C_word t45;
C_word t46;
C_word t47;
C_word t48;
C_word t49;
C_word t50;
C_word t51;
C_word t52;
C_word t53;
C_word t54;
C_word t55;
C_word t56;
C_word t57;
C_word t58;
C_word t59;
C_word t60;
C_word t61;
C_word t62;
C_word t63;
C_word t64;
C_word t65;
C_word t66;
C_word t67;
C_word t68;
C_word t69;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(177,c,9)))){
C_save_and_reclaim((void *)f_6202,2,av);}
a=C_alloc(177);
t2=t1;
t3=C_mutate2((C_word*)lf[333]+1 /* (set! ##sys#read-symbolic-link ...) */,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_6203,a[2]=t2,a[3]=((C_word)li154),tmp=(C_word)a,a+=4,tmp));
t4=C_mutate2((C_word*)lf[336]+1 /* (set! read-symbolic-link ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6222,a[2]=((C_word)li158),tmp=(C_word)a,a+=3,tmp));
t5=C_mutate2((C_word*)lf[342]+1 /* (set! file-link ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6343,a[2]=((C_word)li159),tmp=(C_word)a,a+=3,tmp));
t6=C_mutate2((C_word*)lf[345]+1 /* (set! ##sys#custom-input-port ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6365,a[2]=((C_word)li174),tmp=(C_word)a,a+=3,tmp));
t7=C_mutate2((C_word*)lf[359]+1 /* (set! ##sys#custom-output-port ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6888,a[2]=((C_word)li183),tmp=(C_word)a,a+=3,tmp));
t8=C_mutate2((C_word*)lf[363]+1 /* (set! file-truncate ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_7149,a[2]=((C_word)li184),tmp=(C_word)a,a+=3,tmp));
t9=C_SCHEME_UNDEFINED;
t10=(*a=C_VECTOR_TYPE|1,a[1]=t9,tmp=(C_word)a,a+=2,tmp);
t11=C_SCHEME_UNDEFINED;
t12=(*a=C_VECTOR_TYPE|1,a[1]=t11,tmp=(C_word)a,a+=2,tmp);
t13=C_set_block_item(t10,0,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_7184,a[2]=((C_word)li185),tmp=(C_word)a,a+=3,tmp));
t14=C_set_block_item(t12,0,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_7248,a[2]=((C_word)li186),tmp=(C_word)a,a+=3,tmp));
t15=C_mutate2((C_word*)lf[367]+1 /* (set! file-lock ...) */,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_7266,a[2]=t12,a[3]=t10,a[4]=((C_word)li187),tmp=(C_word)a,a+=5,tmp));
t16=C_mutate2((C_word*)lf[369]+1 /* (set! file-lock/blocking ...) */,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_7282,a[2]=t12,a[3]=t10,a[4]=((C_word)li188),tmp=(C_word)a,a+=5,tmp));
t17=C_mutate2((C_word*)lf[371]+1 /* (set! file-test-lock ...) */,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_7298,a[2]=t12,a[3]=t10,a[4]=((C_word)li189),tmp=(C_word)a,a+=5,tmp));
t18=C_mutate2((C_word*)lf[373]+1 /* (set! file-unlock ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_7325,a[2]=((C_word)li190),tmp=(C_word)a,a+=3,tmp));
t19=C_mutate2((C_word*)lf[375]+1 /* (set! create-fifo ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_7353,a[2]=((C_word)li191),tmp=(C_word)a,a+=3,tmp));
t20=C_mutate2((C_word*)lf[35]+1 /* (set! fifo? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_7390,a[2]=((C_word)li192),tmp=(C_word)a,a+=3,tmp));
t21=C_mutate2((C_word*)lf[379]+1 /* (set! prot/read ...) */,C_fix((C_word)PROT_READ));
t22=C_mutate2((C_word*)lf[380]+1 /* (set! prot/write ...) */,C_fix((C_word)PROT_WRITE));
t23=C_mutate2((C_word*)lf[381]+1 /* (set! prot/exec ...) */,C_fix((C_word)PROT_EXEC));
t24=C_mutate2((C_word*)lf[382]+1 /* (set! prot/none ...) */,C_fix((C_word)PROT_NONE));
t25=C_mutate2((C_word*)lf[383]+1 /* (set! map/fixed ...) */,C_fix((C_word)MAP_FIXED));
t26=C_mutate2((C_word*)lf[384]+1 /* (set! map/shared ...) */,C_fix((C_word)MAP_SHARED));
t27=C_mutate2((C_word*)lf[385]+1 /* (set! map/private ...) */,C_fix((C_word)MAP_PRIVATE));
t28=C_mutate2((C_word*)lf[386]+1 /* (set! map/anonymous ...) */,C_fix((C_word)MAP_ANON));
t29=C_mutate2((C_word*)lf[387]+1 /* (set! map/file ...) */,C_fix((C_word)MAP_FILE));
t30=C_mutate2((C_word*)lf[388]+1 /* (set! map-file-to-memory ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_7468,a[2]=((C_word)li193),tmp=(C_word)a,a+=3,tmp));
t31=C_mutate2((C_word*)lf[394]+1 /* (set! unmap-file-from-memory ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_7528,a[2]=((C_word)li194),tmp=(C_word)a,a+=3,tmp));
t32=C_mutate2((C_word*)lf[396]+1 /* (set! memory-mapped-file-pointer ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_7561,a[2]=((C_word)li195),tmp=(C_word)a,a+=3,tmp));
t33=C_mutate2((C_word*)lf[397]+1 /* (set! memory-mapped-file? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_7570,a[2]=((C_word)li196),tmp=(C_word)a,a+=3,tmp));
t34=C_fix((C_word)sizeof(struct tm));
t35=C_mutate2((C_word*)lf[398]+1 /* (set! string->time ...) */,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_7585,a[2]=t34,a[3]=((C_word)li197),tmp=(C_word)a,a+=4,tmp));
t36=C_fix((C_word)sizeof(struct tm));
t37=C_mutate2((C_word*)lf[400]+1 /* (set! utc-time->seconds ...) */,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_7622,a[2]=t36,a[3]=((C_word)li198),tmp=(C_word)a,a+=4,tmp));
t38=C_mutate2((C_word*)lf[402]+1 /* (set! local-timezone-abbreviation ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_7641,a[2]=((C_word)li199),tmp=(C_word)a,a+=3,tmp));
t39=C_mutate2((C_word*)lf[403]+1 /* (set! _exit ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_7654,a[2]=((C_word)li200),tmp=(C_word)a,a+=3,tmp));
t40=C_mutate2((C_word*)lf[404]+1 /* (set! set-alarm! ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_7668,a[2]=((C_word)li201),tmp=(C_word)a,a+=3,tmp));
t41=C_mutate2((C_word*)lf[405]+1 /* (set! set-buffering-mode! ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_7675,a[2]=((C_word)li202),tmp=(C_word)a,a+=3,tmp));
t42=C_mutate2((C_word*)lf[412]+1 /* (set! terminal-port? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_7738,a[2]=((C_word)li203),tmp=(C_word)a,a+=3,tmp));
t43=C_mutate2(&lf[413] /* (set! ##sys#terminal-check ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_7756,a[2]=((C_word)li204),tmp=(C_word)a,a+=3,tmp));
t44=C_mutate2((C_word*)lf[415]+1 /* (set! terminal-name ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_7787,a[2]=((C_word)li205),tmp=(C_word)a,a+=3,tmp));
t45=C_mutate2((C_word*)lf[416]+1 /* (set! terminal-size ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_7811,a[2]=((C_word)li206),tmp=(C_word)a,a+=3,tmp));
t46=C_mutate2((C_word*)lf[421]+1 /* (set! get-host-name ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_7848,a[2]=((C_word)li207),tmp=(C_word)a,a+=3,tmp));
t47=C_mutate2((C_word*)lf[423]+1 /* (set! process-fork ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_7862,a[2]=((C_word)li210),tmp=(C_word)a,a+=3,tmp));
t48=C_mutate2((C_word*)lf[427]+1 /* (set! process-execute ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_7955,a[2]=((C_word)li213),tmp=(C_word)a,a+=3,tmp));
t49=C_mutate2((C_word*)lf[126]+1 /* (set! ##sys#process-wait ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_8015,a[2]=((C_word)li215),tmp=(C_word)a,a+=3,tmp));
t50=C_mutate2((C_word*)lf[429]+1 /* (set! parent-process-id ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_8053,a[2]=((C_word)li216),tmp=(C_word)a,a+=3,tmp));
t51=C_mutate2((C_word*)lf[430]+1 /* (set! sleep ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_8056,a[2]=((C_word)li217),tmp=(C_word)a,a+=3,tmp));
t52=C_mutate2((C_word*)lf[431]+1 /* (set! process-signal ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_8063,a[2]=((C_word)li218),tmp=(C_word)a,a+=3,tmp));
t53=C_mutate2((C_word*)lf[433]+1 /* (set! ##sys#shell-command ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_8088,a[2]=((C_word)li219),tmp=(C_word)a,a+=3,tmp));
t54=C_mutate2((C_word*)lf[437]+1 /* (set! ##sys#shell-command-arguments ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_8097,a[2]=((C_word)li220),tmp=(C_word)a,a+=3,tmp));
t55=C_mutate2((C_word*)lf[439]+1 /* (set! process-run ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_8103,a[2]=((C_word)li221),tmp=(C_word)a,a+=3,tmp));
t56=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_8157,a[2]=((C_word)li225),tmp=(C_word)a,a+=3,tmp);
t57=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_8194,a[2]=((C_word)li228),tmp=(C_word)a,a+=3,tmp);
t58=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_8214,a[2]=((C_word)li229),tmp=(C_word)a,a+=3,tmp);
t59=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_8226,a[2]=((C_word)li230),tmp=(C_word)a,a+=3,tmp);
t60=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_8241,a[2]=((C_word)li231),tmp=(C_word)a,a+=3,tmp);
t61=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_8255,a[2]=t60,a[3]=t59,a[4]=t57,a[5]=((C_word)li233),tmp=(C_word)a,a+=6,tmp);
t62=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_8300,a[2]=t58,a[3]=((C_word)li234),tmp=(C_word)a,a+=4,tmp);
t63=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_8311,a[2]=t58,a[3]=((C_word)li235),tmp=(C_word)a,a+=4,tmp);
t64=C_mutate2((C_word*)lf[441]+1 /* (set! ##sys#process ...) */,(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_8322,a[2]=t61,a[3]=t62,a[4]=t56,a[5]=t63,a[6]=((C_word)li238),tmp=(C_word)a,a+=7,tmp));
t65=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_8378,a[2]=((C_word)li243),tmp=(C_word)a,a+=3,tmp);
t66=C_mutate2((C_word*)lf[442]+1 /* (set! process ...) */,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_8449,a[2]=t65,a[3]=((C_word)li245),tmp=(C_word)a,a+=4,tmp));
t67=C_mutate2((C_word*)lf[443]+1 /* (set! process* ...) */,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_8497,a[2]=t65,a[3]=((C_word)li246),tmp=(C_word)a,a+=4,tmp));
t68=C_mutate2((C_word*)lf[445]+1 /* (set! set-root-directory! ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_8552,a[2]=((C_word)li247),tmp=(C_word)a,a+=3,tmp));
t69=((C_word*)t0)[2];{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=t69;
av2[1]=C_SCHEME_UNDEFINED;
((C_proc)(void*)(*((C_word*)t69+1)))(2,av2);}}

/* k7396 in fifo? in k6200 in k6169 in k5687 in k5683 in k5679 in k5675 in k5595 in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_7398(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,5)))){
C_save_and_reclaim((void *)f_7398,2,av);}
t2=C_i_fifo_p(t1);
switch(t2){
case C_SCHEME_TRUE:
t3=((C_word*)t0)[2];{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=t3;
av2[1]=C_SCHEME_TRUE;
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}
case C_SCHEME_FALSE:
t3=((C_word*)t0)[2];{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=t3;
av2[1]=C_SCHEME_FALSE;
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}
case C_fix(0):
/* posixunix.scm:1380: ##sys#signal-hook */
t3=*((C_word*)lf[1]+1);{
C_word *av2;
if(c >= 6) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(6);
}
av2[0]=t3;
av2[1]=((C_word*)t0)[2];
av2[2]=lf[8];
av2[3]=lf[35];
av2[4]=lf[377];
av2[5]=((C_word*)t0)[3];
((C_proc)(void*)(*((C_word*)t3+1)))(6,av2);}
default:
/* posixunix.scm:1382: posix-error */
t3=lf[0];{
C_word *av2;
if(c >= 6) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(6);
}
av2[0]=t3;
av2[1]=((C_word*)t0)[2];
av2[2]=lf[8];
av2[3]=lf[35];
av2[4]=lf[378];
av2[5]=((C_word*)t0)[3];
f_2704(6,av2);}}}

/* file-access-time in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_2794(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(3,c,5)))){
C_save_and_reclaim((void *)f_2794,3,av);}
a=C_alloc(3);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2798,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posix-common.scm:265: ##sys#stat */
f_2722(t3,t2,C_SCHEME_FALSE,C_SCHEME_TRUE,lf[18]);}

/* g422 in k3624 in loop in k3605 in k3598 in a3595 in conc-loop in glob in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_fcall f_3630(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(9,0,2)))){
C_save_and_reclaim_args((void *)trf_3630,3,t0,t1,t2);}
a=C_alloc(9);
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3638,a[2]=t1,a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],tmp=(C_word)a,a+=5,tmp);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3650,a[2]=t3,a[3]=((C_word*)t0)[4],tmp=(C_word)a,a+=4,tmp);
/* posix-common.scm:510: irregex-match-substring */
t5=*((C_word*)lf[88]+1);{
C_word av2[3];
av2[0]=t5;
av2[1]=t4;
av2[2]=t2;
((C_proc)(void*)(*((C_word*)t5+1)))(3,av2);}}

/* k6206 in read-symbolic-link in k6200 in k6169 in k5687 in k5683 in k5679 in k5675 in k5595 in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_6208(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,5)))){
C_save_and_reclaim((void *)f_6208,2,av);}
t2=C_do_readlink(t1,((C_word*)t0)[2]);
if(C_truep(C_fixnum_lessp(t2,C_fix(0)))){
/* posixunix.scm:1088: posix-error */
t3=lf[0];{
C_word *av2;
if(c >= 6) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(6);
}
av2[0]=t3;
av2[1]=((C_word*)t0)[3];
av2[2]=lf[8];
av2[3]=((C_word*)t0)[4];
av2[4]=lf[334];
av2[5]=((C_word*)t0)[5];
f_2704(6,av2);}}
else{
/* posixunix.scm:1089: substring */
t3=*((C_word*)lf[335]+1);{
C_word *av2;
if(c >= 5) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(5);
}
av2[0]=t3;
av2[1]=((C_word*)t0)[3];
av2[2]=((C_word*)t0)[2];
av2[3]=C_fix(0);
av2[4]=t2;
((C_proc)(void*)(*((C_word*)t3+1)))(5,av2);}}}

/* fifo? in k6200 in k6169 in k5687 in k5683 in k5679 in k5675 in k5595 in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_7390(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(4,c,3)))){
C_save_and_reclaim((void *)f_7390,3,av);}
a=C_alloc(4);
t3=C_i_check_string_2(t2,lf[35]);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_7398,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm:1377: ##sys#make-c-string */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[11]+1));
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[11]+1);
av2[1]=t4;
av2[2]=t2;
av2[3]=lf[35];
tp(4,av2);}}

/* k5989 in initialize-groups in k5687 in k5683 in k5679 in k5675 in k5595 in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_5991(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_5991,2,av);}
t2=C_i_foreign_fixnum_argumentp(((C_word*)t0)[2]);
t3=((C_word*)t0)[3];{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=t3;
av2[1]=stub1311(C_SCHEME_UNDEFINED,t1,t2);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* for-each-loop1164 in set-signal-mask! in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static C_word C_fcall f_5572(C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_stack_overflow_check;
loop:{}
if(C_truep(C_i_pairp(t1))){
t2=C_slot(t1,C_fix(0));
t3=C_i_check_exact_2(t2,lf[251]);
t4=C_sigaddset(t2);
t5=C_slot(t1,C_fix(1));
t7=t5;
t1=t7;
goto loop;}
else{
t2=C_SCHEME_UNDEFINED;
return(t2);}}

/* k3624 in loop in k3605 in k3598 in a3595 in conc-loop in glob in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_3626(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(6,c,3)))){
C_save_and_reclaim((void *)f_3626,2,av);}
a=C_alloc(6);
if(C_truep(t1)){
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_3630,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word)li35),tmp=(C_word)a,a+=6,tmp);
/* posix-common.scm:502: g422 */
t3=t2;
f_3630(t3,((C_word*)t0)[5],t1);}
else{
t2=((C_word*)t0)[2];
t3=C_u_i_cdr(t2);
/* posix-common.scm:512: loop */
t4=((C_word*)((C_word*)t0)[3])[1];
f_3609(t4,((C_word*)t0)[5],t3);}}

/* k3636 in g422 in k3624 in loop in k3605 in k3598 in a3595 in conc-loop in glob in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_3638(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,2)))){
C_save_and_reclaim((void *)f_3638,2,av);}
a=C_alloc(4);
t2=t1;
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3642,a[2]=((C_word*)t0)[2],a[3]=t2,tmp=(C_word)a,a+=4,tmp);
t4=C_i_cdr(((C_word*)t0)[3]);
/* posix-common.scm:511: loop */
t5=((C_word*)((C_word*)t0)[4])[1];
f_3609(t5,t3,t4);}

/* k4828 in file-select in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_fcall f_4830(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(9,0,2)))){
C_save_and_reclaim_args((void *)trf_4830,2,t0,t1);}
a=C_alloc(9);
t2=t1;
t3=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_4833,a[2]=t2,a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],tmp=(C_word)a,a+=6,tmp);
t4=((C_word*)t0)[3];
if(C_truep(t4)){
if(C_truep(C_fixnump(((C_word*)t0)[3]))){
t5=t3;
f_4833(t5,C_a_i_list1(&a,1,((C_word*)t0)[3]));}
else{
t5=C_i_check_list_2(((C_word*)t0)[3],lf[196]);
t6=((C_word*)t0)[3];
t7=t3;
f_4833(t7,t6);}}
else{
t5=t3;
f_4833(t5,C_SCHEME_END_OF_LIST);}}

/* k4831 in k4828 in file-select in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_fcall f_4833(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(10,0,2)))){
C_save_and_reclaim_args((void *)trf_4833,2,t0,t1);}
a=C_alloc(10);
t2=t1;
t3=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_4836,a[2]=t2,a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],a[6]=((C_word*)t0)[5],tmp=(C_word)a,a+=7,tmp);
t4=((C_word*)t0)[5];
if(C_truep(t4)){
if(C_truep(C_fixnump(((C_word*)t0)[5]))){
t5=t3;
f_4836(t5,C_a_i_list1(&a,1,((C_word*)t0)[5]));}
else{
t5=C_i_check_list_2(((C_word*)t0)[5],lf[196]);
t6=((C_word*)t0)[5];
t7=t3;
f_4836(t7,t6);}}
else{
t5=t3;
f_4836(t5,C_SCHEME_END_OF_LIST);}}

/* file-select in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_4826(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c<4) C_bad_min_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand((c-4)*C_SIZEOF_PAIR +5,c,2)))){
C_save_and_reclaim((void*)f_4826,c,av);}
a=C_alloc((c-4)*C_SIZEOF_PAIR+5);
t4=C_build_rest(&a,c,4,av);
C_word t5;
C_word t6;
C_word t7;
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4830,a[2]=t1,a[3]=t2,a[4]=t3,tmp=(C_word)a,a+=5,tmp);
if(C_truep(C_i_pairp(t4))){
t6=t4;
t7=t5;
f_4830(t7,C_u_i_car(t6));}
else{
t6=t5;
f_4830(t6,C_SCHEME_FALSE);}}

/* k7692 in k7683 in k7680 in k7677 in set-buffering-mode! in k6200 in k6169 in k5687 in k5683 in k5679 in k5675 in k5595 in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 in ... */
static void C_fcall f_7694(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,0,6)))){
C_save_and_reclaim_args((void *)trf_7694,2,t0,t1);}
if(C_truep(t1)){
/* posixunix.scm:1497: ##sys#error */
t2=*((C_word*)lf[50]+1);{
C_word av2[7];
av2[0]=t2;
av2[1]=((C_word*)t0)[2];
av2[2]=lf[405];
av2[3]=lf[406];
av2[4]=((C_word*)t0)[3];
av2[5]=((C_word*)t0)[4];
av2[6]=((C_word*)t0)[5];
((C_proc)(void*)(*((C_word*)t2+1)))(7,av2);}}
else{
t2=C_SCHEME_UNDEFINED;
t3=((C_word*)t0)[2];{
C_word av2[2];
av2[0]=t3;
av2[1]=t2;
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}}

/* k3796 in k3749 in k3805 in k3715 in k3706 in loop in k3691 in k3684 in k3681 in k3872 in k3869 in k3866 in k3863 in k3860 in k3857 in find-files in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in ... */
static void C_ccall f_3798(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,4)))){
C_save_and_reclaim((void *)f_3798,2,av);}
/* posix-common.scm:548: loop */
t2=((C_word*)((C_word*)t0)[2])[1];
f_3695(t2,((C_word*)t0)[3],((C_word*)t0)[4],((C_word*)t0)[5],t1);}

/* k3781 in k3774 in a3767 in k3749 in k3805 in k3715 in k3706 in loop in k3691 in k3684 in k3681 in k3872 in k3869 in k3866 in k3863 in k3860 in k3857 in find-files in k3031 in k2790 in k2690 in k2687 in ... */
static void C_ccall f_3783(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,4)))){
C_save_and_reclaim((void *)f_3783,2,av);}
if(C_truep(t1)){
/* posix-common.scm:547: action */
t2=((C_word*)t0)[2];{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[3];
av2[2]=((C_word*)t0)[4];
av2[3]=((C_word*)t0)[5];
((C_proc)C_fast_retrieve_proc(t2))(4,av2);}}
else{
t2=((C_word*)t0)[5];
/* posix-common.scm:545: loop */
t3=((C_word*)((C_word*)t0)[6])[1];
f_3695(t3,((C_word*)t0)[7],((C_word*)t0)[4],((C_word*)t0)[8],t2);}}

/* k3778 in k3774 in a3767 in k3749 in k3805 in k3715 in k3706 in loop in k3691 in k3684 in k3681 in k3872 in k3869 in k3866 in k3863 in k3860 in k3857 in find-files in k3031 in k2790 in k2690 in k2687 in ... */
static void C_ccall f_3780(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,4)))){
C_save_and_reclaim((void *)f_3780,2,av);}
/* posix-common.scm:545: loop */
t2=((C_word*)((C_word*)t0)[2])[1];
f_3695(t2,((C_word*)t0)[3],((C_word*)t0)[4],((C_word*)t0)[5],t1);}

/* a3787 in k3749 in k3805 in k3715 in k3706 in loop in k3691 in k3684 in k3681 in k3872 in k3869 in k3866 in k3863 in k3860 in k3857 in find-files in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in ... */
static void C_ccall f_3788(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_3788,2,av);}
t2=C_mutate2(((C_word *)((C_word*)t0)[2])+1,((C_word*)((C_word*)t0)[3])[1]);
t3=C_mutate2(((C_word *)((C_word*)t0)[3])+1,((C_word*)((C_word*)t0)[4])[1]);
t4=t1;{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=t4;
av2[1]=C_SCHEME_UNDEFINED;
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* file-read in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_4716(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c<4) C_bad_min_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand((c-4)*C_SIZEOF_PAIR +5,c,3)))){
C_save_and_reclaim((void*)f_4716,c,av);}
a=C_alloc((c-4)*C_SIZEOF_PAIR+5);
t4=C_build_rest(&a,c,4,av);
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
t5=C_i_check_exact_2(t2,lf[188]);
t6=C_i_check_exact_2(t3,lf[188]);
t7=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4726,a[2]=t2,a[3]=t3,a[4]=t1,tmp=(C_word)a,a+=5,tmp);
if(C_truep(C_i_pairp(t4))){
t8=t4;
t9=t7;{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=t9;
av2[1]=C_u_i_car(t8);
f_4726(2,av2);}}
else{
t8=t3;
/* ##sys#make-string */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[72]+1));
C_word *av2=av; /* Re-use our own argvector */
av2[0]=*((C_word*)lf[72]+1);
av2[1]=t7;
av2[2]=t8;
av2[3]=C_make_character(32);
tp(4,av2);}}}

/* k3774 in a3767 in k3749 in k3805 in k3715 in k3706 in loop in k3691 in k3684 in k3681 in k3872 in k3869 in k3866 in k3863 in k3860 in k3857 in find-files in k3031 in k2790 in k2690 in k2687 in k2684 in ... */
static void C_ccall f_3776(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(15,c,2)))){
C_save_and_reclaim((void *)f_3776,2,av);}
a=C_alloc(15);
t2=t1;
t3=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_3780,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=t2,tmp=(C_word)a,a+=6,tmp);
t4=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_3783,a[2]=((C_word*)t0)[5],a[3]=t3,a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[6],a[6]=((C_word*)t0)[2],a[7]=((C_word*)t0)[3],a[8]=t2,tmp=(C_word)a,a+=9,tmp);
/* posix-common.scm:547: pproc */
t5=((C_word*)t0)[7];{
C_word *av2;
if(c >= 3) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(3);
}
av2[0]=t5;
av2[1]=t4;
av2[2]=((C_word*)t0)[4];
((C_proc)(void*)(*((C_word*)t5+1)))(3,av2);}}

/* initialize-groups in k5687 in k5683 in k5679 in k5675 in k5595 in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_6003(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(9,c,2)))){
C_save_and_reclaim((void *)f_6003,4,av);}
a=C_alloc(9);
t4=C_i_check_string_2(t2,lf[279]);
t5=C_i_check_exact_2(t3,lf[279]);
t6=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_6026,a[2]=t1,a[3]=t2,a[4]=t3,tmp=(C_word)a,a+=5,tmp);
t7=t6;
t8=t2;
t9=t3;
t10=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5991,a[2]=t9,a[3]=t7,tmp=(C_word)a,a+=4,tmp);
if(C_truep(t8)){
t11=C_i_foreign_string_argumentp(t8);
/* posixunix.scm:958: ##sys#make-c-string */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[11]+1));
C_word *av2=av; /* Re-use our own argvector */
av2[0]=*((C_word*)lf[11]+1);
av2[1]=t10;
av2[2]=t11;
tp(3,av2);}}
else{
t11=C_i_foreign_fixnum_argumentp(t9);
t12=t7;{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=t12;
av2[1]=stub1311(C_SCHEME_UNDEFINED,C_SCHEME_FALSE,t11);
((C_proc)(void*)(*((C_word*)t12+1)))(2,av2);}}}

/* a3762 in k3749 in k3805 in k3715 in k3706 in loop in k3691 in k3684 in k3681 in k3872 in k3869 in k3866 in k3863 in k3860 in k3857 in find-files in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in ... */
static void C_ccall f_3763(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_3763,2,av);}
t2=C_mutate2(((C_word *)((C_word*)t0)[2])+1,((C_word*)((C_word*)t0)[3])[1]);
t3=C_mutate2(((C_word *)((C_word*)t0)[3])+1,((C_word*)((C_word*)t0)[4])[1]);
t4=t1;{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=t4;
av2[1]=C_SCHEME_UNDEFINED;
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* a8764 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_8765(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(8,c,2)))){
C_save_and_reclaim((void *)f_8765,3,av);}
a=C_alloc(8);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_8769,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_8781,a[2]=t2,a[3]=t3,tmp=(C_word)a,a+=4,tmp);
/* posix-common.scm:332: port? */
t5=*((C_word*)lf[15]+1);{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=t5;
av2[1]=t4;
av2[2]=t2;
((C_proc)(void*)(*((C_word*)t5+1)))(3,av2);}}

/* k3759 in k3749 in k3805 in k3715 in k3706 in loop in k3691 in k3684 in k3681 in k3872 in k3869 in k3866 in k3863 in k3860 in k3857 in find-files in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in ... */
static void C_ccall f_3761(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,4)))){
C_save_and_reclaim((void *)f_3761,2,av);}
/* posix-common.scm:542: loop */
t2=((C_word*)((C_word*)t0)[2])[1];
f_3695(t2,((C_word*)t0)[3],((C_word*)t0)[4],((C_word*)t0)[5],t1);}

/* k8767 in a8764 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_8769(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,5)))){
C_save_and_reclaim((void *)f_8769,2,av);}
a=C_alloc(4);
t2=t1;
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_8772,a[2]=((C_word*)t0)[2],a[3]=t2,tmp=(C_word)a,a+=4,tmp);
if(C_truep(C_i_lessp(t2,C_fix(0)))){
/* posix-common.scm:341: posix-error */
t4=lf[0];{
C_word *av2;
if(c >= 6) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(6);
}
av2[0]=t4;
av2[1]=t3;
av2[2]=lf[8];
av2[3]=lf[45];
av2[4]=lf[464];
av2[5]=((C_word*)t0)[3];
f_2704(6,av2);}}
else{
t4=((C_word*)t0)[2];{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=t4;
av2[1]=t2;
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}}

/* a3767 in k3749 in k3805 in k3715 in k3706 in loop in k3691 in k3684 in k3681 in k3872 in k3869 in k3866 in k3863 in k3860 in k3857 in find-files in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in ... */
static void C_ccall f_3768(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(C_unlikely(!C_demand(C_calculate_demand(8,c,3)))){
C_save_and_reclaim((void *)f_3768,2,av);}
a=C_alloc(8);
t2=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_3776,a[2]=((C_word*)t0)[2],a[3]=t1,a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],a[6]=((C_word*)t0)[5],a[7]=((C_word*)t0)[6],tmp=(C_word)a,a+=8,tmp);
/* posix-common.scm:546: directory */
t3=*((C_word*)lf[26]+1);{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=t3;
av2[1]=t2;
av2[2]=((C_word*)t0)[3];
av2[3]=((C_word*)t0)[7];
((C_proc)(void*)(*((C_word*)t3+1)))(4,av2);}}

/* k6017 in k6024 in initialize-groups in k5687 in k5683 in k5679 in k5675 in k5595 in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_6019(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,5)))){
C_save_and_reclaim((void *)f_6019,2,av);}
/* posixunix.scm:964: ##sys#error */
t2=*((C_word*)lf[50]+1);{
C_word *av2;
if(c >= 6) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(6);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[2];
av2[2]=lf[279];
av2[3]=lf[280];
av2[4]=((C_word*)t0)[3];
av2[5]=((C_word*)t0)[4];
((C_proc)(void*)(*((C_word*)t2+1)))(6,av2);}}

/* k3749 in k3805 in k3715 in k3706 in loop in k3691 in k3684 in k3681 in k3872 in k3869 in k3866 in k3863 in k3860 in k3857 in find-files in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in ... */
static void C_ccall f_3751(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(31,c,4)))){
C_save_and_reclaim((void *)f_3751,2,av);}
a=C_alloc(31);
if(C_truep(t1)){
t2=C_fixnum_plus(((C_word*)((C_word*)t0)[2])[1],C_fix(1));
t3=t2;
t4=(*a=C_VECTOR_TYPE|1,a[1]=t3,tmp=(C_word)a,a+=2,tmp);
t5=C_SCHEME_FALSE;
t6=(*a=C_VECTOR_TYPE|1,a[1]=t5,tmp=(C_word)a,a+=2,tmp);
t7=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_3761,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[6],tmp=(C_word)a,a+=6,tmp);
t8=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_3763,a[2]=t6,a[3]=((C_word*)t0)[2],a[4]=t4,a[5]=((C_word)li40),tmp=(C_word)a,a+=6,tmp);
t9=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_3768,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[7],a[4]=((C_word*)t0)[8],a[5]=((C_word*)t0)[9],a[6]=((C_word*)t0)[10],a[7]=((C_word*)t0)[11],a[8]=((C_word)li41),tmp=(C_word)a,a+=9,tmp);
t10=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_3788,a[2]=t4,a[3]=((C_word*)t0)[2],a[4]=t6,a[5]=((C_word)li42),tmp=(C_word)a,a+=6,tmp);
/* posix-common.scm:544: ##sys#dynamic-wind */
t11=*((C_word*)lf[95]+1);{
C_word *av2;
if(c >= 5) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(5);
}
av2[0]=t11;
av2[1]=t7;
av2[2]=t8;
av2[3]=t9;
av2[4]=t10;
((C_proc)(void*)(*((C_word*)t11+1)))(5,av2);}}
else{
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_3798,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[6],tmp=(C_word)a,a+=6,tmp);
t3=(*a=C_CLOSURE_TYPE|9,a[1]=(C_word)f_3801,a[2]=((C_word*)t0)[8],a[3]=t2,a[4]=((C_word*)t0)[7],a[5]=((C_word*)t0)[9],a[6]=((C_word*)t0)[3],a[7]=((C_word*)t0)[4],a[8]=((C_word*)t0)[5],a[9]=((C_word*)t0)[6],tmp=(C_word)a,a+=10,tmp);
/* posix-common.scm:548: pproc */
t4=((C_word*)t0)[10];{
C_word *av2;
if(c >= 3) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(3);
}
av2[0]=t4;
av2[1]=t3;
av2[2]=((C_word*)t0)[7];
((C_proc)(void*)(*((C_word*)t4+1)))(3,av2);}}}

/* k6261 in loop in k6249 in a6242 in read-symbolic-link in k6200 in k6169 in k5687 in k5683 in k5679 in k5675 in k5595 in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 in ... */
static void C_ccall f_6263(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(7,c,2)))){
C_save_and_reclaim((void *)f_6263,2,av);}
a=C_alloc(7);
t2=t1;
t3=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_6269,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=t2,tmp=(C_word)a,a+=7,tmp);
/* posixunix.scm:1100: file-exists? */
t4=*((C_word*)lf[84]+1);{
C_word *av2;
if(c >= 3) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(3);
}
av2[0]=t4;
av2[1]=t3;
av2[2]=t2;
((C_proc)(void*)(*((C_word*)t4+1)))(3,av2);}}

/* a8758 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_8759(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_8759,3,av);}
t3=C_i_check_exact_2(t2,lf[102]);
t4=t1;{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=t4;
av2[1]=C_umask(t2);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* k6267 in k6261 in loop in k6249 in a6242 in read-symbolic-link in k6200 in k6169 in k5687 in k5683 in k5679 in k5675 in k5595 in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in ... */
static void C_ccall f_6269(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(13,c,5)))){
C_save_and_reclaim((void *)f_6269,2,av);}
a=C_alloc(13);
if(C_truep(t1)){
t2=((C_word*)t0)[2];
t3=C_u_i_cdr(t2);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_6278,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=t3,tmp=(C_word)a,a+=5,tmp);
t5=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_6281,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=t3,a[5]=t4,a[6]=((C_word*)t0)[5],a[7]=((C_word*)t0)[6],tmp=(C_word)a,a+=8,tmp);
/* posixunix.scm:1102: symbolic-link? */
t6=*((C_word*)lf[32]+1);{
C_word *av2;
if(c >= 3) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(3);
}
av2[0]=t6;
av2[1]=t5;
av2[2]=((C_word*)t0)[6];
((C_proc)(void*)(*((C_word*)t6+1)))(3,av2);}}
else{
/* posixunix.scm:1108: ##sys#signal-hook */
t2=*((C_word*)lf[1]+1);{
C_word *av2;
if(c >= 6) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(6);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[4];
av2[2]=lf[8];
av2[3]=lf[336];
av2[4]=lf[339];
av2[5]=((C_word*)t0)[6];
((C_proc)(void*)(*((C_word*)t2+1)))(6,av2);}}}

/* signal-mask! in k5595 in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_5605(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,4)))){
C_save_and_reclaim((void *)f_5605,3,av);}
t3=C_i_check_exact_2(t2,lf[255]);
t4=C_sigemptyset(C_fix(0));
t5=C_sigaddset(t2);
t6=C_sigprocmask_block(C_fix(0));
if(C_truep(C_fixnum_lessp(t6,C_fix(0)))){
/* posixunix.scm:795: posix-error */
t7=lf[0];{
C_word *av2;
if(c >= 5) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(5);
}
av2[0]=t7;
av2[1]=t1;
av2[2]=lf[127];
av2[3]=lf[255];
av2[4]=lf[256];
f_2704(5,av2);}}
else{
t7=C_SCHEME_UNDEFINED;
t8=t1;{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=t8;
av2[1]=t7;
((C_proc)(void*)(*((C_word*)t8+1)))(2,av2);}}}

/* k3740 in k3805 in k3715 in k3706 in loop in k3691 in k3684 in k3681 in k3872 in k3869 in k3866 in k3863 in k3860 in k3857 in find-files in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in ... */
static void C_ccall f_3742(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,4)))){
C_save_and_reclaim((void *)f_3742,2,av);}
if(C_truep(t1)){
/* posix-common.scm:540: action */
t2=((C_word*)t0)[2];{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[3];
av2[2]=((C_word*)t0)[4];
av2[3]=((C_word*)t0)[5];
((C_proc)C_fast_retrieve_proc(t2))(4,av2);}}
else{
t2=((C_word*)t0)[5];
/* posix-common.scm:540: loop */
t3=((C_word*)((C_word*)t0)[6])[1];
f_3695(t3,((C_word*)t0)[7],((C_word*)t0)[8],((C_word*)t0)[9],t2);}}

/* k6276 in k6267 in k6261 in loop in k6249 in a6242 in read-symbolic-link in k6200 in k6169 in k5687 in k5683 in k5679 in k5675 in k5595 in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in ... */
static void C_ccall f_6278(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,3)))){
C_save_and_reclaim((void *)f_6278,2,av);}
/* posixunix.scm:1101: loop */
t2=((C_word*)((C_word*)t0)[2])[1];
f_6253(t2,((C_word*)t0)[3],((C_word*)t0)[4],t1);}

/* k8779 in a8764 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_8781(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,5)))){
C_save_and_reclaim((void *)f_8781,2,av);}
if(C_truep(t1)){
t2=C_slot(((C_word*)t0)[2],C_fix(7));
t3=C_eqp(t2,lf[43]);
if(C_truep(t3)){
t4=C_ftell(((C_word*)t0)[2]);
t5=((C_word*)t0)[3];{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=t5;
av2[1]=t4;
f_8769(2,av2);}}
else{
t4=((C_word*)t0)[3];{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=t4;
av2[1]=C_fix(-1);
f_8769(2,av2);}}}
else{
if(C_truep(C_fixnump(((C_word*)t0)[2]))){
t2=C_lseek(((C_word*)t0)[2],C_fix(0),C_fix((C_word)SEEK_CUR));
t3=((C_word*)t0)[3];{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=t3;
av2[1]=t2;
f_8769(2,av2);}}
else{
/* posix-common.scm:339: ##sys#signal-hook */
t2=*((C_word*)lf[1]+1);{
C_word *av2;
if(c >= 6) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(6);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[3];
av2[2]=lf[13];
av2[3]=lf[45];
av2[4]=lf[465];
av2[5]=((C_word*)t0)[2];
((C_proc)(void*)(*((C_word*)t2+1)))(6,av2);}}}}

/* k5921 in get-groups in k5687 in k5683 in k5679 in k5675 in k5595 in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_5923(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,3)))){
C_save_and_reclaim((void *)f_5923,2,av);}
/* posixunix.scm:933: ##sys#error */
t2=*((C_word*)lf[50]+1);{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[2];
av2[2]=lf[272];
av2[3]=lf[275];
((C_proc)(void*)(*((C_word*)t2+1)))(4,av2);}}

/* set-groups! in k5687 in k5683 in k5679 in k5675 in k5595 in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_5928(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(4,c,3)))){
C_save_and_reclaim((void *)f_5928,3,av);}
a=C_alloc(4);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5932,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
t4=C_i_length(t2);
t5=C_i_foreign_fixnum_argumentp(t4);
if(C_truep(stub1281(C_SCHEME_UNDEFINED,t5))){
t6=t3;{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=t6;
av2[1]=C_SCHEME_UNDEFINED;
f_5932(2,av2);}}
else{
/* posixunix.scm:946: ##sys#error */
t6=*((C_word*)lf[50]+1);{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=t6;
av2[1]=t3;
av2[2]=lf[276];
av2[3]=lf[278];
((C_proc)(void*)(*((C_word*)t6+1)))(4,av2);}}}

/* k3737 in k3805 in k3715 in k3706 in loop in k3691 in k3684 in k3681 in k3872 in k3869 in k3866 in k3863 in k3860 in k3857 in find-files in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in ... */
static void C_ccall f_3739(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,4)))){
C_save_and_reclaim((void *)f_3739,2,av);}
/* posix-common.scm:540: loop */
t2=((C_word*)((C_word*)t0)[2])[1];
f_3695(t2,((C_word*)t0)[3],((C_word*)t0)[4],((C_word*)t0)[5],t1);}

/* k6279 in k6267 in k6261 in loop in k6249 in a6242 in read-symbolic-link in k6200 in k6169 in k5687 in k5683 in k5679 in k5675 in k5595 in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in ... */
static void C_ccall f_6281(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(7,c,3)))){
C_save_and_reclaim((void *)f_6281,2,av);}
a=C_alloc(7);
if(C_truep(t1)){
t2=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_6284,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[6],tmp=(C_word)a,a+=7,tmp);
/* posixunix.scm:1103: ##sys#read-symbolic-link */
t3=*((C_word*)lf[333]+1);{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=t3;
av2[1]=t2;
av2[2]=((C_word*)t0)[7];
av2[3]=lf[336];
((C_proc)(void*)(*((C_word*)t3+1)))(4,av2);}}
else{
/* posixunix.scm:1101: loop */
t2=((C_word*)((C_word*)t0)[2])[1];
f_6253(t2,((C_word*)t0)[3],((C_word*)t0)[4],((C_word*)t0)[7]);}}

/* k6282 in k6279 in k6267 in k6261 in loop in k6249 in a6242 in read-symbolic-link in k6200 in k6169 in k5687 in k5683 in k5679 in k5675 in k5595 in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in ... */
static void C_ccall f_6284(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(8,c,2)))){
C_save_and_reclaim((void *)f_6284,2,av);}
a=C_alloc(8);
t2=t1;
t3=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_6290,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=t2,a[6]=((C_word*)t0)[5],a[7]=((C_word*)t0)[6],tmp=(C_word)a,a+=8,tmp);
/* posixunix.scm:1104: absolute-pathname? */
t4=*((C_word*)lf[338]+1);{
C_word *av2;
if(c >= 3) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(3);
}
av2[0]=t4;
av2[1]=t3;
av2[2]=t2;
((C_proc)(void*)(*((C_word*)t4+1)))(3,av2);}}

/* k8445 in k8441 in %process in k6200 in k6169 in k5687 in k5683 in k5679 in k5675 in k5595 in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_8447(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_8447,2,av);}
t2=C_mutate2(((C_word *)((C_word*)t0)[2])+1,t1);
t3=((C_word*)t0)[3];{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=t3;
av2[1]=t2;
f_8421(2,av2);}}

/* process in k6200 in k6169 in k5687 in k5683 in k5679 in k5675 in k5595 in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_8449(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand((c-3)*C_SIZEOF_PAIR +3,c,7)))){
C_save_and_reclaim((void*)f_8449,c,av);}
a=C_alloc((c-3)*C_SIZEOF_PAIR+3);
t3=C_build_rest(&a,c,3,av);
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
t4=C_i_nullp(t3);
t5=(C_truep(t4)?C_SCHEME_FALSE:C_i_car(t3));
t6=C_i_nullp(t3);
t7=(C_truep(t6)?C_SCHEME_END_OF_LIST:C_i_cdr(t3));
t8=C_i_nullp(t7);
t9=(C_truep(t8)?C_SCHEME_FALSE:C_i_car(t7));
t10=C_i_nullp(t7);
t11=(C_truep(t10)?C_SCHEME_END_OF_LIST:C_i_cdr(t7));
t12=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_8467,a[2]=((C_word)li244),tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm:1734: %process */
f_8378(t1,lf[442],C_SCHEME_FALSE,t2,t5,t9,t12);}

/* k8770 in k8767 in a8764 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_8772(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_8772,2,av);}
t2=((C_word*)t0)[2];{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=t2;
av2[1]=((C_word*)t0)[3];
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* k6288 in k6282 in k6279 in k6267 in k6261 in loop in k6249 in a6242 in read-symbolic-link in k6200 in k6169 in k5687 in k5683 in k5679 in k5675 in k5595 in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in ... */
static void C_ccall f_6290(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,3)))){
C_save_and_reclaim((void *)f_6290,2,av);}
if(C_truep(t1)){
/* posixunix.scm:1101: loop */
t2=((C_word*)((C_word*)t0)[2])[1];
f_6253(t2,((C_word*)t0)[3],((C_word*)t0)[4],((C_word*)t0)[5]);}
else{
/* posixunix.scm:1106: make-pathname */
t2=*((C_word*)lf[83]+1);{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[6];
av2[2]=((C_word*)t0)[7];
av2[3]=((C_word*)t0)[5];
((C_proc)(void*)(*((C_word*)t2+1)))(4,av2);}}}

/* read-symbolic-link in k6200 in k6169 in k5687 in k5683 in k5679 in k5675 in k5595 in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_6222(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand((c-3)*C_SIZEOF_PAIR +7,c,5)))){
C_save_and_reclaim((void*)f_6222,c,av);}
a=C_alloc((c-3)*C_SIZEOF_PAIR+7);
t3=C_build_rest(&a,c,3,av);
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
t4=C_i_nullp(t3);
t5=(C_truep(t4)?C_SCHEME_FALSE:C_i_car(t3));
t6=C_i_check_string_2(t2,lf[336]);
if(C_truep(t5)){
t7=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_6237,a[2]=t2,a[3]=((C_word)li155),tmp=(C_word)a,a+=4,tmp);
t8=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6243,a[2]=((C_word)li157),tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm:1094: ##sys#call-with-values */{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=0;
av2[1]=t1;
av2[2]=t7;
av2[3]=t8;
C_call_with_values(4,av2);}}
else{
/* posixunix.scm:1109: ##sys#read-symbolic-link */
t7=*((C_word*)lf[333]+1);{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=t7;
av2[1]=t1;
av2[2]=t2;
av2[3]=lf[336];
((C_proc)(void*)(*((C_word*)t7+1)))(4,av2);}}}

/* a8466 in process in k6200 in k6169 in k5687 in k5683 in k5679 in k5675 in k5595 in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_8467(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4=av[4];
C_word t5=av[5];
C_word t6;
C_word *a;
if(c!=6) C_bad_argc_2(c,6,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,4)))){
C_save_and_reclaim((void *)f_8467,6,av);}
/* posixunix.scm:1736: values */{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=0;
av2[1]=t1;
av2[2]=t2;
av2[3]=t3;
av2[4]=t4;
C_values(5,av2);}}

/* ##sys#stat in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_fcall f_2722(C_word t1,C_word t2,C_word t3,C_word t4,C_word t5){
C_word tmp;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(12,0,2)))){
C_save_and_reclaim_args((void *)trf_2722,5,t1,t2,t3,t4,t5);}
a=C_alloc(12);
t6=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_2726,a[2]=t4,a[3]=t1,a[4]=t5,a[5]=t2,tmp=(C_word)a,a+=6,tmp);
if(C_truep(C_fixnump(t2))){
t7=t6;{
C_word av2[2];
av2[0]=t7;
av2[1]=C_fstat(t2);
f_2726(2,av2);}}
else{
t7=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_2747,a[2]=t6,a[3]=t2,a[4]=t3,a[5]=t5,tmp=(C_word)a,a+=6,tmp);
/* posix-common.scm:225: port? */
t8=*((C_word*)lf[15]+1);{
C_word av2[3];
av2[0]=t8;
av2[1]=t7;
av2[2]=t2;
((C_proc)(void*)(*((C_word*)t8+1)))(3,av2);}}}

/* a3388 in k3327 in create-directory in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_3389(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4=av[4];
C_word t5;
C_word t6;
C_word *a;
if(c!=5) C_bad_argc_2(c,5,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,4)))){
C_save_and_reclaim((void *)f_3389,5,av);}
if(C_truep(t3)){
/* posix-common.scm:460: make-pathname */
t5=*((C_word*)lf[83]+1);{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=t5;
av2[1]=t1;
av2[2]=t2;
av2[3]=t3;
av2[4]=t4;
((C_proc)(void*)(*((C_word*)t5+1)))(5,av2);}}
else{
t5=t2;
t6=t1;{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=t6;
av2[1]=t5;
((C_proc)(void*)(*((C_word*)t6+1)))(2,av2);}}}

/* k2724 in stat in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_2726(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,5)))){
C_save_and_reclaim((void *)f_2726,2,av);}
if(C_truep(C_fixnum_lessp(t1,C_fix(0)))){
if(C_truep(((C_word*)t0)[2])){
/* posix-common.scm:239: posix-error */
t2=lf[0];{
C_word *av2;
if(c >= 6) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(6);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[3];
av2[2]=lf[8];
av2[3]=((C_word*)t0)[4];
av2[4]=lf[9];
av2[5]=((C_word*)t0)[5];
f_2704(6,av2);}}
else{
t2=((C_word*)t0)[3];{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=t2;
av2[1]=C_SCHEME_FALSE;
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}}
else{
t2=((C_word*)t0)[3];{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=t2;
av2[1]=C_SCHEME_TRUE;
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}}

/* a6236 in read-symbolic-link in k6200 in k6169 in k5687 in k5683 in k5679 in k5675 in k5595 in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_6237(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,2)))){
C_save_and_reclaim((void *)f_6237,2,av);}
/* posixunix.scm:1094: decompose-directory */
t2=*((C_word*)lf[337]+1);{
C_word *av2;
if(c >= 3) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(3);
}
av2[0]=t2;
av2[1]=t1;
av2[2]=((C_word*)t0)[2];
((C_proc)(void*)(*((C_word*)t2+1)))(3,av2);}}

/* k3379 in loop in k3337 in k3327 in create-directory in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_3381(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_3381,2,av);}
t2=((C_word*)t0)[2];
f_3348(t2,C_i_not(t1));}

/* a3382 in k3327 in create-directory in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_3383(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,2)))){
C_save_and_reclaim((void *)f_3383,2,av);}
/* posix-common.scm:459: decompose-pathname */
t2=*((C_word*)lf[82]+1);{
C_word *av2;
if(c >= 3) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(3);
}
av2[0]=t2;
av2[1]=t1;
av2[2]=((C_word*)t0)[2];
((C_proc)(void*)(*((C_word*)t2+1)))(3,av2);}}

/* process* in k6200 in k6169 in k5687 in k5683 in k5679 in k5675 in k5595 in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_8497(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand((c-3)*C_SIZEOF_PAIR +0,c,7)))){
C_save_and_reclaim((void*)f_8497,c,av);}
a=C_alloc((c-3)*C_SIZEOF_PAIR+0);
t3=C_build_rest(&a,c,3,av);
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
t4=C_i_nullp(t3);
t5=(C_truep(t4)?C_SCHEME_FALSE:C_i_car(t3));
t6=C_i_nullp(t3);
t7=(C_truep(t6)?C_SCHEME_END_OF_LIST:C_i_cdr(t3));
t8=C_i_nullp(t7);
t9=(C_truep(t8)?C_SCHEME_FALSE:C_i_car(t7));
if(C_truep(C_i_nullp(t7))){
/* posixunix.scm:1739: %process */
f_8378(t1,lf[443],C_SCHEME_TRUE,t2,t5,t9,*((C_word*)lf[444]+1));}
else{
t10=C_i_cdr(t7);
/* posixunix.scm:1739: %process */
f_8378(t1,lf[443],C_SCHEME_TRUE,t2,t5,t9,*((C_word*)lf[444]+1));}}

/* k7604 in k7600 in string->time in k6200 in k6169 in k5687 in k5683 in k5679 in k5675 in k5595 in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_7606(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(17,c,3)))){
C_save_and_reclaim((void *)f_7606,2,av);}
a=C_alloc(17);
t2=t1;
t3=C_a_i_vector(&a,10,C_SCHEME_FALSE,C_SCHEME_FALSE,C_SCHEME_FALSE,C_SCHEME_FALSE,C_SCHEME_FALSE,C_SCHEME_FALSE,C_SCHEME_FALSE,C_SCHEME_FALSE,C_SCHEME_FALSE,C_SCHEME_FALSE);
t4=t3;
t5=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_7614,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t2,a[5]=t4,tmp=(C_word)a,a+=6,tmp);
/* posixunix.scm:1446: ##sys#make-string */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[72]+1));
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[72]+1);
av2[1]=t5;
av2[2]=((C_word*)t0)[4];
av2[3]=C_make_character(0);
tp(4,av2);}}

/* file-mkstemp in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_4794(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(4,c,3)))){
C_save_and_reclaim((void *)f_4794,3,av);}
a=C_alloc(4);
t3=C_i_check_string_2(t2,lf[194]);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4801,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm:520: ##sys#make-c-string */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[11]+1));
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[11]+1);
av2[1]=t4;
av2[2]=t2;
av2[3]=lf[194];
tp(4,av2);}}

/* a6242 in read-symbolic-link in k6200 in k6169 in k5687 in k5683 in k5679 in k5675 in k5595 in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_6243(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4=av[4];
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(c!=5) C_bad_argc_2(c,5,t0);
if(C_unlikely(!C_demand(C_calculate_demand(4,c,3)))){
C_save_and_reclaim((void *)f_6243,5,av);}
a=C_alloc(4);
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_6251,a[2]=t1,a[3]=t4,tmp=(C_word)a,a+=4,tmp);
t6=(C_truep(t2)?t2:lf[340]);
if(C_truep(t3)){
/* posixunix.scm:1096: string-append */
t7=*((C_word*)lf[2]+1);{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=t7;
av2[1]=t5;
av2[2]=t6;
av2[3]=t3;
((C_proc)(void*)(*((C_word*)t7+1)))(4,av2);}}
else{
/* posixunix.scm:1096: string-append */
t7=*((C_word*)lf[2]+1);{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=t7;
av2[1]=t5;
av2[2]=t6;
av2[3]=lf[341];
((C_proc)(void*)(*((C_word*)t7+1)))(4,av2);}}}

/* set-signal-mask! in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_5548(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(3,c,4)))){
C_save_and_reclaim((void *)f_5548,3,av);}
a=C_alloc(3);
t3=C_i_check_list_2(t2,lf[251]);
t4=C_sigemptyset(C_fix(0));
t5=t2;
t6=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5572,a[2]=((C_word)li130),tmp=(C_word)a,a+=3,tmp);
t7=(
  f_5572(t5)
);
t8=C_sigprocmask_set(C_fix(0));
if(C_truep(C_fixnum_lessp(t8,C_fix(0)))){
/* posixunix.scm:771: posix-error */
t9=lf[0];{
C_word *av2;
if(c >= 5) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(5);
}
av2[0]=t9;
av2[1]=t1;
av2[2]=lf[127];
av2[3]=lf[251];
av2[4]=lf[252];
f_2704(5,av2);}}
else{
t9=C_SCHEME_UNDEFINED;
t10=t1;{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=t10;
av2[1]=t9;
((C_proc)(void*)(*((C_word*)t10+1)))(2,av2);}}}

/* k7600 in string->time in k6200 in k6169 in k5687 in k5683 in k5679 in k5675 in k5595 in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_7602(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(5,c,2)))){
C_save_and_reclaim((void *)f_7602,2,av);}
a=C_alloc(5);
t2=t1;
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_7606,a[2]=((C_word*)t0)[2],a[3]=t2,a[4]=((C_word*)t0)[3],tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm:1446: ##sys#make-c-string */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[11]+1));
C_word *av2;
if(c >= 3) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(3);
}
av2[0]=*((C_word*)lf[11]+1);
av2[1]=t3;
av2[2]=((C_word*)t0)[4];
tp(3,av2);}}

/* k3372 in k3346 in loop in k3337 in k3327 in create-directory in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_3374(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,2)))){
C_save_and_reclaim((void *)f_3374,2,av);}
/* posix-common.scm:462: loop */
t2=((C_word*)((C_word*)t0)[2])[1];
f_3341(t2,((C_word*)t0)[3],t1);}

/* k4765 in k4762 in file-write in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_fcall f_4767(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,0,6)))){
C_save_and_reclaim_args((void *)trf_4767,2,t0,t1);}
a=C_alloc(4);
t2=C_i_check_exact_2(t1,lf[191]);
t3=C_write(((C_word*)t0)[2],((C_word*)t0)[3],t1);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4773,a[2]=((C_word*)t0)[4],a[3]=t3,tmp=(C_word)a,a+=4,tmp);
t5=C_eqp(C_fix(-1),t3);
if(C_truep(t5)){
/* posixunix.scm:514: posix-error */
t6=lf[0];{
C_word av2[7];
av2[0]=t6;
av2[1]=t4;
av2[2]=lf[8];
av2[3]=lf[191];
av2[4]=lf[192];
av2[5]=((C_word*)t0)[2];
av2[6]=t1;
f_2704(7,av2);}}
else{
t6=((C_word*)t0)[4];{
C_word av2[2];
av2[0]=t6;
av2[1]=t3;
((C_proc)(void*)(*((C_word*)t6+1)))(2,av2);}}}

/* k4762 in file-write in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_4764(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(5,c,2)))){
C_save_and_reclaim((void *)f_4764,2,av);}
a=C_alloc(5);
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4767,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],tmp=(C_word)a,a+=5,tmp);
if(C_truep(C_i_pairp(((C_word*)t0)[5]))){
t3=((C_word*)t0)[5];
t4=t2;
f_4767(t4,C_u_i_car(t3));}
else{
t3=t2;
f_4767(t3,C_block_size(((C_word*)t0)[3]));}}

/* file-unlock in k6200 in k6169 in k5687 in k5683 in k5679 in k5675 in k5595 in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_7325(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,5)))){
C_save_and_reclaim((void *)f_7325,3,av);}
t3=C_i_check_structure_2(t2,lf[366],lf[373]);
t4=C_slot(t2,C_fix(2));
t5=C_slot(t2,C_fix(3));
t6=C_flock_setup(C_fix((C_word)F_UNLCK),t4,t5);
t7=C_slot(t2,C_fix(1));
t8=C_flock_lock(t7);
if(C_truep(C_fixnum_lessp(t8,C_fix(0)))){
/* posixunix.scm:1359: posix-error */
t9=lf[0];{
C_word *av2;
if(c >= 6) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(6);
}
av2[0]=t9;
av2[1]=t1;
av2[2]=lf[8];
av2[3]=lf[373];
av2[4]=lf[374];
av2[5]=t2;
f_2704(6,av2);}}
else{
t9=C_SCHEME_UNDEFINED;
t10=t1;{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=t10;
av2[1]=t9;
((C_proc)(void*)(*((C_word*)t10+1)))(2,av2);}}}

/* loop in a8690 in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_fcall f_8697(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word *a;
loop:
if(C_unlikely(!C_demand(C_calculate_demand(3,0,3)))){
C_save_and_reclaim_args((void *)trf_8697,4,t0,t1,t2,t3);}
a=C_alloc(3);
if(C_truep(C_i_nullp(t2))){
t4=t3;
t5=t1;{
C_word av2[2];
av2[0]=t5;
av2[1]=t4;
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}
else{
t4=C_i_car(t2);
t5=t2;
t6=C_u_i_cdr(t5);
if(C_truep(C_sigismember(t4))){
t7=C_a_i_cons(&a,2,t4,t3);
/* posixunix.scm:781: loop */
t9=t1;
t10=t6;
t11=t7;
t1=t9;
t2=t10;
t3=t11;
goto loop;}
else{
t7=t3;
/* posixunix.scm:781: loop */
t9=t1;
t10=t6;
t11=t7;
t1=t9;
t2=t10;
t3=t11;
goto loop;}}}

/* loop in k6249 in a6242 in read-symbolic-link in k6200 in k6169 in k5687 in k5683 in k5679 in k5675 in k5595 in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_fcall f_6253(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(6,0,3)))){
C_save_and_reclaim_args((void *)trf_6253,4,t0,t1,t2,t3);}
a=C_alloc(6);
if(C_truep(C_i_nullp(t2))){
t4=t3;
t5=t1;{
C_word av2[2];
av2[0]=t5;
av2[1]=t4;
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}
else{
t4=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_6263,a[2]=t2,a[3]=((C_word*)t0)[2],a[4]=t1,a[5]=t3,tmp=(C_word)a,a+=6,tmp);
t5=C_i_car(t2);
/* posixunix.scm:1099: make-pathname */
t6=*((C_word*)lf[83]+1);{
C_word av2[4];
av2[0]=t6;
av2[1]=t4;
av2[2]=t3;
av2[3]=t5;
((C_proc)(void*)(*((C_word*)t6+1)))(4,av2);}}}

/* k6249 in a6242 in read-symbolic-link in k6200 in k6169 in k5687 in k5683 in k5679 in k5675 in k5595 in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_6251(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(6,c,4)))){
C_save_and_reclaim((void *)f_6251,2,av);}
a=C_alloc(6);
t2=C_SCHEME_UNDEFINED;
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=C_set_block_item(t3,0,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_6253,a[2]=t3,a[3]=((C_word)li156),tmp=(C_word)a,a+=4,tmp));
t5=((C_word*)t3)[1];
f_6253(t5,((C_word*)t0)[2],((C_word*)t0)[3],t1);}

/* a8690 in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_8691(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(C_unlikely(!C_demand(C_calculate_demand(6,c,4)))){
C_save_and_reclaim((void *)f_8691,2,av);}
a=C_alloc(6);
t2=C_sigprocmask_get(C_fix(0));
t3=C_SCHEME_UNDEFINED;
t4=(*a=C_VECTOR_TYPE|1,a[1]=t3,tmp=(C_word)a,a+=2,tmp);
t5=C_set_block_item(t4,0,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_8697,a[2]=t4,a[3]=((C_word)li258),tmp=(C_word)a,a+=4,tmp));
t6=((C_word*)t4)[1];
f_8697(t6,t1,*((C_word*)lf[250]+1),C_SCHEME_END_OF_LIST);}

/* k4771 in k4765 in k4762 in file-write in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_4773(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_4773,2,av);}
t2=((C_word*)t0)[2];{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=t2;
av2[1]=((C_word*)t0)[3];
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* k8683 in a8674 in k5595 in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_8685(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,4)))){
C_save_and_reclaim((void *)f_8685,2,av);}
/* posixunix.scm:831: ##sys#error */
t2=*((C_word*)lf[50]+1);{
C_word *av2;
if(c >= 5) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(5);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[2];
av2[2]=lf[455];
av2[3]=lf[461];
av2[4]=((C_word*)t0)[3];
((C_proc)(void*)(*((C_word*)t2+1)))(5,av2);}}

/* k4540 in a4526 in a4520 in a4493 in k4484 in k4478 in call-with-exec-args in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_4542(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_4542,2,av);}
t2=C_mutate2(((C_word *)((C_word*)t0)[2])+1,t1);
t3=((C_word*)t0)[3];
f_4531(t3,t2);}

/* a4543 in a4520 in a4493 in k4484 in k4478 in call-with-exec-args in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_4544(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand((c-2)*C_SIZEOF_PAIR +4,c,2)))){
C_save_and_reclaim((void*)f_4544,c,av);}
a=C_alloc((c-2)*C_SIZEOF_PAIR+4);
t2=C_build_rest(&a,c,2,av);
C_word t3;
C_word t4;
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4550,a[2]=t2,a[3]=((C_word)li87),tmp=(C_word)a,a+=4,tmp);
/* posix-common.scm:726: k722 */
t4=((C_word*)t0)[2];{
C_word *av2;
if(c >= 3) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(3);
}
av2[0]=t4;
av2[1]=t1;
av2[2]=t3;
((C_proc)C_fast_retrieve_proc(t4))(3,av2);}}

/* k5683 in k5679 in k5675 in k5595 in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_5685(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(9,c,4)))){
C_save_and_reclaim((void *)f_5685,2,av);}
a=C_alloc(9);
t2=C_mutate2((C_word*)lf[264]+1 /* (set! current-group-id ...) */,t1);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5689,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_8615,a[2]=((C_word)li250),tmp=(C_word)a,a+=3,tmp);
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_8618,a[2]=((C_word)li251),tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm:854: getter-with-setter */
t6=*((C_word*)lf[450]+1);{
C_word *av2;
if(c >= 5) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(5);
}
av2[0]=t6;
av2[1]=t3;
av2[2]=t4;
av2[3]=t5;
av2[4]=lf[454];
((C_proc)(void*)(*((C_word*)t6+1)))(5,av2);}}

/* k5679 in k5675 in k5595 in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_5681(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(9,c,4)))){
C_save_and_reclaim((void *)f_5681,2,av);}
a=C_alloc(9);
t2=C_mutate2((C_word*)lf[263]+1 /* (set! current-effective-user-id ...) */,t1);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5685,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_8634,a[2]=((C_word)li252),tmp=(C_word)a,a+=3,tmp);
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_8637,a[2]=((C_word)li253),tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm:845: getter-with-setter */
t6=*((C_word*)lf[450]+1);{
C_word *av2;
if(c >= 5) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(5);
}
av2[0]=t6;
av2[1]=t3;
av2[2]=t4;
av2[3]=t5;
av2[4]=lf[457];
((C_proc)(void*)(*((C_word*)t6+1)))(5,av2);}}

/* k5687 in k5683 in k5679 in k5675 in k5595 in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_5689(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word t17;
C_word t18;
C_word t19;
C_word t20;
C_word t21;
C_word t22;
C_word t23;
C_word t24;
C_word t25;
C_word t26;
C_word t27;
C_word t28;
C_word t29;
C_word t30;
C_word t31;
C_word t32;
C_word t33;
C_word t34;
C_word t35;
C_word t36;
C_word t37;
C_word t38;
C_word t39;
C_word t40;
C_word t41;
C_word t42;
C_word t43;
C_word t44;
C_word t45;
C_word t46;
C_word t47;
C_word t48;
C_word t49;
C_word t50;
C_word t51;
C_word t52;
C_word t53;
C_word t54;
C_word t55;
C_word t56;
C_word t57;
C_word t58;
C_word t59;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(54,c,5)))){
C_save_and_reclaim((void *)f_5689,2,av);}
a=C_alloc(54);
t2=C_mutate2((C_word*)lf[265]+1 /* (set! current-effective-group-id ...) */,t1);
t3=C_mutate2((C_word*)lf[266]+1 /* (set! user-information ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5691,a[2]=((C_word)li136),tmp=(C_word)a,a+=3,tmp));
t4=C_mutate2((C_word*)lf[269]+1 /* (set! current-user-name ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5745,a[2]=((C_word)li137),tmp=(C_word)a,a+=3,tmp));
t5=C_mutate2((C_word*)lf[270]+1 /* (set! current-effective-user-name ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5759,a[2]=((C_word)li138),tmp=(C_word)a,a+=3,tmp));
t6=C_mutate2((C_word*)lf[271]+1 /* (set! group-information ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5784,a[2]=((C_word)li140),tmp=(C_word)a,a+=3,tmp));
t7=C_mutate2((C_word*)lf[272]+1 /* (set! get-groups ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5864,a[2]=((C_word)li142),tmp=(C_word)a,a+=3,tmp));
t8=C_mutate2((C_word*)lf[276]+1 /* (set! set-groups! ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5928,a[2]=((C_word)li144),tmp=(C_word)a,a+=3,tmp));
t9=C_mutate2((C_word*)lf[279]+1 /* (set! initialize-groups ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6003,a[2]=((C_word)li145),tmp=(C_word)a,a+=3,tmp));
t10=C_mutate2((C_word*)lf[281]+1 /* (set! errno/perm ...) */,C_fix((C_word)EPERM));
t11=C_mutate2((C_word*)lf[282]+1 /* (set! errno/noent ...) */,C_fix((C_word)ENOENT));
t12=C_mutate2((C_word*)lf[283]+1 /* (set! errno/srch ...) */,C_fix((C_word)ESRCH));
t13=C_mutate2((C_word*)lf[284]+1 /* (set! errno/intr ...) */,C_fix((C_word)EINTR));
t14=C_mutate2((C_word*)lf[285]+1 /* (set! errno/io ...) */,C_fix((C_word)EIO));
t15=C_mutate2((C_word*)lf[286]+1 /* (set! errno/noexec ...) */,C_fix((C_word)ENOEXEC));
t16=C_mutate2((C_word*)lf[287]+1 /* (set! errno/badf ...) */,C_fix((C_word)EBADF));
t17=C_mutate2((C_word*)lf[288]+1 /* (set! errno/child ...) */,C_fix((C_word)ECHILD));
t18=C_mutate2((C_word*)lf[289]+1 /* (set! errno/nomem ...) */,C_fix((C_word)ENOMEM));
t19=C_mutate2((C_word*)lf[290]+1 /* (set! errno/acces ...) */,C_fix((C_word)EACCES));
t20=C_mutate2((C_word*)lf[291]+1 /* (set! errno/fault ...) */,C_fix((C_word)EFAULT));
t21=C_mutate2((C_word*)lf[292]+1 /* (set! errno/busy ...) */,C_fix((C_word)EBUSY));
t22=C_mutate2((C_word*)lf[293]+1 /* (set! errno/notdir ...) */,C_fix((C_word)ENOTDIR));
t23=C_mutate2((C_word*)lf[294]+1 /* (set! errno/isdir ...) */,C_fix((C_word)EISDIR));
t24=C_mutate2((C_word*)lf[295]+1 /* (set! errno/inval ...) */,C_fix((C_word)EINVAL));
t25=C_mutate2((C_word*)lf[296]+1 /* (set! errno/mfile ...) */,C_fix((C_word)EMFILE));
t26=C_mutate2((C_word*)lf[297]+1 /* (set! errno/nospc ...) */,C_fix((C_word)ENOSPC));
t27=C_mutate2((C_word*)lf[298]+1 /* (set! errno/spipe ...) */,C_fix((C_word)ESPIPE));
t28=C_mutate2((C_word*)lf[299]+1 /* (set! errno/pipe ...) */,C_fix((C_word)EPIPE));
t29=C_mutate2((C_word*)lf[300]+1 /* (set! errno/again ...) */,C_fix((C_word)EAGAIN));
t30=C_mutate2((C_word*)lf[301]+1 /* (set! errno/rofs ...) */,C_fix((C_word)EROFS));
t31=C_mutate2((C_word*)lf[302]+1 /* (set! errno/exist ...) */,C_fix((C_word)EEXIST));
t32=C_mutate2((C_word*)lf[303]+1 /* (set! errno/wouldblock ...) */,C_fix((C_word)EWOULDBLOCK));
t33=C_set_block_item(lf[304] /* errno/2big */,0,C_fix(0));
t34=C_set_block_item(lf[305] /* errno/deadlk */,0,C_fix(0));
t35=C_set_block_item(lf[306] /* errno/dom */,0,C_fix(0));
t36=C_set_block_item(lf[307] /* errno/fbig */,0,C_fix(0));
t37=C_set_block_item(lf[308] /* errno/ilseq */,0,C_fix(0));
t38=C_set_block_item(lf[309] /* errno/mlink */,0,C_fix(0));
t39=C_set_block_item(lf[310] /* errno/nametoolong */,0,C_fix(0));
t40=C_set_block_item(lf[311] /* errno/nfile */,0,C_fix(0));
t41=C_set_block_item(lf[312] /* errno/nodev */,0,C_fix(0));
t42=C_set_block_item(lf[313] /* errno/nolck */,0,C_fix(0));
t43=C_set_block_item(lf[314] /* errno/nosys */,0,C_fix(0));
t44=C_set_block_item(lf[315] /* errno/notempty */,0,C_fix(0));
t45=C_set_block_item(lf[316] /* errno/notty */,0,C_fix(0));
t46=C_set_block_item(lf[317] /* errno/nxio */,0,C_fix(0));
t47=C_set_block_item(lf[318] /* errno/range */,0,C_fix(0));
t48=C_set_block_item(lf[319] /* errno/xdev */,0,C_fix(0));
t49=C_mutate2((C_word*)lf[320]+1 /* (set! change-file-mode ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6067,a[2]=((C_word)li146),tmp=(C_word)a,a+=3,tmp));
t50=C_mutate2((C_word*)lf[322]+1 /* (set! change-file-owner ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6090,a[2]=((C_word)li147),tmp=(C_word)a,a+=3,tmp));
t51=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6116,a[2]=((C_word)li148),tmp=(C_word)a,a+=3,tmp);
t52=C_mutate2((C_word*)lf[324]+1 /* (set! file-read-access? ...) */,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_6136,a[2]=t51,a[3]=((C_word)li149),tmp=(C_word)a,a+=4,tmp));
t53=C_mutate2((C_word*)lf[325]+1 /* (set! file-write-access? ...) */,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_6142,a[2]=t51,a[3]=((C_word)li150),tmp=(C_word)a,a+=4,tmp));
t54=C_mutate2((C_word*)lf[326]+1 /* (set! file-execute-access? ...) */,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_6148,a[2]=t51,a[3]=((C_word)li151),tmp=(C_word)a,a+=4,tmp));
t55=C_mutate2((C_word*)lf[327]+1 /* (set! create-session ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6154,a[2]=((C_word)li152),tmp=(C_word)a,a+=3,tmp));
t56=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6171,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
t57=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_8575,a[2]=((C_word)li248),tmp=(C_word)a,a+=3,tmp);
t58=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_8593,a[2]=((C_word)li249),tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm:1049: getter-with-setter */
t59=*((C_word*)lf[450]+1);{
C_word *av2;
if(c >= 5) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(5);
}
av2[0]=t59;
av2[1]=t56;
av2[2]=t57;
av2[3]=t58;
av2[4]=lf[451];
((C_proc)(void*)(*((C_word*)t59+1)))(5,av2);}}

/* k7634 in k7628 in k7624 in utc-time->seconds in k6200 in k6169 in k5687 in k5683 in k5679 in k5675 in k5595 in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_7636(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,4)))){
C_save_and_reclaim((void *)f_7636,2,av);}
if(C_truep(t1)){
/* posixunix.scm:1454: ##sys#error */
t2=*((C_word*)lf[50]+1);{
C_word *av2;
if(c >= 5) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(5);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[2];
av2[2]=lf[400];
av2[3]=lf[401];
av2[4]=((C_word*)t0)[3];
((C_proc)(void*)(*((C_word*)t2+1)))(5,av2);}}
else{
t2=((C_word*)t0)[2];{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=t2;
av2[1]=((C_word*)t0)[4];
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}}

/* k7628 in k7624 in utc-time->seconds in k6200 in k6169 in k5687 in k5683 in k5679 in k5675 in k5595 in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_7630(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(9,c,3)))){
C_save_and_reclaim((void *)f_7630,2,av);}
a=C_alloc(9);
t2=C_a_timegm(&a,2,((C_word*)t0)[2],t1);
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_7636,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[2],a[4]=t2,tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm:1453: fp= */
t4=*((C_word*)lf[113]+1);{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=t4;
av2[1]=t3;
av2[2]=lf[114];
av2[3]=t2;
((C_proc)(void*)(*((C_word*)t4+1)))(4,av2);}}

/* k5668 in system-information in k5595 in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_5670(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,3)))){
C_save_and_reclaim((void *)f_5670,2,av);}
/* posixunix.scm:818: ##sys#error */
t2=*((C_word*)lf[50]+1);{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[2];
av2[2]=lf[259];
av2[3]=lf[261];
((C_proc)(void*)(*((C_word*)t2+1)))(4,av2);}}

/* k5675 in k5595 in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_5677(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(9,c,4)))){
C_save_and_reclaim((void *)f_5677,2,av);}
a=C_alloc(9);
t2=C_mutate2((C_word*)lf[262]+1 /* (set! current-user-id ...) */,t1);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5681,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_8653,a[2]=((C_word)li254),tmp=(C_word)a,a+=3,tmp);
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_8656,a[2]=((C_word)li255),tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm:835: getter-with-setter */
t6=*((C_word*)lf[450]+1);{
C_word *av2;
if(c >= 5) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(5);
}
av2[0]=t6;
av2[1]=t3;
av2[2]=t4;
av2[3]=t5;
av2[4]=lf[460];
((C_proc)(void*)(*((C_word*)t6+1)))(5,av2);}}

/* file-write in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_4757(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c<4) C_bad_min_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand((c-4)*C_SIZEOF_PAIR +6,c,5)))){
C_save_and_reclaim((void*)f_4757,c,av);}
a=C_alloc((c-4)*C_SIZEOF_PAIR+6);
t4=C_build_rest(&a,c,4,av);
C_word t5;
C_word t6;
C_word t7;
t5=C_i_check_exact_2(t2,lf[191]);
t6=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_4764,a[2]=t2,a[3]=t3,a[4]=t1,a[5]=t4,tmp=(C_word)a,a+=6,tmp);
if(C_truep(C_blockp(t3))){
if(C_truep(C_byteblockp(t3))){
t7=t6;{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=t7;
av2[1]=C_SCHEME_UNDEFINED;
f_4764(2,av2);}}
else{
/* posixunix.scm:509: ##sys#signal-hook */
t7=*((C_word*)lf[1]+1);{
C_word *av2;
if(c >= 6) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(6);
}
av2[0]=t7;
av2[1]=t6;
av2[2]=lf[13];
av2[3]=lf[191];
av2[4]=lf[193];
av2[5]=t3;
((C_proc)(void*)(*((C_word*)t7+1)))(6,av2);}}}
else{
/* posixunix.scm:509: ##sys#signal-hook */
t7=*((C_word*)lf[1]+1);{
C_word *av2;
if(c >= 6) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(6);
}
av2[0]=t7;
av2[1]=t6;
av2[2]=lf[13];
av2[3]=lf[191];
av2[4]=lf[193];
av2[5]=t3;
((C_proc)(void*)(*((C_word*)t7+1)))(6,av2);}}}

/* local-timezone-abbreviation in k6200 in k6169 in k5687 in k5683 in k5679 in k5675 in k5595 in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_7641(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(C_unlikely(!C_demand(C_calculate_demand(5,c,3)))){
C_save_and_reclaim((void *)f_7641,2,av);}
a=C_alloc(5);
t2=C_a_i_bytevector(&a,1,C_fix(3));
t3=stub1812(t2);
/* posixunix.scm:1458: ##sys#peek-c-string */
t4=*((C_word*)lf[4]+1);{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=t4;
av2[1]=t1;
av2[2]=t3;
av2[3]=C_fix(0);
((C_proc)(void*)(*((C_word*)t4+1)))(4,av2);}}

/* k5662 in k5658 in k5654 in k5650 in k5646 in k5639 in system-information in k5595 in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_5664(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(15,c,1)))){
C_save_and_reclaim((void *)f_5664,2,av);}
a=C_alloc(15);
t2=((C_word*)t0)[2];{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=t2;
av2[1]=C_a_i_list5(&a,5,((C_word*)t0)[3],((C_word*)t0)[4],((C_word*)t0)[5],((C_word*)t0)[6],t1);
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* k5658 in k5654 in k5650 in k5646 in k5639 in system-information in k5595 in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_5660(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(10,c,3)))){
C_save_and_reclaim((void *)f_5660,2,av);}
a=C_alloc(10);
t2=t1;
t3=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_5664,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=t2,tmp=(C_word)a,a+=7,tmp);
/* ##sys#peek-nonnull-c-string */
t4=*((C_word*)lf[260]+1);{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=t4;
av2[1]=t3;
av2[2]=C_mpointer(&a,(void*)C_utsname.machine);
av2[3]=C_fix(0);
((C_proc)(void*)(*((C_word*)t4+1)))(4,av2);}}

/* k4724 in file-read in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_4726(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(6,c,5)))){
C_save_and_reclaim((void *)f_4726,2,av);}
a=C_alloc(6);
t2=t1;
t3=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_4729,a[2]=((C_word*)t0)[2],a[3]=t2,a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],tmp=(C_word)a,a+=6,tmp);
if(C_truep(C_blockp(t2))){
if(C_truep(C_byteblockp(t2))){
t4=t3;{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=t4;
av2[1]=C_SCHEME_UNDEFINED;
f_4729(2,av2);}}
else{
/* posixunix.scm:499: ##sys#signal-hook */
t4=*((C_word*)lf[1]+1);{
C_word *av2;
if(c >= 6) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(6);
}
av2[0]=t4;
av2[1]=t3;
av2[2]=lf[13];
av2[3]=lf[188];
av2[4]=lf[190];
av2[5]=t2;
((C_proc)(void*)(*((C_word*)t4+1)))(6,av2);}}}
else{
/* posixunix.scm:499: ##sys#signal-hook */
t4=*((C_word*)lf[1]+1);{
C_word *av2;
if(c >= 6) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(6);
}
av2[0]=t4;
av2[1]=t3;
av2[2]=lf[13];
av2[3]=lf[188];
av2[4]=lf[190];
av2[5]=t2;
((C_proc)(void*)(*((C_word*)t4+1)))(6,av2);}}}

/* k4727 in k4724 in file-read in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_4729(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(11,c,6)))){
C_save_and_reclaim((void *)f_4729,2,av);}
a=C_alloc(11);
t2=C_read(((C_word*)t0)[2],((C_word*)t0)[3],((C_word*)t0)[4]);
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4732,a[2]=((C_word*)t0)[5],a[3]=((C_word*)t0)[3],a[4]=t2,tmp=(C_word)a,a+=5,tmp);
t4=C_eqp(C_fix(-1),t2);
if(C_truep(t4)){
/* posixunix.scm:502: posix-error */
t5=lf[0];{
C_word *av2;
if(c >= 7) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(7);
}
av2[0]=t5;
av2[1]=t3;
av2[2]=lf[8];
av2[3]=lf[188];
av2[4]=lf[189];
av2[5]=((C_word*)t0)[2];
av2[6]=((C_word*)t0)[4];
f_2704(7,av2);}}
else{
t5=((C_word*)t0)[5];{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=t5;
av2[1]=C_a_i_list2(&a,2,((C_word*)t0)[3],t2);
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}}

/* a8655 in k5675 in k5595 in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_8656(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(4,c,2)))){
C_save_and_reclaim((void *)f_8656,3,av);}
a=C_alloc(4);
t3=C_seteuid(t2);
if(C_truep(C_fixnum_lessp(t3,C_fix(0)))){
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_8666,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm:839: ##sys#update-errno */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[5]+1));
C_word *av2=av; /* Re-use our own argvector */
av2[0]=*((C_word*)lf[5]+1);
av2[1]=t4;
tp(2,av2);}}
else{
t4=C_SCHEME_UNDEFINED;
t5=t1;{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=t5;
av2[1]=t4;
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}}

/* k7612 in k7604 in k7600 in string->time in k6200 in k6169 in k5687 in k5683 in k5679 in k5675 in k5595 in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_7614(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_7614,2,av);}
t2=((C_word*)t0)[2];
if(C_truep(t1)){
t3=C_i_foreign_block_argumentp(t1);
t4=t2;{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=t4;
av2[1]=stub1783(C_SCHEME_UNDEFINED,((C_word*)t0)[3],((C_word*)t0)[4],((C_word*)t0)[5],t3);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}
else{
t3=t2;{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=t3;
av2[1]=stub1783(C_SCHEME_UNDEFINED,((C_word*)t0)[3],((C_word*)t0)[4],((C_word*)t0)[5],C_SCHEME_FALSE);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}}

/* a8652 in k5675 in k5595 in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_8653(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_8653,2,av);}
t2=t1;{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=t2;
av2[1]=stub1214(C_SCHEME_UNDEFINED);
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* k8645 in a8636 in k5679 in k5675 in k5595 in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_8647(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,4)))){
C_save_and_reclaim((void *)f_8647,2,av);}
/* posixunix.scm:850: ##sys#error */
t2=*((C_word*)lf[50]+1);{
C_word *av2;
if(c >= 5) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(5);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[2];
av2[2]=lf[455];
av2[3]=lf[456];
av2[4]=((C_word*)t0)[3];
((C_proc)(void*)(*((C_word*)t2+1)))(5,av2);}}

/* k4730 in k4727 in k4724 in file-read in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_4732(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(6,c,1)))){
C_save_and_reclaim((void *)f_4732,2,av);}
a=C_alloc(6);
t2=((C_word*)t0)[2];{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=t2;
av2[1]=C_a_i_list2(&a,2,((C_word*)t0)[3],((C_word*)t0)[4]);
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* k7624 in utc-time->seconds in k6200 in k6169 in k5687 in k5683 in k5679 in k5675 in k5595 in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_7626(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,3)))){
C_save_and_reclaim((void *)f_7626,2,av);}
a=C_alloc(4);
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_7630,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm:1452: ##sys#make-string */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[72]+1));
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[72]+1);
av2[1]=t2;
av2[2]=((C_word*)t0)[4];
av2[3]=C_make_character(0);
tp(4,av2);}}

/* utc-time->seconds in k6200 in k6169 in k5687 in k5683 in k5679 in k5675 in k5595 in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_7622(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(5,c,3)))){
C_save_and_reclaim((void *)f_7622,3,av);}
a=C_alloc(5);
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_7626,a[2]=t2,a[3]=t1,a[4]=((C_word*)t0)[2],tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm:1451: check-time-vector */
f_3908(t3,lf[400],t2);}

/* a4505 in a4499 in a4493 in k4484 in k4478 in call-with-exec-args in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_4506(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(C_unlikely(!C_demand(C_calculate_demand(5,c,2)))){
C_save_and_reclaim((void *)f_4506,2,av);}
a=C_alloc(5);
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4510,a[2]=t1,a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],tmp=(C_word)a,a+=5,tmp);
/* posix-common.scm:736: free-c-string-buffer */
f_4440(t2,((C_word*)t0)[4]);}

/* k5639 in system-information in k5595 in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_5641(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(6,c,3)))){
C_save_and_reclaim((void *)f_5641,2,av);}
a=C_alloc(6);
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5648,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
/* ##sys#peek-nonnull-c-string */
t3=*((C_word*)lf[260]+1);{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=t3;
av2[1]=t2;
av2[2]=C_mpointer(&a,(void*)C_utsname.sysname);
av2[3]=C_fix(0);
((C_proc)(void*)(*((C_word*)t3+1)))(4,av2);}}

/* a4499 in a4493 in k4484 in k4478 in call-with-exec-args in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_4500(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(6,c,2)))){
C_save_and_reclaim((void *)f_4500,3,av);}
a=C_alloc(6);
t3=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_4506,a[2]=t2,a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],a[5]=((C_word)li84),tmp=(C_word)a,a+=6,tmp);
/* posix-common.scm:726: k722 */
t4=((C_word*)t0)[4];{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=t4;
av2[1]=t1;
av2[2]=t3;
((C_proc)C_fast_retrieve_proc(t4))(3,av2);}}

/* k7677 in set-buffering-mode! in k6200 in k6169 in k5687 in k5683 in k5679 in k5675 in k5595 in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_7679(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(5,c,2)))){
C_save_and_reclaim((void *)f_7679,2,av);}
a=C_alloc(5);
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_7682,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],tmp=(C_word)a,a+=5,tmp);
if(C_truep(C_i_pairp(((C_word*)t0)[5]))){
t3=((C_word*)t0)[5];
t4=t2;
f_7682(t4,C_u_i_car(t3));}
else{
t3=t2;
f_7682(t3,C_fix((C_word)BUFSIZ));}}

/* k5646 in k5639 in system-information in k5595 in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_5648(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(7,c,3)))){
C_save_and_reclaim((void *)f_5648,2,av);}
a=C_alloc(7);
t2=t1;
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5652,a[2]=((C_word*)t0)[2],a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* ##sys#peek-nonnull-c-string */
t4=*((C_word*)lf[260]+1);{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=t4;
av2[1]=t3;
av2[2]=C_mpointer(&a,(void*)C_utsname.nodename);
av2[3]=C_fix(0);
((C_proc)(void*)(*((C_word*)t4+1)))(4,av2);}}

/* a8674 in k5595 in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_8675(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(4,c,2)))){
C_save_and_reclaim((void *)f_8675,3,av);}
a=C_alloc(4);
t3=C_setuid(t2);
if(C_truep(C_fixnum_lessp(t3,C_fix(0)))){
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_8685,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm:830: ##sys#update-errno */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[5]+1));
C_word *av2=av; /* Re-use our own argvector */
av2[0]=*((C_word*)lf[5]+1);
av2[1]=t4;
tp(2,av2);}}
else{
t4=C_SCHEME_UNDEFINED;
t5=t1;{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=t5;
av2[1]=t4;
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}}

/* a4549 in a4543 in a4520 in a4493 in k4484 in k4478 in call-with-exec-args in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_4550(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,2)))){
C_save_and_reclaim((void *)f_4550,2,av);}{
C_word *av2;
if(c >= 3) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(3);
}
av2[0]=0;
av2[1]=t1;
av2[2]=((C_word*)t0)[2];
C_apply_values(3,av2);}}

/* set-buffering-mode! in k6200 in k6169 in k5687 in k5683 in k5679 in k5675 in k5595 in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_7675(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c<4) C_bad_min_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand((c-4)*C_SIZEOF_PAIR +6,c,3)))){
C_save_and_reclaim((void*)f_7675,c,av);}
a=C_alloc((c-4)*C_SIZEOF_PAIR+6);
t4=C_build_rest(&a,c,4,av);
C_word t5;
C_word t6;
t5=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_7679,a[2]=t3,a[3]=t1,a[4]=t2,a[5]=t4,tmp=(C_word)a,a+=6,tmp);
/* posixunix.scm:1485: ##sys#check-port */
t6=*((C_word*)lf[411]+1);{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=t6;
av2[1]=t5;
av2[2]=t2;
av2[3]=lf[405];
((C_proc)(void*)(*((C_word*)t6+1)))(4,av2);}}

/* ##sys#file-nonblocking! in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_4556(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_4556,3,av);}
t3=C_i_foreign_fixnum_argumentp(t2);
t4=t1;{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=t4;
av2[1]=stub788(C_SCHEME_UNDEFINED,t3);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* system-information in k5595 in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_5637(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(C_unlikely(!C_demand(C_calculate_demand(6,c,2)))){
C_save_and_reclaim((void *)f_5637,2,av);}
a=C_alloc(6);
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5641,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
if(C_truep(C_fixnum_lessp(C_fix((C_word)C_uname),C_fix(0)))){
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5670,a[2]=t2,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm:817: ##sys#update-errno */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[5]+1));
C_word *av2=av; /* Re-use our own argvector */
av2[0]=*((C_word*)lf[5]+1);
av2[1]=t3;
tp(2,av2);}}
else{
t3=t2;{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=t3;
av2[1]=C_SCHEME_UNDEFINED;
f_5641(2,av2);}}}

/* a8671 in k5595 in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_8672(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_8672,2,av);}
t2=t1;{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=t2;
av2[1]=stub1209(C_SCHEME_UNDEFINED);
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* k2678 in k2675 */
static void C_ccall f_2680(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(3,c,2)))){
C_save_and_reclaim((void *)f_2680,2,av);}
a=C_alloc(3);
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2683,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=C_SCHEME_UNDEFINED;
av2[1]=t2;
C_extras_toplevel(2,av2);}}

/* k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_2689(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(3,c,2)))){
C_save_and_reclaim((void *)f_2689,2,av);}
a=C_alloc(3);
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2692,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=C_SCHEME_UNDEFINED;
av2[1]=t2;
C_lolevel_toplevel(2,av2);}}

/* k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_2686(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(3,c,2)))){
C_save_and_reclaim((void *)f_2686,2,av);}
a=C_alloc(3);
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2689,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=C_SCHEME_UNDEFINED;
av2[1]=t2;
C_ports_toplevel(2,av2);}}

/* k2681 in k2678 in k2675 */
static void C_ccall f_2683(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(3,c,2)))){
C_save_and_reclaim((void *)f_2683,2,av);}
a=C_alloc(3);
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2686,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=C_SCHEME_UNDEFINED;
av2[1]=t2;
C_files_toplevel(2,av2);}}

/* k8664 in a8655 in k5675 in k5595 in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_8666(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,4)))){
C_save_and_reclaim((void *)f_8666,2,av);}
/* posixunix.scm:840: ##sys#error */
t2=*((C_word*)lf[50]+1);{
C_word *av2;
if(c >= 5) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(5);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[2];
av2[2]=lf[458];
av2[3]=lf[459];
av2[4]=((C_word*)t0)[3];
((C_proc)(void*)(*((C_word*)t2+1)))(5,av2);}}

/* create-fifo in k6200 in k6169 in k5687 in k5683 in k5679 in k5675 in k5595 in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_7353(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand((c-3)*C_SIZEOF_PAIR +4,c,2)))){
C_save_and_reclaim((void*)f_7353,c,av);}
a=C_alloc((c-3)*C_SIZEOF_PAIR+4);
t3=C_build_rest(&a,c,3,av);
C_word t4;
C_word t5;
C_word t6;
C_word t7;
t4=C_i_check_string_2(t2,lf[375]);
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_7360,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
if(C_truep(C_i_pairp(t3))){
t6=t3;
t7=t5;
f_7360(t7,C_u_i_car(t6));}
else{
t6=C_fixnum_or(C_fix((C_word)S_IRWXG),C_fix((C_word)S_IRWXO));
t7=t5;
f_7360(t7,C_fixnum_or(C_fix((C_word)S_IRWXU),t6));}}

/* k7680 in k7677 in set-buffering-mode! in k6200 in k6169 in k5687 in k5683 in k5679 in k5675 in k5595 in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_fcall f_7682(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(5,0,5)))){
C_save_and_reclaim_args((void *)trf_7682,2,t0,t1);}
a=C_alloc(5);
t2=t1;
t3=((C_word*)t0)[2];
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_7685,a[2]=t2,a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],tmp=(C_word)a,a+=5,tmp);
t5=C_eqp(t3,lf[407]);
if(C_truep(t5)){
t6=t4;{
C_word av2[2];
av2[0]=t6;
av2[1]=C_fix((C_word)_IOFBF);
f_7685(2,av2);}}
else{
t6=C_eqp(t3,lf[408]);
if(C_truep(t6)){
t7=C_fix((C_word)_IOLBF);
t8=t4;{
C_word av2[2];
av2[0]=t8;
av2[1]=t7;
f_7685(2,av2);}}
else{
t7=C_eqp(t3,lf[409]);
if(C_truep(t7)){
t8=t4;{
C_word av2[2];
av2[0]=t8;
av2[1]=C_fix((C_word)_IONBF);
f_7685(2,av2);}}
else{
/* posixunix.scm:1491: ##sys#error */
t8=*((C_word*)lf[50]+1);{
C_word av2[6];
av2[0]=t8;
av2[1]=t4;
av2[2]=lf[405];
av2[3]=lf[410];
av2[4]=((C_word*)t0)[2];
av2[5]=((C_word*)t0)[4];
((C_proc)(void*)(*((C_word*)t8+1)))(6,av2);}}}}}

/* ##sys#file-select-one in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_4563(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_4563,3,av);}
t3=C_i_foreign_fixnum_argumentp(t2);
t4=t1;{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=t4;
av2[1]=stub793(C_SCHEME_UNDEFINED,t3);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* k7683 in k7680 in k7677 in set-buffering-mode! in k6200 in k6169 in k5687 in k5683 in k5679 in k5675 in k5595 in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_7685(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(6,c,2)))){
C_save_and_reclaim((void *)f_7685,2,av);}
a=C_alloc(6);
t2=t1;
t3=C_i_check_exact_2(((C_word*)t0)[2],lf[405]);
t4=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_7694,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=t2,a[5]=((C_word*)t0)[2],tmp=(C_word)a,a+=6,tmp);
t5=C_slot(((C_word*)t0)[4],C_fix(7));
t6=C_eqp(lf[43],t5);
if(C_truep(t6)){
t7=C_setvbuf(((C_word*)t0)[4],t2,((C_word*)t0)[2]);
t8=t4;
f_7694(t8,C_fixnum_lessp(t7,C_fix(0)));}
else{
t7=t4;
f_7694(t7,C_SCHEME_TRUE);}}

/* signal-unmask! in k5595 in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_5621(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,4)))){
C_save_and_reclaim((void *)f_5621,3,av);}
t3=C_i_check_exact_2(t2,lf[257]);
t4=C_sigemptyset(C_fix(0));
t5=C_sigaddset(t2);
t6=C_sigprocmask_unblock(C_fix(0));
if(C_truep(C_fixnum_lessp(t6,C_fix(0)))){
/* posixunix.scm:802: posix-error */
t7=lf[0];{
C_word *av2;
if(c >= 5) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(5);
}
av2[0]=t7;
av2[1]=t1;
av2[2]=lf[127];
av2[3]=lf[257];
av2[4]=lf[258];
f_2704(5,av2);}}
else{
t7=C_SCHEME_UNDEFINED;
t8=t1;{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=t8;
av2[1]=t7;
((C_proc)(void*)(*((C_word*)t8+1)))(2,av2);}}}

/* ##sys#custom-output-port in k6200 in k6169 in k5687 in k5683 in k5679 in k5675 in k5595 in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_6888(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4=av[4];
C_word t5;
C_word *a;
if(c<5) C_bad_min_argc_2(c,5,t0);
if(C_unlikely(!C_demand(C_calculate_demand((c-5)*C_SIZEOF_PAIR +8,c,2)))){
C_save_and_reclaim((void*)f_6888,c,av);}
a=C_alloc((c-5)*C_SIZEOF_PAIR+8);
t5=C_build_rest(&a,c,5,av);
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word t17;
C_word t18;
C_word t19;
C_word t20;
C_word t21;
t6=C_i_nullp(t5);
t7=(C_truep(t6)?C_SCHEME_FALSE:C_i_car(t5));
t8=C_i_nullp(t5);
t9=(C_truep(t8)?C_SCHEME_END_OF_LIST:C_i_cdr(t5));
t10=C_i_nullp(t9);
t11=(C_truep(t10)?C_fix(0):C_i_car(t9));
t12=t11;
t13=C_i_nullp(t9);
t14=(C_truep(t13)?C_SCHEME_END_OF_LIST:C_i_cdr(t9));
t15=C_i_nullp(t14);
t16=(C_truep(t15)?*((C_word*)lf[346]+1):C_i_car(t14));
t17=t16;
t18=C_i_nullp(t14);
t19=(C_truep(t18)?C_SCHEME_END_OF_LIST:C_i_cdr(t14));
t20=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_6910,a[2]=t4,a[3]=t2,a[4]=t3,a[5]=t12,a[6]=t1,a[7]=t17,tmp=(C_word)a,a+=8,tmp);
if(C_truep(t7)){
/* posixunix.scm:1251: ##sys#file-nonblocking! */
t21=*((C_word*)lf[143]+1);{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=t21;
av2[1]=t20;
av2[2]=t4;
((C_proc)(void*)(*((C_word*)t21+1)))(3,av2);}}
else{
t21=t20;{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=t21;
av2[1]=C_SCHEME_UNDEFINED;
f_6910(2,av2);}}}

/* k2675 */
static void C_ccall f_2677(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(3,c,2)))){
C_save_and_reclaim((void *)f_2677,2,av);}
a=C_alloc(3);
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2680,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=C_SCHEME_UNDEFINED;
av2[1]=t2;
C_irregex_toplevel(2,av2);}}

/* k8419 in %process in k6200 in k6169 in k5687 in k5683 in k5679 in k5675 in k5595 in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_8421(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(9,c,2)))){
C_save_and_reclaim((void *)f_8421,2,av);}
a=C_alloc(9);
t2=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_8424,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[6],a[7]=((C_word*)t0)[7],a[8]=((C_word*)t0)[8],tmp=(C_word)a,a+=9,tmp);
if(C_truep(((C_word*)t0)[5])){
/* posixunix.scm:1728: chkstrlst */
t3=((C_word*)t0)[9];
f_8380(t3,t2,((C_word*)t0)[5]);}
else{
t3=t2;{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=t3;
av2[1]=C_SCHEME_UNDEFINED;
f_8424(2,av2);}}}

/* k4529 in a4526 in a4520 in a4493 in k4484 in k4478 in call-with-exec-args in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_fcall f_4531(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(6,0,3)))){
C_save_and_reclaim_args((void *)trf_4531,2,t0,t1);}
a=C_alloc(6);
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_4538,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],tmp=(C_word)a,a+=6,tmp);
/* posix-common.scm:744: ##sys#make-c-string */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[11]+1));
C_word av2[4];
av2[0]=*((C_word*)lf[11]+1);
av2[1]=t2;
av2[2]=((C_word*)t0)[6];
av2[3]=((C_word*)t0)[7];
tp(4,av2);}}

/* k8422 in k8419 in %process in k6200 in k6169 in k5687 in k5683 in k5679 in k5675 in k5595 in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_8424(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(8,c,3)))){
C_save_and_reclaim((void *)f_8424,2,av);}
a=C_alloc(8);
t2=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_8429,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[6],a[7]=((C_word)li242),tmp=(C_word)a,a+=8,tmp);
/* posixunix.scm:1729: ##sys#call-with-values */{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=0;
av2[1]=((C_word*)t0)[7];
av2[2]=t2;
av2[3]=((C_word*)t0)[8];
C_call_with_values(4,av2);}}

/* _exit in k6200 in k6169 in k5687 in k5683 in k5679 in k5675 in k5595 in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_7654(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand((c-2)*C_SIZEOF_PAIR +0,c,1)))){
C_save_and_reclaim((void*)f_7654,c,av);}
a=C_alloc((c-2)*C_SIZEOF_PAIR+0);
t2=C_build_rest(&a,c,2,av);
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
if(C_truep(C_i_pairp(t2))){
t3=t2;
t4=C_u_i_car(t3);
t5=t1;
t6=C_i_foreign_fixnum_argumentp(t4);
t7=t5;{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=t7;
av2[1]=stub1818(C_SCHEME_UNDEFINED,t6);
((C_proc)(void*)(*((C_word*)t7+1)))(2,av2);}}
else{
t3=t1;
t4=C_i_foreign_fixnum_argumentp(C_fix(0));
t5=t3;{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=t5;
av2[1]=stub1818(C_SCHEME_UNDEFINED,t4);
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}}

/* set-alarm! in k6200 in k6169 in k5687 in k5683 in k5679 in k5675 in k5595 in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_7668(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_7668,3,av);}
t3=C_i_foreign_fixnum_argumentp(t2);
t4=t1;{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=t4;
av2[1]=stub1824(C_SCHEME_UNDEFINED,t3);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* k4536 in k4529 in a4526 in a4520 in a4493 in k4484 in k4478 in call-with-exec-args in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_4538(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,4)))){
C_save_and_reclaim((void *)f_4538,2,av);}
/* posix-common.scm:744: proc */
t2=((C_word*)t0)[2];{
C_word *av2;
if(c >= 5) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(5);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[3];
av2[2]=t1;
av2[3]=((C_word*)t0)[4];
av2[4]=((C_word*)((C_word*)t0)[5])[1];
((C_proc)C_fast_retrieve_proc(t2))(5,av2);}}

/* user-information in k5687 in k5683 in k5679 in k5675 in k5595 in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_5691(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand((c-3)*C_SIZEOF_PAIR +7,c,3)))){
C_save_and_reclaim((void*)f_5691,c,av);}
a=C_alloc((c-3)*C_SIZEOF_PAIR+7);
t3=C_build_rest(&a,c,3,av);
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
t4=C_i_nullp(t3);
t5=(C_truep(t4)?C_SCHEME_FALSE:C_i_car(t3));
t6=t5;
t7=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5698,a[2]=t6,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
if(C_truep(C_fixnump(t2))){
t8=t7;
f_5698(t8,C_getpwuid(t2));}
else{
t8=C_i_check_string_2(t2,lf[266]);
t9=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5737,a[2]=t7,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm:876: ##sys#make-c-string */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[11]+1));
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[11]+1);
av2[1]=t9;
av2[2]=t2;
av2[3]=lf[266];
tp(4,av2);}}}

/* k5696 in user-information in k5687 in k5683 in k5679 in k5675 in k5595 in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_fcall f_5698(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(7,0,3)))){
C_save_and_reclaim_args((void *)trf_5698,2,t0,t1);}
a=C_alloc(7);
if(C_truep(t1)){
t2=(C_truep(((C_word*)t0)[2])?*((C_word*)lf[267]+1):*((C_word*)lf[268]+1));
t3=t2;
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5711,a[2]=t3,a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* ##sys#peek-nonnull-c-string */
t5=*((C_word*)lf[260]+1);{
C_word av2[4];
av2[0]=t5;
av2[1]=t4;
av2[2]=C_mpointer(&a,(void*)C_user->pw_name);
av2[3]=C_fix(0);
((C_proc)(void*)(*((C_word*)t5+1)))(4,av2);}}
else{
t2=((C_word*)t0)[3];{
C_word av2[2];
av2[0]=t2;
av2[1]=C_SCHEME_FALSE;
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}}

/* a8428 in k8422 in k8419 in %process in k6200 in k6169 in k5687 in k5683 in k5679 in k5675 in k5595 in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_8429(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,8)))){
C_save_and_reclaim((void *)f_8429,2,av);}
/* posixunix.scm:1730: ##sys#process */
t2=*((C_word*)lf[441]+1);{
C_word *av2;
if(c >= 9) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(9);
}
av2[0]=t2;
av2[1]=t1;
av2[2]=((C_word*)t0)[2];
av2[3]=((C_word*)((C_word*)t0)[3])[1];
av2[4]=((C_word*)((C_word*)t0)[4])[1];
av2[5]=((C_word*)t0)[5];
av2[6]=C_SCHEME_TRUE;
av2[7]=C_SCHEME_TRUE;
av2[8]=((C_word*)t0)[6];
((C_proc)(void*)(*((C_word*)t2+1)))(9,av2);}}

/* k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_2692(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(18,c,6)))){
C_save_and_reclaim((void *)f_2692,2,av);}
a=C_alloc(18);
t2=C_mutate2(&lf[0] /* (set! posix-error ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2704,a[2]=((C_word)li0),tmp=(C_word)a,a+=3,tmp));
t3=C_mutate2((C_word*)lf[6]+1 /* (set! ##sys#posix-error ...) */,lf[0]);
t4=C_mutate2(&lf[7] /* (set! ##sys#stat ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2722,a[2]=((C_word)li1),tmp=(C_word)a,a+=3,tmp));
t5=C_mutate2((C_word*)lf[16]+1 /* (set! file-stat ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2772,a[2]=((C_word)li2),tmp=(C_word)a,a+=3,tmp));
t6=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2792,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
t7=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_8802,a[2]=((C_word)li264),tmp=(C_word)a,a+=3,tmp);
t8=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_8808,a[2]=((C_word)li265),tmp=(C_word)a,a+=3,tmp);
/* posix-common.scm:252: getter-with-setter */
t9=*((C_word*)lf[450]+1);{
C_word *av2;
if(c >= 5) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(5);
}
av2[0]=t9;
av2[1]=t6;
av2[2]=t7;
av2[3]=t8;
av2[4]=lf[469];
((C_proc)(void*)(*((C_word*)t9+1)))(5,av2);}}

/* k3814 in k3715 in k3706 in loop in k3691 in k3684 in k3681 in k3872 in k3869 in k3866 in k3863 in k3860 in k3857 in find-files in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 in ... */
static void C_ccall f_3816(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(6,c,4)))){
C_save_and_reclaim((void *)f_3816,2,av);}
a=C_alloc(6);
if(C_truep(t1)){
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_3823,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],tmp=(C_word)a,a+=6,tmp);
/* posix-common.scm:549: action */
t3=((C_word*)t0)[6];{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=t3;
av2[1]=t2;
av2[2]=((C_word*)t0)[7];
av2[3]=((C_word*)t0)[8];
((C_proc)C_fast_retrieve_proc(t3))(4,av2);}}
else{
/* posix-common.scm:550: loop */
t2=((C_word*)((C_word*)t0)[2])[1];
f_3695(t2,((C_word*)t0)[3],((C_word*)t0)[4],((C_word*)t0)[5],((C_word*)t0)[8]);}}

/* k8441 in %process in k6200 in k6169 in k5687 in k5683 in k5679 in k5675 in k5595 in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_8443(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,2)))){
C_save_and_reclaim((void *)f_8443,2,av);}
a=C_alloc(4);
t2=C_mutate2(((C_word *)((C_word*)t0)[2])+1,t1);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_8447,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm:1727: ##sys#shell-command */
t4=*((C_word*)lf[433]+1);{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=t4;
av2[1]=t3;
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* k7300 in file-test-lock in k6200 in k6169 in k5687 in k5683 in k5679 in k5675 in k5595 in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_7302(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,4)))){
C_save_and_reclaim((void *)f_7302,2,av);}
t2=C_flock_test(((C_word*)t0)[2]);
if(C_truep(t2)){
t3=((C_word*)t0)[3];
t4=C_eqp(t2,C_fix(0));
t5=t3;{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=t5;
av2[1]=(C_truep(t4)?C_SCHEME_FALSE:t2);
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}
else{
/* posixunix.scm:1352: err */
f_7248(((C_word*)t0)[3],lf[372],t1,lf[371]);}}

/* create-pipe in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_5501(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(C_unlikely(!C_demand(C_calculate_demand(3,c,4)))){
C_save_and_reclaim((void *)f_5501,2,av);}
a=C_alloc(3);
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5505,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
t3=C_pipe(C_SCHEME_FALSE);
if(C_truep(C_fixnum_lessp(t3,C_fix(0)))){
/* posixunix.scm:691: posix-error */
t4=lf[0];{
C_word *av2;
if(c >= 5) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(5);
}
av2[0]=t4;
av2[1]=t2;
av2[2]=lf[8];
av2[3]=lf[221];
av2[4]=lf[222];
f_2704(5,av2);}}
else{
/* posixunix.scm:692: values */{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=0;
av2[1]=t1;
av2[2]=C_fix((C_word)C_pipefds[ 0 ]);
av2[3]=C_fix((C_word)C_pipefds[ 1 ]);
C_values(4,av2);}}}

/* k5503 in create-pipe in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_5505(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,3)))){
C_save_and_reclaim((void *)f_5505,2,av);}
/* posixunix.scm:692: values */{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=0;
av2[1]=((C_word*)t0)[2];
av2[2]=C_fix((C_word)C_pipefds[ 0 ]);
av2[3]=C_fix((C_word)C_pipefds[ 1 ]);
C_values(4,av2);}}

/* k7358 in create-fifo in k6200 in k6169 in k5687 in k5683 in k5679 in k5675 in k5595 in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_fcall f_7360(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(5,0,3)))){
C_save_and_reclaim_args((void *)trf_7360,2,t0,t1);}
a=C_alloc(5);
t2=t1;
t3=C_i_check_exact_2(t2,lf[375]);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_7377,a[2]=t2,a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm:1369: ##sys#make-c-string */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[11]+1));
C_word av2[4];
av2[0]=*((C_word*)lf[11]+1);
av2[1]=t4;
av2[2]=((C_word*)t0)[3];
av2[3]=lf[375];
tp(4,av2);}}

/* k5650 in k5646 in k5639 in system-information in k5595 in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_5652(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(8,c,3)))){
C_save_and_reclaim((void *)f_5652,2,av);}
a=C_alloc(8);
t2=t1;
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_5656,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t2,tmp=(C_word)a,a+=5,tmp);
/* ##sys#peek-nonnull-c-string */
t4=*((C_word*)lf[260]+1);{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=t4;
av2[1]=t3;
av2[2]=C_mpointer(&a,(void*)C_utsname.release);
av2[3]=C_fix(0);
((C_proc)(void*)(*((C_word*)t4+1)))(4,av2);}}

/* k5654 in k5650 in k5646 in k5639 in system-information in k5595 in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_5656(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(9,c,3)))){
C_save_and_reclaim((void *)f_5656,2,av);}
a=C_alloc(9);
t2=t1;
t3=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_5660,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=t2,tmp=(C_word)a,a+=6,tmp);
/* ##sys#peek-nonnull-c-string */
t4=*((C_word*)lf[260]+1);{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=t4;
av2[1]=t3;
av2[2]=C_mpointer(&a,(void*)C_utsname.version);
av2[3]=C_fix(0);
((C_proc)(void*)(*((C_word*)t4+1)))(4,av2);}}

/* a5495 in k5469 in with-output-to-pipe in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_5496(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_5496,2,av);}
t2=C_mutate2(((C_word *)((C_word*)t0)[2])+1,*((C_word*)lf[220]+1));
t3=C_mutate2((C_word*)lf[220]+1 /* (set! ##sys#standard-output ...) */,((C_word*)((C_word*)t0)[3])[1]);
t4=t1;{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=t4;
av2[1]=C_SCHEME_UNDEFINED;
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* k5489 in a5486 in a5480 in k5469 in with-output-to-pipe in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_5491(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,2)))){
C_save_and_reclaim((void *)f_5491,2,av);}{
C_word *av2;
if(c >= 3) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(3);
}
av2[0]=0;
av2[1]=((C_word*)t0)[2];
av2[2]=((C_word*)t0)[3];
C_apply_values(3,av2);}}

/* k7375 in k7358 in create-fifo in k6200 in k6169 in k5687 in k5683 in k5679 in k5675 in k5595 in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_7377(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,6)))){
C_save_and_reclaim((void *)f_7377,2,av);}
t2=C_mkfifo(t1,((C_word*)t0)[2]);
if(C_truep(C_fixnum_lessp(t2,C_fix(0)))){
/* posixunix.scm:1370: posix-error */
t3=lf[0];{
C_word *av2;
if(c >= 7) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(7);
}
av2[0]=t3;
av2[1]=((C_word*)t0)[3];
av2[2]=lf[8];
av2[3]=lf[375];
av2[4]=lf[376];
av2[5]=((C_word*)t0)[4];
av2[6]=((C_word*)t0)[2];
f_2704(7,av2);}}
else{
t3=C_SCHEME_UNDEFINED;
t4=((C_word*)t0)[3];{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=t4;
av2[1]=t3;
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}}

/* a5475 in k5469 in with-output-to-pipe in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_5476(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_5476,2,av);}
t2=C_mutate2(((C_word *)((C_word*)t0)[2])+1,*((C_word*)lf[220]+1));
t3=C_mutate2((C_word*)lf[220]+1 /* (set! ##sys#standard-output ...) */,((C_word*)((C_word*)t0)[3])[1]);
t4=t1;{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=t4;
av2[1]=C_SCHEME_UNDEFINED;
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* k5469 in with-output-to-pipe in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_5471(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(19,c,4)))){
C_save_and_reclaim((void *)f_5471,2,av);}
a=C_alloc(19);
t2=t1;
t3=t2;
t4=(*a=C_VECTOR_TYPE|1,a[1]=t3,tmp=(C_word)a,a+=2,tmp);
t5=C_SCHEME_FALSE;
t6=(*a=C_VECTOR_TYPE|1,a[1]=t5,tmp=(C_word)a,a+=2,tmp);
t7=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_5476,a[2]=t6,a[3]=t4,a[4]=((C_word)li124),tmp=(C_word)a,a+=5,tmp);
t8=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_5481,a[2]=t2,a[3]=((C_word*)t0)[2],a[4]=((C_word)li126),tmp=(C_word)a,a+=5,tmp);
t9=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_5496,a[2]=t4,a[3]=t6,a[4]=((C_word)li127),tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm:677: ##sys#dynamic-wind */
t10=*((C_word*)lf[95]+1);{
C_word *av2;
if(c >= 5) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(5);
}
av2[0]=t10;
av2[1]=((C_word*)t0)[3];
av2[2]=t7;
av2[3]=t8;
av2[4]=t9;
((C_proc)(void*)(*((C_word*)t10+1)))(5,av2);}}

/* k3805 in k3715 in k3706 in loop in k3691 in k3684 in k3681 in k3872 in k3869 in k3866 in k3863 in k3860 in k3857 in find-files in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 in ... */
static void C_ccall f_3807(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(16,c,2)))){
C_save_and_reclaim((void *)f_3807,2,av);}
a=C_alloc(16);
t2=(C_truep(t1)?C_i_not(((C_word*)t0)[2]):C_SCHEME_FALSE);
if(C_truep(t2)){
t3=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_3739,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[6],tmp=(C_word)a,a+=6,tmp);
t4=(*a=C_CLOSURE_TYPE|9,a[1]=(C_word)f_3742,a[2]=((C_word*)t0)[7],a[3]=t3,a[4]=((C_word*)t0)[8],a[5]=((C_word*)t0)[9],a[6]=((C_word*)t0)[3],a[7]=((C_word*)t0)[4],a[8]=((C_word*)t0)[5],a[9]=((C_word*)t0)[6],tmp=(C_word)a,a+=10,tmp);
/* posix-common.scm:540: pproc */
t5=((C_word*)t0)[10];{
C_word *av2;
if(c >= 3) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(3);
}
av2[0]=t5;
av2[1]=t4;
av2[2]=((C_word*)t0)[8];
((C_proc)(void*)(*((C_word*)t5+1)))(3,av2);}}
else{
t3=(*a=C_CLOSURE_TYPE|11,a[1]=(C_word)f_3751,a[2]=((C_word*)t0)[11],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[6],a[7]=((C_word*)t0)[8],a[8]=((C_word*)t0)[7],a[9]=((C_word*)t0)[9],a[10]=((C_word*)t0)[10],a[11]=((C_word*)t0)[12],tmp=(C_word)a,a+=12,tmp);
/* posix-common.scm:541: lproc */
t4=((C_word*)t0)[13];{
C_word *av2;
if(c >= 3) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(3);
}
av2[0]=t4;
av2[1]=t3;
av2[2]=((C_word*)t0)[8];
((C_proc)C_fast_retrieve_proc(t4))(3,av2);}}}

/* k5717 in k5713 in k5709 in k5696 in user-information in k5687 in k5683 in k5679 in k5675 in k5595 in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_5719(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(10,c,3)))){
C_save_and_reclaim((void *)f_5719,2,av);}
a=C_alloc(10);
t2=t1;
t3=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_5723,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=t2,tmp=(C_word)a,a+=7,tmp);
/* ##sys#peek-c-string */
t4=*((C_word*)lf[4]+1);{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=t4;
av2[1]=t3;
av2[2]=C_mpointer(&a,(void*)C_user->pw_dir);
av2[3]=C_fix(0);
((C_proc)(void*)(*((C_word*)t4+1)))(4,av2);}}

/* k5713 in k5709 in k5696 in user-information in k5687 in k5683 in k5679 in k5675 in k5595 in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_5715(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(9,c,3)))){
C_save_and_reclaim((void *)f_5715,2,av);}
a=C_alloc(9);
t2=t1;
t3=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_5719,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=t2,tmp=(C_word)a,a+=6,tmp);
/* ##sys#peek-nonnull-c-string */
t4=*((C_word*)lf[260]+1);{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=t4;
av2[1]=t3;
av2[2]=C_mpointer(&a,(void*)C_PW_GECOS);
av2[3]=C_fix(0);
((C_proc)(void*)(*((C_word*)t4+1)))(4,av2);}}

/* k5709 in k5696 in user-information in k5687 in k5683 in k5679 in k5675 in k5595 in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_5711(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(8,c,3)))){
C_save_and_reclaim((void *)f_5711,2,av);}
a=C_alloc(8);
t2=t1;
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_5715,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t2,tmp=(C_word)a,a+=5,tmp);
/* ##sys#peek-nonnull-c-string */
t4=*((C_word*)lf[260]+1);{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=t4;
av2[1]=t3;
av2[2]=C_mpointer(&a,(void*)C_user->pw_passwd);
av2[3]=C_fix(0);
((C_proc)(void*)(*((C_word*)t4+1)))(4,av2);}}

/* k3799 in k3749 in k3805 in k3715 in k3706 in loop in k3691 in k3684 in k3681 in k3872 in k3869 in k3866 in k3863 in k3860 in k3857 in find-files in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in ... */
static void C_ccall f_3801(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,4)))){
C_save_and_reclaim((void *)f_3801,2,av);}
if(C_truep(t1)){
/* posix-common.scm:548: action */
t2=((C_word*)t0)[2];{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[3];
av2[2]=((C_word*)t0)[4];
av2[3]=((C_word*)t0)[5];
((C_proc)C_fast_retrieve_proc(t2))(4,av2);}}
else{
t2=((C_word*)t0)[5];
/* posix-common.scm:548: loop */
t3=((C_word*)((C_word*)t0)[6])[1];
f_3695(t3,((C_word*)t0)[7],((C_word*)t0)[8],((C_word*)t0)[9],t2);}}

/* k3349 in k3346 in loop in k3337 in k3327 in create-directory in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_3351(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,3)))){
C_save_and_reclaim((void *)f_3351,2,av);}
a=C_alloc(4);
t2=((C_word*)t0)[2];
t3=((C_word*)t0)[3];
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3367,a[2]=t2,a[3]=t3,tmp=(C_word)a,a+=4,tmp);
/* posix-common.scm:450: ##sys#make-c-string */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[11]+1));
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[11]+1);
av2[1]=t4;
av2[2]=t3;
av2[3]=lf[79];
tp(4,av2);}}

/* nop in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_4474(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_4474,3,av);}
t3=t1;{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=t3;
av2[1]=t2;
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* k3821 in k3814 in k3715 in k3706 in loop in k3691 in k3684 in k3681 in k3872 in k3869 in k3866 in k3863 in k3860 in k3857 in find-files in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in ... */
static void C_ccall f_3823(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,4)))){
C_save_and_reclaim((void *)f_3823,2,av);}
/* posix-common.scm:549: loop */
t2=((C_word*)((C_word*)t0)[2])[1];
f_3695(t2,((C_word*)t0)[3],((C_word*)t0)[4],((C_word*)t0)[5],t1);}

/* lp in k5066 in k4842 in k4834 in k4831 in k4828 in file-select in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_fcall f_5007(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(7,0,2)))){
C_save_and_reclaim_args((void *)trf_5007,5,t0,t1,t2,t3,t4);}
a=C_alloc(7);
if(C_truep(C_i_nullp(t4))){
/* posixunix.scm:565: ##sys#fast-reverse */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[198]+1));
C_word av2[3];
av2[0]=*((C_word*)lf[198]+1);
av2[1]=t1;
av2[2]=t3;
tp(3,av2);}}
else{
t5=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_5036,a[2]=t2,a[3]=t4,a[4]=t3,a[5]=((C_word*)t0)[2],a[6]=t1,tmp=(C_word)a,a+=7,tmp);
t6=t2;
t7=C_i_foreign_fixnum_argumentp(t6);
if(C_truep(((C_word*)t0)[3])){
t8=C_i_foreign_block_argumentp(((C_word*)t0)[3]);
t9=t5;
f_5036(t9,stub995(C_SCHEME_UNDEFINED,t7,t8));}
else{
t8=t5;
f_5036(t8,stub995(C_SCHEME_UNDEFINED,t7,C_SCHEME_FALSE));}}}

/* a4279 in process-wait in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_4280(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4=av[4];
C_word t5;
C_word t6;
C_word *a;
if(c!=5) C_bad_argc_2(c,5,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,5)))){
C_save_and_reclaim((void *)f_4280,5,av);}
t5=C_eqp(t2,C_fix(-1));
if(C_truep(t5)){
/* posix-common.scm:681: posix-error */
t6=lf[0];{
C_word *av2;
if(c >= 6) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(6);
}
av2[0]=t6;
av2[1]=t1;
av2[2]=lf[127];
av2[3]=lf[125];
av2[4]=lf[128];
av2[5]=((C_word*)t0)[2];
f_2704(6,av2);}}
else{
/* posix-common.scm:682: values */{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=0;
av2[1]=t1;
av2[2]=t2;
av2[3]=t3;
av2[4]=t4;
C_values(5,av2);}}}

/* a3898 in find-files in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_3899(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(C_unlikely(!C_demand(C_calculate_demand(3,c,2)))){
C_save_and_reclaim((void *)f_3899,2,av);}
a=C_alloc(3);
t2=t1;{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=t2;
av2[1]=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3901,a[2]=((C_word)li53),tmp=(C_word)a,a+=3,tmp);
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* k3346 in loop in k3337 in k3327 in create-directory in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_fcall f_3348(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(8,0,2)))){
C_save_and_reclaim_args((void *)trf_3348,2,t0,t1);}
a=C_alloc(8);
if(C_truep(t1)){
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3351,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3374,a[2]=((C_word*)t0)[4],a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* posix-common.scm:462: pathname-directory */
t4=*((C_word*)lf[81]+1);{
C_word av2[3];
av2[0]=t4;
av2[1]=t3;
av2[2]=((C_word*)t0)[3];
((C_proc)(void*)(*((C_word*)t4+1)))(3,av2);}}
else{
t2=C_SCHEME_UNDEFINED;
t3=((C_word*)t0)[2];{
C_word av2[2];
av2[0]=t3;
av2[1]=t2;
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}}

/* loop in k3337 in k3327 in create-directory in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_fcall f_3341(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(8,0,2)))){
C_save_and_reclaim_args((void *)trf_3341,3,t0,t1,t2);}
a=C_alloc(8);
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3348,a[2]=t1,a[3]=t2,a[4]=((C_word*)t0)[2],tmp=(C_word)a,a+=5,tmp);
if(C_truep(t2)){
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3381,a[2]=t3,tmp=(C_word)a,a+=3,tmp);
/* posix-common.scm:461: directory? */
t5=*((C_word*)lf[37]+1);{
C_word av2[3];
av2[0]=t5;
av2[1]=t4;
av2[2]=t2;
((C_proc)(void*)(*((C_word*)t5+1)))(3,av2);}}
else{
t4=t3;
f_3348(t4,C_SCHEME_FALSE);}}

/* k4478 in call-with-exec-args in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_4480(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(11,c,4)))){
C_save_and_reclaim((void *)f_4480,2,av);}
a=C_alloc(11);
t2=C_a_i_cons(&a,2,t1,((C_word*)t0)[2]);
t3=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_4486,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[6],a[6]=((C_word*)t0)[7],a[7]=((C_word*)t0)[8],tmp=(C_word)a,a+=8,tmp);
/* posix-common.scm:731: list->c-string-buffer */
f_4321(t3,t2,((C_word*)t0)[9],((C_word*)t0)[6]);}

/* f_3893 in a3890 in k3857 in find-files in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_3893(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(3,c,1)))){
C_save_and_reclaim((void *)f_3893,4,av);}
a=C_alloc(3);
t4=t1;{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=t4;
av2[1]=C_a_i_cons(&a,2,t2,t3);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* a3890 in k3857 in find-files in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_3891(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(C_unlikely(!C_demand(C_calculate_demand(3,c,4)))){
C_save_and_reclaim((void *)f_3891,2,av);}
a=C_alloc(3);
t2=t1;{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=t2;
av2[1]=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3893,a[2]=((C_word)li51),tmp=(C_word)a,a+=3,tmp);
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* f_3849 in k3872 in k3869 in k3866 in k3863 in k3860 in k3857 in find-files in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_3849(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_3849,2,av);}
t2=t1;{
C_word *av2=av; /* Re-use our own argvector */
av2[0]=t2;
av2[1]=C_fixnum_lessp(((C_word*)((C_word*)t0)[2])[1],((C_word*)t0)[3]);
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* call-with-exec-args in k4240 in k3904 in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_fcall f_4476(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6,C_word t7){
C_word tmp;
C_word t8;
C_word t9;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(10,0,2)))){
C_save_and_reclaim_args((void *)trf_4476,8,t0,t1,t2,t3,t4,t5,t6,t7);}
a=C_alloc(10);
t8=(*a=C_CLOSURE_TYPE|9,a[1]=(C_word)f_4480,a[2]=t5,a[3]=t1,a[4]=t7,a[5]=t3,a[6]=t2,a[7]=t6,a[8]=((C_word*)t0)[2],a[9]=t4,tmp=(C_word)a,a+=10,tmp);
/* posix-common.scm:729: pathname-strip-directory */
t9=((C_word*)t0)[3];{
C_word av2[3];
av2[0]=t9;
av2[1]=t8;
av2[2]=t3;
((C_proc)(void*)(*((C_word*)t9+1)))(3,av2);}}

/* k3337 in k3327 in create-directory in k3031 in k2790 in k2690 in k2687 in k2684 in k2681 in k2678 in k2675 */
static void C_ccall f_3339(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(6,c,3)))){
C_save_and_reclaim((void *)f_3339,2,av);}
a=C_alloc(6);
t2=C_SCHEME_UNDEFINED;
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=C_set_block_item(t3,0,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3341,a[2]=t3,a[3]=((C_word)li28),tmp=(C_word)a,a+=4,tmp));
t5=((C_word*)t3)[1];
f_3341(t5,((C_word*)t0)[2],t1);}

#ifdef C_ENABLE_PTABLES
static C_PTABLE_ENTRY ptable[621] = {
{"f_4494:posixunix_2escm",(void*)f_4494},
{"f_3841:posixunix_2escm",(void*)f_3841},
{"f_4489:posixunix_2escm",(void*)f_4489},
{"f_4486:posixunix_2escm",(void*)f_4486},
{"f_8725:posixunix_2escm",(void*)f_8725},
{"f_6498:posixunix_2escm",(void*)f_6498},
{"f_5418:posixunix_2escm",(void*)f_5418},
{"f_5413:posixunix_2escm",(void*)f_5413},
{"f_3832:posixunix_2escm",(void*)f_3832},
{"f_3833:posixunix_2escm",(void*)f_3833},
{"f_6495:posixunix_2escm",(void*)f_6495},
{"f_4274:posixunix_2escm",(void*)f_4274},
{"f_3868:posixunix_2escm",(void*)f_3868},
{"f_3313:posixunix_2escm",(void*)f_3313},
{"f_6621:posixunix_2escm",(void*)f_6621},
{"f_5771:posixunix_2escm",(void*)f_5771},
{"f_6623:posixunix_2escm",(void*)f_6623},
{"f_3865:posixunix_2escm",(void*)f_3865},
{"f_3862:posixunix_2escm",(void*)f_3862},
{"f_7744:posixunix_2escm",(void*)f_7744},
{"f_7024:posixunix_2escm",(void*)f_7024},
{"f_6671:posixunix_2escm",(void*)f_6671},
{"f_5767:posixunix_2escm",(void*)f_5767},
{"f_3888:posixunix_2escm",(void*)f_3888},
{"f_7756:posixunix_2escm",(void*)f_7756},
{"f_5791:posixunix_2escm",(void*)f_5791},
{"f_8734:posixunix_2escm",(void*)f_8734},
{"f_5428:posixunix_2escm",(void*)f_5428},
{"f_5424:posixunix_2escm",(void*)f_5424},
{"f_3885:posixunix_2escm",(void*)f_3885},
{"f_3882:posixunix_2escm",(void*)f_3882},
{"f_3879:posixunix_2escm",(void*)f_3879},
{"f_3367:posixunix_2escm",(void*)f_3367},
{"f_8618:posixunix_2escm",(void*)f_8618},
{"f_7004:posixunix_2escm",(void*)f_7004},
{"f_8615:posixunix_2escm",(void*)f_8615},
{"f_5784:posixunix_2escm",(void*)f_5784},
{"f_6613:posixunix_2escm",(void*)f_6613},
{"f_3874:posixunix_2escm",(void*)f_3874},
{"f_3871:posixunix_2escm",(void*)f_3871},
{"f_7738:posixunix_2escm",(void*)f_7738},
{"f_5737:posixunix_2escm",(void*)f_5737},
{"f_4209:posixunix_2escm",(void*)f_4209},
{"f_8609:posixunix_2escm",(void*)f_8609},
{"f_4908:posixunix_2escm",(void*)f_4908},
{"f_5487:posixunix_2escm",(void*)f_5487},
{"f_5481:posixunix_2escm",(void*)f_5481},
{"f_5081:posixunix_2escm",(void*)f_5081},
{"f_4205:posixunix_2escm",(void*)f_4205},
{"f_8637:posixunix_2escm",(void*)f_8637},
{"f_8634:posixunix_2escm",(void*)f_8634},
{"f_5723:posixunix_2escm",(void*)f_5723},
{"f_5727:posixunix_2escm",(void*)f_5727},
{"f_4918:posixunix_2escm",(void*)f_4918},
{"f_4911:posixunix_2escm",(void*)f_4911},
{"f_5079:posixunix_2escm",(void*)f_5079},
{"f_8628:posixunix_2escm",(void*)f_8628},
{"f_5753:posixunix_2escm",(void*)f_5753},
{"f_6602:posixunix_2escm",(void*)f_6602},
{"f_5757:posixunix_2escm",(void*)f_5757},
{"f_4227:posixunix_2escm",(void*)f_4227},
{"f_5759:posixunix_2escm",(void*)f_5759},
{"f_5068:posixunix_2escm",(void*)f_5068},
{"f_3329:posixunix_2escm",(void*)f_3329},
{"f_3323:posixunix_2escm",(void*)f_3323},
{"f_5745:posixunix_2escm",(void*)f_5745},
{"f_7205:posixunix_2escm",(void*)f_7205},
{"f_6067:posixunix_2escm",(void*)f_6067},
{"f_6429:posixunix_2escm",(void*)f_6429},
{"f_4434:posixunix_2escm",(void*)f_4434},
{"f_3859:posixunix_2escm",(void*)f_3859},
{"f_6437:posixunix_2escm",(void*)f_6437},
{"f_4440:posixunix_2escm",(void*)f_4440},
{"f_7266:posixunix_2escm",(void*)f_7266},
{"f_4444:posixunix_2escm",(void*)f_4444},
{"f_3855:posixunix_2escm",(void*)f_3855},
{"f_5036:posixunix_2escm",(void*)f_5036},
{"f_3901:posixunix_2escm",(void*)f_3901},
{"f_3906:posixunix_2escm",(void*)f_3906},
{"f_4449:posixunix_2escm",(void*)f_4449},
{"f_3908:posixunix_2escm",(void*)f_3908},
{"f_7248:posixunix_2escm",(void*)f_7248},
{"f_6026:posixunix_2escm",(void*)f_6026},
{"f_3281:posixunix_2escm",(void*)f_3281},
{"f_7298:posixunix_2escm",(void*)f_7298},
{"f_3276:posixunix_2escm",(void*)f_3276},
{"f_3273:posixunix_2escm",(void*)f_3273},
{"f_7270:posixunix_2escm",(void*)f_7270},
{"f_4977:posixunix_2escm",(void*)f_4977},
{"f_3291:posixunix_2escm",(void*)f_3291},
{"f_4423:posixunix_2escm",(void*)f_4423},
{"f_7282:posixunix_2escm",(void*)f_7282},
{"f_7286:posixunix_2escm",(void*)f_7286},
{"f_4417:posixunix_2escm",(void*)f_4417},
{"f_4948:posixunix_2escm",(void*)f_4948},
{"f_3927:posixunix_2escm",(void*)f_3927},
{"f_3952:posixunix_2escm",(void*)f_3952},
{"f_3983:posixunix_2escm",(void*)f_3983},
{"f_6443:posixunix_2escm",(void*)f_6443},
{"f_3989:posixunix_2escm",(void*)f_3989},
{"f_3931:posixunix_2escm",(void*)f_3931},
{"f_4462:posixunix_2escm",(void*)f_4462},
{"f_4459:posixunix_2escm",(void*)f_4459},
{"f_6917:posixunix_2escm",(void*)f_6917},
{"f_6911:posixunix_2escm",(void*)f_6911},
{"f_6910:posixunix_2escm",(void*)f_6910},
{"f_3209:posixunix_2escm",(void*)f_3209},
{"f_3206:posixunix_2escm",(void*)f_3206},
{"f_6465:posixunix_2escm",(void*)f_6465},
{"f_7836:posixunix_2escm",(void*)f_7836},
{"f_6462:posixunix_2escm",(void*)f_6462},
{"f_7840:posixunix_2escm",(void*)f_7840},
{"f_3227:posixunix_2escm",(void*)f_3227},
{"f_7815:posixunix_2escm",(void*)f_7815},
{"f_6400:posixunix_2escm",(void*)f_6400},
{"f_7811:posixunix_2escm",(void*)f_7811},
{"f_6404:posixunix_2escm",(void*)f_6404},
{"f_7848:posixunix_2escm",(void*)f_7848},
{"f_4407:posixunix_2escm",(void*)f_4407},
{"f_3979:posixunix_2escm",(void*)f_3979},
{"f_8153:posixunix_2escm",(void*)f_8153},
{"f_8159:posixunix_2escm",(void*)f_8159},
{"f_8157:posixunix_2escm",(void*)f_8157},
{"f_6967:posixunix_2escm",(void*)f_6967},
{"f_6936:posixunix_2escm",(void*)f_6936},
{"f_7893:posixunix_2escm",(void*)f_7893},
{"f_8174:posixunix_2escm",(void*)f_8174},
{"f_6693:posixunix_2escm",(void*)f_6693},
{"f_6994:posixunix_2escm",(void*)f_6994},
{"f_4116:posixunix_2escm",(void*)f_4116},
{"f_8110:posixunix_2escm",(void*)f_8110},
{"f_7787:posixunix_2escm",(void*)f_7787},
{"toplevel:posixunix_2escm",(void*)C_posix_toplevel},
{"f_7484:posixunix_2escm",(void*)f_7484},
{"f_8103:posixunix_2escm",(void*)f_8103},
{"f_8107:posixunix_2escm",(void*)f_8107},
{"f_6977:posixunix_2escm",(void*)f_6977},
{"f_6689:posixunix_2escm",(void*)f_6689},
{"f_7497:posixunix_2escm",(void*)f_7497},
{"f_3948:posixunix_2escm",(void*)f_3948},
{"f_6982:posixunix_2escm",(void*)f_6982},
{"f_6988:posixunix_2escm",(void*)f_6988},
{"f_6986:posixunix_2escm",(void*)f_6986},
{"f_6114:posixunix_2escm",(void*)f_6114},
{"f_6116:posixunix_2escm",(void*)f_6116},
{"f_4197:posixunix_2escm",(void*)f_4197},
{"f_8194:posixunix_2escm",(void*)f_8194},
{"f_5289:posixunix_2escm",(void*)f_5289},
{"f_5275:posixunix_2escm",(void*)f_5275},
{"f_5273:posixunix_2escm",(void*)f_5273},
{"f_6126:posixunix_2escm",(void*)f_6126},
{"f_4161:posixunix_2escm",(void*)f_4161},
{"f_8180:posixunix_2escm",(void*)f_8180},
{"f_4167:posixunix_2escm",(void*)f_4167},
{"f_4171:posixunix_2escm",(void*)f_4171},
{"f_4179:posixunix_2escm",(void*)f_4179},
{"f_4141:posixunix_2escm",(void*)f_4141},
{"f_4149:posixunix_2escm",(void*)f_4149},
{"f_6154:posixunix_2escm",(void*)f_6154},
{"f_6158:posixunix_2escm",(void*)f_6158},
{"f_5442:posixunix_2escm",(void*)f_5442},
{"f_5447:posixunix_2escm",(void*)f_5447},
{"f_6164:posixunix_2escm",(void*)f_6164},
{"f_4124:posixunix_2escm",(void*)f_4124},
{"f_7907:posixunix_2escm",(void*)f_7907},
{"f_8365:posixunix_2escm",(void*)f_8365},
{"f_7911:posixunix_2escm",(void*)f_7911},
{"f_6136:posixunix_2escm",(void*)f_6136},
{"f_8361:posixunix_2escm",(void*)f_8361},
{"f_6134:posixunix_2escm",(void*)f_6134},
{"f_3088:posixunix_2escm",(void*)f_3088},
{"f_4135:posixunix_2escm",(void*)f_4135},
{"f_4139:posixunix_2escm",(void*)f_4139},
{"f_7915:posixunix_2escm",(void*)f_7915},
{"f_8353:posixunix_2escm",(void*)f_8353},
{"f_6142:posixunix_2escm",(void*)f_6142},
{"f_6148:posixunix_2escm",(void*)f_6148},
{"f_5453:posixunix_2escm",(void*)f_5453},
{"f_8357:posixunix_2escm",(void*)f_8357},
{"f_5457:posixunix_2escm",(void*)f_5457},
{"f_7056:posixunix_2escm",(void*)f_7056},
{"f_5207:posixunix_2escm",(void*)f_5207},
{"f_8380:posixunix_2escm",(void*)f_8380},
{"f_8385:posixunix_2escm",(void*)f_8385},
{"f_6198:posixunix_2escm",(void*)f_6198},
{"f_7973:posixunix_2escm",(void*)f_7973},
{"f_5400:posixunix_2escm",(void*)f_5400},
{"f_7976:posixunix_2escm",(void*)f_7976},
{"f_6194:posixunix_2escm",(void*)f_6194},
{"f_5409:posixunix_2escm",(void*)f_5409},
{"f_5404:posixunix_2escm",(void*)f_5404},
{"f_7066:posixunix_2escm",(void*)f_7066},
{"f_5433:posixunix_2escm",(void*)f_5433},
{"f_8378:posixunix_2escm",(void*)f_8378},
{"f_5437:posixunix_2escm",(void*)f_5437},
{"f_4250:posixunix_2escm",(void*)f_4250},
{"f_7038:posixunix_2escm",(void*)f_7038},
{"f_7039:posixunix_2escm",(void*)f_7039},
{"f_6173:posixunix_2escm",(void*)f_6173},
{"f_6171:posixunix_2escm",(void*)f_6171},
{"f_5462:posixunix_2escm",(void*)f_5462},
{"f_7955:posixunix_2escm",(void*)f_7955},
{"f_5467:posixunix_2escm",(void*)f_5467},
{"f_8133:posixunix_2escm",(void*)f_8133},
{"f_8015:posixunix_2escm",(void*)f_8015},
{"f_8394:posixunix_2escm",(void*)f_8394},
{"f_8129:posixunix_2escm",(void*)f_8129},
{"f_7016:posixunix_2escm",(void*)f_7016},
{"f_3487:posixunix_2escm",(void*)f_3487},
{"f_4242:posixunix_2escm",(void*)f_4242},
{"f_4244:posixunix_2escm",(void*)f_4244},
{"f_3473:posixunix_2escm",(void*)f_3473},
{"f_7852:posixunix_2escm",(void*)f_7852},
{"f_7855:posixunix_2escm",(void*)f_7855},
{"f_5296:posixunix_2escm",(void*)f_5296},
{"f_8053:posixunix_2escm",(void*)f_8053},
{"f_8056:posixunix_2escm",(void*)f_8056},
{"f_3499:posixunix_2escm",(void*)f_3499},
{"f_7862:posixunix_2escm",(void*)f_7862},
{"f_8300:posixunix_2escm",(void*)f_8300},
{"f_8304:posixunix_2escm",(void*)f_8304},
{"f_8322:posixunix_2escm",(void*)f_8322},
{"f_8328:posixunix_2escm",(void*)f_8328},
{"f_7472:posixunix_2escm",(void*)f_7472},
{"f_8092:posixunix_2escm",(void*)f_8092},
{"f_7468:posixunix_2escm",(void*)f_7468},
{"f_8311:posixunix_2escm",(void*)f_8311},
{"f_8315:posixunix_2escm",(void*)f_8315},
{"f_3233:posixunix_2escm",(void*)f_3233},
{"f_7478:posixunix_2escm",(void*)f_7478},
{"f_7475:posixunix_2escm",(void*)f_7475},
{"f_8097:posixunix_2escm",(void*)f_8097},
{"f_8345:posixunix_2escm",(void*)f_8345},
{"f_8349:posixunix_2escm",(void*)f_8349},
{"f_5389:posixunix_2escm",(void*)f_5389},
{"f_5385:posixunix_2escm",(void*)f_5385},
{"f_8334:posixunix_2escm",(void*)f_8334},
{"f_3237:posixunix_2escm",(void*)f_3237},
{"f_5377:posixunix_2escm",(void*)f_5377},
{"f_5370:posixunix_2escm",(void*)f_5370},
{"f_3267:posixunix_2escm",(void*)f_3267},
{"f_3412:posixunix_2escm",(void*)f_3412},
{"f_3257:posixunix_2escm",(void*)f_3257},
{"f_3256:posixunix_2escm",(void*)f_3256},
{"f_4382:posixunix_2escm",(void*)f_4382},
{"f_6399:posixunix_2escm",(void*)f_6399},
{"f_6393:posixunix_2escm",(void*)f_6393},
{"f_4388:posixunix_2escm",(void*)f_4388},
{"f_8088:posixunix_2escm",(void*)f_8088},
{"f_8802:posixunix_2escm",(void*)f_8802},
{"f_8808:posixunix_2escm",(void*)f_8808},
{"f_8806:posixunix_2escm",(void*)f_8806},
{"f_4391:posixunix_2escm",(void*)f_4391},
{"f_3038:posixunix_2escm",(void*)f_3038},
{"f_8828:posixunix_2escm",(void*)f_8828},
{"f_3033:posixunix_2escm",(void*)f_3033},
{"f_8818:posixunix_2escm",(void*)f_8818},
{"f_6737:posixunix_2escm",(void*)f_6737},
{"f_5306:posixunix_2escm",(void*)f_5306},
{"f_3006:posixunix_2escm",(void*)f_3006},
{"f_6717:posixunix_2escm",(void*)f_6717},
{"f_3000:posixunix_2escm",(void*)f_3000},
{"f_3075:posixunix_2escm",(void*)f_3075},
{"f_5329:posixunix_2escm",(void*)f_5329},
{"f_5394:posixunix_2escm",(void*)f_5394},
{"f_6702:posixunix_2escm",(void*)f_6702},
{"f_6707:posixunix_2escm",(void*)f_6707},
{"f_3090:posixunix_2escm",(void*)f_3090},
{"f_5123:posixunix_2escm",(void*)f_5123},
{"f_3046:posixunix_2escm",(void*)f_3046},
{"f_8031:posixunix_2escm",(void*)f_8031},
{"f_6324:posixunix_2escm",(void*)f_6324},
{"f_6328:posixunix_2escm",(void*)f_6328},
{"f_8063:posixunix_2escm",(void*)f_8063},
{"f_8067:posixunix_2escm",(void*)f_8067},
{"f_3596:posixunix_2escm",(void*)f_3596},
{"f_3590:posixunix_2escm",(void*)f_3590},
{"f_4673:posixunix_2escm",(void*)f_4673},
{"f_4670:posixunix_2escm",(void*)f_4670},
{"f_4685:posixunix_2escm",(void*)f_4685},
{"f_3575:posixunix_2escm",(void*)f_3575},
{"f_4694:posixunix_2escm",(void*)f_4694},
{"f_4620:posixunix_2escm",(void*)f_4620},
{"f_2911:posixunix_2escm",(void*)f_2911},
{"f_2919:posixunix_2escm",(void*)f_2919},
{"f_4657:posixunix_2escm",(void*)f_4657},
{"f_4653:posixunix_2escm",(void*)f_4653},
{"f_6363:posixunix_2escm",(void*)f_6363},
{"f_6365:posixunix_2escm",(void*)f_6365},
{"f_5260:posixunix_2escm",(void*)f_5260},
{"f_3509:posixunix_2escm",(void*)f_3509},
{"f_6343:posixunix_2escm",(void*)f_6343},
{"f_5233:posixunix_2escm",(void*)f_5233},
{"f_2921:posixunix_2escm",(void*)f_2921},
{"f_2929:posixunix_2escm",(void*)f_2929},
{"f_5226:posixunix_2escm",(void*)f_5226},
{"f_5217:posixunix_2escm",(void*)f_5217},
{"f_5214:posixunix_2escm",(void*)f_5214},
{"f_2941:posixunix_2escm",(void*)f_2941},
{"f_2949:posixunix_2escm",(void*)f_2949},
{"f_3449:posixunix_2escm",(void*)f_3449},
{"f_2931:posixunix_2escm",(void*)f_2931},
{"f_2939:posixunix_2escm",(void*)f_2939},
{"f_8259:posixunix_2escm",(void*)f_8259},
{"f_3434:posixunix_2escm",(void*)f_3434},
{"f_2961:posixunix_2escm",(void*)f_2961},
{"f_8255:posixunix_2escm",(void*)f_8255},
{"f_3430:posixunix_2escm",(void*)f_3430},
{"f_2969:posixunix_2escm",(void*)f_2969},
{"f_7791:posixunix_2escm",(void*)f_7791},
{"f_8241:posixunix_2escm",(void*)f_8241},
{"f_8278:posixunix_2escm",(void*)f_8278},
{"f_3455:posixunix_2escm",(void*)f_3455},
{"f_3459:posixunix_2escm",(void*)f_3459},
{"f_6763:posixunix_2escm",(void*)f_6763},
{"f_3452:posixunix_2escm",(void*)f_3452},
{"f_2988:posixunix_2escm",(void*)f_2988},
{"f_8276:posixunix_2escm",(void*)f_8276},
{"f_2984:posixunix_2escm",(void*)f_2984},
{"f_2971:posixunix_2escm",(void*)f_2971},
{"f_2979:posixunix_2escm",(void*)f_2979},
{"f_8265:posixunix_2escm",(void*)f_8265},
{"f_8262:posixunix_2escm",(void*)f_8262},
{"f_8214:posixunix_2escm",(void*)f_8214},
{"f_8209:posixunix_2escm",(void*)f_8209},
{"f_8203:posixunix_2escm",(void*)f_8203},
{"f_8575:posixunix_2escm",(void*)f_8575},
{"f_5818:posixunix_2escm",(void*)f_5818},
{"f_5814:posixunix_2escm",(void*)f_5814},
{"f_5812:posixunix_2escm",(void*)f_5812},
{"f_8593:posixunix_2escm",(void*)f_8593},
{"f_4017:posixunix_2escm",(void*)f_4017},
{"f_5808:posixunix_2escm",(void*)f_5808},
{"f_5804:posixunix_2escm",(void*)f_5804},
{"f_4021:posixunix_2escm",(void*)f_4021},
{"f_4025:posixunix_2escm",(void*)f_4025},
{"f_2951:posixunix_2escm",(void*)f_2951},
{"f_2959:posixunix_2escm",(void*)f_2959},
{"f_4031:posixunix_2escm",(void*)f_4031},
{"f_8569:posixunix_2escm",(void*)f_8569},
{"f_5355:posixunix_2escm",(void*)f_5355},
{"f_6504:posixunix_2escm",(void*)f_6504},
{"f_8552:posixunix_2escm",(void*)f_8552},
{"f_3193:posixunix_2escm",(void*)f_3193},
{"f_8588:posixunix_2escm",(void*)f_8588},
{"f_4062:posixunix_2escm",(void*)f_4062},
{"f_8288:posixunix_2escm",(void*)f_8288},
{"f_8582:posixunix_2escm",(void*)f_8582},
{"f_2806:posixunix_2escm",(void*)f_2806},
{"f_2804:posixunix_2escm",(void*)f_2804},
{"f_2800:posixunix_2escm",(void*)f_2800},
{"f_8285:posixunix_2escm",(void*)f_8285},
{"f_8282:posixunix_2escm",(void*)f_8282},
{"f_4069:posixunix_2escm",(void*)f_4069},
{"f_5894:posixunix_2escm",(void*)f_5894},
{"f_4078:posixunix_2escm",(void*)f_4078},
{"f_6539:posixunix_2escm",(void*)f_6539},
{"f_6537:posixunix_2escm",(void*)f_6537},
{"f_6533:posixunix_2escm",(void*)f_6533},
{"f_5315:posixunix_2escm",(void*)f_5315},
{"f_4092:posixunix_2escm",(void*)f_4092},
{"f_4095:posixunix_2escm",(void*)f_4095},
{"f_4088:posixunix_2escm",(void*)f_4088},
{"f_6543:posixunix_2escm",(void*)f_6543},
{"f_5346:posixunix_2escm",(void*)f_5346},
{"f_5874:posixunix_2escm",(void*)f_5874},
{"f_5871:posixunix_2escm",(void*)f_5871},
{"f_5879:posixunix_2escm",(void*)f_5879},
{"f_5336:posixunix_2escm",(void*)f_5336},
{"f_4360:posixunix_2escm",(void*)f_4360},
{"f_4364:posixunix_2escm",(void*)f_4364},
{"f_5864:posixunix_2escm",(void*)f_5864},
{"f_4366:posixunix_2escm",(void*)f_4366},
{"f_5868:posixunix_2escm",(void*)f_5868},
{"f_5362:posixunix_2escm",(void*)f_5362},
{"f_6576:posixunix_2escm",(void*)f_6576},
{"f_7173:posixunix_2escm",(void*)f_7173},
{"f_4343:posixunix_2escm",(void*)f_4343},
{"f_5842:posixunix_2escm",(void*)f_5842},
{"f_4349:posixunix_2escm",(void*)f_4349},
{"f_6586:posixunix_2escm",(void*)f_6586},
{"f_2816:posixunix_2escm",(void*)f_2816},
{"f_2818:posixunix_2escm",(void*)f_2818},
{"f_2812:posixunix_2escm",(void*)f_2812},
{"f_4513:posixunix_2escm",(void*)f_4513},
{"f_2810:posixunix_2escm",(void*)f_2810},
{"f_4510:posixunix_2escm",(void*)f_4510},
{"f_7149:posixunix_2escm",(void*)f_7149},
{"f_4353:posixunix_2escm",(void*)f_4353},
{"f_4358:posixunix_2escm",(void*)f_4358},
{"f_4521:posixunix_2escm",(void*)f_4521},
{"f_4527:posixunix_2escm",(void*)f_4527},
{"f_7159:posixunix_2escm",(void*)f_7159},
{"f_4321:posixunix_2escm",(void*)f_4321},
{"f_5828:posixunix_2escm",(void*)f_5828},
{"f_4329:posixunix_2escm",(void*)f_4329},
{"f_6564:posixunix_2escm",(void*)f_6564},
{"f_8237:posixunix_2escm",(void*)f_8237},
{"f_4332:posixunix_2escm",(void*)f_4332},
{"f_4337:posixunix_2escm",(void*)f_4337},
{"f_2822:posixunix_2escm",(void*)f_2822},
{"f_2824:posixunix_2escm",(void*)f_2824},
{"f_8225:posixunix_2escm",(void*)f_8225},
{"f_8226:posixunix_2escm",(void*)f_8226},
{"f_7184:posixunix_2escm",(void*)f_7184},
{"f_6598:posixunix_2escm",(void*)f_6598},
{"f_7166:posixunix_2escm",(void*)f_7166},
{"f_3569:posixunix_2escm",(void*)f_3569},
{"f_3600:posixunix_2escm",(void*)f_3600},
{"f_4807:posixunix_2escm",(void*)f_4807},
{"f_4801:posixunix_2escm",(void*)f_4801},
{"f_3609:posixunix_2escm",(void*)f_3609},
{"f_3607:posixunix_2escm",(void*)f_3607},
{"f_4814:posixunix_2escm",(void*)f_4814},
{"f_3650:posixunix_2escm",(void*)f_3650},
{"f_4836:posixunix_2escm",(void*)f_4836},
{"f_3642:posixunix_2escm",(void*)f_3642},
{"f_8544:posixunix_2escm",(void*)f_8544},
{"f_4844:posixunix_2escm",(void*)f_4844},
{"f_2843:posixunix_2escm",(void*)f_2843},
{"f_3670:posixunix_2escm",(void*)f_3670},
{"f_3104:posixunix_2escm",(void*)f_3104},
{"f_3102:posixunix_2escm",(void*)f_3102},
{"f_3134:posixunix_2escm",(void*)f_3134},
{"f_5904:posixunix_2escm",(void*)f_5904},
{"f_3695:posixunix_2escm",(void*)f_3695},
{"f_3693:posixunix_2escm",(void*)f_3693},
{"f_7535:posixunix_2escm",(void*)f_7535},
{"f_3166:posixunix_2escm",(void*)f_3166},
{"f_6822:posixunix_2escm",(void*)f_6822},
{"f_3160:posixunix_2escm",(void*)f_3160},
{"f_3686:posixunix_2escm",(void*)f_3686},
{"f_3683:posixunix_2escm",(void*)f_3683},
{"f_3116:posixunix_2escm",(void*)f_3116},
{"f_3118:posixunix_2escm",(void*)f_3118},
{"f_2715:posixunix_2escm",(void*)f_2715},
{"f_3143:posixunix_2escm",(void*)f_3143},
{"f_2719:posixunix_2escm",(void*)f_2719},
{"f_2708:posixunix_2escm",(void*)f_2708},
{"f_2704:posixunix_2escm",(void*)f_2704},
{"f_3173:posixunix_2escm",(void*)f_3173},
{"f_3176:posixunix_2escm",(void*)f_3176},
{"f_7528:posixunix_2escm",(void*)f_7528},
{"f_3717:posixunix_2escm",(void*)f_3717},
{"f_7570:posixunix_2escm",(void*)f_7570},
{"f_5932:posixunix_2escm",(void*)f_5932},
{"f_5937:posixunix_2escm",(void*)f_5937},
{"f_5599:posixunix_2escm",(void*)f_5599},
{"f_5597:posixunix_2escm",(void*)f_5597},
{"f_3708:posixunix_2escm",(void*)f_3708},
{"f_7585:posixunix_2escm",(void*)f_7585},
{"f_2751:posixunix_2escm",(void*)f_2751},
{"f_6088:posixunix_2escm",(void*)f_6088},
{"f_5953:posixunix_2escm",(void*)f_5953},
{"f_2747:posixunix_2escm",(void*)f_2747},
{"f_7561:posixunix_2escm",(void*)f_7561},
{"f_6090:posixunix_2escm",(void*)f_6090},
{"f_6812:posixunix_2escm",(void*)f_6812},
{"f_2772:posixunix_2escm",(void*)f_2772},
{"f_2779:posixunix_2escm",(void*)f_2779},
{"f_2760:posixunix_2escm",(void*)f_2760},
{"f_2767:posixunix_2escm",(void*)f_2767},
{"f_2792:posixunix_2escm",(void*)f_2792},
{"f_2798:posixunix_2escm",(void*)f_2798},
{"f_6203:posixunix_2escm",(void*)f_6203},
{"f_6202:posixunix_2escm",(void*)f_6202},
{"f_7398:posixunix_2escm",(void*)f_7398},
{"f_2794:posixunix_2escm",(void*)f_2794},
{"f_3630:posixunix_2escm",(void*)f_3630},
{"f_6208:posixunix_2escm",(void*)f_6208},
{"f_7390:posixunix_2escm",(void*)f_7390},
{"f_5991:posixunix_2escm",(void*)f_5991},
{"f_5572:posixunix_2escm",(void*)f_5572},
{"f_3626:posixunix_2escm",(void*)f_3626},
{"f_3638:posixunix_2escm",(void*)f_3638},
{"f_4830:posixunix_2escm",(void*)f_4830},
{"f_4833:posixunix_2escm",(void*)f_4833},
{"f_4826:posixunix_2escm",(void*)f_4826},
{"f_7694:posixunix_2escm",(void*)f_7694},
{"f_3798:posixunix_2escm",(void*)f_3798},
{"f_3783:posixunix_2escm",(void*)f_3783},
{"f_3780:posixunix_2escm",(void*)f_3780},
{"f_3788:posixunix_2escm",(void*)f_3788},
{"f_4716:posixunix_2escm",(void*)f_4716},
{"f_3776:posixunix_2escm",(void*)f_3776},
{"f_6003:posixunix_2escm",(void*)f_6003},
{"f_3763:posixunix_2escm",(void*)f_3763},
{"f_8765:posixunix_2escm",(void*)f_8765},
{"f_3761:posixunix_2escm",(void*)f_3761},
{"f_8769:posixunix_2escm",(void*)f_8769},
{"f_3768:posixunix_2escm",(void*)f_3768},
{"f_6019:posixunix_2escm",(void*)f_6019},
{"f_3751:posixunix_2escm",(void*)f_3751},
{"f_6263:posixunix_2escm",(void*)f_6263},
{"f_8759:posixunix_2escm",(void*)f_8759},
{"f_6269:posixunix_2escm",(void*)f_6269},
{"f_5605:posixunix_2escm",(void*)f_5605},
{"f_3742:posixunix_2escm",(void*)f_3742},
{"f_6278:posixunix_2escm",(void*)f_6278},
{"f_8781:posixunix_2escm",(void*)f_8781},
{"f_5923:posixunix_2escm",(void*)f_5923},
{"f_5928:posixunix_2escm",(void*)f_5928},
{"f_3739:posixunix_2escm",(void*)f_3739},
{"f_6281:posixunix_2escm",(void*)f_6281},
{"f_6284:posixunix_2escm",(void*)f_6284},
{"f_8447:posixunix_2escm",(void*)f_8447},
{"f_8449:posixunix_2escm",(void*)f_8449},
{"f_8772:posixunix_2escm",(void*)f_8772},
{"f_6290:posixunix_2escm",(void*)f_6290},
{"f_6222:posixunix_2escm",(void*)f_6222},
{"f_8467:posixunix_2escm",(void*)f_8467},
{"f_2722:posixunix_2escm",(void*)f_2722},
{"f_3389:posixunix_2escm",(void*)f_3389},
{"f_2726:posixunix_2escm",(void*)f_2726},
{"f_6237:posixunix_2escm",(void*)f_6237},
{"f_3381:posixunix_2escm",(void*)f_3381},
{"f_3383:posixunix_2escm",(void*)f_3383},
{"f_8497:posixunix_2escm",(void*)f_8497},
{"f_7606:posixunix_2escm",(void*)f_7606},
{"f_4794:posixunix_2escm",(void*)f_4794},
{"f_6243:posixunix_2escm",(void*)f_6243},
{"f_5548:posixunix_2escm",(void*)f_5548},
{"f_7602:posixunix_2escm",(void*)f_7602},
{"f_3374:posixunix_2escm",(void*)f_3374},
{"f_4767:posixunix_2escm",(void*)f_4767},
{"f_4764:posixunix_2escm",(void*)f_4764},
{"f_7325:posixunix_2escm",(void*)f_7325},
{"f_8697:posixunix_2escm",(void*)f_8697},
{"f_6253:posixunix_2escm",(void*)f_6253},
{"f_6251:posixunix_2escm",(void*)f_6251},
{"f_8691:posixunix_2escm",(void*)f_8691},
{"f_4773:posixunix_2escm",(void*)f_4773},
{"f_8685:posixunix_2escm",(void*)f_8685},
{"f_4542:posixunix_2escm",(void*)f_4542},
{"f_4544:posixunix_2escm",(void*)f_4544},
{"f_5685:posixunix_2escm",(void*)f_5685},
{"f_5681:posixunix_2escm",(void*)f_5681},
{"f_5689:posixunix_2escm",(void*)f_5689},
{"f_7636:posixunix_2escm",(void*)f_7636},
{"f_7630:posixunix_2escm",(void*)f_7630},
{"f_5670:posixunix_2escm",(void*)f_5670},
{"f_5677:posixunix_2escm",(void*)f_5677},
{"f_4757:posixunix_2escm",(void*)f_4757},
{"f_7641:posixunix_2escm",(void*)f_7641},
{"f_5664:posixunix_2escm",(void*)f_5664},
{"f_5660:posixunix_2escm",(void*)f_5660},
{"f_4726:posixunix_2escm",(void*)f_4726},
{"f_4729:posixunix_2escm",(void*)f_4729},
{"f_8656:posixunix_2escm",(void*)f_8656},
{"f_7614:posixunix_2escm",(void*)f_7614},
{"f_8653:posixunix_2escm",(void*)f_8653},
{"f_8647:posixunix_2escm",(void*)f_8647},
{"f_4732:posixunix_2escm",(void*)f_4732},
{"f_7626:posixunix_2escm",(void*)f_7626},
{"f_7622:posixunix_2escm",(void*)f_7622},
{"f_4506:posixunix_2escm",(void*)f_4506},
{"f_5641:posixunix_2escm",(void*)f_5641},
{"f_4500:posixunix_2escm",(void*)f_4500},
{"f_7679:posixunix_2escm",(void*)f_7679},
{"f_5648:posixunix_2escm",(void*)f_5648},
{"f_8675:posixunix_2escm",(void*)f_8675},
{"f_4550:posixunix_2escm",(void*)f_4550},
{"f_7675:posixunix_2escm",(void*)f_7675},
{"f_4556:posixunix_2escm",(void*)f_4556},
{"f_5637:posixunix_2escm",(void*)f_5637},
{"f_8672:posixunix_2escm",(void*)f_8672},
{"f_2680:posixunix_2escm",(void*)f_2680},
{"f_2689:posixunix_2escm",(void*)f_2689},
{"f_2686:posixunix_2escm",(void*)f_2686},
{"f_2683:posixunix_2escm",(void*)f_2683},
{"f_8666:posixunix_2escm",(void*)f_8666},
{"f_7353:posixunix_2escm",(void*)f_7353},
{"f_7682:posixunix_2escm",(void*)f_7682},
{"f_4563:posixunix_2escm",(void*)f_4563},
{"f_7685:posixunix_2escm",(void*)f_7685},
{"f_5621:posixunix_2escm",(void*)f_5621},
{"f_6888:posixunix_2escm",(void*)f_6888},
{"f_2677:posixunix_2escm",(void*)f_2677},
{"f_8421:posixunix_2escm",(void*)f_8421},
{"f_4531:posixunix_2escm",(void*)f_4531},
{"f_8424:posixunix_2escm",(void*)f_8424},
{"f_7654:posixunix_2escm",(void*)f_7654},
{"f_7668:posixunix_2escm",(void*)f_7668},
{"f_4538:posixunix_2escm",(void*)f_4538},
{"f_5691:posixunix_2escm",(void*)f_5691},
{"f_5698:posixunix_2escm",(void*)f_5698},
{"f_8429:posixunix_2escm",(void*)f_8429},
{"f_2692:posixunix_2escm",(void*)f_2692},
{"f_3816:posixunix_2escm",(void*)f_3816},
{"f_8443:posixunix_2escm",(void*)f_8443},
{"f_7302:posixunix_2escm",(void*)f_7302},
{"f_5501:posixunix_2escm",(void*)f_5501},
{"f_5505:posixunix_2escm",(void*)f_5505},
{"f_7360:posixunix_2escm",(void*)f_7360},
{"f_5652:posixunix_2escm",(void*)f_5652},
{"f_5656:posixunix_2escm",(void*)f_5656},
{"f_5496:posixunix_2escm",(void*)f_5496},
{"f_5491:posixunix_2escm",(void*)f_5491},
{"f_7377:posixunix_2escm",(void*)f_7377},
{"f_5476:posixunix_2escm",(void*)f_5476},
{"f_5471:posixunix_2escm",(void*)f_5471},
{"f_3807:posixunix_2escm",(void*)f_3807},
{"f_5719:posixunix_2escm",(void*)f_5719},
{"f_5715:posixunix_2escm",(void*)f_5715},
{"f_5711:posixunix_2escm",(void*)f_5711},
{"f_3801:posixunix_2escm",(void*)f_3801},
{"f_3351:posixunix_2escm",(void*)f_3351},
{"f_4474:posixunix_2escm",(void*)f_4474},
{"f_3823:posixunix_2escm",(void*)f_3823},
{"f_5007:posixunix_2escm",(void*)f_5007},
{"f_4280:posixunix_2escm",(void*)f_4280},
{"f_3899:posixunix_2escm",(void*)f_3899},
{"f_3348:posixunix_2escm",(void*)f_3348},
{"f_3341:posixunix_2escm",(void*)f_3341},
{"f_4480:posixunix_2escm",(void*)f_4480},
{"f_3893:posixunix_2escm",(void*)f_3893},
{"f_3891:posixunix_2escm",(void*)f_3891},
{"f_3849:posixunix_2escm",(void*)f_3849},
{"f_4476:posixunix_2escm",(void*)f_4476},
{"f_3339:posixunix_2escm",(void*)f_3339},
{NULL,NULL}};
#endif

static C_PTABLE_ENTRY *create_ptable(void){
#ifdef C_ENABLE_PTABLES
return ptable;
#else
return NULL;
#endif
}

/*
S|applied compiler syntax:
S|  for-each		3
o|eliminated procedure checks: 278 
o|specializations:
o|  1 (zero? fixnum)
o|  1 (##sys#check-output-port * * *)
o|  1 (##sys#check-input-port * * *)
o|  1 (##sys#call-with-values (procedure () *) *)
o|  3 (##sys#length list)
o|  10 (cdr pair)
o|  1 (string-ref string fixnum)
o|  1 (string-length string)
o|  3 (##sys#check-list (or pair list) *)
o|  4 (make-string fixnum)
o|  4 (##sys#check-open-port * *)
o|  11 (eqv? * (not float))
o|  15 (car pair)
(o e)|safe calls: 866 
(o e)|assignments to immediate values: 26 
o|dropping redundant toplevel assignment: process 
o|dropping redundant toplevel assignment: process* 
o|safe globals: (file-stat ##sys#stat ##sys#posix-error posix-error) 
o|Removed `not' forms: 9 
o|contracted procedure: "(posix-common.scm:185) strerror64" 
o|inlining procedure: k2727 
o|inlining procedure: k2727 
o|inlining procedure: k2742 
o|inlining procedure: k2742 
o|inlining procedure: k2761 
o|inlining procedure: k2761 
o|inlining procedure: k2838 
o|inlining procedure: k2850 
o|inlining procedure: k2850 
o|inlining procedure: k2862 
o|inlining procedure: k2862 
o|inlining procedure: k2874 
o|inlining procedure: k2874 
o|inlining procedure: k2838 
o|inlining procedure: k2995 
o|inlining procedure: k2995 
o|inlining procedure: k3007 
o|inlining procedure: k3007 
o|inlining procedure: k3017 
o|inlining procedure: k3017 
o|inlining procedure: k3044 
o|contracted procedure: k3060 
o|inlining procedure: k3057 
o|inlining procedure: k3057 
o|substituted constant variable: a3070 
o|inlining procedure: k3044 
o|inlining procedure: k3077 
o|inlining procedure: k3077 
o|substituted constant variable: a3121 
o|inlining procedure: k3122 
o|inlining procedure: k3122 
o|contracted procedure: k3138 
o|inlining procedure: k3141 
o|inlining procedure: k3141 
o|inlining procedure: k3174 
o|inlining procedure: k3174 
o|inlining procedure: k3198 
o|inlining procedure: k3198 
o|substituted constant variable: a3219 
o|inlining procedure: k3238 
o|inlining procedure: k3238 
o|inlining procedure: k3259 
o|propagated global variable: r32608880 delete-file 
o|inlining procedure: k3259 
o|inlining procedure: k3251 
o|inlining procedure: k3283 
o|inlining procedure: k3283 
o|inlining procedure: k3251 
o|inlining procedure: k3321 
o|inlining procedure: k3321 
o|inlining procedure: k3343 
o|contracted procedure: "(posix-common.scm:463) g331332" 
o|inlining procedure: k3354 
o|inlining procedure: k3354 
o|inlining procedure: k3343 
o|inlining procedure: k3391 
o|inlining procedure: k3391 
o|contracted procedure: "(posix-common.scm:464) g349350" 
o|inlining procedure: k3399 
o|inlining procedure: k3399 
o|inlining procedure: k3460 
o|inlining procedure: k3460 
o|inlining procedure: k3475 
o|inlining procedure: k3475 
o|inlining procedure: k3516 
o|inlining procedure: k3516 
o|substituted constant variable: a3538 
o|substituted constant variable: a3540 
o|inlining procedure: k3577 
o|inlining procedure: k3577 
o|inlining procedure: k3611 
o|inlining procedure: k3611 
o|inlining procedure: k3664 
o|inlining procedure: k3664 
o|inlining procedure: k3672 
o|inlining procedure: k3672 
o|contracted procedure: "(posix-common.scm:558) find-files" 
o|inlining procedure: k3697 
o|inlining procedure: k3697 
o|inlining procedure: k3718 
o|inlining procedure: k3718 
o|inlining procedure: k3737 
o|inlining procedure: k3737 
o|inlining procedure: k3746 
o|inlining procedure: k3778 
o|inlining procedure: k3778 
o|inlining procedure: k3746 
o|inlining procedure: k3796 
o|inlining procedure: k3796 
o|inlining procedure: k3811 
o|inlining procedure: k3811 
o|contracted procedure: k3838 
o|inlining procedure: k3843 
o|inlining procedure: k3843 
o|inlining procedure: k3913 
o|inlining procedure: k3913 
o|inlining procedure: k3990 
o|inlining procedure: k3990 
o|contracted procedure: "(posix-common.scm:595) ctime542" 
o|inlining procedure: k4026 
o|inlining procedure: k4026 
o|inlining procedure: k4070 
o|contracted procedure: "(posix-common.scm:618) strftime568" 
o|inlining procedure: k4056 
o|inlining procedure: k4056 
o|inlining procedure: k4070 
o|contracted procedure: "(posix-common.scm:620) asctime567" 
o|inlining procedure: k4043 
o|inlining procedure: k4043 
o|inlining procedure: k4172 
o|inlining procedure: k4181 
o|inlining procedure: k4181 
o|inlining procedure: k4172 
o|contracted procedure: "(posix-common.scm:644) get619" 
o|inlining procedure: k4282 
o|inlining procedure: k4282 
o|inlining procedure: k4368 
o|inlining procedure: k4368 
o|contracted procedure: "(posix-common.scm:712) c-string->allocated-pointer663" 
o|merged explicitly consed rest parameter: args675697 
o|consed rest parameter at call site: tmp22595 1 
o|inlining procedure: k4451 
o|inlining procedure: k4451 
o|inlining procedure: k4511 
o|inlining procedure: k4511 
o|inlining procedure: k4634 
o|inlining procedure: k4634 
o|contracted procedure: "(posixunix.scm:466) fcntl833" 
o|inlining procedure: k4671 
o|inlining procedure: k4671 
o|inlining procedure: k4696 
o|inlining procedure: k4696 
o|inlining procedure: k4730 
o|inlining procedure: k4730 
o|inlining procedure: k4771 
o|inlining procedure: k4771 
o|inlining procedure: k4874 
o|inlining procedure: k4874 
o|inlining procedure: k4897 
o|inlining procedure: k4897 
o|inlining procedure: k4920 
o|inlining procedure: k4929 
o|inlining procedure: k4929 
o|inlining procedure: k4920 
o|inlining procedure: k4935 
o|inlining procedure: k4935 
o|inlining procedure: k4950 
o|inlining procedure: k4950 
o|contracted procedure: "(posixunix.scm:572) g10101011" 
o|inlining procedure: k4969 
o|inlining procedure: k4969 
o|inlining procedure: k5009 
o|inlining procedure: k5009 
o|contracted procedure: "(posixunix.scm:564) g991992" 
o|inlining procedure: k5028 
o|inlining procedure: k5028 
o|contracted procedure: "(posixunix.scm:558) g965966" 
o|inlining procedure: k5083 
o|inlining procedure: k5083 
o|contracted procedure: "(posixunix.scm:552) g950951" 
o|inlining procedure: k5100 
o|inlining procedure: k5100 
o|inlining procedure: k5125 
o|inlining procedure: k5125 
o|contracted procedure: "(posixunix.scm:546) g932933" 
o|inlining procedure: k5142 
o|inlining procedure: k5142 
o|contracted procedure: k5172 
o|inlining procedure: k5175 
o|inlining procedure: k5175 
o|contracted procedure: k5187 
o|inlining procedure: k5190 
o|inlining procedure: k5190 
o|inlining procedure: k5215 
o|inlining procedure: k5215 
o|inlining procedure: k5231 
o|inlining procedure: k5231 
o|inlining procedure: k5244 
o|inlining procedure: k5244 
o|inlining procedure: k5262 
o|inlining procedure: k5262 
o|inlining procedure: k5287 
o|inlining procedure: k5287 
o|inlining procedure: "(posixunix.scm:623) badmode1038" 
o|substituted constant variable: a5311 
o|substituted constant variable: a5313 
o|inlining procedure: k5327 
o|inlining procedure: k5327 
o|inlining procedure: "(posixunix.scm:634) badmode1038" 
o|substituted constant variable: a5351 
o|substituted constant variable: a5353 
o|substituted constant variable: a5358 
o|substituted constant variable: a5359 
o|inlining procedure: k5360 
o|inlining procedure: k5360 
o|substituted constant variable: a5373 
o|substituted constant variable: a5374 
o|inlining procedure: k5375 
o|inlining procedure: k5375 
o|inlining procedure: k5503 
o|inlining procedure: k5503 
o|inlining procedure: k5561 
o|inlining procedure: k5561 
o|inlining procedure: k5574 
o|contracted procedure: "(posixunix.scm:765) g11651172" 
o|inlining procedure: k5574 
o|inlining procedure: k5610 
o|inlining procedure: k5610 
o|inlining procedure: k5626 
o|inlining procedure: k5626 
o|inlining procedure: k5699 
o|inlining procedure: k5699 
o|inlining procedure: k5792 
o|inlining procedure: k5819 
o|inlining procedure: k5819 
o|contracted procedure: "(posixunix.scm:913) group-member" 
o|inlining procedure: k5792 
o|inlining procedure: k5881 
o|inlining procedure: k5881 
o|contracted procedure: "(posixunix.scm:936) _get-groups" 
o|inlining procedure: "(posixunix.scm:934) _ensure-groups" 
o|inlining procedure: k5939 
o|inlining procedure: k5939 
o|inlining procedure: "(posixunix.scm:945) _ensure-groups" 
o|inlining procedure: k6011 
o|inlining procedure: k6011 
o|contracted procedure: "(posixunix.scm:962) init1308" 
o|inlining procedure: k6075 
o|inlining procedure: k6075 
o|inlining procedure: k6101 
o|inlining procedure: k6101 
o|inlining procedure: k6124 
o|inlining procedure: k6124 
o|inlining procedure: k6156 
o|inlining procedure: k6156 
o|inlining procedure: k6181 
o|inlining procedure: k6181 
o|inlining procedure: k6209 
o|inlining procedure: k6209 
o|inlining procedure: k6230 
o|inlining procedure: k6255 
o|inlining procedure: k6255 
o|inlining procedure: k6276 
o|inlining procedure: k6276 
o|inlining procedure: k6306 
o|inlining procedure: k6306 
o|inlining procedure: k6230 
o|inlining procedure: k6351 
o|inlining procedure: k6351 
o|contracted procedure: "(posixunix.scm:1116) link1440" 
o|inlining procedure: k6326 
o|inlining procedure: k6326 
o|inlining procedure: k6405 
o|inlining procedure: k6405 
o|inlining procedure: k6431 
o|inlining procedure: k6431 
o|inlining procedure: k6445 
o|inlining procedure: k6469 
o|inlining procedure: k6469 
o|inlining procedure: k6445 
o|inlining procedure: k6490 
o|inlining procedure: k6490 
o|inlining procedure: k6510 
o|inlining procedure: k6510 
o|inlining procedure: k6547 
o|inlining procedure: k6547 
o|inlining procedure: k6569 
o|inlining procedure: k6569 
o|inlining procedure: k6578 
o|inlining procedure: k6578 
o|inlining procedure: k6600 
o|inlining procedure: k6600 
o|inlining procedure: k6625 
o|inlining procedure: k6625 
o|inlining procedure: k6672 
o|inlining procedure: k6672 
o|inlining procedure: k6694 
o|inlining procedure: k6694 
o|inlining procedure: k6722 
o|inlining procedure: k6722 
o|inlining procedure: k6765 
o|inlining procedure: k6765 
o|inlining procedure: k6814 
o|inlining procedure: k6814 
o|inlining procedure: k6919 
o|inlining procedure: k6940 
o|inlining procedure: k6940 
o|inlining procedure: k6919 
o|inlining procedure: k6996 
o|inlining procedure: k6996 
o|inlining procedure: k7026 
o|inlining procedure: k7026 
o|inlining procedure: k7041 
o|inlining procedure: k7058 
o|inlining procedure: k7058 
o|inlining procedure: k7041 
o|inlining procedure: k7154 
o|inlining procedure: k7154 
o|inlining procedure: k7164 
o|inlining procedure: k7164 
o|inlining procedure: k7271 
o|inlining procedure: k7271 
o|inlining procedure: k7287 
o|inlining procedure: k7287 
o|inlining procedure: k7303 
o|contracted procedure: "(posixunix.scm:1349) g16901691" 
o|contracted procedure: k7311 
o|inlining procedure: k7308 
o|inlining procedure: k7308 
o|inlining procedure: k7303 
o|inlining procedure: k7338 
o|inlining procedure: k7338 
o|inlining procedure: k7364 
o|inlining procedure: k7364 
o|inlining procedure: k7399 
o|inlining procedure: k7399 
o|inlining procedure: k7411 
o|inlining procedure: k7411 
o|substituted constant variable: a7424 
o|substituted constant variable: a7426 
o|substituted constant variable: a7428 
o|contracted procedure: "(posixunix.scm:1418) mmap1727" 
o|contracted procedure: k7508 
o|inlining procedure: k7536 
o|inlining procedure: k7536 
o|contracted procedure: "(posixunix.scm:1428) munmap1758" 
o|contracted procedure: "(posixunix.scm:1446) strptime1777" 
o|inlining procedure: k7579 
o|inlining procedure: k7579 
o|inlining procedure: k7631 
o|inlining procedure: k7631 
o|contracted procedure: "(posixunix.scm:1474) ex01816" 
o|inlining procedure: k7689 
o|inlining procedure: k7689 
o|inlining procedure: k7699 
o|inlining procedure: k7699 
o|inlining procedure: k7712 
o|inlining procedure: k7712 
o|substituted constant variable: a7728 
o|substituted constant variable: a7730 
o|substituted constant variable: a7732 
o|substituted constant variable: a7741 
o|contracted procedure: k7748 
o|inlining procedure: k7745 
o|inlining procedure: k7745 
o|inlining procedure: k7760 
o|inlining procedure: k7760 
o|contracted procedure: "(posixunix.scm:1514) ttyname1852" 
o|inlining procedure: k7816 
o|inlining procedure: k7816 
o|contracted procedure: "(posixunix.scm:1525) ttysize1861" 
o|inlining procedure: k7853 
o|inlining procedure: k7853 
o|contracted procedure: "(posixunix.scm:1538) getit1883" 
o|inlining procedure: k7894 
o|inlining procedure: k7894 
o|contracted procedure: "(posixunix.scm:1551) fork1890" 
o|contracted procedure: "(posixunix.scm:1547) g19081909" 
o|inlining procedure: k7879 
o|inlining procedure: k7879 
o|inlining procedure: k7981 
o|inlining procedure: k7981 
o|inlining procedure: k8021 
o|inlining procedure: k8021 
o|inlining procedure: k8040 
o|inlining procedure: k8040 
o|inlining procedure: k8074 
o|inlining procedure: k8074 
o|inlining procedure: k8093 
o|inlining procedure: k8093 
o|contracted procedure: k8114 
o|inlining procedure: k8111 
o|inlining procedure: k8111 
o|inlining procedure: k8164 
o|inlining procedure: k8182 
o|inlining procedure: k8182 
o|inlining procedure: k8164 
o|removed unused formal parameters: (loc2007) 
o|inlining procedure: k8196 
o|inlining procedure: k8196 
o|removed unused formal parameters: (loc2012 fd2015) 
o|inlining procedure: k8216 
o|inlining procedure: k8216 
o|inlining procedure: k8228 
o|contracted procedure: "(posixunix.scm:1668) replace-fd1987" 
o|inlining procedure: k8145 
o|inlining procedure: k8145 
o|inlining procedure: k8228 
o|inlining procedure: k8243 
o|inlining procedure: k8243 
o|removed unused parameter to known procedure: loc2007 "(posixunix.scm:1678) needed-pipe1993" 
o|removed unused parameter to known procedure: loc2007 "(posixunix.scm:1677) needed-pipe1993" 
o|removed unused parameter to known procedure: loc2007 "(posixunix.scm:1676) needed-pipe1993" 
o|removed unused formal parameters: (pid2047) 
o|inlining procedure: k8305 
o|inlining procedure: k8305 
o|removed unused parameter to known procedure: loc2012 "(posixunix.scm:1689) connect-parent1994" 
o|removed unused parameter to known procedure: fd2015 "(posixunix.scm:1689) connect-parent1994" 
o|removed unused formal parameters: (pid2055) 
o|inlining procedure: k8316 
o|inlining procedure: k8316 
o|removed unused parameter to known procedure: loc2012 "(posixunix.scm:1693) connect-parent1994" 
o|removed unused parameter to known procedure: fd2015 "(posixunix.scm:1693) connect-parent1994" 
o|removed unused parameter to known procedure: pid2047 "(posixunix.scm:1708) input-port2028" 
o|removed unused parameter to known procedure: pid2055 "(posixunix.scm:1705) output-port2029" 
o|removed unused parameter to known procedure: pid2047 "(posixunix.scm:1703) input-port2028" 
o|inlining procedure: k8396 
o|inlining procedure: k8396 
o|inlining procedure: k8557 
o|inlining procedure: k8557 
o|contracted procedure: "(posixunix.scm:1750) chroot2153" 
o|inlining procedure: k8542 
o|inlining procedure: k8542 
o|inlining procedure: k8580 
o|inlining procedure: k8580 
o|inlining procedure: k8601 
o|inlining procedure: k8601 
o|inlining procedure: k8620 
o|inlining procedure: k8620 
o|inlining procedure: k8639 
o|inlining procedure: k8639 
o|inlining procedure: k8658 
o|inlining procedure: k8658 
o|inlining procedure: k8677 
o|inlining procedure: k8677 
o|inlining procedure: k8699 
o|inlining procedure: k8699 
o|inlining procedure: k8714 
o|inlining procedure: k8714 
o|inlining procedure: k8746 
o|inlining procedure: k8746 
o|inlining procedure: k8770 
o|inlining procedure: k8770 
o|inlining procedure: k8782 
o|inlining procedure: k8782 
o|inlining procedure: k8792 
o|inlining procedure: k8792 
o|inlining procedure: k8829 
o|inlining procedure: k8829 
o|contracted procedure: "(posix-common.scm:257) g115116" 
o|inlining procedure: k8816 
o|inlining procedure: k8816 
o|replaced variables: 916 
o|removed binding forms: 568 
o|substituted constant variable: r27288839 
o|substituted constant variable: r28518845 
o|substituted constant variable: r28638847 
o|substituted constant variable: r28758849 
o|substituted constant variable: r28398851 
o|substituted constant variable: r30088855 
o|inlining procedure: k3044 
o|substituted constant variable: r30588861 
o|inlining procedure: k3044 
o|inlining procedure: k3044 
o|propagated global variable: g2993008881 delete-file 
o|inlining procedure: k3259 
o|inlining procedure: k3259 
o|propagated global variable: r32609367 delete-file 
o|propagated global variable: r32609367 delete-file 
o|converted assignments to bindings: (rmdir282) 
o|substituted constant variable: loc333 
o|substituted constant variable: loc333 
o|substituted constant variable: loc351 
o|substituted constant variable: loc351 
o|substituted constant variable: r34768908 
o|substituted constant variable: r35788912 
o|substituted constant variable: r36658918 
o|substituted constant variable: r36658918 
o|substituted constant variable: r36738922 
o|substituted constant variable: r36738922 
o|substituted constant variable: loc438 
o|substituted constant variable: r40578956 
o|substituted constant variable: r40578956 
o|substituted constant variable: r40448963 
o|substituted constant variable: r40448963 
o|substituted constant variable: r41738969 
o|substituted constant variable: r48989010 
o|substituted constant variable: r48989010 
o|substituted constant variable: r48989012 
o|substituted constant variable: r48989012 
o|inlining procedure: k4920 
o|inlining procedure: k4920 
o|substituted constant variable: r49309017 
o|inlining procedure: k4920 
o|substituted constant variable: r49219018 
o|substituted constant variable: r49219018 
o|substituted constant variable: r49709026 
o|substituted constant variable: r49709026 
o|substituted constant variable: r50299032 
o|substituted constant variable: r50299032 
o|substituted constant variable: r51019038 
o|substituted constant variable: r51019038 
o|substituted constant variable: r51439044 
o|substituted constant variable: r51439044 
o|substituted constant variable: r52459059 
o|removed side-effect free assignment to unused variable: badmode1038 
o|inlining procedure: k5287 
o|inlining procedure: k5327 
o|substituted constant variable: r57009107 
o|substituted constant variable: r58209110 
o|substituted constant variable: r57939111 
o|removed side-effect free assignment to unused variable: _ensure-groups 
o|substituted constant variable: r58829112 
o|inlining procedure: k6276 
o|substituted constant variable: r63079155 
o|substituted constant variable: r63079155 
o|substituted constant variable: r63279162 
o|substituted constant variable: r63279162 
o|substituted constant variable: r64329166 
o|inlining procedure: k6502 
o|inlining procedure: k6502 
o|inlining procedure: k6584 
o|substituted constant variable: r66959198 
o|substituted constant variable: r68159210 
o|inlining procedure: k7002 
o|inlining procedure: k7164 
o|substituted constant variable: r73099235 
o|substituted constant variable: r74009242 
o|inlining procedure: k7482 
o|substituted constant variable: r75809250 
o|substituted constant variable: r75809250 
o|substituted constant variable: r77009258 
o|substituted constant variable: r77009258 
o|folded constant expression: (fx< (quote -1) (quote 0)) 
o|substituted constant variable: r77469262 
o|substituted constant variable: c-pointer19101914 
o|substituted constant variable: c-pointer19101914 
o|substituted constant variable: r78809276 
o|substituted constant variable: r78809276 
o|inlining procedure: k8040 
o|inlining procedure: k8040 
o|substituted constant variable: r80949289 
o|substituted constant variable: r81979297 
o|substituted constant variable: r82179299 
o|substituted constant variable: r82449305 
o|removed unused formal parameters: (stdfd2051) 
o|substituted constant variable: r83069307 
o|removed unused formal parameters: (stdfd2059) 
o|substituted constant variable: r83179309 
o|removed unused parameter to known procedure: stdfd2051 "(posixunix.scm:1708) input-port2028" 
o|removed unused parameter to known procedure: stdfd2059 "(posixunix.scm:1705) output-port2029" 
o|removed unused parameter to known procedure: stdfd2051 "(posixunix.scm:1703) input-port2028" 
o|substituted constant variable: r85439316 
o|substituted constant variable: r85439316 
o|converted assignments to bindings: (check1373) 
o|substituted constant variable: r87839347 
o|substituted constant variable: r88179354 
o|substituted constant variable: r88179354 
o|simplifications: ((let . 2)) 
o|replaced variables: 62 
o|removed binding forms: 956 
o|removed conditional forms: 1 
o|inlining procedure: k3519 
o|inlining procedure: k4233 
o|inlining procedure: k4233 
o|inlining procedure: k4460 
o|inlining procedure: k4742 
o|inlining procedure: k4742 
o|inlining procedure: k4787 
o|inlining procedure: k4787 
o|substituted constant variable: r49219415 
o|inlining procedure: k7498 
o|inlining procedure: k7498 
o|removed unused formal parameters: (loc2020) 
o|removed unused parameter to known procedure: loc2020 "(posixunix.scm:1685) connect-child1995" 
o|removed unused parameter to known procedure: loc2020 "(posixunix.scm:1684) connect-child1995" 
o|removed unused parameter to known procedure: loc2020 "(posixunix.scm:1683) connect-child1995" 
o|inlining procedure: k8508 
o|replaced variables: 28 
o|removed binding forms: 175 
o|substituted constant variable: r30459356 
o|substituted constant variable: r30459358 
o|substituted constant variable: r30459360 
o|substituted constant variable: r35209506 
o|substituted constant variable: r35209506 
o|substituted constant variable: r42349521 
o|contracted procedure: k4383 
o|substituted constant variable: r47439534 
o|substituted constant variable: r47889536 
o|substituted constant variable: r74999564 
o|contracted procedure: k7888 
o|removed unused formal parameters: (loc2033) 
o|removed unused parameter to known procedure: loc2033 "(posixunix.scm:1697) spawn2027" 
o|inlining procedure: k8743 
o|inlining procedure: k8743 
o|simplifications: ((let . 3)) 
o|replaced variables: 3 
o|removed binding forms: 31 
o|removed conditional forms: 4 
o|inlining procedure: k7660 
o|inlining procedure: k7660 
o|substituted constant variable: r87449625 
o|replaced variables: 1 
o|removed binding forms: 12 
o|substituted constant variable: r76619681 
o|contracted procedure: k7885 
o|removed binding forms: 4 
o|removed binding forms: 1 
o|simplifications: ((if . 89) (##core#call . 665)) 
o|  call simplifications:
o|    <
o|    bitwise-ior	2
o|    vector-ref	2
o|    make-vector
o|    ##sys#structure?
o|    ##sys#foreign-pointer-argument	4
o|    fxior	2
o|    ##sys#check-structure	3
o|    ##sys#make-structure	3
o|    ##sys#setislot	3
o|    fxmin	2
o|    eof-object?
o|    ##sys#foreign-string-argument	5
o|    length
o|    fx>=	8
o|    fx*
o|    *
o|    inexact->exact
o|    memq	2
o|    list	7
o|    ##sys#check-list	5
o|    add1
o|    ##sys#apply	2
o|    values	20
o|    ##sys#fudge	2
o|    vector-set!	3
o|    char=?
o|    ##sys#foreign-block-argument	8
o|    ##sys#foreign-integer-argument	5
o|    fx-	12
o|    ##sys#check-number	8
o|    ##sys#check-vector
o|    procedure?
o|    member
o|    fx+	28
o|    string-ref
o|    fx>
o|    cons	13
o|    ##sys#size	14
o|    ##sys#call-with-values	14
o|    not	8
o|    ##sys#check-string	32
o|    fx=	32
o|    zero?
o|    ##sys#null-pointer?	4
o|    pair?	19
o|    ##sys#check-exact	37
o|    ##sys#slot	32
o|    eq?	40
o|    cdr	28
o|    ##sys#eqv?	14
o|    null?	72
o|    car	51
o|    vector	2
o|    fixnum?	15
o|    string?	2
o|    fx<	47
o|    ##sys#foreign-fixnum-argument	28
o|    apply	9
o|contracted procedure: k2701 
o|contracted procedure: k2730 
o|contracted procedure: k2739 
o|contracted procedure: k2755 
o|contracted procedure: k2783 
o|contracted procedure: k2774 
o|contracted procedure: k2904 
o|contracted procedure: k2826 
o|contracted procedure: k2898 
o|contracted procedure: k2829 
o|contracted procedure: k2892 
o|contracted procedure: k2832 
o|contracted procedure: k2886 
o|contracted procedure: k2835 
o|contracted procedure: k2847 
o|contracted procedure: k2853 
o|contracted procedure: k2859 
o|contracted procedure: k2865 
o|contracted procedure: k2871 
o|contracted procedure: k2877 
o|contracted procedure: k2883 
o|contracted procedure: k2989 
o|contracted procedure: k2992 
o|contracted procedure: k3014 
o|contracted procedure: k3010 
o|contracted procedure: k3020 
o|contracted procedure: k3026 
o|contracted procedure: k3047 
o|contracted procedure: k3054 
o|contracted procedure: k3080 
o|contracted procedure: k3092 
o|contracted procedure: k3106 
o|contracted procedure: k3162 
o|contracted procedure: k3125 
o|contracted procedure: k3154 
o|contracted procedure: k3144 
o|contracted procedure: k3168 
o|contracted procedure: k3177 
o|contracted procedure: k3183 
o|contracted procedure: k3186 
o|contracted procedure: k3189 
o|contracted procedure: k3220 
o|contracted procedure: k3195 
o|contracted procedure: k3306 
o|contracted procedure: k3229 
o|contracted procedure: k3241 
o|contracted procedure: k3248 
o|contracted procedure: k3286 
o|contracted procedure: k3296 
o|contracted procedure: k3300 
o|contracted procedure: k3423 
o|contracted procedure: k3315 
o|contracted procedure: k3318 
o|contracted procedure: k3420 
o|contracted procedure: k3324 
o|contracted procedure: k3357 
o|contracted procedure: k3402 
o|contracted procedure: k3553 
o|contracted procedure: k3435 
o|contracted procedure: k3547 
o|contracted procedure: k3438 
o|contracted procedure: k3541 
o|contracted procedure: k3441 
o|contracted procedure: k3444 
o|contracted procedure: k3463 
o|contracted procedure: k3478 
o|contracted procedure: k3482 
o|contracted procedure: k3488 
o|contracted procedure: k3534 
o|contracted procedure: k3491 
o|contracted procedure: k3510 
o|contracted procedure: k3513 
o|contracted procedure: k3528 
o|contracted procedure: k3519 
o|contracted procedure: k3559 
o|contracted procedure: k3580 
o|contracted procedure: k3583 
o|contracted procedure: k3614 
o|contracted procedure: k3621 
o|contracted procedure: k3644 
o|contracted procedure: k3660 
o|contracted procedure: k3678 
o|contracted procedure: k3700 
o|contracted procedure: k3703 
o|contracted procedure: k3709 
o|contracted procedure: k3721 
o|contracted procedure: k3730 
o|contracted procedure: k3756 
o|contracted procedure: k3827 
o|contracted procedure: k3846 
o|contracted procedure: k3910 
o|contracted procedure: k3923 
o|contracted procedure: k3916 
o|contracted procedure: k3932 
o|contracted procedure: k3938 
o|contracted procedure: k3953 
o|contracted procedure: k3959 
o|contracted procedure: k3984 
o|contracted procedure: k4001 
o|contracted procedure: k3997 
o|contracted procedure: k3976 
o|contracted procedure: k4007 
o|contracted procedure: k4117 
o|contracted procedure: k4064 
o|contracted procedure: k4073 
o|contracted procedure: k4056 
o|contracted procedure: k4107 
o|contracted procedure: k4103 
o|contracted procedure: k4043 
o|contracted procedure: k4126 
o|contracted procedure: k4129 
o|contracted procedure: k4143 
o|contracted procedure: k4184 
o|contracted procedure: k4191 
o|contracted procedure: k4199 
o|contracted procedure: k4211 
o|contracted procedure: k4215 
o|contracted procedure: k4222 
o|contracted procedure: k4158 
o|contracted procedure: k4229 
o|contracted procedure: k4312 
o|contracted procedure: k4252 
o|contracted procedure: k4306 
o|contracted procedure: k4255 
o|contracted procedure: k4300 
o|contracted procedure: k4258 
o|contracted procedure: k4294 
o|contracted procedure: k4261 
o|contracted procedure: k4264 
o|contracted procedure: k4267 
o|contracted procedure: k4285 
o|contracted procedure: k4323 
o|contracted procedure: k4371 
o|contracted procedure: k4374 
o|contracted procedure: k4411 
o|contracted procedure: k4377 
o|contracted procedure: k4398 
o|contracted procedure: k4436 
o|contracted procedure: k4454 
o|contracted procedure: k4467 
o|contracted procedure: k44679528 
o|contracted procedure: k4481 
o|contracted procedure: k4559 
o|contracted procedure: k4566 
o|contracted procedure: k4643 
o|contracted procedure: k4622 
o|contracted procedure: k4625 
o|contracted procedure: k4628 
o|contracted procedure: k4637 
o|contracted procedure: k4609 
o|contracted procedure: k4613 
o|contracted procedure: k4617 
o|contracted procedure: k8721 
o|contracted procedure: k4650 
o|contracted procedure: k4658 
o|contracted procedure: k4661 
o|contracted procedure: k4664 
o|contracted procedure: k4674 
o|contracted procedure: k4680 
o|contracted procedure: k4687 
o|contracted procedure: k4699 
o|contracted procedure: k4705 
o|contracted procedure: k4718 
o|contracted procedure: k4721 
o|contracted procedure: k4736 
o|contracted procedure: k4748 
o|contracted procedure: k4759 
o|contracted procedure: k4768 
o|contracted procedure: k4774 
o|contracted procedure: k4780 
o|contracted procedure: k4796 
o|contracted procedure: k4802 
o|contracted procedure: k4816 
o|contracted procedure: k4819 
o|contracted procedure: k4839 
o|contracted procedure: k4845 
o|contracted procedure: k4877 
o|contracted procedure: k4886 
o|contracted procedure: k4903 
o|contracted procedure: k4893 
o|contracted procedure: k4900 
o|contracted procedure: k4926 
o|contracted procedure: k4932 
o|contracted procedure: k4938 
o|contracted procedure: k4944 
o|contracted procedure: k4953 
o|contracted procedure: k4982 
o|contracted procedure: k4992 
o|contracted procedure: k4986 
o|contracted procedure: k4999 
o|contracted procedure: k5003 
o|contracted procedure: k4965 
o|contracted procedure: k4969 
o|contracted procedure: k5012 
o|contracted procedure: k5041 
o|contracted procedure: k5051 
o|contracted procedure: k5045 
o|contracted procedure: k5058 
o|contracted procedure: k5062 
o|contracted procedure: k5024 
o|contracted procedure: k5028 
o|contracted procedure: k4857 
o|contracted procedure: k4861 
o|contracted procedure: k4865 
o|contracted procedure: k5073 
o|contracted procedure: k5086 
o|contracted procedure: k5113 
o|contracted procedure: k5119 
o|contracted procedure: k5092 
o|contracted procedure: k5096 
o|contracted procedure: k5100 
o|contracted procedure: k5128 
o|contracted procedure: k5155 
o|contracted procedure: k5161 
o|contracted procedure: k5134 
o|contracted procedure: k5138 
o|contracted procedure: k5142 
o|contracted procedure: k5168 
o|contracted procedure: k5178 
o|contracted procedure: k5184 
o|contracted procedure: k5193 
o|contracted procedure: k5199 
o|contracted procedure: k5202 
o|contracted procedure: k5209 
o|contracted procedure: k5218 
o|contracted procedure: k5228 
o|contracted procedure: k5234 
o|contracted procedure: k5247 
o|contracted procedure: k5265 
o|contracted procedure: k5277 
o|contracted procedure: k5290 
o|contracted procedure: k5300 
o|contracted procedure: k5317 
o|contracted procedure: k5330 
o|contracted procedure: k5340 
o|contracted procedure: k5363 
o|contracted procedure: k5378 
o|contracted procedure: k5509 
o|contracted procedure: k5544 
o|contracted procedure: k5550 
o|contracted procedure: k5564 
o|contracted procedure: k5577 
o|contracted procedure: k5587 
o|contracted procedure: k5591 
o|contracted procedure: k5555 
o|contracted procedure: k5601 
o|contracted procedure: k5607 
o|contracted procedure: k5613 
o|contracted procedure: k5623 
o|contracted procedure: k5629 
o|contracted procedure: k5665 
o|contracted procedure: k5738 
o|contracted procedure: k5693 
o|contracted procedure: k5702 
o|contracted procedure: k5728 
o|contracted procedure: k5731 
o|contracted procedure: k5843 
o|contracted procedure: k5786 
o|contracted procedure: k5795 
o|contracted procedure: k5830 
o|contracted procedure: k5780 
o|contracted procedure: k5833 
o|contracted procedure: k5836 
o|contracted procedure: k5884 
o|contracted procedure: k5896 
o|contracted procedure: k5899 
o|contracted procedure: k5853 
o|contracted procedure: k58609119 
o|contracted procedure: k5918 
o|contracted procedure: k5942 
o|contracted procedure: k5948 
o|contracted procedure: k5958 
o|contracted procedure: k5961 
o|contracted procedure: k5968 
o|contracted procedure: k5972 
o|contracted procedure: k5982 
o|contracted procedure: k58609127 
o|contracted procedure: k6005 
o|contracted procedure: k6008 
o|contracted procedure: k6014 
o|contracted procedure: k5993 
o|contracted procedure: k6000 
o|contracted procedure: k6069 
o|contracted procedure: k6072 
o|contracted procedure: k6078 
o|contracted procedure: k6092 
o|contracted procedure: k6095 
o|contracted procedure: k6098 
o|contracted procedure: k6104 
o|contracted procedure: k6118 
o|contracted procedure: k6121 
o|contracted procedure: k6159 
o|contracted procedure: k6175 
o|contracted procedure: k6178 
o|contracted procedure: k6184 
o|contracted procedure: k6212 
o|contracted procedure: k6312 
o|contracted procedure: k6224 
o|contracted procedure: k6227 
o|contracted procedure: k6258 
o|contracted procedure: k6298 
o|contracted procedure: k6302 
o|contracted procedure: k6345 
o|contracted procedure: k6348 
o|contracted procedure: k6354 
o|contracted procedure: k6333 
o|contracted procedure: k6340 
o|contracted procedure: k6881 
o|contracted procedure: k6367 
o|contracted procedure: k6875 
o|contracted procedure: k6370 
o|contracted procedure: k6869 
o|contracted procedure: k6373 
o|contracted procedure: k6863 
o|contracted procedure: k6376 
o|contracted procedure: k6857 
o|contracted procedure: k6379 
o|contracted procedure: k6851 
o|contracted procedure: k6382 
o|contracted procedure: k6845 
o|contracted procedure: k6385 
o|contracted procedure: k6839 
o|contracted procedure: k6388 
o|contracted procedure: k6830 
o|contracted procedure: k6394 
o|contracted procedure: k6408 
o|contracted procedure: k6414 
o|contracted procedure: k6417 
o|contracted procedure: k6434 
o|contracted procedure: k6448 
o|contracted procedure: k6454 
o|contracted procedure: k6457 
o|contracted procedure: k6472 
o|contracted procedure: k6487 
o|contracted procedure: k6507 
o|contracted procedure: k6513 
o|contracted procedure: k6516 
o|contracted procedure: k6550 
o|contracted procedure: k6554 
o|contracted procedure: k6557 
o|contracted procedure: k6566 
o|contracted procedure: k6581 
o|contracted procedure: k6590 
o|contracted procedure: k6606 
o|contracted procedure: k6628 
o|contracted procedure: k6634 
o|contracted procedure: k6637 
o|contracted procedure: k6666 
o|contracted procedure: k6640 
o|contracted procedure: k6644 
o|contracted procedure: k6648 
o|contracted procedure: k6655 
o|contracted procedure: k6659 
o|contracted procedure: k6663 
o|contracted procedure: k6675 
o|contracted procedure: k6685 
o|contracted procedure: k6697 
o|contracted procedure: k6759 
o|contracted procedure: k6713 
o|contracted procedure: k6719 
o|contracted procedure: k6725 
o|contracted procedure: k6732 
o|contracted procedure: k6741 
o|contracted procedure: k6752 
o|contracted procedure: k6748 
o|contracted procedure: k6780 
o|contracted procedure: k6776 
o|contracted procedure: k6769 
o|inlining procedure: k6765 
o|contracted procedure: k6791 
o|contracted procedure: k6795 
o|contracted procedure: k6787 
o|inlining procedure: k6765 
o|contracted procedure: k6802 
o|contracted procedure: k6805 
o|contracted procedure: k6817 
o|contracted procedure: k6824 
o|contracted procedure: k7142 
o|contracted procedure: k6890 
o|contracted procedure: k7136 
o|contracted procedure: k6893 
o|contracted procedure: k7130 
o|contracted procedure: k6896 
o|contracted procedure: k7124 
o|contracted procedure: k6899 
o|contracted procedure: k7118 
o|contracted procedure: k6902 
o|contracted procedure: k7112 
o|contracted procedure: k6905 
o|contracted procedure: k6922 
o|contracted procedure: k6928 
o|contracted procedure: k6931 
o|contracted procedure: k6943 
o|contracted procedure: k6958 
o|contracted procedure: k6969 
o|contracted procedure: k7103 
o|contracted procedure: k6972 
o|contracted procedure: k6999 
o|contracted procedure: k7008 
o|contracted procedure: k7021 
o|contracted procedure: k7033 
o|contracted procedure: k7048 
o|contracted procedure: k7052 
o|contracted procedure: k7061 
o|contracted procedure: k7074 
o|contracted procedure: k7081 
o|contracted procedure: k7085 
o|contracted procedure: k7091 
o|contracted procedure: k7097 
o|contracted procedure: k7151 
o|contracted procedure: k7167 
o|contracted procedure: k7177 
o|contracted procedure: k7241 
o|contracted procedure: k7186 
o|contracted procedure: k7235 
o|contracted procedure: k7189 
o|contracted procedure: k7229 
o|contracted procedure: k7192 
o|contracted procedure: k7223 
o|contracted procedure: k7195 
o|contracted procedure: k7200 
o|contracted procedure: k7213 
o|contracted procedure: k7207 
o|contracted procedure: k7216 
o|contracted procedure: k7254 
o|contracted procedure: k7258 
o|contracted procedure: k7262 
o|contracted procedure: k7274 
o|contracted procedure: k7290 
o|contracted procedure: k7315 
o|contracted procedure: k7327 
o|contracted procedure: k7331 
o|contracted procedure: k7335 
o|contracted procedure: k7349 
o|contracted procedure: k7341 
o|contracted procedure: k7355 
o|contracted procedure: k7361 
o|contracted procedure: k7367 
o|contracted procedure: k7378 
o|contracted procedure: k7386 
o|contracted procedure: k7392 
o|contracted procedure: k7402 
o|contracted procedure: k7408 
o|contracted procedure: k7414 
o|contracted procedure: k7488 
o|contracted procedure: k7442 
o|contracted procedure: k7446 
o|contracted procedure: k7450 
o|contracted procedure: k7454 
o|contracted procedure: k7458 
o|contracted procedure: k7462 
o|contracted procedure: k7504 
o|contracted procedure: k7530 
o|contracted procedure: k7539 
o|contracted procedure: k7550 
o|contracted procedure: k7518 
o|contracted procedure: k7522 
o|contracted procedure: k7553 
o|contracted procedure: k7563 
o|contracted procedure: k7615 
o|contracted procedure: k7587 
o|contracted procedure: k7590 
o|contracted procedure: k7593 
o|contracted procedure: k7608 
o|substituted constant variable: g9894 
o|substituted constant variable: g9894 
o|substituted constant variable: g9894 
o|substituted constant variable: g9894 
o|substituted constant variable: g9894 
o|substituted constant variable: g9894 
o|substituted constant variable: g9894 
o|substituted constant variable: g9894 
o|substituted constant variable: g9894 
o|substituted constant variable: g9894 
o|contracted procedure: k7579 
o|contracted procedure: k7663 
o|contracted procedure: k76519680 
o|contracted procedure: k76519685 
o|contracted procedure: k7671 
o|contracted procedure: k7686 
o|contracted procedure: k7706 
o|contracted procedure: k7702 
o|contracted procedure: k7709 
o|contracted procedure: k7715 
o|contracted procedure: k7721 
o|contracted procedure: k7733 
o|contracted procedure: k7752 
o|contracted procedure: k7773 
o|contracted procedure: k7769 
o|contracted procedure: k7763 
o|contracted procedure: k7784 
o|contracted procedure: k7819 
o|contracted procedure: k7800 
o|contracted procedure: k7804 
o|contracted procedure: k7808 
o|contracted procedure: k7948 
o|contracted procedure: k7864 
o|contracted procedure: k7942 
o|contracted procedure: k7867 
o|contracted procedure: k7936 
o|contracted procedure: k7870 
o|contracted procedure: k7930 
o|contracted procedure: k7873 
o|contracted procedure: k7897 
o|contracted procedure: k7900 
o|contracted procedure: k7924 
o|contracted procedure: k8008 
o|contracted procedure: k7957 
o|contracted procedure: k8002 
o|contracted procedure: k7960 
o|contracted procedure: k7996 
o|contracted procedure: k7963 
o|contracted procedure: k7990 
o|contracted procedure: k7966 
o|contracted procedure: k7978 
o|contracted procedure: k7984 
o|contracted procedure: k8018 
o|contracted procedure: k8046 
o|contracted procedure: k8024 
o|contracted procedure: k8059 
o|contracted procedure: k8068 
o|contracted procedure: k8071 
o|contracted procedure: k8077 
o|contracted procedure: k8083 
o|contracted procedure: k8135 
o|contracted procedure: k8138 
o|contracted procedure: k8161 
o|contracted procedure: k8188 
o|contracted procedure: k8167 
o|contracted procedure: k8219 
o|contracted procedure: k8231 
o|contracted procedure: k8148 
o|contracted procedure: k8250 
o|contracted procedure: k8367 
o|contracted procedure: k8371 
o|contracted procedure: k8375 
o|contracted procedure: k8336 
o|contracted procedure: k8382 
o|contracted procedure: k8399 
o|contracted procedure: k8409 
o|contracted procedure: k8413 
o|contracted procedure: k8416 
o|contracted procedure: k8490 
o|contracted procedure: k8451 
o|contracted procedure: k8484 
o|contracted procedure: k8454 
o|contracted procedure: k8478 
o|contracted procedure: k8457 
o|contracted procedure: k8472 
o|contracted procedure: k8460 
o|contracted procedure: k8532 
o|contracted procedure: k8499 
o|contracted procedure: k8526 
o|contracted procedure: k8502 
o|contracted procedure: k8520 
o|contracted procedure: k8505 
o|contracted procedure: k8514 
o|contracted procedure: k8508 
o|contracted procedure: k8554 
o|contracted procedure: k8560 
o|contracted procedure: k8549 
o|contracted procedure: k8571 
o|contracted procedure: k8577 
o|contracted procedure: k8583 
o|contracted procedure: k8595 
o|contracted procedure: k8598 
o|contracted procedure: k8604 
o|contracted procedure: k8623 
o|contracted procedure: k8642 
o|contracted procedure: k8661 
o|contracted procedure: k8680 
o|contracted procedure: k8702 
o|contracted procedure: k8705 
o|contracted procedure: k8714 
o|contracted procedure: k8727 
o|contracted procedure: k8752 
o|contracted procedure: k8736 
o|contracted procedure: k8739 
o|contracted procedure: k8761 
o|contracted procedure: k8773 
o|contracted procedure: k8789 
o|contracted procedure: k8785 
o|contracted procedure: k8795 
o|contracted procedure: k8810 
o|contracted procedure: k8832 
o|contracted procedure: k8823 
o|simplifications: ((if . 1) (let . 120)) 
o|removed binding forms: 574 
o|inlining procedure: k3929 
o|inlining procedure: k3950 
o|inlining procedure: "(posixunix.scm:616) mode1037" 
o|inlining procedure: "(posixunix.scm:627) mode1037" 
o|inlining procedure: k5989 
o|replaced variables: 301 
o|removed binding forms: 2 
o|inlining procedure: k5106 
o|inlining procedure: k5106 
o|inlining procedure: k5148 
o|inlining procedure: k5148 
o|removed side-effect free assignment to unused variable: mode1037 
o|inlining procedure: k5580 
o|inlining procedure: k5912 
o|inlining procedure: k5975 
o|substituted constant variable: r599010006 
o|substituted constant variable: r599010006 
o|replaced variables: 10 
o|removed binding forms: 154 
o|contracted procedure: k4631 
o|contracted procedure: k4871 
o|contracted procedure: k5909 
o|contracted procedure: k7479 
o|contracted procedure: k7546 
o|contracted procedure: k7829 
o|converted assignments to bindings: (check1039) 
o|simplifications: ((let . 3)) 
o|removed binding forms: 21 
o|contracted procedure: k5280 
o|contracted procedure: k5320 
o|replaced variables: 2 
o|removed binding forms: 2 
o|removed binding forms: 1 
o|direct leaf routine/allocation: doloop946947 0 
o|direct leaf routine/allocation: doloop928929 0 
o|direct leaf routine/allocation: for-each-loop11641176 0 
o|direct leaf routine/allocation: peek1483 0 
o|direct leaf routine/allocation: swapped-ends2030 3 
o|direct leaf routine/allocation: g20882095 0 
o|contracted procedure: k4848 
o|contracted procedure: k4851 
o|converted assignments to bindings: (doloop946947) 
o|converted assignments to bindings: (doloop928929) 
o|contracted procedure: k5558 
o|converted assignments to bindings: (for-each-loop11641176) 
o|contracted procedure: "(posixunix.scm:1177) k6544" 
o|contracted procedure: "(posixunix.scm:1680) k8270" 
o|contracted procedure: "(posixunix.scm:1685) k8293" 
o|contracted procedure: "(posixunix.scm:1684) k8297" 
o|contracted procedure: "(posixunix.scm:1721) k8402" 
o|simplifications: ((let . 3)) 
o|removed binding forms: 8 
o|direct leaf routine/allocation: for-each-loop20872105 0 
o|converted assignments to bindings: (for-each-loop20872105) 
o|simplifications: ((let . 1)) 
o|customizable procedures: (loop1185 %process2076 chkstrlst2083 output-port2029 make-on-close1992 input-port2028 spawn2027 connect-parent1994 needed-pipe1993 connect-child1995 k8105 k8065 call-with-exec-args ##sys#terminal-check k7680 k7692 k7533 k7473 k7358 setup1653 err1654 k7203 k7157 loop1622 k6975 k6700 k6619 loop1529 ready?1482 fetch1484 loop1426 check1373 doloop12971298 loop1289 k5789 loop1270 k5696 check1039 k4828 k4831 k4834 k5066 k5034 lp983 k4975 lp1002 k4916 k4765 k4655 list->c-string-buffer k4529 doloop702703 tmp12594 tmp22595 doloop683684 free-c-string-buffer scan628 loop625 check-time-vector k3681 k3684 loop450 g422423 loop414 conc-loop395 k3497 loop374 k3346 loop328 g289296 for-each-loop288305 rmdir282 k3171 mode204 check205 k2986 ##sys#stat) 
o|calls to known targets: 291 
o|unused rest argument: _446 f_3849 
o|unused rest argument: _445 f_3841 
o|unused rest argument: _486 f_3901 
o|identified direct recursive calls: f_4179 1 
o|identified direct recursive calls: f_5123 2 
o|identified direct recursive calls: f_5081 2 
o|identified direct recursive calls: f_5572 1 
o|identified direct recursive calls: f_5879 1 
o|identified direct recursive calls: f_5937 1 
o|identified direct recursive calls: f_6623 1 
o|identified direct recursive calls: f_7056 1 
o|identified direct recursive calls: f_8394 1 
o|identified direct recursive calls: f_8697 2 
o|fast box initializations: 26 
o|fast global references: 73 
o|fast global assignments: 7 
o|dropping unused closure argument: f_7756 
o|dropping unused closure argument: f_4440 
o|dropping unused closure argument: f_3908 
o|dropping unused closure argument: f_7248 
o|dropping unused closure argument: f_8157 
o|dropping unused closure argument: f_6116 
o|dropping unused closure argument: f_8194 
o|dropping unused closure argument: f_8378 
o|dropping unused closure argument: f_3233 
o|dropping unused closure argument: f_3038 
o|dropping unused closure argument: f_3075 
o|dropping unused closure argument: f_5260 
o|dropping unused closure argument: f_8241 
o|dropping unused closure argument: f_8214 
o|dropping unused closure argument: f_4321 
o|dropping unused closure argument: f_8226 
o|dropping unused closure argument: f_7184 
o|dropping unused closure argument: f_5572 
o|dropping unused closure argument: f_2722 
*/
/* end of file */
