/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.devtools.jsdoc.checks;

import com.google.javascript.rhino.head.ast.AstNode;
import com.google.javascript.rhino.head.ast.Comment;
import com.google.javascript.rhino.head.ast.FunctionNode;
import java.util.HashSet;
import java.util.Set;
import org.chromium.devtools.jsdoc.checks.AstUtil;
import org.chromium.devtools.jsdoc.checks.ContextTrackingChecker;
import org.chromium.devtools.jsdoc.checks.ContextTrackingState;
import org.chromium.devtools.jsdoc.checks.FunctionRecord;

public final class RequiredThisAnnotationChecker
extends ContextTrackingChecker {
    private final Set<FunctionRecord> functionsRequiringThisAnnotation = new HashSet<FunctionRecord>();

    @Override
    void enterNode(AstNode astNode) {
        if (astNode.getType() == 43) {
            FunctionRecord functionRecord = this.getState().getCurrentFunctionRecord();
            if (functionRecord == null) {
                return;
            }
            if (!functionRecord.isTopLevelFunction() && !functionRecord.isConstructor) {
                this.functionsRequiringThisAnnotation.add(functionRecord);
            }
            return;
        }
    }

    @Override
    void leaveNode(AstNode astNode) {
        if (astNode.getType() != 109) {
            return;
        }
        ContextTrackingState contextTrackingState = this.getState();
        FunctionRecord functionRecord = contextTrackingState.getCurrentFunctionRecord();
        if (!this.functionsRequiringThisAnnotation.contains(functionRecord)) {
            return;
        }
        FunctionNode functionNode = (FunctionNode)astNode;
        AstNode astNode2 = AstUtil.getFunctionNameNode(functionNode);
        if (astNode2 != null && this.shouldAddThisAnnotation(functionNode)) {
            contextTrackingState.getContext().reportErrorInNode(astNode2, 0, "@this annotation is required for functions referencing 'this'");
        }
    }

    private boolean shouldAddThisAnnotation(FunctionNode functionNode) {
        Comment comment = AstUtil.getJsDocNode(functionNode);
        return comment == null || !this.getContext().getNodeText(comment).contains("@this");
    }
}

