file(GLOB test_xml_file "${RunCMake_TEST_BINARY_DIR}/Testing/*/Test.xml")
if(test_xml_file)
  file(READ "${test_xml_file}" test_xml LIMIT 4096)
  if("${test_xml}" MATCHES [[(<Test Status="passed">.*</Test>).*(<Test Status="failed">.*</Test>)]])
    set(test_passed "${CMAKE_MATCH_1}")
    set(test_failed "${CMAKE_MATCH_2}")
    if(NOT "${test_passed}" MATCHES [[<Value>PassingTes\.\.\..*10 bytes]])
      set(RunCMake_TEST_FAILED "Test.xml passed test output not truncated at 10 bytes:\n ${test_passed}")
    elseif(NOT "${test_failed}" MATCHES [[<Value>CMake Error:\.\.\..*12 bytes]])
      set(RunCMake_TEST_FAILED "Test.xml failed test output not truncated at 12 bytes:\n ${test_failed}")
    endif()
  else()
    set(RunCMake_TEST_FAILED "Test.xml does not contain a passed then failed test:\n ${test_xml}")
  endif()
else()
  set(RunCMake_TEST_FAILED "Test.xml not found")
endif()
