/*
 * Copyright (C) 2003  Robert Collins  <robertc@squid-cache.org>
 * 
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 * DO NOT ALTER THE NEXT LINE
 * arch-tag: 9c80fac8-ffe4-4fc5-8930-60a8f7cbe09b
 * 
 */

#ifndef   _CM_CONFIGWGETSOURCE_H_
#define   _CM_CONFIGWGETSOURCE_H_

#include <stdexcept>
#include <getopt++/StringOption.h>
#include "ConfigSource.h"

class ConfigWGetSource : public ConfigSource
{

public:
  ConfigWGetSource(std::string const &url);
  virtual std::string url(bool const &) const;

    virtual void get
      (std::string const &) const throw (std::exception *);
    virtual void update (std::string const &) const throw(std::exception *);
  virtual int changes (std::string const &) const throw(std::exception *);
  virtual int missing (std::string const &) const throw(std::exception *);
  virtual void ignore (ConfigSource const *, std::string const &) const throw (std::exception *);

    virtual std::string treeVersion(std::string const &where) const;

private:
    std::string const theUrl;
    std::string decompress;
    std::string urlPart;
    std::string scheme;
};

#endif /* _CM_CONFIGWGETSOURCE_H_ */
