/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import net.sf.saxon.Configuration;
import net.sf.saxon.Err;
import net.sf.saxon.expr.BinaryExpression;
import net.sf.saxon.expr.ComputedExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.RoleLocator;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.Token;
import net.sf.saxon.expr.TypeChecker;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.Item;
import net.sf.saxon.trans.DynamicError;
import net.sf.saxon.trans.StaticError;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInSchemaFactory;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.Type;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.CalendarValue;
import net.sf.saxon.value.DoubleValue;
import net.sf.saxon.value.DurationValue;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.NumericValue;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.UntypedAtomicValue;
import net.sf.saxon.value.Value;

public class ArithmeticExpression
extends BinaryExpression {
    private static final int NUMERIC_ARITHMETIC = 0;
    private static final int DATE_AND_DURATION = 1;
    private static final int DATE_DIFFERENCE = 2;
    private static final int DURATION_ADDITION = 3;
    private static final int DURATION_MULTIPLICATION = 4;
    private static final int DURATION_DIVISION = 5;
    private static final int UNKNOWN = -1;
    private static final int UNKNOWN_10 = -2;
    private static final Signature[] plusTable = new Signature[]{new Signature(646, 646, 0, Type.NUMBER_TYPE), new Signature(646, 642, 0, Type.NUMBER_TYPE), new Signature(642, 646, 0, Type.NUMBER_TYPE), new Signature(642, 642, 0, Type.NUMBER_TYPE), new Signature(521, 518, 1, Type.DATE_TYPE), new Signature(518, 521, 1, Type.DATE_TYPE), new Signature(520, 518, 1, Type.TIME_TYPE), new Signature(518, 520, 1, Type.TIME_TYPE), new Signature(519, 518, 1, Type.DATE_TIME_TYPE), new Signature(518, 519, 1, Type.DATE_TIME_TYPE), new Signature(518, 518, 3, Type.DURATION_TYPE)};
    private static final Signature[] minusTable = new Signature[]{new Signature(646, 646, 0, Type.NUMBER_TYPE), new Signature(646, 642, 0, Type.NUMBER_TYPE), new Signature(642, 646, 0, Type.NUMBER_TYPE), new Signature(642, 642, 0, Type.NUMBER_TYPE), new Signature(521, 521, 2, Type.DAY_TIME_DURATION_TYPE), new Signature(521, 518, 1, Type.DATE_TYPE), new Signature(520, 520, 2, Type.DAY_TIME_DURATION_TYPE), new Signature(520, 518, 1, Type.TIME_TYPE), new Signature(519, 519, 2, Type.DAY_TIME_DURATION_TYPE), new Signature(519, 518, 1, Type.DATE_TIME_TYPE), new Signature(518, 518, 3, Type.DURATION_TYPE)};
    private static final Signature[] multiplyTable = new Signature[]{new Signature(646, 646, 0, Type.NUMBER_TYPE), new Signature(646, 642, 0, Type.NUMBER_TYPE), new Signature(642, 646, 0, Type.NUMBER_TYPE), new Signature(642, 642, 0, Type.NUMBER_TYPE), new Signature(646, 518, 4, Type.DURATION_TYPE), new Signature(518, 646, 4, Type.DURATION_TYPE)};
    private static final Signature[] divideTable = new Signature[]{new Signature(646, 646, 0, Type.NUMBER_TYPE), new Signature(646, 642, 0, Type.NUMBER_TYPE), new Signature(642, 646, 0, Type.NUMBER_TYPE), new Signature(642, 642, 0, Type.NUMBER_TYPE), new Signature(518, 646, 4, Type.DURATION_TYPE), new Signature(518, 518, 5, Type.NUMBER_TYPE)};
    private static final Signature[] idivTable = new Signature[]{new Signature(646, 646, 0, Type.INTEGER_TYPE), new Signature(646, 642, 0, Type.INTEGER_TYPE), new Signature(642, 646, 0, Type.INTEGER_TYPE), new Signature(642, 642, 0, Type.INTEGER_TYPE)};
    private static final Signature[] modTable = new Signature[]{new Signature(646, 646, 0, Type.NUMBER_TYPE), new Signature(646, 642, 0, Type.NUMBER_TYPE), new Signature(642, 646, 0, Type.NUMBER_TYPE), new Signature(642, 642, 0, Type.NUMBER_TYPE)};
    private boolean backwardsCompatible = false;

    public ArithmeticExpression(Expression expression, int n, Expression expression2) {
        super(expression, n, expression2);
    }

    public Expression typeCheck(StaticContext staticContext, ItemType itemType) throws XPathException {
        TypeHierarchy typeHierarchy = staticContext.getConfiguration().getTypeHierarchy();
        this.backwardsCompatible = staticContext.isInBackwardsCompatibleMode();
        Expression expression = this.operand0;
        Expression expression2 = this.operand1;
        this.operand0 = this.operand0.typeCheck(staticContext, itemType);
        this.operand1 = this.operand1.typeCheck(staticContext, itemType);
        SequenceType sequenceType = SequenceType.OPTIONAL_ATOMIC;
        RoleLocator roleLocator = new RoleLocator(1, Token.tokens[this.operator], 0, null);
        roleLocator.setSourceLocator(this);
        this.operand0 = TypeChecker.staticTypeCheck(this.operand0, sequenceType, this.backwardsCompatible, roleLocator, staticContext);
        RoleLocator roleLocator2 = new RoleLocator(1, Token.tokens[this.operator], 1, null);
        roleLocator2.setSourceLocator(this);
        this.operand1 = TypeChecker.staticTypeCheck(this.operand1, sequenceType, this.backwardsCompatible, roleLocator2, staticContext);
        if (this.operand0 != expression) {
            this.adoptChildExpression(this.operand0);
        }
        if (this.operand1 != expression2) {
            this.adoptChildExpression(this.operand1);
        }
        if (this.backwardsCompatible) {
            if (this.operand0.getCardinality() == 8192 || this.operand1.getCardinality() == 8192) {
                return DoubleValue.NaN;
            }
            Arithmetic10 arithmetic10 = new Arithmetic10(this.operand0, this.operator, this.operand1);
            arithmetic10.setParentExpression(this.getParentExpression());
            ExpressionTool.copyLocationInfo(this, arithmetic10);
            return arithmetic10.simplify(staticContext).typeCheck(staticContext, itemType);
        }
        if (this.operand0.getCardinality() == 8192 || this.operand1.getCardinality() == 8192) {
            return EmptySequence.getInstance();
        }
        Expression expression3 = super.typeCheck(staticContext, itemType);
        if (expression3 instanceof ArithmeticExpression) {
            int n = this.operand0.getItemType(typeHierarchy).getPrimitiveType();
            int n2 = this.operand1.getItemType(typeHierarchy).getPrimitiveType();
            int n3 = ArithmeticExpression.getAction(n, this.operator, n2, false);
            switch (n3) {
                case 0: {
                    expression3 = new NumericArithmetic(this.operand0, this.operator, this.operand1);
                    break;
                }
                case 3: {
                    expression3 = new DurationAddition(this.operand0, this.operator, this.operand1);
                    break;
                }
                case 4: {
                    expression3 = new DurationMultiplication(this.operand0, this.operator, this.operand1, staticContext.getConfiguration());
                    break;
                }
                case 5: {
                    expression3 = new DurationDivision(this.operand0, this.operator, this.operand1);
                    break;
                }
                case 1: {
                    expression3 = new DateAndDuration(this.operand0, this.operator, this.operand1, staticContext.getConfiguration());
                    break;
                }
                case 2: {
                    expression3 = new DateDifference(this.operand0, this.operator, this.operand1);
                    break;
                }
                case -2: {
                    expression3 = new Arithmetic10(this.operand0, this.operator, this.operand1);
                    break;
                }
                case -1: {
                    if (staticContext.getConfiguration().getSchemaType(n).isAtomicType() && n != 642 && n != 643 && staticContext.getConfiguration().getSchemaType(n2).isAtomicType() && n2 != 642 && n2 != 643) {
                        StaticError staticError = new StaticError("Unsuitable operands for arithmetic operation (" + staticContext.getNamePool().getDisplayName(n) + ", " + staticContext.getNamePool().getDisplayName(n2) + ')');
                        staticError.setErrorCode("XPTY0004");
                        staticError.setIsTypeError(true);
                        staticError.setLocator(ExpressionTool.getLocator(this));
                        throw staticError;
                    }
                    return expression3;
                }
            }
            ExpressionTool.copyLocationInfo(this, expression3);
            ComputedExpression.setParentExpression(expression3, this.getParentExpression());
        }
        return expression3;
    }

    private static int getAction(int n, int n2, int n3, boolean bl) {
        Signature[] signatureArray;
        int n4;
        if (n == 645 || n == 644) {
            n = 518;
        }
        if (n3 == 645 || n3 == 644) {
            n3 = 518;
        }
        if ((n4 = ArithmeticExpression.getEntry(signatureArray = ArithmeticExpression.getOperatorTable(n2), n, n3)) < 0) {
            return bl ? -2 : -1;
        }
        return signatureArray[n4].operation;
    }

    private static Signature[] getOperatorTable(int n) {
        switch (n) {
            case 15: {
                return plusTable;
            }
            case 16: 
            case 199: {
                return minusTable;
            }
            case 17: {
                return multiplyTable;
            }
            case 18: {
                return divideTable;
            }
            case 50: {
                return idivTable;
            }
            case 19: {
                return modTable;
            }
        }
        throw new IllegalArgumentException("Unknown arithmetic operator");
    }

    private static int getEntry(Signature[] signatureArray, int n, int n2) {
        if (Type.isNumericPrimitiveType(n)) {
            n = 646;
        }
        if (Type.isNumericPrimitiveType(n2)) {
            n2 = 646;
        }
        for (int i = 0; i < signatureArray.length; ++i) {
            if (n != signatureArray[i].operand0 || n2 != signatureArray[i].operand1) continue;
            return i;
        }
        return -1;
    }

    public ItemType getItemType(TypeHierarchy typeHierarchy) {
        ItemType itemType = this.operand0.getItemType(typeHierarchy);
        int n = itemType.getPrimitiveType();
        ItemType itemType2 = this.operand1.getItemType(typeHierarchy);
        int n2 = itemType2.getPrimitiveType();
        Signature[] signatureArray = ArithmeticExpression.getOperatorTable(this.operator);
        int n3 = ArithmeticExpression.getEntry(signatureArray, n, n2);
        if (n3 < 0) {
            return Type.ANY_ATOMIC_TYPE;
        }
        ItemType itemType3 = signatureArray[n3].resultType;
        if (itemType3 == Type.NUMBER_TYPE) {
            AtomicType atomicType = (AtomicType)BuiltInSchemaFactory.getSchemaType(n);
            AtomicType atomicType2 = (AtomicType)BuiltInSchemaFactory.getSchemaType(n2);
            itemType3 = NumericValue.promote(atomicType, atomicType2, typeHierarchy);
            itemType3 = this.operator == 18 && itemType3 == Type.INTEGER_TYPE ? Type.DECIMAL_TYPE : NumericValue.promote(atomicType, atomicType2, typeHierarchy);
        } else if (itemType3 == Type.DURATION_TYPE) {
            if (typeHierarchy.isSubType(itemType, Type.DAY_TIME_DURATION_TYPE)) {
                itemType3 = Type.DAY_TIME_DURATION_TYPE;
            } else if (typeHierarchy.isSubType(itemType2, Type.DAY_TIME_DURATION_TYPE)) {
                itemType3 = Type.DAY_TIME_DURATION_TYPE;
            } else if (typeHierarchy.isSubType(itemType, Type.YEAR_MONTH_DURATION_TYPE)) {
                itemType3 = Type.YEAR_MONTH_DURATION_TYPE;
            } else if (typeHierarchy.isSubType(itemType2, Type.YEAR_MONTH_DURATION_TYPE)) {
                itemType3 = Type.YEAR_MONTH_DURATION_TYPE;
            }
        }
        return itemType3;
    }

    public Item evaluateItem(XPathContext xPathContext) throws XPathException {
        ArithmeticExpression arithmeticExpression;
        AtomicValue atomicValue = (AtomicValue)this.operand0.evaluateItem(xPathContext);
        if (atomicValue == null) {
            return null;
        }
        atomicValue = atomicValue.getPrimitiveValue();
        AtomicValue atomicValue2 = (AtomicValue)this.operand1.evaluateItem(xPathContext);
        if (atomicValue2 == null) {
            return null;
        }
        atomicValue2 = atomicValue2.getPrimitiveValue();
        Configuration configuration = xPathContext.getConfiguration();
        TypeHierarchy typeHierarchy = configuration.getTypeHierarchy();
        int n = ArithmeticExpression.getAction(atomicValue.getItemType(typeHierarchy).getPrimitiveType(), this.operator, atomicValue2.getItemType(typeHierarchy).getPrimitiveType(), this.backwardsCompatible);
        switch (n) {
            case 0: {
                arithmeticExpression = new NumericArithmetic(atomicValue, this.operator, atomicValue2);
                break;
            }
            case 3: {
                arithmeticExpression = new DurationAddition(atomicValue, this.operator, atomicValue2);
                break;
            }
            case 4: {
                arithmeticExpression = new DurationMultiplication(atomicValue, this.operator, atomicValue2, configuration);
                break;
            }
            case 5: {
                arithmeticExpression = new DurationDivision(atomicValue, this.operator, atomicValue2);
                break;
            }
            case 1: {
                arithmeticExpression = new DateAndDuration(atomicValue, this.operator, atomicValue2, configuration);
                break;
            }
            case 2: {
                arithmeticExpression = new DateDifference(atomicValue, this.operator, atomicValue2);
                break;
            }
            default: {
                if (this.backwardsCompatible) {
                    NumericValue numericValue;
                    NumericValue numericValue2;
                    try {
                        numericValue2 = (NumericValue)atomicValue.convert(517, xPathContext);
                        numericValue = (NumericValue)atomicValue2.convert(517, xPathContext);
                    }
                    catch (XPathException xPathException) {
                        this.typeError("Unsuitable operands for arithmetic operation (" + atomicValue.getItemType(typeHierarchy) + ", " + atomicValue2.getItemType(typeHierarchy) + ')', "XPTY0004", xPathContext);
                        return null;
                    }
                    arithmeticExpression = new NumericArithmetic(numericValue2, this.operator, numericValue);
                    break;
                }
                this.typeError("Unsuitable operands for arithmetic operation (" + atomicValue.getItemType(typeHierarchy) + ", " + atomicValue2.getItemType(typeHierarchy) + ')', "XPTY0004", xPathContext);
                return null;
            }
        }
        ExpressionTool.copyLocationInfo(this, arithmeticExpression);
        ComputedExpression.setParentExpression(arithmeticExpression, this.getParentExpression());
        return arithmeticExpression.evaluateItem(xPathContext);
    }

    public static class DateDifference
    extends ArithmeticExpression {
        public DateDifference(Expression expression, int n, Expression expression2) {
            super(expression, n, expression2);
        }

        public Item evaluateItem(XPathContext xPathContext) throws XPathException {
            try {
                return DateDifference.doArithmetic(this.operand0, this.operand1, xPathContext);
            }
            catch (XPathException xPathException) {
                if (xPathException.getLocator() == null) {
                    xPathException.setLocator(this);
                }
                throw xPathException;
            }
        }

        public static Item doArithmetic(Expression expression, Expression expression2, XPathContext xPathContext) throws XPathException {
            AtomicValue atomicValue = (AtomicValue)expression.evaluateItem(xPathContext);
            if (atomicValue == null) {
                return null;
            }
            CalendarValue calendarValue = (CalendarValue)atomicValue.getPrimitiveValue();
            AtomicValue atomicValue2 = (AtomicValue)expression2.evaluateItem(xPathContext);
            if (atomicValue2 == null) {
                return null;
            }
            CalendarValue calendarValue2 = (CalendarValue)atomicValue2.getPrimitiveValue();
            return calendarValue.subtract(calendarValue2, xPathContext);
        }
    }

    public static class DateAndDuration
    extends ArithmeticExpression {
        public DateAndDuration(Expression expression, int n, Expression expression2, Configuration configuration) {
            super(expression, n, expression2);
            TypeHierarchy typeHierarchy = configuration.getTypeHierarchy();
            if (typeHierarchy.isSubType(expression.getItemType(typeHierarchy), Type.DURATION_TYPE)) {
                this.operand0 = expression2;
                this.operand1 = expression;
            }
        }

        public Item evaluateItem(XPathContext xPathContext) throws XPathException {
            try {
                return DateAndDuration.doArithmetic(this.operand0, this.operator, this.operand1, xPathContext);
            }
            catch (XPathException xPathException) {
                if (xPathException.getLocator() == null) {
                    xPathException.setLocator(this);
                }
                throw xPathException;
            }
        }

        public static Item doArithmetic(Expression expression, int n, Expression expression2, XPathContext xPathContext) throws XPathException {
            AtomicValue atomicValue = (AtomicValue)expression.evaluateItem(xPathContext);
            if (atomicValue == null) {
                return null;
            }
            CalendarValue calendarValue = (CalendarValue)atomicValue.getPrimitiveValue();
            AtomicValue atomicValue2 = (AtomicValue)expression2.evaluateItem(xPathContext);
            if (atomicValue2 == null) {
                return null;
            }
            DurationValue durationValue = (DurationValue)atomicValue2.getPrimitiveValue();
            if (n == 16) {
                durationValue = durationValue.multiply(-1.0);
            }
            return calendarValue.add(durationValue);
        }
    }

    public static class DurationDivision
    extends ArithmeticExpression {
        public DurationDivision(Expression expression, int n, Expression expression2) {
            super(expression, n, expression2);
        }

        public Item evaluateItem(XPathContext xPathContext) throws XPathException {
            try {
                return DurationDivision.doArithmetic(this.operand0, this.operand1, xPathContext);
            }
            catch (XPathException xPathException) {
                if (xPathException.getLocator() == null) {
                    xPathException.setLocator(this);
                }
                throw xPathException;
            }
        }

        public static Item doArithmetic(Expression expression, Expression expression2, XPathContext xPathContext) throws XPathException {
            AtomicValue atomicValue = (AtomicValue)expression.evaluateItem(xPathContext);
            if (atomicValue == null) {
                return null;
            }
            DurationValue durationValue = (DurationValue)atomicValue.getPrimitiveValue();
            AtomicValue atomicValue2 = (AtomicValue)expression2.evaluateItem(xPathContext);
            if (atomicValue2 == null) {
                return null;
            }
            DurationValue durationValue2 = (DurationValue)atomicValue2.getPrimitiveValue();
            return durationValue.divide(durationValue2);
        }
    }

    public static class DurationMultiplication
    extends ArithmeticExpression {
        public DurationMultiplication(Expression expression, int n, Expression expression2, Configuration configuration) {
            super(expression, n, expression2);
            TypeHierarchy typeHierarchy = configuration.getTypeHierarchy();
            if (typeHierarchy.isSubType(expression2.getItemType(typeHierarchy), Type.DURATION_TYPE)) {
                this.operand0 = expression2;
                this.operand1 = expression;
            }
        }

        public Item evaluateItem(XPathContext xPathContext) throws XPathException {
            try {
                return DurationMultiplication.doArithmetic(this.operand0, this.operator, this.operand1, xPathContext);
            }
            catch (XPathException xPathException) {
                if (xPathException.getLocator() == null) {
                    xPathException.setLocator(this);
                }
                throw xPathException;
            }
        }

        public static Item doArithmetic(Expression expression, int n, Expression expression2, XPathContext xPathContext) throws XPathException {
            AtomicValue atomicValue = (AtomicValue)expression.evaluateItem(xPathContext);
            if (atomicValue == null) {
                return null;
            }
            DurationValue durationValue = (DurationValue)atomicValue.getPrimitiveValue();
            AtomicValue atomicValue2 = (AtomicValue)expression2.evaluateItem(xPathContext);
            if (atomicValue2 == null) {
                return null;
            }
            NumericValue numericValue = (NumericValue)atomicValue2.getPrimitiveValue();
            double d = numericValue.getDoubleValue();
            if (n == 18) {
                d = 1.0 / d;
            }
            return durationValue.multiply(d);
        }
    }

    public static class DurationAddition
    extends ArithmeticExpression {
        public DurationAddition(Expression expression, int n, Expression expression2) {
            super(expression, n, expression2);
        }

        public Item evaluateItem(XPathContext xPathContext) throws XPathException {
            try {
                return DurationAddition.doArithmetic(this.operand0, this.operator, this.operand1, xPathContext);
            }
            catch (XPathException xPathException) {
                if (xPathException.getLocator() == null) {
                    xPathException.setLocator(this);
                }
                throw xPathException;
            }
        }

        public static Item doArithmetic(Expression expression, int n, Expression expression2, XPathContext xPathContext) throws XPathException {
            AtomicValue atomicValue = (AtomicValue)expression.evaluateItem(xPathContext);
            if (atomicValue == null) {
                return null;
            }
            DurationValue durationValue = (DurationValue)atomicValue.getPrimitiveValue();
            AtomicValue atomicValue2 = (AtomicValue)expression2.evaluateItem(xPathContext);
            if (atomicValue2 == null) {
                return null;
            }
            DurationValue durationValue2 = (DurationValue)atomicValue2.getPrimitiveValue();
            if (n == 15) {
                return durationValue.add(durationValue2);
            }
            if (n == 16) {
                return durationValue.subtract(durationValue2);
            }
            throw new AssertionError((Object)"Unknown operation on durations");
        }
    }

    public static class NumericArithmetic
    extends ArithmeticExpression {
        boolean backCompatible = false;

        public NumericArithmetic(Expression expression, int n, Expression expression2) {
            super(expression, n, expression2);
        }

        public void setBackwardsCompatible(boolean bl) {
            this.backCompatible = bl;
        }

        public boolean isBackwardsCompatible() {
            return this.backCompatible;
        }

        public Item evaluateItem(XPathContext xPathContext) throws XPathException {
            try {
                return NumericArithmetic.doArithmetic(this.operand0, this.operator, this.operand1, xPathContext, this.backCompatible);
            }
            catch (XPathException xPathException) {
                if (xPathException.getLocator() == null) {
                    xPathException.setLocator(this);
                }
                throw xPathException;
            }
        }

        public static Item doArithmetic(Expression expression, int n, Expression expression2, XPathContext xPathContext, boolean bl) throws XPathException {
            AtomicValue atomicValue = (AtomicValue)expression.evaluateItem(xPathContext);
            if (atomicValue == null) {
                return bl ? DoubleValue.NaN : null;
            }
            if (atomicValue instanceof UntypedAtomicValue) {
                try {
                    atomicValue = new DoubleValue(Value.stringToNumber(atomicValue.getStringValueCS()));
                }
                catch (NumberFormatException numberFormatException) {
                    if (bl) {
                        atomicValue = DoubleValue.NaN;
                    }
                    DynamicError dynamicError = new DynamicError("Failure converting untyped value " + Err.wrap(atomicValue.getStringValueCS(), 4) + " to a number");
                    dynamicError.setErrorCode("FORG0001");
                    dynamicError.setXPathContext(xPathContext);
                    throw dynamicError;
                }
            } else {
                atomicValue = atomicValue.getPrimitiveValue();
            }
            AtomicValue atomicValue2 = (AtomicValue)expression2.evaluateItem(xPathContext);
            if (atomicValue2 == null) {
                return bl ? DoubleValue.NaN : null;
            }
            if (atomicValue2 instanceof UntypedAtomicValue) {
                try {
                    atomicValue2 = new DoubleValue(Value.stringToNumber(atomicValue2.getStringValueCS()));
                }
                catch (NumberFormatException numberFormatException) {
                    if (bl) {
                        atomicValue2 = DoubleValue.NaN;
                    }
                    DynamicError dynamicError = new DynamicError("Failure converting untyped value " + Err.wrap(atomicValue2.getStringValueCS(), 4) + " to a number");
                    dynamicError.setErrorCode("FORG0001");
                    dynamicError.setXPathContext(xPathContext);
                    throw dynamicError;
                }
            } else {
                atomicValue2 = atomicValue2.getPrimitiveValue();
            }
            if (n == 199) {
                return ((NumericValue)atomicValue2).negate();
            }
            try {
                return ((NumericValue)atomicValue).arithmetic(n, (NumericValue)atomicValue2, xPathContext);
            }
            catch (DynamicError dynamicError) {
                if (dynamicError.getXPathContext() == null) {
                    dynamicError.setXPathContext(xPathContext);
                }
                throw dynamicError;
            }
            catch (ArithmeticException arithmeticException) {
                DynamicError dynamicError = new DynamicError("Arithmetic exception: " + arithmeticException.getMessage());
                dynamicError.setXPathContext(xPathContext);
                throw dynamicError;
            }
        }
    }

    private static class Arithmetic10
    extends BinaryExpression {
        public Arithmetic10(Expression expression, int n, Expression expression2) {
            super(expression, n, expression2);
        }

        public Expression typeCheck(StaticContext staticContext, ItemType itemType) throws XPathException {
            TypeHierarchy typeHierarchy = staticContext.getConfiguration().getTypeHierarchy();
            SequenceType sequenceType = SequenceType.OPTIONAL_ATOMIC;
            RoleLocator roleLocator = new RoleLocator(1, Token.tokens[this.operator], 0, null);
            roleLocator.setSourceLocator(this);
            this.operand0 = TypeChecker.staticTypeCheck(this.operand0, sequenceType, true, roleLocator, staticContext);
            RoleLocator roleLocator2 = new RoleLocator(1, Token.tokens[this.operator], 1, null);
            roleLocator2.setSourceLocator(this);
            this.operand1 = TypeChecker.staticTypeCheck(this.operand1, sequenceType, true, roleLocator2, staticContext);
            Expression expression = super.typeCheck(staticContext, itemType);
            if (expression instanceof ArithmeticExpression) {
                int n = this.operand0.getItemType(typeHierarchy).getPrimitiveType();
                int n2 = this.operand1.getItemType(typeHierarchy).getPrimitiveType();
                if (n == 514) {
                    n = 646;
                } else if (n == 513) {
                    n = 646;
                }
                if (n2 == 514) {
                    n2 = 646;
                } else if (n2 == 513) {
                    n2 = 646;
                }
                int n3 = ArithmeticExpression.getAction(n, this.operator, n2, true);
                switch (n3) {
                    case 0: {
                        expression = new NumericArithmetic(this.operand0, this.operator, this.operand1);
                        ((NumericArithmetic)expression).setBackwardsCompatible(true);
                        break;
                    }
                    case 3: {
                        expression = new DurationAddition(this.operand0, this.operator, this.operand1);
                        break;
                    }
                    case 4: {
                        expression = new DurationMultiplication(this.operand0, this.operator, this.operand1, staticContext.getConfiguration());
                        break;
                    }
                    case 5: {
                        expression = new DurationDivision(this.operand0, this.operator, this.operand1);
                        break;
                    }
                    case 1: {
                        expression = new DateAndDuration(this.operand0, this.operator, this.operand1, staticContext.getConfiguration());
                        break;
                    }
                    case 2: {
                        expression = new DateDifference(this.operand0, this.operator, this.operand1);
                        break;
                    }
                    case -2: {
                        break;
                    }
                    case -1: {
                        if (staticContext.getConfiguration().getSchemaType(n).isAtomicType() && n != 642 && n != 643 && staticContext.getConfiguration().getSchemaType(n2).isAtomicType() && n2 != 642 && n2 != 643) {
                            StaticError staticError = new StaticError("Unsuitable operands for arithmetic operation (" + staticContext.getNamePool().getDisplayName(n) + ", " + staticContext.getNamePool().getDisplayName(n2) + ')');
                            staticError.setErrorCode("XPTY0004");
                            staticError.setIsTypeError(true);
                            throw staticError;
                        }
                        return expression;
                    }
                }
                ExpressionTool.copyLocationInfo(this, expression);
                ComputedExpression.setParentExpression(expression, this.getParentExpression());
            }
            return expression;
        }

        public ItemType getItemType(TypeHierarchy typeHierarchy) {
            return Type.ANY_ATOMIC_TYPE;
        }

        public Item evaluateItem(XPathContext xPathContext) throws XPathException {
            AtomicValue atomicValue;
            AtomicValue atomicValue2 = (AtomicValue)this.operand0.evaluateItem(xPathContext);
            if (atomicValue2 == null) {
                return DoubleValue.NaN;
            }
            if ((atomicValue2 = atomicValue2.getPrimitiveValue()) instanceof BooleanValue || atomicValue2 instanceof StringValue || atomicValue2 instanceof NumericValue) {
                try {
                    atomicValue2 = atomicValue2.convert(517, xPathContext);
                }
                catch (XPathException xPathException) {
                    return DoubleValue.NaN;
                }
            }
            if ((atomicValue = (AtomicValue)this.operand1.evaluateItem(xPathContext)) == null) {
                return DoubleValue.NaN;
            }
            if ((atomicValue = atomicValue.getPrimitiveValue()) instanceof BooleanValue || atomicValue instanceof StringValue || atomicValue instanceof NumericValue) {
                try {
                    atomicValue = atomicValue.convert(517, xPathContext);
                }
                catch (XPathException xPathException) {
                    return DoubleValue.NaN;
                }
            }
            TypeHierarchy typeHierarchy = xPathContext.getConfiguration().getTypeHierarchy();
            int n = ArithmeticExpression.getAction(atomicValue2.getItemType(typeHierarchy).getPrimitiveType(), this.operator, atomicValue.getItemType(typeHierarchy).getPrimitiveType(), true);
            switch (n) {
                case 0: {
                    try {
                        return NumericArithmetic.doArithmetic(atomicValue2, this.operator, atomicValue, xPathContext, true);
                    }
                    catch (XPathException xPathException) {
                        if (xPathException.getLocator() == null) {
                            xPathException.setLocator(this);
                        }
                        throw xPathException;
                    }
                }
                case 3: {
                    try {
                        return DurationAddition.doArithmetic(atomicValue2, this.operator, atomicValue, xPathContext);
                    }
                    catch (XPathException xPathException) {
                        if (xPathException.getLocator() == null) {
                            xPathException.setLocator(this);
                        }
                        throw xPathException;
                    }
                }
                case 4: {
                    try {
                        return DurationMultiplication.doArithmetic(atomicValue2, this.operator, atomicValue, xPathContext);
                    }
                    catch (XPathException xPathException) {
                        if (xPathException.getLocator() == null) {
                            xPathException.setLocator(this);
                        }
                        throw xPathException;
                    }
                }
                case 5: {
                    try {
                        return DurationDivision.doArithmetic(atomicValue2, atomicValue, xPathContext);
                    }
                    catch (XPathException xPathException) {
                        if (xPathException.getLocator() == null) {
                            xPathException.setLocator(this);
                        }
                        throw xPathException;
                    }
                }
                case 1: {
                    try {
                        return DateAndDuration.doArithmetic(atomicValue2, this.operator, atomicValue, xPathContext);
                    }
                    catch (XPathException xPathException) {
                        if (xPathException.getLocator() == null) {
                            xPathException.setLocator(this);
                        }
                        throw xPathException;
                    }
                }
                case 2: {
                    try {
                        return DateDifference.doArithmetic(atomicValue2, atomicValue, xPathContext);
                    }
                    catch (XPathException xPathException) {
                        if (xPathException.getLocator() == null) {
                            xPathException.setLocator(this);
                        }
                        throw xPathException;
                    }
                }
            }
            this.typeError("Unsuitable operands for arithmetic operation (" + atomicValue2.getItemType(typeHierarchy) + ", " + atomicValue.getItemType(typeHierarchy) + ')', "XPTY0004", xPathContext);
            return null;
        }
    }

    private static final class Signature {
        int operand0;
        int operand1;
        int operation;
        ItemType resultType;

        Signature(int n, int n2, int n3, ItemType itemType) {
            this.operand0 = n;
            this.operand1 = n2;
            this.operation = n3;
            this.resultType = itemType;
        }
    }
}

