#include "log.h"
#include "markpool.h"
#include "mutexlock.h"
#include <stdio.h>
#include <assert.h>
#include <pthread.h>
#include <queue>

MarkPool::MarkPool(int start, int end)
	: start(start), end(end)
{
	assert(start > 0 && start < 65536);
	assert(end > 0 && end < 65536);

	for (int i = start; i < end; ++i) {
		free_marks.push(i);
	}

	pthread_mutex_init(&mutex, NULL);
}

int MarkPool::get_mark()
{
	MutexLock lock(&mutex);
	if (free_marks.empty()) {
		log(WARNING, "Out of free marks in mark pool %d-%d, session will not be marked. "
		             "To fix, increase the pool size and HUP the server.",
			     start, end);
		return 0;
	}
	int mark = free_marks.front();
	free_marks.pop();
	return mark;
}

void MarkPool::release_mark(int mark)
{
	if (mark == 0) {
		return;
	}

	MutexLock lock(&mutex);
	free_marks.push(mark);
}
